/**
 * Ultimate Video Player PACKAGED v9.1
 * Advertisement button.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
var FWDUVPAdsButton = function(
            prt,
            icon_img,
            iconOverPath_str,
            text_str,
            position_str,
            borderColorN_str,
            borderColorS_str,
            adsBackgroundPath_str,
            textNormalColor,
            textSelectedColor,
            useHEX,
            nBC,
            sBC
        ){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPAdsButton.prototype;
        
        
        _s.icon_img = icon_img;
        
        _s.useHEX = useHEX; 
        _s.nBC = nBC;
        _s.sBC = sBC;
        
        _s.borderNColor_str = borderColorN_str;
        _s.borderSColor_str = borderColorS_str;
        _s.adsBackgroundPath_str = adsBackgroundPath_str;
        _s.position_str = position_str;
        _s.textNormalColor_str = textNormalColor;
        _s.textSelectedColor_str = textSelectedColor;
        _s.text_str = text_str;
        _s.iconOverPath_str = iconOverPath_str;
        _s.totalWidth = 215;
        _s.totalHeight = 64;
        _s.fontSize = 12;
        
        _s.isMbl = FWDUVPUtils.isMobile;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
        

    
        //##########################################//
        /* initialize */
        //##########################################//
        _s.init = function(){
            _s.setOverflow("visible");
            _s.setupMainContainers();
            _s.hide(false, true);
        };
        

        //##########################################//
        /* setup main containers */
        //##########################################//
        _s.setupMainContainers = function(){
            
            _s.main_do = new FWDUVPDisplayObject("div");
            _s.main_do.hasTransform3d_bl = false;
            _s.main_do.hasTransform2d_bl = false;
            _s.main_do.setBackfaceVisibility();
            
            _s.bk_do = new FWDUVPDisplayObject("div");
            _s.bk_do.getStyle().background = "url('" + _s.adsBackgroundPath_str + "')";
        
            _s.text_do = new FWDUVPDisplayObject("div");
            _s.text_do.screen.className = 'UVP-skip';
            _s.text_do.hasTransform3d_bl = false;
            _s.text_do.hasTransform2d_bl = false;
            _s.text_do.setBackfaceVisibility();
            _s.text_do.setOverflow("visible");
            _s.text_do.getStyle().display = "inline";
            _s.text_do.getStyle().fontFamily = "Arial";
            _s.text_do.getStyle().fontSize= "22px";
            _s.text_do.getStyle().whiteSpace= "nowrap";
            _s.text_do.getStyle().color = _s.textNormalColor_str;
            _s.text_do.getStyle().fontSmoothing = "antialiased";
            _s.text_do.getStyle().webkitFontSmoothing = "antialiased";
            _s.text_do.getStyle().textRendering = "optimizeLegibility";
            
            _s.thumbHolder_do = new FWDUVPDisplayObject("div");
            _s.thumbHolder_do.setWidth(_s.totalHeight - 8);
            _s.thumbHolder_do.setHeight(_s.totalHeight - 8);
            _s.thumbHolder_do.setX(_s.totalWidth - _s.thumbHolder_do.w - 4);
            _s.thumbHolder_do.setY(4);
            
            _s.border_do = new FWDUVPDisplayObject("div");
            _s.border_do.getStyle().border = "1px solid " + _s.borderNColor_str + "";
            _s.border_do.setButtonMode(true);
            _s.main_do.setWidth(_s.totalWidth);
            _s.main_do.setHeight(_s.totalHeight);
            _s.bk_do.setWidth(_s.totalWidth);
            _s.bk_do.setHeight(_s.totalHeight);

            if(_s.position_str == "left"){
                _s.border_do.setX(-1);
                _s.border_do.setWidth(_s.totalWidth - 1);
                _s.border_do.setHeight(_s.totalHeight -2);
            }else{
                _s.border_do.setWidth(_s.totalWidth);
                _s.border_do.setHeight(_s.totalHeight -2);
            }
            _s.setWidth(_s.totalWidth);
            _s.setHeight(_s.totalHeight);
            
            if(_s.useHEX){
                _s.icon_do = new FWDUVPDisplayObject("div");
                _s.icon_do.setWidth(_s.icon_img.width);
                _s.icon_do.setHeight(_s.icon_img.height);
                _s.icon_do_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.icon_img, _s.nBC).canvas;
                _s.icon_do.screen.appendChild(_s.icon_do_canvas);
            }else{
                _s.icon_do = new FWDUVPDisplayObject("img");
                _s.icon_do.setScreen(_s.icon_img);
                _s.icon_do.setWidth(_s.icon_img.width);
                _s.icon_do.setHeight(_s.icon_img.height);
            }
            
            _s.iconS_img =  new Image();
            _s.iconS_img.src = _s.iconOverPath_str;
            
            if(_s.useHEX){
                _s.iconS_do = new FWDUVPDisplayObject("div");
                _s.iconS_do.setWidth(_s.icon_do.w);
                _s.iconS_do.setHeight(_s.icon_do.h);
                _s.iconS_img.onload = function(){
                    _s.iconS_do_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.iconS_img, _s.sBC).canvas;
                    _s.iconS_do.screen.appendChild(_s.iconS_do_canvas);
                }
            }else{
                _s.iconS_do = new FWDUVPDisplayObject("img");
                _s.iconS_do.setScreen(_s.iconS_img);
                _s.iconS_do.setWidth(_s.icon_do.w);
                _s.iconS_do.setHeight(_s.icon_do.h);
            }
            
            _s.iconS_do.setAlpha(0);
        
            _s.main_do.addChild(_s.bk_do);
            _s.main_do.addChild(_s.text_do);
            _s.main_do.addChild(_s.thumbHolder_do);
            _s.main_do.addChild(_s.icon_do);
            _s.main_do.addChild(_s.iconS_do);
            _s.main_do.addChild(_s.border_do);
            
            if(FWDUVPUtils.isIEAndLessThen9){
                _s.dumy_do = new FWDUVPDisplayObject("div");
                _s.dumy_do.setBkColor("#00FF00");
                _s.dumy_do.setAlpha(.0001);
                _s.dumy_do.setWidth(_s.totalWidth);
                _s.dumy_do.setHeight(_s.totalHeight);
                _s.dumy_do.setButtonMode(true);
                _s.main_do.addChild(_s.dumy_do);
            }
            
            _s.addChild(_s.main_do);
            _s.updateText(_s.text_str);

            
            if(FWDUVPUtils.isIEAndLessThen9){
                if(_s.isMbl){
                    if(_s.hasPointerEvent_bl){
                        _s.dumy_do.screen.addEventListener("pointerup", _s.onMouseUp);
                        _s.dumy_do.screen.addEventListener("pointerover", _s.onMouseOver);
                        _s.dumy_do.screen.addEventListener("pointerout", _s.onMouseOut);
                    }else{
                        _s.dumy_do.screen.addEventListener("touchend", _s.onMouseUp);
                    }
                }else if(_s.dumy_do.screen.addEventListener){   
                    _s.dumy_do.screen.addEventListener("mouseover", _s.onMouseOver);
                    _s.dumy_do.screen.addEventListener("mouseout", _s.onMouseOut);
                    _s.dumy_do.screen.addEventListener("mouseup", _s.onMouseUp);
                }else if(_s.dumy_do.screen.attachEvent){
                    _s.dumy_do.screen.attachEvent("onmouseover", _s.onMouseOver);
                    _s.dumy_do.screen.attachEvent("onmouseout", _s.onMouseOut);
                    _s.dumy_do.screen.attachEvent("onmouseup", _s.onMouseUp);
                }
            }else{
                if(_s.isMbl){
                    if(_s.hasPointerEvent_bl){
                        _s.border_do.screen.addEventListener("pointerup", _s.onMouseUp);
                        _s.border_do.screen.addEventListener("pointerover", _s.onMouseOver);
                        _s.border_do.screen.addEventListener("pointerout", _s.onMouseOut);
                    }else{
                        _s.border_do.screen.addEventListener("touchend", _s.onMouseUp);
                    }
                }else if(_s.border_do.screen.addEventListener){ 
                    _s.border_do.screen.addEventListener("mouseover", _s.onMouseOver);
                    _s.border_do.screen.addEventListener("mouseout", _s.onMouseOut);
                    _s.border_do.screen.addEventListener("mouseup", _s.onMouseUp);
                }else if(_s.border_do.screen.attachEvent){
                    _s.border_do.screen.attachEvent("onmouseover", _s.onMouseOver);
                    _s.border_do.screen.attachEvent("onmouseout", _s.onMouseOut);
                    _s.border_do.screen.attachEvent("onmouseup", _s.onMouseUp);
                }
            }
            
        };
        
        _s.onMouseOver = function(e){
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE || e.pointerType == "mouse"){
                _s.setSelectedState();
            }
        };
            
        _s.onMouseOut = function(e){
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE || e.pointerType == "mouse"){
                _s.setNormalState();
            }
        };
        
        _s.onMouseUp = function(e){
            if(e.preventDefault) e.preventDefault();
            if(e.button == 2 || !_s.isShowed_bl) return;
            _s.dispatchEvent(FWDUVPAdsButton.MOUSE_UP);
        };

        
        //#####################################//
        /* Update text */
        //#####################################//
        _s.updateText = function(text){
            
            _s.text_do.setInnerHTML(text);
            _s.positionInside();
        };

        _s.positionInside = function(){
            var totalWidth;
            totalWidth = _s.text_do.getWidth() + 8 + _s.iconS_do.w;
            _s.text_do.setX(parseInt(_s.totalWidth - totalWidth)/2);
            _s.text_do.setY(parseInt((_s.totalHeight - _s.text_do.getHeight())/2) + 2);
            _s.icon_do.setX(_s.text_do.x + totalWidth - _s.iconS_do.w);
            _s.icon_do.setY(parseInt((_s.totalHeight - _s.iconS_do.h)/2) + 2);
            _s.iconS_do.setX(_s.text_do.x + totalWidth - _s.iconS_do.w);
            _s.iconS_do.setY(parseInt((_s.totalHeight - _s.iconS_do.h)/2) + 2);
        }

        //Resize button.
        _s.prevW;
        _s.resize = function(mbl){
            var mbl;
            var tt = _s.totalWidth;
            
            _s.prvW = prt.sW;
            if(prt.sW < 600) mbl = true;

            if(mbl){
                _s.totalWidth = 64;
                tt = 64;    
            }else{
                _s.totalWidth = 215;
                tt = 215;
            }

            if(!_s.isShWithDl){
                if(_s.position_str == "right"){
                    _s.main_do.setX(-_s.totalWidth)
                }
            }

            if(_s.prevW != _s.totalWidth){
                _s.positionInside();
            }
            _s.prevW = _s.totalWidth

            if(mbl){
                _s.text_do.setVisible(false);
                _s.icon_do.setX(Math.round((tt - _s.iconS_do.w)/2) - 1);
                _s.icon_do.setY(Math.round((_s.totalHeight - _s.iconS_do.h)/2));
            }else{
                _s.text_do.setVisible(true);
                _s.icon_do.setX(_s.text_do.x + _s.text_do.getWidth() + 8 + _s.iconS_do.w - _s.iconS_do.w);
                _s.icon_do.setY(parseInt((_s.totalHeight - _s.iconS_do.h)/2) + 2);
            }

            _s.iconS_do.setX(_s.icon_do.x);
            _s.iconS_do.setY(_s.icon_do.y);
            _s.setWidth(tt);
            _s.main_do.setWidth(tt);
            _s.bk_do.setWidth(tt);
            _s.border_do.setWidth(tt - 1);
        }

        
        //####################################//
        /* Set normal / selected state */
        //####################################//
        _s.setNormalState = function(){
            FWDAnimation.to(_s.iconS_do, .5, {alpha:0, ease:Expo.easeOut}); 
            FWDAnimation.to(_s.text_do.screen, .5, {css:{color:_s.textNormalColor_str}, ease:Expo.easeOut});    
            FWDAnimation.to(_s.border_do.screen, .5, {css:{borderColor:_s.borderNColor_str}, ease:Expo.easeOut});   
        };
        
        _s.setSelectedState = function(){
            FWDAnimation.to(_s.iconS_do, .5, {alpha:1, ease:Expo.easeOut}); 
            FWDAnimation.to(_s.text_do.screen, .5, {css:{color:_s.textSelectedColor_str}, ease:Expo.easeOut});  
            FWDAnimation.to(_s.border_do.screen, .5, {css:{borderColor:_s.borderSColor_str}, ease:Expo.easeOut});   
        };
    
        _s.show = function(animate){
            if(_s.isShowed_bl) return;
            _s.isShowed_bl = true;
            _s.isShWithDl = true;
            _s.resize();
            
            setTimeout(function(){
                _s.isShWithDl = false;
            }, 500);
            _s.setVisible(true);
            
            FWDAnimation.killTweensOf(_s.main_do);
            if(animate && !_s.isMobile_bl){
                if(_s.position_str == "left"){
                    FWDAnimation.to(_s.main_do, .8, {x:0, delay:.8, ease:Expo.easeInOut});
                }else{
                    FWDAnimation.to(_s.main_do, .8, {x:-_s.totalWidth, delay:.8,  ease:Expo.easeInOut});
                }
            }else{
                if(_s.position_str == "left"){
                    _s.main_do.setX(0);
                }else{
                    _s.main_do.setX(-_s.totalWidth);
                }
            }
        };  
            
        _s.hide = function(animate, overwrite){
            if(!_s.isShowed_bl && !overwrite) return;
            _s.isShowed_bl = false;
            _s.isShWithDl = true;
            _s.hasThumbanil_bl = false;
            
            FWDAnimation.killTweensOf(_s.main_do);
            if(animate && !_s.isMobile_bl){
                if(_s.position_str == "left"){
                    FWDAnimation.to(_s.main_do, .8, {x:-_s.totalWidth, ease:Expo.easeInOut, onComplete:_s.hideCompleteHandler});
                }else{
                    FWDAnimation.to(_s.main_do, .8, {x:0, ease:Expo.easeInOut, onComplete:_s.hideCompleteHandler});
                }
            }else{
                if(_s.position_str == "left"){
                    _s.main_do.setX(-_s.totalWidth);
                }else{
                    _s.main_do.setX(0);
                } 
                _s.hideCompleteHandler();
            }
        };
        
        _s.hideCompleteHandler = function(){
            if(_s.smallImage_img){
                _s.smallImage_img.onload = null;
                _s.smallImage_img.src = "";
                FWDAnimation.killTweensOf(_s.icon_do);
            }
            if(_s.main_do.alpha != 1) _s.main_do.setAlpha(1);
            _s.thumbHolder_do.setVisible(false);
            _s.setVisible(false);
            _s.setX(-500);
        };
        
        
        //###########################################//
        /* hide / show  opacity */
        //###########################################//
        _s.hideWithOpacity = function(){
            if(!FWDUVPUtils.isIEAndLessThen9){
                FWDAnimation.to(_s.main_do, .8, {alpha:.5});
            }
        };
        
        _s.showWithOpacity = function(){
            if(!FWDUVPUtils.isIEAndLessThen9){
                FWDAnimation.to(_s.main_do, .8, {alpha:1});
            }
        };
            
        _s.init();
    };
    
    /* set prototype */
    FWDUVPAdsButton.setPrototype = function(){
        FWDUVPAdsButton.prototype = null;
        FWDUVPAdsButton.prototype = new FWDUVPTransformDisplayObject("div");
    };
    
    FWDUVPAdsButton.CLICK = "onClick";
    FWDUVPAdsButton.MOUSE_OVER = "onMouseOver";
    FWDUVPAdsButton.SHOW_TOOLTIP = "showTooltip";
    FWDUVPAdsButton.MOUSE_OUT = "onMouseOut";
    FWDUVPAdsButton.MOUSE_UP = "onMouseDown";
    
    FWDUVPAdsButton.prototype = null;
    window.FWDUVPAdsButton = FWDUVPAdsButton;
}(window));﻿/**
 * Ultimate Video Player PACKAGED v9.1
 * Advertisement info window.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
var FWDUVPAdsStart = function(
            position_str,
            borderColorN_str,
            borderColorS_str,
            adsBackgroundPath_str,
            timeColor_str
        ){
        
        'use strict';

        var _s = this;
        var prototype = FWDUVPAdsStart.prototype;
        
        _s.borderNColor_str = borderColorN_str;
        _s.borderSColor_str = borderColorS_str;
        _s.adsBackgroundPath_str = adsBackgroundPath_str;
        _s.position_str = position_str;
        _s.timeColor_str = timeColor_str;
        
        _s.totalWidth = 215;
        _s.totalHeight = 64;
        _s.fontSize = 12;

        _s.isMbl = FWDUVPUtils.isMobile;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
        
    
        //##########################################//
        /* initialize */
        //##########################################//
        _s.init = function(){
            _s.setOverflow("visible");
            _s.setupMainContainers();
            _s.hide(false, true);
        };
        

        //##########################################//
        /* setup main containers */
        //##########################################//
        _s.setupMainContainers = function(){
            
            _s.main_do = new FWDUVPDisplayObject("div");
            _s.main_do.hasTransform3d_bl = false;
            _s.main_do.hasTransform2d_bl = false;
            _s.main_do.setBackfaceVisibility();
            
            _s.bk_do = new FWDUVPDisplayObject("div");
            _s.bk_do.getStyle().background = "url('" + _s.adsBackgroundPath_str + "')";
            
            _s.text_do = new FWDUVPDisplayObject("div");
            _s.text_do.screen.className = 'UVP-skip-in';
            _s.text_do.hasTransform3d_bl = false;
            _s.text_do.hasTransform2d_bl = false;
            _s.text_do.setBackfaceVisibility();
            _s.text_do.getStyle().fontFamily = "Arial";
            _s.text_do.getStyle().fontSize= "12px";
            _s.text_do.getStyle().lineHeight = "18px";
            _s.text_do.getStyle().textAlign = "center";
            _s.text_do.getStyle().color = _s.timeColor_str;
            _s.text_do.getStyle().fontSmoothing = "antialiased";
            _s.text_do.getStyle().webkitFontSmoothing = "antialiased";
            _s.text_do.getStyle().textRendering = "optimizeLegibility";
            _s.text_do.setInnerHTML("...");
            
            _s.thumbHolder_do = new FWDUVPDisplayObject("div");
            _s.thumbHolder_do.setWidth(_s.totalHeight - 8);
            _s.thumbHolder_do.setHeight(_s.totalHeight - 8);
            _s.thumbHolder_do.setX(_s.totalWidth - _s.thumbHolder_do.w - 4);
            _s.thumbHolder_do.setY(4);
            
            _s.border_do = new FWDUVPDisplayObject("div");
            _s.border_do.getStyle().border = "1px solid " + _s.borderNColor_str + "";
        
            _s.main_do.setWidth(_s.totalWidth);
            _s.main_do.setHeight(_s.totalHeight);
            _s.bk_do.setWidth(_s.totalWidth);
            _s.bk_do.setHeight(_s.totalHeight);
            if(_s.position_str == "left"){
                _s.border_do.setX(-1);
                _s.border_do.setWidth(_s.totalWidth - 1);
                _s.border_do.setHeight(_s.totalHeight -2);
            }else{
                _s.border_do.setWidth(_s.totalWidth);
                _s.border_do.setHeight(_s.totalHeight -2);
            }
            _s.setWidth(_s.totalWidth);
            _s.setHeight(_s.totalHeight);
        
            _s.main_do.addChild(_s.bk_do);
            _s.main_do.addChild(_s.text_do);
            _s.main_do.addChild(_s.thumbHolder_do);
            _s.main_do.addChild(_s.border_do);
            
            _s.addChild(_s.main_do);
        };

        
        //#####################################//
        /* load thumbnail */
        //#####################################//
        _s.loadThumbnail = function(path){
            _s.hasThumbanil_bl = true;
            
            if(_s.smallImage_img){
                _s.smallImage_img.removeAttribute("width");
                _s.smallImage_img.removeAttribute("height");
                _s.smallImage_img.onload = null;
                _s.smallImage_img.src = "";
                try{
                    if(!FWDUVPUtils.isIE) _s.thumbHolder_do.removeChild(_s.thumbnail_do);
                }catch(e){}
            }
            
            if(!_s.thumbnail_do){
                _s.thumbnail_do = new FWDUVPDisplayObject("img");
                _s.smallImage_img = new Image();
            }
            
            _s.thumbHolder_do.setVisible(true);
            _s.smallImage_img.onload = _s.onSmallImageLoad;
            _s.smallImage_img.src = path;
        };
        
        _s.onSmallImageLoad = function(){
            
            _s.smallImageOriginalW = _s.smallImage_img.width;
            _s.smallImageOriginalH = _s.smallImage_img.height;
            _s.thumbnail_do.setScreen(_s.smallImage_img);
            _s.thumbHolder_do.addChild(_s.thumbnail_do);
            
            var scaleX = _s.thumbHolder_do.w/_s.smallImageOriginalW;
            var scaleY = _s.thumbHolder_do.h/_s.smallImageOriginalH;
            var totalScale = 0;
            
            if(scaleX >= scaleY){
                totalScale = scaleX;
            }else if(scaleX <= scaleY){
                totalScale = scaleY;
            }
            
            _s.thumbnail_do.setWidth(Math.round(_s.smallImageOriginalW * totalScale));
            _s.thumbnail_do.setHeight(Math.round(_s.smallImageOriginalH * totalScale));
            _s.thumbnail_do.setX(Math.round((_s.thumbHolder_do.w - _s.thumbnail_do.w)/2));
            _s.thumbnail_do.setY(Math.round((_s.thumbHolder_do.h - _s.thumbnail_do.h)/2));
            _s.thumbnail_do.setAlpha(0);
            FWDAnimation.to(_s.thumbnail_do, .8, {alpha:1});
            _s.updateText();
        };
        

        //#####################################//
        /* Update text */
        //#####################################//
        _s.updateText = function(text){
            if(text) _s.text_do.setInnerHTML(text);
            
            if(_s.hasThumbanil_bl){
                _s.text_do.setX(16);
                _s.text_do.setWidth(_s.totalWidth - _s.totalHeight - 26);
            }else{
                _s.text_do.setX(8);
                _s.text_do.setWidth(_s.totalWidth - 16);
            }
            
            _s.text_do.setY(parseInt((_s.totalHeight - _s.text_do.getHeight())/2));
        };
    

        //#####################################//
        /* show / hide */
        //#####################################//
        _s.show = function(animate){
            if(_s.isShowed_bl) return;
            
            _s.isShowed_bl = true;
            _s.setVisible(true);
            
            FWDAnimation.killTweensOf(_s.main_do);
            if(animate && !_s.isMbl){
                if(_s.position_str == "left"){
                    FWDAnimation.to(_s.main_do, .8, {x:0, delay:.2, ease:Expo.easeInOut});
                }else{
                    FWDAnimation.to(_s.main_do, .8, {x:-_s.totalWidth + 1, delay:.2,  ease:Expo.easeInOut});
                }
            }else{
                if(_s.position_str == "left"){
                    _s.main_do.setX(0);
                }else{
                    _s.main_do.setX(-_s.totalWidth);
                }
            }
        };  
            
        _s.hide = function(animate, overwrite){
            if(!_s.isShowed_bl && !overwrite) return;
            
            _s.isShowed_bl = false;
            _s.hasThumbanil_bl = false;
            
            FWDAnimation.killTweensOf(_s.main_do);
            if(animate && !_s.isMbl){
                if(_s.position_str == "left"){
                    FWDAnimation.to(_s.main_do, .8, {x:-_s.totalWidth, ease:Expo.easeInOut, onComplete:_s.hideCompleteHandler});
                }else{
                    FWDAnimation.to(_s.main_do, .8, {x:0, ease:Expo.easeInOut, onComplete:_s.hideCompleteHandler});
                }
            }else{
                if(_s.position_str == "left"){
                    _s.main_do.setX(-_s.totalWidth);
                }else{
                    _s.main_do.setX(0);
                } 
                _s.hideCompleteHandler();
            }
        };
        
        _s.hideCompleteHandler = function(){
            if(_s.smallImage_img){
                _s.smallImage_img.onload = null;
                _s.smallImage_img.src = "";
                FWDAnimation.killTweensOf(_s.thumbnail_do);
            }
            
            if(_s.main_do.alpha != 1) _s.main_do.setAlpha(1);
            _s.thumbHolder_do.setVisible(false);
            _s.setVisible(false);
        };
        

        //###########################################//
        /* hide / show  opacity */
        //###########################################//
        _s.hideWithOpacity = function(){
            if(!FWDUVPUtils.isIEAndLessThen9){
                FWDAnimation.to(_s.main_do, .8, {alpha:.5});
            }
        };
        
        _s.showWithOpacity = function(){
            if(!FWDUVPUtils.isIEAndLessThen9){
                FWDAnimation.to(_s.main_do, .8, {alpha:1});
            }
        };
        
        _s.init();
    };
    
    
    /* set prototype */
    FWDUVPAdsStart.setPrototype = function(){
        FWDUVPAdsStart.prototype = null;
        FWDUVPAdsStart.prototype = new FWDUVPTransformDisplayObject("div");
    };
    
    FWDUVPAdsStart.CLICK = "onClick";
    FWDUVPAdsStart.MOUSE_OVER = "onMouseOver";
    FWDUVPAdsStart.SHOW_TOOLTIP = "showTooltip";
    FWDUVPAdsStart.MOUSE_OUT = "onMouseOut";
    FWDUVPAdsStart.MOUSE_UP = "onMouseDown";
    
    FWDUVPAdsStart.prototype = null;
    window.FWDUVPAdsStart = FWDUVPAdsStart;
}(window));﻿/**
 * Ultimate Video Player PACKAGED v9.1
 * Annotation item.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
var FWDUVPAnnotation = function(props_obj){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPAnnotation.prototype;
        
        _s.id = props_obj.id;
        _s.startTime = props_obj.start;
        _s.endTime = props_obj.end;
        _s.htmlContent_str = props_obj.content;
        _s.left = props_obj.left;
        _s.top = props_obj.top;
        _s.showCloseButton_bl = props_obj.showCloseButton_bl;
        _s.clickSource = props_obj.clickSource;
        _s.clickSourceTarget = props_obj.clickSourceTarget;
        _s.closeButtonNpath = props_obj.closeButtonNpath;
        _s.closeButtonSPath = props_obj.closeButtonSPath;
        _s.normalStateClass = props_obj.normalStateClass;
        _s.selectedStateClass = props_obj.selectedStateClass;
        _s.showAnnotationsPositionTool_bl = props_obj.showAnnotationsPositionTool_bl;
        _s.prt = props_obj.prt;
        _s.curX = _s.left;
        _s.curY = _s.top;
        _s._d = props_obj._d;
        
        _s.useHEX = props_obj.useHEX;
        _s.nBC = props_obj.nBC;
        _s.sBC = props_obj.sBC;
        
        _s.handPath_str = props_obj.handPath_str;
        _s.grabPath_str = props_obj.grabPath_str;

    
        //##########################################//
        /* initialize  */
        //##########################################//
        _s.init = function(){
            if(_s._d.sknPth.indexOf("hex_white") != -1){
                _s.sBC = "#FFFFFF";
            }
            
            _s.setOverflow("visible");
            _s.setAlpha(0);
            _s.setVisible(false);
            
            if(FWDUVPUtils.hasTransform2d){
                _s.getStyle().transformOrigin = "0% 0%";
            }
            
            _s.screen.innerHTML = _s.htmlContent_str;
            _s.screen.className = _s.normalStateClass;
            _s.setBackfaceVisibility();
            _s.getStyle().fontSmoothing = "antialiased";
            _s.getStyle().webkitFontSmoothing = "antialiased";
            _s.getStyle().textRendering = "optimizeLegibility";
            
            _s.dummy_do = new FWDUVPDisplayObject("div");
            _s.dummy_do.getStyle().width = "100%";
            _s.dummy_do.getStyle().height = "100%";
            _s.addChild(_s.dummy_do);
        
            setTimeout(function(){
                _s.w = _s.getWidth();
                _s.h = _s.getHeight();
            }, 100);
            
            if(_s.showCloseButton_bl && !_s.showAnnotationsPositionTool_bl){
                FWDUVPSimpleSizeButton.setPrototype();
                _s.clsBtn = new FWDUVPSimpleSizeButton(
                        _s.closeButtonNpath, 
                        _s.closeButtonSPath,
                        26,
                        26,
                        _s.useHEX,
                        _s.nBC,
                        _s.sBC,
                        true
                        );
                _s.clsBtn.setScale2(0);
                _s.clsBtn.addListener(FWDUVPSimpleSizeButton.MOUSE_UP, _s.closeClickButtonCloseHandler);
                _s.clsBtn.getStyle().position = "absolute";
                _s.addChild(_s.clsBtn);
            }
            
            if(_s.showAnnotationsPositionTool_bl){
                _s.info_do = new FWDUVPDisplayObject("div");
                _s.info_do.getStyle().backgroundColor = "#FFFFFF";
                _s.info_do.getStyle().boxShadow = "2px 2px 2px #888888;";
                
                _s.info_do.getStyle().fontSmoothing = "antialiased";
                _s.info_do.getStyle().webkitFontSmoothing = "antialiased";
                _s.info_do.getStyle().textRendering = "optimizeLegibility";
                _s.addChild(_s.info_do);
                
                setTimeout(function(){
                    _s.info_do.screen.innerHTML = "<div style='padding:4px; maring:4px; color:#000000'> _d-left=" + Math.round(_s.curX * _s.prt.scaleInverse)  + "</div><div style='padding:4px; margin:4px; color:#000000;'> _d-top=" + Math.round(_s.curY * _s.prt.scaleInverse)  + "</div>";
                    
                    _s.setX(Math.round(_s.curX * _s.prt.scale));
                    _s.setY(Math.round(_s.curY * _s.prt.scale));
                }, 100)
                if(_s.isMbl){
                if(_s.hasPointerEvent_bl){
                        _s.screen.addEventListener("pointerdown", _s.selfOnDownHandler);
                    }else{
                        _s.screen.addEventListener("touchdown", _s.selfOnDownHandler);
                    }
                }else{
                    if(window.addEventListener){
                        _s.screen.addEventListener("mousedown", _s.selfOnDownHandler);      
                    }
                }
                _s.getStyle().cursor = 'url(' + _s.handPath_str + '), default';
            }
        
            if(_s.clickSource && !_s.showAnnotationsPositionTool_bl){
                _s.dummy_do.setButtonMode(true);
                _s.dummy_do.screen.addEventListener("click", _s.onClickHandler);
                _s.dummy_do.screen.addEventListener("mouseover", _s.onMouseOverHandler);
                _s.dummy_do.screen.addEventListener("mouseout", _s.onMouseOutHandler);
            }
        };
        
        _s.selfOnDownHandler =  function(e){
            if(e.preventDefault) e.preventDefault();
            
            _s.getStyle().cursor = 'url(' + _s.grabPath_str + '), default';
            _s.prt.addChild(_s);
            
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            _s.startX = vc.screenX - _s.prt.getGlobalX();
            _s.startY = vc.screenY - _s.prt.getGlobalY();
            _s.curX = _s.x;
            _s.curY = _s.y;
        
            if(_s.isMbl){
                if(_s.hasPointerEvent_bl){
                    window.addEventListener("pointermove", _s.selfMoveHandler);
                    window.addEventListener("pointerup", _s.selfEndHandler);
                }else{
                    window.addEventListener("touchmove", _s.selfMoveHandler);
                    window.addEventListener("touchend", _s.selfEndHandler);
                }
            }else{
                if(window.addEventListener){
                    window.addEventListener("mousemove", _s.selfMoveHandler);
                    window.addEventListener("mouseup", _s.selfEndHandler);      
                }
            }
        };
        
        _s.selfMoveHandler = function(e){
            if(e.preventDefault) e.preventDefault();
            
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            _s.localX = vc.screenX - _s.prt.getGlobalX();
            _s.localY = vc.screenY - _s.prt.getGlobalY();
            
            _s.curX = _s.x;
            _s.curY = _s.y;
            _s.curX += (_s.localX - _s.startX);
            _s.curY += (_s.localY - _s.startY);
            
            _s.setX(_s.curX);
            _s.setY(_s.curY);
            _s.startX = vc.screenX - _s.prt.getGlobalX();
            _s.startY = vc.screenY - _s.prt.getGlobalY();
            
            _s.info_do.screen.innerHTML = "<div style='padding:4px; maring:4px; color:#000000'> _d-left=" + Math.round(_s.curX * _s.prt.scaleInverse)  + "</div><div style='padding:4px; margin:4px; color:#000000;'> _d-top=" + Math.round(_s.curY * _s.prt.scaleInverse)  + "</div>";
        };
        
        _s.selfEndHandler = function(e){
            _s.getStyle().cursor = 'url(' + _s.handPath_str + '), default';
            if(_s.isMbl){
                if(_s.hasPointerEvent_bl){
                    window.removeEventListener("pointermove", _s.selfMoveHandler);
                    window.removeEventListener("pointerup", _s.selfEndHandler);
                }else{
                    window.removeEventListener("touchmove", _s.selfMoveHandler);
                    window.removeEventListener("touchend", _s.selfEndHandler);
                }
            }else{
                if(window.removeEventListener){
                    window.removeEventListener("mousemove", _s.selfMoveHandler);
                    window.removeEventListener("mouseup", _s.selfEndHandler);       
                }
            }
        };
        
        _s.onMouseOverHandler = function(e){
            _s.setSelectedAtate();
        };
        
        _s.onMouseOutHandler = function(e){
            _s.setNormalState();
        };
        
        _s.onClickHandler = function(){
        
            if(_s.clickSource.indexOf("https") != -1 || _s.clickSource.indexOf("http") != -1){
                window.open(_s.clickSource, _s.clickSourceTarget);
            }else{
                eval(_s.clickSource);
            }
        };
        
        _s.closeClickButtonCloseHandler = function(){
            _s.hide();
            _s.isClsd = true;
        };
    
        _s.show = function(){
            if(_s.isShowed_bl || _s.isClsd) return;
            _s.isShowed_bl = true;
            _s.setVisible(true);
            FWDAnimation.killTweensOf(_s);
            FWDAnimation.to(_s, .8, {alpha:1, ease:Quint.easeOut});
            if(_s.clsBtn) FWDAnimation.to(_s.clsBtn, .8, {scale:1, delay:.2, ease:Elastic.easeOut});
        };
        
        _s.hide = function(){
            if(!_s.isShowed_bl) return;
            FWDAnimation.killTweensOf(_s);
            _s.isShowed_bl = false;
            _s.setVisible(false);
            _s.setAlpha(0);
            if(_s.clsBtn){
                FWDAnimation.killTweensOf(_s.clsBtn);
                _s.clsBtn.setScale2(0);
            }
        };
        
        _s.setNormalState = function(){
            if(!_s.selectedStateClass) return;
            FWDAnimation.to(_s.screen, .8, {className:_s.normalStateClass, ease:Quint.easeOut});
        };
        
        _s.setSelectedAtate = function(){
            if(!_s.selectedStateClass) return;
            FWDAnimation.to(_s.screen, .8, {className:_s.selectedStateClass, ease:Quint.easeOut});
        };

        
        //##########################################//
        /* Update HEX color of a canvaas */
        //##########################################//
        _s.updateHEXColors = function(nBC, sBC){
            if(_s.clsBtn) _s.clsBtn.updateHEXColors(nBC, sBC, _s.buttonWidth, _s.buttonHeight);
        }
        
        _s.init();
    };
    

    /* set prototype */
    FWDUVPAnnotation.setPrototype = function(){
        FWDUVPAnnotation.prototype = null;
        if(FWDUVPUtils.hasTransform2d){
            FWDUVPAnnotation.prototype = new FWDUVPTransformDisplayObject("div");
        }else{
            FWDUVPAnnotation.prototype = new FWDUVPDisplayObject("div");
        }
    };

    FWDUVPAnnotation.prototype = null;
    window.FWDUVPAnnotation = FWDUVPAnnotation;
}(window));﻿/**
 * Ultimate Video Player PACKAGED v9.1
 * Annotations.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
var FWDUVPAnnotations = function(prt, _d){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPAnnotations.prototype;
        
        _s.nBC = _d.nBC;
        _s.sBC = _d.sBC;
        
        _s.ann_ar = [];
        _s.showAnnotationsPositionTool_bl = _d.showAnnotationsPositionTool_bl;
    

        //##########################################//
        /* initialize */
        //##########################################//
        _s.init = function(){
            _s.setOverflow("visible");
        };
        

        //##########################################//
        /* setup text containers */
        //##########################################//
        _s.setupAnnotations = function(source_ar){
            
            if(_s.ann_ar){
                for(var i=0; i<_s.ann_ar.length; i++){
                    try{
                        _s.removeChild(_s.ann_ar[i]);
                    }catch(e){}
                }
            }
            
            _s.source_ar = source_ar;
            
            if(source_ar == undefined){
                _s.setVisible(false);
                return;
            }else{
                _s.setVisible(true);
            }
            
            _s.source_ar = source_ar;
            _s.ann_ar = [];
            _s.totalAnnotations = _s.source_ar.length;
            var pth = _d.annotationAddCloseNPath_str;
            if(window['isWhite']){
                pth = 'content/hex_white/annotation-close-button-normal.png';
            }
            
            for(var i=0; i<_s.totalAnnotations; i++){
                
                FWDUVPAnnotation.setPrototype();
                var ann = new FWDUVPAnnotation({
                    id:i,
                    start:_s.source_ar[i].start,
                    end:_s.source_ar[i].end,
                    left:_s.source_ar[i].left,
                    top:_s.source_ar[i].top,
                    clickSource:_s.source_ar[i].clickSource,
                    clickSourceTarget:_s.source_ar[i].clickSourceTarget,
                    content:_s.source_ar[i].content,
                    showCloseButton_bl:_s.source_ar[i].showCloseButton_bl,
                    closeButtonNpath:pth,
                    closeButtonSPath:_d.annotationAddCloseSPath_str,
                    normalStateClass:_s.source_ar[i].normalStateClass,
                    selectedStateClass:_s.source_ar[i].selectedStateClass,
                    showAnnotationsPositionTool_bl:_s.showAnnotationsPositionTool_bl,
                    prt:_s,
                    handPath_str:_d.handPath_str,
                    grabPath_str:_d.grabPath_str,
                    useHEX:_d.useHEX,
                    nBC:_s.nBC,
                    sBC:_s.sBC,
                    _d:_d
                }) 
                
                _s.ann_ar[i] = ann;
                
                _s.addChild(ann);
            }   
        };
        
        _s.update = function(duration){

            if(_s.totalAnnotations == 0) return;
            var annotation;
            
            for(var i=0; i<_s.totalAnnotations; i++){
                annotation = _s.ann_ar[i];
                if(duration <=0){
                    annotation.hide();
                }else if(duration >= annotation.startTime && duration <= annotation.endTime){
                    annotation.show();
                    _s.position();
                    
                }else{
                    annotation.hide();
                }
            }   
        
        };
        
        _s.position = function(animate){
            
            var selfScale = prt.sW/prt.maxWidth;
            _s.setX(Math.round((prt.sW - (selfScale * prt.maxWidth))/2));
            _s.setY(Math.round((prt.tempVidStageHeight - (selfScale * prt.maxHeight))/2));
            
            _s.scale = prt.sW/prt.maxWidth;
            _s.scaleY = _s.scale;
            _s.scaleX = _s.scale;
            
            _s.scaleInverse = prt.maxWidth/prt.sW;
            
            if(_s.showAnnotationsPositionTool_bl) return;
            for(var i=0; i<_s.totalAnnotations; i++){
                var ann_do = _s.ann_ar[i];
                
                var finalX = 0;
                var finalY = 0;
                
                ann_do.setScale2(_s.scale);
            
                ann_do.finalX = Math.floor(ann_do.left * _s.scaleX);
                if(prt.playlist_do && prt.isPlaylistShowed_bl && prt.tempPlaylistPosition_str == "right" && !prt.isFullScreen_bl && ann_do.left > prt.maxWidth/3){
                    ann_do.finalX -= (prt.playlistWidth + prt.spaceBetweenControllerAndPlaylist);
                }
                
                ann_do.finalY = Math.floor(ann_do.top * _s.scaleY);
                
                if(ann_do.clsBtn){
                    
                    ann_do.clsBtn.setWidth(Math.round(ann_do.clsBtn.buttonWidth * _s.scaleInverse));
                    ann_do.clsBtn.setHeight(Math.round(ann_do.clsBtn.buttonHeight * _s.scaleInverse));
                    ann_do.clsBtn.n_do.setWidth(Math.round(ann_do.clsBtn.buttonWidth * _s.scaleInverse));
                    ann_do.clsBtn.n_do.setHeight(Math.round(ann_do.clsBtn.buttonHeight * _s.scaleInverse));
                    if(ann_do.clsBtn.n_do_canvas){
                        ann_do.clsBtn.n_do_canvas.style.width = Math.round(ann_do.clsBtn.buttonWidth * _s.scaleInverse) + "px";
                        ann_do.clsBtn.n_do_canvas.style.height = Math.round(ann_do.clsBtn.buttonheight * _s.scaleInverse) + "px";
                        ann_do.clsBtn.s_do_canvas.style.width = Math.round(ann_do.clsBtn.buttonWidth * _s.scaleInverse) + "px";
                        ann_do.clsBtn.s_do_canvas.style.height = Math.round(ann_do.clsBtn.buttonheight * _s.scaleInverse) + "px";
                    }
                    ann_do.clsBtn.s_do.setWidth(Math.round(ann_do.clsBtn.buttonWidth * _s.scaleInverse));
                    ann_do.clsBtn.s_do.setHeight(Math.round(ann_do.clsBtn.buttonHeight * _s.scaleInverse));
                    ann_do.clsBtn.setX(Math.floor(ann_do.getWidth() - ((ann_do.clsBtn.w/2))));
                    ann_do.clsBtn.setY(Math.floor(-(ann_do.clsBtn.h/2)));
                }
                
                if(ann_do.prevFinalX != ann_do.finalX){
                    if(animate){
                        FWDAnimation.to(ann_do, .8, {x:ann_do.finalX, ease:Expo.easeInOut});
                    }else{
                        ann_do.setX(ann_do.finalX);
                    }
                    
                }
            
                if(ann_do.prevFinalY != ann_do.finalY){
                    if(animate){
                        FWDAnimation.to(ann_do, .8, {y:ann_do.finalY, ease:Expo.easeInOut});
                    }else{
                        ann_do.setY(ann_do.finalY);
                    }
                }
                
                ann_do.prevFinalX = ann_do.finalX;
                ann_do.prevFinalY = ann_do.finalY
            }
        };
    
        _s.updateHEXColors =  function(nBC, sBC){
            
            _s.nBC = nBC;
            _s.sBC = sBC;
            if(_s.ann_ar){
                for(var i=0; i<_s.ann_ar.length; i++){
                    _s.ann_ar[i].updateHEXColors(nBC, sBC); 
                }
            }
        }
        _s.init();
    };

    
    /* set prototype */
    FWDUVPAnnotations.setPrototype = function(){
        FWDUVPAnnotations.prototype = null;
        FWDUVPAnnotations.prototype = new FWDUVPDisplayObject("div", "absolute");
    };
    
    FWDUVPAnnotations.prototype = null;
    window.FWDUVPAnnotations = FWDUVPAnnotations;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Audio screen.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function(window){
    
    var FWDUVPAudioScreen = function(prt, volume){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPAudioScreen.prototype;
    
        _s.lastPercentPlayed = 0;
        _s.volume = volume;
        _s.curDuration = 0;
        _s.countNormalMp3Errors = 0;
        _s.countShoutCastErrors = 0;
        _s.maxShoutCastCountErrors = 5;
        _s.maxNormalCountErrors = 1;
        _s.testShoutCastId_to;
        _s.audioVisualizerLinesColor_str = FWDUVPUtils.hexToRgb(prt._d.audioVisualizerLinesColor_str);
        _s.audioVisualizerCircleColor_str = FWDUVPUtils.hexToRgb(prt._d.audioVisualizerCircleColor_str);
        _s.hasError_bl = true;
        _s.isStopped_bl = true;

        
        //###############################################//
        /* init */
        //###############################################//
        _s.init = function(){
            _s.setupAudio();
        };

        
        //##############################################//
        /* Resize and position */
        //##############################################//
        _s.resizeAndPosition = function(width, height){
            if(width){
                _s.sW = width;
                _s.sH = height;
            }
            
            _s.setWidth(_s.sW);
            _s.setHeight(_s.sH);
            _s.resizeSpectrumCanvas()
        };
    

        //###############################################//
        /* Setup audio element */
        //##############################################//
        _s.setupAudio = function(){
            if(_s.audio_el == null){
                _s.audio_el = document.createElement("audio");
                _s.screen.appendChild(_s.audio_el);
                _s.audio_el.controls = false;
                _s.audio_el.preload = "auto";
                _s.audio_el.volume = _s.volume;
                if(!FWDUVPUtils.isLocal) _s.audio_el.crossOrigin = "*";
                _s.setPlaybackRate(prt._d.defaultPlaybackRate_ar[prt._d.startAtPlaybackIndex]);
            }
            
            _s.audio_el.addEventListener("error", _s.errorHandler);
            _s.audio_el.addEventListener("canplay", _s.safeToBeControlled);
            _s.audio_el.addEventListener("canplaythrough", _s.safeToBeControlled);
            _s.audio_el.addEventListener("progress", _s.updateProgress);
            _s.audio_el.addEventListener("timeupdate", _s.updateAudio);
            _s.audio_el.addEventListener("pause", _s.pauseHandler);
            _s.audio_el.addEventListener("play", _s.playHandler);
            _s.audio_el.addEventListener("ended", _s.endedHandler);
        };
        
        _s.destroyAudio = function(){
            if(_s.audio_el){
                _s.audio_el.removeEventListener("error", _s.errorHandler);
                _s.audio_el.removeEventListener("canplay", _s.safeToBeControlled);
                _s.audio_el.removeEventListener("canplaythrough", _s.safeToBeControlled);
                _s.audio_el.removeEventListener("progress", _s.updateProgress);
                _s.audio_el.removeEventListener("timeupdate", _s.updateAudio);
                _s.audio_el.removeEventListener("pause", _s.pauseHandler);
                _s.audio_el.removeEventListener("play", _s.playHandler);
                _s.audio_el.removeEventListener("ended", _s.endedHandler);
                _s.audio_el.removeEventListener("waiting", _s.startToBuffer);
                _s.audio_el.removeEventListener("playing", _s.stopToBuffer);
                _s.audio_el.src = "";
                _s.audio_el.load();
            }
        };
        
        _s.startToBuffer = function(overwrite){
            _s.dispatchEvent(FWDUVPVideoScreen.START_TO_BUFFER);
        };
        
        _s.stopToBuffer = function(){
            _s.dispatchEvent(FWDUVPVideoScreen.STOP_TO_BUFFER);
        };
        
        _s.togglePlayPause = function(){
            if(_s == null) return;
            if(!_s.isSafeToBeControlled_bl) return;
            if(_s.isPlaying_bl){
                _s.pause();
            }else{
                _s.play();
            }
        };

        _s.updateLinesColor = function(lc){
            _s.audioVisualizerLinesColor_str = lc;
        }
        

        //##########################################//
        /* Video error handler. */
        //##########################################//
        _s.errorHandler = function(e){
            if(_s.sourcePath_str == null || _s.sourcePath_str == undefined) return;
            
            if(_s.isNormalMp3_bl && _s.countNormalMp3Errors <= _s.maxNormalCountErrors){
                _s.stop();
                _s.testShoutCastId_to = setTimeout(_s.play, 200);
                _s.countNormalMp3Errors ++;
                return;
            }
            
            if(_s.isShoutcast_bl && _s.countShoutCastErrors <= _s.maxShoutCastCountErrors && _s.audio_el.networkState == 0){
                _s.testShoutCastId_to = setTimeout(_s.play, 200);
                _s.countShoutCastErrors ++;
                return;
            }
            
            var error_str;
            _s.hasError_bl = true;
            _s.stop();
            
            if(_s.audio_el.networkState == 0){
                error_str = "error '_s.audio_el.networkState = 1'";
            }else if(_s.audio_el.networkState == 1){
                error_str = "error '_s.audio_el.networkState = 1'";
            }else if(_s.audio_el.networkState == 2){
                error_str = "'_s.audio_el.networkState = 2'";
            }else if(_s.audio_el.networkState == 3){
                error_str = "source not found";
            }else{
                error_str = e;
            }
            
            if(window.console) window.console.log(_s.audio_el.networkState);
            
            _s.dispatchEvent(FWDUVPAudioScreen.ERROR, {text:error_str });
        };
        

        //##############################################//
        /* Set path */
        //##############################################//
        _s.setSource = function(sourcePath){
            
            _s.sourcePath_str = sourcePath;
            clearTimeout(_s.testShoutCastId_to);
            
            if(_s.sourcePath_str.indexOf(";") != -1){
                _s.isShoutcast_bl = true;
                _s.countShoutCastErrors = 0;
            }else{
                _s.isShoutcast_bl = false;
            }
            
            if(_s.sourcePath_str.indexOf(";") == -1){
                _s.isNormalMp3_bl = true;
                _s.countNormalMp3Errors = 0;
            }else{
                _s.isNormalMp3_bl = false;
            }
            
            _s.lastPercentPlayed = 0;
            if(_s.audio_el) _s.stop(true);
        };

    
        //##########################################//
        /* Play / pause / stop methods */
        //##########################################//
        _s.play = function(overwrite){
            if(_s.isStopped_bl){
                _s.isPlaying_bl = false;
                _s.hasError_bl = false;
                _s.allowScrubing_bl = false;
                _s.isStopped_bl = false;
                _s.setupAudio();
                _s.audio_el.src = _s.sourcePath_str;
                _s.play();
                _s.setVisible(true);
            }else if(!_s.audio_el.ended || overwrite){
                try{
                    _s.isPlaying_bl = true;
                    _s.hasPlayedOnce_bl = true;
                    var prm = _s.audio_el.play();
                    if(prm !== undefined) {
                        prm.then(function(){}, function(){});
                    }
                    if(FWDUVPUtils.isIE) _s.dispatchEvent(FWDUVPAudioScreen.PLAY);
                }catch(e){console.log(e)};
            }
        };
        
        _s.resume = function(){
            if(_s.isStopped_bl) return;
            _s.play();
        };

        _s.pause = function(){
            if(_s == null) return;
            if(_s.audio_el == null) return;
            if(!_s.audio_el.ended){
                _s.audio_el.pause();
                _s.isPlaying_bl = false;
                if(FWDUVPUtils.isIE) _s.dispatchEvent(FWDUVPAudioScreen.PAUSE);             
            }
        };
        
        _s.pauseHandler = function(){
            if(_s.allowScrubing_bl) return;
            _s.stopSpectrum();
            _s.dispatchEvent(FWDUVPAudioScreen.PAUSE);
        };
        
        _s.playHandler = function(){
            if(_s.allowScrubing_bl) return;
            if(!_s.isStartEventDispatched_bl){
                _s.dispatchEvent(FWDUVPAudioScreen.START);
                _s.isStartEventDispatched_bl = true;
            }
        
            _s.startSpectrum();
            _s.dispatchEvent(FWDUVPAudioScreen.PLAY);
        };
        
        _s.endedHandler = function(){
            _s.dispatchEvent(FWDUVPAudioScreen.PLAY_COMPLETE);
        };
        
        _s.stop = function(overwrite){
        
            if((_s == null || _s.audio_el == null || _s.isStopped_bl) && !overwrite) return;
            _s.isPlaying_bl = false;
            _s.isStopped_bl = true;
            _s.hasPlayedOnce_bl = true;
            _s.isSafeToBeControlled_bl = false;
            _s.isStartEventDispatched_bl = false;
            _s.setVisible(false);
            clearTimeout(_s.testShoutCastId_to);
            _s.stopToUpdateSubtitles();
            _s.stopSpectrum();
            _s.audio_el.pause();
            _s.destroyAudio();
            _s.dispatchEvent(FWDUVPAudioScreen.STOP);
            _s.dispatchEvent(FWDUVPAudioScreen.LOAD_PROGRESS, {percent:0});
        };


        //###########################################//
        /* Check if audio is safe to be controlled */
        //###########################################//
        _s.safeToBeControlled = function(){
            if(!_s.isSafeToBeControlled_bl){
                _s.hasHours_bl = Math.floor(_s.audio_el.duration / (60 * 60)) > 0;
                _s.isPlaying_bl = true;
                _s.isSafeToBeControlled_bl = true;
                _s.startToUpdateSubtitles();
                _s.dispatchEvent(FWDUVPAudioScreen.SAFE_TO_SCRUBB);
                _s.dispatchEvent(FWDUVPAudioScreen.SAFE_TO_UPDATE_VOLUME);
            }
        };
    

        //###########################################//
        /* Update progress */
        //##########################################//
        _s.updateProgress = function(){
            var buffered;
            var percentLoaded = 0;
            
            if(_s.audio_el.buffered.length > 0){
                buffered = _s.audio_el.buffered.end(_s.audio_el.buffered.length - 1);
                percentLoaded = buffered.toFixed(1)/_s.audio_el.duration.toFixed(1);
                if(isNaN(percentLoaded) || !percentLoaded) percentLoaded = 0;
            }
            
            if(percentLoaded == 1) _s.audio_el.removeEventListener("progress", _s.updateProgress);
            
            _s.dispatchEvent(FWDUVPAudioScreen.LOAD_PROGRESS, {percent:percentLoaded});
        };

        
        //##############################################//
        /* Update audio */
        //#############################################//
        _s.updateAudio = function(){
            
            var percentPlayed; 
            if (!_s.allowScrubing_bl) {
                percentPlayed = _s.audio_el.currentTime /_s.audio_el.duration;
                _s.dispatchEvent(FWDUVPAudioScreen.UPDATE, {percent:percentPlayed});
            }
            
            var totalTime = FWDUVPUtils.formatTime(_s.audio_el.duration);
            var curTime = FWDUVPUtils.formatTime(_s.audio_el.currentTime);
            
            
            if(!isNaN(_s.audio_el.duration)){
                _s.dispatchEvent(FWDUVPVideoScreen.UPDATE_TIME, {curTime: curTime, totalTime:totalTime, seconds:_s.audio_el.currentTime, totalTimeInSeconds:_s.audio_el.duration});
            }else{
                _s.dispatchEvent(FWDUVPVideoScreen.UPDATE_TIME, {curTime:"00:00" , totalTime:"00:00", seconds:0, totalTimeInSeconds:0});
            }
            _s.lastPercentPlayed = percentPlayed;
            _s.curDuration = curTime;
        };

        
        //###############################################//
        /* Scrub */
        //###############################################//
        _s.startToScrub = function(){
            _s.allowScrubing_bl = true;
        };
        
        _s.stopToScrub = function(){
            _s.allowScrubing_bl = false;
        };
        
        _s.scrubbAtTime = function(duration){
            _s.audio_el.currentTime = duration;
            var totalTime = FWDUVPUtils.formatTime(_s.audio_el.duration);
            var curTime = FWDUVPUtils.formatTime(_s.audio_el.currentTime);
            _s.dispatchEvent(FWDUVPVideoScreen.UPDATE_TIME, {curTime: curTime, totalTime:totalTime});
        };
        
        _s.scrub = function(percent, e){
            if(_s.audio_el == null || !_s.audio_el.duration) return;
            if(e) _s.startToScrub();
            try{
                _s.audio_el.currentTime = _s.audio_el.duration * percent;
                var totalTime = FWDUVPUtils.formatTime(_s.audio_el.duration);
                var curTime = FWDUVPUtils.formatTime(_s.audio_el.currentTime);
                _s.dispatchEvent(FWDUVPAudioScreen.UPDATE_TIME, {curTime: curTime, totalTime:totalTime});
            }catch(e){}
        };

        
        //###############################################//
        /* replay */
        //###############################################//
        _s.replay = function(){
            _s.scrub(0);
            _s.play();
        };

        
        //##################################################//
        /* Subtitles */
        //##################################################//
        _s.stopToUpdateSubtitles = function(){
            clearInterval(_s.startToUpdateSubtitleId_int);  
        }
        
        _s.startToUpdateSubtitles = function(){
            clearInterval(_s.startToUpdateSubtitleId_int);
            _s.startToUpdateSubtitleId_int = setInterval(_s.updateSubtitleHandler, 10);
        }
        
        _s.updateSubtitleHandler = function(){
            _s.dispatchEvent(FWDUVPAudioScreen.UPDATE_SUBTITLE, {curTime:_s.audio_el.currentTime});
        }
        

        //###############################################//
        /* Volume */
        //###############################################//
        _s.setVolume = function(vol){
            if(vol != undefined) _s.volume = vol;
            if(_s.audio_el) _s.audio_el.volume = _s.volume;
        };
        
        _s.setPlaybackRate = function(rate){
            if(!_s.audio_el) return;
            if(rate == 0.25) rate = "0.5";
            
            _s.audio_el.defaultPlaybackRate = rate;
            _s.audio_el.playbackRate = rate;
        }

        
        //####################################################//
        /* Spectrum visualizer */
        //###################################################//
        _s.setupSpectrum = function(){
            if(FWDUVPUtils.isIOS) return;
            if(prt.useWithoutVideoScreen_bl) return;
            var audioContextTest = window.AudioContext || window.webkitAudioContext;
            if(_s.canvas_do || !audioContextTest) return;
            if(FWDUVPAudioScreen.countAudioContext > 3) return;
            FWDUVPAudioScreen.countAudioContext ++;
            _s.canvas_do = new FWDUVPDisplayObject("canvas");
            
            _s.addChild(_s.canvas_do);
            
            _s.canvas = _s.canvas_do.screen;
            _s.ctx = _s.canvas.getContext("2d");
            
            _s.resizeSpectrumCanvas();
            
            if(!audioContextTest) return;
            _s.context = new audioContextTest();
            _s.analyser = _s.context.createAnalyser();
            
            _s.source = _s.context.createMediaElementSource(_s.audio_el);
            
            _s.source.connect(_s.analyser);
            _s.analyser.connect(_s.context.destination);
            
            _s.fbc_array = new Uint8Array(_s.analyser.frequencyBinCount);
            _s.renderSpectrum();
        }
        
        _s.resizeSpectrumCanvas =  function(){
            if(!_s.canvas_do) return;
            _s.canvas_do.setWidth(_s.sW);
            _s.canvas_do.setHeight(_s.sH);
            _s.canvas.width  = _s.sW;
            _s.canvas.height = _s.sH;
        }
        
        
        // give vars an initial real value to validate
        _s.bars = 200;
        if(FWDUVPUtils.isMobile) _s.bars = 100;
        _s.react_x = 0;
        _s.react_y = 0;
        _s.radius = 0;
        _s.deltarad = 0;
        _s.shockwave = 0;
        _s.rot = 0;
        _s.intensity = 0;
        _s.isSeeking = 0;
        _s.center_x;
        _s.center_y;
        
        
        _s.renderSpectrum = function() {
            
            if(!_s.canvas_do) return;
            _s.resizeSpectrumCanvas(); // for some reason i have to resize the _s.canvas every update or else the framerate decreases over time
                        
            var grd = _s.ctx.createLinearGradient(0, 0, 0, _s.canvas.height);
            grd.addColorStop(0, "rgba(0, 0, 0, 1)");
            grd.addColorStop(1, "rgba(0, 0, 0, 1)");

            _s.ctx.fillStyle = grd;
            _s.ctx.fillRect(0, 0, _s.canvas.width, _s.canvas.height);
            
            _s.ctx.fillStyle = "rgba(255, 255, 255, " + (_s.intensity * 0.0000125 - 0.4) + ")";
            _s.ctx.fillRect(0, 0, _s.canvas.width, _s.canvas.height);
                
            _s.rot = _s.rot + _s.intensity * 0.0000001;
                
            _s.react_x = 0;
            _s.react_y = 0;
                        
            _s.intensity = 0;
                        
            _s.analyser.getByteFrequencyData(_s.fbc_array);
            
            for (var i = 0; i < _s.bars; i++) {
                var rads = Math.PI * 2 / _s.bars;
                                
                var bar_x = _s.center_x;
                var bar_y = _s.center_y;
            
                var limit =  _s.sH/3;
                if(isNaN(limit)) limit = 10;
                var bar_height = Math.round(_s.fbc_array[i]/256 * limit)
                var bar_width = Math.round(bar_height * 0.02);
                                
                var bar_x_term = _s.center_x + Math.cos(rads * i + _s.rot) * (_s.radius + bar_height);
                var bar_y_term = _s.center_y + Math.sin(rads * i + _s.rot) * (_s.radius + bar_height);
                                
                _s.ctx.save();
                
                var lineColor = _s.audioVisualizerLinesColor_str;
                                
                _s.ctx.strokeStyle = lineColor;
                _s.ctx.lineWidth = bar_width;
                _s.ctx.beginPath();
                _s.ctx.moveTo(bar_x, bar_y);
                _s.ctx.lineTo(bar_x_term, bar_y_term);
                _s.ctx.stroke();
                            
                _s.react_x += Math.cos(rads * i + _s.rot) * (_s.radius + bar_height);
                _s.react_y += Math.sin(rads * i + _s.rot) * (_s.radius + bar_height);
                            
                _s.intensity += bar_height;
            }
                        
            _s.center_x = _s.canvas.width / 2 - (_s.react_x * 0.007);
            _s.center_y = _s.canvas.height / 2 - (_s.react_y * 0.007);
                        
            var radius_old = _s.radius;
            _s.radius =  25 + (_s.intensity * 0.002);
            _s.deltarad = _s.radius - radius_old;
                        
            _s.ctx.fillStyle = _s.audioVisualizerCircleColor_str;
            _s.ctx.beginPath();
            _s.ctx.arc(_s.center_x, _s.center_y, _s.radius + 2, 0, Math.PI * 2, false);
            _s.ctx.fill();
            
            // _s.shockwave effect          
            _s.shockwave += 60;
                        
            _s.ctx.lineWidth = 15;
            _s.ctx.strokeStyle = _s.audioVisualizerCircleColor_str;
            _s.ctx.beginPath();
            _s.ctx.arc(_s.center_x, _s.center_y, _s.shockwave + _s.radius, 0, Math.PI * 2, false);
            _s.ctx.stroke();
                                
            if (_s.deltarad > 15) {
                _s.shockwave = 0;
                
                _s.ctx.fillStyle = "rgba(255, 255, 255, 0.7)";
                _s.ctx.fillRect(0, 0, _s.canvas.width, _s.canvas.height);
                
                _s.rot = _s.rot + 0.4;
            }
            
            _s.startSpectrum();
            
        }
        
        _s.startSpectrum = function(){
            if(!_s.canvas_do) return;
            _s.stopSpectrum();
            _s.spectrumAnimationFrameId = window.requestAnimationFrame(_s.renderSpectrum);
        }
        
        _s.stopSpectrum = function(){
            if(!_s.canvas_do) return;
            cancelAnimationFrame(_s.spectrumAnimationFrameId);
        }

        _s.init();
    };

    /* set prototype */
    FWDUVPAudioScreen.setPrototype = function(){
        FWDUVPAudioScreen.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPAudioScreen.UPDATE_SUBTITLE = "updateSubtitle"
    FWDUVPAudioScreen.ERROR = "error";
    FWDUVPAudioScreen.UPDATE = "update";
    FWDUVPAudioScreen.UPDATE = "update";
    FWDUVPAudioScreen.UPDATE_TIME = "updateTime";
    FWDUVPAudioScreen.SAFE_TO_SCRUBB = "safeToControll";
    FWDUVPAudioScreen.SAFE_TO_UPDATE_VOLUME = "safeToUpdateVolume";
    FWDUVPAudioScreen.LOAD_PROGRESS = "loadProgress";
    FWDUVPAudioScreen.START = "start";
    FWDUVPAudioScreen.PLAY = "play";
    FWDUVPAudioScreen.PAUSE = "pause";
    FWDUVPAudioScreen.STOP = "stop";
    FWDUVPAudioScreen.PLAY_COMPLETE = "playComplete";
    FWDUVPAudioScreen.countAudioContext = 0;
    
    window.FWDUVPAudioScreen = FWDUVPAudioScreen;

}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Categories window.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function(){
var FWDUVPCategories = function(_d, prt){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPCategories.prototype;
        
        _s.image_img;
        _s.catThumbBk_img = _d.catThumbBk_img;
        _s.catNextN_img = _d.catNextN_img;
        _s.catPrevN_img = _d.catPrevN_img;
        _s.catCloseN_img = _d.catCloseN_img;
    
        _s.thumbs_ar = [];
        _s.categories_ar = _d.cats_ar;  
        _s.catBkPath_str = _d.catBkPath_str;
        
        _s.id = 0;
        _s.mouseX = 0;
        _s.mouseY = 0;
        _s.dif = 0;
        _s.tempId = _s.id;
        _s.sW = 0;
        _s.sH = 0;
        _s.thumbW = 0;
        _s.thumbH = 0;
        _s.buttonsMargins = _d.buttonsMargins;
        _s.thumbnailMaxWidth = _d.thumbnailMaxWidth;
        _s.thumbnailMaxHeight = _d.thumbnailMaxHeight;
        _s.spacerH = _d.horizontalSpaceBetweenThumbnails;
        _s.spacerV = _d.verticalSpaceBetweenThumbnails;
        _s.dl;
        _s.howManyThumbsToDisplayH = 0;
        _s.howManyThumbsToDisplayV = 0;
        if(_s.catNextN_img){
            _s.categoriesOffsetTotalWidth = _s.catNextN_img.width * 2 + 40 + _s.buttonsMargins * 2; 
            _s.categoriesOffsetTotalHeight = _s.catNextN_img.height + 40;
        }
        _s.totalThumbnails = _s.categories_ar.length;
        _s.delayRate = .06;
        _s.countLoadedThumbs = 0;
        
        _s.inputBackgroundColor_str = _d.searchInputBackgroundColor_str;
        _s.inputColor_str = _d.searchInputColor_str;
    
        _s.showSearchInpt = _d.showPlaylistsSearchInput_bl;
        _s.isMbl = FWDUVPUtils.isMobile;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
        _s.useVectorIcons_bl = _d.useVectorIcons_bl;


        //##########################################//
        /* initialize */
        //##########################################//
        _s.init = function(){
            _s.screen.className = 'fwduvp fwduvp-categories';
            if(_d.sknPth.indexOf("hex_white") != -1){
                _s.sBC = "#FFFFFF";
            }else{
                _s.sBC = _d.sBC;
            }
            
            _s.getStyle().zIndex = 2147483647;
            _s.getStyle().msTouchAction = "none";
            _s.getStyle().webkitTapHighlightColor = "rgba(0, 0, 0, 0)";
            _s.getStyle().width = "100%";
            
            _s.mainHld = new FWDUVPDisplayObject("div");
            _s.mainHld.screen.className = 'fwduvp-categories-background';
            _s.mainHld.getStyle().background = "url('" + _s.catBkPath_str + "')";
            _s.mainHld.setY(- 3000);
            _s.addChild(_s.mainHld);
            _s.setupButtons();
            _s.setupDisable();
            if(_s.isMbl){
                _s.setupMobileMove();
            }
            
            if(!_s.isMbl || (_s.isMbl && _s.hasPointerEvent_bl)) _s.setSelectable(false);
            
            if(window.addEventListener){
                _s.screen.addEventListener ("mousewheel", _s.mouseWheelDumyHandler);
                _s.screen.addEventListener('DOMMouseScroll', _s.mouseWheelDumyHandler);
            }else if(document.attachEvent){
                _s.screen.attachEvent ("onmousewheel", _s.mouseWheelDumyHandler);
            }
            if(_s.showSearchInpt) _s.setupInput();

        };
        
        _s.mouseWheelDumyHandler = function(e){ 
            var thumb;
            if(FWDAnimation.isTweening(_s.mainHld)){
                if(e.preventDefault){
                    e.preventDefault();
                }
                return false;
            }
            
            for (var i = 0; i<_s.totalThumbnails; i++) {
                thumb = _s.thumbs_ar[i];
                if(FWDAnimation.isTweening(thumb)){
                    if(e.preventDefault){
                        e.preventDefault();
                    }
                    return false;
                }
            }
            
            var dir = e.detail || e.wheelDelta; 
            if(e.wheelDelta) dir *= -1;
            if(FWDUVPUtils.isOpera) dir *= -1;
            
            if(dir > 0){
                _s.nextButtonOnMouseUpHandler();
            }else if(dir < 0){
                if(_s.leftId <= 0) return;
                _s.prevButtonOnMouseUpHandler();
            }
        
        
            if(e.preventDefault){
                e.preventDefault();
            }else{
                return false;
            }
        };
        

        //###########################################//
        // Resize and position.
        //###########################################//
        _s.resizeAndPosition = function(overwrite){
            if(!_s.isShowed_bl && !overwrite) return;
            
            var scrollOffsets = FWDUVPUtils.getScrollOffsets();
            var viewportSize = FWDUVPUtils.getViewportSize();
            
            _s.sW = viewportSize.w;
            _s.sH = viewportSize.h;
            
            FWDAnimation.killTweensOf(_s.mainHld);
            _s.mainHld.setX(0);
            _s.mainHld.setWidth(_s.sW);
            _s.mainHld.setHeight(_s.sH);
            
            _s.setX(scrollOffsets.x);
            _s.setY(scrollOffsets.y);
            
            _s.setHeight(_s.sH);
            if(_s.isMbl || prt.isEmbedded_bl) _s.setWidth(_s.sW);
            _s.positionButtons();
            _s.tempId = _s.id;
            _s.resizeAndPositionThumbnails();
            _s.disableEnableNextAndPrevButtons();
            
            if(_s.input_do){
                _s.input_do.setX(_s.sW - _s.input_do.getWidth() - _s.buttonsMargins);
                _s.input_do.setY(_s.sH - _s.input_do.getHeight() - _s.buttonsMargins);
                _s.inputArrow_do.setX(_s.input_do.x +  _s.input_do.getWidth() - 20);
                _s.inputArrow_do.setY(_s.input_do.y + _s.input_do.getHeight()/2 - _s.inputArrow_do.getHeight()/2 );
            }
        };

        
        //##########################################//
        /* resize and scroll handler */
        //##########################################//
        _s.onScrollHandler = function(){
            var scrollOffsets = FWDUVPUtils.getScrollOffsets();
            _s.setX(scrollOffsets.x);
            _s.setY(scrollOffsets.y);
        };
        

        //################################################//
        /* setup input */
        //################################################//
        _s.setupInput = function(){
            
            _s.input_do = new FWDUVPDisplayObject("input");
            _s.input_do.screen.className = 'fwduvp-search';
            _s.input_do.screen.maxLength = 20;
            _s.input_do.getStyle().textAlign = "left";
            _s.input_do.getStyle().outline = "none";
            _s.input_do.getStyle().boxShadow  = "none";
            _s.input_do.getStyle().fontFamily = "Arial";
            _s.input_do.getStyle().fontSize= "12px";
            _s.input_do.getStyle().padding = "14px 10px";
            _s.input_do.getStyle().boxSizing = 'border-box';
            _s.input_do.getStyle().backgroundColor = _s.inputBackgroundColor_str;
            _s.input_do.getStyle().color = _s.inputColor_str;
            _s.input_do.screen.value = "Search";
            _s.input_do.setHeight(20);
            _s.input_do.setX(18);
            
            _s.noSearchFound_do = new FWDUVPDisplayObject("div");
            _s.noSearchFound_do.screen.className = 'fwduvp-search-not-found';
            _s.noSearchFound_do.setX(0);
            _s.noSearchFound_do.getStyle().textAlign = "center";
            _s.noSearchFound_do.getStyle().width = "100%";
            _s.noSearchFound_do.getStyle().fontFamily = "Arial";
            _s.noSearchFound_do.getStyle().fontSize= "12px";
            _s.noSearchFound_do.getStyle().color = _s.inputColor_str;
            _s.noSearchFound_do.setInnerHTML("NOTHING FOUND!");
            _s.noSearchFound_do.setVisible(false);
            _s.addChild(_s.noSearchFound_do);
            
            var img = new Image();
            img.src = _d.inputArrowPath_str;
            
            _s.inputArrow_do = new FWDUVPDisplayObject("img"); 
            _s.inputArrow_do.setScreen(img);
            _s.inputArrow_do.setWidth(12);
            _s.inputArrow_do.setHeight(12);
            
            if(_s.hasPointerEvent_bl){
                _s.input_do.screen.addEventListener("pointerdown", _s.inputFocusInHandler);
            }else if(_s.input_do.screen.addEventListener){
                _s.input_do.screen.addEventListener("mousedown", _s.inputFocusInHandler);
                _s.input_do.screen.addEventListener("touchstart", _s.inputFocusInHandler);
            }
            
            _s.input_do.screen.addEventListener("keyup", _s.keyUpHandler);
            _s.mainHld.addChild(_s.input_do);
            _s.mainHld.addChild(_s.inputArrow_do);
        };
        
        _s.inputFocusInHandler = function(){
            if(_s.hasInputFocus_bl) return;
            _s.hasInputFocus_bl = true;
            
            if(_s.input_do.screen.value == "Search"){
                _s.input_do.screen.value = "";
            }
            
            _s.input_do.screen.focus();
            
            setTimeout(function(){
                if(_s.hasPointerEvent_bl){
                    window.addEventListener("pointerdown", _s.inputFocusOutHandler);
                }else if(window.addEventListener){
                    window.addEventListener("mousedown", _s.inputFocusOutHandler);
                    window.addEventListener("touchstart", _s.inputFocusOutHandler);
                }
            }, 50);
        };
        
        _s.inputFocusOutHandler = function(e){
            if(!_s.hasInputFocus_bl) return;
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            if(!FWDUVPUtils.hitTest(_s.input_do.screen, vc.screenX, vc.screenY)){
                _s.hasInputFocus_bl = false;
                if(_s.input_do.screen.value == ""){
                    _s.input_do.screen.value = "Search";
                    if(_s.hasPointerEvent_bl){
                        window.removeEventListener("pointerdown", _s.inputFocusOutHandler);
                    }else if(window.removeEventListener){
                        window.removeEventListener("mousedown", _s.inputFocusOutHandler);
                        window.removeEventListener("touchstart", _s.inputFocusOutHandler);
                    }
                }
                return;
            }
        };
        
        _s.keyUpHandler = function(e){
            if(e.stopPropagation) e.stopPropagation();
            if(_s.prevInputValue_str != _s.input_do.screen.value){
                clearTimeout(_s.keyPressedId_to);
                _s.keyPressed_bl = true;
                clearTimeout(_s.rsId_to);
                _s.rsId_to = setTimeout(function(){
                    _s.resizeAndPositionThumbnails(true);
                    _s.disableEnableNextAndPrevButtons();
                }, 400);
            }
            _s.prevInputValue_str = _s.input_do.screen.value;
            _s.keyPressedId_to = setTimeout(function(){
                _s.keyPressed_bl = false;
            }, 450)
        };
        
        _s.showNothingFound = function(){
            if(_s.isShowNothingFound_bl) return;
            
            _s.isShowNothingFound_bl = true;
            
            _s.noSearchFound_do.setVisible(true);
            _s.noSearchFound_do.setY(parseInt((_s.sH - _s.noSearchFound_do.getHeight())/2));
            _s.noSearchFound_do.setAlpha(0);
            FWDAnimation.to(_s.noSearchFound_do, .1, {alpha:1, yoyo:true, repeat:4});
        };
        
        _s.hideNothingFound = function(){
            if(!_s.isShowNothingFound_bl) return;
            _s.isShowNothingFound_bl = false;
            
            FWDAnimation.killTweensOf(_s.noSearchFound_do);
            _s.noSearchFound_do.setVisible(false);
        };
        

        //###############################//
        /* setup disable */
        //##############################//
        _s.setupDisable = function(){
            _s.disable_do = new FWDUVPDisplayObject("div");
            if(FWDUVPUtils.isIE){
                _s.disable_do.setBkColor("#FFFFFF");
                _s.disable_do.setAlpha(0.01);
            }
            _s.addChild(_s.disable_do);
        };
        
        _s.showDisable = function(){
            if(_s.disable_do.w == _s.sW) return;
            _s.disable_do.setWidth(_s.sW);
            _s.disable_do.setHeight(_s.sH);
        };
        
        _s.hideDisable = function(){
            if(_s.disable_do.w == 0) return;
            _s.disable_do.setWidth(0);
            _s.disable_do.setHeight(0);
        };

        
        //############################################//
        /* setup buttons */
        //############################################//
        _s.setupButtons = function(){
            if(_s.clsBtn) return;

            //setup close button
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.clsBtn = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<div class='table-fwduvp-button'><span class='table-cell-fwduvp-button fwdicon-close'></span></div>",
                        undefined,
                        "UVPCategoriesNextAndPrevNormalState",
                        "UVPCategoriesNextAndPrevSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.clsBtn = new FWDUVPSimpleButton(_s.catCloseN_img, _d.catCloseSPath_str, undefined,
                        true,
                        _d.useHEX,
                        _d.nBC,
                        _s.sBC,
                        false, false, false, false, true);

            }
            _s.clsBtn.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.closeButtonOnMouseUpHandler);
            
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.nextButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<div class='table-fwduvp-button'><span class='table-cell-fwduvp-button fwdicon-FF-right'></span></div>",
                        undefined,
                        "UVPCategoriesNextAndPrevNormalState",
                        "UVPCategoriesNextAndPrevSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.nextButton_do = new FWDUVPSimpleButton(_s.catNextN_img, _d.catNextSPath_str, undefined,
                        true,
                        _d.useHEX,
                        _d.nBC,
                        _s.sBC,
                        false, false, false, false, true);
            }
            _s.nextButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.nextButtonOnMouseUpHandler);
            
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.prevButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<div class='table-fwduvp-button'><span class='table-cell-fwduvp-button fwdicon-FF-left'></span></div>",
                        undefined,
                        "UVPCategoriesNextAndPrevNormalState",
                        "UVPCategoriesNextAndPrevSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.prevButton_do = new FWDUVPSimpleButton(_s.catPrevN_img, _d.catPrevSPath_str, undefined,
                        true,
                        _d.useHEX,
                        _d.nBC,
                        _s.sBC,
                        false, false, false, false, true);
            }
            _s.prevButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.prevButtonOnMouseUpHandler);
        };
        
        _s.closeButtonOnMouseUpHandler = function(){
             _s.hide();
        };
        
        _s.nextButtonOnMouseUpHandler = function(){
            var availableThumbsPerSection = (_s.howManyThumbsToDisplayH * _s.howManyThumbsToDisplayV);
            _s.tempId += availableThumbsPerSection;
            if(_s.tempId > _s.totalThumbnails - 1) _s.tempId = _s.totalThumbnails - 1;
            var curSet = Math.floor(_s.tempId / availableThumbsPerSection);
            _s.tempId = curSet * availableThumbsPerSection;
            _s.resizeAndPositionThumbnails(true, "next");
            _s.disableEnableNextAndPrevButtons(false, true);
        };
        
        _s.prevButtonOnMouseUpHandler = function(){
            var availableThumbsPerSection = (_s.howManyThumbsToDisplayH * _s.howManyThumbsToDisplayV);
            _s.tempId -= availableThumbsPerSection;
            if(_s.tempId < 0) _s.tempId = 0;
            var curSet = Math.floor(_s.tempId / availableThumbsPerSection);
            _s.tempId = curSet * availableThumbsPerSection;
            _s.resizeAndPositionThumbnails(true, "prev");
            _s.disableEnableNextAndPrevButtons(true, false);
        };
        
        _s.positionButtons = function(){
            _s.clsBtn.setX(_s.sW - _s.clsBtn.w - _s.buttonsMargins);
            _s.clsBtn.setY(_s.buttonsMargins);
            _s.nextButton_do.setX(_s.sW - _s.nextButton_do.w - _s.buttonsMargins);
            _s.nextButton_do.setY(parseInt((_s.sH - _s.nextButton_do.h)/2));
            _s.prevButton_do.setX(_s.buttonsMargins);
            _s.prevButton_do.setY(parseInt((_s.sH - _s.prevButton_do.h)/2));
        };
        
        _s.disableEnableNextAndPrevButtons = function(hitTestLeft, hitTestRight){
            var availableThumbsPerSection = (_s.howManyThumbsToDisplayH * _s.howManyThumbsToDisplayV);
            var curSet = Math.floor(_s.tempId / availableThumbsPerSection);
            var totalSets = Math.ceil(_s.totalThumbnails / availableThumbsPerSection) - 1;
            var currentLeftColId = _s.howManyThumbsToDisplayH * curSet;
            var maxId = totalSets * _s.howManyThumbsToDisplayH;
        
            if(availableThumbsPerSection >= _s.totalThumbnails){
                _s.nextButton_do.disable();
                _s.prevButton_do.disable();
                _s.nextButton_do.setDisabledState();
                _s.prevButton_do.setDisabledState();
            }else if(curSet == 0){
                _s.nextButton_do.enable();
                _s.prevButton_do.disable();
                _s.nextButton_do.setEnabledState();
                _s.prevButton_do.setDisabledState();
            }else if(curSet == totalSets){
                _s.nextButton_do.disable();
                _s.prevButton_do.enable();
                _s.nextButton_do.setDisabledState();
                _s.prevButton_do.setEnabledState();
            }else{
                _s.nextButton_do.enable();
                _s.prevButton_do.enable();
                _s.nextButton_do.setEnabledState();
                _s.prevButton_do.setEnabledState();
            }
            
            if(!hitTestLeft){
                _s.prevButton_do.setNormalState();
            }
            
            if(!hitTestRight){
                _s.nextButton_do.setNormalState();
            }
        };
        
        //##########################################//
        /* setup mobile scrollbar */
        //##########################################//
        _s.setupMobileMove = function(){    
            if(_s.hasPointerEvent_bl){
                _s.screen.addEventListener("pointerdown", _s.mobileDownHandler);
            }else{
                _s.screen.addEventListener("touchstart", _s.mobileDownHandler);
            }
        };
        
        _s.mobileDownHandler = function(e){
            if (e.touches) if(e.touches.length != 1) return;
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            _s.mouseX = vc.screenX;;
            _s.mouseY = vc.screenY;
            if(_s.hasPointerEvent_bl){
                window.addEventListener("pointerup", _s.mobileUpHandler);
                window.addEventListener("pointermove", _s.mobileMoveHandler);
            }else{
                window.addEventListener("touchend", _s.mobileUpHandler);
                window.addEventListener("touchmove", _s.mobileMoveHandler, {passive:false});
            }
        };
        
        _s.mobileMoveHandler = function(e){
            if(e.preventDefault) e.preventDefault();
            if (e.touches) if(e.touches.length != 1) return;
            _s.showDisable();
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);
            _s.dif = _s.mouseX - vc.screenX;
            _s.mouseX = vc.screenX;
            _s.mouseY = vc.screenY;
        };
        
        _s.mobileUpHandler = function(e){
            _s.hideDisable();
            if(_s.dif > 10){
                _s.nextButtonOnMouseUpHandler();
            }else if(_s.dif < -10){
                _s.prevButtonOnMouseUpHandler();
            }
            _s.dif = 0;
            
            if(_s.hasPointerEvent_bl){
                window.removeEventListener("pointerup", _s.mobileUpHandler);
                window.removeEventListener("pointermove", _s.mobileMoveHandler);
            }else{
                window.removeEventListener("touchend", _s.mobileUpHandler);
                window.removeEventListener("touchmove", _s.mobileMoveHandler);
            }
        };
        

        //######################################//
        /* setup thumbnails */
        //######################################//
        _s.setupThumbnails = function(){
            if(_s.areThumbnailsCreated_bl) return;

            _s.areThumbnailsCreated_bl = true;
            var thumb;
            for(var i=0; i<_s.totalThumbnails; i++){
                FWDUVPCategoriesThumb.setPrototype();
                thumb = new FWDUVPCategoriesThumb(_s,
                        i,
                        _d.catThumbBkPath_str,
                        _d.catThumbBkTextPath_str,
                        _d.thumbnailSelectedType_str, 
                        _s.categories_ar[i].htmlContent,
                        _s.categories_ar[i].htmlText_str);
                thumb.addListener(FWDUVPCategoriesThumb.MOUSE_UP, _s.thumbnailOnMouseUpHandler);
                _s.thumbs_ar[i] = thumb;
                _s.mainHld.addChild(thumb);
            }
            _s.mainHld.addChild(_s.clsBtn); 
            _s.mainHld.addChild(_s.nextButton_do); 
            _s.mainHld.addChild(_s.prevButton_do);
        };
        
        _s.thumbnailOnMouseUpHandler = function(e){
            _s.id = e.id;
            _s.disableOrEnableThumbnails();
            _s.hide();
        };
        

        //#############################################//
        /* set _d for resize */
        //#############################################//
        _s.resizeAndPositionThumbnails = function(animate, direction){
            if(!_s.areThumbnailsCreated_bl) return;
            var thumb;
            var totalWidth;
            var curSet;
            var tempSet;
            var newX;
            var newY;
            var totalWidth;
            var totalHeight;
            var remainWidthSpace;
            var firsId;
            var lastId;
            var addToX;
            var currentLeftColId;
            var availableThumbsPerSection;
            
            var copy_ar = [].concat(_s.thumbs_ar);
            _s.isSearched_bl = false;
        
            if(_s.input_do){
                var inputValue = _s.input_do.screen.value.toLowerCase();
                if(inputValue != "Search".toLowerCase()){
                    for(var i=0; i<copy_ar.length; i++){
                        thumb = copy_ar[i];
                        if(thumb.htmlText_str.toLowerCase().indexOf(inputValue.toLowerCase()) == -1){
                            FWDAnimation.killTweensOf(thumb);
                            thumb.hide();
                            copy_ar.splice(i, 1);
                            i--;
                        }
                    }
                }
            }
        
            _s.totalThumbnails = copy_ar.length;
            if(_s.totalThumbnails != _s.thumbs_ar.length) _s.isSearched_bl = true;
            
            if(_s.totalThumbnails == 0){
                _s.showNothingFound();
            }else{
                _s.hideNothingFound();
            }
            
            _s.remainWidthSpace = (_s.sW - totalWidth);
            
            var widthToResize = _s.sW - _s.categoriesOffsetTotalWidth;
            var heightToResize = _s.sH - _s.categoriesOffsetTotalHeight;
            
            _s.howManyThumbsToDisplayH = Math.ceil((widthToResize - _s.spacerH)/(_s.thumbnailMaxWidth + _s.spacerH));
            _s.thumbW = Math.floor(((widthToResize - _s.spacerH * (_s.howManyThumbsToDisplayH - 1)))/_s.howManyThumbsToDisplayH);
            if(_s.thumbW > _s.thumbnailMaxWidth){
                _s.howManyThumbsToDisplayH += 1;
                _s.thumbW = Math.floor(((widthToResize - _s.spacerH * (_s.howManyThumbsToDisplayH - 1)))/_s.howManyThumbsToDisplayH);
            }
            
            _s.thumbH = Math.floor((_s.thumbW/_s.thumbnailMaxWidth) * _s.thumbnailMaxHeight);
            
            _s.howManyThumbsToDisplayV = Math.floor(heightToResize/(_s.thumbH + _s.spacerV));
            if(_s.howManyThumbsToDisplayV < 1) _s.howManyThumbsToDisplayV = 1;
            
            totalWidth = (Math.min(_s.howManyThumbsToDisplayH, _s.totalThumbnails) * (_s.thumbW + _s.spacerH)) - _s.spacerH;
            totalHeight = Math.min(Math.ceil(_s.totalThumbnails/_s.howManyThumbsToDisplayH), _s.howManyThumbsToDisplayV) * (_s.thumbH + _s.spacerV) - _s.spacerV;
            
            if(_s.howManyThumbsToDisplayH > _s.totalThumbnails){
                remainWidthSpace = 0;
            }else{
                remainWidthSpace = (widthToResize - totalWidth);
            }
            
            if(_s.howManyThumbsToDisplayH > _s.totalThumbnails) _s.howManyThumbsToDisplayH = _s.totalThumbnails;
            availableThumbsPerSection = (_s.howManyThumbsToDisplayH * _s.howManyThumbsToDisplayV);
    
            curSet = Math.floor(_s.tempId / availableThumbsPerSection);
            if(_s.isSearched_bl) curSet = 0;
            currentLeftColId = _s.howManyThumbsToDisplayH * curSet;
            
            var firstId = curSet * availableThumbsPerSection;
            
            var lastId = firstId + availableThumbsPerSection;
            if(lastId > _s.totalThumbnails)  lastId = _s.totalThumbnails;
            
            for (var i = 0; i<_s.totalThumbnails; i++) {
                
                thumb = copy_ar[i];
                
                thumb.finalW = _s.thumbW;
                if(i % _s.howManyThumbsToDisplayH == _s.howManyThumbsToDisplayH - 1) thumb.finalW += remainWidthSpace;
                thumb.finalH = _s.thumbH;
                
                thumb.finalX = (i % _s.howManyThumbsToDisplayH) * (_s.thumbW + _s.spacerH);
                thumb.finalX += Math.floor((i / availableThumbsPerSection)) * _s.howManyThumbsToDisplayH * (_s.thumbW + _s.spacerH);
                thumb.finalX += (_s.sW - totalWidth)/2;
                thumb.finalX = Math.floor(thumb.finalX - currentLeftColId * (_s.thumbW + _s.spacerH));
                
                thumb.finalY = i % availableThumbsPerSection;
                thumb.finalY = Math.floor((thumb.finalY / _s.howManyThumbsToDisplayH)) * (_s.thumbH + _s.spacerV);
                thumb.finalY += (heightToResize - totalHeight)/2;
                thumb.finalY += _s.categoriesOffsetTotalHeight/2;
                thumb.finalY = Math.floor(thumb.finalY);
                
                tempSet = Math.floor((i / availableThumbsPerSection));
            
                if(tempSet > curSet){
                    thumb.finalX += 150;
                }else if(tempSet < curSet){
                    thumb.finalX -= 150;
                }
                
                if(animate){
                    if ((i >= firstId) && (i < lastId)){
                        if(direction == "next"){
                            var dl = (i % availableThumbsPerSection) * _s.delayRate + .1;
                        }else{
                            var dl = (availableThumbsPerSection -  (i % availableThumbsPerSection)) * _s.delayRate + .1;
                        }
                        if(_s.keyPressed_bl) dl = 0;
                        thumb.resizeAndPosition(true, dl);
                    }else{
                        thumb.resizeAndPosition(true, 0);
                    }
                    
                }else{
                    thumb.resizeAndPosition();
                }   
                thumb.show();
            }
            if((_s.howManyThumbsToDisplayH * _s.howManyThumbsToDisplayV) >= _s.totalThumbnails){
                _s.nextButton_do.setVisible(false);
                _s.prevButton_do.setVisible(false);
                
            }else{
                _s.nextButton_do.setVisible(true);
                _s.prevButton_do.setVisible(true);
                
            }
        };
        

        //#############################################//
        /* load images */
        //#############################################//
        _s.loadImages = function(){

            if(_s.countLoadedThumbs > _s.totalThumbnails-1) return;
            
            if(_s.image_img){
                _s.image_img.onload = null;
                _s.image_img.onerror = null;
            }
            
            _s.image_img = new Image();
            _s.image_img.onerror = _s.onImageLoadError;
            _s.image_img.onload = _s.onImageLoadComplete;
            _s.image_img.src = _s.categories_ar[_s.countLoadedThumbs].thumbnailPath;
        };
        
        _s.onImageLoadError = function(e){};
        
        _s.onImageLoadComplete = function(e){
            var thumb = _s.thumbs_ar[_s.countLoadedThumbs];
            thumb.setImage(_s.image_img);
            _s.countLoadedThumbs++;
            _s.loadWithDelayId_to = setTimeout(_s.loadImages, 40);  
        };

        
        //###########################################//
        /* disable / enable thumbnails */
        //###########################################//
        _s.disableOrEnableThumbnails = function(){
            var thumb;
            for(var i = 0; i<_s.totalThumbnails; i++) {
                thumb = _s.thumbs_ar[i];    
                if(i == _s.id){
                    thumb.disable();
                }else{
                    thumb.enable();
                }
            }
        };
        

        //###########################################//
        /* show / hide */
        //###########################################//
        _s.show = function(id){
            if(_s.isShowed_bl) return;
            _s.isShowed_bl = true;
            _s.isOnDOM_bl = true;
            _s.id = id;
            
            if(prt.isFullScreen_bl){
                prt.main_do.addChild(_s);
            }else{
                document.documentElement.appendChild(_s.screen);
            }   
                    
            if(window.addEventListener){
                window.addEventListener("scroll", _s.onScrollHandler);
            }else if(window.attachEvent){
                window.attachEvent("onscroll", _s.onScrollHandler);
            }
                
            _s.setupThumbnails();   
            
            if(_s.useVectorIcons_bl){
            
                _s.clsBtn.setFinalSize(true);
                _s.nextButton_do.setFinalSize(true);
                _s.prevButton_do.setFinalSize(true);

                _s.checkButtonsId_to = setInterval(function(){
                    if(_s.clsBtn.w != 0){
                        _s.categoriesOffsetTotalWidth = _s.clsBtn.w * 2 + 40 + _s.buttonsMargins * 2;
                        _s.categoriesOffsetTotalHeight = _s.clsBtn.h;
                        _s.resizeAndPosition(true);
                        _s.showDisable();
                        _s.disableOrEnableThumbnails();
                        clearTimeout(_s.hideCompleteId_to);
                        clearTimeout(_s.showCompleteId_to);
                        _s.mainHld.setY(- _s.sH);
                        
                        if(_s.isMbl){
                            _s.showCompleteId_to = setTimeout(_s.showCompleteHandler, 1200);
                            FWDAnimation.to(_s.mainHld, .8, {y:0, delay:.4, ease:Expo.easeInOut});
                        }else{
                            _s.showCompleteId_to = setTimeout(_s.showCompleteHandler, 800);
                            FWDAnimation.to(_s.mainHld, .8, {y:0, ease:Expo.easeInOut});
                        }
                    
                        clearInterval(_s.checkButtonsId_to);
                    }
                
                }, 50);
            }else{
                _s.resizeAndPosition(true);
                _s.showDisable();
                _s.disableOrEnableThumbnails();
                clearTimeout(_s.hideCompleteId_to);
                clearTimeout(_s.showCompleteId_to);
                _s.mainHld.setY(- _s.sH);
                
                if(_s.isMbl){
                    _s.showCompleteId_to = setTimeout(_s.showCompleteHandler, 1200);
                    FWDAnimation.to(_s.mainHld, .8, {y:0, delay:.4, ease:Expo.easeInOut});
                }else{
                    _s.showCompleteId_to = setTimeout(_s.showCompleteHandler, 800);
                    FWDAnimation.to(_s.mainHld, .8, {y:0, ease:Expo.easeInOut});
                }
                
            }
        };
        
        _s.showCompleteHandler = function(){
            _s.mainHld.setY(0);
            _s.hideDisable();
            if(FWDUVPUtils.isIphone){
                if(prt.videoScreen_do) prt.videoScreen_do.setY(-5000);
                if(prt.ytb_do) prt.ytb_do.setY(-5000);
            }
            _s.resizeAndPosition(true);
            if(!_s.areThumbnailsLoaded_bl){
                _s.loadImages();
                _s.areThumbnailsLoaded_bl = true;
            }
        };
        
        _s.hide = function(){
            if(!_s.isShowed_bl) return;
            _s.isShowed_bl = false;
            
            if(FWDUVPUtils.isIphone){
                if(prt.videoScreen_do) prt.videoScreen_do.setY(0);
                if(prt.ytb_do) prt.ytb_do.setY(0);
            }
            
            clearTimeout(_s.hideCompleteId_to);
            clearTimeout(_s.showCompleteId_to);
            _s.showDisable();
            _s.hideCompleteId_to = setTimeout(_s.hideCompleteHandler, 800);
            FWDAnimation.killTweensOf(_s.mainHld);
            FWDAnimation.to(_s.mainHld, .8, {y:-_s.sH, ease:Expo.easeInOut});
            
            if(window.addEventListener){
                window.removeEventListener("scroll", _s.onScrollHandler);
            }else if(window.detachEvent){
                window.detachEvent("onscroll", _s.onScrollHandler);
            }
            _s.resizeAndPosition();
        };
        
        _s.hideCompleteHandler = function(){
            
            if(prt.main_do.contains(_s)){
                prt.main_do.removeChild(_s);
            }else{
                document.documentElement.removeChild(_s.screen);
            }   
            
            _s.isOnDOM_bl = false;
            _s.dispatchEvent(FWDUVPCategories.HIDE_COMPLETE);
        };
        
        _s.init();
    };
    
    
    /* set prototype */
    FWDUVPCategories.setPrototype = function(){
        FWDUVPCategories.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPCategories.HIDE_COMPLETE = "hideComplete";

    FWDUVPCategories.prototype = null;
    window.FWDUVPCategories = FWDUVPCategories;
    
}());/**
 * Ultimate Video Player PACKAGED v9.1
 * Categories thumbnail.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
    var FWDUVPCategoriesThumb = function(
            prt,
            pId, 
            catThumbBkTextPath_str,
            catThumbTextBkPath_str,
            thumbnailSelectedType_str,
            htmlContent,
            htmlText
        ){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPCategoriesThumb.prototype;
    
        _s.backgroundImagePath_str = catThumbBkTextPath_str;
        _s.catThumbTextBkPath_str = catThumbTextBkPath_str;
        _s.canvas_el = null;
        _s.htmlContent = htmlContent;
        _s.htmlText_str = htmlText;
        _s.thumbnailSelectedType_str = thumbnailSelectedType_str;
        
        _s.id = pId;
        
        _s.isDark = true;
        if(catThumbBkTextPath_str.indexOf('dark') == -1){
            _s.isDark = false;
        }
        
        _s.dispatchShowWithDelayId_to;
        _s.hasCanvas_bl = FWDUVPlayer.hasCanvas;
        _s.isMbl = FWDUVPUtils.isMobile;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;

        _s.init = function(){
            _s.getStyle().background = "url('" + _s.backgroundImagePath_str + "')";
            _s.screen.className = 'fwduvp-categories-thumbnail-background';
            _s.setupMainContainers();
            _s.setupDescription();
            _s.setupDumy();
        };

        
        //#################################//
        /* set image */
        //#################################//
        _s.setupMainContainers = function(){
            _s.imageHolder_do = new FWDUVPDisplayObject("div");
            _s.addChild(_s.imageHolder_do);
        };
        

        //#################################//
        /* setup dumy */
        //#################################//
        _s.setupDumy = function(){
            _s.dumy_do = new FWDUVPDisplayObject("div");
            if(FWDUVPUtils.isIE){
                _s.dumy_do.setBkColor("#FFFFFF");
                _s.dumy_do.setAlpha(0);
            }
            _s.addChild(_s.dumy_do);
        };
        

        //################################################//
        /* Setup title bar */
        //###############################################//
        _s.setupDescription = function(){
            _s.simpleText_do = new FWDUVPDisplayObject("div");
            _s.simpleText_do.getStyle().background = "url('" + _s.catThumbTextBkPath_str + "')";
            var cls = 'fwduvp-categories-white-text';
            if(_s.isDark){
                cls = 'fwduvp-categories-dark-text';
            }
            _s.simpleText_do.screen.className = cls;
            _s.slTitle = _s.simpleText_do.screen.className;

            if(FWDUVPUtils.isFirefox){
                _s.simpleText_do.hasTransform3d_bl = false;
                _s.simpleText_do.hasTransform2d_bl = false;
            }
            _s.simpleText_do.setBackfaceVisibility();
            _s.simpleText_do.getStyle().width = "100%";
            _s.simpleText_do.getStyle().fontFamily = "Arial";
            _s.simpleText_do.getStyle().fontSize= "12px";
            _s.simpleText_do.getStyle().textAlign = "left";
            _s.simpleText_do.getStyle().color = "#FFFFFF";  
            _s.simpleText_do.setInnerHTML(_s.htmlContent);
            _s.addChild(_s.simpleText_do);
        };
        
        _s.positionDescription = function(){
            _s.simpleText_do.setY(parseInt(_s.finalH - _s.simpleText_do.getHeight()));
        };

        
        //#################################//
        /* setup black an white image */
        //#################################//
        _s.setupBlackAndWhiteImage = function(image){
            if(!_s.hasCanvas_bl || _s.thumbnailSelectedType_str == "opacity") return;
            var canvas = document.createElement("canvas");

            var ctx = canvas.getContext("2d");
            
            canvas.width = _s.imageOriginalW;
            canvas.height = _s.imageOriginalH; 
            ctx.drawImage(image, 0, 0); 
            
            var imgPixels = ctx.getImageData(0, 0, canvas.width, canvas.height);
            
            var d = imgPixels._d;
            
            if(_s.thumbnailSelectedType_str == "threshold"){
                //treshhold
                for (var i=0; i<d.length; i+=4) {
                    var r = d[i];
                    var g = d[i+1];
                    var b = d[i+2];
                    var v = (0.2126*r + 0.7152*g + 0.0722*b >= 150) ? 255 : 0;
                    d[i] = d[i+1] = d[i+2] = v;
                }
            }else if(_s.thumbnailSelectedType_str == "blackAndWhite"){
                //grayscale
                for (var i=0; i<d.length; i+=4) {
                    var r = d[i];
                    var g = d[i+1];
                    var b = d[i+2];
                    // CIE luminance for the RGB
                    // The human eye is bad at seeing red and blue, so we de-emphasize them.
                    var v = 0.2126*r + 0.7152*g + 0.0722*b;
                    d[i] = d[i+1] = d[i+2] = v;
                }
            }
        
            ctx.putImageData(imgPixels, 0, 0, 0, 0, imgPixels.width, imgPixels.height);
            
            _s.effectImage_do = new FWDUVPDisplayObject("canvas");
            _s.effectImage_do.screen = canvas;
            _s.effectImage_do.setAlpha(.9);
            
            _s.effectImage_do.setMainProperties();
        };

    
        //#################################//
        /* set image */
        //#################################//
        _s.setImage = function(image){
            _s.normalImage_do = new FWDUVPDisplayObject("img");
            _s.normalImage_do.setScreen(image);
            
            _s.imageOriginalW = _s.normalImage_do.w;
            _s.imageOriginalH = _s.normalImage_do.h;
            
            _s.setButtonMode(true);
            _s.setupBlackAndWhiteImage(image);
            
            _s.resizeImage();
            
            _s.imageHolder_do.setX(parseInt(_s.finalW/2));
            _s.imageHolder_do.setY(parseInt(_s.finalH/2));
            _s.imageHolder_do.setWidth(0);
            _s.imageHolder_do.setHeight(0);
            
            _s.normalImage_do.setX(- parseInt(_s.normalImage_do.w/2));
            _s.normalImage_do.setY(- parseInt(_s.normalImage_do.h/2));
            _s.normalImage_do.setAlpha(0);
            
            if(_s.effectImage_do){
                _s.effectImage_do.setX(- parseInt(_s.normalImage_do.w/2));
                _s.effectImage_do.setY(- parseInt(_s.normalImage_do.h/2));
                _s.effectImage_do.setAlpha(0.01);
            }
            
            FWDAnimation.to(_s.imageHolder_do, .8, {
                x:0, 
                y:0,
                w:_s.finalW,
                h:_s.finalH, 
                ease:Expo.easeInOut});
            
            FWDAnimation.to(_s.normalImage_do, .8, {
                alpha:1,
                x:_s.imageFinalX, 
                y:_s.imageFinalY, 
                ease:Expo.easeInOut});
            
            if(_s.effectImage_do){
                FWDAnimation.to(_s.effectImage_do, .8, {
                    x:_s.imageFinalX, 
                    y:_s.imageFinalY, 
                    ease:Expo.easeInOut});
            }
            
            if(_s.hasPointerEvent_bl){
                _s.screen.addEventListener("pointerup", _s.onMouseUp);
                _s.screen.addEventListener("pointerover", _s.onMouseOver);
                _s.screen.addEventListener("pointerout", _s.onMouseOut);
            }else if(_s.screen.addEventListener){   
                if(!_s.isMbl){
                    _s.screen.addEventListener("mouseover", _s.onMouseOver);
                    _s.screen.addEventListener("mouseout", _s.onMouseOut);
                    _s.screen.addEventListener("mouseup", _s.onMouseUp);
                }
                _s.screen.addEventListener("touchend", _s.onMouseUp);
            }
        
            _s.imageHolder_do.addChild(_s.normalImage_do);
            if(_s.effectImage_do) _s.imageHolder_do.addChild(_s.effectImage_do);
            
            _s.hasImage_bl = true;
            
            if(_s.id == prt.id){
                _s.disable();
            }
            
        };
        
        _s.onMouseOver = function(e, animate){
            if(_s.isDisabled_bl) return;
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE){
                _s.setSelectedState(true);
            }
        };
            
        _s.onMouseOut = function(e){
            if(_s.isDisabled_bl) return;
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE){
                _s.setNormalState(true);
            }
        };
        
        _s.onMouseUp = function(e){
            if(_s.isDisabled_bl || e.button == 2) return;
            if(e.preventDefault) e.preventDefault();
            _s.dispatchEvent(FWDUVPCategoriesThumb.MOUSE_UP, {id:_s.id});
        };

    
        //#################################//
        /* resize thumbnail*/
        //#################################//
        _s.resizeAndPosition = function(animate, dl){
            
            FWDAnimation.killTweensOf(_s);
            FWDAnimation.killTweensOf(_s.imageHolder_do);
            
            if(animate){
                FWDAnimation.to(_s, .8, {
                    x:_s.finalX, 
                    y:_s.finalY,
                    delay:dl,
                    ease:Expo.easeInOut});
            }else{
                _s.setX(_s.finalX);
                _s.setY(_s.finalY);
            }
            
            _s.setWidth(_s.finalW);
            _s.setHeight(_s.finalH);
            _s.imageHolder_do.setX(0);
            _s.imageHolder_do.setY(0);
            _s.imageHolder_do.setWidth(_s.finalW);
            _s.imageHolder_do.setHeight(_s.finalH);
            
            _s.dumy_do.setWidth(_s.finalW);
            _s.dumy_do.setHeight(_s.finalH);
            
            _s.resizeImage();
            _s.positionDescription();
        };
    

        //#################################//
        /* resize image*/
        //#################################//
        _s.resizeImage = function(animate){
            
            if(!_s.normalImage_do) return;
            FWDAnimation.killTweensOf(_s.normalImage_do);
            var scX = _s.finalW/_s.imageOriginalW;
            var scY = _s.finalH/_s.imageOriginalH;
            var ttsc;
            
            if(scX >= scY){
                ttsc = scX;
            }else{
                ttsc = scY;
            }
            
            _s.imageFinalW = Math.ceil(ttsc * _s.imageOriginalW);
            _s.imageFinalH = Math.ceil(ttsc * _s.imageOriginalH);
            _s.imageFinalX = Math.round((_s.finalW - _s.imageFinalW)/2);
            _s.imageFinalY = Math.round((_s.finalH - _s.imageFinalH)/2);
            
            if(_s.effectImage_do){
                FWDAnimation.killTweensOf(_s.effectImage_do);
                _s.effectImage_do.setX(_s.imageFinalX);
                _s.effectImage_do.setY(_s.imageFinalY);
                _s.effectImage_do.setWidth(_s.imageFinalW);
                _s.effectImage_do.setHeight(_s.imageFinalH);
                if(_s.isDisabled_bl) _s.setSelectedState(false, true);
            }
            
            _s.normalImage_do.setX(_s.imageFinalX);
            _s.normalImage_do.setY(_s.imageFinalY);
            _s.normalImage_do.setWidth(_s.imageFinalW + 1);
            _s.normalImage_do.setHeight(_s.imageFinalH);
            
            if(_s.isDisabled_bl){
                _s.normalImage_do.setAlpha(.3);
            }else{
                _s.normalImage_do.setAlpha(1);
            }
        };
        

        //##############################//
        /* set normal/selected state*/
        //##############################//
        _s.setNormalState = function(animate){
            if(!_s.isSelected_bl) return;
            _s.isSelected_bl = false;
            if(_s.slTitle){
                _s.simpleText_do.screen.className = _s.slTitle;
            }

            if(_s.thumbnailSelectedType_str == "threshold" || _s.thumbnailSelectedType_str == "blackAndWhite"){
                if(animate){
                    FWDAnimation.to(_s.effectImage_do, 1, {alpha:.01, ease:Quart.easeOut});
                }else{
                    _s.effectImage_do.setAlpha(.01);
                }
            }else if(_s.thumbnailSelectedType_str == "opacity"){
                if(animate){
                    FWDAnimation.to(_s.normalImage_do, 1, {alpha:1, ease:Quart.easeOut});
                }else{
                    _s.normalImage_do.setAlpha(1);
                }
            }
        };
        
        _s.setSelectedState = function(animate, overwrite){
            if(_s.isSelected_bl && !overwrite) return;
            _s.isSelected_bl = true;
            _s.setTitleSelectedClass();
            if(_s.thumbnailSelectedType_str == "threshold" || _s.thumbnailSelectedType_str == "blackAndWhite"){
                if(animate){
                    FWDAnimation.to(_s.effectImage_do, 1, {alpha:1, ease:Expo.easeOut});
                }else{
                    _s.effectImage_do.setAlpha(1);
                }
            }else if(_s.thumbnailSelectedType_str == "opacity"){
                if(animate){
                    FWDAnimation.to(_s.normalImage_do, 1, {alpha:.3, ease:Expo.easeOut});
                }else{
                    _s.normalImage_do.setAlpha(.3);
                }
            }
        };
        

        //###############################//
        /* Hide / show */
        //###############################//
        _s.show = function(){
            FWDAnimation.to(_s, .8, {scale:1, ease:Expo.easeInOut});
        }
        
        _s.hide = function(){
            FWDAnimation.to(_s, .8, {scale:0, ease:Expo.easeInOut});
        }
        

        //###############################//
        /* enable / disable */
        //##############################//
        _s.enable = function(){
            if(!_s.hasImage_bl) return;
            _s.isDisabled_bl = false;
            _s.setButtonMode(true);
            _s.setNormalState(true);
        };
        
        _s.disable = function(){
            if(!_s.hasImage_bl) return;
            _s.isDisabled_bl = true;
            _s.setButtonMode(false);
            _s.setSelectedState(true);
            _s.setTitleSelectedClass();
        };

        _s.setTitleSelectedClass = function(){
            if(_s.slTitle){
                _s.simpleText_do.screen.className = _s.slTitle  + ' active';
            }
        }
    
        _s.init();
    };
    
    
    /* set prototype */
    FWDUVPCategoriesThumb.setPrototype = function(){
        FWDUVPCategoriesThumb.prototype = new FWDUVPTransformDisplayObject("div");
    };
    
    
    FWDUVPCategoriesThumb.MOUSE_UP = "onMouseUp";
    
    FWDUVPCategoriesThumb.prototype = null;
    window.FWDUVPCategoriesThumb = FWDUVPCategoriesThumb;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Playlist select box.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
    
    var FWDUVPComboBox = function(prt, props_obj){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPComboBox.prototype;
        
        _s.categories_ar = props_obj.categories_ar;
        _s.buttons_ar = [];
        
        _s.arrowW = props_obj.arrowW;
        _s.arrowH = props_obj.arrowH;
        
        _s.useHEX = prt._d.useHEX; 
        _s.nBC = prt._d.nBC;
        _s.sBC = prt._d.sBC;
    
        _s.arrowN_str = props_obj.arrowN_str 
        _s.arrowS_str = props_obj.arrowS_str;
        
        _s.selLabel = props_obj.selectorLabel;
        _s.selBkColN = props_obj.selectorBackgroundNormalColor;
        _s.selBkColS = props_obj.selectorBackgroundSelectedColor;
        _s.selTxtColN = props_obj.selectorTextNormalColor;
        _s.selTxtColS = props_obj.selectorTextSelectedColor;
        
        _s.itmBkClrN = props_obj.buttonBackgroundNormalColor;
        _s.itmBkClrS = props_obj.buttonBackgroundSelectedColor;
        _s.itmTxtClrN = props_obj.buttonTextNormalColor;
        _s.itmTxtClrS = props_obj.buttonTextSelectedColor;
        
        _s.scrBarHandY = 0;
        _s.ttBtns = _s.categories_ar.length;
        _s.curId = props_obj.startAtPlaylist;
        _s.btnsHldW = 0;
        _s.btnsHldH = 0;
        _s.totalWidth = prt.sW;
        _s.buttonHeight = props_obj.buttonHeight;
        
        _s.ttBtnH = 0;
        _s.spcBtwBtns = 1;
        _s.thmbsFinY = 0;
        _s.vy = 0;
        _s.vy2 = 0;
        _s.frc = .9;
    
        _s.addMouseWheelSupport_bl = prt._d.addMouseWheelSupport_bl;
        _s.scollbarSpeedSensitivity = prt._d.scollbarSpeedSensitivity;
        _s.hasPointEvt = FWDUVPUtils.hasPointerEvent;
        _s.isMbl = FWDUVPUtils.isMobile;
        

        //#####################################//
        /* Initialize */
        //####################################//
        _s.init = function(){
            _s.setOverflow("visible");
            _s.setupMainContainers();
            _s.setupScrollLogic();
            _s.getMaxWidthResizeAndPosition();
            _s.mainButtonsHolder_do.setVisible(false);
            _s.bk_do.setVisible(false);
            
        };
        

        //#####################################//
        /* setup main containers */
        //####################################//
        _s.setupMainContainers = function(){
            var button_do;
            
            _s.mainHld = new FWDUVPDisplayObject("div");
            _s.mainHld.setOverflow("visible");
            _s.addChild(_s.mainHld);
            
            _s.bk_do = new FWDUVPDisplayObject("div");
            _s.bk_do.screen.className = 'fwduvp-combobox-background';
            _s.bk_do.setY(_s.buttonHeight);
            _s.bk_do.setBkColor(prt.playlistBackgroundColor_str);
            _s.bk_do.setAlpha(0);
            
            _s.mainHld.addChild(_s.bk_do);
            
            _s.mainButtonsHolder_do = new FWDUVPDisplayObject("div");
            _s.mainButtonsHolder_do.setY(_s.buttonHeight);
            _s.mainHld.addChild(_s.mainButtonsHolder_do);
            
            if(prt.repeatBackground_bl){
                _s.dummyBk_do =  new FWDUVPDisplayObject("div");
                _s.dummyBk_do.getStyle().background = "url('" + prt.bkPath_str +  "')";
            }else{
                _s.dummyBk_do = new FWDUVPDisplayObject("img");
                var imageBk_img = new Image();
                imageBk_img.src = prt.bkPath_str;
                _s.dummyBk_do.setScreen(imageBk_img);
            }
    
            _s.dummyBk_do.setHeight(_s.buttonHeight);
            _s.mainHld.addChild(_s.dummyBk_do);
            
            _s.buttonsHolder_do = new FWDUVPDisplayObject("div");
            _s.mainButtonsHolder_do.addChild(_s.buttonsHolder_do);
            
            var selLabel = _s.selLabel;
            
            if (_s.selLabel == "default"){
                selLabel = _s.categories_ar[_s.curId];
            }
            
            FWDUVPComboBoxSelector.setPrototype();
            _s.selector_do = new FWDUVPComboBoxSelector(
                    11,
                    6,
                    props_obj.arrowN_str,
                    props_obj.arrowS_str,
                    selLabel,
                    _s.selBkColN,
                    _s.selBkColS,
                    _s.selTxtColN,
                    _s.selTxtColS,
                    _s.buttonHeight,
                    _s.useHEX,
                    _s.nBC,
                    _s.sBC);
            _s.mainHld.addChild(_s.selector_do);
            _s.selector_do.setNormalState(false);
            _s.selector_do.addListener(FWDUVPComboBoxSelector.CLICK, _s.openMenuHandler);
            
            for(var i=0; i<_s.ttBtns; i++){
                FWDUVPComboBoxButton.setPrototype();


                button_do = new FWDUVPComboBoxButton(
                        _s,
                        _s.categories_ar[i],
                        _s.itmBkClrN,
                        _s.itmBkClrS,
                        _s.itmTxtClrN,
                        _s.itmTxtClrS,
                        i,
                        _s.buttonHeight);
                _s.buttons_ar[i] = button_do;
                button_do.addListener(FWDUVPComboBoxButton.CLICK, _s.buttonOnMouseDownHandler);
                _s.buttonsHolder_do.addChild(button_do);
            }
        };

        _s.buttonOnMouseDownHandler = function(e){
            _s.curId = e.id;
            clearTimeout(_s.hideMenuTimeOutId_to);
            _s.hide(true);
            _s.selector_do.enable(); 
            if(_s.hasPointEvt){
                window.removeEventListener("pointerdown", _s.checkOpenedMenu);
            }else{
                window.removeEventListener("touchstart", _s.checkOpenedMenu);
                if(!_s.isMbl){
                    window.removeEventListener("mousedown", _s.checkOpenedMenu);
                    window.removeEventListener("mousemove", _s.checkOpenedMenu);
                }
            }
        
            _s.selector_do.setText(_s.buttons_ar[_s.curId].label1_str);
            _s.dispatchEvent(FWDUVPComboBox.BUTTON_PRESSED, {id:_s.curId});
        };

        _s.openMenuHandler = function(e){
            if(FWDAnimation.isTweening(_s.mainButtonsHolder_do)) return;
            if(_s.isShd){
                _s.checkOpenedMenu(e.e, true);
            }else{
                _s.selector_do.disable();
                _s.show(true);
                _s.startToCheckOpenedMenu();
                _s.dispatchEvent(FWDUVPComboBox.OPEN);
            }
        };
        

        //#######################################//
        /* Disable or enable buttons */
        //#######################################//
        _s.setButtonsStateBasedOnId = function(id){
            _s.curId = id;
            for(var i=0; i<_s.ttBtns; i++){
                var button_do = _s.buttons_ar[i];
                if(i == _s.curId){
                    button_do.disable();
                }else{
                    button_do.enable();
                }
            }
            _s.selector_do.setText(_s.buttons_ar[_s.curId].label1_str);
            if(_s.scrHandler_do){
                _s.updateScrollBarSizeActiveAndDeactivate();
                _s.updateScrollBarHandlerAndContent(false, true);
            }else{
                _s.thmbsFinY = 0;
            }
        };
        
        _s.setValue = function(id){
            _s.curId = id;
            _s.setButtonsStateBasedOnId();
        };


        //#######################################//
        /* Start to check if mouse is over menu */
        //#######################################//
        _s.startToCheckOpenedMenu = function(e){
            if(_s.hasPointEvt){
                window.addEventListener("pointerdown", _s.checkOpenedMenu);
            }else{
                window.addEventListener("touchstart", _s.checkOpenedMenu);
                if(!_s.isMbl){
                    window.addEventListener("mousedown", _s.checkOpenedMenu);
                }
            }
        };
        _s.checkOpenedMenu = function(e, forceHide){
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            var hideDelay  = 1000;
            if(e.type == "mousedown") hideDelay = 0;

            if(!FWDUVPUtils.hitTest(_s.screen, vc.screenX, vc.screenY) &&
               !FWDUVPUtils.hitTest(_s.mainButtonsHolder_do.screen, vc.screenX, vc.screenY)
               || forceHide
            ){
                _s.hide(true);
                _s.selector_do.enable();
                if(_s.hasPointEvt){
                    window.removeEventListener("pointerdown", _s.checkOpenedMenu);
                }else{
                    if(!_s.isMbl){
                        window.removeEventListener("touchstart", _s.checkOpenedMenu);
                        window.removeEventListener("mousemove", _s.checkOpenedMenu);
                    }
                    window.removeEventListener("mousedown", _s.checkOpenedMenu);
                }
            }else{
                clearTimeout(_s.hideMenuTimeOutId_to);
            }

            if(FWDUVPUtils.hitTest(_s.selector_do.screen, vc.screenX, vc.screenY) && !_s.isMbl){
                setTimeout(function(){
                    _s.selector_do.setSelectedState(true);
                }, 50)
            }
        };
        
        
        //########################################//
        /* Get max width and position */
        //#######################################//
        _s.getMaxWidthResizeAndPosition = function(){
            
            var button_do;
            var finalX;
            var finalY;
            _s.ttBtnH = 0;      
            
            for(var i=0; i<_s.ttBtns; i++){
                button_do = _s.buttons_ar[i];
                button_do.setY((i * (button_do.totalHeight + _s.spcBtwBtns)));
                if(_s.allowToScrollAndScrollBarIsActive_bl && !_s.isMbl){
                    _s.totalWidth = prt.sW ;
                }else{
                    _s.totalWidth = prt.sW;
                }
                
                button_do.totalWidth =  _s.totalWidth;
                button_do.setWidth(_s.totalWidth);
                button_do.centerText();
            }
        
            _s.ttBtnH = button_do.getY() + button_do.totalHeight - _s.spcBtwBtns;
            var offset = 2;
            if(_s.isMbl){
                offset = 0;
            }
            
            _s.dummyBk_do.setWidth(_s.totalWidth + offset);
            _s.setWidth(_s.totalWidth);
            _s.setHeight(_s.buttonHeight);
            _s.selector_do.totalWidth =  _s.totalWidth + offset;
            _s.selector_do.setWidth(_s.totalWidth + offset);
            _s.selector_do.centerText();
            _s.buttonsHolder_do.setWidth(_s.totalWidth);
            _s.buttonsHolder_do.setHeight(_s.ttBtnH);   
        };

        //######################################//
        /* position */
        //######################################//
        _s.position = function(){       
            if (FWDUVPUtils.isAndroid){
                _s.setX(Math.floor(_s.finalX));
                _s.setY(Math.floor(_s.finalY-1));
                setTimeout(_s.poscombo-box, 100);
            }else{
                _s.poscombo-box();
            }
        };
            
        _s.resizeAndPosition = function(){
            _s.sW = prt.sW;
            _s.sH = prt.sH;
            _s.bk_do.setWidth(_s.sW);
            _s.bk_do.setHeight(_s.sH - prt.removeFromThumbsHolderHeight + 5);
            _s.mainButtonsHolder_do.setWidth(_s.sW);
            _s.mainButtonsHolder_do.setHeight(_s.sH - prt.removeFromThumbsHolderHeight);

            if(_s.ttBtnH > _s.mainButtonsHolder_do.h){
                _s.allowToScrollAndScrollBarIsActive_bl = true;
            }else{
                _s.allowToScrollAndScrollBarIsActive_bl = false;
            }
            
            if(!_s.allowToScrollAndScrollBarIsActive_bl && _s.scrMainHolder_do){
                _s.scrMainHolder_do.setVisible(false);
            }else if(_s.allowToScrollAndScrollBarIsActive_bl && _s.scrMainHolder_do && _s.isShd){
                _s.scrMainHolder_do.setVisible(true);
            }
            
            if(_s.scrHandler_do) _s.updateScrollBarSizeActiveAndDeactivate();
            _s.getMaxWidthResizeAndPosition();
            _s.updateScrollBarHandlerAndContent();
        };
        
        _s.hide = function(animate, overwrite){
            if(!_s.isShd && !overwrite) return;
            FWDAnimation.killTweensOf(_s);
            _s.isShd = false;
            FWDAnimation.killTweensOf(_s.mainButtonsHolder_do);
            FWDAnimation.killTweensOf(_s.bk_do);
            if(animate){
                FWDAnimation.to(_s.mainButtonsHolder_do, .8, {y:-_s.ttBtnH, ease:Expo.easeInOut, onComplete:_s.hideComplete});  
                FWDAnimation.to(_s.bk_do, .8, {alpha:0});   
            }else{
                _s.mainButtonsHolder_do.setY(_s.buttonHeight - _s.ttBtnH);
                _s.bk_do.setAlpha(0);
                _s.setHeight(_s.buttonHeight);
            }
        };
        
        _s.hideComplete = function(){
            _s.mainButtonsHolder_do.setVisible(false);
            _s.bk_do.setVisible(false);
        }

        _s.show = function(animate, overwrite){
            if(_s.isShd && !overwrite) return;
            FWDAnimation.killTweensOf(_s);
            _s.mainButtonsHolder_do.setY(- _s.ttBtnH);
            _s.isShd = true;
            _s.mainButtonsHolder_do.setVisible(true);
            _s.bk_do.setVisible(true);
            _s.resizeAndPosition();
            FWDAnimation.killTweensOf(_s.mainButtonsHolder_do);
            FWDAnimation.killTweensOf(_s.bk_do);
            if(_s.scrMainHolder_do && _s.allowToScrollAndScrollBarIsActive_bl) _s.scrMainHolder_do.setVisible(true);
        
            if(animate){
                FWDAnimation.to(_s.bk_do, .8, {alpha:1});
                FWDAnimation.to(_s.mainButtonsHolder_do, .8, {y:_s.buttonHeight + prt.spaceBetweenThumbnails, ease:Expo.easeInOut});
            }else{
                _s.bk_do.setAlpha(1);
                _s.mainButtonsHolder_do.setY(_s.buttonHeight + prt.spaceBetweenThumbnails);
            }
        };
        _s.setupScrollLogic = function(){
            
            _s.setupMobileScrollbar();
            if(!_s.isMbl) _s.setupScrollbar();
            if(_s.addMouseWheelSupport_bl) _s.addMouseWheelSupport();
        };
        

        //##########################################//
        /* setup mobile scrollbar */
        //##########################################//
        _s.setupMobileScrollbar = function(){
            if(_s.hasPointEvt){
                _s.mainButtonsHolder_do.screen.addEventListener("pointerdown", _s.scrollBarTouchStartHandler);
            }else{
                _s.mainButtonsHolder_do.screen.addEventListener("touchstart", _s.scrollBarTouchStartHandler);
            }
            if(_s.isMbl) _s.updateMobileScrollBarId_int = setInterval(_s.updateMobileScrollBar, 16);
        };

        _s.scrollBarTouchStartHandler = function(e){
            if(e.preventDefault) e.preventDefault();
            _s.isScrollingOnMove_bl = false;
            FWDAnimation.killTweensOf(_s.buttonsHolder_do);
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);        
            _s.isDragging_bl = true;
            _s.lastPresedY = vc.screenY;
            _s.checkLastPresedY = vc.screenY;
            if(_s.hasPointEvt){
                window.addEventListener("pointerup", _s.scrollBarTouchEndHandler);
                window.addEventListener("pointermove", _s.scrollBarTouchMoveHandler);
            }else{
                window.addEventListener("touchend", _s.scrollBarTouchEndHandler);
                window.addEventListener("touchmove", _s.scrollBarTouchMoveHandler, {passive:false});
            }
            window.addEventListener("mouseup", _s.scrollBarTouchEndHandler);
            window.addEventListener("mousemove", _s.scrollBarTouchMoveHandler);
            clearInterval(_s.updateMoveMobileScrollbarId_int);
            _s.updateMoveMobileScrollbarId_int = setInterval(_s.updateMoveMobileScrollbar, 20);
        };

        _s.scrollBarTouchMoveHandler = function(e){
            if(e.preventDefault) e.preventDefault();
            e.stopImmediatePropagation();
            if(_s.ttBtnH < _s.mainButtonsHolder_do.h) return;
            prt.prt.showDisable();
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            if(vc.screenY >= _s.checkLastPresedY + 6 || vc.screenY <= _s.checkLastPresedY - 6) _s.isScrollingOnMove_bl = true;
            var toAdd = vc.screenY - _s.lastPresedY;
            _s.thmbsFinY += toAdd;
            _s.thmbsFinY = Math.round(_s.thmbsFinY);
            _s.lastPresedY = vc.screenY;
            _s.vy = toAdd  * 2;
            
            if(!_s.isMobile){
                if(_s.thmbsFinY > 0){
                    _s.thmbsFinY = 0;
                }else if(_s.thmbsFinY < _s.mainButtonsHolder_do.h - _s.ttBtnH){
                    _s.thmbsFinY = _s.mainButtonsHolder_do.h - _s.ttBtnH;
                }   
                
                var percentScrolled = Math.max(0,(_s.thmbsFinY/(_s.mainButtonsHolder_do.h - _s.ttBtnH)));
                
                if(_s.scrMainHolder_do){
                    _s.scrBarHandY = Math.round((_s.scrMainHolder_do.h - _s.scrHandler_do.h) * percentScrolled);
                    
                    if(_s.scrBarHandY < 0){
                        _s.scrBarHandY = 0;
                    }else if(_s.scrBarHandY > _s.scrMainHolder_do.h - _s.scrHandler_do.h - 1){
                        _s.scrBarHandY = _s.scrMainHolder_do.h - _s.scrHandler_do.h - 1;
                    }
                    
                    FWDAnimation.killTweensOf(_s.scrHandler_do);
                    FWDAnimation.killTweensOf(_s.scrHandlerLines_do);
                    
                        _s.scrHandler_do.setY(_s.scrBarHandY);
                        _s.scrHandlerLines_do.setY(_s.scrBarHandY + parseInt((_s.scrHandler_do.h - _s.scrHandlerLinesN_do.h)/2));
                    
                }
            }
        };

        _s.scrollBarTouchEndHandler = function(e){
            _s.isDragging_bl = false;
            clearInterval(_s.updateMoveMobileScrollbarId_int);
            clearTimeout(_s.disableOnMoveId_to);
            _s.disableOnMoveId_to = setTimeout(function(){
                prt.prt.hideDisable();
            },100);
            if(_s.hasPointEvt){
                window.removeEventListener("pointerup", _s.scrollBarTouchEndHandler);
                window.removeEventListener("pointermove", _s.scrollBarTouchMoveHandler);
            }else{
                window.removeEventListener("touchend", _s.scrollBarTouchEndHandler);
                window.removeEventListener("touchmove", _s.scrollBarTouchMoveHandler);
            }
            window.removeEventListener("mousemove", _s.scrollBarTouchMoveHandler);
        };

        _s.updateMoveMobileScrollbar = function(){
            _s.buttonsHolder_do.setY(_s.thmbsFinY);
        };

        _s.updateMobileScrollBar = function(animate){
            if(!_s.isDragging_bl){
                if(_s.ttBtnH < _s.mainButtonsHolder_do.h) _s.thmbsFinY = 0.01;
                _s.vy *= _s.frc;
                _s.thmbsFinY += _s.vy;  
                if(_s.thmbsFinY > 0){
                    _s.vy2 = (0 - _s.thmbsFinY) * .3;
                    _s.vy *= _s.frc;
                    _s.thmbsFinY += _s.vy2;
                }else if(_s.thmbsFinY < _s.mainButtonsHolder_do.h - _s.ttBtnH){
                    _s.vy2 = (_s.mainButtonsHolder_do.h - _s.ttBtnH - _s.thmbsFinY) * .3;
                    _s.vy *= _s.frc;
                    _s.thmbsFinY += _s.vy2;
                }
                _s.buttonsHolder_do.setY(Math.round(_s.thmbsFinY));
            }
        };

        //#################################//
        /* setup mouse scrollbar */
        //#################################//
        _s.setupScrollbar = function(){
            _s.scrMainHolder_do = new FWDUVPDisplayObject("div");
            _s.scrMainHolder_do.setVisible(false);
            
            _s.scrMainHolder_do.setWidth(prt.scrWidth);
            
            //track
            _s.scrTrack_do = new FWDUVPDisplayObject("div");
            _s.scrTrack_do.setWidth(prt.scrWidth);
            
            var scrBkTop_img = new Image();
            scrBkTop_img.src = prt.scrBkTop_img.src;
            _s.scrTrackTop_do = new FWDUVPDisplayObject("img");
            _s.scrTrackTop_do.setWidth(prt.scrTrackTop_do.w);
            _s.scrTrackTop_do.setHeight(prt.scrTrackTop_do.h);
            _s.scrTrackTop_do.setScreen(scrBkTop_img);
            
            _s.scrTrackMiddle_do = new FWDUVPDisplayObject("div");
            _s.scrTrackMiddle_do.getStyle().background = "url('" + prt._d.scrBkMiddlePath_str + "')";
            _s.scrTrackMiddle_do.setWidth(prt.scrWidth);
            _s.scrTrackMiddle_do.setY(_s.scrTrackTop_do.h);
        
            var scrTrackBottomImage_img = new Image();
            scrTrackBottomImage_img.src = prt._d.scrBkBottomPath_str;
            _s.scrTrackBottom_do = new FWDUVPDisplayObject("img");
            _s.scrTrackBottom_do.setScreen(scrTrackBottomImage_img);
            _s.scrTrackBottom_do.setWidth(_s.scrTrackTop_do.w);
            _s.scrTrackBottom_do.setHeight(_s.scrTrackTop_do.h);
            
            //handler
            _s.scrHandler_do = new FWDUVPDisplayObject("div");
            _s.scrHandler_do.setWidth(prt.scrWidth);
        
            _s.scrDragTop_img = new Image();
            _s.scrDragTop_img.src = prt.scrDragTop_img.src;
            _s.scrDragTop_img.width = prt.scrDragTop_img.width;
            _s.scrDragTop_img.height = prt.scrDragTop_img.height;
            
            _s.scrHandlerTop_do = new FWDUVPDisplayObject("img");
            if(_s.useHEX){
                _s.scrHandlerTop_do = new FWDUVPDisplayObject("div");
                _s.scrHandlerTop_do.setWidth(_s.scrDragTop_img.width);
                _s.scrHandlerTop_do.setHeight(_s.scrDragTop_img.height);
                _s.mainScrubberDragTop_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.scrDragTop_img, _s.nBC).canvas;
                _s.scrHandlerTop_do.screen.appendChild(_s.mainScrubberDragTop_canvas);  
            }else{
                _s.scrHandlerTop_do = new FWDUVPDisplayObject("img");
                _s.scrHandlerTop_do.setScreen(_s.scrDragTop_img);
            }
            
            _s.scrHandlerMiddle_do = new FWDUVPDisplayObject("div");
            _s.middleImage = new Image();
            _s.middleImage.src = prt._d.scrDragMiddlePath_str;
            if(_s.useHEX){
                _s.middleImage.onload = function(){
                    _s.scrubberDragMiddle_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.middleImage, _s.nBC, true);
                    _s.scrubberDragImage_img = _s.scrubberDragMiddle_canvas.image;
                    _s.scrHandlerMiddle_do.getStyle().background = "url('" + _s.scrubberDragImage_img.src + "') repeat-y";
                }
            }else{
                _s.scrHandlerMiddle_do.getStyle().background = "url('" + prt._d.scrDragMiddlePath_str + "')";
            }
    
            _s.scrHandlerMiddle_do.setWidth(prt.scrWidth);
            _s.scrHandlerMiddle_do.setY(_s.scrHandlerTop_do.h);
            
            _s.scrHandlerBottom_do = new FWDUVPDisplayObject("div");
            _s.bottomImage = new Image();
            _s.bottomImage.src = prt._d.scrDragMiddlePath_str;
            if(_s.useHEX){
                _s.bottomImage.onload = function(){
                    _s.scrubberDragBottom_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.bottomImage, _s.nBC, true);
                    _s.scrubberDragBottomImage_img = _s.scrubberDragBottom_canvas.image;
                    _s.scrHandlerBottom_do.getStyle().background = "url('" + _s.scrubberDragBottomImage_img.src + "') repeat-y";
                    
                }
            }else{
                _s.scrHandlerBottom_do.getStyle().background = "url('" + prt._d.scrDragBottomPath_str + "')";
            }
            _s.scrHandlerBottom_do.setWidth(prt.scrWidth);
            _s.scrHandlerBottom_do.setY(_s.scrHandlerTop_do.h);
            
            _s.scrHandlerBottom_do.setWidth(_s.scrHandlerTop_do.w);
            _s.scrHandlerBottom_do.setHeight(_s.scrHandlerTop_do.h);
            _s.scrHandler_do.setButtonMode(true);
            
            _s.scrLinesN_img = new Image();
            _s.scrLinesN_img.src = prt.scrLinesN_img.src;
            _s.scrLinesN_img.width = prt.scrLinesN_img.width;
            _s.scrLinesN_img.height = prt.scrLinesN_img.height;
            
            if(_s.useHEX){
                _s.scrHandlerLinesN_do = new FWDUVPDisplayObject("div");
                _s.scrHandlerLinesN_do.setWidth(_s.scrLinesN_img.width);
                _s.scrHandlerLinesN_do.setHeight(_s.scrLinesN_img.height);
                _s.mainhandlerN_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.scrLinesN_img, _s.sBC).canvas;
                _s.scrHandlerLinesN_do.screen.appendChild(_s.mainhandlerN_canvas);  
            }else{
                _s.scrHandlerLinesN_do = new FWDUVPDisplayObject("img");
                _s.scrHandlerLinesN_do.setScreen(_s.scrLinesN_img);
            }
            
            _s.scrHandlerLinesS_img = new Image();
            _s.scrHandlerLinesS_img.src = prt._d.scrLinesSPath_str;
            if(_s.useHEX){
                _s.scrHandlerLinesS_do = new FWDUVPDisplayObject("div");
                _s.scrHandlerLinesS_img.onload = function(){
                    _s.scrHandlerLinesS_do.setWidth(_s.scrHandlerLinesN_do.w);
                    _s.scrHandlerLinesS_do.setHeight(_s.scrHandlerLinesN_do.h);
                    _s.scrubberLines_s_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.scrHandlerLinesS_img, _s.sBC, true);
                    _s.scrubbelinesSImage_img = _s.scrubberLines_s_canvas.image;
                    _s.scrHandlerLinesS_do.getStyle().background = "url('" + _s.scrubbelinesSImage_img.src + "') repeat-y";
                }
            }else{
                _s.scrHandlerLinesS_do = new FWDUVPDisplayObject("img");
                _s.scrHandlerLinesS_do.setScreen(_s.scrHandlerLinesS_img);
                _s.scrHandlerLinesS_do.setWidth(_s.scrHandlerLinesN_do.w);
                _s.scrHandlerLinesS_do.setHeight(_s.scrHandlerLinesN_do.h);
            }
            _s.scrHandlerLinesS_do.setAlpha(0);
            
            _s.scrHandlerLines_do = new FWDUVPDisplayObject("div");
            _s.scrHandlerLines_do.setWidth(_s.scrHandlerLinesN_do.w);
            _s.scrHandlerLines_do.setHeight(_s.scrHandlerLinesN_do.h);
            _s.scrHandlerLines_do.setButtonMode(true);
                
            _s.scrTrack_do.addChild(_s.scrTrackTop_do);
            _s.scrTrack_do.addChild(_s.scrTrackMiddle_do);
            _s.scrTrack_do.addChild(_s.scrTrackBottom_do);
            _s.scrHandler_do.addChild(_s.scrHandlerTop_do);
            _s.scrHandler_do.addChild(_s.scrHandlerMiddle_do);
            _s.scrHandler_do.addChild(_s.scrHandlerBottom_do);
            _s.scrHandlerLines_do.addChild(_s.scrHandlerLinesN_do);
            _s.scrHandlerLines_do.addChild(_s.scrHandlerLinesS_do);
            _s.scrMainHolder_do.addChild(_s.scrTrack_do);
            _s.scrMainHolder_do.addChild(_s.scrHandler_do);
            _s.scrMainHolder_do.addChild(_s.scrHandlerLines_do);
            _s.mainButtonsHolder_do.addChild(_s.scrMainHolder_do);
            
            _s.scrHandler_do.screen.addEventListener("mouseover", _s.scrollBarHandlerOnMouseOver);
            _s.scrHandler_do.screen.addEventListener("mouseout", _s.scrollBarHandlerOnMouseOut);
            _s.scrHandler_do.screen.addEventListener("mousedown", _s.scrollBarHandlerOnMouseDown);
            _s.scrHandlerLines_do.screen.addEventListener("mouseover", _s.scrollBarHandlerOnMouseOver);
            _s.scrHandlerLines_do.screen.addEventListener("mouseout", _s.scrollBarHandlerOnMouseOut);
            _s.scrHandlerLines_do.screen.addEventListener("mousedown", _s.scrollBarHandlerOnMouseDown);
        
        };
        
        _s.scrollBarHandlerOnMouseOver = function(e){
            if(!_s.allowToScrollAndScrollBarIsActive_bl) return; 
            FWDAnimation.killTweensOf(_s.scrHandlerLinesN_do);
            FWDAnimation.killTweensOf(_s.scrHandlerLinesS_do);
            FWDAnimation.to(_s.scrHandlerLinesN_do, .8, {alpha:0, ease:Expo.easeOut});
            FWDAnimation.to(_s.scrHandlerLinesS_do, .8, {alpha:1, ease:Expo.easeOut});
        };
        
        _s.scrollBarHandlerOnMouseOut = function(e){
            if(_s.isDragging_bl || !_s.allowToScrollAndScrollBarIsActive_bl) return;
            FWDAnimation.killTweensOf(_s.scrHandlerLinesN_do);
            FWDAnimation.killTweensOf(_s.scrHandlerLinesS_do);
            FWDAnimation.to(_s.scrHandlerLinesN_do, .8, {alpha:1, ease:Expo.easeOut});
            FWDAnimation.to(_s.scrHandlerLinesS_do, .8, {alpha:0, ease:Expo.easeOut});
        };
        
        _s.scrollBarHandlerOnMouseDown = function(e){
            if(!_s.allowToScrollAndScrollBarIsActive_bl) return;
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);        
            _s.isDragging_bl = true;
            _s.yPositionOnPress = _s.scrHandler_do.y;
            _s.lastPresedY = vc.screenY;
            FWDAnimation.killTweensOf(_s.scrHandler_do);
            prt.prt.showDisable();
            
            if(window.addEventListener){
                window.addEventListener("mousemove", _s.scrollBarHandlerMoveHandler);
                window.addEventListener("mouseup", _s.scrollBarHandlerEndHandler);  
            }else if(document.attachEvent){
                document.attachEvent("onmousemove", _s.scrollBarHandlerMoveHandler);
                document.attachEvent("onmouseup", _s.scrollBarHandlerEndHandler);
            }
        };
        
        _s.scrollBarHandlerMoveHandler = function(e){
            if(e.preventDefault) e.preventDefault();
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            var linesY = _s.scrBarHandY + parseInt((_s.scrHandler_do.h - _s.scrHandlerLines_do.h)/2);
    
            _s.scrBarHandY = Math.round(_s.yPositionOnPress + vc.screenY - _s.lastPresedY);
            if(_s.scrBarHandY >= _s.scrTrack_do.h - _s.scrHandler_do.h){
                _s.scrBarHandY = _s.scrTrack_do.h -  _s.scrHandler_do.h;
            }else if(_s.scrBarHandY <= 0){
                _s.scrBarHandY = 0;
            }
            
            _s.scrHandler_do.setY(_s.scrBarHandY);
            FWDAnimation.killTweensOf(_s.scrHandler_do);
            FWDAnimation.to(_s.scrHandlerLines_do, .8, {y:linesY, ease:Quart.easeOut});
            _s.updateScrollBarHandlerAndContent(true);
        };
        
        _s.scrollBarHandlerEndHandler = function(e){
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            _s.isDragging_bl = false;
            
            if(!FWDUVPUtils.hitTest(_s.scrHandler_do.screen, vc.screenX, vc.screenY)){
                FWDAnimation.killTweensOf(_s.scrHandlerLinesN_do);
                FWDAnimation.killTweensOf(_s.scrHandlerLinesS_do);
                FWDAnimation.to(_s.scrHandlerLinesN_do, .8, {alpha:1, ease:Expo.easeOut});
                FWDAnimation.to(_s.scrHandlerLinesS_do, .8, {alpha:0, ease:Expo.easeOut});
            }
            
            prt.prt.hideDisable();
            FWDAnimation.killTweensOf(_s.scrHandler_do);
            FWDAnimation.to(_s.scrHandler_do, .4, {y:_s.scrBarHandY, ease:Quart.easeOut});
            
            if(window.removeEventListener){
                window.removeEventListener("mousemove", _s.scrollBarHandlerMoveHandler);
                window.removeEventListener("mouseup", _s.scrollBarHandlerEndHandler);   
            }else if(document.detachEvent){
                document.detachEvent("onmousemove", _s.scrollBarHandlerMoveHandler);
                document.detachEvent("onmouseup", _s.scrollBarHandlerEndHandler);
            }
        };
        
        _s.updateScrollBarSizeActiveAndDeactivate = function(){
            if(_s.disableForAWhileAfterThumbClick_bl) return;
        
            if(_s.allowToScrollAndScrollBarIsActive_bl){
                _s.allowToScrollAndScrollBarIsActive_bl = true;
                _s.scrMainHolder_do.setX(_s.sW - _s.scrMainHolder_do.w);
                _s.scrMainHolder_do.setHeight(_s.mainButtonsHolder_do.h);
                _s.scrTrack_do.setHeight(_s.scrMainHolder_do.h);
                _s.scrTrackMiddle_do.setHeight(_s.scrTrack_do.h - (_s.scrTrackTop_do.h * 2));
                _s.scrTrackBottom_do.setY(_s.scrTrackMiddle_do.y + _s.scrTrackMiddle_do.h);
                _s.scrMainHolder_do.setAlpha(1);
                _s.scrHandler_do.setButtonMode(true);
                _s.scrHandlerLines_do.setButtonMode(true);
            }else{
                _s.allowToScrollAndScrollBarIsActive_bl = false;
                _s.scrMainHolder_do.setX(_s.sW - _s.scrMainHolder_do.w);
                _s.scrMainHolder_do.setHeight(_s.mainButtonsHolder_do.h);
                _s.scrTrack_do.setHeight(_s.scrMainHolder_do.h);
                _s.scrTrackMiddle_do.setHeight(_s.scrTrack_do.h - (_s.scrTrackTop_do.h * 2));
                _s.scrTrackBottom_do.setY(_s.scrTrackMiddle_do.y + _s.scrTrackMiddle_do.h);
                _s.scrMainHolder_do.setAlpha(.5);
                _s.scrHandler_do.setY(0);
                _s.scrHandler_do.setButtonMode(false);
                _s.scrHandlerLines_do.setButtonMode(false);
            }
            
            _s.scrHandler_do.setHeight(Math.max(120, Math.round(Math.min(1,(_s.scrMainHolder_do.h/_s.ttBtnH)) * _s.scrMainHolder_do.h)));
            _s.scrHandlerMiddle_do.setHeight(_s.scrHandler_do.h - (_s.scrHandlerTop_do.h * 2));
            _s.scrHandlerBottom_do.setY(_s.scrHandlerMiddle_do.y + _s.scrHandlerMiddle_do.h);
            FWDAnimation.killTweensOf(_s.scrHandlerLines_do);
            _s.scrHandlerLines_do.setY(_s.scrBarHandY + parseInt((_s.scrHandler_do.h - _s.scrHandlerLines_do.h)/2));
            _s.scrHandlerBottom_do.setY(_s.scrHandler_do.h - _s.scrHandlerBottom_do.h);
        };

        
        //###########################################//
        /* Add mousewheel support */
        //###########################################//
        _s.addMouseWheelSupport = function(){
            if(_s.screen.addEventListener){
                _s.screen.addEventListener('DOMMouseScroll', _s.mouseWheelHandler);
                _s.screen.addEventListener ("mousewheel", _s.mouseWheelHandler);
            }else if(_s.screen.attachEvent){
                _s.screen.attachEvent('onmousewheel', _s.mouseWheelHandler);
            }
        };
    
        _s.mouseWheelHandler = function(e){
            if(e.preventDefault) e.preventDefault();
            if(_s.disableMouseWheel_bl || _s.isDragging_bl) return false;
            var dir = e.detail || e.wheelDelta; 
            if(e.wheelDelta) dir *= -1;
            if(dir > 0){
                _s.scrBarHandY += Math.round((160 * _s.scollbarSpeedSensitivity)  * (_s.mainButtonsHolder_do.h/_s.ttBtnH));
            }else if(dir < 0){
                _s.scrBarHandY -= Math.round((160 * _s.scollbarSpeedSensitivity)  * (_s.mainButtonsHolder_do.h/_s.ttBtnH));
            }
            
            if(_s.scrBarHandY >= _s.scrTrack_do.h - _s.scrHandler_do.h){
                _s.scrBarHandY = _s.scrTrack_do.h -  _s.scrHandler_do.h;
            }else if(_s.scrBarHandY <= 0){
                _s.scrBarHandY = 0;
            }
            
            var linesY = _s.scrBarHandY + parseInt((_s.scrHandler_do.h - _s.scrHandlerLines_do.h)/2);
            FWDAnimation.killTweensOf(_s.scrHandler_do);
            FWDAnimation.killTweensOf(_s.scrHandlerLines_do);
            FWDAnimation.to(_s.scrHandlerLines_do, .8, {y:linesY, ease:Quart.easeOut});
            FWDAnimation.to(_s.scrHandler_do, .5, {y:_s.scrBarHandY, ease:Quart.easeOut});
            _s.isDragging_bl = true;
            _s.updateScrollBarHandlerAndContent(true);
            _s.isDragging_bl = false;
        
            if(e.preventDefault){
                e.preventDefault();
            }else{
                return false;
            }
        };
        
        _s.updateScrollBarHandlerAndContent = function(animate, overwrite){
            if(_s.disableForAWhileAfterThumbClick_bl) return;
            if(!_s.allowToScrollAndScrollBarIsActive_bl && !overwrite) return;

            var percentScrolled = 0;
            var thumb;
            if(_s.isDragging_bl && !_s.isMbl){
                percentScrolled = (_s.scrBarHandY/(_s.scrMainHolder_do.h - _s.scrHandler_do.h));
                if(percentScrolled == "Infinity"){
                    percentScrolled = 0;
                }
                _s.thmbsFinY = Math.round(percentScrolled * (_s.ttBtnH - _s.mainButtonsHolder_do.h)) * -1;
                if(_s.mainButtonsHolder_do.h == 0) _s.thmbsFinY = 0;
            }else{
                percentScrolled = _s.curId/(_s.ttBtns - 1);
                _s.thmbsFinY = Math.min(0, Math.round(percentScrolled * (_s.ttBtnH - _s.mainButtonsHolder_do.h)) * -1);
                if(_s.mainButtonsHolder_do.h == 0) _s.thmbsFinY = 0;
                if(_s.scrMainHolder_do){
                    _s.scrBarHandY = Math.round((_s.scrMainHolder_do.h - _s.scrHandler_do.h) * percentScrolled);
                    if(_s.scrBarHandY < 0){
                        _s.scrBarHandY = 0;
                    }else if(_s.scrBarHandY > _s.scrMainHolder_do.h - _s.scrHandler_do.h - 1){
                        _s.scrBarHandY = _s.scrMainHolder_do.h - _s.scrHandler_do.h - 1;
                    }
                    
                    FWDAnimation.killTweensOf(_s.scrHandler_do);
                    FWDAnimation.killTweensOf(_s.scrHandlerLines_do);
                    if(animate){
                        FWDAnimation.to(_s.scrHandler_do, .4, {y:_s.scrBarHandY, ease:Quart.easeOut});
                        FWDAnimation.to(_s.scrHandlerLines_do, .8, {y:_s.scrBarHandY + parseInt((_s.scrHandler_do.h - _s.scrHandlerLinesN_do.h)/2), ease:Quart.easeOut});
                    }else{
                        _s.scrHandler_do.setY(_s.scrBarHandY);
                        _s.scrHandlerLines_do.setY(_s.scrBarHandY + parseInt((_s.scrHandler_do.h - _s.scrHandlerLinesN_do.h)/2));
                    }
                }
            }
            
            if(_s.lastThumbnailFinalY != _s.thmbsFinY){
                FWDAnimation.killTweensOf(_s.buttonsHolder_do);
                if(animate){
                    FWDAnimation.to(_s.buttonsHolder_do, .5, {y:_s.thmbsFinY, ease:Quart.easeOut});
                }else{
                    _s.buttonsHolder_do.setY(_s.thmbsFinY);
                }
            }
            
            _s.lastThumbnailFinalY = _s.thmbsFinY;
        };
        
        _s.init();
    };
    
    
    /* set prototype */
    FWDUVPComboBox.setPrototype =  function(){
        FWDUVPComboBox.prototype = new FWDUVPDisplayObject("div");
    };
    FWDUVPComboBox.OPEN = "open";
    FWDUVPComboBox.HIDE_COMPLETE = "infoWindowHideComplete";
    FWDUVPComboBox.BUTTON_PRESSED = "buttonPressed";
    FWDUVPComboBox.prototype = null;
    window.FWDUVPComboBox = FWDUVPComboBox;
    
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Playlist select box button.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (){
var FWDUVPComboBoxButton = function(
            prt,
            label1, 
            backgroundNormalColor,
            backgroundSelectedColor,
            textNormalColor,
            textSelectedColor,
            id,
            totalHeight
        ){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPComboBoxButton.prototype;
        
        _s.label1_str = label1;
        _s.bkNClr = backgroundNormalColor;
        _s.bkSClr = backgroundSelectedColor;
        _s.txtNClr = textNormalColor;
        _s.txtSClr = textSelectedColor;
        
        _s.totalWidth = 400;
        _s.totalHeight = totalHeight;
        _s.id = id;
        
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
        _s.isMbl = FWDUVPUtils.isMobile;

    
        //##########################################//
        /* initialize */
        //##########################################//
        _s.init = function(){
            _s.setBackfaceVisibility();
            _s.setButtonMode(true);
            _s.setupMainContainers();
            _s.setWidth(_s.totalWidth);
            _s.setHeight(_s.totalHeight);
            _s.setNormalState();
        };

        
        //##########################################//
        /* setup main containers */
        //##########################################//
        _s.setupMainContainers = function(){
            
            _s.bk_sdo = new FWDUVPDisplayObject("div");
            _s.bk_sdo.setBkColor(_s.bkNClr);
            _s.addChild(_s.bk_sdo);
            
            _s.text_sdo = new FWDUVPDisplayObject("div");
            _s.text_sdo.getStyle().whiteSpace = "nowrap";
            _s.text_sdo.screen.className = 'fwduvp-cb-button'
            _s.text_sdo.setBackfaceVisibility();
            _s.text_sdo.setOverflow("visible");
            _s.text_sdo.setDisplay("inline-block");
            _s.text_sdo.getStyle().fontFamily = "Arial";
            _s.text_sdo.getStyle().fontSize= "13px";
            _s.text_sdo.getStyle().padding = "6px";
            _s.text_sdo.getStyle().fontWeight = "100";
            _s.text_sdo.getStyle().color = _s.nBC;
            _s.text_sdo.getStyle().fontSmoothing = "antialiased";
            _s.text_sdo.getStyle().webkitFontSmoothing = "antialiased";
            _s.text_sdo.getStyle().textRendering = "optimizeLegibility";    
            
            if (FWDUVPUtils.isIEAndLessThen9){
                _s.text_sdo.screen.innerText = _s.label1_str;
            }else{
                _s.text_sdo.setInnerHTML(_s.label1_str);
            }
            
            _s.addChild(_s.text_sdo);
            
            _s.dumy_sdo = new FWDUVPDisplayObject("div");
            if(FWDUVPUtils.isIE){
                _s.dumy_sdo.setBkColor("#FF0000");
                _s.dumy_sdo.setAlpha(0);
            };
            _s.addChild(_s.dumy_sdo);
            
            
            if(_s.hasPointerEvent_bl){
                _s.screen.addEventListener("pointerup", _s.onClick);
                _s.screen.addEventListener("pointerover", _s.onMouseOver);
                _s.screen.addEventListener("pointerout", _s.onMouseOut);
            }else if(_s.screen.addEventListener){   
                if(!_s.isMbl){
                    _s.screen.addEventListener("mouseover", _s.onMouseOver);
                    _s.screen.addEventListener("mouseout", _s.onMouseOut);
                    _s.screen.addEventListener("mouseup", _s.onClick);
                }
                _s.screen.addEventListener("touchend", _s.onClick);
            }
        };
        
        _s.onMouseOver = function(e){
            if(_s.isDisabled_bl) return;
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE){
                FWDAnimation.killTweensOf(_s.text_sdo);
                _s.setSelectedState(true);
                _s.dispatchEvent(FWDUVPComboBoxButton.MOUSE_OVER);
            }
        };
            
        _s.onMouseOut = function(e){
            if(_s.isDisabled_bl) return;
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE){
                FWDAnimation.killTweensOf(_s.text_sdo);
                _s.setNormalState(true);
                _s.dispatchEvent(FWDUVPComboBoxButton.MOUSE_OUT);
            }
        };
        
        _s.onClick = function(e){
            if(_s.isDisabled_bl || prt.isScrollingOnMove_bl) return;
            if(e.preventDefault) e.preventDefault();
            _s.dispatchEvent(FWDUVPComboBoxButton.CLICK, {id:_s.id});
        };
        
        _s.onMouseDown = function(e){
            if(_s.isDisabled_bl || prt.isScrollingOnMove_bl) return;
            if(e.preventDefault) e.preventDefault();
            _s.dispatchEvent(FWDUVPComboBoxButton.MOUSE_DOWN, {id:_s.id});
        };
        

        //###########################################//
        /* set selected / normal state */
        //###########################################//
        _s.setSelectedState = function(animate){
            FWDAnimation.killTweensOf(_s.bk_sdo.screen);
            FWDAnimation.killTweensOf(_s.text_sdo.screen);
            if(animate){
                FWDAnimation.to(_s.bk_sdo.screen, .6, {css:{backgroundColor:_s.bkSClr}, ease:Quart.easeOut});
                FWDAnimation.to(_s.text_sdo.screen, .6, {css:{color:_s.txtSClr}, ease:Quart.easeOut});
            }else{
                _s.bk_sdo.setBkColor(_s.bkSClr);
                _s.text_sdo.getStyle().color = _s.txtSClr;
            }
        };
        
        _s.setNormalState = function(animate){
            FWDAnimation.killTweensOf(_s.bk_sdo.screen);
            FWDAnimation.killTweensOf(_s.text_sdo.screen);
            if(animate){
                FWDAnimation.to(_s.bk_sdo.screen, .6, {css:{backgroundColor:_s.bkNClr}, ease:Quart.easeOut});
                FWDAnimation.to(_s.text_sdo.screen, .6, {css:{color:_s.txtNClr}, ease:Quart.easeOut});
            }else{
                _s.bk_sdo.setBkColor(_s.bkNClr);
                _s.text_sdo.getStyle().color = _s.txtNClr;
            }
        };
        

        //##########################################//
        /* center text */
        //##########################################//
        _s.centerText = function(){
            
            _s.dumy_sdo.setWidth(_s.totalWidth);
            _s.dumy_sdo.setHeight(_s.totalHeight);
            _s.bk_sdo.setWidth(_s.totalWidth);
            _s.bk_sdo.setHeight(_s.totalHeight);
            _s.text_sdo.setX(4);
            _s.text_sdo.setY(Math.round((_s.totalHeight - _s.text_sdo.getHeight())/2));
        };
        

        //###############################//
        /* get max text width */
        //###############################//
        _s.getMaxTextWidth = function(){
            return _s.text_sdo.getWidth();
        };

        
        //##############################//
        /* disable / enable */
        //#############################//
        _s.disable = function(){
            _s.isDisabled_bl = true;
            _s.setButtonMode(false);
            _s.setSelectedState(true);
        };
        
        _s.enable = function(){
            _s.isDisabled_bl = false;
            _s.setNormalState(true);
            _s.setButtonMode(true);
        };
        
        _s.init();
    };
    
    
    /* set prototype */
    FWDUVPComboBoxButton.setPrototype = function(){
        FWDUVPComboBoxButton.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPComboBoxButton.FIRST_BUTTON_CLICK = "onFirstClick";
    FWDUVPComboBoxButton.SECOND_BUTTON_CLICK = "secondButtonOnClick";
    FWDUVPComboBoxButton.MOUSE_OVER = "onMouseOver";
    FWDUVPComboBoxButton.MOUSE_OUT = "onMouseOut";
    FWDUVPComboBoxButton.MOUSE_DOWN = "onMouseDown";
    FWDUVPComboBoxButton.CLICK = "onClick";
    
    FWDUVPComboBoxButton.prototype = null;
    window.FWDUVPComboBoxButton = FWDUVPComboBoxButton;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Playlist select box selector.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (){
var FWDUVPComboBoxSelector = function(
            arrowW,
            arrowH,
            arrowN_str,
            arrowS_str,
            label1, 
            backgroundNormalColor,
            backgroundSelectedColor,
            textNormalColor,
            textSelectedColor,
            totalHeight,
            useHEX,
            nBC,
            sBC
        ){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPComboBoxSelector.prototype;
        
        _s.arrowN_str = arrowN_str;
        _s.arrowS_str = arrowS_str;
        
        _s.label1_str = label1;
        _s.bkNColor = backgroundNormalColor;
        _s.bkSColor = backgroundSelectedColor;
        _s.tNColor = textNormalColor;
        _s.tSColor = textSelectedColor;
        
        _s.useHEX = useHEX;
        _s.nBC = nBC;
        _s.sBC = sBC;
        
        _s.totalWidth = 400;
        
        _s.totalHeight = totalHeight;
        _s.arrowWidth = arrowW;
        _s.arrowHeight = arrowH;
        
        _s.hasPointEvt = FWDUVPUtils.hasPointerEvent;
        _s.isMbl = FWDUVPUtils.isMobile;
        
        
        //##########################################//
        /* initialize  */
        //##########################################//
        _s.init = function(){
            _s.setBackfaceVisibility();
            _s.setButtonMode(true);
            _s.setupMainContainers();
            _s.setWidth(_s.totalWidth);
            _s.setHeight(_s.totalHeight);
        };
    
        //##########################################//
        /* setup main containers */
        //##########################################//
        _s.setupMainContainers = function(){
            
            _s.bk_sdo = new FWDUVPDisplayObject("div");
            _s.bk_sdo.getStyle().backgroundColor = _s.bkNColor;
            _s.addChild(_s.bk_sdo);
            
            _s.text_sdo = new FWDUVPDisplayObject("div");
            _s.text_sdo.getStyle().whiteSpace = "nowrap";
            _s.text_sdo.screen.className = 'fwduvp-cb-selector';
            _s.text_sdo.setBackfaceVisibility();
            _s.text_sdo.setOverflow("visible");
            _s.text_sdo.setDisplay("inline-block");
            _s.text_sdo.getStyle().fontFamily = "Arial";
            _s.text_sdo.getStyle().fontSize= "13px";
            _s.text_sdo.getStyle().fontWeight = "100";
            _s.text_sdo.getStyle().padding = "6px";
            _s.text_sdo.getStyle().color = _s.nBC;
            _s.text_sdo.getStyle().fontSmoothing = "antialiased";
            _s.text_sdo.getStyle().webkitFontSmoothing = "antialiased";
            _s.text_sdo.getStyle().textRendering = "optimizeLegibility";
            
            if (FWDUVPUtils.isIEAndLessThen9){
                _s.text_sdo.screen.innerText = _s.label1_str;
            }else{
                _s.text_sdo.setInnerHTML(_s.label1_str);
            }
            
            _s.addChild(_s.text_sdo);
            
            _s.arrow_do = new FWDUVPDisplayObject("div");
            _s.arrow_do.screen.className = "arrow";
            _s.arrow_do.setOverflow("visible");
            
            if(_s.useHEX){
                _s.arrowN_img = new Image();
                _s.arrowN_img.src = _s.arrowN_str;
                _s.arrowS_img = new Image();
                _s.arrowS_img.src = _s.arrowS_str;
                _s.arrowN_sdo = new FWDUVPDisplayObject("div");
                _s.arrowS_sdo = new FWDUVPDisplayObject("div");
                
                _s.arrowS_img.onload = function(){
                    _s.arrowN_sdo.setWidth(_s.arrowN_img.width);
                    _s.arrowN_sdo.setHeight(_s.arrowN_img.height);
                    _s.nBC = _s.bkNColor;       

                    _s.scrubberLines_n_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.arrowN_img, _s.nBC, true);
                    _s.scrubbelinesNImage_img = _s.scrubberLines_n_canvas.image;
                    _s.arrowN_sdo.getStyle().background = "url('" + _s.scrubbelinesNImage_img.src + "') repeat-y";
                    
                    _s.arrowS_sdo.setWidth(_s.arrowS_img.width);
                    _s.arrowS_sdo.setHeight(_s.arrowS_img.height);
                    _s.sBC = _s.arrowS_str; 
                    _s.scrubberLines_s_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.arrowS_img, _s.sBC, true);
                    _s.scrubbelinesSImage_img = _s.scrubberLines_s_canvas.image;
                    _s.arrowS_sdo.getStyle().background = "url('" + _s.scrubbelinesSImage_img.src + "') repeat-y";
                }
            }else{
                _s.arrowN_sdo = new FWDUVPDisplayObject("div");
                _s.arrowN_sdo.screen.style.backgroundImage = "url(" + _s.arrowN_str + ")";
                _s.arrowS_sdo = new FWDUVPDisplayObject("div");
                _s.arrowS_sdo.screen.style.backgroundImage = "url(" + _s.arrowS_str + ")";
            }
            
            _s.arrowS_sdo.setAlpha(0);
            _s.arrow_do.addChild(_s.arrowN_sdo);
            _s.arrow_do.addChild(_s.arrowS_sdo);
            _s.addChild(_s.arrow_do);
            
            _s.arrowN_sdo.setWidth(_s.arrowWidth);
            _s.arrowN_sdo.setHeight(_s.arrowHeight);
            _s.arrowS_sdo.setWidth(_s.arrowWidth);
            _s.arrowS_sdo.setHeight(_s.arrowHeight);
            
            _s.dumy_sdo = new FWDUVPDisplayObject("div");
            if(FWDUVPUtils.isIE){
                _s.dumy_sdo.setBkColor("#FF0000");
                _s.dumy_sdo.setAlpha(0);
            };
            _s.addChild(_s.dumy_sdo);
            
            if(_s.hasPointEvt){
                _s.screen.addEventListener("pointerup", _s.onClick);
                _s.screen.addEventListener("pointerover", _s.onMouseOver);
                _s.screen.addEventListener("pointerout", _s.onMouseOut);
            }else if(_s.screen.addEventListener){   
                _s.screen.addEventListener("mouseover", _s.onMouseOver);
                _s.screen.addEventListener("mouseout", _s.onMouseOut);
                _s.screen.addEventListener("mouseup", _s.onClick);
                _s.screen.addEventListener("touchend", _s.onClick);
            }
        };
        
        _s.onMouseOver = function(e){
            if(_s.isDble) return;
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE){
                FWDAnimation.killTweensOf(_s.text_sdo);
                _s.setSelectedState(true, 0);
                _s.dispatchEvent(FWDUVPComboBoxSelector.MOUSE_OVER);
            }
        };
            
        _s.onMouseOut = function(e){
            if(_s.isDble) return;
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE){
                FWDAnimation.killTweensOf(_s.text_sdo);
                _s.setNormalState(true, true);
                _s.dispatchEvent(FWDUVPComboBoxSelector.MOUSE_OUT);
            }
        };
        
        _s.onClick = function(e){
            
            if(_s.isDeveleper_bl){
                window.open("http://www.webdesign-flash.ro", "_blank");
                return;
            }

            if(e.preventDefault) e.preventDefault();
            _s.dispatchEvent(FWDUVPComboBoxSelector.CLICK, {e:e});
        };
        
        _s.onMouseDown = function(e){
            if(e.preventDefault) e.preventDefault();
            _s.dispatchEvent(FWDUVPComboBoxSelector.MOUSE_DOWN, {e:e});
        };
        

        //###########################################//
        /* set selected / normal state */
        //###########################################//
        _s.setSelectedState = function(animate, dl){
            
            if(animate){
                FWDAnimation.to(_s.bk_sdo, .6, {alpha:1, ease:Expo.easeOut});   
                FWDAnimation.to(_s.text_sdo.screen, .6, {css:{color:_s.tSColor}, ease:Expo.easeOut});
                FWDAnimation.to(_s.arrowS_sdo, .6, {alpha:1, ease:Expo.easeOut});
            }else{
                _s.bk_sdo.setAlpha(1);
                _s.text_sdo.getStyle().color = _s.tSColor;
                _s.arrowS_sdo.alpha = 1;
            }
        };
        
        _s.setNormalState = function(animate, removeDelay){
            var dll = .6;
            if(removeDelay) dll = 0;
            dll = 0;
            FWDAnimation.killTweensOf(_s.bk_sdo);
            FWDAnimation.killTweensOf(_s.text_sdo.screen);
            FWDAnimation.killTweensOf(_s.arrowS_sdo);

            if(animate){
                FWDAnimation.to(_s.bk_sdo, .6, {alpha:0, delay:dll, ease:Expo.easeOut});    
                FWDAnimation.to(_s.text_sdo.screen, .6, {css:{color:_s.tNColor}, delay:dll, ease:Expo.easeOut});
                FWDAnimation.to(_s.arrowS_sdo, .6, {alpha:0, delay:dll, ease:Expo.easeOut});
            }else{
                _s.bk_sdo.setAlpha(0);
                _s.text_sdo.getStyle().color = _s.tNColor;
                _s.arrowS_sdo.alpha = 0;
            }
        };

        
        //##########################################//
        /* center text */
        //##########################################//
        _s.centerText = function(){
            _s.dumy_sdo.setWidth(_s.totalWidth);
            _s.dumy_sdo.setHeight(_s.totalHeight);
            _s.bk_sdo.setWidth(_s.totalWidth);
            _s.bk_sdo.setHeight(_s.totalHeight);
            
            _s.text_sdo.setX(2);
            
            _s.text_sdo.setY(Math.round((_s.totalHeight - _s.text_sdo.getHeight())/2));
            
            _s.arrow_do.setX(_s.totalWidth - _s.arrowWidth - 5);
            _s.arrow_do.setY(Math.round((_s.totalHeight - _s.arrowHeight)/2));
        };

        
        //###############################//
        /* get max text width */
        //###############################//
        _s.getMaxTextWidth = function(){
            return _s.text_sdo.getWidth();
        };

        
        //##############################//
        /* disable / enable */
        //#############################//
        _s.disable = function(){
            _s.isDble = true;
            _s.setSelectedState(true);
            if(FWDUVPUtils.hasTransform2d){
                FWDAnimation.to(_s.arrowN_sdo.screen, .8, {css:{rotation:180}, ease:Quart.easeOut});
                FWDAnimation.to(_s.arrowS_sdo.screen, .8, {css:{rotation:180}, ease:Quart.easeOut});
            }
            _s.setNormalState(true);

        };
        
        _s.enable = function(){
            _s.isDble = false;
            if(FWDUVPUtils.hasTransform2d){
                FWDAnimation.to(_s.arrowN_sdo.screen, .8, {css:{rotation:0}, ease:Quart.easeOut});
                FWDAnimation.to(_s.arrowS_sdo.screen, .8, {css:{rotation:0}, ease:Quart.easeOut});
            }
            _s.setButtonMode(true);
        };
        
        _s.setText = function(text){
            if (FWDUVPUtils.isIEAndLessThen9){
                _s.text_sdo.screen.innerText = text;
            }else{
                _s.text_sdo.setInnerHTML(text);
            }
        };
    
        _s.init();
    };
    

    /* set prototype */
    FWDUVPComboBoxSelector.setPrototype = function(){
        FWDUVPComboBoxSelector.prototype = new FWDUVPDisplayObject ("div");
    };
    
    FWDUVPComboBoxSelector.FIRST_BUTTON_CLICK = "onFirstClick";
    FWDUVPComboBoxSelector.SECOND_BUTTON_CLICK = "secondButtonOnClick";
    FWDUVPComboBoxSelector.MOUSE_OVER = "onMouseOver";
    FWDUVPComboBoxSelector.MOUSE_OUT = "onMouseOut";
    FWDUVPComboBoxSelector.MOUSE_DOWN = "onMouseDown";
    FWDUVPComboBoxSelector.CLICK = "onClick";
    
    FWDUVPComboBoxSelector.prototype = null;
    window.FWDUVPComboBoxSelector = FWDUVPComboBoxSelector;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Complex button.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (){
var FWDUVPComplexButton = function(
            n1Img, 
            s1Path, 
            n2Img, 
            s2Path, 
            disptachMainEvent_bl,
            useHEX,
            nBC,
            sBC,
            iconCSSString, 
            icon2CSSString, 
            normalCalssName,
            selectedCalssName
        ){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPComplexButton.prototype;
        
        _s.iconCSSString = iconCSSString;
        _s.icon2CSSString = icon2CSSString;
        _s.normalCalssName = normalCalssName;
        _s.selectedCalssName = selectedCalssName;
        
        _s.n1Img = n1Img;
        _s.s1Path_str = s1Path;
        _s.n2Img = n2Img;
        _s.s2Path_str = s2Path;
        
        if(_s.n1Img){
            _s.buttonWidth = _s.n1Img.width;
            _s.buttonHeight = _s.n1Img.height;
        }
        
        _s.useHEX = useHEX;
        _s.nBC = nBC;
        _s.sBC = sBC;
        _s.currentState = 1;
        _s.disptachMainEvent_bl = disptachMainEvent_bl;
        _s.isMbl = FWDUVPUtils.isMobile;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
        _s.allowToCreateSecondButton_bl = !_s.isMbl || _s.hasPointerEvent_bl;
        _s.useFontAwesome_bl = Boolean(_s.iconCSSString);
        

        //##########################################//
        /* initialize */
        //##########################################//
        _s.init = function(){
            _s.hasTransform2d_bl = false;
            _s.setButtonMode(true);
            _s.setWidth(_s.buttonWidth);
            _s.setHeight(_s.buttonHeight);
            _s.setupMainContainers();
            _s.secondButton_do.setVisible(false);
            _s.setNormalState();
        };
        

        //##########################################//
        /* setup main containers */
        //##########################################//
        _s.setupMainContainers = function(){
            if(_s.useFontAwesome_bl){
                _s.setOverflow('visible');
                _s.firstButton_do = new FWDUVPDisplayObject("div");
                _s.firstButton_do.setOverflow('visible');
                _s.n1_do = new FWDUVPDisplayObject("div");  
                _s.n1_do.setInnerHTML(_s.iconCSSString);
                _s.firstButton_do.addChild(_s.n1_do);
                
                //Second button
                _s.secondButton_do = new FWDUVPDisplayObject("div");
                _s.secondButton_do.setOverflow('visible');
                _s.n2_do = new FWDUVPDisplayObject("div");  
                _s.n2_do.setInnerHTML(_s.icon2CSSString);
                _s.secondButton_do.addChild(_s.n2_do);
                
                _s.setFinalSize();
                
            }else{
            
                _s.firstButton_do = new FWDUVPDisplayObject("div");
                _s.firstButton_do.setWidth(_s.buttonWidth);
                _s.firstButton_do.setHeight(_s.buttonHeight);
                
                if(_s.useHEX){
                    _s.n1_do = new FWDUVPDisplayObject("div");
                    _s.n1_do.setWidth(_s.buttonWidth);
                    _s.n1_do.setHeight(_s.buttonHeight);
                    _s.n1_sdo_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.n1Img, _s.nBC).canvas;
                    _s.n1_do.screen.appendChild(_s.n1_sdo_canvas);          
                }else{
                    _s.n1_do = new FWDUVPDisplayObject("img");  
                    _s.n1_do.setScreen(_s.n1Img);
                }
                _s.firstButton_do.addChild(_s.n1_do);
                
                if(_s.allowToCreateSecondButton_bl){
                    
                    _s.s1_img = new Image();
                    _s.s1_img.src = _s.s1Path_str;
                    
                    if(_s.useHEX){
                        _s.s1_do = new FWDUVPTransformDisplayObject("div");
                        _s.s1_do.setWidth(_s.buttonWidth);
                        _s.s1_do.setHeight(_s.buttonHeight);
                        _s.s1_img.onload = function(){
                            _s.s1_do_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.s1_img, _s.sBC).canvas;
                            _s.s1_do.screen.appendChild(_s.s1_do_canvas);
                        }
                        _s.s1_do.setAlpha(0);
                    }else{
                        _s.s1_do = new FWDUVPDisplayObject("img");
                        _s.s1_do.setScreen(_s.s1_img);
                        _s.s1_do.setWidth(_s.buttonWidth);
                        _s.s1_do.setHeight(_s.buttonHeight);
                        _s.s1_do.setAlpha(0);
                    }
                    _s.firstButton_do.addChild(_s.s1_do);
                }
                            
                //Second button
                _s.secondButton_do = new FWDUVPDisplayObject("div");
                _s.secondButton_do.setWidth(_s.buttonWidth);
                _s.secondButton_do.setHeight(_s.buttonHeight);
                
                if(_s.useHEX){
                    _s.n2_do = new FWDUVPDisplayObject("div");
                    _s.n2_do.setWidth(_s.buttonWidth);
                    _s.n2_do.setHeight(_s.buttonHeight);
                    _s.n2_sdo_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.n2Img, _s.nBC).canvas;
                    _s.n2_do.screen.appendChild(_s.n2_sdo_canvas);          
                }else{
                    _s.n2_do = new FWDUVPDisplayObject("img");  
                    _s.n2_do.setScreen(_s.n2Img);
                }
                _s.secondButton_do.addChild(_s.n2_do);
                
                if(_s.allowToCreateSecondButton_bl){
                    
                    _s.s2_img = new Image();
                    _s.s2_img.src = _s.s2Path_str;
                    
                    if(_s.useHEX){
                        _s.s2_do = new FWDUVPTransformDisplayObject("div");
                        _s.s2_do.setWidth(_s.buttonWidth);
                        _s.s2_do.setHeight(_s.buttonHeight);
                        _s.s2_img.onload = function(){
                            _s.s2_do_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.s2_img, _s.sBC).canvas;
                            _s.s2_do.screen.appendChild(_s.s2_do_canvas);
                        }
                        _s.s2_do.setAlpha(0);
                    }else{
                        _s.s2_do = new FWDUVPDisplayObject("img");
                        _s.s2_do.setScreen(_s.s2_img);
                        _s.s2_do.setWidth(_s.buttonWidth);
                        _s.s2_do.setHeight(_s.buttonHeight);
                        _s.s2_do.setAlpha(0);
                    }
                    _s.secondButton_do.addChild(_s.s2_do);
                }   
            }
            
            _s.addChild(_s.secondButton_do);
            _s.addChild(_s.firstButton_do);
            
            if(_s.hasPointerEvent_bl){
                _s.screen.addEventListener("pointerup", _s.onMouseUp);
                _s.screen.addEventListener("pointerover", _s.onMouseOver);
                _s.screen.addEventListener("pointerout", _s.onMouseOut);
            }else if(_s.screen.addEventListener){   
                if(!_s.isMbl){
                    _s.screen.addEventListener("mouseover", _s.onMouseOver);
                    _s.screen.addEventListener("mouseout", _s.onMouseOut);
                    _s.screen.addEventListener("mouseup", _s.onMouseUp);
                }
                _s.screen.addEventListener("toustart", _s.onDown);
                _s.screen.addEventListener("touchend", _s.onMouseUp);
            }
        };
        
        _s.onMouseOver = function(e, animate){
            if(_s.isDisabled_bl || _s.isSelectedState_bl) return;
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE || e.pointerType == "mouse"){
                _s.dispatchEvent(FWDUVPComplexButton.MOUSE_OVER, {e:e});
                _s.dispatchEvent(FWDUVPComplexButton.SHOW_TOOLTIP, {e:e});
                _s.setSelectedState(true);
            }
        };
            
        _s.onMouseOut = function(e){
            if(_s.isDisabled_bl || !_s.isSelectedState_bl) return;
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE || e.pointerType == "mouse"){
                _s.setNormalState(true);
                _s.dispatchEvent(FWDUVPComplexButton.MOUSE_OUT);
            }
        };
        
        _s.onDown = function(e){
            if(e.preventDefault) e.preventDefault();
        };
    
        _s.onMouseUp = function(e){
            if(_s.isDisabled_bl || e.button == 2) return;
            if(e.preventDefault) e.preventDefault();
            if(!_s.isMbl) _s.onMouseOver(e, false);
            if(_s.disptachMainEvent_bl) _s.dispatchEvent(FWDUVPComplexButton.MOUSE_UP, {e:e});
        };
        
        _s.checkCount = 0;
        _s.setFinalSize = function(){
            
            clearInterval(_s.checkId_int);
            _s.lastWidth = _s.n1_do.screen.firstChild.offsetWidth;
            if(_s.checkCount > 5) return;
            _s.checkCount ++;
                
            _s.checkId_int = setInterval(function(){
                _s.setFinalSize();
            },100);
            
            if(_s.prevWidth == _s.lastWidth || _s.lastWidth == 0) return;
            var maxWidth = Math.max(_s.n1_do.screen.firstChild.offsetWidth, _s.n2_do.screen.firstChild.offsetWidth); 
            var maxHeight = Math.max(_s.n1_do.screen.offsetHeight, _s.n2_do.screen.firstChild.offsetHeight); 
            _s.buttonWidth = maxWidth;
            _s.buttonHeight = maxHeight;
            
            _s.setWidth(maxWidth);
            _s.setHeight(maxHeight);
            _s.firstButton_do.setWidth(_s.w);
            _s.firstButton_do.setHeight(_s.h);
            _s.secondButton_do.setWidth(_s.w);
            _s.secondButton_do.setHeight(_s.h);
            
            _s.n1_do.setX(Math.round((maxWidth - _s.n1_do.getWidth())/2));
            _s.n1_do.setY(Math.round((maxHeight - _s.n1_do.getHeight())/2));
            _s.n2_do.setX(Math.round((maxWidth - _s.n2_do.getWidth())/2));
            _s.n2_do.setY(Math.round((maxHeight - _s.n2_do.getHeight())/2));
        
        
            _s.prevWidth = _s.lastWidth;
        }

        
        //##############################//
        /* toggle button */
        //#############################//
        _s.toggleButton = function(){
            if(_s.currentState == 1){
                _s.firstButton_do.setVisible(false);
                _s.secondButton_do.setVisible(true);
                _s.currentState = 0;
                _s.dispatchEvent(FWDUVPComplexButton.FIRST_BUTTON_CLICK);
            }else{
                _s.firstButton_do.setVisible(true);
                _s.secondButton_do.setVisible(false);
                _s.currentState = 1;
                _s.dispatchEvent(FWDUVPComplexButton.SECOND_BUTTON_CLICK);
            }
        };
        

        //##############################//
        /* set second buttons state */
        //##############################//
        _s.setButtonState = function(state){
            if(state == 1){
                _s.firstButton_do.setVisible(true);
                _s.secondButton_do.setVisible(false);
                _s.currentState = 1; 
            }else{
                _s.firstButton_do.setVisible(false);
                _s.secondButton_do.setVisible(true);
                _s.currentState = 0; 
            }
            
        };

        
        //###############################//
        /* set normal state */
        //################################//
        _s.setNormalState = function(animate){
            if(_s.isMbl && !_s.hasPointerEvent_bl && !_s.useFontAwesome_bl) return;
            _s.isSelectedState_bl = false;
            FWDAnimation.killTweensOf(_s.s1_do);
            FWDAnimation.killTweensOf(_s.s2_do);
                
            if(_s.useFontAwesome_bl){
                FWDAnimation.killTweensOf(_s.n1_do.screen);
                FWDAnimation.killTweensOf(_s.n2_do.screen);
                    
                if(animate){
                    FWDAnimation.to(_s.n1_do.screen, .8, {className:_s.normalCalssName, ease:Expo.easeOut});    
                    FWDAnimation.to(_s.n2_do.screen, .8, {className:_s.normalCalssName, ease:Expo.easeOut});
                }else{
                    _s.n1_do.screen.className = _s.normalCalssName;
                    _s.n2_do.screen.className = _s.normalCalssName;
                }
            }else{
                FWDAnimation.to(_s.s1_do, .5, {alpha:0, ease:Expo.easeOut});    
                FWDAnimation.to(_s.s2_do, .5, {alpha:0, ease:Expo.easeOut});
            }
        };
        
        _s.setSelectedState = function(animate){
            _s.isSelectedState_bl = true;
            FWDAnimation.killTweensOf(_s.s1_do);
            FWDAnimation.killTweensOf(_s.s2_do);
            
            if(_s.useFontAwesome_bl){
                
                    FWDAnimation.killTweensOf(_s.n1_do.screen);
                    FWDAnimation.killTweensOf(_s.n2_do.screen);
                    if(animate){
                        FWDAnimation.to(_s.n1_do.screen, .8, {className:_s.selectedCalssName, ease:Expo.easeOut});  
                        FWDAnimation.to(_s.n2_do.screen, .8, {className:_s.selectedCalssName, ease:Expo.easeOut});  
                    }else{
                        _s.n1_do.screen.className = _s.selectedCalssName;
                        _s.n2_do.screen.className = _s.selectedCalssName;
                    }
            }else{
                FWDAnimation.to(_s.s1_do, .5, {alpha:1, delay:.1, ease:Expo.easeOut});
                FWDAnimation.to(_s.s2_do, .5, {alpha:1, delay:.1, ease:Expo.easeOut});
            }
        };
        
        _s.disable = function(){
            if(_s.isDisabled_bl) return;
            _s.isDisabled_bl = true;
            _s.setButtonMode(false);
            FWDAnimation.killTweensOf(_s);
            FWDAnimation.to(_s, .6, {alpha:.4});
            _s.setNormalState();
        };
        
        _s.enable = function(){
            if(!_s.isDisabled_bl) return;
            _s.isDisabled_bl = false;
            _s.setButtonMode(true);
            FWDAnimation.killTweensOf(_s);
            FWDAnimation.to(_s, .6, {alpha:1});
        };

        
        //##########################################//
        /* Update HEX color of a canvaas */
        //##########################################//
        _s.updateHEXColors = function(nBC, sBC){
            FWDUVPUtils.changeCanvasHEXColor(_s.n1Img, _s.n1_sdo_canvas, nBC);
            FWDUVPUtils.changeCanvasHEXColor(_s.s1_img, _s.s1_do_canvas, sBC);
            FWDUVPUtils.changeCanvasHEXColor(_s.n2Img, _s.n2_sdo_canvas, nBC);
            FWDUVPUtils.changeCanvasHEXColor(_s.s2_img, _s.s2_do_canvas, sBC);
        }
        
        _s.init();
    };
    
    
    /* set prototype */
    FWDUVPComplexButton.setPrototype = function(){
        FWDUVPComplexButton.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPComplexButton.FIRST_BUTTON_CLICK = "onFirstClick";
    FWDUVPComplexButton.SECOND_BUTTON_CLICK = "secondButtonOnClick";
    FWDUVPComplexButton.MOUSE_OVER = "onMouseOver";
    FWDUVPComplexButton.MOUSE_OUT = "onMouseOut";
    FWDUVPComplexButton.MOUSE_UP = "onMouseUp";
    FWDUVPComplexButton.CLICK = "onClick";
    FWDUVPComplexButton.SHOW_TOOLTIP = "showTooltip";
    
    FWDUVPComplexButton.prototype = null;
    window.FWDUVPComplexButton = FWDUVPComplexButton;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Right click context menu.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (){
    var FWDUVPContextMenu = function(prt, _d){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPContextMenu.prototype;
        _s.prt = prt;
        
        _s.buttonsTest_ar = ['copy_url', 'copy_url_time', 'fullscreen'];
        _s.itemsLabels_ar = ['Copy video URL', 'Copy video URL at current time', 'Fullscreen/Normalscreen'];
        _s.items_ar = [];
        _s.spacers_ar = [];

        _s.backgroundColor_str = _d.contextMenuBackgroundColor_str;
        _s.borderColor_str = _d.contextMenuBorderColor_str;
        _s.spacerColor_str = _d.contextMenuSpacerColor_str;
        _s.itemNormalColor_str = _d.contextMenuItemNormalColor_str;
        _s.itemSelectedColor_str = _d.contextMenuItemSelectedColor_str;
        _s.itemDisabledColor_str = _d.contextMenuItemDisabledColor_str;
        _s.draggingMode_str = _d.startDraggingMode_str;
        _s.link_str = _d.link_str;
        
        _s.borderRadius = 0;
        _s.biggestWidth;
        _s.totalWidth = 400;
        _s.totalHeight = 400;
        _s.sapaceBetweenButtons = 7;
        _s.padding = 6;
            
        _s.inverseNextAndPrevRotation_bl = _d.inverseNextAndPrevRotation_bl;
        _s.showScriptDeveloper_bl = _d.showScriptDeveloper_bl;
        
        _s.init = function(){
            
            if(_s.itemsLabels_ar || _s.showScriptDeveloper_bl){
                _s.show_bl = true;
                _s.setWidth(_s.totalWidth);
                _s.setHeight(_s.totalHeight);
                _s.setBkColor(_s.backgroundColor_str);
                _s.getStyle().borderColor = _s.borderColor_str;
                _s.getStyle().borderStyle = "solid";
                _s.getStyle().borderRadius = _s.borderRadius + "px";
                _s.getStyle().borderWidth = "1px";
                _s.setVisible(false);
                _s.setY(-2000);
                _s.prt.main_do.addChild(_s);
                
                _s.setupLabels();   
                _s.setupDeveloperButton();
                _s.setupSpacers();
                _s.disable();
                _s.getMaxWidthResizeAndPositionId_to = setTimeout(_s.getMaxWidthResizeAndPosition, 200);
            }
            
            _s.addContextEvent();
        };
        
        _s.copyText = function(str){
            var el = document.createElement('textarea');
            el.value = str;
            document.body.appendChild(el);
            el.select();
            document.execCommand('copy');
            document.body.removeChild(el);
        };
        

        //##########################################//
        /* Setup context items. */
        //##########################################//
        _s.setupLabels = function(){
            var len = _s.buttonsTest_ar.length;
            var res;
            var label1_str = "";
            var label2_str = "";
            
            if(!_s.itemsLabels_ar) return;
            
            for(var i=0; i<len; i++){
                res = _s.buttonsTest_ar[i]; 
                if(res == "copy_url"){
                    label1_str = _s.itemsLabels_ar[i];
                    FWDUVPContextMenuButton.setPrototype();
                    _s.copyURL_do = new FWDUVPContextMenuButton(label1_str, undefined, _s.itemNormalColor_str, _s.itemSelectedColor_str, _s.itemDisabledColor_str);
                    _s.items_ar.push(_s.copyURL_do);
                    _s.copyURL_do.addListener(FWDUVPContextMenuButton.MOUSE_DOWN, _s.copyURLHandler);
                    _s.addChild(_s.copyURL_do);
                }else if(res == "copy_url_time"){
                    label1_str = _s.itemsLabels_ar[i];
                    FWDUVPContextMenuButton.setPrototype();
                    _s.copyURLTime_do = new FWDUVPContextMenuButton(label1_str, undefined, _s.itemNormalColor_str, _s.itemSelectedColor_str, _s.itemDisabledColor_str);
                    _s.items_ar.push(_s.copyURLTime_do);
                    _s.copyURLTime_do.addListener(FWDUVPContextMenuButton.MOUSE_DOWN, _s.copyURLAtTimeHandler);
                    _s.addChild(_s.copyURLTime_do);
                }else if(res == "fullscreen"){
                    if(_d.showFullScreenButton_bl){
                        var str =  _s.itemsLabels_ar[i];
                        label1_str = str.substr(0, str.indexOf("/"));
                        label2_str = str.substr(str.indexOf("/") + 1);
                        
                        FWDUVPContextMenuButton.setPrototype();
                        _s.fullScreenButton_do = new FWDUVPContextMenuButton(label1_str, label2_str, _s.itemNormalColor_str, _s.itemSelectedColor_str, _s.itemDisabledColor_str);
                        _s.items_ar.push(_s.fullScreenButton_do);
                        _s.fullScreenButton_do.addListener(FWDUVPContextMenuButton.MOUSE_DOWN, _s.fullScreenStartHandler);
                        _s.addChild(_s.fullScreenButton_do);
                    }
                }
            }
        };
        
        _s.setupDeveloperButton = function(){
            if(_s.showScriptDeveloper_bl){
                if(!_s.itemsLabels_ar) _s.itemsLabels_ar = [];
                _s.itemsLabels_ar.push("&#0169; made by FWD");
                var label1_str = "&#0169; made by FWD";
                FWDUVPContextMenuButton.setPrototype();
                _s.developerButton_do = new FWDUVPContextMenuButton(label1_str, undefined, _s.itemNormalColor_str, _s.itemSelectedColor_str, _s.itemDisabledColor_str);
                _s.developerButton_do.isDeveleper_bl = true;
                _s.items_ar.push(_s.developerButton_do);
                _s.addChild(_s.developerButton_do);

            }
        };
        
        _s.copyURLAtTimeHandler = function(e){
            var curTime = prt.curTime;
            if(curTime.length == 5) curTime = '00:' + curTime;
            var time_ar = String(curTime).split(':');
            for(var i=0; i<time_ar.length; i++){
                if(time_ar[i] == '00') time_ar[i] = '0';
            }
            var args = FWDUVPUtils.getHashUrlArgs(window.location.hash);
            var href = location.href;

            href = href.replace(/&uvpi=.*/i, '');
            href = href.replace(/&playlistId=.*/i, '');
            href = href.replace(/playlistId=.*/i, '');
            href = href.replace(/&t=.*/i, '');
            
            if(location.href.indexOf('?') == -1){
                if(FWDUVPlayer.instaces_ar.length > 1){
                    curTime = href + '?uvpi=' + prt.instanceName_str + '&playlistId=' + prt.catId + '&videoId=' + prt.id;
                }else{
                    curTime = href + '?playlistId=' + prt.catId + '&videoId=' + prt.id;
                }
            }else{
                if(FWDUVPlayer.instaces_ar.length > 1){
                    curTime =href + '&uvpi=' + prt.instanceName_str + '&playlistId=' + prt.catId + '&videoId=' + prt.id;
                }else{
                    curTime = href + '&playlistId=' + prt.catId + '&videoId=' + prt.id;
                }
            }
            if(curTime.indexOf('t=') == -1) curTime = curTime + '&t=' + time_ar[0] +'h' + time_ar[1] +'m' + time_ar[2] +'s';
            _s.copyText(curTime);
            _s.removeMenuId_to = setTimeout(_s.removeFromDOM, 150);
        };
        
        
        _s.copyURLHandler = function(e){
            _s.copyText(location.href);
            _s.removeMenuId_to = setTimeout(_s.removeFromDOM, 150);
        };

        //full screen.
        _s.fullScreenStartHandler = function(e){
            if(_s.fullScreenButton_do.currentState == 0){
                prt.goFullScreen();
            }else if(_s.fullScreenButton_do.currentState == 1){
                prt.goNormalScreen();
            }
            _s.fullScreenButton_do.onMouseOut();
        };
        
        _s.updateFullScreenButton = function(currentState){
            if(!_s.fullScreenButton_do) return;
            if(currentState == 0){
                _s.fullScreenButton_do.setButtonState(0);
            }else{
                _s.fullScreenButton_do.setButtonState(1);
            }
            _s.removeMenuId_to = setTimeout(_s.removeFromDOM, 150);
        };
        
        
        //########################################//
        /* setup sapcers */
        //########################################//
        _s.setupSpacers = function(){
            var totalSpacers = _s.items_ar.length - 1;
            var spacer_sdo;
            
            for(var i=0; i<totalSpacers; i++){
                spacer_sdo = new FWDUVPDisplayObject("div");
                _s.spacers_ar[i] = spacer_sdo;
                spacer_sdo.setHeight(1);
                spacer_sdo.setBkColor(_s.spacerColor_str);
                _s.addChild(spacer_sdo);
            };
        };
        
        //########################################//
        /* Get max width and position */
        //#######################################//
        _s.getMaxWidthResizeAndPosition = function(){
            var totalItems = _s.items_ar.length;
            var item_do;
            var spacer;
            var finalX;
            var finalY;
            _s.totalWidth = 0;
            _s.totalHeight = 0;
            for(var i=0; i<totalItems; i++){
                item_do = _s.items_ar[i];
                if(item_do.getMaxTextWidth() > _s.totalWidth) _s.totalWidth = item_do.getMaxTextWidth();
            };
            
            for(var i=0; i<totalItems; i++){
                spacer = _s.spacers_ar[i - 1];
                item_do = _s.items_ar[i];
                item_do.setX(_s.padding);
                item_do.setY(10 + (i * (item_do.totalHeight + _s.sapaceBetweenButtons)) - _s.padding);
                
                if(spacer){
                    spacer.setWidth(_s.totalWidth + 2);
                    spacer.setX(_s.padding);
                    spacer.setY(parseInt(item_do.getY() - _s.sapaceBetweenButtons/2) - 1);
                };
                
                item_do.setWidth(_s.totalWidth + 2);
                item_do.centerText();
            }
            
            _s.totalHeight = item_do.getY() + item_do.totalHeight + 2;
            
            _s.setWidth(_s.totalWidth + _s.padding * 2 + 4);
            _s.setHeight(_s.totalHeight);
            
            _s.setVisible(true);
            _s.removeMenuId_to = setTimeout(_s.removeFromDOM, 150);
        };

        
        //##########################################//
        /* Add context events. */
        //##########################################//
        _s.addContextEvent = function(){
            if(_s.prt.main_do.screen.addEventListener){
                _s.prt.main_do.screen.addEventListener("contextmenu", _s.contextMenuHandler);
            }else{
                _s.prt.main_do.screen.attachEvent("oncontextmenu", _s.contextMenuHandler);
            }
        };
        
        _s.contextMenuHandler = function(e){    

            if(!_s.show_bl || !_d.showContextmenu_bl){
                if(e.preventDefault){
                    e.preventDefault();
                }else{
                    return false;
                }   
                return;
            }
            clearTimeout(_s.removeMenuId_to);
            _s.prt.main_do.addChild(_s);

            _s.positionButtons(e);
            _s.setAlpha(0);
            FWDAnimation.to(_s, .4, {alpha:1, ease:Quart.easeOut});
            
            if(window.addEventListener){
                window.addEventListener("mousedown", _s.contextMenuWindowOnMouseDownHandler);
                window.addEventListener("mouseup", _s.contextMenuWindowOnMouseDownHandler);
            }else{
                document.documentElement.attachEvent("onmousedown", _s.contextMenuWindowOnMouseDownHandler);
                document.documentElement.attachEvent("onmouseup", _s.contextMenuWindowOnMouseDownHandler);
            }
            
            if(e.preventDefault){
                e.preventDefault();
            }else{
                return false;
            }
        };
        
        _s.contextMenuWindowOnMouseDownHandler = function(e){
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);
            
            var screenX =  vc.screenX;
            var screenY =  vc.screenY;
            
            
            if(!FWDUVPUtils.hitTest(_s.screen, screenX, screenY)){
                if(window.removeEventListener){
                    window.removeEventListener("mousedown", _s.contextMenuWindowOnMouseDownHandler);
                    window.removeEventListener("mouseup", _s.contextMenuWindowOnMouseDownHandler);
                }else{
                    document.documentElement.detachEvent("onmousedown", _s.contextMenuWindowOnMouseDownHandler);
                    document.documentElement.detachEvent("onmouseup", _s.contextMenuWindowOnMouseDownHandler);
                }
                _s.removeMenuId_to = setTimeout(_s.removeFromDOM, 150);
            }
        };

    
        //####################################//
        /* position buttons */
        //####################################//
        _s.positionButtons = function(e){
        
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);
            var parentWidth = _s.prt.main_do.getWidth();
            var parentHeight = _s.prt.main_do.getHeight();
        
            var localX = vc.screenX - _s.prt.main_do.getGlobalX();
            var localY = vc.screenY - _s.prt.main_do.getGlobalY();
            var finalX = localX - 2;
            var finalY = localY - 2;
            _s.totalWidth = _s.getWidth();
            _s.totalHeight = _s.getHeight();
            
            if(finalX + _s.totalWidth > parentWidth - 2) finalX = localX - _s.totalWidth;
            if(finalX < 0) finalX = parseInt((parentWidth - _s.totalWidth)/2);
            if(finalX < 0) finalX = 0;
            
            if(finalY + _s.totalHeight > parentHeight - 2) finalY = localY - _s.totalHeight;
            if(finalY < 0) finalY = parseInt((parentHeight - _s.totalHeight)/2);
            if(finalY < 0) finalY = 0;
    
            _s.setX(finalX);
            _s.setY(finalY);            
        };
        

        //########################################//
        /* disable / enable */
        //########################################//
        _s.disable = function(){
            if(_s.copyURL_do) _s.copyURL_do.disable();
            if(_s.copyURLTime_do) _s.copyURLTime_do.disable();
            
        };
        
        _s.enable = function(){
            if(_s.copyURL_do) _s.copyURL_do.enable();
            if(_s.copyURLTime_do) _s.copyURLTime_do.enable();
        };

        
        //######################################//
        /* remove from DOM */
        //######################################//
        _s.removeFromDOM = function(){
            _s.setX(-5000);
        };
        
        _s.init();
    };
    
    FWDUVPContextMenu.setPrototype = function(){
        FWDUVPContextMenu.prototype = new FWDUVPDisplayObject("div");
    };
    
    
    FWDUVPContextMenu.prototype = null;
    window.FWDUVPContextMenu = FWDUVPContextMenu;
    
}(window));
/**
 * Ultimate Video Player PACKAGED v9.1
 * Right click context menu button.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (){
var FWDUVPContextMenuButton = function(
            label1, 
            label2, 
            normalColor,
            selectedColor,
            disabledColor,
            padding
        ){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPContextMenuButton.prototype;
        
        _s.label1_str = label1;
        _s.label2_str = label2;
        _s.nBC = normalColor;
        _s.sBC = selectedColor;
        _s.disabledColor_str = disabledColor;
        
        _s.totalWidth = 400;
        _s.totalHeight = 20;        
        _s.isMbl = FWDUVPUtils.isMobile;
        _s.currentState = 1;
        _s.showSecondButton_bl = label2 != undefined;


        //##########################################//
        /* initialize */
        //##########################################//
        _s.init = function(){
            _s.setBackfaceVisibility();
            _s.setButtonMode(true);
            _s.setupMainContainers();
            _s.setWidth(_s.totalWidth);
            _s.setHeight(_s.totalHeight);
            _s.setButtonState(0);
        };

        
        //##########################################//
        /* setup main containers */
        //##########################################//
        _s.setupMainContainers = function(){
            
            _s.text1_sdo = new FWDUVPDisplayObject("div");
            _s.text1_sdo.setBackfaceVisibility();
            _s.text1_sdo.setDisplay("inline-block");
            _s.text1_sdo.getStyle().fontFamily = "Arial";
            _s.text1_sdo.getStyle().fontSize= "12px";
            _s.text1_sdo.getStyle().color = _s.nBC;
            _s.text1_sdo.getStyle().fontSmoothing = "antialiased";
                    _s.text1_sdo.setInnerHTML(_s.label1_str);
            _s.addChild(_s.text1_sdo);
            
            if(_s.showSecondButton_bl){
                _s.text2_sdo = new FWDUVPDisplayObject("div");
                _s.text2_sdo.setBackfaceVisibility();
                _s.text2_sdo.setDisplay("inline-block");
                _s.text2_sdo.getStyle().fontFamily = "Arial";
                _s.text2_sdo.getStyle().fontSize= "12px";
                _s.text2_sdo.getStyle().color = _s.nBC;
                _s.text2_sdo.getStyle().fontSmoothing = "antialiased";
                _s.text2_sdo.setInnerHTML(_s.label2_str);
                _s.addChild(_s.text2_sdo);
            }
            
            _s.dumy_sdo = new FWDUVPDisplayObject("div");
            if(FWDUVPUtils.isIE){
                _s.dumy_sdo.setBkColor("#FF0000");
                _s.dumy_sdo.setAlpha(0);
            };
            _s.addChild(_s.dumy_sdo);
            
            if(_s.isMbl){
                _s.screen.addEventListener("touchstart", _s.onMouseDown);
            }else if(_s.screen.addEventListener){
                _s.screen.addEventListener("mouseover", _s.onMouseOver);
                _s.screen.addEventListener("mouseout", _s.onMouseOut);
                _s.screen.addEventListener("mousedown", _s.onMouseDown);
                _s.screen.addEventListener("click", _s.onClick);
            }
        };
        
        _s.onMouseOver = function(animate){
            if(_s.isDisabled_bl) return;
            FWDAnimation.killTweensOf(_s.text1_sdo);
            if(animate){
                FWDAnimation.to(_s.text1_sdo.screen, .5, {css:{color:_s.sBC}, ease:Expo.easeOut});
                if(_s.showSecondButton_bl) FWDAnimation.to(_s.text2_sdo.screen, .5, {css:{color:_s.sBC}, ease:Expo.easeOut});
            }else{
                _s.text1_sdo.getStyle().color = _s.sBC;
                if(_s.showSecondButton_bl){
                    FWDAnimation.killTweensOf(_s.text2_sdo);
                    _s.text2_sdo.getStyle().color = _s.sBC;
                }
            }
            _s.dispatchEvent(FWDUVPContextMenuButton.MOUSE_OVER);
        };
            
        _s.onMouseOut = function(e){
            if(_s.isDisabled_bl) return;
            FWDAnimation.killTweensOf(_s.text1_sdo);
            FWDAnimation.to(_s.text1_sdo.screen, .5, {css:{color:_s.nBC}, ease:Expo.easeOut});
            
            if(_s.showSecondButton_bl){
                FWDAnimation.killTweensOf(_s.text2_sdo);
                FWDAnimation.to(_s.text2_sdo.screen, .5, {css:{color:_s.nBC}, ease:Expo.easeOut});
            }
            _s.dispatchEvent(FWDUVPContextMenuButton.MOUSE_OUT);
        };
        
        _s.onClick = function(e){
            if(_s.isDeveleper_bl){
                window.open("http://www.webdesign-flash.ro", "_blank");
                return;
            }
            if(_s.isDisabled_bl) return;
            if(e.preventDefault) e.preventDefault();
            _s.dispatchEvent(FWDUVPContextMenuButton.CLICK);
        };
        
        _s.onMouseDown = function(e){
            if(_s.isDisabled_bl) return;
            if(e.preventDefault) e.preventDefault();
            _s.dispatchEvent(FWDUVPContextMenuButton.MOUSE_DOWN, {e:e});
        };
        

        //##############################//
        /* toggle button */
        //#############################//
        _s.toggleButton = function(){
            if(!_s.showSecondButton_bl ) return;
            if(_s.currentState == 1){
                _s.text1_sdo.setVisible(true);
                _s.text2_sdo.setVisible(false);
                _s.currentState = 0;
                _s.dispatchEvent(FWDUVPContextMenuButton.FIRST_BUTTON_CLICK);
            }else{
                _s.text1_sdo.setVisible(false);
                _s.text2_sdo.setVisible(true);
                _s.currentState = 1;
                _s.dispatchEvent(FWDUVPContextMenuButton.SECOND_BUTTON_CLICK);
            }
        };
        

        //##############################//
        /* set second buttons state */
        //##############################//
        _s.setButtonState = function(state){
            if(state == 0){
                _s.text1_sdo.setVisible(true);
                if(_s.showSecondButton_bl) _s.text2_sdo.setVisible(false);
                _s.currentState = 0;
            }else if(state == 1){
                _s.text1_sdo.setVisible(false);
                if(_s.showSecondButton_bl) _s.text2_sdo.setVisible(true);
                _s.currentState = 1;
            }
        };      


        //##########################################//
        /* center text */
        //##########################################//
        _s.centerText = function(){
            _s.dumy_sdo.setWidth(_s.totalWidth);
            _s.dumy_sdo.setHeight(_s.totalHeight);
            if(FWDUVPUtils.isIEAndLessThen9){
                _s.text1_sdo.setY(Math.round((_s.totalHeight - _s.text1_sdo.getHeight())/2) - 1);
                if(_s.showSecondButton_bl) _s.text2_sdo.setY(Math.round((_s.totalHeight - _s.text2_sdo.getHeight())/2) - 1);
            }else{
                _s.text1_sdo.setY(Math.round((_s.totalHeight - _s.text1_sdo.getHeight())/2));
                if(_s.showSecondButton_bl) _s.text2_sdo.setY(Math.round((_s.totalHeight - _s.text2_sdo.getHeight())/2));
            }
            _s.text1_sdo.setHeight(_s.totalHeight + 2);
            if(_s.showSecondButton_bl) _s.text2_sdo.setHeight(_s.totalHeight + 2);
        };
        

        //###############################//
        /* get max text width */
        //###############################//
        _s.getMaxTextWidth = function(){
            var w1 = _s.text1_sdo.getWidth();
            var w2 = 0;
            if(_s.showSecondButton_bl) w2 = _s.text2_sdo.getWidth();
            return Math.max(w1, w2);
        };

        
        //##############################//
        /* disable /enable button */
        //##############################//
        _s.disable = function(){
            _s.isDisabled_bl = true;
            FWDAnimation.killTweensOf(_s.text1_sdo);
            FWDAnimation.to(_s.text1_sdo.screen, .5, {css:{color:_s.disabledColor_str}, ease:Expo.easeOut});
            _s.setButtonMode(false);
        };
        
        _s.enable = function(){
            _s.isDisabled_bl = false;
            FWDAnimation.killTweensOf(_s.text1_sdo);
            FWDAnimation.to(_s.text1_sdo.screen, .5, {css:{color:_s.nBC}, ease:Expo.easeOut});
            _s.setButtonMode(true);
        };
        
        _s.init();
    };

    
    /* set prototype */
    FWDUVPContextMenuButton.setPrototype = function(){
        FWDUVPContextMenuButton.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPContextMenuButton.FIRST_BUTTON_CLICK = "onFirstClick";
    FWDUVPContextMenuButton.SECOND_BUTTON_CLICK = "secondButtonOnClick";
    FWDUVPContextMenuButton.MOUSE_OVER = "onMouseOver";
    FWDUVPContextMenuButton.MOUSE_OUT = "onMouseOut";
    FWDUVPContextMenuButton.MOUSE_DOWN = "onMouseDown";
    FWDUVPContextMenuButton.CLICK = "onClick";
    
    FWDUVPContextMenuButton.prototype = null;
    window.FWDUVPContextMenuButton = FWDUVPContextMenuButton;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Video controller.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function(){
var FWDUVPController = function(
            _d,
            prt
        ){
            
        'use strict';

        var _s = this;
        var prototype = FWDUVPController.prototype;
        
        _s._d = _d;
        _s.bkLeft_img = _d.bkLeft_img;
        _s.bkRight_img = _d.bkRight_img;
        _s.playN_img = _d.playN_img;
        _s.pauseN_img = _d.pauseN_img;
        _s.mainScrubberBkLeft_img = _d.mainScrubberBkLeft_img;
        _s.mainScrubberDragLeft_img = _d.mainScrubberDragLeft_img;
        _s.mainScrubberDragLeftSource = _d.mainScrubberDragLeft_img.src;
        _s.mainScrubberLine_img = _d.mainScrubberLine_img;
        _s.volumeScrubberBkLeft_img = _d.volumeScrubberBkLeft_img;
        _s.volumeScrubberDragBottom_img = _d.volumeScrubberDragBottom_img;
        _s.volumeScrubberLine_img = _d.volumeScrubberLine_img;
        _s.volumeN_img = _d.volumeN_img;
        _s.progressLeft_img = _d.progressLeft_img;
        _s.categoriesN_img = _d.categoriesN_img;
        _s.prt = prt;
        
        _s.playlistN_img = _d.playlistN_img;
        
        _s.ytbQualityN_img = _d.ytbQualityN_img;
        _s.infoN_img = _d.infoN_img;
        _s.downloadN_img = _d.downloadN_img;
        _s.facebookN_img = _d.facebookN_img;
        _s.fullScreenN_img = _d.fullScreenN_img;
        _s.normalScreenN_img = _d.normalScreenN_img;
        _s.hidePlaylistN_img = _d.hidePlaylistN_img;
        _s.showPlaylistN_img = _d.showPlaylistN_img;
        _s.embedN_img = _d.embedN_img;
    
        _s.buttons_ar = [];
        
        _s.useHEX = _d.useHEX; 
        _s.nBC = _d.nBC;
        _s.sBC = _d.sBC;
        
        _s.bkMiddlePath_str = _d.bkMiddlePath_str;
        _s.mainScrubberBkMiddlePath_str = _d.mainScrubberBkMiddlePath_str;
        _s.volumeScrubberBkMiddlePath_str = _d.volumeScrubberBkMiddlePath_str;
        _s.mainScrubberDragMiddlePath_str = _d.mainScrubberDragMiddlePath_str;
        _s.volumeScrubberDragMiddlePath_str = _d.volumeScrubberDragMiddlePath_str;
        _s.timeColor_str = _d.timeColor_str;
        _s.progressMiddlePath_str = _d.progressMiddlePath_str;
        _s.youtubeQualityButtonNormalColor_str = _d.youtubeQualityButtonNormalColor_str;
        _s.youtubeQualityButtonSelectedColor_str = _d.youtubeQualityButtonSelectedColor_str;
        _s.youtubeQualityArrowPath_str = _d.youtubeQualityArrowPath_str;
        _s.controllerBkPath_str = _d.controllerBkPath_str;
        _s.ytbQualityButtonPointerPath_str = _d.ytbQualityButtonPointerPath_str;
        _s.buttonsToolTipFontColor_str = _d.buttonsToolTipFontColor_str;
        
        _s.buttonsToolTipHideDelay = _d.buttonsToolTipHideDelay;
        _s.ttYtbBtns = 0;
        _s.sW = 0;
        _s.sH = _d.controllerHeight;
        _s.scrbsBkLARW = _s.mainScrubberBkLeft_img.width;
        _s.maiScrbW = 0;
        _s.mainScrbMinW = 100;
        _s.volumeScrubberOfsetHeight = _d.volumeScrubberOfsetHeight;
        _s.volumeScrubberHeight = _d.volumeScrubberHeight + _s.volumeScrubberOfsetHeight;
        _s.volScrbW = _s.mainScrubberBkLeft_img.height;
        _s.mainScrbH = _s.mainScrubberBkLeft_img.height;
        _s.mainScrbDrgLW = _s.mainScrubberDragLeft_img.width;
        _s.scrubbersOffsetWidth = _d.scrubbersOffsetWidth;
        _s.volume = _d.volume;
        
        _s.lastVolume = _s.volume;
        _s.startSpaceBetweenButtons = _d.startSpaceBetweenButtons;
        _s.spaceBetweenButtons = _d.spaceBetweenButtons;
        _s.percentPlayed = 0;
        _s.percentLoaded = 0;
        _s.lastTimeLength = 0;
        _s.prevYtbQualityButtonsLength = 0;
        _s.pointerWidth = 8;
        _s.pointerHeight = 5;
        _s.timeOffsetLeftWidth = _d.timeOffsetLeftWidth;
        _s.timeOffsetRightWidth = _d.timeOffsetRightWidth;
        _s.timeOffsetTop = _d.timeOffsetTop;
        _s.mainScrubberOffestTop = _d.mainScrubberOffestTop;
        
        _s.isVolumeScrubberShowed_bl = true;
        _s.volumeScrubberIsDragging_bl = false;
        _s.showButtonsToolTip_bl = _d.showButtonsToolTip_bl;
        _s.showPlaylistsButtonAndPlaylists_bl = _d.showPlaylistsButtonAndPlaylists_bl;
        _s.showPlaylistButtonAndPlaylist_bl = _d.showPlaylistButtonAndPlaylist_bl;
        _s.showEmbedButton_bl = _d.showEmbedButton_bl;
        _s.showPlaylistByDefault_bl = _d.showPlaylistByDefault_bl;
        _s.showShuffleButton_bl = _d.showShuffleButton_bl;
        _s.showLoopButton_bl = _d.showLoopButton_bl;
        
        _s.showNP_bl = prt._d.showNextAndPrevButtonsInController_bl;
        _s.showNextAndPrevButtonsInController_bl = _d.showNextAndPrevButtonsInController_bl;
        _s.showFullScreenButton_bl = _d.showFullScreenButton_bl;
        _s.disableVideoScrubber_bl = _d.disableVideoScrubber_bl;
        _s.showYoutubeQualityButton_bl = _d.showYoutubeQualityButton_bl;
        _s.showShareButton_bl = _d.showShareButton_bl;
        _s.showInfoButton_bl = _d.showInfoButton_bl;
        _s.showDownloadVideoButton_bl = _d.showDownloadVideoButton_bl;
        _s.showVolumeScrubber_bl = _d.showVolumeScrubber_bl;
        _s.allowToChangeVolume_bl = _d.allowToChangeVolume_bl;
        _s.showTime_bl = _d.showTime_bl;
        _s.showVolumeButton_bl = _d.showVolumeButton_bl;
        _s.showControllerWhenVideoIsStopped_bl = _d.showControllerWhenVideoIsStopped_bl;
        _s.showRewindButton_bl = _d.showRewindButton_bl;
        _s.showSubBtn = _d.showSubBtn;
        _s.muted = prt._d.autoPlay_bl;
        _s.isShowed_bl = true;
        _s.showNextAndPrevButtons_bl = _d.showNextAndPrevButtons_bl;
        _s.isPlaylistShowed_bl = _d.isPlaylistShowed_bl;
        _s.areYtbQualityButtonsShowed_bl = true;
        _s.repeatBackground_bl = _d.repeatBackground_bl;
        _s.isMbl = FWDUVPUtils.isMobile;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
        _s.useVectorIcons_bl = _d.useVectorIcons_bl


        //##########################################//
        /* initialize */
        //##########################################//
        _s.init = function(){
            _s.setOverflow("visible");
            _s.mainHld = new FWDUVPDisplayObject("div");
            if(_d.useAToB) _s.setupATB();

            if(_s.repeatBackground_bl){
                _s.bk_do = new FWDUVPDisplayObject("div");
                _s.bk_do.getStyle().background = "url('" + _s.controllerBkPath_str +  "')";
            }else{
                _s.bk_do = new FWDUVPDisplayObject("img");
                var img = new Image();
                img.src = _s.controllerBkPath_str;
                _s.bk_do.setScreen(img);    
            }
            _s.mainHld.addChild(_s.bk_do);
            
            _s.mainHld.setOverflow("visible");
            _s.mainHld.getStyle().zIndex = 1;
        
            _s.addChild(_s.mainHld);
            
            if(_s.showYoutubeQualityButton_bl){
                _s.ytbQuality_ar = ["hd4320", "hd2880","hd2160", "hd1440", "highres", "hd1080", "hd720", "large", "medium", "small", "tiny"];
                
                _s.ytbButtons_ar = [];
                _s.ttYtbBtns = _s.ytbQuality_ar.length;
                _s.setupYtbButtons();
            }
            
            if(_s.showNextAndPrevButtonsInController_bl) _s.setupPrevButton();
            _s.setupPlayPauseButton();
            if(_s.showRewindButton_bl) _s.setupRewindButton();
            if(_s.showNextAndPrevButtonsInController_bl) _s.setupNextButton();
            _s.setupMainScrubber();
            if(_s.showTime_bl) _s.setupTime();
            
            if(_s.showVolumeButton_bl) _s.setupVolumeButton();
            
            if(_s.showPlaylistsButtonAndPlaylists_bl) _s.setupCategoriesButton();
            if(_s.showPlaylistButtonAndPlaylist_bl) _s.setupPlaylistButton();

            if(_s.showYoutubeQualityButton_bl) _s.setupYoutubeQualityButton();
            
            if(_s.showShareButton_bl) _s.setupShareButton();
            if(_s.showEmbedButton_bl) _s.setupEmbedButton();
            if(_d.useAToB) _s.setupAtbButton();

            if(_s.showInfoButton_bl) _s.setupInfoButton();
            
            if(_d.showPlaybackRateButton_bl) _s.setupPlaybackRateButton();
            if(_s.showDownloadVideoButton_bl) _s.setupDownloadButton();
            if(_s.showSubBtn) _s.setupSubtitleButton();
            if(_d.showChromecastButton_bl) _s.setupChromecastButton();
            if(_d.showAudioTracksButton_bl) _s.setupAudioTracksButton();
            if(_d.show360DegreeVideoVrButton_bl) _s.setupVrButton();
            if(_s.showFullScreenButton_bl) _s.setupFullscreenButton();
            if(_s.showButtonsToolTip_bl) _s.setupToolTips();
            
            if(_s.showVolumeScrubber_bl){
                _s.setupVolumeScrubber();
                _s.hideVolumeScrubber();
            }
            _s.hide(false);
        };

        
        //###########################################//
        // Resize and position _s...
        //###########################################//
        _s.resizeAndPosition = function(){

            _s.sW = prt.tempVidStageWidth;
            _s.positionButtons();
            _s.setY(prt.tempVidStageHeight - _s.sH);
            _s.hideQualityButtons(false);
            if(_s.ytbButtonsHolder_do){
                FWDAnimation.killTweensOf(_s.ytbButtonsHolder_do);
                _s.ytbButtonsHolder_do.setY(prt.tempStageHeight);
            }
            
            if(_s.subtitlesButtonsHolder_do){
                FWDAnimation.killTweensOf(_s.subtitlesButtonsHolder_do);
                _s.subtitlesButtonsHolder_do.setY(prt.sH);
            }

            if(_s.ATBButtonsHolder_do){
                FWDAnimation.killTweensOf(_s.ATBButtonsHolder_do);
                _s.ATBButtonsHolder_do.setY(prt.sH);
            }
            
            if(_s.playbackRatesButtonsHolder_do){
                FWDAnimation.killTweensOf(_s.playbackRatesButtonsHolder_do);
                _s.playbackRatesButtonsHolder_do.setY(prt.sH);
            }
            
            _s.positionAdsLines();
        };
        
        _s.getButtonIndex = function(button){
            return FWDUVPUtils.indexOfArray(_s.buttons_ar, button);
        }
        
        
        //##############################//
        /* setup background */
        //##############################//
        _s.positionButtons = function(){
            if(!_s.sW) return;
            var button;
            var prevButton;
            var totalButtons = 0;
            var totalButtonsWidth = 0;
            var spaceBetweenButtons = 0;
            var leftWidth = 0;
            var hasTime_bl = _s.showTime_bl;
            var indexToAdd;
            
            if(!_d.playlist_ar || !_d.playlist_ar[prt.id]) return;

            
            if(prt.is360 && _s.vrButton_do){
                _s.addVrButton();
            }else{
                _s.removeVrButton();
            }
            
            // download button
            if(_s.showDownloadVideoButton_bl){
                if(_d.playlist_ar[prt.id]['downloadable']){
                    if(_s.getButtonIndex(_s.downloadButton_do) == -1){
                        if(_s.ccBtn_do && _s.getButtonIndex(_s.ccBtn_do) != -1){
                            indexToAdd = _s.getButtonIndex(_s.ccBtn_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.downloadButton_do);
                        }else if(_s.vrButton_do){
                            indexToAdd = _s.getButtonIndex(_s.vrButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.downloadButton_do);
                        }else if(_s.fullScreenButton_do){
                            indexToAdd = _s.getButtonIndex(_s.fullScreenButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.downloadButton_do);
                        }else{
                            _s.buttons_ar.splice(_s.buttons_ar.length,0, _s.downloadButton_do);
                        }
                        _s.downloadButton_do.setVisible(true);
                    }
                }else{
                    var downloadButtonIndex = _s.getButtonIndex(_s.downloadButton_do);
                    if(downloadButtonIndex != -1){
                        _s.buttons_ar.splice(downloadButtonIndex,1);
                        _s.downloadButton_do.setVisible(false);
                    }
                }
            };
            
            // info button
            if(_s.showInfoButton_bl){
                if(_d.playlist_ar[prt.id].desc){
                    if(_s.getButtonIndex(_s.infoButton_do) == -1){
                        if(_s.downloadButton_do && _s.getButtonIndex(_s.downloadButton_do) != -1){
                            indexToAdd = _s.getButtonIndex(_s.downloadButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.infoButton_do);
                        }else if(_s.ccBtn_do && _s.getButtonIndex(_s.ccBtn_do) != -1){
                            indexToAdd = _s.getButtonIndex(_s.ccBtn_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.infoButton_do);
                        }else if(_s.vrButton_do){
                            indexToAdd = _s.getButtonIndex(_s.vrButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.infoButton_do);
                        }else if(_s.fullScreenButton_do){
                            indexToAdd = _s.getButtonIndex(_s.fullScreenButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.infoButton_do);
                        }else{
                            _s.buttons_ar.splice(_s.buttons_ar.length,0, _s.infoButton_do);
                        }
                        _s.infoButton_do.setVisible(true);
                    }
                }else{
                    var downloadButtonIndex = _s.getButtonIndex(_s.infoButton_do);
                    if(downloadButtonIndex != -1){
                        _s.buttons_ar.splice(downloadButtonIndex,1);
                        _s.infoButton_do.setVisible(false);
                    }
                }
            };
    
            // a to be buttons
            if(_d['useAToB']){
                if(_d.playlist_ar[prt.id]['atb']){
                    if(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.atbButton_do) == -1){
                        if(_s.infoButton_do && _s.getButtonIndex(_s.infoButton_do) != -1){
                            indexToAdd = _s.getButtonIndex(_s.infoButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.atbButton_do);
                        }else if(_s.downloadButton_do && _s.getButtonIndex(_s.downloadButton_do) != -1){
                            indexToAdd = _s.getButtonIndex(_s.downloadButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.atbButton_do);
                        }else if(_s.ccBtn_do && _s.getButtonIndex(_s.ccBtn_do) != -1){
                            indexToAdd = _s.getButtonIndex(_s.ccBtn_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.atbButton_do);
                        }else if(_s.vrButton_do){
                            indexToAdd = _s.getButtonIndex(_s.vrButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.atbButton_do);
                        }else if(_s.fullScreenButton_do){
                            indexToAdd = _s.getButtonIndex(_s.fullScreenButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.atbButton_do);
                        }else{
                            _s.buttons_ar.splice(_s.buttons_ar.length,0, _s.atbButton_do);
                        }
                        _s.atbButton_do.setVisible(true);
                    }
                }else{
                    var atbButtonIndex = FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.atbButton_do);
                    if(atbButtonIndex != -1){
                        _s.buttons_ar.splice(atbButtonIndex,1);
                        _s.atbButton_do.setVisible(false);
                        _s.atb.hide(true);
                    }
                }
            };

            // Subtitle button
            if(_s.showSubBtn){
                if(_d.playlist_ar[prt.id].subtitleSource){
                    if(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.subtitleButton_do) == -1){
                        if(_s.playbackRateButton_do && _s.getButtonIndex(_s.playbackRateButton_do) != -1){
                            indexToAdd = _s.getButtonIndex(_s.playbackRateButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.subtitleButton_do);
                        }else if(_s.atbButton_do && _s.getButtonIndex(_s.atbButton_do) != -1){
                            indexToAdd = _s.getButtonIndex(_s.atbButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.subtitleButton_do);
                        }else if(_s.infoButton_do && _s.getButtonIndex(_s.infoButton_do) != -1){
                            indexToAdd = _s.getButtonIndex(_s.infoButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.subtitleButton_do);
                        }else if(_s.downloadButton_do && _s.getButtonIndex(_s.downloadButton_do) != -1){
                            indexToAdd = _s.getButtonIndex(_s.downloadButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.subtitleButton_do);
                        }else if(_s.ccBtn_do && _s.getButtonIndex(_s.ccBtn_do) != -1){
                            indexToAdd = _s.getButtonIndex(_s.ccBtn_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.subtitleButton_do);
                        }else if(_s.vrButton_do){
                            indexToAdd = _s.getButtonIndex(_s.vrButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.subtitleButton_do);
                        }else if(_s.fullScreenButton_do){
                            indexToAdd = _s.getButtonIndex(_s.fullScreenButton_do);
                            _s.buttons_ar.splice(indexToAdd, 0, _s.subtitleButton_do);
                        }else{
                            _s.buttons_ar.splice(_s.buttons_ar.length,0, _s.subtitleButton_do);
                        }
                        _s.subtitleButton_do.setVisible(true);
                    }
                }else{
                    var subtitleButtonIndex = FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.subtitleButton_do);
                    if(subtitleButtonIndex != -1){
                        _s.buttons_ar.splice(subtitleButtonIndex,1);
                        _s.subtitleButton_do.setVisible(false);
                        _s.subtitleButton_do.setX(-5000);
                    }
                }
            };
            

            
            if(prt.videoType_str == FWDUVPlayer.VIMEO && !_d.showDefaultControllerForVimeo_bl){
                
                var playButtonIndex = FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.playPauseButton_do);
                if(playButtonIndex != -1){
                    _s.buttons_ar.splice(playButtonIndex, 1);
                    _s.playPauseButton_do.setVisible(false);
                    _s.playPauseButton_do.setX(-500);
                }
                _s.mainScrubber_do.setVisible(false);
            }else{
                if(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.playPauseButton_do) == -1){
                    if(_s.playPauseButton_do){
                        indexToAdd = 0;
                        _s.buttons_ar.splice(indexToAdd, 0, _s.playPauseButton_do);
                        _s.playPauseButton_do.setVisible(true);
                    }
                }
                
                if(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.rewindButton_do) == -1){
                    if(_s.rewindButton_do){
                        indexToAdd = FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.playPauseButton_do);
                        _s.buttons_ar.splice(indexToAdd, 0, _s.rewindButton_do);
                        _s.rewindButton_do.setVisible(true);
                    }
                }
            
                if(_s.showVolumeButton_bl){
                    if(_s.showTime_bl){
                        if(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.volBtn) == -1){
                            indexToAdd = FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.time_do) + 1;
                            _s.buttons_ar.splice(indexToAdd, 0, _s.volBtn);
                            _s.volBtn.setVisible(true);
                        }
                    }else{
                        if(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.volBtn) == -1){
                            indexToAdd = FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.mainScrubber_do) + 1;
                            _s.buttons_ar.splice(indexToAdd, 0, _s.volBtn);
                            _s.volBtn.setVisible(true);
                        }
                    }
                }
                
                _s.mainScrubber_do.setVisible(true);
            }
        
            
            var buttonsCopy_ar = [];
            for (var i=0; i < _s.buttons_ar.length; i++) {
                buttonsCopy_ar[i] = _s.buttons_ar[i];
            }
            
            if(prt.tempPlaylistPosition_str == "right" 
                && _s.showNextAndPrevButtonsInController_bl
                && !_s.showNP_bl){
                if(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.nextButton_do) != -1){
                    buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.nextButton_do), 1);
                    buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.prevButton_do), 1);
                    _s.nextButton_do.setX(-1000);
                    _s.prevButton_do.setX(-1000);
                }
            }
            
            _s.maiScrbW = _s.sW - _s.startSpaceBetweenButtons * 2;
            for (var i=0; i < buttonsCopy_ar.length; i++) {
                button = buttonsCopy_ar[i];
                if(button != _s.mainScrubber_do){
                    _s.maiScrbW -= button.w + _s.spaceBetweenButtons;
                }
            };
        
            if(prt.videoType_str == FWDUVPlayer.VIMEO && _s.maiScrbW >= 120 && !_d.showDefaultControllerForVimeo_bl){
                if(_s.mainScrubber_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.mainScrubber_do) != -1){
                    buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.mainScrubber_do), 1);
                    _s.positionScrollBarOnTopOfTheController();
                }
                
                if(_s.time_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.time_do) != -1){
                    buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.time_do), 1);
                    _s.time_do.setX(-1000);
                }
                
                totalButtons = buttonsCopy_ar.length;
                for(var i=0; i<totalButtons; i++){
                    totalButtonsWidth += buttonsCopy_ar[i].w;
                }
                
                spaceBetweenButtons = _s.spaceBetweenButtons;
                leftWidth = _s.sW - buttonsCopy_ar[totalButtons - 1].w - _s.startSpaceBetweenButtons - 2;
                
                for (var i=totalButtons - 1; i>=0 ; i--) {
                    
                    button = buttonsCopy_ar[i];
                    if(i == totalButtons - 1){
                        button.setX(leftWidth);
                    }else{
                        prevButton = buttonsCopy_ar[i + 1];
                        button.setX(prevButton.x - button.w - spaceBetweenButtons); 
                    }
                }
            
            }else if(_s.maiScrbW <= 120 || prt.videoType_str == FWDUVPlayer.VIMEO && !_d.showDefaultControllerForVimeo_bl){
                if(_s.mainScrubber_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.mainScrubber_do) != -1){
                    buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.mainScrubber_do), 1);
                    _s.positionScrollBarOnTopOfTheController();
                }
                
                if(_s.time_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.time_do) != -1){
                    buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.time_do), 1);
                    _s.time_do.setX(-1000);
                }
                
                totalButtons = buttonsCopy_ar.length;
                for(var i=0; i<totalButtons; i++){
                    totalButtonsWidth += buttonsCopy_ar[i].w;
                }
            
                    spaceBetweenButtons = parseInt((_s.sW - totalButtonsWidth - _s.startSpaceBetweenButtons * 2)/(totalButtons - 1));
                    leftWidth = parseInt((_s.sW - totalButtonsWidth - ((totalButtons - 1) * spaceBetweenButtons))/2);
                    
                    for (var i=0; i < totalButtons; i++) {
                        button = buttonsCopy_ar[i];
                        if(i == 0){
                            button.setX(leftWidth);
                        }else{
                            prevButton = buttonsCopy_ar[i - 1];
                            button.setX(prevButton.x + prevButton.w + spaceBetweenButtons); 
                        }
                    }
            }else{
                while(_s.maiScrbW < _s.mainScrbMinW){
                    _s.maiScrbW = _s.sW - _s.startSpaceBetweenButtons * 2;
                    if(_s.time_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.time_do) != -1){
                        buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.time_do), 1);
                        _s.time_do.setX(-1000);
                        hasTime_bl = false;
                    }else if(_s.shareButton_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.shareButton_do) != -1){
                        buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.shareButton_do), 1);
                        _s.shareButton_do.setX(-1000);
                    }else if(_s.downloadButton_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.downloadButton_do) != -1){
                        buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.downloadButton_do), 1);
                        _s.downloadButton_do.setX(-1000);
                    }else if(_s.embedButton_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.embedButton_do) != -1){
                        buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.embedButton_do), 1);
                        _s.embedButton_do.setX(-1000);
                    }else if(_s.volBtn && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.volBtn) != -1){
                        buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.volBtn), 1);
                        _s.volBtn.setX(-1000);
                    }else if(_s.playbackRateButton_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.playbackRateButton_do) != -1){
                        buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.playbackRateButton_do), 1);
                        _s.playbackRateButton_do.setX(-1000);
                    }else if(_s.ytbQualityButton_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.ytbQualityButton_do) != -1){
                        buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.ytbQualityButton_do), 1);
                        _s.ytbQualityButton_do.setX(-1000);
                    }else if(_s.playlistButton_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.playlistButton_do) != -1){
                        buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.playlistButton_do), 1);
                        _s.playlistButton_do.setX(-1000);
                    }else if(_s.infoButton_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.infoButton_do) != -1){
                        buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.infoButton_do), 1);
                        _s.infoButton_do.setX(-1000);
                    }else if(_s.categoriesButton_do && FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.categoriesButton_do) != -1){
                        buttonsCopy_ar.splice(FWDUVPUtils.indexOfArray(buttonsCopy_ar, _s.categoriesButton_do), 1);
                        _s.categoriesButton_do.setX(-1000);
                    }
                            
                    totalButtons = buttonsCopy_ar.length;
                    for (var i=0; i < totalButtons; i++) {
                        button = buttonsCopy_ar[i];
                        if(button != _s.mainScrubber_do){
                            _s.maiScrbW -= button.w + _s.spaceBetweenButtons;
                        }
                    };
                };
                
                if(_s.showNextAndPrevButtonsInController_bl
                    && _s.maiScrbW > 120){          
                }
                
                if(hasTime_bl) _s.maiScrbW -= _s.timeOffsetLeftWidth * 2;
                totalButtons = buttonsCopy_ar.length;
                
                for (var i=0; i < totalButtons; i++) {
                    button = buttonsCopy_ar[i];
                    
                    if(i == 0){
                        button.setX(_s.startSpaceBetweenButtons);
                    }else if(button == _s.mainScrubber_do){
                        prevButton = buttonsCopy_ar[i - 1];
                        FWDAnimation.killTweensOf(_s.mainScrubber_do);
                        _s.mainScrubber_do.setX(prevButton.x + prevButton.w + _s.spaceBetweenButtons);
                        _s.mainScrubber_do.setY(parseInt((_s.sH - _s.mainScrbH)/2));
                        _s.mainScrubber_do.setWidth(_s.maiScrbW + 1);
                        _s.mainScrubberBkMiddle_do.setWidth(_s.maiScrbW - _s.scrbsBkLARW * 2);
                        _s.mainScrubberBkRight_do.setX(_s.maiScrbW - _s.scrbsBkLARW);
                        _s.mainScrubberDragMiddle_do.setWidth(_s.maiScrbW - _s.scrbsBkLARW - _s.scrubbersOffsetWidth);
                    }else if(button == _s.time_do){
                        prevButton = buttonsCopy_ar[i - 1];
                        button.setX(prevButton.x + prevButton.w + _s.spaceBetweenButtons + _s.timeOffsetLeftWidth);
                        var timeOffset = 0;
                        if(_s.isLive) timeOffset = 1;
                        button.setY(parseInt((_s.sH - button.h)/2) + timeOffset);
                    }else if(button == _s.volBtn && hasTime_bl){
                        prevButton = buttonsCopy_ar[i - 1];
                        button.setX(prevButton.x + prevButton.w + _s.spaceBetweenButtons + _s.timeOffsetRightWidth);
                    }else{
                        prevButton = buttonsCopy_ar[i - 1];
                        button.setX(prevButton.x + prevButton.w + _s.spaceBetweenButtons);
                    }
                }
                
                if(_s.isShowed_bl){
                    _s.isMainScrubberOnTop_bl = false;
                }else{
                    _s.isMainScrubberOnTop_bl = true;
                    _s.positionScrollBarOnTopOfTheController();
                }
            }
        
            if(_s.bk_do){
                _s.bk_do.setWidth(_s.sW);
                _s.bk_do.setHeight(_s.sH);
            }
            
            if(_s.progressMiddle_do) _s.progressMiddle_do.setWidth(Math.max(_s.maiScrbW - _s.scrbsBkLARW - _s.scrubbersOffsetWidth, 0));
            _s.updateMainScrubber(_s.percentPlayed);
            _s.updatePreloaderBar(_s.percentLoaded);
            
            _s.mainHld.setWidth(_s.sW);
            _s.mainHld.setHeight(_s.sH);
            _s.setWidth(_s.sW);
            _s.setHeight(_s.sH);

            if(_s.atb) _s.atb.resize();
        };
        
        _s.positionScrollBarOnTopOfTheController = function(){
            
            _s.maiScrbW = _s.sW;
            _s.updatePreloaderBar(_s.percentLoaded);
            
            _s.mainScrubber_do.setWidth(_s.maiScrbW + 1);
            _s.mainScrubberBkMiddle_do.setWidth(_s.maiScrbW - _s.scrbsBkLARW * 2);
            _s.mainScrubberBkRight_do.setX(_s.maiScrbW - _s.scrbsBkLARW);
            _s.mainScrubberDragMiddle_do.setWidth(_s.maiScrbW - _s.scrbsBkLARW - _s.scrubbersOffsetWidth);
            
            var offset = 0;
            if(_s.atb && _s.atb.isShowed_bl) offset = _s.sH;
            
            FWDAnimation.killTweensOf(_s.mainScrubber_do);
            _s.mainScrubber_do.setX(0);
            _s.mainScrubber_do.setAlpha(1);
            
            if(_s.isMainScrubberOnTop_bl || _s.isShowed_bl){
                if(_s.atb && _s.atb.isShowed_bl && !_s.isShowed_bl){
                    offset += _s.mainScrubberOffestTop;
                }else{
                    offset = 0;
                }
                
                FWDAnimation.killTweensOf(_s.mainScrubber_do);
                if(_s.isShowed_bl){
                    _s.mainScrubber_do.setY(- _s.mainScrubberOffestTop - offset);
                }else{
                    FWDAnimation.to(_s.mainScrubber_do, .8, {y:- _s.mainScrubberOffestTop - offset, ease:Expo.easeOut});
                }
            }else if(!_s.isLive){
                
                FWDAnimation.to(_s.mainScrubber_do, .8, {y:- _s.mainScrubberOffestTop - offset, ease:Expo.easeOut});
            }
            
            _s.isMainScrubberOnTop_bl = true;
        };
    
            
        //################################//
        /* Setup tooltips */
        //################################//        
        _s.setupToolTips = function(){
            FWDUVPToolTip.setPrototype();
            _s.playPauseToolTip_do = new FWDUVPToolTip(_s.playPauseButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "play / pause", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
            document.documentElement.appendChild(_s.playPauseToolTip_do.screen);
            
            if(_s.showControllerWhenVideoIsStopped_bl){
                FWDUVPToolTip.setPrototype();
                _s.prevButtonToolTip_do = new FWDUVPToolTip(_s.prevButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "previous video", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.prevButtonToolTip_do.screen);
                
                FWDUVPToolTip.setPrototype();
                _s.nextButtonToolTip_do = new FWDUVPToolTip(_s.nextButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "next video", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.nextButtonToolTip_do.screen);
            }
            
            if(_s.showPlaylistsButtonAndPlaylists_bl){
                FWDUVPToolTip.setPrototype();
                _s.playlistsButtonToolTip_do = new FWDUVPToolTip(_s.categoriesButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "show playlists", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.playlistsButtonToolTip_do.screen);
            }
            
            if(_s.showPlaylistButtonAndPlaylist_bl){
                FWDUVPToolTip.setPrototype();
                _s.playlistButtonToolTip_do = new FWDUVPToolTip(_s.playlistButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "show / hide playlist", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.playlistButtonToolTip_do.screen);
            }
            
            if(_s.showEmbedButton_bl){
                FWDUVPToolTip.setPrototype();
                _s.embedButtonToolTip_do = new FWDUVPToolTip(_s.embedButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "show embed window", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.embedButtonToolTip_do.screen);
            }
            
            if(_s.showShareButton_bl){
                FWDUVPToolTip.setPrototype();
                _s.facebookButtonToolTip_do = new FWDUVPToolTip(_s.shareButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "share", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.facebookButtonToolTip_do.screen);
            }
            
            if(_d.showChromecastButton_bl){
                FWDUVPToolTip.setPrototype();
                _s.castButtonToolTip_do = new FWDUVPToolTip(_s.ccBtn_do, _d.toopTipBk_str, _d.toopTipPointer_str, "chromecast", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.castButtonToolTip_do.screen);
            }

            FWDUVPToolTip.setPrototype();
            _s.atbButtonToolTip_do = new FWDUVPToolTip(_s.atbButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "a to b loop", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
            document.documentElement.appendChild(_s.atbButtonToolTip_do.screen);
            
            if(_s.showSubBtn){
                FWDUVPToolTip.setPrototype();
                _s.subtitleButtonToolTip_do = new FWDUVPToolTip(_s.subtitleButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "show / hide subtitle", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.subtitleButtonToolTip_do.screen);
            }
            
            
            if(_s.showInfoButton_bl){
                FWDUVPToolTip.setPrototype();
                _s.infoButtonToolTip_do = new FWDUVPToolTip(_s.infoButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "more info", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.infoButtonToolTip_do.screen);
            }
            
            if(_s.showDownloadVideoButton_bl){
                FWDUVPToolTip.setPrototype();
                _s.downloadButtonToolTip_do = new FWDUVPToolTip(_s.downloadButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "download video", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.downloadButtonToolTip_do.screen);
            }
            
            if(_s.fullScreenButton_do){
                FWDUVPToolTip.setPrototype();
                _s.fullscreenButtonToolTip_do = new FWDUVPToolTip(_s.fullScreenButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "fullscreen / normalscreen", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.fullscreenButtonToolTip_do.screen);
            }

            if(_s.vrButton_do){
                FWDUVPToolTip.setPrototype();
                _s.vrToolTip_do = new FWDUVPToolTip(_s.vrButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "VR", _s.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.vrToolTip_do.screen);
            }
        };
        
        _s.showToolTip = function(button, toolTip, e){
            if(!_s.showButtonsToolTip_bl) return;
            var ws = FWDUVPUtils.getViewportSize();
            var wc = FWDUVPUtils.getViewportMouseCoordinates(e);
            var localX;
            var localY;
            
            if(button.screen.offsetWidth < 3){
                localX = parseInt(button.getGlobalX() * 100 + button.w/2 - toolTip.w/2);
                localY = parseInt(button.getGlobalY() * 100 - toolTip.h - 8);
            }else{
                localX = parseInt(button.getGlobalX() + button.w/2 - toolTip.w/2);
                localY = parseInt(button.getGlobalY() - toolTip.h - 8);
            }
            
            var offseX = 0;
        
            if(localX < 0){
                offseX = localX;
                localX = 0;
            }else if(localX + toolTip.w > ws.w){
                offseX = (ws.w - (localX + toolTip.w)) * -1;
                localX = localX + (offseX * -1);
            }
            
            toolTip.positionPointer(offseX, false);
            
            toolTip.setX(localX);
            toolTip.setY(localY);
            toolTip.show();
            
        };

        
        //################################################//
        /* Setup main scrubber */
        //################################################//
        _s.setupAdsLines = function(linesAr, id, catId, overwrite){
            if(_s.createdAdsOnce_bl || _s.curLinesId == id && _s.curLinesCat == catId && !overwrite) return;
            
            _s.curLinesId = id;
            _s.curLinesCat = catId;
            
            if(!linesAr) return;
            _s.resetsAdsLines();

            if(!_s.linesHolder_do){
                _s.linesHolder_do = new FWDUVPDisplayObject("div");
                _s.linesHolder_do.setOverflow("visible");
                _s.mainScrubber_do.addChild(_s.linesHolder_do);
            }
            
            _s.createdAdsOnce_bl = true;
            _s.lines_ar = linesAr;
            if(_s.lines_ar){
                var line;
                _s.line_ar = [];
                for(var i=0; i<_s.lines_ar.length; i++){
                    line = new FWDUVPDisplayObject("div");
                    line.screen.className = 'uvp-ad-line';
                    var src = _d.adLinePat_str;
                    if(_s.useHEX && window['isWhite']){
                        src = _d.sknPth + 'ad-line-dark.png';
                    }
                    line.getStyle().background = "url('" + src + "') repeat-x";
                    line.timeStart = linesAr[i].timeStart;
                    line.setWidth(2);
                    line.setHeight(_s.mainScrubberDragLeft_img.height);
                    line.isUsed_bl = false;
                    line.isShowed_bl = false;
                    if(_s.lines_ar[i].played_bl) line.setVisible(false);
                    line.setAlpha(0);
                    _s.line_ar[i] = line;
                    _s.linesHolder_do.addChild(line);
                }
            }
            _s.totalDuration = 0;
        };
        
        _s.hideAdsLines = function(){
            if(_s.linesHolder_do) _s.linesHolder_do.setX(-5000);
            if(_s.line_ar){
                for(var i=0; i<_s.line_ar.length; i++){
                    _s.line_ar[i].setAlpha(0);
                    _s.line_ar[i].isShowed_bl = false;
                }
            }
        }
        
        _s.positionAdsLines = function(totalDuration){
        
            if(!_s.linesHolder_do || !prt.totalDuration || !_s.createdAdsOnce_bl)  return;
        
            _s.totalDuration = prt.totalDuration;
            
            if(prt.isAdd_bl){
                _s.linesHolder_do.setX(-5000);
            }else{
                _s.linesHolder_do.setX(0);
            }
        
            if(_s.line_ar){
                var line;
                for(var i=0; i<_s.line_ar.length; i++){
                    line = _s.line_ar[i];
                    var x = Math.round((line.timeStart/_s.totalDuration) * _s.maiScrbW) - 1;
                    line.setX(x);
                    if(line.x < 0) line.setX(0);
                    if(!line.isUsed_bl && _s.totalDuration != 0 && !line.isShowed_bl){
                        FWDAnimation.to(line, 1, {alpha:1, delay:1, ease:Expo.easeOut});
                        line.isShowed_bl = true;
                    }
                }
            }
        }
        
        _s.resetsAdsLines = function(){
            if(_s.line_ar){
                for(var i=0; i<_s.line_ar.length; i++){
                    FWDAnimation.killTweensOf(_s.line_ar[i]);
                    _s.linesHolder_do.removeChild(_s.line_ar[i]);
                }
                _s.createdAdsOnce_bl = false;
                _s.curLinesId = -1;
                _s.line_ar = null;
                _s.hadLInes = false;
            }
        }

        
        //##########################################//
        /* Setup playback rate button */
        //##########################################//
        _s.playbackRatesSource_ar = _d.defaultPlaybackRate_ar;
        _s.playbackRateButtons_ar = [];
        _s.totalPlaybackRateButtons = 6;
        _s.arePlaybackRateButtonsShowed_bl = true;
        if(!_s.showPlaybackRateButton_bl) _s.arePlaybackRateButtonsShowed_bl = false;
        
        _s.setupPlaybackRateButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.playbackRateButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-watch-later'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
                
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.playbackRateButton_do = new FWDUVPSimpleButton(_d.playbackRateNPath_img,
                                                             _d.playbackRateSPath_str, 
                                                             undefined, 
                                                             true,
                                                             _s.useHEX,
                                                             _s.nBC,
                                                             _s.sBC);
            }
            
            _s.playbackRateButton_do.screen.className = 'fwduvp-playback-rate-button';
            _s.playbackRateButton_do.setY(parseInt((_s.sH - _s.playbackRateButton_do.h)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.playbackRateButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.playbackRateButton_do.setY(parseInt((_s.sH - _s.playbackRateButton_do.buttonHeight)/2));
                }
            }, 50);
            _s.playbackRateButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.playbackRateButtonMouseUpHandler);
            _s.mainHld.addChild(_s.playbackRateButton_do);
            _s.playbackRateButton_do.setX(-500);
            
            _s.disablePlaybackRateButton();
            _s.setupPlaybackRateButtons();  
        }
        
        _s.playbackRateButtonMouseUpHandler = function(){
            if(_s.arePlaybackRateButtonsShowed_bl){
                _s.hidePlaybackRateButtons(true);
            }else{
                _s.showPlaybackRateButtons(true);
                _s.hideMainScrubberTop();
            }
        };
        
        _s.disablePlaybackRateButton = function(){
            if(_s.playbackRateButton_do) _s.playbackRateButton_do.disable();
        };
        
        _s.enablePlaybackRateButton = function(){
            if(_s.playbackRateButton_do) _s.playbackRateButton_do.enable();
        };
                
        _s.removePlaybackRateButton = function(){
            if(!_s.playbackRateButton_do) return;
            if(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.playbackRateButton_do) != -1){
                _s.buttons_ar.splice(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.playbackRateButton_do), 1);
                _s.playbackRateButton_do.setX(-300);
                _s.positionButtons();
            }
        };
        
        _s.addPlaybackRateButton = function(rate){
            if(!_s.playbackRateButton_do) return;
            
            if(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.playbackRateButton_do) != -1) return;
            var indexToAdd;

            if(_s.atbButton_do && _s.getButtonIndex(_s.atbButton_do) != -1){
                indexToAdd = _s.getButtonIndex(_s.atbButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.playbackRateButton_do);
            }else if(_s.infoButton_do && _s.getButtonIndex(_s.infoButton_do) != -1){
                indexToAdd = _s.getButtonIndex(_s.infoButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.playbackRateButton_do);
            }else if(_s.downloadButton_do && _s.getButtonIndex(_s.downloadButton_do) != -1){
                indexToAdd = _s.getButtonIndex(_s.downloadButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.playbackRateButton_do);
            }else if(_s.ccBtn_do && _s.getButtonIndex(_s.ccBtn_do) != -1){
                indexToAdd = _s.getButtonIndex(_s.ccBtn_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.playbackRateButton_do);
            }else if(_s.vrButton_do){
                indexToAdd = _s.getButtonIndex(_s.vrButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.playbackRateButton_do);
            }else if(_s.fullScreenButton_do){
                indexToAdd = _s.getButtonIndex(_s.fullScreenButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.playbackRateButton_do);
            }else{
                _s.buttons_ar.splice(_s.buttons_ar.length,0, _s.playbackRateButton_do);
            }
            
            _s.updatePlaybackRateButtons(rate);
        };

        
        //###################################################//
        /* Setup PlaybackRatebuttons */
        //###################################################//
        _s.updatePlaybackRateButtons = function(playbackRateIndex){
            if(!_s.playbackRateButton_do) return;
            setTimeout(function(){
                _s.disablePlaybackRateButtons(playbackRateIndex);
            },65);
            _s.prevplaybackRateIndex = playbackRateIndex;
        };  
        
        _s.setupPlaybackRateButtons = function(){
            
            _s.playbackRatesButtonsHolder_do = new FWDUVPDisplayObject("div");
            _s.playbackRatesButtonsHolder_do.setOverflow("visible");
            
            if(_s.repeatBackground_bl){
                _s.playbackRatesButtonsHolder_do.getStyle().background = "url('" + _s.controllerBkPath_str +  "')";
            }else{
                _s.playbackRatesButtonsBackground_do = new FWDUVPDisplayObject("img");
                var img = new Image();
                img.src = _s.controllerBkPath_str;
                _s.playbackRatesButtonsBackground_do.setScreen(img);
                _s.playbackRatesButtonsHolder_do.addChild(_s.playbackRatesButtonsBackground_do);
            }
            
            _s.playbackRatesButtonsHolder_do.setX(300);
            _s.playbackRatesButtonsHolder_do.setY(-300);
            prt.videoHolder_do.addChild(_s.playbackRatesButtonsHolder_do);
            
            var img = new Image();
            img.src = _s.ytbQualityButtonPointerPath_str;
            _s.playbackRatesPonter_do = new FWDUVPDisplayObject("img");
            _s.playbackRatesPonter_do.setScreen(img);
            _s.playbackRatesPonter_do.setWidth(_s.pointerWidth);
            _s.playbackRatesPonter_do.setHeight(_s.pointerHeight);
            _s.playbackRatesButtonsHolder_do.addChild(_s.playbackRatesPonter_do);
    
            
            var img = new Image();
            img.src = _s.youtubeQualityArrowPath_str;
            _s.playbackRateQualityArrow_do = new FWDUVPDisplayObject("img");
            _s.playbackRateQualityArrow_do.setScreen(img);
            _s.playbackRateQualityArrow_do.setX(7);
            _s.playbackRateQualityArrow_do.setWidth(5);
            _s.playbackRateQualityArrow_do.setHeight(7);
            _s.playbackRatesButtonsHolder_do.addChild(_s.playbackRateQualityArrow_do);
            
            var btn;
            
            for(var i=0; i<_s.totalPlaybackRateButtons; i++){
                FWDUVPYTBQButton.setPrototype();
                btn = new FWDUVPYTBQButton("no source", 
                        _s.youtubeQualityButtonNormalColor_str, 
                        _s.youtubeQualityButtonSelectedColor_str,
                        undefined,
                        i);
                
                btn.addListener(FWDUVPYTBQButton.MOUSE_OVER, _s.plbkQualityOver);
                btn.addListener(FWDUVPYTBQButton.MOUSE_OUT, _s.plbkQualityOut);
                btn.addListener(FWDUVPYTBQButton.CLICK, _s.plbkQualityClick);
                _s.playbackRateButtons_ar[i] = btn;
                _s.playbackRatesButtonsHolder_do.addChild(btn);
            }
            _s.positionAndResizePlaybackRateButtons(_s.playbackRatesSource_ar);
            _s.hidePlaybackRateButtons(false);
        };
        
        _s.plbkQualityOver = function(e){
            _s.setPlaybackRateArrowPosition(e.target);
        };
        
        _s.plbkQualityOut = function(e){
            _s.setPlaybackRateArrowPosition(undefined);
        };
        
        _s.plbkQualityClick = function(e){
            _s.startAtPlaybackRate = e.id;
            _s.disablePlaybackRateButtons(_s.startAtPlaybackRate);
            _s.hidePlaybackRateButtons(true);
            _s.dispatchEvent(FWDUVPController.CHANGE_PLAYBACK_RATES, {rate:_s.playbackRatesSource_ar[e.id]});
        };
        
        _s.positionAndResizePlaybackRateButtons = function(ar){
            if(!ar) return;
            
            var totalButtons = ar.length;
            if(_s.prevplaybackRatesQualityButtonsLength == totalButtons) return;
            _s.prevplaybackRatesQualityButtonsLength = totalButtons;
            var btn;
            var startY = 5;
            var totalWidth = 0;
            var totalHeight = 0;
            
            for(var i=0; i<totalButtons; i++){
                btn = _s.playbackRateButtons_ar[i];
                if(ar[i] == 1){
                    btn.updateText("normal");
                }else{
                    btn.updateText(ar[i]);
                }
                
                btn.setFinalSize();
            }
            
            setTimeout(function(){
                for(var i=0; i<totalButtons; i++){
                    btn = _s.playbackRateButtons_ar[i];
                    if(i < totalButtons){
                        if(btn.x != 0) btn.setX(0);
                        if(btn.w > totalWidth) totalWidth = btn.w;
                        btn.setY(startY);
                        startY += btn.h;
                    }else{
                        if(btn.x != -3000) btn.setX(-3000);
                    }
                }
                
                for(var i=0; i<totalButtons; i++){
                    btn = _s.playbackRateButtons_ar[i];
                    if(btn.dumy_do.w < totalWidth){
                        btn.setWidth(totalWidth);
                        btn.dumy_do.setWidth(totalWidth);
                    }
                }
                
                totalHeight = startY + 5;
                _s.playbackRatesPonter_do.setX(parseInt((totalWidth - _s.playbackRatesPonter_do.w)/2));
                _s.playbackRatesPonter_do.setY(totalHeight);
                if(_s.playbackRatesButtonsBackground_do){   
                    _s.playbackRatesButtonsBackground_do.setWidth(totalWidth);
                    _s.playbackRatesButtonsBackground_do.setHeight(totalHeight);
                }
                _s.playbackRatesButtonsHolder_do.setWidth(totalWidth);
                _s.playbackRatesButtonsHolder_do.setHeight(totalHeight);
            }, 60);
        };
        
        _s.disablePlaybackRateButtons = function(index){
            if(index == undefined) return;
            for(var i=0; i<_s.totalPlaybackRateButtons; i++){
                var btn = _s.playbackRateButtons_ar[i];
                if(i == index){
                    FWDAnimation.killTweensOf(_s.playbackRateQualityArrow_do);
                    _s.playbackRateQualityArrow_do.setY(btn.y + parseInt((btn.h - _s.playbackRateQualityArrow_do.h)/2) - 1);
                    btn.disable();
                    _s.playbackRateDisabledButton_do = btn;
                }else{
                    btn.enable();
                }
            }
        };
        
        _s.setPlaybackRateArrowPosition = function(target){
            var curY = 0;
            if(!target){
                curY = _s.playbackRateDisabledButton_do.y + parseInt((_s.playbackRateDisabledButton_do.h - _s.playbackRateQualityArrow_do.h)/2 - 1);
            }else{
                curY = target.y + parseInt((target.h - _s.playbackRateQualityArrow_do.h)/2 - 1);
            }
            FWDAnimation.killTweensOf(_s.playbackRateQualityArrow_do);
            FWDAnimation.to(_s.playbackRateQualityArrow_do, .6, {y:curY, delay:.1, ease:Expo.easeInOut});
        };
        
        _s.showPlaybackRateButtons = function(animate){
            if(_s.arePlaybackRateButtonsShowed_bl) return;
            _s.hideQualityButtons();
            _s.arePlaybackRateButtonsShowed_bl = true;
            var finalX = parseInt(_s.playbackRateButton_do.x + (parseInt(_s.playbackRateButton_do.w - _s.playbackRatesButtonsHolder_do.w)/2));
            var finalY = parseInt(prt.tempVidStageHeight - _s.sH - _s.playbackRatesButtonsHolder_do.h - 6);
            
            if(_s.hasPointerEvent_bl){
                window.addEventListener("pointerdown", _s.hideplaybackRatesButtonsHandler);
            }else{
                if(!_s.isMbl){
                    window.addEventListener("mousedown", _s.hideplaybackRatesButtonsHandler);
                }
                window.addEventListener("touchstart", _s.hideplaybackRatesButtonsHandler);
            }
            
            _s.playbackRatesButtonsHolder_do.setX(finalX);
        
            if(animate){
                FWDAnimation.to(_s.playbackRatesButtonsHolder_do, .6, {y:finalY, ease:Expo.easeInOut});
            }else{
                FWDAnimation.killTweensOf(_s.playbackRatesButtonsHolder_do);
                _s.playbackRatesButtonsHolder_do.setY(finalY);
            }
        };
    
        _s.hidePlaybackRateButtons = function(animate){
            if(!_s.arePlaybackRateButtonsShowed_bl || !_s.playbackRatesButtonsHolder_do) return;
            _s.arePlaybackRateButtonsShowed_bl = false;
            _s.showMainScrubberOnTop();
            
            if(animate){
                FWDAnimation.to(_s.playbackRatesButtonsHolder_do, .6, {y:prt.sH, ease:Expo.easeInOut});
            }else{
                FWDAnimation.killTweensOf(_s.playbackRatesButtonsHolder_do);
                _s.playbackRatesButtonsHolder_do.setY(prt.sH);
            }
            
            if(_s.hasPointerEvent_bl){
                window.removeEventListener("pointerdown", _s.hideplaybackRatesButtonsHandler);
            }else{
                if(!_s.isMbl){
                    window.removeEventListener("mousedown", _s.hideplaybackRatesButtonsHandler);
                }
                window.removeEventListener("touchstart", _s.hideplaybackRatesButtonsHandler);
            }
        };
        
        _s.hideplaybackRatesButtonsHandler = function(e){
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            if(FWDUVPUtils.hitTest(_s.playbackRateButton_do.screen, vc.screenX, vc.screenY)
               || FWDUVPUtils.hitTest(_s.playbackRatesButtonsHolder_do.screen, vc.screenX, vc.screenY)){
                return;
            }
            _s.hidePlaybackRateButtons(true);
        };

        
        //###############################################//
        /* Set is live */
        //###############################################//
        _s.setIsLive = function(isLive){
            _s.isLive = isLive;
            if(isLive){
                if(!_s.mainScrubber_do.contains(_s.live_do)){
                    _s.mainScrubber_do.setAlpha(.2);
                    _s.mainHld.addChild(_s.live_do);
                    setTimeout(function(){
                            _s.live_do.setX(4);
                            _s.live_do.setY(- _s.live_do.getHeight() - 4);
                    }, 100)
                    _s.disableMainScrubber();
                }
            }else{
                if(_s.mainHld.contains(_s.live_do)){
                    _s.mainHld.removeChild(_s.live_do);
                    _s.mainScrubber_do.setAlpha(1);
                    
                    _s.enableMainScrubber();
                }
            }
        }
        
        //################################################//
        /* Setup main scrubber */
        //################################################//
        _s.setupMainScrubber = function(){
            //setup background bar
            _s.mainScrubber_do = new FWDUVPDisplayObject("div");
            _s.mainScrubber_do.screen.className = 'fwduvp-main-scrubber';
            _s.mainScrubber_do.setY(parseInt((_s.sH - _s.mainScrbH)/2));
            _s.mainScrubber_do.setHeight(_s.mainScrbH);
            
            _s.mainScrubberBkLeft_do = new FWDUVPDisplayObject("img");
            _s.mainScrubberBkLeft_do.setScreen(_s.mainScrubberBkLeft_img);
            
            var rightImage = new Image();
            rightImage.src = _d.mainScrubberBkRightPath_str;
            _s.mainScrubberBkRight_do = new FWDUVPDisplayObject("img");
            _s.mainScrubberBkRight_do.setScreen(rightImage);
            _s.mainScrubberBkRight_do.setWidth(_s.mainScrubberBkLeft_do.w);
            _s.mainScrubberBkRight_do.setHeight(_s.mainScrubberBkLeft_do.h);
        
            var middleImage = new Image();
            middleImage.src = _s.mainScrubberBkMiddlePath_str;
            
            _s.mainScrubberBkMiddle_do = new FWDUVPDisplayObject("div");    
            _s.mainScrubberBkMiddle_do.getStyle().background = "url('" + _s.mainScrubberBkMiddlePath_str + "') repeat-x";
                
            _s.mainScrubberBkMiddle_do.setHeight(_s.mainScrbH);
            _s.mainScrubberBkMiddle_do.setX(_s.scrbsBkLARW);
            
            //setup progress bar
            _s.mainProgress_do = new FWDUVPDisplayObject("div");
            _s.mainProgress_do.setHeight(_s.mainScrbH);
        
            _s.progressLeft_do = new FWDUVPDisplayObject("img");
            _s.progressLeft_do.setScreen(_s.progress);
            
            middleImage = new Image();
            middleImage.src = _s.progressMiddlePath_str;
            
            _s.progressMiddle_do = new FWDUVPDisplayObject("div");  
            _s.progressMiddle_do.getStyle().background = "url('" + _s.progressMiddlePath_str + "') repeat-x";
        
            _s.progressMiddle_do.setHeight(_s.mainScrbH);
            _s.progressMiddle_do.setX(_s.mainScrbDrgLW);
            
            //setup darg bar.
            _s.mainScrubberDrag_do = new FWDUVPDisplayObject("div");
            _s.mainScrubberDrag_do.setHeight(_s.mainScrbH);
        
            if(_s.useHEX){
                _s.mainScrubberDragLeft_do = new FWDUVPDisplayObject("div");
                _s.mainScrubberDragLeft_do.setWidth(_s.mainScrubberDragLeft_img.width);
                _s.mainScrubberDragLeft_do.setHeight(_s.mainScrubberDragLeft_img.height);
                _s.mainScrubberDragLeft_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.mainScrubberDragLeft_img, _s.nBC).canvas;
                _s.mainScrubberDragLeft_do.screen.appendChild(_s.mainScrubberDragLeft_canvas);  
            }else{
                _s.mainScrubberDragLeft_do = new FWDUVPDisplayObject("img");
                _s.mainScrubberDragLeft_do.setScreen(_s.mainScrubberDragLeft_img);
            }
            
            _s.mainScrubberMiddleImage = new Image();
            _s.mainScrubberMiddleImage.src = _s.mainScrubberDragMiddlePath_str;
            _s.volumeScrubberDragMiddle_do = new FWDUVPDisplayObject("div");
            
            if(_s.useHEX){
                _s.mainScrubberDragMiddle_do = new FWDUVPDisplayObject("div");
                _s.mainScrubberMiddleImage.onload = function(){
                    var testCanvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.mainScrubberMiddleImage, _s.nBC, true);
                    _s.mainSCrubberMiddleCanvas = testCanvas.canvas;
                    _s.mainSCrubberDragMiddleImageBackground = testCanvas.image;
                    _s.mainScrubberDragMiddle_do.getStyle().background = "url('" + _s.mainSCrubberDragMiddleImageBackground.src + "') repeat-x";
                }
            }else{
                _s.mainScrubberDragMiddle_do = new FWDUVPDisplayObject("div");  
                _s.mainScrubberDragMiddle_do.getStyle().background = "url('" + _s.mainScrubberDragMiddlePath_str + "') repeat-x";
            }
            
            _s.mainScrubberDragMiddle_do.setHeight(_s.mainScrbH);
            _s.mainScrubberDragMiddle_do.setX(_s.mainScrbDrgLW);
            
            _s.mainScrubberBarLine_do = new FWDUVPDisplayObject("img");
            _s.mainScrubberBarLine_do.setScreen(_s.mainScrubberLine_img);
            _s.mainScrubberBarLine_do.setAlpha(0);
            _s.mainScrubberBarLine_do.hasTransform3d_bl = false;
            _s.mainScrubberBarLine_do.hasTransform2d_bl = false;
            
            _s.buttons_ar.push(_s.mainScrubber_do);
            
            _s.live_do = new FWDUVPDisplayObject("div");
            _s.live_do.hasTransform3d_bl = false;
            _s.live_do.hasTransform2d_bl = false;
            _s.live_do.setBackfaceVisibility();
            _s.live_do.getStyle().fontFamily = "Arial";
            _s.live_do.getStyle().fontSize= "12px";
            _s.live_do.getStyle().whiteSpace= "nowrap";
            _s.live_do.getStyle().textAlign = "center";
            _s.live_do.getStyle().padding = "4px";
            _s.live_do.getStyle().paddingLeft = "6px";
            _s.live_do.getStyle().paddingRIght = "6px";
            _s.live_do.getStyle().color = "#FFFFFF";
            _s.live_do.getStyle().fontSmoothing = "antialiased";
            _s.live_do.getStyle().webkitFontSmoothing = "antialiased";
            _s.live_do.getStyle().textRendering = "optimizeLegibility";
            _s.live_do.getStyle().backgroundColor = "rgba(255,0,0,0.8)";
            _s.live_do.setInnerHTML("&#x25C9; LIVE");
            
            //add all children
            _s.mainScrubber_do.addChild(_s.mainScrubberBkLeft_do);
            _s.mainScrubber_do.addChild(_s.mainScrubberBkMiddle_do);
            _s.mainScrubber_do.addChild(_s.mainScrubberBkRight_do);
            _s.mainScrubber_do.addChild(_s.mainScrubberBarLine_do);
            _s.mainScrubberDrag_do.addChild(_s.mainScrubberDragLeft_do);
            _s.mainScrubberDrag_do.addChild(_s.mainScrubberDragMiddle_do);
            _s.mainProgress_do.addChild(_s.progressLeft_do);
            _s.mainProgress_do.addChild(_s.progressMiddle_do);
            _s.mainScrubber_do.addChild(_s.mainProgress_do);
            _s.mainScrubber_do.addChild(_s.mainScrubberDrag_do);
            _s.mainScrubber_do.addChild(_s.mainScrubberBarLine_do);
            _s.mainHld.addChild(_s.mainScrubber_do);
            
            if(!_s.disableVideoScrubber_bl){
                if(_s.hasPointerEvent_bl){
                    _s.mainScrubber_do.screen.addEventListener("pointerover", _s.mainScrubberOnOverHandler);
                    _s.mainScrubber_do.screen.addEventListener("pointerout", _s.mainScrubberOnOutHandler);
                    _s.mainScrubber_do.screen.addEventListener("pointerdown", _s.mainScrubberOnDownHandler);
                }else if(_s.screen.addEventListener){   
                    if(!_s.isMbl){
                        _s.mainScrubber_do.screen.addEventListener("mouseover", _s.mainScrubberOnOverHandler);
                        _s.mainScrubber_do.screen.addEventListener("mousemove", _s.updateTooltipOnMove);
                        _s.mainScrubber_do.screen.addEventListener("mouseout", _s.mainScrubberOnOutHandler);
                        _s.mainScrubber_do.screen.addEventListener("mousedown", _s.mainScrubberOnDownHandler);
                    }
                    _s.mainScrubber_do.screen.addEventListener("touchstart", _s.mainScrubberOnDownHandler);
                }
            }
            
            _s.disableMainScrubber();
            _s.updateMainScrubber(0);

            FWDUVPScrubberToolip.setPrototype();
            _s.ttm = new FWDUVPScrubberToolip(_s.mainScrubber_do, _d.scrubbersToolTipLabelBackgroundColor, _d.scrubbersToolTipLabelFontColor);
            _s.addChild(_s.ttm);
        };

        _s.updateToolTip = function(localX, percentScrubbed){
            if(!_d.showMainScrubberToolTipLabel_bl) return;
            if(prt.isCasting){
                _s.ttm.setLabel(FWDUVPUtils.formatTime(Math.round(prt.cc.getDuration() * percentScrubbed)));
            }else{
                _s.ttm.setLabel(FWDUVPUtils.formatTime(Math.round(prt.totalDuration * percentScrubbed)));
            }
            _s.ttm.setX(Math.round(_s.mainScrubber_do.x + localX - _s.ttm.getWidth()/2) + 1);
             
            _s.ttm.setY(_s.mainScrubber_do.y - _s.ttm.h - 2);
        }
        
        _s.updateThumbnailsPreview = function(localX, percentScrubbed){
            if(!_s.thumbnailsPreview_do || !prt.hasThumbnailsPreview) return;
            var pointerOffsetX = 0;
            
            var x = Math.round(_s.mainScrubber_do.x + localX - _s.thumbnailsPreview_do.getWidth()/2) + 1;
            if(x < 1){
                pointerOffsetX = x;
                x = 1;
            }else if(x > _s.sW - _s.thumbnailsPreview_do.w - 1){
                pointerOffsetX = x - _s.sW + _s.thumbnailsPreview_do.w;
                x = _s.sW - _s.thumbnailsPreview_do.w - 1;
            }
            _s.thumbnailsPreview_do.setLabel(FWDUVPUtils.formatTime(Math.round(prt.totalDuration * percentScrubbed)), Math.round(prt.totalDuration * percentScrubbed), pointerOffsetX);
            _s.thumbnailsPreview_do.setX(x);
            _s.thumbnailsPreview_do.setY(_s.mainScrubber_do.y - _s.thumbnailsPreview_do.h - 2);
        }

        _s.updateTooltipOnMove = function(e){
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            var localX = vc.screenX - _s.mainScrubber_do.getGlobalX();
            
            if(localX < 0){
                localX = 0;
            }else if(localX > _s.maiScrbW - _s.scrubbersOffsetWidth){
                localX = _s.maiScrbW - _s.scrubbersOffsetWidth;
            }
            var percentScrubbed = localX/_s.maiScrbW;

            _s.updateToolTip(localX, percentScrubbed);
            _s.updateThumbnailsPreview(localX, percentScrubbed);
        }

        _s.mainScrubberWMouseMove = function(e){
            var wc = FWDUVPUtils.getViewportMouseCoordinates(e);
            _s.vcX = wc.screenX;
            _s.vcY = wc.screenY;
            if(!FWDUVPUtils.hitTest(_s.mainScrubber_do.screen, _s.vcX, _s.vcY)){
                if(!_s.isMainScrubberScrubbing_bl){
                    window.removeEventListener('mousemove', _s.mainScrubberWMouseMove);
                    _s.ttm.hide();
                } 
            }
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            var localX = vc.screenX - _s.mainScrubber_do.getGlobalX();
            
            if(localX < 0){
                localX = 0;
            }else if(localX > _s.maiScrbW - _s.scrubbersOffsetWidth){
                localX = _s.maiScrbW - _s.scrubbersOffsetWidth;
            }
            var percentScrubbed = localX/_s.maiScrbW;
            _s.updateThumbnailsPreview(localX, percentScrubbed);
        }
        
        _s.mainScrubberOnOverHandler =  function(e){
            if(_s.isMainScrubberDisabled_bl) return;
            if(_d.showMainScrubberToolTipLabel_bl && !prt.hasThumbnailsPreview) _s.ttm.show();
            if(_s.thumbnailsPreview_do && prt.hasThumbnailsPreview) _s.thumbnailsPreview_do.show();
        
            if(!_s.isMbl && (_s.ttm || _s.thumbnailsPreview_do)){
                window.removeEventListener('mousemove', _s.mainScrubberWMouseMove);
                window.addEventListener('mousemove', _s.mainScrubberWMouseMove);
            }
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            var localX = vc.screenX - _s.mainScrubber_do.getGlobalX();
        
            if(localX < 0){
                localX = 0;
            }else if(localX > _s.maiScrbW - _s.scrubbersOffsetWidth){
                localX = _s.maiScrbW - _s.scrubbersOffsetWidth;
            }
            var percentScrubbed = localX/_s.maiScrbW;

            _s.updateToolTip(localX, percentScrubbed);
            _s.updateThumbnailsPreview(localX, percentScrubbed);
        };
        
        _s.mainScrubberOnOutHandler =  function(e){
            if(!_s.isMainScrubberScrubbing_bl){
                if(_s.ttm) _s.ttm.hide();
                if(_s.thumbnailsPreview_do && prt.hasThumbnailsPreview) _s.thumbnailsPreview_do.hide();
            }
        };
        
        _s.mainScrubberOnDownHandler =  function(e){
            if(_s.isMainScrubberDisabled_bl || e.button == 2) return;
            
            prt.showDisable();
            if(e.preventDefault) e.preventDefault();
            _s.isMainScrubberScrubbing_bl = true;
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            var localX = vc.screenX - _s.mainScrubber_do.getGlobalX();
            
            if(localX < 0){
                localX = 0;
            }else if(localX > _s.maiScrbW - _s.scrubbersOffsetWidth){
                localX = _s.maiScrbW - _s.scrubbersOffsetWidth;
            }
            var percentScrubbed = localX/_s.maiScrbW;
        
            if(_d.showMainScrubberToolTipLabel_bl && !prt.hasThumbnailsPreview) _s.ttm.show();
            if(_s.thumbnailsPreview_do && prt.hasThumbnailsPreview) _s.thumbnailsPreview_do.show();
            _s.updateToolTip(localX, percentScrubbed);
            _s.updateMainScrubber(percentScrubbed);
            _s.updateThumbnailsPreview(localX, percentScrubbed);
            
            _s.dispatchEvent(FWDUVPController.START_TO_SCRUB);
            _s.dispatchEvent(FWDUVPController.SCRUB, {percent:percentScrubbed});
            
            if(_s.hasPointerEvent_bl){
                window.addEventListener("pointermove", _s.mainScrubberMoveHandler);
                window.addEventListener("pointerup", _s.mainScrubberEndHandler);
            }else{
                window.addEventListener("mousemove", _s.mainScrubberMoveHandler);
                window.addEventListener("mouseup", _s.mainScrubberEndHandler);      
                window.addEventListener("touchmove", _s.mainScrubberMoveHandler, {passive:false});
                window.addEventListener("touchend", _s.mainScrubberEndHandler);
            }   
        };
        
        _s.mainScrubberMoveHandler = function(e){
            if(e.preventDefault) e.preventDefault();
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            var localX = vc.screenX - _s.mainScrubber_do.getGlobalX();
            
            if(localX < 0){
                localX = 0;
            }else if(localX > _s.maiScrbW - _s.scrubbersOffsetWidth){
                localX = _s.maiScrbW - _s.scrubbersOffsetWidth;
            }
            
            var percentScrubbed = localX/_s.maiScrbW;
            _s.updateToolTip(localX, percentScrubbed);
            _s.updateMainScrubber(percentScrubbed);
            _s.updateThumbnailsPreview(localX, percentScrubbed);
            _s.dispatchEvent(FWDUVPController.SCRUB, {percent:percentScrubbed});
        };
        
        _s.mainScrubberEndHandler = function(e){
            prt.hideDisable();          
            if(e){
                var wp = FWDUVPUtils.getViewportMouseCoordinates(e);
                if(!FWDUVPUtils.hitTest(_s.mainScrubber_do.screen, wp.screenX, wp.screenY)){
                    if(_s.ttm) _s.ttm.hide();
                    if(_s.thumbnailsPreview_do && prt.hasThumbnailsPreview) _s.thumbnailsPreview_do.hide();
                }
            }
    
            _s.isMainScrubberScrubbing_bl = false;
            _s.dispatchEvent(FWDUVPController.STOP_TO_SCRUB);
            
            if(_s.hasPointerEvent_bl){
                window.removeEventListener("pointermove", _s.mainScrubberMoveHandler);
                window.removeEventListener("pointerup", _s.mainScrubberEndHandler);
            }else{
                window.removeEventListener("mousemove", _s.mainScrubberMoveHandler);
                window.removeEventListener("mouseup", _s.mainScrubberEndHandler);       
                window.removeEventListener("touchmove", _s.mainScrubberMoveHandler);
                window.removeEventListener("touchend", _s.mainScrubberEndHandler);
            }
        };
        
        _s.disableMainScrubber = function(){
            if(!_s.mainScrubber_do) return;
            _s.isMainScrubberDisabled_bl = true;
            _s.mainScrubber_do.setButtonMode(false);
            _s.mainScrubberEndHandler();
            _s.mainScrubberOnOutHandler();
            _s.updateMainScrubber(0);
            _s.updatePreloaderBar(0);
        };
        
        _s.enableMainScrubber = function(){
            if(!_s.mainScrubber_do || _s.isLive) return;
            _s.isMainScrubberDisabled_bl = false;
            if(!_s.disableVideoScrubber_bl) _s.mainScrubber_do.setButtonMode(true);
        };
        
        _s.updateMainScrubber = function(percent){
            if(!_s.mainScrubber_do) return;
            if(_s.isLive) percent = 0;
            var finalWidth = parseInt(percent * _s.maiScrbW);
            if(isNaN(finalWidth) || finalWidth == undefined) return;
            if(finalWidth < 0) finalWidth = 0;
            
            _s.percentPlayed = percent;
            if(!FWDUVPlayer.hasHTML5Video && finalWidth >= _s.mainProgress_do.w) finalWidth = _s.mainProgress_do.w;
            
            if(finalWidth < 1 && _s.isMainScrubberLineVisible_bl){
                _s.isMainScrubberLineVisible_bl = false;
                FWDAnimation.to(_s.mainScrubberBarLine_do, .5, {alpha:0});
            }else if(finalWidth > 1 && !_s.isMainScrubberLineVisible_bl){
                _s.isMainScrubberLineVisible_bl = true;
                FWDAnimation.to(_s.mainScrubberBarLine_do, .5, {alpha:1});
            }
            
            _s.mainScrubberDrag_do.setWidth(finalWidth);
            if(finalWidth > _s.maiScrbW - _s.scrubbersOffsetWidth) finalWidth = _s.maiScrbW - _s.scrubbersOffsetWidth;
            if(finalWidth < 0) finalWidth = 0;
            FWDAnimation.to(_s.mainScrubberBarLine_do, .8, {x:finalWidth + 1, ease:Expo.easeOut});
        };
        
        _s.updatePreloaderBar = function(percent){
            if(!_s.mainProgress_do) return;
            if(_s.isLive) percent = 0;
            _s.percentLoaded = percent;
            var finalWidth = parseInt(_s.percentLoaded * _s.maiScrbW); 
            if(isNaN(finalWidth) || finalWidth == undefined) return;
            if(finalWidth < 0) finalWidth = 0;
            
            if(_s.percentLoaded >= 0.98){
                _s.percentLoaded = 1;
                _s.mainProgress_do.setY(-30);
            }else if(_s.mainProgress_do.y != 0 && _s.percentLoaded!= 1){
                _s.mainProgress_do.setY(0);
            }
            if(finalWidth > _s.maiScrbW - _s.scrubbersOffsetWidth) finalWidth = _s.maiScrbW - _s.scrubbersOffsetWidth;
            if(finalWidth < 0) finalWidth = 0;
            _s.mainProgress_do.setWidth(finalWidth);
        };
        

        //################################################//
        /* Setup prev button */
        //################################################//
        _s.setupPrevButton = function(){
            
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.prevButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-FF-left'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.prevButton_do = new FWDUVPSimpleButton(_d.prev2N_img, _d.prevSPath_str, undefined, true, _s.useHEX,
                        _s.nBC,
                        _s.sBC);
            }
            
            _s.prevButton_do.screen.className = 'fwduvp-prev-button';
            _s.prevButton_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.prevButtonShowTooltipHandler);
            _s.prevButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.prevButtonOnMouseUpHandler);
            _s.prevButton_do.setY(parseInt((_s.sH - _s.prevButton_do.h)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.prevButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.prevButton_do.setY(parseInt((_s.sH - _s.prevButton_do.buttonHeight)/2));
                }
            }, 50);
        
            _s.buttons_ar.push(_s.prevButton_do);
            _s.mainHld.addChild(_s.prevButton_do); 
        };
        
        _s.prevButtonShowTooltipHandler = function(e){
            
            _s.showToolTip(_s.prevButton_do, _s.prevButtonToolTip_do, e.e);
        };
        
        _s.prevButtonOnMouseUpHandler = function(){
            _s.dispatchEvent(FWDUVPPlaylist.PLAY_PREV_VIDEO);
        };

        
        //################################################//
        /* Setup next button */
        //################################################//
        _s.setupNextButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.nextButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-FF-right'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.nextButton_do = new FWDUVPSimpleButton(_d.next2N_img, _d.nextSPath_str, undefined, true, _s.useHEX,
                        _s.nBC,
                        _s.sBC);
            }

            _s.nextButton_do.screen.className = 'fwduvp-next-button';
            _s.nextButton_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.nextButtonShowTooltipHandler);
            _s.nextButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.nextButtonOnMouseUpHandler);
            _s.nextButton_do.setY(parseInt((_s.sH - _s.nextButton_do.h)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.nextButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.nextButton_do.setY(parseInt((_s.sH - _s.nextButton_do.buttonHeight)/2));
                }
            }, 50);
            _s.buttons_ar.push(_s.nextButton_do);
            _s.mainHld.addChild(_s.nextButton_do);
        };
        
        _s.nextButtonShowTooltipHandler = function(e){
            _s.showToolTip(_s.nextButton_do, _s.nextButtonToolTip_do, e.e);
        };
        
        _s.nextButtonOnMouseUpHandler = function(){
            _s.dispatchEvent(FWDUVPPlaylist.PLAY_NEXT_VIDEO);
        };

    
        //################################################//
        /* Setup play button */
        //################################################//
        _s.setupPlayPauseButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPComplexButton.setPrototype();
                _s.playPauseButton_do = new FWDUVPComplexButton(undefined, undefined, undefined, undefined, true, undefined, undefined, undefined,
                    "<span class='fwdicon fwdicon-play'></span>",
                    "<span class='fwdicon fwdicon-pause'></span>",
                    "UVPMainButtonsNormalState play",
                    "UVPMainButtonsSelectedState play"
                );
            }else{
                FWDUVPComplexButton.setPrototype();
                _s.playPauseButton_do = new FWDUVPComplexButton(
                        _s.playN_img,
                        _d.playSPath_str,
                        _s.pauseN_img,
                        _d.pauseSPath_str,
                        true,
                        _s.useHEX,
                        _s.nBC,
                        _s.sBC
                );
            }
            
            _s.buttons_ar.push(_s.playPauseButton_do);
            _s.playPauseButton_do.setY(parseInt((_s.sH - _s.playPauseButton_do.buttonHeight)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.playPauseButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.playPauseButton_do.setY(parseInt((_s.sH - _s.playPauseButton_do.buttonHeight)/2));
                }
            }, 50);

            _s.playPauseButton_do.screen.className = 'fwduvp-play-button';
            _s.playPauseButton_do.addListener(FWDUVPComplexButton.SHOW_TOOLTIP, _s.playButtonShowTooltipHandler);
            _s.playPauseButton_do.addListener(FWDUVPComplexButton.MOUSE_UP, _s.playButtonMouseUpHandler);
            _s.mainHld.addChild(_s.playPauseButton_do);
        };
        
        
        _s.playButtonShowTooltipHandler = function(e){
            _s.showToolTip(_s.playPauseButton_do, _s.playPauseToolTip_do, e.e);
        };
        
        _s.showPlayButton = function(){
            if(!_s.playPauseButton_do) return;
            _s.playPauseButton_do.setButtonState(1);
        };
        
        _s.showPauseButton = function(){
            if(!_s.playPauseButton_do) return;
            _s.playPauseButton_do.setButtonState(0);
        };
        
        _s.playButtonMouseUpHandler = function(){
            if(_s.playPauseButton_do.currentState == 0){
                _s.dispatchEvent(FWDUVPController.PAUSE);
            }else{
                _s.dispatchEvent(FWDUVPController.PLAY);
            }
        };
        
        _s.disablePlayButton = function(){
            _s.playPauseButton_do.disable();
            _s.playPauseButton_do.setNormalState();
            _s.showPlayButton();
        };
        
        _s.enablePlayButton = function(){
            _s.playPauseButton_do.enable();
        };
        

        //##########################################//
        /* Setup categories buttons */
        //##########################################//
        _s.setupCategoriesButton = function(){
            if(_s.useVectorIcons_bl){               
                FWDUVPSimpleButton.setPrototype();
                _s.categoriesButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-playlist'></span>",
                        undefined,
                        "UVPMainButtonsNormalState cats",
                        "UVPMainButtonsSelectedState cats"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.categoriesButton_do = new FWDUVPSimpleButton(_s.categoriesN_img, _d.categoriesSPath_str, undefined, true, _s.useHEX,
                        _s.nBC,
                        _s.sBC);
            }

            _s.categoriesButton_do.screen.className = 'fwduvp-categories-button';
            _s.categoriesButton_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.categoriesButtonShowTooltipHandler);
            _s.categoriesButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.categoriesButtonOnMouseUpHandler);
            _s.categoriesButton_do.setY(parseInt((_s.sH - _s.categoriesButton_do.h)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.categoriesButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.categoriesButton_do.setY(parseInt((_s.sH - _s.categoriesButton_do.buttonHeight)/2));
                }
            }, 50);
            _s.buttons_ar.push(_s.categoriesButton_do);
            _s.mainHld.addChild(_s.categoriesButton_do); 
        };
        
        _s.categoriesButtonShowTooltipHandler = function(e){
            _s.showToolTip(_s.categoriesButton_do, _s.playlistsButtonToolTip_do, e.e);
        };
        
        _s.categoriesButtonOnMouseUpHandler = function(){
            _s.dispatchEvent(FWDUVPController.SHOW_CATEGORIES);
        };
        
        _s.setCategoriesButtonState = function(state){  
            if(!_s.categoriesButton_do) return;
            if(state == "selected"){
                _s.categoriesButton_do.setSelected();
            }else if(state == "unselected"){
                _s.categoriesButton_do.setUnselected();
            }
        };
        

        //##########################################//
        /* Setup playlist button */
        //##########################################//
        _s.setupPlaylistButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPComplexButton.setPrototype();
                _s.playlistButton_do = new FWDUVPComplexButton(undefined, undefined, undefined, undefined, true, undefined, undefined, undefined,
                    "<span class='fwdicon fwdicon-playlist-sidebar'></span>",
                    "<span class='fwdicon fwdicon-playlist-close-sidebar'></span>",
                    "UVPMainButtonsNormalState playlist",
                    "UVPMainButtonsSelectedState playlist"
                );
            }else{
                FWDUVPComplexButton.setPrototype();
                _s.playlistButton_do = new FWDUVPComplexButton(
                        _s.hidePlaylistN_img,
                        _d.hidePlaylistSPath_str,
                        _s.showPlaylistN_img,
                        _d.showPlaylistSPath_str,
                        true,
                        _s.useHEX,
                        _s.nBC,
                        _s.sBC
                );
            }
            
            _s.buttons_ar.push(_s.playlistButton_do);
            _s.playlistButton_do.setY(parseInt((_s.sH - _s.playlistButton_do.buttonHeight)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.playlistButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.playlistButton_do.setY(parseInt((_s.sH - _s.playlistButton_do.buttonHeight)/2));
                }
            }, 50);

            _s.playlistButton_do.screen.className = 'fwduvp-playlist-button';
            _s.playlistButton_do.addListener(FWDUVPComplexButton.SHOW_TOOLTIP, _s.playlistButtonShowToolTipHandler);
            _s.playlistButton_do.addListener(FWDUVPComplexButton.MOUSE_UP, _s.playlistButtonMouseUpHandler);
            if(!_s.showPlaylistByDefault_bl) _s.playlistButton_do.setButtonState(0);
            _s.mainHld.addChild(_s.playlistButton_do);
            
        };
        
        _s.playlistButtonShowToolTipHandler = function(e){
            _s.showToolTip(_s.playlistButton_do, _s.playlistButtonToolTip_do, e.e);
        };
        
        _s.showShowPlaylistButton = function(){
            if(!_s.playlistButton_do) return;
            _s.playlistButton_do.setButtonState(1);
        };
        
        _s.showHidePlaylistButton = function(){
            if(!_s.playlistButton_do) return;
            _s.playlistButton_do.setButtonState(0);
        };
        
        _s.playlistButtonMouseUpHandler = function(){
            if(_s.playlistButton_do.currentState == 1){
                _s.dispatchEvent(FWDUVPController.SHOW_PLAYLIST);
            }else{
                _s.dispatchEvent(FWDUVPController.HIDE_PLAYLIST);
            }
            _s.playlistButton_do.setNormalState(true);
            if(_s.playlistButtonToolTip_do) _s.playlistButtonToolTip_do.hide();
        };
        
        _s.disablePlaylistButton = function(){
            if(_s.playlistButton_do){
                _s.playlistButton_do.disable();
                _s.playlistButton_do.setAlpha(.4);
            }
        };
        
        _s.enablePlaylistButton = function(){
            if(_s.playlistButton_do){
                _s.playlistButton_do.enable();
                _s.playlistButton_do.setAlpha(1);
            }
        };
        

        //##########################################//
        /* Setup embed button */
        //#########################################//
        _s.setupEmbedButton = function(){
            if(_s.useVectorIcons_bl){           
                FWDUVPSimpleButton.setPrototype();
                _s.embedButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-embed'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.embedButton_do = new FWDUVPSimpleButton(_s.embedN_img, _d.embedPathS_str, undefined, true, _s.useHEX,
                        _s.nBC,
                        _s.sBC);
            }

            _s.embedButton_do.screen.className = 'fwduvp-embed-button';
            _s.embedButton_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.embedButtonShowToolTipHandler);
            _s.embedButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.embedButtonOnMouseUpHandler);
            _s.embedButton_do.setY(parseInt((_s.sH - _s.embedButton_do.h)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.embedButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.embedButton_do.setY(parseInt((_s.sH - _s.embedButton_do.buttonHeight)/2));
                }
            }, 50);
            _s.buttons_ar.push(_s.embedButton_do);
            _s.mainHld.addChild(_s.embedButton_do);
        };
        
        _s.embedButtonShowToolTipHandler = function(e){
            _s.showToolTip(_s.embedButton_do, _s.embedButtonToolTip_do, e.e);
        };
        
        _s.embedButtonOnMouseUpHandler = function(){
            _s.dispatchEvent(FWDUVPController.SHOW_EMBED_WINDOW);
            if(_s.embedButtonToolTip_do) _s.embedButtonToolTip_do.hide();
        };

        
        //###################################################//
        /* Setup youtube quality buttons */
        //###################################################//
        _s.setupYtbButtons = function(){
            _s.ytbButtonsHolder_do = new FWDUVPDisplayObject("div");
            _s.ytbButtonsHolder_do.setOverflow("visible");
            if(_s.repeatBackground_bl){
                _s.ytbButtonsHolder_do.getStyle().background = "url('" + _s.controllerBkPath_str +  "')";
            }else{
                _s.ytbButtonBackground_do = new FWDUVPDisplayObject("img");
                var img = new Image();
                img.src = _s.controllerBkPath_str;
                _s.ytbButtonBackground_do.setScreen(img);
                _s.ytbButtonsHolder_do.addChild(_s.ytbButtonBackground_do);
            }
            
            _s.ytbButtonsHolder_do.setX(300);
            _s.ytbButtonsHolder_do.setY(-300);
            prt.videoHolder_do.addChild(_s.ytbButtonsHolder_do, 0);
            
            var img = new Image();
            img.src = _s.ytbQualityButtonPointerPath_str;
            _s.pointer_do = new FWDUVPDisplayObject("img");
            _s.pointer_do.setScreen(img);
            _s.pointer_do.setWidth(_s.pointerWidth);
            _s.pointer_do.setHeight(_s.pointerHeight);
            _s.ytbButtonsHolder_do.addChild(_s.pointer_do);
            
            var img = new Image();
            img.src = _s.youtubeQualityArrowPath_str;
            _s.ytbQualityArrow_do = new FWDUVPDisplayObject("img");
            _s.ytbQualityArrow_do.setScreen(img);
            _s.ytbQualityArrow_do.setX(7);
            _s.ytbQualityArrow_do.setWidth(5);
            _s.ytbQualityArrow_do.setHeight(7);
            _s.ytbButtonsHolder_do.addChild(_s.ytbQualityArrow_do);
            
            var btn;
            for(var i=0; i<_s.ttYtbBtns; i++){
                FWDUVPYTBQButton.setPrototype();
                var btn = new FWDUVPYTBQButton(_s.ytbQuality_ar[i], 
                        _s.youtubeQualityButtonNormalColor_str, 
                        _s.youtubeQualityButtonSelectedColor_str,
                        _d.hdPath_str,
                        i);
                
                btn.addListener(FWDUVPYTBQButton.MOUSE_OVER, _s.ytbQualityOver);
                btn.addListener(FWDUVPYTBQButton.MOUSE_OUT, _s.ytbQualityOut);
                btn.addListener(FWDUVPYTBQButton.CLICK, _s.ytbQualityClick);
                _s.ytbButtons_ar[i] = btn;
                _s.ytbButtonsHolder_do.addChild(btn);
            }
            _s.hideQualityButtons(false);
        };
        
        _s.ytbQualityOver = function(e){
            _s.setYtbQualityArrowPosition(e.target);
        };
        
        _s.ytbQualityOut = function(e){
            _s.setYtbQualityArrowPosition(undefined);
        };
        
        _s.ytbQualityClick = function(e){
            _s.hideQualityButtons(true);
            _s.dispatchEvent(FWDUVPController.CHANGE_YOUTUBE_QUALITY, {quality:e.target.label_str, id:e.id});
        };
        
        _s.positionAndResizeYtbQualityButtons = function(ar){
            if(!ar) return;
            var totalButtons = ar.length;
            if(_s.prevYtbQualityButtonsLength == totalButtons) return;
            _s.prevYtbQualityButtonsLength = totalButtons;
            var btn;
            var startY = 5;
            var totalWidth = 0;
            var totalHeight = 0;
            
            for(var i=0; i<totalButtons; i++){
                btn = _s.ytbButtons_ar[i];
                if(btn){
                    btn.updateText(ar[i]);  
                }
            }
            
            setTimeout(function(){
                for(var i=0; i<_s.ttYtbBtns; i++){
                    btn = _s.ytbButtons_ar[i];

                    btn.setFinalSize();
                    if(i < totalButtons){
                        if(btn.x != 0) btn.setX(0);
                        if(btn.w > totalWidth) totalWidth = btn.w;
                        btn.setY(startY);
                        startY += btn.h;
                    }else{
                        if(btn.x != -3000) btn.setX(-3000);
                    }
                }
                
                for(var i=0; i<_s.ttYtbBtns; i++){
                    btn = _s.ytbButtons_ar[i];
                    if(btn.dumy_do.w < totalWidth){
                        btn.setWidth(totalWidth);
                        btn.dumy_do.setWidth(totalWidth);
                    }
                }
                
                totalHeight = startY + 5;
                _s.pointer_do.setX(parseInt((totalWidth - _s.pointer_do.w)/2));
                _s.pointer_do.setY(totalHeight);
                if(_s.ytbButtonBackground_do){
                    _s.ytbButtonBackground_do.setWidth(totalWidth);
                    _s.ytbButtonBackground_do.setHeight(totalHeight);
                }
                _s.ytbButtonsHolder_do.setWidth(totalWidth);
                _s.ytbButtonsHolder_do.setHeight(totalHeight);
            }, 300);
        };
        
        _s.disableQualityButtons = function(curQualityLevel, btnId){
            _s.showHDIcon(curQualityLevel);

            for(var i=0; i<_s.ttYtbBtns; i++){
                var btn = _s.ytbButtons_ar[i];
                
                if(btn.label_str == curQualityLevel
                    || btn.id === btnId){
                    FWDAnimation.killTweensOf(_s.ytbQualityArrow_do);

                    if(btnId !== undefined){
                        if(btn.id === btnId){
                            _s.showHDIcon(_s.ytbButtons_ar[btnId].label_str)
                        }
                    }

                    if(btn.y != 0){
                        _s.ytbQualityArrow_do.setY(btn.y + Math.round((btn.h - _s.ytbQualityArrow_do.h)/2));
                        _s.ytbDisabledButton_do = btn;
                    }
                    
                    btn.disable();
                }else{
                    btn.enable();
                }
            }
        };

        _s.showHDIcon = function(curQualityLevel){
            if(curQualityLevel == "highres"
                || curQualityLevel == "hd720" 
                || curQualityLevel == "hd1080"
                || curQualityLevel == "hd1440" 
                || curQualityLevel == "hd2160"
                || curQualityLevel == "hd2880"
            ){
                _s.ytbQualityButton_do.showDisabledState();
            }else{
                _s.ytbQualityButton_do.hideDisabledState();
            }
            
        }
        
        _s.setYtbQualityArrowPosition = function(target){
            var curY = 0;
            if(!target){
                curY = _s.ytbDisabledButton_do.y + parseInt((_s.ytbDisabledButton_do.h - _s.ytbQualityArrow_do.h)/2);
            }else{
                curY = target.y + parseInt((target.h - _s.ytbQualityArrow_do.h)/2);
            }
            FWDAnimation.killTweensOf(_s.ytbQualityArrow_do);
            FWDAnimation.to(_s.ytbQualityArrow_do, .6, {y:curY, delay:.1, ease:Expo.easeInOut});
        };
        
        _s.showQualityButtons = function(animate){
            if(_s.areYtbQualityButtonsShowed_bl || !_s.showYoutubeQualityButton_bl) return;
            _s.hideSubtitleButtons();
            _s.hideMainScrubberTop();
            _s.areYtbQualityButtonsShowed_bl = true;
            var finalX = parseInt(_s.ytbQualityButton_do.x + (parseInt(_s.ytbQualityButton_do.w - _s.ytbButtonsHolder_do.w)/2));
            var finalY = parseInt(prt.tempVidStageHeight - _s.sH - _s.ytbButtonsHolder_do.h - 6);
            
            if(window.hasPointerEvent_bl){
                window.addEventListener("pointerdown", _s.hideQualityButtonsHandler);
            }else{
                if(!_s.isMbl){
                    window.addEventListener("mousedown", _s.hideQualityButtonsHandler);
                }
                window.addEventListener("touchstart", _s.hideQualityButtonsHandler);
            }
            
            _s.ytbButtonsHolder_do.setX(finalX);
        
            if(animate){
                FWDAnimation.to(_s.ytbButtonsHolder_do, .6, {y:finalY, ease:Expo.easeInOut});
            }else{
                FWDAnimation.killTweensOf(_s.ytbButtonsHolder_do);
                _s.ytbButtonsHolder_do.setY(finalY);
            }
        };
    
        _s.hideQualityButtons = function(animate){
            if(!_s.areYtbQualityButtonsShowed_bl || !_s.showYoutubeQualityButton_bl) return;
            _s.hideSubtitleButtons();
            _s.areYtbQualityButtonsShowed_bl = false;
            if(animate){
                FWDAnimation.to(_s.ytbButtonsHolder_do, .6, {y:prt.sH, ease:Expo.easeInOut});
            }else{
                FWDAnimation.killTweensOf(_s.ytbButtonsHolder_do);
                _s.ytbButtonsHolder_do.setY(prt.sH);
            }
            
            if(window.hasPointerEvent_bl){
                window.removeEventListener("pointerdown", _s.hideQualityButtonsHandler);
            }else{
                if(!_s.isMbl){
                    window.removeEventListener("mousedown", _s.hideQualityButtonsHandler);
                }
                window.removeEventListener("touchstart", _s.hideQualityButtonsHandler);
            }
        };
        

        //##########################################//
        /* Setup subtitle button */
        //##########################################//
        _s.subtitlesSource_ar = _d.subtitles_ar;
        _s.subtitleButtons_ar = [];
        _s.totalSubttleButtons = 10;
        
        _s.setupSubtitleButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPComplexButton.setPrototype();
                _s.subtitleButton_do = new FWDUVPComplexButton(undefined, undefined, undefined, undefined, true, undefined, undefined, undefined,
                    "<span class='fwdicon fwdicon-CC'></span>",
                    "<span class='fwdicon fwdicon-CC-off'></span>",
                    "UVPMainButtonsNormalState",
                    "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPComplexButton.setPrototype();
                _s.subtitleButton_do = new FWDUVPComplexButton(
                        _d.showSubtitleNPath_img,
                        _d.showSubtitleSPath_str,
                        _d.hideSubtitleNPath_img,
                        _d.hideSubtitleSPath_str,
                        true,
                        _s.useHEX,
                        _s.nBC,
                        _s.sBC
                );
            }
            
            var checkIconInterval = setInterval(function(){
                if(_s.subtitleButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.subtitleButton_do.setY(parseInt((_s.sH - _s.subtitleButton_do.buttonHeight)/2));
                }
            }, 50);
            
            _s.subtitleButton_do.screen.className = 'fwduvp-subtitle-button';
            _s.buttons_ar.push(_s.subtitleButton_do);
            _s.subtitleButton_do.setY(parseInt((_s.sH - _s.subtitleButton_do.h)/2));
            _s.subtitleButton_do.addListener(FWDUVPComplexButton.MOUSE_UP, _s.subtitleButtonMouseUpHandler);
            _s.mainHld.addChild(_s.subtitleButton_do);
            
            _s.setupSubtitleButtons();
            
            if(location.protocol.indexOf("file:") != -1) _s.disableSubtitleButton();
            
            if(prt.subtitle_do.showSubtitileByDefault_bl) _s.subtitleButton_do.setButtonState(0);
        }
        
        _s.subtitleButtonMouseUpHandler = function(){
            if(_s.areSubtitleButtonsShowed_bl){
                _s.hideSubtitleButtons(true);
            }else{
                _s.showSubtitleButtons(true);
            }
        };
        
        _s.disableSubtitleButton = function(){
            if(_s.subtitleButton_do) _s.subtitleButton_do.disable();
        };
        
        _s.enableSubtitleButton = function(){
            if(_s.subtitleButton_do) _s.subtitleButton_do.enable();
        };




            
        //###################################################//
        /* Setup subtitlebuttons */
        //###################################################//
        _s.updateSubtitleButtons = function(subtitles, subtitleIndex){
            if(!_s.subtitleButton_do) return;
            
            _s.subtitlesSource_ar = subtitles;
            _s.positionAndResizeSubtitleButtons(subtitles);
            setTimeout(function(){
                subtitleIndex = _s.subtitlesSource_ar.length - 1 - subtitleIndex;
                _s.disableSubtitleButtons(subtitleIndex);
            },65);
            _s.prevSubtitleIndex = subtitleIndex;
        };  
        
        _s.setupSubtitleButtons = function(){
            _s.subtitlesButtonsHolder_do = new FWDUVPDisplayObject("div");
            _s.subtitlesButtonsHolder_do.setOverflow("visible");
            if(_s.repeatBackground_bl){
                _s.subtitlesButtonsHolder_do.getStyle().background = "url('" + _s.controllerBkPath_str +  "')";
            }else{
                _s.subtitlesButtonsBackground_do = new FWDUVPDisplayObject("img");
                var img = new Image();
                img.src = _s.controllerBkPath_str;
                _s.subtitlesButtonsBackground_do.setScreen(img);
                _s.subtitlesButtonsHolder_do.addChild(_s.subtitlesButtonsBackground_do);
            }
            
            _s.subtitlesButtonsHolder_do.setX(300);
            _s.subtitlesButtonsHolder_do.setY(-300);
            prt.videoHolder_do.addChild(_s.subtitlesButtonsHolder_do, 0);
            
            var img = new Image();
            img.src = _s.ytbQualityButtonPointerPath_str;
            _s.subtitlesPonter_do = new FWDUVPDisplayObject("img");
            _s.subtitlesPonter_do.setScreen(img);
            _s.subtitlesPonter_do.setWidth(_s.pointerWidth);
            _s.subtitlesPonter_do.setHeight(_s.pointerHeight);
            _s.subtitlesButtonsHolder_do.addChild(_s.subtitlesPonter_do);
    
            
            var img = new Image();
            img.src = _s.youtubeQualityArrowPath_str;
            _s.subtitleQualityArrow_do = new FWDUVPDisplayObject("img");
            _s.subtitleQualityArrow_do.setScreen(img);
            _s.subtitleQualityArrow_do.setX(7);
            _s.subtitleQualityArrow_do.setWidth(5);
            _s.subtitleQualityArrow_do.setHeight(7);
            _s.subtitlesButtonsHolder_do.addChild(_s.subtitleQualityArrow_do);
                    
            for(var i=0; i<_s.totalSubttleButtons; i++){
                FWDUVPYTBQButton.setPrototype();
                var btn = new FWDUVPYTBQButton("no source", 
                        _s.youtubeQualityButtonNormalColor_str, 
                        _s.youtubeQualityButtonSelectedColor_str,
                        _d.hdPath_str,
                        i);
                
                btn.addListener(FWDUVPYTBQButton.MOUSE_OVER, _s.sbtQualityOver);
                btn.addListener(FWDUVPYTBQButton.MOUSE_OUT, _s.sbtQualityOut);
                btn.addListener(FWDUVPYTBQButton.CLICK, _s.sbtQualityClick);
                _s.subtitleButtons_ar[i] = btn;
                _s.subtitlesButtonsHolder_do.addChild(btn);
            }
            _s.hideSubtitleButtons(false);
        };
        
        _s.sbtQualityOver = function(e){
            _s.setSubtitleArrowPosition(e.target);
        };
        
        _s.sbtQualityOut = function(e){
            _s.setSubtitleArrowPosition(undefined);
        };
        
        _s.sbtQualityClick = function(e){
            _s.startAtSubtitle = e.id;
            _s.disableSubtitleButtons(_s.startAtSubtitle);
            _s.hideSubtitleButtons(true);
            
            _s.dispatchEvent(FWDUVPController.CHANGE_SUBTITLE, {id:_s.subtitlesSource_ar.length -1 - e.id});
        };
        
        _s.positionAndResizeSubtitleButtons = function(ar){
            if(!ar) return;
            
            var totalButtons = ar.length;
            if(_s.prevSubtitlesQualityButtonsLength == totalButtons) return;
            _s.prevSubtitlesQualityButtonsLength = totalButtons;
            var btn;
            var startY = 5;
            var totalWidth = 0;
            var totalHeight = 0;

            for(var i=0; i<totalButtons; i++){
                btn = _s.subtitleButtons_ar[i];
                btn.updateText(ar[i]["label"]);
                btn.setFinalSize();
            }
            
            setTimeout(function(){
                for(var i=0; i<_s.totalSubttleButtons; i++){
                    btn = _s.subtitleButtons_ar[i];
                    if(i < totalButtons){
                        if(btn.x != 0) btn.setX(0);
                        if(btn.w > totalWidth) totalWidth = btn.w;
                        btn.setY(startY);
                        startY += btn.h;
                    }else{
                        if(btn.x != -3000) btn.setX(-3000);
                    }
                }
                
                for(var i=0; i<_s.totalSubttleButtons; i++){
                    btn = _s.subtitleButtons_ar[i];
                    if(btn.dumy_do.w < totalWidth){
                        btn.setWidth(totalWidth);
                        btn.dumy_do.setWidth(totalWidth);
                    }
                }
                
                totalHeight = startY + 5;
                _s.subtitlesPonter_do.setX(parseInt((totalWidth - _s.subtitlesPonter_do.w)/2));
                _s.subtitlesPonter_do.setY(totalHeight);
                if(_s.subtitlesButtonsBackground_do){   
                    _s.subtitlesButtonsBackground_do.setWidth(totalWidth);
                    _s.subtitlesButtonsBackground_do.setHeight(totalHeight);
                }
                _s.subtitlesButtonsHolder_do.setWidth(totalWidth);
                _s.subtitlesButtonsHolder_do.setHeight(totalHeight);
            }, 60);
        };
        
        _s.disableSubtitleButtons = function(index){
            for(var i=0; i<_s.totalSubttleButtons; i++){
                var btn = _s.subtitleButtons_ar[i];
                if(i == index){
                    FWDAnimation.killTweensOf(_s.subtitleQualityArrow_do);
                    _s.subtitleQualityArrow_do.setY(btn.y + parseInt((btn.h - _s.subtitleQualityArrow_do.h)/2) + 1);
                    btn.disable();
                    _s.subtitleDisabledButton_do = btn;
                }else{
                    btn.enable();
                }
            }
            
            if(_s.subtitlesSource_ar.length -1 - index == 0){
                _s.subtitleButton_do.setButtonState(0);
            }else{
                _s.subtitleButton_do.setButtonState(1);
            }
        };
        
        _s.setSubtitleArrowPosition = function(target){
            var curY = 0;
            if(!target){
                curY = _s.subtitleDisabledButton_do.y + parseInt((_s.subtitleDisabledButton_do.h - _s.subtitleQualityArrow_do.h)/2);
            }else{
                curY = target.y + parseInt((target.h - _s.subtitleQualityArrow_do.h)/2);
            }
            FWDAnimation.killTweensOf(_s.subtitleQualityArrow_do);
            FWDAnimation.to(_s.subtitleQualityArrow_do, .6, {y:curY, delay:.1, ease:Expo.easeInOut});
        };
        
        _s.showSubtitleButtons = function(animate){
            if(_s.areSubtitleButtonsShowed_bl) return;
            _s.hideQualityButtons();
            _s.hideMainScrubberTop();
            _s.areSubtitleButtonsShowed_bl = true;
            var finalX = parseInt(_s.subtitleButton_do.x + (parseInt(_s.subtitleButton_do.w - _s.subtitlesButtonsHolder_do.w)/2));
            var finalY = parseInt(prt.tempVidStageHeight - _s.sH - _s.subtitlesButtonsHolder_do.h - 6);
            
            if(_s.hasPointerEvent_bl){
                window.addEventListener("pointerdown", _s.hideSubtitlesButtonsHandler);
            }else{
                if(!_s.isMbl){
                    window.addEventListener("mousedown", _s.hideSubtitlesButtonsHandler);
                }
                window.addEventListener("touchstart", _s.hideSubtitlesButtonsHandler);
            }
            
            _s.subtitlesButtonsHolder_do.setX(finalX);
        
            if(animate){
                FWDAnimation.to(_s.subtitlesButtonsHolder_do, .6, {y:finalY, ease:Expo.easeInOut});
            }else{
                FWDAnimation.killTweensOf(_s.subtitlesButtonsHolder_do);
                _s.subtitlesButtonsHolder_do.setY(finalY);
            }
        };
    
        _s.hideSubtitleButtons = function(animate){
            if(!_s.areSubtitleButtonsShowed_bl || !_s.subtitlesButtonsHolder_do) return;
            _s.areSubtitleButtonsShowed_bl = false;
            if(animate){
                FWDAnimation.to(_s.subtitlesButtonsHolder_do, .6, {y:prt.sH, ease:Expo.easeInOut});
            }else{
                FWDAnimation.killTweensOf(_s.subtitlesButtonsHolder_do);
                _s.subtitlesButtonsHolder_do.setY(prt.sH);
            }
            
            if(_s.hasPointerEvent_bl){
                window.removeEventListener("pointerdown", _s.hideSubtitlesButtonsHandler);
            }else{
                if(!_s.isMbl){
                    window.removeEventListener("mousedown", _s.hideSubtitlesButtonsHandler);
                }
                window.removeEventListener("touchstart", _s.hideSubtitlesButtonsHandler);
            }
            _s.showMainScrubberOnTop();
        };
        
        _s.hideSubtitlesButtonsHandler = function(e){
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            if(FWDUVPUtils.hitTest(_s.subtitleButton_do.screen, vc.screenX, vc.screenY)
               || FWDUVPUtils.hitTest(_s.subtitlesButtonsHolder_do.screen, vc.screenX, vc.screenY)){
                return;
            }
            _s.hideSubtitleButtons(true);
        };
        
        
        //##########################################//
        /* Setup youtube quality button */
        //##########################################//
        _s.setupYoutubeQualityButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.ytbQualityButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-settings'></span>",
                        _d.hdIcn,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.ytbQualityButton_do = new FWDUVPSimpleButton(
                        _s.ytbQualityN_img,
                        _d.ytbQualitySPath_str,
                        _d.ytbQualityDPath_str,
                        true,
                        _s.useHEX,
                        _s.nBC,
                        _s.sBC
                );
            }
            
            _s.ytbQualityButton_do.screen.className = 'fwduvp-quality-button';
            _s.ytbQualityButton_do.setX(-300);
            _s.ytbQualityButton_do.setY(parseInt((_s.sH - _s.ytbQualityButton_do.h)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.ytbQualityButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.ytbQualityButton_do.setY(parseInt((_s.sH - _s.ytbQualityButton_do.buttonHeight)/2));
                }
            }, 50);
            _s.ytbQualityButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.ytbQualityMouseUpHandler);
            _s.mainHld.addChild(_s.ytbQualityButton_do);
        };
        
        _s.ytbQualityMouseUpHandler = function(){
            
            if(_s.areYtbQualityButtonsShowed_bl){
                _s.hideQualityButtons(true);
                if(_s.isMainScrubberOnTop_bl){
                    _s.mainScrubber_do.setX(0);
                    FWDAnimation.to(_s.mainScrubber_do, .6, {alpha:1});
                }
            }else{
                _s.showQualityButtons(true);
            }
        };
        
        _s.hideQualityButtonsHandler = function(e){
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            if(FWDUVPUtils.hitTest(_s.ytbQualityButton_do.screen, vc.screenX, vc.screenY)
               || FWDUVPUtils.hitTest(_s.ytbButtonsHolder_do.screen, vc.screenX, vc.screenY)){
                return;
            }
            _s.hideQualityButtons(true);
            _s.showMainScrubberOnTop();
        };
        
        _s.addYtbQualityButton = function(){
            if(_s.hasYtbButton_bl || !_s.showYoutubeQualityButton_bl) return;
            _s.hasYtbButton_bl = true;
            var indexToAdd;
            if(_s.subtitleButton_do && _s.getButtonIndex(_s.subtitleButton_do) != -1){
                indexToAdd = _s.getButtonIndex(_s.subtitleButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.ytbQualityButton_do);
            }else if(_s.playbackRateButton_do && _s.getButtonIndex(_s.playbackRateButton_do) != -1){
                indexToAdd = _s.getButtonIndex(_s.playbackRateButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.ytbQualityButton_do);
            }else if(_s.atbButton_do && _s.getButtonIndex(_s.atbButton_do) != -1){
                indexToAdd = _s.getButtonIndex(_s.atbButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.ytbQualityButton_do);
            }else if(_s.infoButton_do && _s.getButtonIndex(_s.infoButton_do) != -1){
                indexToAdd = _s.getButtonIndex(_s.infoButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.ytbQualityButton_do);
            }else if(_s.downloadButton_do && _s.getButtonIndex(_s.downloadButton_do) != -1){
                indexToAdd = _s.getButtonIndex(_s.ytbQualityButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.ytbQualityButton_do);
            }else if(_s.ccBtn_do && _s.getButtonIndex(_s.ccBtn_do) != -1){
                indexToAdd = _s.getButtonIndex(_s.ccBtn_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.ytbQualityButton_do);
            }else if(_s.vrButton_do){
                indexToAdd = _s.getButtonIndex(_s.vrButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.ytbQualityButton_do);
            }else if(_s.fullScreenButton_do){
                indexToAdd = _s.getButtonIndex(_s.fullScreenButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.ytbQualityButton_do);
            }else{
                _s.buttons_ar.splice(_s.buttons_ar.length,0, _s.ytbQualityButton_do);
            }
            
            _s.ytbQualityButton_do.disable();
            _s.ytbQualityButton_do.rotation = 0;
            _s.ytbQualityButton_do.setRotation(_s.ytbQualityButton_do.rotation);
            _s.ytbQualityButton_do.hideDisabledState();
            _s.hideQualityButtons(false);
            
            _s.positionButtons();
        };
        
        _s.removeYtbQualityButton = function(){
            if(!_s.hasYtbButton_bl || !_s.showYoutubeQualityButton_bl) return;
            _s.hasYtbButton_bl = false;
            _s.buttons_ar.splice(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.ytbQualityButton_do), 1);
            
            _s.ytbQualityButton_do.setX(-300);
            _s.ytbQualityButton_do.hideDisabledState();
            _s.hideQualityButtons(false);
            _s.positionButtons();
        };
        
        _s.updateQuality = function(qualityLevels, curQualityLevel, id){
            if(!_s.hasYtbButton_bl || !_s.showYoutubeQualityButton_bl) return;

            _s.positionAndResizeYtbQualityButtons(qualityLevels);
            
            setTimeout(function(){
                _s.disableQualityButtons(curQualityLevel, id);
            },300);
        };  

        
        //##########################################//
        /* Setup info  button */
        //#########################################//
        _s.setupInfoButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.infoButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-info'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.infoButton_do = new FWDUVPSimpleButton(_s.infoN_img, _d.infoSPath_str, undefined, true, _s.useHEX,
                        _s.nBC,
                        _s.sBC);
            }

            _s.infoButton_do.screen.className = 'fwduvp-ifon-button';
            var checkIconInterval = setInterval(function(){
                if(_s.infoButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.infoButton_do.setY(parseInt((_s.sH - _s.infoButton_do.buttonHeight)/2));
                }
            }, 50);
            _s.infoButton_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.infoButtonShowToolTipHandler);
            _s.infoButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.infoButtonOnMouseUpHandler);
            _s.infoButton_do.setX(-300);
            _s.infoButton_do.setY(parseInt((_s.sH - _s.infoButton_do.h)/2));
            _s.mainHld.addChild(_s.infoButton_do);
        };
        
        _s.infoButtonShowToolTipHandler = function(e){
            _s.showToolTip(_s.infoButton_do, _s.infoButtonToolTip_do, e.e);
        };
        
        _s.infoButtonOnMouseUpHandler = function(){
            _s.dispatchEvent(FWDUVPController.SHOW_INFO_WINDOW);
        };
        
        _s.enableQualtyButton = function(){
            if(_s.ytbQualityButton_do) _s.ytbQualityButton_do.enable();
        }
        
        _s.disableQualtyButton = function(){
            if(_s.ytbQualityButton_do) _s.ytbQualityButton_do.disable();
        }
        

        //##########################################//
        /* Setup download button */
        //#########################################//
        _s.setupDownloadButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.downloadButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-download'></span>",
                        undefined,
                        "UVPMainButtonsNormalState dw",
                        "UVPMainButtonsSelectedState dw"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.downloadButton_do = new FWDUVPSimpleButton(_s.downloadN_img, _d.downloadSPath_str, undefined, true, _s.useHEX,
                        _s.nBC,
                        _s.sBC);
            }

            _s.downloadButton_do.screen.className = 'fwduvp-download-button';
            _s.downloadButton_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.downloadButtonShowToolTipHandler);
            _s.downloadButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.downloadButtonOnMouseUpHandler);
            _s.downloadButton_do.setX(-300);
            _s.downloadButton_do.setY(parseInt((_s.sH - _s.downloadButton_do.h)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.downloadButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.downloadButton_do.setY(parseInt((_s.sH - _s.downloadButton_do.buttonHeight)/2));
                }
            }, 50);
            _s.mainHld.addChild(_s.downloadButton_do); 
        };
        
        _s.downloadButtonShowToolTipHandler = function(e){
            _s.showToolTip(_s.downloadButton_do, _s.downloadButtonToolTip_do, e.e);
        };
        
        _s.downloadButtonOnMouseUpHandler = function(){
            _s.dispatchEvent(FWDUVPController.DOWNLOAD_VIDEO);
        };
        
        
        //##########################################//
        /* Setup thumbnails preview */
        //##########################################//
        _s.setupThumbnailsPreview =  function(){
            if(_s.thumbnailsPreview_do || !window['FWDUVPThumbnailsPreview']) return;
            FWDUVPThumbnailsPreview.setPrototype();
            _s.thumbnailsPreview_do = new FWDUVPThumbnailsPreview(_s);
            _s.thumbnailsPreview_do.addListener(FWDUVPData.LOAD_ERROR, function(e){
                
                _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:e.text});
            });
        }

        //##########################################//
        /* Setup a to b button */
        //##########################################//
        _s.setupATB = function(){
            FWDUVPATB.setPrototype();
            _s.atb = new FWDUVPATB(_s);
            _s.mainHld.addChild(_s.atb);
            _s.atb.addListener(FWDUVPATB.START_TO_SCRUB, _s.atbStartToScrub);
            _s.atb.addListener(FWDUVPATB.STOP_TO_SCRUB, _s.atbStopToScrub);
        }

        _s.atbStartToScrub = function(){
            prt.showDisable();
        }

        _s.atbStopToScrub = function(){
            prt.hideDisable();
        }

        _s.setupAtbButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.atbButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-AB'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.atbButton_do = new FWDUVPSimpleButton(
                        _d.atbNPath_img,
                        _d.atbSPath_str,
                        undefined,
                        true,
                        _s.useHEX,
                        _s.nBC,
                        _s.sBC
                );
            }
            
            _s.atbButton_do.screen.className = 'fwduvp-a-to-b-button';
            _s.atbButton_do.setX(-5000);
            _s.atbButton_do.setY(parseInt((_s.sH - _s.atbButton_do.h)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.atbButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.atbButton_do.setY(parseInt((_s.sH - _s.atbButton_do.buttonHeight)/2));
                }
            }, 50);
            _s.atbButton_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.atbButtonShowTooltipHandler);
            _s.atbButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.atbButtonMouseUpHandler);
            _s.mainHld.addChild(_s.atbButton_do);
        };
        
        _s.atbButtonShowTooltipHandler = function(e){
            _s.showToolTip(_s.atbButton_do, _s.atbButtonToolTip_do, e.e);
        };
        
    
        _s.atbButtonMouseUpHandler = function(){
            if(_s.atbButton_do.isSelected){
                _s.atbButton_do.doNotallowToSetNormal = false;
                _s.atbButton_do.isSelected = false;
                _s.atb.hide(true);
                if(_s.isMbl) _s.atbButton_do.setNormalState();
            }else{
                _s.atbButton_do.isSelected = true;
                _s.atbButton_do.doNotallowToSetNormal = true;
                _s.atbButton_do.setSelectedState();
                _s.atb.show(true);
            }
            
        };

        _s.disableAtbButton = function(){
            if(_s.atbButton_do) _s.atbButton_do.disable();
        };
        
        _s.enableAtbButton = function(){
            if(_s.atbButton_do) _s.atbButton_do.enable();
        };

        
        //##########################################//
        /* Setup facebook button */
        //##########################################//
        _s.setupShareButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.shareButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-share'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.shareButton_do = new FWDUVPSimpleButton(
                        _d.shareN_img,
                        _d.shareSPath_str,
                        undefined,
                        true,
                        _s.useHEX,
                        _s.nBC,
                        _s.sBC
                );
            }
            
            _s.shareButton_do.screen.className = 'fwduvp-share-button';
            _s.buttons_ar.push(_s.shareButton_do);
            _s.shareButton_do.setY(parseInt((_s.sH - _s.shareButton_do.h)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.shareButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.shareButton_do.setY(parseInt((_s.sH - _s.shareButton_do.buttonHeight)/2));
                }
            }, 50);
            _s.shareButton_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.facebookButtonShowTooltipHandler);
            _s.shareButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.facebookButtonMouseUpHandler);
            _s.mainHld.addChild(_s.shareButton_do);
        };
        
        _s.facebookButtonShowTooltipHandler = function(e){
            _s.showToolTip(_s.shareButton_do, _s.facebookButtonToolTip_do, e.e);
        };
        
    
        _s.facebookButtonMouseUpHandler = function(){
            _s.dispatchEvent(FWDUVPController.SHOW_SHARE_WINDOW);
        };

        
        //##########################################//
        /* Setup chromecast button */
        //##########################################//
        _s.setupChromecastButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPComplexButton.setPrototype();
                _s.ccBtn_do = new FWDUVPComplexButton(undefined, undefined, undefined, undefined, true, undefined, undefined, undefined,
                    "<span class='fwdicon fwdicon-cast'></span>",
                    "<span class='fwdicon fwdicon-uncast'></span>",
                    "UVPMainButtonsNormalState",
                    "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPComplexButton.setPrototype();
                _s.ccBtn_do = new FWDUVPComplexButton(
                    _d.castN_img,
                    _d.castSPath_str,
                    _d.uncastN_img,
                    _d.uncastSPath_str,
                    true,
                    _s.useHEX,
                    _s.nBC,
                    _s.sBC
                );
            }
                
            var checkIconInterval = setInterval(function(){
                if(_s.ccBtn_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.ccBtn_do.setY(parseInt((_s.sH - _s.ccBtn_do.buttonHeight)/2));
                }
            }, 50);

            _s.ccBtn_do.screen.className = 'fwduvp-chromecast-button';
            _s.ccBtn_do.setY(parseInt((_s.sH - _s.ccBtn_do.buttonHeight)/2));
            _s.ccBtn_do.addListener(FWDUVPComplexButton.MOUSE_UP, _s.chormecastMouseUpHandler);
            _s.ccBtn_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.castTooltipHandler);
            _s.ccBtn_do.setX(-500);
            _s.mainHld.addChild(_s.ccBtn_do);
        }
        
        _s.castTooltipHandler = function(e){
            _s.showToolTip(_s.ccBtn_do, _s.castButtonToolTip_do, e.e);
        };

        _s.chormecastMouseUpHandler = function(){
            if(_s.ccBtn_do.currentState == 0){
                _s.dispatchEvent(FWDUVPController.UNCAST);
            }else{
                _s.dispatchEvent(FWDUVPController.CAST);
            }
        }
        
        _s.removeCCButton = function(){
            if(!_s.ccBtn_do) return;
            if(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.ccBtn_do) != -1){
                _s.buttons_ar.splice(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.ccBtn_do), 1);
                _s.ccBtn_do.setX(-300);
                _s.positionButtons();
            }
        };
        
        _s.addCCButton = function(){
            
            if(!_s.ccBtn_do) return;
            
            if(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.ccBtn_do) == -1){
                if(_s.vrButton_do){
                    var indexToAdd = _s.getButtonIndex(_s.vrButton_do);
                    _s.buttons_ar.splice(indexToAdd, 0, _s.ccBtn_do);
                }else if(_s.fullScreenButton_do && FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.fullScreenButton_do) != -1){
                    _s.buttons_ar.splice(FWDUVPUtils.indexOfArray(_s.buttons_ar, _s.fullScreenButton_do), 0, _s.ccBtn_do);
                }else{
                    _s.buttons_ar.splice(_s.buttons_ar.length, 0, _s.ccBtn_do);
                }
                _s.positionButtons();
            }
        };


        //###################################################//
        /* Setup audio traks button */
        //###################################################//
        _s.setupAudioTracksButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.atButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-headephone'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
                _s.atButton_do.screen.className = "fwduvp-audio-tracks-button vector";
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.atButton_do = new FWDUVPSimpleButton(_d.at_img,
                                                             _d.atSPath_img, 
                                                             undefined, 
                                                             true,
                                                             _s.useHEX,
                                                             _s.nBC,
                                                             _s.sBC);
                _s.atButton_do.screen.className = "fwduvp-audio-tracks-button";
            }

            var checkIconInterval = setInterval(function(){
                if(_s.atButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.atButton_do.setY(parseInt((_s.sH - _s.atButton_do.buttonHeight)/2));
                }
            }, 50);
            
            _s.atButton_do.screen.className = 'fwduvp-audio-tracks-button';
            _s.atButton_do.setY(parseInt((_s.sH - _s.atButton_do.h)/2));
            _s.atButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.atButtonMouseUpHandler);
            _s.atButton_do.setX(-300);
            _s.mainHld.addChild(_s.atButton_do);

            _s.setupATBButtons();
            
            _s.disableAtButton();
        }
        
        _s.atButtonMouseUpHandler = function(){
            _s.showATBButtons(true);
        };
        
        _s.disableAtButton = function(){
            if(_s.atButton_do) _s.atButton_do.disable();
        };
        
        _s.enableAtButton = function(){
            if(_s.atButton_do) _s.atButton_do.enable();
        };
        
        _s.removeAtButton = function(){
            if(!_s.atButton_do) return;
            if(_s.getButtonIndex(_s.atButton_do) != -1){
                _s.buttons_ar.splice(_s.getButtonIndex(_s.atButton_do), 1);
                _s.atButton_do.setX(-300);
            }
        };
        
        _s.addAtButton = function(){
            if(!_s.atButton_do) return;
            if(_s.getButtonIndex(_s.atButton_do) != -1) return;
            
            _s.disableAtButton();
            if(_s.ytbQualityButton_do && _s.getButtonIndex(_s.ytbQualityButton_do) != -1){
                var indexToAdd = _s.getButtonIndex(_s.ytbQualityButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.atButton_do);
            }else if(_s.fullScreenButton_do && _s.getButtonIndex(_s.fullScreenButton_do) != -1){
                var indexToAdd = _s.getButtonIndex(_s.fullScreenButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.atButton_do);
            }else{
                _s.buttons_ar.splice(_s.buttons_ar.length,0, _s.atButton_do);
            }
            _s.positionButtons();
        };


        //###################################################//
        /* Setup audio tracks buttons. */
        //###################################################//
        _s.totalATBButtons = 10;
        _s.areATBButtonsShowed_bl = false;
        _s.updateATBButtons = function(ATB, ATBIndex){
            if(!_s.atButton_do) return;
        
            _s.ATBSource_ar = ATB;

            _s.positionAndResizeATBButtons(ATB);
            
            setTimeout(function(){
                ATBIndex = _s.ATBSource_ar.length - 1 - ATBIndex;
                _s.disableATBButtons(ATBIndex);
            },65);
            _s.prevATBIndex = ATBIndex;
        };  
        
        _s.setupATBButtons = function(){

            _s.ATBButtons_ar = [];
            _s.ATBButtonsHolder_do = new FWDUVPDisplayObject("div");
            _s.ATBButtonsHolder_do.setOverflow("visible");
            if(_s.repeatBackground_bl){
                _s.ATBButtonsHolder_do.getStyle().background = "url('" + _s.controllerBkPath_str +  "')";
            }else{
                _s.ATBButtonsBackground_do = new FWDUVPDisplayObject("img");
                var img = new Image();
                img.src = _s.controllerBkPath_str;
                _s.ATBButtonsBackground_do.setScreen(img);
                _s.ATBButtonsHolder_do.addChild(_s.ATBButtonsBackground_do);
            }
            
            _s.ATBButtonsHolder_do.setX(300);
            _s.ATBButtonsHolder_do.setY(-300);
            prt.videoHolder_do.addChild(_s.ATBButtonsHolder_do, 0);
            
            var img = new Image();
            img.src = _s.ytbQualityButtonPointerPath_str;
            _s.ATBPonter_do = new FWDUVPDisplayObject("img");
            _s.ATBPonter_do.setScreen(img);
            _s.ATBPonter_do.setWidth(_s.pointerWidth);
            _s.ATBPonter_do.setHeight(_s.pointerHeight);
            _s.ATBButtonsHolder_do.addChild(_s.ATBPonter_do);
    
            var img = new Image();
            img.src = _s.youtubeQualityArrowPath_str;
            _s.ABTQualityArrow_do = new FWDUVPDisplayObject("img");
            _s.ABTQualityArrow_do.setScreen(img);
            _s.ABTQualityArrow_do.setX(7);
            _s.ABTQualityArrow_do.setWidth(5);
            _s.ABTQualityArrow_do.setHeight(7);
            _s.ATBButtonsHolder_do.addChild(_s.ABTQualityArrow_do);
                    
            for(var i=0; i<_s.totalATBButtons; i++){
                FWDUVPYTBQButton.setPrototype();
                var btn = new FWDUVPYTBQButton("no source", 
                        _s.youtubeQualityButtonNormalColor_str, 
                        _s.youtubeQualityButtonSelectedColor_str,
                        _d.hdPath_str,
                        i);
                
                btn.addListener(FWDUVPYTBQButton.MOUSE_OVER, _s.ATBQualityOver);
                btn.addListener(FWDUVPYTBQButton.MOUSE_OUT, _s.ATBQualityOut);
                btn.addListener(FWDUVPYTBQButton.CLICK, _s.ATBQualityClick);
                _s.ATBButtons_ar[i] = btn;
                _s.ATBButtonsHolder_do.addChild(btn);
            }
            _s.hideATBButtons(false);
        };
        
        _s.ATBQualityOver = function(e){
            _s.setATBArrowPosition(e.target);
        };
        
        _s.ATBQualityOut = function(e){
            _s.setATBArrowPosition(undefined);
        };
        
        _s.ATBQualityClick = function(e){
            _s.startAtATB = e.id;
            
            _s.disableATBButtons(_s.startAtATB);
            _s.hideATBButtons(true);
            
            _s.dispatchEvent(FWDUVPController.CHANGE_AUDIO_TRACKS, {id:_s.ATBSource_ar.length -1 - e.id});
        };
        
        _s.positionAndResizeATBButtons = function(ar){
            if(!ar) return;
            
            var totalButtons = ar.length;

            if(_s.prevATBButtonsLength == totalButtons) return;
            _s.prevATBButtonsLength = totalButtons;

            var btn;
            var startY = 5;
            var totalWidth = 0;
            var totalHeight = 0;

            for(var i=0; i<totalButtons; i++){
                btn = _s.ATBButtons_ar[i];
                btn.updateText(ar[i]["label"]);
                btn.setFinalSize();
            }

            setTimeout(function(){
                for(var i=0; i<_s.totalATBButtons; i++){
                    btn = _s.ATBButtons_ar[i];
                    if(i < totalButtons){
                        if(btn.x != 0) btn.setX(0);
                        if(btn.w > totalWidth) totalWidth = btn.w;
                        btn.setY(startY);
                        startY += btn.h;
                    }else{
                        if(btn.x != -3000) btn.setX(-3000);
                    }
                }
                
                for(var i=0; i<_s.totalATBButtons; i++){
                    btn = _s.ATBButtons_ar[i];
                    if(btn.dumy_do.w < totalWidth){
                        btn.setWidth(totalWidth);
                        btn.dumy_do.setWidth(totalWidth);
                    }
                }
                
                totalHeight = startY + 5;

                _s.ATBPonter_do.setX(parseInt((totalWidth - _s.ATBPonter_do.w)/2));
                _s.ATBPonter_do.setY(totalHeight);
                if(_s.ATBButtonsBackground_do){ 
                    _s.ATBButtonsBackground_do.setWidth(totalWidth);
                    _s.ATBButtonsBackground_do.setHeight(totalHeight);
                }
                _s.ATBButtonsHolder_do.setWidth(totalWidth);
                _s.ATBButtonsHolder_do.setHeight(totalHeight);
            }, 60);
        };
        
        _s.disableATBButtons = function(index){
            for(var i=0; i<_s.totalATBButtons; i++){
                var btn = _s.ATBButtons_ar[i];
                if(i == index){
                    FWDAnimation.killTweensOf(_s.ABTQualityArrow_do);
                    _s.ABTQualityArrow_do.setY(btn.y + parseInt((btn.h - _s.ABTQualityArrow_do.h)/2) + 1);
                    btn.disable();
                    _s.ABTDisabledButton_do = btn;
                }else{
                    btn.enable();
                }
            }
        };
        
        _s.setATBArrowPosition = function(target){
            var curY = 0;
            if(!target){
                curY = _s.ABTDisabledButton_do.y + parseInt((_s.ABTDisabledButton_do.h - _s.ABTQualityArrow_do.h)/2);
            }else{
                curY = target.y + parseInt((target.h - _s.ABTQualityArrow_do.h)/2);
            }
            FWDAnimation.killTweensOf(_s.ABTQualityArrow_do);
            FWDAnimation.to(_s.ABTQualityArrow_do, .6, {y:curY, delay:.1, ease:Expo.easeInOut});
        };
        
        _s.showATBButtons = function(animate){
            _s.hideATBButtons();
            _s.hideMainScrubberTop();
            _s.areATBButtonsShowed_bl = true;
            var finalX = parseInt(_s.atButton_do.x + (parseInt(_s.atButton_do.w - _s.ATBButtonsHolder_do.w)/2));
            var finalY = parseInt(prt.tempVidStageHeight - _s.sH - _s.ATBButtonsHolder_do.h - 6);
            
            if(_s.hasPointerEvent_bl){
                window.addEventListener("pointerdown", _s.hideATBsButtonsHandler);
            }else{
                if(!_s.isMbl){
                    window.addEventListener("mousedown", _s.hideATBsButtonsHandler);
                }
                window.addEventListener("touchstart", _s.hideATBsButtonsHandler);
            }
            
            _s.ATBButtonsHolder_do.setX(finalX);
        
            if(animate){
                FWDAnimation.to(_s.ATBButtonsHolder_do, .6, {y:finalY, ease:Expo.easeInOut});
            }else{
                FWDAnimation.killTweensOf(_s.ATBButtonsHolder_do);
                _s.ATBButtonsHolder_do.setY(finalY);
            }
        };
    
        _s.hideATBButtons = function(animate){
            if(!_s.ATBButtonsHolder_do) return;
            
            _s.areATBButtonsShowed_bl = false;
            if(animate){
                FWDAnimation.to(_s.ATBButtonsHolder_do, .6, {y:prt.sH, ease:Expo.easeInOut});
            }else{
                FWDAnimation.killTweensOf(_s.ATBButtonsHolder_do);
                _s.ATBButtonsHolder_do.setY(prt.sH);
            }

            if(_s.hasPointerEvent_bl){
                window.removeEventListener("pointerdown", _s.hideATBsButtonsHandler);
            }else{
                if(!_s.isMbl){
                    window.removeEventListener("mousedown", _s.hideATBsButtonsHandler);
                }
                window.removeEventListener("touchstart", _s.hideATBsButtonsHandler);
            }
            _s.showMainScrubberOnTop();
        };
        
        _s.hideATBsButtonsHandler = function(e){
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            if(FWDUVPUtils.hitTest(_s.atButton_do.screen, vc.screenX, vc.screenY)
               || FWDUVPUtils.hitTest(_s.ATBButtonsHolder_do.screen, vc.screenX, vc.screenY)){
                return;
            }
            _s.hideATBButtons(true);
        };


        //###################################################//
        /* Setup VR button */
        //###################################################//
        _s.setupVrButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.vrButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-vr'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
                    _s.vrButton_do.screen.className = "FWDUVP-vr-button vector";
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.vrButton_do = new FWDUVPSimpleButton(_d.vr_img,
                                                             _d.vrSPath_img, 
                                                             undefined, 
                                                             true,
                                                             _s.useHEX,
                                                             _s.nBC,
                                                             _s.sBC);
                    _s.vrButton_do.screen.className = "FWDUVP-vr-button";
            }
            
            _s.vrButton_do.screen.className = 'fwduvp-vr-button';
            _s.vrButton_do.setY(parseInt((_s.sH - _s.vrButton_do.h)/2));
            _s.vrButton_do.addListener(FWDUVPComplexButton.SHOW_TOOLTIP, _s.vrButtonShowToolTipHandler);
            _s.vrButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.vrButtonMouseUpHandler);
            _s.mainHld.addChild(_s.vrButton_do);
            _s.vrButton_do.setX(-300);
            _s.disableVrButton();
        }

        _s.vrButtonShowToolTipHandler =  function(e){
            _s.showToolTip(_s.vrButton_do, _s.vrToolTip_do, e.e);
        }
        
        _s.vrButtonMouseUpHandler = function(){
            _s.dispatchEvent(FWDUVPController.VR);
        };
        
        _s.disableVrButton = function(){
            if(_s.vrButton_do) _s.vrButton_do.disable();
        };
        
        _s.enableVrButton = function(){
            if(_s.vrButton_do) _s.vrButton_do.enable();
        };
        
        _s.removeVrButton = function(){
            if(!_s.vrButton_do) return;
            if(_s.getButtonIndex(_s.vrButton_do) != -1){
                _s.buttons_ar.splice(_s.getButtonIndex(_s.vrButton_do), 1);
                _s.vrButton_do.setX(-300);
            }
        };
        
        _s.addVrButton = function(){
            if(!_s.vrButton_do) return;
            if(_s.getButtonIndex(_s.vrButton_do) != -1) return;
            
            _s.disableVrButton();
            if(_s.fullScreenButton_do && _s.getButtonIndex(_s.fullScreenButton_do) != -1){
                var indexToAdd = _s.getButtonIndex(_s.fullScreenButton_do);
                _s.buttons_ar.splice(indexToAdd, 0, _s.vrButton_do);
            }else{
                _s.buttons_ar.splice(_s.buttons_ar.length,0, _s.infoButton_do);
            }
        };



        //##########################################//
        /* Setup fullscreen button */
        //##########################################//
        _s.setupFullscreenButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPComplexButton.setPrototype();
                _s.fullScreenButton_do = new FWDUVPComplexButton(undefined, undefined, undefined, undefined, true, undefined, undefined, undefined,
                    "<span class='fwdicon fwdicon-fullscreen'></span>",
                    "<span class='fwdicon fwdicon-normalscreen'></span>",
                    "UVPMainButtonsNormalState",
                    "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPComplexButton.setPrototype();
                _s.fullScreenButton_do = new FWDUVPComplexButton(
                        _s.fullScreenN_img,
                        _d.fullScreenSPath_str,
                        _s.normalScreenN_img,
                        _d.normalScreenSPath_str,
                        true,
                        _s.useHEX,
                        _s.nBC,
                        _s.sBC
                );
            }
            
            _s.buttons_ar.push(_s.fullScreenButton_do);
            _s.fullScreenButton_do.setY(parseInt((_s.sH - _s.fullScreenButton_do.buttonHeight)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.fullScreenButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.fullScreenButton_do.setY(parseInt((_s.sH - _s.fullScreenButton_do.buttonHeight)/2));
                }
            }, 50);

            _s.fullScreenButton_do.screen.className = 'fwduvp-fullscreen-button';
            _s.fullScreenButton_do.addListener(FWDUVPComplexButton.SHOW_TOOLTIP, _s.fullscreenButtonShowToolTipHandler);
            _s.fullScreenButton_do.addListener(FWDUVPComplexButton.MOUSE_UP, _s.fullScreenButtonMouseUpHandler);
            _s.mainHld.addChild(_s.fullScreenButton_do);
        };
        
        _s.fullscreenButtonShowToolTipHandler = function(e){
            _s.showToolTip(_s.fullScreenButton_do, _s.fullscreenButtonToolTip_do, e.e);
        };
        
        _s.showFullScreenButton = function(){
            if(!_s.fullScreenButton_do) return;
            _s.fullScreenButton_do.setButtonState(1);
        };
        
        _s.showNormalScreenButton = function(){
            if(!_s.fullScreenButton_do) return;
            _s.fullScreenButton_do.setButtonState(0);
        };
        
        _s.setNormalStateToFullScreenButton = function(){
            if(!_s.fullScreenButton_do) return;
            _s.fullScreenButton_do.setNormalState(true);
            _s.hideQualityButtons(false);
        };
        
        _s.fullScreenButtonMouseUpHandler = function(){
            if(_s.fullscreenButtonToolTip_do) _s.fullscreenButtonToolTip_do.hide();
            if(_s.fullScreenButton_do.currentState == 1){
                _s.dispatchEvent(FWDUVPController.FULL_SCREEN);
            }else{
                _s.dispatchEvent(FWDUVPController.NORMAL_SCREEN);
            }
        };

        
        //########################################//
        /* Setup time*/
        //########################################//
        _s.setupTime = function(){
            _s.time_do = new FWDUVPDisplayObject("div");
            _s.time_do.screen.className = 'fwduvp-time';
            _s.time_do.hasTransform3d_bl = false;
            _s.time_do.hasTransform2d_bl = false;
            _s.time_do.setBackfaceVisibility();
            _s.time_do.getStyle().fontFamily = "Arial";
            _s.time_do.getStyle().fontSize= "12px";
            _s.time_do.getStyle().whiteSpace= "nowrap";
            _s.time_do.getStyle().textAlign = "center";
            _s.time_do.getStyle().color = _s.timeColor_str;
            _s.time_do.getStyle().fontSmoothing = "antialiased";
            _s.time_do.getStyle().webkitFontSmoothing = "antialiased";
            _s.time_do.getStyle().textRendering = "optimizeLegibility"; 
            _s.mainHld.addChild(_s.time_do);
            _s.updateTime("00:00/00:00");
            _s.buttons_ar.push(_s.time_do);
        };
        
        _s.updateTime = function(time){
            if(!_s.time_do) return;
            if(_s.isLive) time = time.substr(0, time.indexOf("/"));
            _s.time_do.setInnerHTML(time);
            
            if(_s.lastTimeLength != time.length){
                _s.time_do.w = _s.time_do.getWidth();
                _s.positionButtons();
                
                setTimeout(function(){
                    _s.time_do.w = _s.time_do.getWidth();
                    _s.time_do.h = _s.time_do.getHeight();
                    _s.time_do.setY(parseInt((_s.sH - _s.time_do.h)/2) + 1 + _s.timeOffsetTop);
                    _s.positionButtons();
                }, 50);
                _s.lastTimeLength = time.length;
            }
        };

        
        //##########################################//
        /* Setup facebook button */
        //##########################################//
        _s.setupRewindButton = function(){
            
            if(_s.useVectorIcons_bl){               
                FWDUVPSimpleButton.setPrototype();
                _s.rewindButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-10'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.rewindButton_do = new FWDUVPSimpleButton(
                        _d.rewindN_img,
                        _d.rewindSPath_str,
                        undefined,
                        true,
                        _s.useHEX,
                        _s.nBC,
                        _s.sBC
                );
            }
            
            _s.rewindButton_do.screen.className = 'fwduvp-rewind-button';
            _s.buttons_ar.push(_s.rewindButton_do);
            _s.rewindButton_do.setY(parseInt((_s.sH - _s.rewindButton_do.h)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.rewindButton_do.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.rewindButton_do.setY(parseInt((_s.sH - _s.rewindButton_do.buttonHeight)/2));
                }
            }, 50);
            _s.rewindButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.rewindButtonMouseUpHandler);
            _s.mainHld.addChild(_s.rewindButton_do);
        };
    
        _s.rewindButtonMouseUpHandler = function(){
            _s.dispatchEvent(FWDUVPController.REWIND);
        };
        
        _s.disableRewindButton = function(){
            if(_s.rewindButton_do) _s.rewindButton_do.disable();
        }
        
        _s.enableRewindButton = function(){
            if(_s.rewindButton_do) _s.rewindButton_do.enable();
        }
        

        //##########################################//
        /* Setup volume button */
        //#########################################//
        _s.setupVolumeButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPVolumeButton.setPrototype();
                _s.volBtn = new FWDUVPVolumeButton(undefined, undefined, undefined, undefined, undefined, undefined,
                    "<span class='fwdicon fwdicon-sound'></span>",
                    "<span class='fwdicon fwdicon-sound-off'></span>",
                    "UVPMainButtonsNormalState volume",
                    "UVPMainButtonsSelectedState volume"
                );
            }else{
                FWDUVPVolumeButton.setPrototype();
                _s.volBtn = new FWDUVPVolumeButton(_s.volumeN_img, _d.volumeSPath_str, _d.volumeDPath_str, _s.useHEX,
                        _s.nBC,
                        _s.sBC);
            }
            _s.volBtn.addListener(FWDUVPVolumeButton.SHOW_TOOLTIP, _s.volumeButtonShowTooltipHandler);
            _s.volBtn.addListener(FWDUVPVolumeButton.MOUSE_OVER, _s.volumeOnMouseOverHandler);;
            _s.volBtn.addListener(FWDUVPVolumeButton.MOUSE_UP, _s.volumeOnMouseUpHandler);
            _s.volBtn.setY(parseInt((_s.sH - _s.volBtn.h)/2));
            var checkIconInterval = setInterval(function(){
                if(_s.volBtn.buttonHeight > 0){
                    clearInterval(checkIconInterval);
                    _s.volBtn.setY(parseInt((_s.sH - _s.volBtn.buttonHeight)/2));
                }
            }, 50);
            _s.buttons_ar.push(_s.volBtn);
            _s.mainHld.addChild(_s.volBtn); 
            if(_s.volume == 0) _s.volBtn.setDisabledState();
        };
        
        _s.volumeButtonShowTooltipHandler = function(e){};
        
        _s.hideMainScrubberTop = function(){
            if(_s.isMainScrubberOnTop_bl){
                FWDAnimation.to(_s.mainScrubber_do, .4, {alpha:0, onComplete:function(){_s.mainScrubber_do.setX(-5000);}});
            }
        }
        
        _s.showMainScrubberOnTop = function(){
            if(_s.isMainScrubberOnTop_bl){
                _s.mainScrubber_do.setX(0);
                FWDAnimation.to(_s.mainScrubber_do, .6, {alpha:1});
            }
        }
        
        _s.volumeOnMouseOverHandler = function(){
            _s.showVolumeScrubber(true);
            _s.hideQualityButtons(true);
            _s.hideSubtitleButtons(true);
            _s.hideATBButtons(true);
            _s.hidePlaybackRateButtons(true);
            _s.hideMainScrubberTop();
        };
        
        _s.volumeOnMouseUpHandler = function(){
            var vol = _s.lastVolume;
            if(_s.isMbl){
                if(!_s.isVolumeScrubberShowed_bl){
                    _s.volumeOnMouseOverHandler();
                }
                return;
            }

            if(_s.muted){
                vol = _s.lastVolume;
                _s.muted = false;
            }else{
                vol = 0.000001;
                _s.muted = true;
            };
            _s.updateVolume(vol);
        };
        

        //################################################//
        /* Setup volume scrubber */
        //################################################//
        _s.setupVolumeScrubber = function(){
            
            //setup background bar
            _s.volumeScrubberHolder_do = new FWDUVPDisplayObject("div");
            
            if(_s.repeatBackground_bl){
                _s.volumeBk_do = new FWDUVPDisplayObject("div");
                _s.volumeBk_do.getStyle().background = "url('" + _s.controllerBkPath_str +  "')";
            }else{
                _s.volumeBk_do = new FWDUVPDisplayObject("img");
                var volumeBk_img = new Image();
                volumeBk_img.src = _s.controllerBkPath_str;
                _s.volumeBk_do.setScreen(volumeBk_img);
            }
            _s.volumeScrubberHolder_do.addChild(_s.volumeBk_do);

            _s.volumeScrubber_do = new FWDUVPDisplayObject("div");
            _s.volumeScrubber_do.setHeight(_s.mainScrbH);
            _s.volumeScrubber_do.setY(parseInt(_s.volumeScrubberOfsetHeight/2));
            
            var volumeScrubberBkBottom_img = new Image();
            volumeScrubberBkBottom_img.src = _d.volumeScrubberBkBottomPath_str;
            _s.volumeScrubberBkBottom_do = new FWDUVPDisplayObject("img");
            _s.volumeScrubberBkBottom_do.setScreen(volumeScrubberBkBottom_img);
            _s.volumeScrubberBkBottom_do.setWidth(_s.mainScrubberBkLeft_img.height);
            _s.volumeScrubberBkBottom_do.setHeight(_s.mainScrubberBkLeft_img.width);
            _s.volumeScrubberBkBottom_do.setY(_s.volumeScrubberHeight - _s.volumeScrubberOfsetHeight - _s.volumeScrubberBkBottom_do.h);
        
            var volumeScrubberBkTop_img = new Image();
            volumeScrubberBkTop_img.src = _d.volumeScrubberBkTopPath_str;
            _s.volumeScrubberBkTop_do = new FWDUVPDisplayObject("img");
            
            _s.volumeScrubberBkTop_do.setScreen(volumeScrubberBkTop_img);
            _s.volumeScrubberBkTop_do.setWidth(_s.volumeScrubberBkBottom_do.w);
            _s.volumeScrubberBkTop_do.setHeight(_s.volumeScrubberBkBottom_do.h);
            
            var middleImage = new Image();
            middleImage.src = _d.volumeScrubberBkMiddlePath_str;
            
            if(_s.isMbl){
                _s.volumeScrubberBkMiddle_do = new FWDUVPDisplayObject("div");  
                _s.volumeScrubberBkMiddle_do.getStyle().background = "url('" + _s.volumeScrubberBkMiddlePath_str + "') repeat-y";
            }else{
                _s.volumeScrubberBkMiddle_do = new FWDUVPDisplayObject("img");
                _s.volumeScrubberBkMiddle_do.setScreen(middleImage);
            }
            
            _s.volumeScrubberBkMiddle_do.setWidth(_s.volumeScrubberBkBottom_do.w);
            _s.volumeScrubberBkMiddle_do.setHeight((_s.volumeScrubberHeight - _s.volumeScrubberOfsetHeight) - _s.volumeScrubberBkTop_do.h * 2);
            _s.volumeScrubberBkMiddle_do.setY(_s.volumeScrubberBkTop_do.h);
            
            //setup darg bar.
            _s.volumeScrubberDrag_do = new FWDUVPDisplayObject("div");
            _s.volumeScrubberDrag_do.setWidth(_s.volumeScrubberBkBottom_do.w);
            
            if(_s.useHEX){
                _s.volumeScrubberDragBottom_do = new FWDUVPDisplayObject("div");
                _s.volumeScrubberDragBottom_do.setWidth(_s.volumeScrubberDragBottom_img.width);
                _s.volumeScrubberDragBottom_do.setHeight(_s.volumeScrubberDragBottom_img.height);
                _s.volumeScrubberDragBottom_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.volumeScrubberDragBottom_img, _s.nBC).canvas;
                _s.volumeScrubberDragBottom_do.screen.appendChild(_s.volumeScrubberDragBottom_canvas);  
            }else{
                _s.volumeScrubberDragBottom_do = new FWDUVPDisplayObject("img");
                _s.volumeScrubberDragBottom_do.setScreen(_s.volumeScrubberDragBottom_img);
            }
        
            _s.volumeScrubberDragBottom_do.setWidth(_s.mainScrubberDragLeft_img.height);
            _s.volumeScrubberDragBottom_do.setHeight(_s.mainScrubberDragLeft_img.width);
            _s.volumeScrubberDragBottom_do.setY(_s.volumeScrubberHeight - _s.volumeScrubberOfsetHeight - _s.volumeScrubberDragBottom_do.h);
            
            
            _s.middleImage = new Image();
            _s.middleImage.src = _s.volumeScrubberDragMiddlePath_str;
            
            if(_s.useHEX){
                _s.volumeScrubberDragMiddle_do = new FWDUVPDisplayObject("div");
                _s.middleImage.onload = function(){
                    _s.volumeScrubberDragMiddle_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.middleImage, _s.nBC, true);
                    _s.volumeScrubberDragImage_img = _s.volumeScrubberDragMiddle_canvas.image;
                    _s.volumeScrubberDragMiddle_do.getStyle().background = "url('" + _s.volumeScrubberDragImage_img.src + "') repeat-y";
                }
            }else{
                _s.volumeScrubberDragMiddle_do = new FWDUVPDisplayObject("img");
                _s.volumeScrubberDragMiddle_do.setScreen(_s.middleImage);
            }
            
            _s.volumeScrubberDragMiddle_do.setWidth(_s.volumeScrubberDragBottom_do.w);
            _s.volumeScrubberDragMiddle_do.setHeight(_s.volumeScrubberHeight);
            
            var volumeScrubberBarLine_img = new Image();
            volumeScrubberBarLine_img.src = _d.volumeScrubberLinePath_str;
            _s.volumeScrubberBarLine_do = new FWDUVPDisplayObject("img");
            _s.volumeScrubberBarLine_do.setScreen(volumeScrubberBarLine_img);
            _s.volumeScrubberBarLine_do.setWidth(_s.mainScrubberLine_img.height);
            _s.volumeScrubberBarLine_do.setHeight(_s.mainScrubberLine_img.width);
            _s.volumeScrubberBarLine_do.setAlpha(0);
            _s.volumeScrubberBarLine_do.hasTransform3d_bl = false;
            _s.volumeScrubberBarLine_do.hasTransform2d_bl = false;
            _s.volumeScrubberHolder_do.setWidth(_s.volScrbW);
            _s.volumeScrubberHolder_do.setHeight(_s.volumeScrubberHeight + _s.sH);
            _s.volumeBk_do.setWidth(_s.volScrbW);
            _s.volumeBk_do.setHeight(_s.volumeScrubberHeight + _s.sH);
            _s.volumeScrubber_do.setWidth(_s.volScrbW);
            _s.volumeScrubber_do.setHeight(_s.volumeScrubberHeight - _s.volumeScrubberOfsetHeight);
            
            //add all children
            _s.volumeScrubber_do.addChild(_s.volumeScrubberBkBottom_do);
            _s.volumeScrubber_do.addChild(_s.volumeScrubberBkMiddle_do);
            _s.volumeScrubber_do.addChild(_s.volumeScrubberBkTop_do);
            _s.volumeScrubber_do.addChild(_s.volumeScrubberBarLine_do);
            _s.volumeScrubber_do.addChild(_s.volumeScrubberDragBottom_do);
            _s.volumeScrubberDrag_do.addChild(_s.volumeScrubberDragMiddle_do);
            _s.volumeScrubber_do.addChild(_s.volumeScrubberDrag_do);
            _s.volumeScrubber_do.addChild(_s.volumeScrubberBarLine_do);
            _s.volumeScrubberHolder_do.addChild(_s.volumeScrubber_do);
        
            _s.addChild(_s.volumeScrubberHolder_do);
            
            if(_s.isMbl){
                if(_s.hasPointerEvent_bl){
                    _s.volumeScrubber_do.screen.addEventListener("pointerover", _s.volumeScrubberOnOverHandler);
                    _s.volumeScrubber_do.screen.addEventListener("pointerout", _s.volumeScrubberOnOutHandler);
                    _s.volumeScrubber_do.screen.addEventListener("pointerdown", _s.volumeScrubberOnDownHandler);
                }else{
                    _s.volumeScrubber_do.screen.addEventListener("touchstart", _s.volumeScrubberOnDownHandler);
                }
            }else if(_s.screen.addEventListener){   
                _s.volumeScrubber_do.screen.addEventListener("mouseover", _s.volumeScrubberOnOverHandler);
                _s.volumeScrubber_do.screen.addEventListener("mouseout", _s.volumeScrubberOnOutHandler);
                _s.volumeScrubber_do.screen.addEventListener("mousedown", _s.volumeScrubberOnDownHandler);
            }
            
            _s.enableVolumeScrubber();
            _s.updateVolumeScrubber(_s.volume);
        };
        
        _s.volumeScrubberOnOverHandler =  function(e){
            if(_s.isVolumeScrubberDisabled_bl) return;
        };
        
        _s.volumeScrubberOnOutHandler =  function(e){
            if(_s.isVolumeScrubberDisabled_bl) return;
        };
        
        _s.volumeScrubberOnDownHandler =  function(e){
            if(_s.isVolumeScrubberDisabled_bl || e.button == 2) return;
            if(e.preventDefault) e.preventDefault();
            _s.volumeScrubberIsDragging_bl = true;
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            var localY = vc.screenY - _s.volumeScrubber_do.getGlobalY();
            prt.showDisable();
            if(localY < 0){
                localY = 0;
            }else if(localY > _s.volumeScrubber_do.h - _s.scrubbersOffsetWidth){
                localY = _s.volumeScrubber_do.h - _s.scrubbersOffsetWidth;
            }
            var percentScrubbed = 1 - localY/_s.volumeScrubber_do.h;

            _s.lastVolume = percentScrubbed;
            _s.updateVolume(percentScrubbed);
            
            if(_s.isMbl){
                if(_s.hasPointerEvent_bl){
                    window.addEventListener("MSPointerMove", _s.volumeScrubberMoveHandler);
                    window.addEventListener("pointerup", _s.volumeScrubberEndHandler);
                }else{
                    window.addEventListener("touchmove", _s.volumeScrubberMoveHandler, {passive:false});
                    window.addEventListener("touchend", _s.volumeScrubberEndHandler);
                }
            }else{
                window.addEventListener("mousemove", _s.volumeScrubberMoveHandler);
                window.addEventListener("mouseup", _s.volumeScrubberEndHandler);        
            }
        };
        
        _s.volumeScrubberMoveHandler = function(e){
            if(_s.isVolumeScrubberDisabled_bl) return;
            if(e.preventDefault) e.preventDefault();
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            var localY = vc.screenY - _s.volumeScrubber_do.getGlobalY();
            
            if(localY < _s.scrubbersOffsetWidth){
                localY = _s.scrubbersOffsetWidth;
            }else if(localY > _s.volumeScrubber_do.h){
                localY = _s.volumeScrubber_do.h;
            }
            var percentScrubbed = 1 - localY/_s.volumeScrubber_do.h;
        
            _s.lastVolume = percentScrubbed;
            _s.updateVolume(percentScrubbed);
        };
        
        _s.volumeScrubberEndHandler = function(){
            prt.hideDisable();
            _s.volumeScrubberIsDragging_bl = false;
            if(_s.isMbl){
                if(_s.hasPointerEvent_bl){
                    window.removeEventListener("MSPointerMove", _s.volumeScrubberMoveHandler);
                    window.removeEventListener("pointerup", _s.volumeScrubberEndHandler);
                }else{
                    window.removeEventListener("touchmove", _s.volumeScrubberMoveHandler);
                    window.removeEventListener("touchend", _s.volumeScrubberEndHandler);
                }
            }else{
                window.removeEventListener("mousemove", _s.volumeScrubberMoveHandler);
                window.removeEventListener("mouseup", _s.volumeScrubberEndHandler);     
            }
        };
        
        _s.disableVolumeScrubber = function(){
            _s.isVolumeScrubberDisabled_bl = true;
            _s.volumeScrubber_do.setButtonMode(false);
            _s.volumeScrubberEndHandler();
        };
        
        _s.enableVolumeScrubber = function(){
            _s.isVolumeScrubberDisabled_bl = false;
            _s.volumeScrubber_do.setButtonMode(true);
        };
        
        _s.updateVolumeScrubber = function(percent){
            var totalHeight = _s.volumeScrubberHeight - _s.volumeScrubberOfsetHeight;
            var finalHeight = Math.round(percent * totalHeight); 
            
            _s.volumeScrubberDrag_do.setHeight(Math.max(0,finalHeight - _s.volumeScrubberDragBottom_do.h));
            _s.volumeScrubberDrag_do.setY(totalHeight - finalHeight);
        
            if(finalHeight < 1 && _s.isVolumeScrubberLineVisible_bl){
                _s.isVolumeScrubberLineVisible_bl = false;
                FWDAnimation.to(_s.volumeScrubberBarLine_do, .5, {alpha:0});
                FWDAnimation.to(_s.volumeScrubberDragBottom_do, .5, {alpha:0});
            }else if(finalHeight > 1 && !_s.isVolumeScrubberLineVisible_bl){
                _s.isVolumeScrubberLineVisible_bl = true;
                FWDAnimation.to(_s.volumeScrubberBarLine_do, .5, {alpha:1});
                FWDAnimation.to(_s.volumeScrubberDragBottom_do, .5, {alpha:1});
            }
            
            if(finalHeight > totalHeight) finalHeight = totalHeight;
            
            FWDAnimation.to(_s.volumeScrubberBarLine_do, .8, {y:totalHeight - finalHeight - 2, ease:Expo.easeOut});
        };
        
        _s.updateVolume = function(volume, preventEvent){
            if(!_s.showVolumeScrubber_bl) return;
            _s.volume = volume;
            if(_s.volume <= 0.000001){
                _s.muted = true;
                _s.volume = 0;
            }else if(_s.voume >= 1){
                _s.muted = false;
                _s.volume = 1;
                prt.removeAPT();
            }else{
                _s.muted = false;
                prt.removeAPT();
            }
            
            if(_s.volume == 0){
                if(_s.volBtn) _s.volBtn.setDisabledState();
            }else{
                if(_s.volBtn) _s.volBtn.setEnabledState();
            }
            
            if(_s.volumeScrubberBarLine_do) _s.updateVolumeScrubber(_s.volume);
            if(!preventEvent) _s.dispatchEvent(FWDUVPController.CHANGE_VOLUME, {percent:_s.volume});
        };
        
        _s.showVolumeScrubber = function(animate){
            if(_s.isVolumeScrubberShowed_bl) return;
            _s.isVolumeScrubberShowed_bl = true;
            var finalY = - _s.volumeScrubberHolder_do.h + _s.h;
            _s.volumeScrubberHolder_do.setVisible(true);
            
            if(_s.isMbl){
                setTimeout(function(){
                    window.addEventListener("touchstart", _s.hideVolumeSchubberOnMoveHandler);
                },50);
            }else{
                window.addEventListener("mousemove", _s.hideVolumeSchubberOnMoveHandler);
            }
            
            _s.volumeScrubberHolder_do.setX(parseInt(_s.volBtn.x + (_s.volBtn.w - _s.volumeScrubberHolder_do.w)/2));
            
            if(animate){
                FWDAnimation.to(_s.volumeScrubberHolder_do, .6, {y:finalY, ease:Expo.easeInOut});
            }else{
                FWDAnimation.killTweensOf(_s.volumeScrubberHolder_do);
                _s.volumeScrubberHolder_do.setY(finalY);
            }
        };
        
        _s.hideVolumeSchubberOnMoveHandler = function(e){
            
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            
            if((FWDUVPUtils.hitTest(_s.volumeScrubberHolder_do.screen, vc.screenX, vc.screenY)
               || FWDUVPUtils.hitTest(_s.volBtn.screen, vc.screenX, vc.screenY)
             ) && !_s.isMbl){
                return;
            }
            
            if(FWDUVPUtils.hitTest(_s.volumeScrubber_do.screen, vc.screenX, vc.screenY) && _s.isMbl){
                return;
            }
            
            if(_s.volumeScrubberIsDragging_bl) return;
        
            _s.hideVolumeScrubber(true);
            if(_s.isMainScrubberOnTop_bl){
                _s.mainScrubber_do.setX(0);
                FWDAnimation.to(_s.mainScrubber_do, .6, {alpha:1});
            }
        };
    
        _s.hideVolumeScrubber = function(animate){
            if(!_s.isVolumeScrubberShowed_bl) return;
            _s.isVolumeScrubberShowed_bl = false;
            
            _s.volBtn.setNormalState(true);
            if(animate){
                FWDAnimation.to(_s.volumeScrubberHolder_do, .6, {y:prt.sH, ease:Expo.easeInOut, onComplete:function(){_s.volumeScrubberHolder_do.setVisible(false);}});
            }else{
                FWDAnimation.killTweensOf(_s.ytbButtonsHolder_do);
                _s.volumeScrubberHolder_do.setY(prt.sH);
                _s.volumeScrubberHolder_do.setVisible(false);
            }
            
            if(_s.isMbl){
                window.removeEventListener("touchstart", _s.hideVolumeSchubberOnMoveHandler);
            }else{
                window.removeEventListener("mousemove", _s.hideVolumeSchubberOnMoveHandler);
            }
        };

        
        //###################################//
        /* show / hide */
        //###################################//
        _s.show = function(animate){
            if(_s.isShowed_bl) return;
            _s.isShowed_bl = true;

            _s.setX(0);
            if(animate){
                FWDAnimation.to(_s.mainHld, .8, {y:0, ease:Expo.easeInOut});
            }else{
                FWDAnimation.killTweensOf(_s.mainHld);
                _s.mainHld.setY(0);
            }

            _s.disableCtrl_to = setTimeout(function(){
                _s.positionButtons();
                _s.getStyle().pointerEvents = 'auto';
            }, 200);

        };
        
        _s.hide = function(animate, offset){

            if(!_s.isShowed_bl) return;
            if(!offset) offset = 0;
            if(_s.atb && _s.atb.isShowed_bl) offset += _s.h + 1;
            if(_s.isMainScrubberOnTop_bl  && _s.atb && _s.atb.isShowed_bl) offset += _s.mainScrubberOffestTop;
            if(!_d.showScrubberWhenControllerIsHidden_bl) offset +=_s.mainScrubber_do.h - 14;
            _s.isShowed_bl = false;
            clearTimeout(_s.disableCtrl_to);
            _s.getStyle().pointerEvents = 'none';
            
            if(animate){
                FWDAnimation.to(_s.mainHld, .8, {y:_s.sH + offset, ease:Expo.easeInOut});
            }else{
                FWDAnimation.killTweensOf(_s.mainHld);
                _s.mainHld.setY(_s.sH + offset);
            }

            _s.hideQualityButtons(true);
            _s.hideSubtitleButtons(true);
            _s.hideATBButtons(true);
            _s.hidePlaybackRateButtons(true);
        };
        
        _s.mainScrubberDragMiddleAddPath_str = _d.mainScrubberDragMiddleAddPath_str;
        _s.updateHexColorForScrubber = function(isAdd){
            if(isAdd){
                _s.mainScrubberDragMiddle_do.getStyle().background = "url('" + _s.mainScrubberDragMiddleAddPath_str + "') repeat-x";
                _s.mainScrubberDragLeft_do.screen.src = _d.mainScrubberDragLeftAddPath_str;
            }else{
                if(_s.useHEX && _s.mainSCrubberMiddleCanvas){
                    var newCenterImage = FWDUVPUtils.changeCanvasHEXColor(_s.mainScrubberMiddleImage, _s.mainSCrubberMiddleCanvas, _s.nBC, true);
                    _s.mainScrubberDragMiddle_do.getStyle().background = "url('" + newCenterImage.src + "') repeat-x";
                }else{
                    _s.mainScrubberDragMiddle_do.getStyle().background = "url('" + _s.mainScrubberDragMiddlePath_str + "') repeat-x";
                    _s.mainScrubberDragLeft_do.screen.src = _s.mainScrubberDragLeftSource;
                }
            }
        }

        _s.updateHEXColors = function(nBC, sBC){
            _s.nBC = nBC;
            _s.sBC = sBC;
        }
    
        _s.init();
    };

    
    /* set prototype */
    FWDUVPController.setPrototype = function(){
        FWDUVPController.prototype = new FWDUVPDisplayObject("div");
    };
    

    FWDUVPController.VR = 'vr';
    FWDUVPController.UNCAST = 'uncast';
    FWDUVPController.CAST = 'cast'; 
    FWDUVPController.SHOW_SHARE_WINDOW = "showShareWindow";
    FWDUVPController.SHOW_SUBTITLE = "showSubtitle";
    FWDUVPController.HIDE_SUBTITLE = "hideSubtitle";
    FWDUVPController.SHOW_PLAYLIST = "showPlaylist";
    FWDUVPController.HIDE_PLAYLIST = "hidePlaylist";
    FWDUVPController.SHOW_CATEGORIES = "showCategories";
    FWDUVPController.DOWNLOAD_VIDEO = "downloadVideo";
    FWDUVPController.UNCAST = 'uncast';
    FWDUVPController.REWIND = "rewind";
    FWDUVPController.FULL_SCREEN = "fullScreen";
    FWDUVPController.NORMAL_SCREEN = "normalScreen";
    FWDUVPController.PLAY = "play";
    FWDUVPController.PAUSE = "pause";
    FWDUVPController.START_TO_SCRUB = "startToScrub";
    FWDUVPController.SCRUB = "scrub";
    FWDUVPController.STOP_TO_SCRUB = "stopToScrub";
    FWDUVPController.CHANGE_VOLUME = "changeVolume";
    FWDUVPController.CHANGE_YOUTUBE_QUALITY = "changeYoutubeQuality";
    FWDUVPController.SHOW_EMBED_WINDOW = "showEmbedWindow";
    FWDUVPController.SHOW_INFO_WINDOW = "showInfoWindow";
    FWDUVPController.CHANGE_SUBTITLE = "changeSubtitle";
    FWDUVPController.CHANGE_PLAYBACK_RATES = "changePlaybackRate";
    FWDUVPController.CHANGE_AUDIO_TRACKS = 'changeAudioTracks';
    
    FWDUVPController.prototype = null;
    window.FWDUVPController = FWDUVPController;
    
}());/**
 * Easy Video Player PACKAGED v8.4
 * Data.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function(window){
    
    var FWDUVPData = function(props, playListElement, prt){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPData.prototype;

        _s.props = props;
        _s.skinPaths_ar = [];
        _s.images_ar = [];
        _s.cats_ar = [];
        _s.catsRef_ar = [];
    
        _s.controllerHeight = 0;
        _s.countLoadedSkinImages = 0;
        _s.volume = 1;
        _s.controllerHideDelay = 0;
        _s.startSpaceBetweenButtons = 0;
        _s.spaceBetweenButtons = 0;
        _s.scrubbersOffsetWidth = 0;
        _s.volumeScrubberOffsetTopWidth = 0;
        _s.timeOffsetLeftWidth = 0;
        _s.timeOffsetTop = 0;
        _s.logoMargins = 0;
        _s.startAtPlaylist = 0;
        _s.startAtVideo = 0;
        _s.playlistBottomHeight = 0;
        _s.maxPlaylistItems = 0;
        _s.totalPlaylists = 0;
        _s.thumbnailMaxWidth = 0; 
        _s.buttonsMargins = 0;
        _s.nextAndPrevSetButtonsMargins = 0;
        _s.thumbnailMaxHeight = 0;
        _s.horizontalSpaceBetweenThumbnails = 0;
        _s.verticalSpaceBetweenThumbnails = 0;
        _s.buttonsToolTipHideDelay = 0;
        _s.thumbnailWidth = 0;
        _s.thumbnailHeight = 0;
        _s.timeOffsetTop = 0;
        _s.embedWindowCloseButtonMargins = 0;
        _s.plsCache_ar = [];
        
        _s.isMbl = FWDUVPUtils.isMobile;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
    

        //###################################//
        /*init*/
        //###################################//
        _s.init = function(){
            _s.parseProperties();
        };
        

        //#############################################//
        // parse properties.
        //#############################################//
        _s.parseProperties = function(){
            
            _s.useHEX = _s.props.useHEXColorsForSkin; 
            _s.useHEX = _s.useHEX == "yes" ? true : false;
            if(location.protocol.indexOf("file:") != -1) _s.useHEX = false;
            
            _s.categoriesId_str = _s.props.playlistsId;
            if(!_s.categoriesId_str){
                setTimeout(function(){
                    if(_s == null) return;
                    var errorMessage_str = "The <font color='#ff0000'>playlistsId</font> property is not defined in the constructor function!";
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:errorMessage_str});
                }, 50);
                return;
            }
                
            _s.mainFolderPath_str = _s.props.mainFolderPath;
            if(!_s.mainFolderPath_str){
                setTimeout(function(){
                    if(_s == null) return;
                    var errorMessage_str = "The <font color='#ff0000'>mainFolderPath</font> property is not defined in the constructor function!";
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:errorMessage_str});
                }, 50);
                return;
            }
            
            if((_s.mainFolderPath_str.lastIndexOf("/") + 1) != _s.mainFolderPath_str.length){
                _s.mainFolderPath_str += "/";
            }
            
            _s.sknPth = _s.props.skinPath;
            if(!_s.sknPth){
                setTimeout(function(){
                    if(_s == null) return;
                    var errorMessage_str = "The <font color='#ff0000'>skinPath</font> property is not defined in the constructor function!";
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:errorMessage_str});
                }, 50);
                return;
            }
            
            if((_s.sknPth.lastIndexOf("/") + 1) != _s.sknPth.length){
                _s.sknPth += "/";
            }
        
            _s.sknPth = _s.mainFolderPath_str + _s.sknPth;
            _s.flashPath_str = _s.mainFolderPath_str + "flashlsChromeless.swf";
            _s.flashCopyToCBPath_str = _s.mainFolderPath_str + "cb.swf";
            _s.proxyPath_str =  _s.mainFolderPath_str + "proxy.php";
            _s.proxyFolderPath_str = _s.mainFolderPath_str  + "proxyFolder.php";
            _s.mailPath_str = _s.mainFolderPath_str  + "sendMail.php";
            _s.sendToAFriendPath_str = _s.mainFolderPath_str  + "sendMailToAFriend.php";
            _s.videoDownloaderPath_str = _s.mainFolderPath_str  + "downloader.php";
            
            _s.handPath_str = _s.sknPth + "hand.cur";
            _s.grabPath_str = _s.sknPth + "grab.cur";
            if(_s.sknPth.indexOf('white') != -1){
                _s.isWhite = true;
            }
            
            _s.categories_el = document.getElementById(_s.categoriesId_str);
            
            if(!_s.categories_el){
                setTimeout(function(){
                    if(_s == null) return;
                    var errorMessage_str = "The playlist with the id <font color='#ff0000'>" + _s.categoriesId_str + "</font> is not found!";
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:errorMessage_str});
                }, 50);
                return;
            }
            
            var catsChildren_ar = FWDUVPUtils.getChildren(_s.categories_el);
            _s.totalCats = catsChildren_ar.length;  
            
            if(_s.totalCats == 0){
                setTimeout(function(){
                    if(_s == null) return;
                    var errorMessage_str = "At least one playlist is required!";
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:errorMessage_str});
                }, 50);
                return;
            }
            
            
            for(var i=0; i<_s.totalCats; i++){
                var obj = {};
                
                var cat_el = null;
                var child = catsChildren_ar[i];
                
                if(!FWDUVPUtils.hasAttribute(child, "data-source")){
                    setTimeout(function(){
                        if(_s == null) return;
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Attribute <font color='#ff0000'>data-source</font> is required in the plalists html element at position <font color='#ff0000'>" + (i + 1)});
                    }, 50);
                    return;
                }
                
                if(!FWDUVPUtils.hasAttribute(child, "data-thumbnail-path")){
                    setTimeout(function(){
                        if(_s == null) return;
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Attribute <font color='#ff0000'>data-thumbnail-path</font> is required in the playlists html element at position <font color='#ff0000'>" + (i + 1)});
                    }, 50);
                    return;
                }
                
                obj.source = FWDUVPUtils.getAttributeValue(child, "data-source");
                if(obj.source.indexOf("=") == -1 && obj.source.indexOf(".xml") == -1 && obj.source.indexOf("vimeo.com") == -1 && obj.source.indexOf("youtube.") == -1){
                    cat_el = document.getElementById(obj.source);
                }else{
                    cat_el = obj.source;
                }

                _s.catsRef_ar.push(cat_el);
                
                obj.thumbnailPath = FWDUVPUtils.getAttributeValue(child, "data-thumbnail-path");
            
                obj.htmlContent = child.innerHTML;
                obj.htmlText_str = child.innerText;
                obj.vimeoUserId = FWDUVPUtils.getAttributeValue(child, "data-user-id");
                
                obj.clientId = FWDUVPUtils.getAttributeValue(child, "data-client-id");
                obj.vimeoSecret = FWDUVPUtils.getAttributeValue(child, "data-vimeo-secret");
                obj.vimeoToken = FWDUVPUtils.getAttributeValue(child, "data-vimeo-token");

                if(FWDUVPUtils.hasAttribute(child, "data-playlist-name")){
                    obj.playlistName =  FWDUVPUtils.getAttributeValue(child, "data-playlist-name");
                }else{
                    obj.playlistName = "not defined!";
                };

                obj.pass =  FWDUVPUtils.getAttributeValue(child, "data-password");  

                _s.cats_ar[i] = obj;
            }
            
            for(var i=0; i<_s.totalCats; i++){
                var obj = {};
                var cat_el = null;
                child = catsChildren_ar[i]; 
                cat_el = document.getElementById(FWDUVPUtils.getAttributeValue(child, "data-source"));
            }
        
            _s.startAtPlaylist = _s.props.startAtPlaylist || 0;
            if(isNaN(_s.startAtPlaylist)) _s.startAtPlaylist = 0;
            if(_s.startAtPlaylist < 0){
                _s.startAtPlaylist = 0;
            }else if(_s.startAtPlaylist > _s.totalCats - 1){
                _s.startAtPlaylist = _s.totalCats - 1;
            }
            
            _s.playlistBottomHeight = _s.props.playlistBottomHeight || 0;
            _s.playlistBottomHeight = Math.min(800, _s.playlistBottomHeight);
            
            _s.subtitlesOffLabel_str = _s.props.subtitlesOffLabel || "Subtitle off";
        
            _s.videoSourcePath_str = _s.props.videoSourcePath || undefined;
            _s.timeColor_str = _s.props.timeColor || "#FF0000";
            
            _s.youtubeQualityButtonNormalColor_str = _s.props.youtubeQualityButtonNormalColor || "#FF0000";
            _s.youtubeQualityButtonSelectedColor_str = _s.props.youtubeQualityButtonSelectedColor || "#FF0000";
            _s.posterBackgroundColor_str = _s.props.posterBackgroundColor || "transparent";
        
            _s.showPlaylistButtonAndPlaylist_bl = _s.props.showPlaylistButtonAndPlaylist;
            _s.showPlaylistButtonAndPlaylist_bl = _s.showPlaylistButtonAndPlaylist_bl == "no" ? false : true;

            _s.showYoutubeRelAndInfo_bl = _s.props.showYoutubeRelAndInfo;
            _s.showYoutubeRelAndInfo_bl = _s.showYoutubeRelAndInfo_bl == "no" ? false : true;   

            _s.useResumeOnPlay_bl = _s.props.useResumeOnPlay;
            _s.useResumeOnPlay_bl = _s.useResumeOnPlay_bl == "yes" ? true : false;

            _s.useResumeOnPlay_bl = _s.props.useResumeOnPlay;
            _s.useResumeOnPlay_bl = _s.useResumeOnPlay_bl == "yes" ? true : false;

            _s.showOnlyThumbnail = _s.props.showOnlyThumbnail;
            _s.showOnlyThumbnail = _s.showOnlyThumbnail == "yes" ? true : false;

            _s.showThumbnail_bl = _s.props.showThumbnail;
            _s.showThumbnail_bl = _s.showThumbnail_bl == "no" ? false : true;
            if(_s.showOnlyThumbnail) _s.showThumbnail_bl = true;
    
            _s.showPlaylistOnFullScreen = _s.props.showPlaylistOnFullScreen;
            _s.showPlaylistOnFullScreen = _s.showPlaylistOnFullScreen == "yes" ? true : false;
            
            _s.stopAfterLastVideoHasPlayed_bl = _s.props.stopAfterLastVideoHasPlayed;
            _s.stopAfterLastVideoHasPlayed_bl = _s.stopAfterLastVideoHasPlayed_bl == "yes" ? true : false;
            
    
            _s.usePlaylistsSelectBox_bl = _s.props.usePlaylistsSelectBox;
            _s.usePlaylistsSelectBox_bl = _s.usePlaylistsSelectBox_bl == "yes" ? true : false;
            
            _s.executeCuepointsOnlyOnce_bl = _s.props.executeCuepointsOnlyOnce; 
            _s.executeCuepointsOnlyOnce_bl = _s.executeCuepointsOnlyOnce_bl == "yes" ? true : false;
            
            _s.showPlaylistByDefault_bl = _s.props.showPlaylistByDefault;
            _s.showPlaylistByDefault_bl = _s.showPlaylistByDefault_bl == "no" ? false : true;
        
            _s.playAfterVideoStop_bl = _s.props.playAfterVideoStop;
            _s.playAfterVideoStop_bl = _s.playAfterVideoStop_bl == "no" ? false : true;
            
            _s.openerAlignment_str = _s.props.openerAlignment;
            _s.openerEqulizerOffsetTop = _s.props.openerEqulizerOffsetTop || 0;
            _s.openerEqulizerOffsetLeft = _s.props.openerEqulizerOffsetLeft || 0;
            
            _s.showOpener_bl = _s.props.showOpener; 
            _s.showOpener_bl = _s.showOpener_bl == "yes" ? true : false;

            _s.stickyOnScrollShowOpener_bl = _s.props.stickyOnScrollShowOpener; 
            _s.stickyOnScrollShowOpener_bl = _s.stickyOnScrollShowOpener_bl == "yes" ? true : false;
            
            _s.showOpenerPlayPauseButton_bl = _s.props.showOpenerPlayPauseButton;
            _s.showOpenerPlayPauseButton_bl = _s.showOpenerPlayPauseButton_bl == "yes" ? true : false;
            
            _s.animate_bl = _s.props.animatePlayer; 
            _s.animate_bl = _s.animate_bl == "yes" ? true : false;
            
            _s.showChromecastButton_bl = _s.props.showChromecastButton; 
            _s.showChromecastButton_bl = _s.showChromecastButton_bl == "yes" ? true : false;
            if(!FWDUVPUtils.isChrome || FWDUVPUtils.isLocal || location.href.indexOf("https:") == -1) _s.showChromecastButton_bl = false;

            _s.show360DegreeVideoVrButton_bl = _s.props.show360DegreeVideoVrButton; 
            _s.show360DegreeVideoVrButton_bl = _s.show360DegreeVideoVrButton_bl == "yes" ? true : false;
        
            _s.showAnnotationsPositionTool_bl =  _s.props.showAnnotationsPositionTool;
            _s.showAnnotationsPositionTool_bl = _s.showAnnotationsPositionTool_bl == "yes" ? true : false;
            if(_s.showAnnotationsPositionTool_bl) _s.showPlaylistByDefault_bl = false;
            
            _s.showPlaylistName_bl = _s.props.showPlaylistName;
            _s.showPlaylistName_bl = _s.showPlaylistName_bl == "no" ? false : true;
            
            _s.showSearchInpt = _s.props.showSearchInput;
            _s.showSearchInpt = _s.showSearchInpt == "no" ? false : true;
            
            _s.showSubByDflt = _s.props.showSubtitleByDefault;
            _s.showSubByDflt = _s.showSubByDflt == "no" ? false : true;
                 
            _s.showSubBtn = _s.props.showSubtitleButton;
            _s.showSubBtn = _s.showSubBtn == "no" ? false : true;
            
            _s.forceDisableDownloadButtonForFolder_bl = _s.props.forceDisableDownloadButtonForFolder; 
            _s.forceDisableDownloadButtonForFolder_bl = _s.forceDisableDownloadButtonForFolder_bl == "yes" ? true : false;
            
            _s.nBC = _s.props.normalHEXButtonsColor || "#FFFFFF";

            if(_s.sknPth.indexOf('dark') != -1){
                _s.sBC = '#FFFFFF';
            }else{
                _s.sBC = '#000000';
            }

            _s.playlistPosition_str = _s.props.playlistPosition || "bottom";
            var test = _s.playlistPosition_str == "bottom" || _s.playlistPosition_str == "right";          
            if(!test) _s.playlistPosition_str = "right";        
            
            _s.folderVideoLabel_str = _s.props.folderVideoLabel || "Video ";
            
            _s.logoPosition_str = _s.props.logoPosition || "topleft";
            _s.logoPosition_str = String(_s.logoPosition_str).toLowerCase();
            test = _s.logoPosition_str == "topleft" 
                       || _s.logoPosition_str == "topright"
                       || _s.logoPosition_str == "bottomleft"
                       || _s.logoPosition_str == "bottomright"; 
            if(!test) _s.logoPosition_str = "topleft";
            
            _s.thumbnailSelectedType_str = _s.props.thumbnailSelectedType || "opacity";
            if(_s.thumbnailSelectedType_str != "blackAndWhite"  
                && _s.thumbnailSelectedType_str != "threshold" 
                && _s.thumbnailSelectedType_str != "opacity"){
                _s.thumbnailSelectedType_str = "opacity";
            }
            if(_s.isMbl || FWDUVPUtils.isIEAndLessThen9)  _s.thumbnailSelectedType_str = "opacity";
            if(document.location.protocol == "file:") _s.thumbnailSelectedType_str = "opacity";
            
            _s.adsButtonsPosition_str = _s.props.adsButtonsPosition || "left";
            _s.adsButtonsPosition_str = String(_s.adsButtonsPosition_str).toLowerCase();
            test = _s.adsButtonsPosition_str == "left" 
                       || _s.adsButtonsPosition_str == "right";
                           
            if(!test) _s.adsButtonsPosition_str = "left";
            
            _s.skipToVideoButtonText_str = _s.props.skipToVideoButtonText || "not defined";
            _s.skipToVideoText_str = _s.props.skipToVideoText;
            
            _s.adsTextNormalColor = _s.props.adsTextNormalColor || "#FF0000";
            _s.adsTextSelectedColor = _s.props.adsTextSelectedColor || "#FF0000";
            _s.adsBorderNormalColor_str = _s.props.adsBorderNormalColor || "#FF0000";
            _s.adsBorderSelectedColor_str = _s.props.adsBorderSelectedColor || "#FF0000";
                
            _s.volume = _s.props.volume;
            if(_s.volume == undefined || isNaN(_s.volume)) _s.volume = 1;
            
            if(_s.volume > 1){
                _s.volume = 1;
            }else if(_s.volume <=0){
                _s.volume = 0;
            }

            _s.rewTm = _s.props.rewindTime;
            if(_s.rewTm == undefined || isNaN(_s.rewTm)) _s.rewTm = 10;
            if(_s.rewTm <=1){
                _s.rewTm = 1;
            }
        
            _s.buttonsToolTipFontColor_str = _s.props.buttonsToolTipFontColor || "#FF0000";
            _s.toolTipsButtonFontColor_str = _s.props.toolTipsButtonFontColor || "#FF0000";
            _s.shareAndEmbedTextColor_str = _s.props.shareAndEmbedTextColor || "#FF0000";
            _s.inputBackgroundColor_str = _s.props.inputBackgroundColor || "#FF0000";
            _s.inputColor_str = _s.props.inputColor || "#FF0000";
            _s.searchInputBackgroundColor_str = _s.props.searchInputBackgroundColor || "#FF0000";
            _s.borderColor_str = _s.props.borderColor || "#FF0000";
            _s.searchInputColor_str = _s.props.searchInputColor || "#FF0000";
            _s.youtubeAndFolderVideoTitleColor_str = _s.props.youtubeAndFolderVideoTitleColor || "#FF0000";
            _s.folderAudioSecondTitleColor_str = _s.props.folderAudioSecondTitleColor || "#666666";
            _s.youtubeDescriptionColor_str = _s.props.youtubeDescriptionColor || "#FF0000"; 
            _s.youtubeOwnerColor_str = _s.props.youtubeOwnerColor || "#FF0000";
            _s.secondaryLabelsColor_str = _s.props.secondaryLabelsColor || "#FF0000"; 
            _s.mainLabelsColor_str = _s.props.mainLabelsColor || "#FF0000"; 
            _s.playlistBackgroundColor_str = _s.props.playlistBackgroundColor || "#FF0000"; 
            _s.thumbnailNormalBackgroundColor_str = _s.props.thumbnailNormalBackgroundColor || "#FF0000"; 
            _s.playlistNameColor_str = _s.props.playlistNameColor || "#FF0000"; 
            _s.thumbnailHoverBackgroundColor_str = _s.props.thumbnailHoverBackgroundColor || "#FF0000"; 
            _s.thumbnailDisabledBackgroundColor_str = _s.props.thumbnailDisabledBackgroundColor || "#FF0000"; 
            _s.mainSelectorBackgroundSelectedColor = _s.props.mainSelectorBackgroundSelectedColor || "#FFFFFF";
            _s.mainSelectorTextNormalColor = _s.props.mainSelectorTextNormalColor || "#FFFFFF";
            _s.mainSelectorTextSelectedColor = _s.props.mainSelectorTextSelectedColor || "#000000";
            _s.mainButtonBackgroundNormalColor = _s.props.mainButtonBackgroundNormalColor || "#212021";
            _s.mainButtonBackgroundSelectedColor = _s.props.mainButtonBackgroundSelectedColor || "#FFFFFF"; 
            _s.mainButtonTextNormalColor = _s.props.mainButtonTextNormalColor || "#FFFFFF";
            _s.mainButtonTextSelectedColor = _s.props.mainButtonTextSelectedColor || "#000000";
            _s.logoLink_str = _s.props.logoLink || "none"; 
            _s.logoTarget = _s.props.logoTarget || "_self"; 

            _s.startAtVideo = parseInt(_s.props.startAtVideo) || 0;
            _s.audioVisualizerLinesColor_str = _s.props.audioVisualizerLinesColor || "#0099FF";
            _s.audioVisualizerCircleColor_str = _s.props.audioVisualizerCircleColor || "#FFFFFF";
            _s.privateVideoPassword_str = _s.props.privateVideoPassword;
            _s.youtubeAPIKey = _s.props.youtubeAPIKey || 'AIzaSyCgbixU3aIWCkiZ76h_E-XpEGig5mFhnVY'; 

            _s.contextMenuBackgroundColor_str = _s.props.contextMenuBackgroundColor || "#000000";
            _s.contextMenuBorderColor_str = _s.props.contextMenuBorderColor || "#FF0000";
            _s.contextMenuSpacerColor_str = _s.props.contextMenuSpacerColor || "#FF0000";
            _s.contextMenuItemNormalColor_str = _s.props.contextMenuItemNormalColor || "#FF0000";
            _s.contextMenuItemSelectedColor_str = _s.props.contextMenuItemSelectedColor || "#FF0000";
            _s.contextMenuItemDisabledColor_str = _s.props.contextMenuItemDisabledColor || "#FF0000";

            _s.showScriptDeveloper_bl = _s.props.showScriptDeveloper;
            _s.showScriptDeveloper_bl = _s.showScriptDeveloper_bl == "yes" ? true : false;

            _s.showContextmenu_bl = _s.props.showContextmenu;
            _s.showContextmenu_bl = _s.showContextmenu_bl == "no" ? false : true;

            _s.useFingerPrintStamp = _s.props.useFingerPrintStamp;
            _s.useFingerPrintStamp = _s.useFingerPrintStamp == "yes" ? true : false;
            if(!window['fwduvpFingerPrintStamp']) _s.useFingerPrintStamp = false;
            _s.frequencyOfFingerPrintStamp = _s.props.frequencyOfFingerPrintStamp || 5000;
            _s.durationOfFingerPrintStamp = _s.props.durationOfFingerPrintStamp || 400;

            _s.nextAndPrevSetButtonsMargins = _s.props.nextAndPrevSetButtonsMargins || 0;
            _s.buttonsMargins = _s.props.buttonsMargins || 0; 
            _s.thumbnailMaxWidth = _s.props.thumbnailMaxWidth || 330; 
            _s.thumbnailMaxHeight = _s.props.thumbnailMaxHeight || 330;
            _s.horizontalSpaceBetweenThumbnails = _s.props.horizontalSpaceBetweenThumbnails;
            _s.verticalSpaceBetweenThumbnails = _s.props.verticalSpaceBetweenThumbnails;
            _s.totalPlaylists = _s.cats_ar.length;
            _s.controllerHeight = _s.props.controllerHeight || 50;
            _s.startSpaceBetweenButtons = _s.props.startSpaceBetweenButtons || 0;
            _s.controllerHideDelay = _s.props.controllerHideDelay || 2;
            _s.controllerHideDelay *= 1000;
            _s.spaceBetweenButtons = _s.props.spaceBetweenButtons || 0;
            _s.scrubbersOffsetWidth = _s.props.scrubbersOffsetWidth || 0;
            _s.mainScrubberOffestTop = _s.props.mainScrubberOffestTop || 0;
            _s.volumeScrubberOffsetTopWidth = _s.props.volumeScrubberOffsetTopWidth || 0;
            _s.timeOffsetLeftWidth = _s.props.timeOffsetLeftWidth || 0;
            _s.timeOffsetRightWidth = _s.props.timeOffsetRightWidth || 0;
            _s.timeOffsetTop = _s.props.timeOffsetTop || 0;
            _s.embedWindowCloseButtonMargins = _s.props.embedAndInfoWindowCloseButtonMargins || 0;
            _s.logoMargins = _s.props.logoMargins || 0;
            _s.maxPlaylistItems = _s.props.maxPlaylistItems || 50;
            _s.volumeScrubberHeight = _s.props.volumeScrubberHeight || 10;
            _s.volumeScrubberOfsetHeight = _s.props.volumeScrubberOfsetHeight || 0;
            if(_s.volumeScrubberHeight > 200) _s.volumeScrubberHeight = 200;
            _s.buttonsToolTipHideDelay = _s.props.buttonsToolTipHideDelay || 1.5;
            _s.thumbnailWidth = _s.props.thumbnailWidth || 80;
            _s.thumbnailHeight = _s.props.thumbnailHeight || 80;

            _s.spaceBetweenThumbnails = _s.props.spaceBetweenThumbnails || 0;
            _s.timeOffsetTop = _s.props.timeOffsetTop || 0;
            _s.scrollbarOffestWidth = _s.props.scrollbarOffestWidth || 0;
            _s.scollbarSpeedSensitivity = _s.props.scollbarSpeedSensitivity || .5;
            _s.facebookAppId_str = _s.props.facebookAppId;
            
            _s.aopwBorderSize = _s.props.aopwBorderSize || 0; 
            _s.aopwTitle = _s.props.aopwTitle || "Advertisement";
            _s.aopwTitleColor_str = _s.props.aopwTitleColor || "#FFFFFF"; 
            _s.aopwWidth = _s.props.aopwWidth || 200; 
            _s.aopwHeight = _s.props.aopwHeight || 200; 
            
            _s.fillEntireVideoScreen_bl = _s.props.fillEntireVideoScreen; 
            _s.fillEntireVideoScreen_bl = _s.fillEntireVideoScreen_bl == "yes" ? true : false;

            _s.fillEntireposterScreen_bl = _s.props.fillEntireposterScreen; 
            _s.fillEntireposterScreen_bl = _s.fillEntireposterScreen_bl == "yes" ? true : false;

            _s.goFullScreenOnPlay_bl = _s.props.goFullScreenOnButtonPlay; 
            _s.goFullScreenOnPlay_bl = _s.goFullScreenOnPlay_bl == "yes" ? true : false;
            
            _s.showContextMenu_bl = _s.props.showContextMenu; 
            _s.showContextMenu_bl = _s.showContextMenu_bl == "no" ? false : true;
            
            _s.showController_bl = _s.props.showController; 
            _s.showController_bl = _s.showController_bl == "no" ? false : true;
            
            _s.showButtonsToolTip_bl = _s.props.showButtonsToolTips; 
            _s.showButtonsToolTip_bl = _s.showButtonsToolTip_bl == "no" ? false : true;
            if(_s.isMbl) _s.showButtonsToolTip_bl = false;
            
            _s.addKeyboardSupport_bl = _s.props.addKeyboardSupport; 
            _s.addKeyboardSupport_bl = _s.addKeyboardSupport_bl == "no" ? false : true;

            _s.playsinline = _s.props.playsinline == "yes" ? true : false;

            _s.useAToB = _s.props.useAToB == "yes" ? true : false;
            _s.atbTimeBackgroundColor = _s.props.atbTimeBackgroundColor || "transparent";
            _s.atbTimeTextColorNormal = _s.props.atbTimeTextColorNormal ||  "#888888";
            _s.atbTimeTextColorSelected = _s.props.atbTimeTextColorSelected || "#FFFFFF";
            _s.atbButtonTextNormalColor = _s.props.atbButtonTextNormalColor || "#888888";
            _s.atbButtonTextSelectedColor = _s.props.atbButtonTextSelectedColor || "#FFFFFF";
            _s.atbButtonBackgroundNormalColor = _s.props.atbButtonBackgroundNormalColor || "#FFFFFF";
            _s.atbButtonBackgroundSelectedColor = _s.props.atbButtonBackgroundSelectedColor || "#000000";
            
            _s.addMouseWheelSupport_bl = _s.props.addMouseWheelSupport; 
            _s.addMouseWheelSupport_bl = _s.addMouseWheelSupport_bl == "no" ? false : true;

            _s.addScrOnMM_bl = _s.props.addScrollOnMouseMove; 
            _s.addScrOnMM_bl = _s.addScrOnMM_bl == "yes" ? true : false;
            
            _s.showPlaylistsSearchInput_bl = _s.props.showPlaylistsSearchInput; 
            _s.showPlaylistsSearchInput_bl = _s.showPlaylistsSearchInput_bl == "yes" ? true : false;
        
            _s.scrubbersToolTipLabelBackgroundColor = _s.props.scrubbersToolTipLabelBackgroundColor || "#FFFFFF";
            _s.scrubbersToolTipLabelFontColor  = _s.props.scrubbersToolTipLabelFontColor || "#000000";
        
            _s.autoPlay_bl = _s.props.autoPlay; 
            _s.autoPlay_bl = _s.autoPlay_bl == "yes" ? true : false;
            _s.autoPlayText = _s.props.autoPlayText || '';
            
            _s.showNextAndPrevButtons_bl = _s.props.showNextAndPrevButtons; 
            _s.showNextAndPrevButtons_bl = _s.showNextAndPrevButtons_bl == "no" ? false : true;
            
            _s.showPlaylistsButtonAndPlaylists_bl = _s.props.showPlaylistsButtonAndPlaylists;
            _s.showPlaylistsButtonAndPlaylists_bl = _s.showPlaylistsButtonAndPlaylists_bl == "no" ? false : true;
            
            _s.showEmbedButton_bl = _s.props.showEmbedButton;
            _s.showEmbedButton_bl = _s.showEmbedButton_bl == "no" ? false : true;

            _s.showScrubberWhenControllerIsHidden_bl = _s.props.showScrubberWhenControllerIsHidden; 
            _s.showScrubberWhenControllerIsHidden_bl = _s.showScrubberWhenControllerIsHidden_bl == "no" ? false : true;

            _s.showMainScrubberToolTipLabel_bl = _s.props.showMainScrubberToolTipLabel;
            _s.showMainScrubberToolTipLabel_bl = _s.showMainScrubberToolTipLabel_bl == "yes" ? true : false;
            
            _s.showPlaylistsByDefault_bl = _s.props.showPlaylistsByDefault; 
            _s.showPlaylistsByDefault_bl = _s.showPlaylistsByDefault_bl == "yes" ? true : false;
            
            _s.loop_bl = _s.props.loop; 
            _s.loop_bl = _s.loop_bl == "yes" ? true : false;
            
            _s.shuffle_bl = _s.props.shuffle; 
            _s.shuffle_bl = _s.shuffle_bl == "yes" ? true : false;
            
            _s.showLoopButton_bl = _s.props.showLoopButton; 
            _s.showLoopButton_bl = _s.props.showLoopButton == "no" ? false : true;
            
            _s.showShuffleButton_bl = _s.props.showShuffleButton; 
            _s.showShuffleButton_bl = _s.props.showShuffleButton == "no" ? false : true;
            
            _s.showDownloadVideoButton_bl = _s.props.showDownloadButton; 
            _s.showDownloadVideoButton_bl = _s.showDownloadVideoButton_bl == "no" ? false : true;

            _s.randomizePlaylist_bl = _s.props.randomizePlaylist; 
            _s.randomizePlaylist_bl = _s.randomizePlaylist_bl == "yes" ? true : false;
            
            _s.showDefaultControllerForVimeo_bl = _s.props.showDefaultControllerForVimeo; 
            _s.showDefaultControllerForVimeo_bl = _s.showDefaultControllerForVimeo_bl == "yes" ? true : false;
            
            _s.showInfoButton_bl = _s.props.showInfoButton; 
            _s.showInfoButton_bl = _s.showInfoButton_bl == "no" ? false : true;
        
            _s.showLogo_bl = _s.props.showLogo; 
            _s.showLogo_bl = _s.showLogo_bl == "yes" ? true : false;
            
            _s.hideLogoWithController_bl = _s.props.hideLogoWithController;
            _s.hideLogoWithController_bl = _s.hideLogoWithController_bl == "yes" ? true : false;
            
            _s.showPoster_bl = _s.props.showPoster; 
            _s.showPoster_bl = _s.showPoster_bl == "yes" ? true : false;
            
            _s.useVectorIcons_bl = _s.props.useVectorIcons; 
            _s.useVectorIcons_bl = _s.useVectorIcons_bl == "yes" ? true : false;
            
            _s.showVolumeButton_bl = _s.props.showVolumeButton; 
            _s.showVolumeButton_bl = _s.showVolumeButton_bl == "no" ? false : true;
            
            _s.showVolumeScrubber_bl = _s.showVolumeButton_bl;
            
            _s.showControllerWhenVideoIsStopped_bl = _s.props.showControllerWhenVideoIsStopped; 
            _s.showControllerWhenVideoIsStopped_bl = _s.showControllerWhenVideoIsStopped_bl == "yes" ? true : false;
            
            _s.showNextAndPrevButtonsInController_bl = _s.props.showNextAndPrevButtonsInController; 
            _s.showNextAndPrevButtonsInController_bl = _s.showNextAndPrevButtonsInController_bl == "yes" ? true : false;
            
            _s.showTime_bl = _s.props.showTime; 
            _s.showTime_bl = _s.showTime_bl == "no" ? false : true;
            
            _s.shwPpoppAdClsBtn = _s.props.showPopupAdsCloseButton; 
            _s.shwPpoppAdClsBtn = _s.shwPpoppAdClsBtn == "no" ? false : true
            
            _s.showRewindButton_bl = _s.props.showRewindButton; 
            _s.showRewindButton_bl = _s.showRewindButton_bl == "no" ? false : true;
            
            _s.disableVideoScrubber_bl = _s.props.disableVideoScrubber; 
            _s.disableVideoScrubber_bl = _s.disableVideoScrubber_bl == "yes" ? true : false;
            
            _s.showPlaybackRateButton_bl = _s.props.showPlaybackRateButton;
            _s.showPlaybackRateButton_bl = _s.showPlaybackRateButton_bl == "yes" ? true : false;
            
            _s.defaultPlaybackRate_str = _s.props.defaultPlaybackRate;
            if(_s.defaultPlaybackRate_str ==  undefined) _s.defaultPlaybackRate_str = 1;
            _s.defaultPlaybackRate_ar = ["0.25", "0.5", "1", "1.25", "1.5", "2"];
            
            _s.defaultPlaybackRate_ar.reverse();
            var found_bl = false;
            for(var i=0; i<_s.defaultPlaybackRate_ar.length; i++){
                if(_s.defaultPlaybackRate_ar[i] == _s.defaultPlaybackRate_str){
                    found_bl = true;
                    _s.startAtPlaybackIndex = i;
                }
            }
            
            if(!found_bl){
                _s.startAtPlaybackIndex = 3;
                _s.defaultPlaybackRate_str = _s.defaultPlaybackRate_ar[_s.startAtPlaybackIndex];
            }
            
            _s.showFullScreenButton_bl = _s.props.showFullScreenButton; 
            _s.showFullScreenButton_bl = _s.showFullScreenButton_bl == "no" ? false : true;
            
            _s.repeatBackground_bl = _s.props.repeatBackground; 
            _s.repeatBackground_bl = _s.repeatBackground_bl == "no" ? false : true;
            
            //loggin
            _s.playVideoOnlyWhenLoggedIn_bl = _s.props.playVideoOnlyWhenLoggedIn; 
            _s.playVideoOnlyWhenLoggedIn_bl = _s.playVideoOnlyWhenLoggedIn_bl == "yes" ? true : false;
            
            _s.playIfLoggedIn = _s.props.playIfLoggedIn; 
            _s.playIfLoggedIn = _s.playIfLoggedIn == "yes" ? true : false;
            _s.playIfLoggedInMessage = _s.props.playIfLoggedInMessage || 'Please loggin';
            
            _s.showShareButton_bl = _s.props.showShareButton; 
            _s.showShareButton_bl = _s.showShareButton_bl == "no" ? false : true;
            
            _s.openNewPageAtTheEndOfTheAds_bl =  _s.props.openNewPageAtTheEndOfTheAds;
            _s.openNewPageAtTheEndOfTheAds_bl = _s.openNewPageAtTheEndOfTheAds_bl == "yes" ? true : false;
            
            _s.playAdsOnlyOnce_bl =  _s.props.playAdsOnlyOnce;
            _s.playAdsOnlyOnce_bl = _s.playAdsOnlyOnce_bl == "yes" ? true : false;
            
            _s.startAtRandomVideo_bl =  _s.props.startAtRandomVideo;
            _s.startAtRandomVideo_bl = _s.startAtRandomVideo_bl == "yes" ? true : false;
            
            _s.stopVideoWhenPlayComplete_bl =  _s.props.stopVideoWhenPlayComplete;
            _s.stopVideoWhenPlayComplete_bl = _s.stopVideoWhenPlayComplete_bl == "yes" ? true : false;

            _s.closeLightBoxWhenPlayComplete =  _s.props.closeLightBoxWhenPlayComplete;
            _s.closeLightBoxWhenPlayComplete = _s.closeLightBoxWhenPlayComplete == "yes" ? true : false;

            _s.showYoutubeQualityButton_bl = _s.props.showQualityButton; 
            _s.showYoutubeQualityButton_bl = _s.showYoutubeQualityButton_bl == "no" ? false : true;

            _s.showAudioTracksButton_bl = _s.props.showAudioTracksButton; 
            _s.showAudioTracksButton_bl = _s.showAudioTracksButton_bl == "no" ? false : true;
            
            _s.thumbnailsPreviewWidth = _s.props.thumbnailsPreviewWidth || 300
            _s.thumbnailsPreviewHeight = _s.props.thumbnailsPreviewHeight || 168
            _s.thumbnailsPreviewBackgroundColor =  _s.props.thumbnailsPreviewBackgroundColor || "#000";
            _s.thumbnailsPreviewBorderColor =   _s.props.thumbnailsPreviewBorderColor || "#333";
            _s.thumbnailsPreviewLabelBackgroundColor =  _s.props.thumbnailsPreviewLabelBackgroundColor || "#FFF";
            _s.thumbnailsPreviewLabelFontColor =    _s.props.thumbnailsPreviewLabelFontColor || "#000";
            
            _s.arrowN_str = _s.sknPth + "combobox-arrow-normal.png";
            _s.arrowS_str = _s.sknPth + "combobox-arrow-selected.png";
            
            _s.hlsPath_str = _s.mainFolderPath_str  + "java/hls.js";
            _s.dashPath_str = _s.mainFolderPath_str  + "java/dash.all.min.js";
            _s.threeJsPath_str = _s.mainFolderPath_str  + "java/three.js";
            _s.threeJsControlsPath_str = _s.mainFolderPath_str  + "java/threeControled.js";

            _s.isDark = true;
            if(_s.sknPth.indexOf('dark') == -1){
                _s.isDark = false;
            }
            
            _s.logoPath_str = _s.sknPth + "logo.png";
            _s.adLinePat_str = _s.sknPth + "ad-line.png";
            if(_s.props.logoPath) _s.logoPath_str = _s.props.logoPath;
            
            _s.mainScrubberDragLeftAddPath_str = _s.sknPth + "scrubber-left-drag-add.png";
            _s.mainScrubberDragMiddleAddPath_str = _s.sknPth + "scrubber-middle-drag-add.png";
        
            _s.mainPreloader_img = new Image();
            _s.mainPreloader_img.onerror = _s.onSkinLoadErrorHandler;
            _s.mainPreloader_img.onload = _s.onPreloaderLoadHandler;
            _s.mainPreloader_img.src = _s.sknPth + "preloader.jpg";
            
            _s.hdIcn = _s.sknPth + 'hd.png';

            _s.skinPaths_ar = [
                 {img:_s.skipIconPath_img = new Image(), src:_s.sknPth + "skip-icon.png"},
                 {img:_s.mainScrubberBkLeft_img = new Image(), src:_s.sknPth + "scrubber-left-background.png"},
                 {img:_s.mainScrubberDragLeft_img = new Image(), src:_s.sknPth + "scrubber-left-drag.png"},
                 {img:_s.mainScrubberLine_img = new Image(), src:_s.sknPth + "scrubber-line.png"},
                 {img:_s.progressLeft_img = new Image(), src:_s.sknPth + "progress-left.png"},
                 {img:_s.volumeScrubberDragBottom_img = new Image(), src:_s.sknPth + "volume-scrubber-bottom-drag.png"},
                 {img:_s.popwColseN_img = new Image(), src:_s.sknPth + "popw-close-button.png"},
                 {img:_s.embedColoseN_img = new Image(), src:_s.sknPth + "embed-close-button.png"}

            ];
            
            if(!_s.useVectorIcons_bl){
                _s.skinPaths_ar.push(
                     {img:_s.prevN_img = new Image(), src:_s.sknPth + "prev-video.png"},
                     {img:_s.nextN_img = new Image(), src:_s.sknPth + "next-video.png"},
                     {img:_s.playN_img = new Image(), src:_s.sknPth + "play.png"},
                     {img:_s.pauseN_img = new Image(), src:_s.sknPth + "pause.png"},
                     {img:_s.volumeN_img = new Image(), src:_s.sknPth + "volume.png"},
                     {img:_s.largePlayN_img = new Image(), src:_s.sknPth + "large-play.png"},
                     {img:_s.categoriesN_img = new Image(), src:_s.sknPth + "categories-button.png"},
                     {img:_s.replayN_img = new Image(), src:_s.sknPth + "replay-button.png"},
                     {img:_s.shuffleN_img = new Image(), src:_s.sknPth + "shuffle-button.png"},
                     {img:_s.fullScreenN_img = new Image(), src:_s.sknPth + "full-screen.png"},
                     {img:_s.ytbQualityN_img = new Image(), src:_s.sknPth + "youtube-quality.png"},
                     {img:_s.shareN_img = new Image(), src:_s.sknPth + "share.png"},
                     {img:_s.facebookN_img = new Image(), src:_s.sknPth + "facebook.png"},
                     {img:_s.infoN_img = new Image(), src:_s.sknPth + "info-button.png"},
                     {img:_s.downloadN_img = new Image(), src:_s.sknPth + "download-button.png"},
                     {img:_s.normalScreenN_img = new Image(), src:_s.sknPth + "normal-screen.png"},
                     {img:_s.embedN_img = new Image(), src:_s.sknPth + "embed.png"},
                     {img:_s.passColoseN_img = new Image(), src:_s.sknPth + "embed-close-button.png"},
                     {img:_s.showSubtitleNPath_img = new Image(), src:_s.sknPth + "show-subtitle-icon.png"},
                     {img:_s.hideSubtitleNPath_img = new Image(), src:_s.sknPth + "hide-subtitle-icon.png"},
                     {img:_s.playbackRateNPath_img = new Image(), src:_s.sknPth + "playback-rate-normal.png"}
                )

                if(_s.useAToB){
                    _s.skinPaths_ar.push(
                        {img:_s.atbNPath_img = new Image(), src:_s.sknPth + "a-to-b-button.png"}
                    )
                }
            }
            
            if((_s.showOpener_bl && prt.displayType == FWDUVPlayer.STICKY) 
                || (_s.stickyOnScrollShowOpener_bl && prt.stickyOnScroll)){
                _s.skinPaths_ar.push(
                     {img:_s.openerPauseN_img = new Image(), src:_s.sknPth + "open-pause-button-normal.png"},
                     {img:_s.openerPlayN_img = new Image(), src:_s.sknPth + "open-play-button-normal.png"},
                     {img:_s.animationPath_img = new Image(), src:_s.sknPth + "equalizer.png"},
                     {img:_s.closeN_img = new Image(), src:_s.sknPth + "opener-close.png"},
                     {img:_s.openTopN_img = new Image(), src:_s.sknPth + "open-button-normal-top.png"},
                     {img:_s.openBottomN_img = new Image(), src:_s.sknPth + "open-button-normal-bottom.png"}
                     
                )
                _s.openerPauseS_str = _s.sknPth + "open-pause-button-selected.png";
                _s.openerPlayS_str = _s.sknPth + "open-play-button-selected.png";
                _s.openerAnimationPath_str = _s.sknPth + "equalizer.png";   
                _s.openTopSPath_str = _s.sknPth + "open-button-selected-top.png";   
                _s.openBottomSPath_str = _s.sknPth + "open-button-selected-bottom.png"; 
                _s.openTopSPath_str = _s.sknPth + "open-button-selected-top.png";
                _s.openBottomSPath_str = _s.sknPth + "open-button-selected-bottom.png";
                
                _s.closeSPath_str = _s.sknPth + "opener-close-over.png"
            }
            
            if(_s.showRewindButton_bl){
                _s.skinPaths_ar.push(
                     {img:_s.rewindN_img = new Image(), src:_s.sknPth + "rewind.png"}
                )
                _s.rewindSPath_str = _s.sknPth + "rewind-over.png";
            }

            if(_s.showInfoButton_bl){
                _s.skinPaths_ar.push(
                    {img:_s.infoWindowClooseN_img = new Image(), src:_s.sknPth + "embed-close-button.png"}
                )
            }
            
            if(_s.showNextAndPrevButtonsInController_bl && !_s.useVectorIcons_bl){
                _s.skinPaths_ar.push(
                    {img:_s.next2N_img = new Image(), src:_s.sknPth + "next-video.png"},
                    {img:_s.prev2N_img = new Image(), src:_s.sknPth + "prev-video.png"}
                )
            }

            if(_s.show360DegreeVideoVrButton_bl){
                _s.skinPaths_ar.push(
                    {img:_s.vr_img = new Image(), src:_s.sknPth + "vr.png"}
                )
                _s.vrSPath_img = _s.sknPth + "vr-over.png";
            }   

            if(_s.showAudioTracksButton_bl){
                _s.skinPaths_ar.push(
                    {img:_s.at_img = new Image(), src:_s.sknPth + "at.png"}
                )
                _s.atSPath_img = _s.sknPth + "at-over.png";
            }   
            
            
            if(_s.showShareButton_bl && !_s.useVectorIcons_bl){
                _s.skinPaths_ar.push(
                    {img:_s.shareClooseN_img = new Image(), src:_s.sknPth + "embed-close-button.png"},
                    {img:_s.facebookN_img = new Image(), src:_s.sknPth + "facebook.png"},
                    {img:_s.googleN_img = new Image(), src:_s.sknPth + "google-plus.png"},
                    {img:_s.twitterN_img = new Image(), src:_s.sknPth + "twitter.png"},
                    {img:_s.likedInkN_img = new Image(), src:_s.sknPth + "likedin.png"},
                    {img:_s.bufferkN_img = new Image(), src:_s.sknPth + "buffer.png"},
                    {img:_s.diggN_img = new Image(), src:_s.sknPth + "digg.png"},
                    {img:_s.redditN_img = new Image(), src:_s.sknPth + "reddit.png"},
                    {img:_s.thumbrlN_img = new Image(), src:_s.sknPth + "thumbrl.png"}
                )
                
                _s.facebookSPath_str = _s.sknPth + "facebook-over.png";
                _s.googleSPath_str = _s.sknPth + "google-plus-over.png";
                _s.twitterSPath_str = _s.sknPth + "twitter-over.png";
                _s.likedInSPath_str = _s.sknPth + "likedin-over.png";
                _s.bufferSPath_str = _s.sknPth + "buffer-over.png";
                _s.diggSPath_str = _s.sknPth + "digg-over.png";
                _s.redditSPath_str = _s.sknPth + "reddit-over.png";
                _s.thumbrlSPath_str = _s.sknPth + "thumbrl-over.png";
            }
            
            //setup skin paths
            _s.atbSPath_str = _s.sknPth + "a-to-b-button-over.png";
            _s.popwColseSPath_str = _s.sknPth + "popw-close-button-over.png";
            _s.popwWindowBackgroundPath_str = _s.sknPth + "popw-window-background.png";
            _s.popwBarBackgroundPath_str = _s.sknPth + "popw-bar-background.png";
            _s.playbackRateSPath_str = _s.sknPth + "playback-rate-selected.png";
            _s.prevSPath_str = _s.sknPth + "prev-video-over.png"; 
            _s.nextSPath_str = _s.sknPth + "next-video-over.png"; 
            _s.playSPath_str = _s.sknPth + "play-over.png"; 
            _s.pauseSPath_str = _s.sknPth + "pause-over.png";
            _s.bkMiddlePath_str = _s.sknPth + "controller-middle.png";
            _s.hdPath_str = _s.sknPth + "hd.png";
            _s.youtubeQualityArrowPath_str = _s.sknPth + "youtube-quality-arrow.png";
            _s.ytbQualityButtonPointerPath_str = _s.sknPth + "youtube-quality-pointer.png";
            _s.controllerBkPath_str = _s.sknPth + "controller-background.png";
            _s.skipIconSPath_str = _s.sknPth + "skip-icon-over.png";
            _s.adsBackgroundPath_str = _s.sknPth + "ads-background.png";
            _s.shareSPath_str = _s.sknPth + "share-over.png";

            _s.mainScrubberBkRightPath_str = _s.sknPth + "scrubber-right-background.png";
            _s.mainScrubberBkMiddlePath_str = _s.sknPth + "scrubber-middle-background.png";
            _s.mainScrubberDragMiddlePath_str = _s.sknPth + "scrubber-middle-drag.png";
        
            _s.volumeScrubberBkBottomPath_str = _s.sknPth + "volume-scrubber-bottom-background.png"; 
            _s.volumeScrubberBkMiddlePath_str = _s.sknPth + "volume-scrubber-middle-background.png";
            _s.volumeScrubberBkTopPath_str = _s.sknPth + "volume-scrubber-top-background.png";
            _s.volumeScrubberDragBottomPath_str = _s.sknPth + "volume-scrubber-bottom-drag.png";
            _s.volumeScrubberLinePath_str = _s.sknPth + "volume-scrubber-line.png";
            _s.volumeScrubberDragMiddlePath_str = _s.sknPth + "volume-scrubber-middle-drag.png";    
        
            _s.volumeSPath_str = _s.sknPth + "volume-over.png";
            _s.volumeDPath_str = _s.sknPth + "volume-disabled.png";
            _s.categoriesSPath_str = _s.sknPth + "categories-button-over.png";
            _s.replaySPath_str = _s.sknPth + "replay-button-over.png";
            _s.toopTipBk_str = _s.sknPth + "tooltip-background.png"; 
            _s.toopTipPointer_str = _s.sknPth + "tooltip-pointer.png"; 
            _s.shufflePathS_str = _s.sknPth + "shuffle-button-over.png";
            _s.passButtonNPath_str = _s.sknPth + "pass-button.png";
            _s.passButtonSPath_str = _s.sknPth + "pass-button-over.png";
            
            _s.largePlayS_str = _s.sknPth + "large-play-over.png";
            _s.fullScreenSPath_str = _s.sknPth + "full-screen-over.png";
            _s.ytbQualitySPath_str = _s.sknPth + "youtube-quality-over.png";
            _s.ytbQualityDPath_str = _s.sknPth + "youtube-quality-hd.png";
            _s.facebookSPath_str = _s.sknPth + "facebook-over.png";
            _s.infoSPath_str = _s.sknPth + "info-button-over.png";
            _s.downloadSPath_str = _s.sknPth + "download-button-over.png";
            _s.normalScreenSPath_str = _s.sknPth + "normal-screen-over.png";
            _s.progressMiddlePath_str = _s.sknPth + "progress-middle.png";
            _s.embedPathS_str = _s.sknPth + "embed-over.png";
            _s.embedWindowClosePathS_str = _s.sknPth + "embed-close-button-over.png"; 
            _s.embedWindowInputBackgroundPath_str = _s.sknPth + "embed-window-input-background.png";
            _s.embedCopyButtonNPath_str = _s.sknPth + "embed-copy-button.png";
            _s.embedCopyButtonSPath_str = _s.sknPth + "embed-copy-button-over.png";
            _s.sendButtonNPath_str = _s.sknPth + "send-button.png";
            _s.sendButtonSPath_str = _s.sknPth + "send-button-over.png";
            _s.embedWindowBackground_str = _s.sknPth + "embed-window-background.png";
            _s.showSubtitleSPath_str = _s.sknPth + "show-subtitle-icon-over.png";
            _s.hideSubtitleSPath_str = _s.sknPth + "hide-subtitle-icon-over.png";
            _s.inputArrowPath_str = _s.sknPth + "input-arrow.png"; 
            
            if(_s.showPlaylistsButtonAndPlaylists_bl){
                _s.skinPaths_ar.push(
                    {img:new Image(), src:_s.sknPth + "categories-background.png"}
                );
                
                if(!_s.useVectorIcons_bl){
                    _s.skinPaths_ar.push(
                        {img:_s.catNextN_img = new Image(), src:_s.sknPth + "categories-next-button.png"},
                        {img:_s.catPrevN_img = new Image(), src:_s.sknPth + "categories-prev-button.png"},
                        {img:_s.catCloseN_img = new Image(), src:_s.sknPth + "categories-close-button.png"}
                    )
                }
                _s.catBkPath_str = _s.sknPth + "categories-background.png"; 
                _s.catThumbBkPath_str = _s.sknPth + "categories-thumbnail-background.png"; 
                _s.catThumbBkTextPath_str = _s.sknPth + "categories-thumbnail-text-backgorund.png"; 
                _s.catNextSPath_str = _s.sknPth + "categories-next-button-over.png"; 
                _s.catPrevSPath_str = _s.sknPth + "categories-prev-button-over.png"; 
                _s.catCloseSPath_str = _s.sknPth + "categories-close-button-over.png"; 
            }
            
            _s.poppAdClsNPth = _s.sknPth + "close-button-normal.png"; 
            _s.poppAdClsSPth = _s.sknPth + "close-button-selected.png"; 
            
            _s.annotationAddCloseNPath_str = _s.sknPth + "annotation-close-button-normal.png"; 
            _s.annotationAddCloseSPath_str = _s.sknPth + "annotation-close-button-selected.png";
            
            if(_s.showPlaylistButtonAndPlaylist_bl){
                var prevThumbsSetNPath_str;
                
                _s.playlistThumbnailsBkPath_str = _s.sknPth + "playlist-thumbnail-background.png";
                _s.playlistBkPath_str = _s.sknPth + "playlist-background.png";
                
                if(_s.playlistPosition_str == "bottom"){
                    _s.skinPaths_ar.push(
                        {img:_s.hidePlaylistN_img = new Image(), src:_s.sknPth + "hide-horizontal-playlist.png"},
                        {img:_s.showPlaylistN_img = new Image(), src:_s.sknPth + "show-horizontal-playlist.png"}
                    );
                    _s.hidePlaylistSPath_str = _s.sknPth + "hide-horizontal-playlist-over.png"; 
                    _s.showPlaylistSPath_str = _s.sknPth + "show-horizontal-playlist-over.png"; 
                }else{
                    _s.skinPaths_ar.push(
                        {img:_s.hidePlaylistN_img = new Image(), src:_s.sknPth + "hide-vertical-playlist.png"},
                        {img:_s.showPlaylistN_img = new Image(), src:_s.sknPth + "show-vertical-playlist.png"}
                    );
                    _s.hidePlaylistSPath_str = _s.sknPth + "hide-vertical-playlist-over.png"; 
                    _s.showPlaylistSPath_str = _s.sknPth + "show-vertical-playlist-over.png"; 
                }
                
                _s.skinPaths_ar.push(
                    {img:_s.scrBkTop_img = new Image(), src:_s.sknPth + "playlist-scrollbar-background-top.png"},
                    {img:_s.scrDragTop_img = new Image(), src:_s.sknPth + "playlist-scrollbar-drag-top.png"},
                    {img:_s.scrLinesN_img = new Image(), src:_s.sknPth + "playlist-scrollbar-lines.png"}
                );
                
                _s.scrBkMiddlePath_str = _s.sknPth + "playlist-scrollbar-background-middle.png";
                _s.scrBkBottomPath_str = _s.sknPth + "playlist-scrollbar-background-bottom.png";
                _s.scrDragMiddlePath_str = _s.sknPth + "playlist-scrollbar-drag-middle.png";
                _s.scrDragBottomPath_str = _s.sknPth + "playlist-scrollbar-drag-bottom.png";
                _s.scrLinesSPath_str = _s.sknPth + "playlist-scrollbar-lines-over.png";
                _s.inputArrowPath_str = _s.sknPth + "input-arrow.png";
            }

            if(_s.showChromecastButton_bl){
                _s.skinPaths_ar.push(
                    {img:_s.castN_img = new Image(), src:_s.sknPth + "cast.png"},
                    {img:_s.uncastN_img = new Image(), src:_s.sknPth + "uncast.png"}
                )
                _s.castSPath_str = _s.sknPth + "cast-over.png";
                _s.uncastSPath_str = _s.sknPth + "uncast-over.png";
            }
            
            _s.totalGraphics = _s.skinPaths_ar.length;
        };
        

        //####################################//
        /* Preloader load done! */
        //###################################//
        _s.onPreloaderLoadHandler = function(){
            _s.countLoadedSCript = 0;
            _s.scripts = [];
            if(_s.useAToB){
                _s.scripts.push('FWDUVPATB.js');
            }
            if(_s.thumbnailsPreview){
                _s.scripts.push('FWDUVPThumbnailsPreview.js');
            }
            if(_s.showChromecastButton_bl){
                _s.scripts.push('https://www.gstatic.com/cv/js/sender/v1/cast_sender.js?loadCastFramework=1');
                _s.scripts.push('FWDUVPCC.js');
            }

            if(_s.useFingerPrintStamp){
                _s.scripts.push('FWDUVPFPS.js');
            }
            _s.totalScripts = _s.scripts.length;

            _s.dispatchEvent(FWDUVPData.PRELOADER_LOAD_DONE);
            _s.loadPlugin();
        };

        _s.loadPlugin = function(){
            if(_s.countLoadedSCript == _s.totalScripts){
                _s.loadSkin();  
            }else{
                var script = document.createElement('script');
                var scriptURI = _s.scripts[_s.countLoadedSCript] 
                if(/\?/.test(scriptURI)){
                    scriptURI += '&version=' + FWDUVPlayer.V;
                }else{
                    scriptURI += '?version=' + FWDUVPlayer.V;
                }
                document.head.appendChild(script);
                if(scriptURI.indexOf('gstatic') != -1){
                    script.src = scriptURI;
                }else{
                    script.src =  _s.mainFolderPath_str + 'java/' + scriptURI;
                }
                
                script.onload = _s.loadPlugin;
                script.onerror = function(e){
                    console.log(e);
                    if(scriptURI == 'FWDUVPFPS.js'){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:'You have enabled the FingerPrintstamp plugin, the fingerpintstamp js file named <font color="#FF0000">FWDUVPFPS.js</font> is not found. Please make sure that the content folder contains the java folder that contains the <font color="#FF0000">FWDUVPFPS.js</font> file. '});
                    }else if(scriptURI == 'FWDUVPATB.js'){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:'You have enabled the A to B plugin, the A to B js file named <font color="#FF0000">FWDUVPATB.js</font> is not found. Please make sure that the content folder contains the java folder that contains the <font color="#FF0000">FWDUVPATB.js</font> file. '});
                    }else if(scriptURI == 'FWDUVPThumbnailsPreview.js'){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:'You have enabled the thumbnal preview plugin, the thumbnail preview js file named <font color="#FF0000">FWDUVPThumbnailsPreview.js</font> is not found. Please make sure that the content folder contains the java folder that contains the <font color="#FF0000">FWDUVPThumbnailsPreview.js</font> file. '});
                    }else if(scriptURI == 'FWDUVPCC.js'){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:'You have enabled the chromecast plugin, the js file named <font color="#FF0000">FWDUVPCC.js</font> is not found. Please make sure that the content folder contains the java folder that contains the <font color="#FF0000">FWDUVPCC.js</font> file.'});
                    }else if(scriptURI.indexOf('gstatic.js') != -1){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:'Choromecast framework javascript file can\'t be loaded<font color="#FF0000"> ' + scriptURI +  ' </font>'});
                    }
                
                }
            }
            _s.countLoadedSCript++;
        }

        
        //#####################################//
        /* Load IMA SDK */
        //#####################################//
        _s.countImaLoadedSCript = 0;
        _s.startToLoadIMA = function(){
            if(_s.imaScripts) return;
            _s.imaScripts = ['//imasdk.googleapis.com/js/sdkloader/ima3.js',  _s.mainFolderPath_str + 'java/FWDUVPIMA.js'];
            _s.totalImaScripts = _s.imaScripts.length;
            _s.loadIMA();
        }
        
        _s.loadIMA = function(){
            if(_s.countImaLoadedSCript == _s.totalImaScripts){
                _s.imaReady = true;
                _s.dispatchEvent(FWDUVPData.IMA_READY);
            }else{
                var script = document.createElement('script');
                var scriptURI = _s.imaScripts[_s.countImaLoadedSCript];
                document.head.appendChild(script);
                script.src = scriptURI;
                script.onload = _s.loadIMA;
                script.onerror = function(e){
                    if(_s.countImaLoadedSCript == 1){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:'IMA SDK can\'t be loaded'});
                    }else if(_s.countImaLoadedSCript == 2){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:'IMA file <font color="#FF0000">FWDUVPIMA.js</font> is not found. Please make sure that the content folder contains the java folder that contains the <font color="#FF0000">FWDUVPIMA.js</font> file. '});
                    }
                    _s.dispatchEvent(FWDUVPData.IMA_ERROR);
                }
                _s.countImaLoadedSCript++;
            }
        }
            
        
        //####################################//
        /* load buttons graphics */
        //###################################//
        _s.loadSkin = function(){
            var img;
            var src;
            for(var i=0; i<_s.totalGraphics; i++){
                img = _s.skinPaths_ar[i].img;
                src = _s.skinPaths_ar[i].src;
                img.onload = _s.onSkinLoadHandler;
                img.onerror = _s.onSkinLoadErrorHandler;
                img.src = src;
            }
        };
        
        _s.onSkinLoadHandler = function(e){
            _s.countLoadedSkinImages++;
            if(_s.countLoadedSkinImages == _s.totalGraphics){
                if(_s.showOnlyThumbnail){
                    _s.thumbnailWidth = _s.thumbnailWidth - _s.scrBkTop_img.width;
                    _s.showSearchInpt = false;
                }
                setTimeout(function(){
                    _s.dispatchEvent(FWDUVPData.SKIN_LOAD_COMPLETE);
                }, 50);
            }
        };
        
        _s.onSkinLoadErrorHandler = function(e){
            var message;
            if (FWDUVPUtils.isIEAndLessThen9){
                message = "Graphics image not found!";
            }else{
                message = "The skin icon with label <font color='#ff0000'>" + e.target.src + "</font> can't be loaded, check path!";
            }
            
            if(window.console) console.log(e);
            var err = {text:message};
            setTimeout(function(){
                _s.dispatchEvent(FWDUVPData.LOAD_ERROR, err);
            }, 50);
        };
        

        //##########################################//
        /* Download video */
        //##########################################//
        _s.downloadVideo = function(sourcePath, pName){
                
            if(FWDUVPUtils.isLocal){
                _s.isPlaylistDispatchingError_bl = true;
                var showLoadPlaylistErrorId_to = setTimeout(function(){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Downloading video files local is not allowed or possible! To function properly please test online."});
                    _s.isPlaylistDispatchingError_bl = false;
                }, 50);
                return;
            }
            
            if(!sourcePath){
                _s.isPlaylistDispatchingError_bl = true;
                var showLoadPlaylistErrorId_to = setTimeout(function(){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Not allowed to download _s video!"});
                    _s.isPlaylistDispatchingError_bl = false;
                }, 50);
                return;
            }
            
            if(!sourcePath.match(/\.mp3|\.mp4/ig)){
                _s.isPlaylistDispatchingError_bl = true;
                var showLoadPlaylistErrorId_to = setTimeout(function(){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Only mp4 video files hosted on your server can be downloaded."});
                    _s.isPlaylistDispatchingError_bl = false;
                }, 50);
                return;
                
            }
            
            var defaultSourcePath = sourcePath;
            var path1 = location.origin;
            var path2 = location.pathname;
        
            if(path2.indexOf(".") != -1){
                path2 = path2.substr(0, path2.lastIndexOf("/") + 1);
            }
            
            var hasHTTPorHTTPS_bl = sourcePath.indexOf("http:") == -1 && sourcePath.indexOf("https:") == -1;
        
            if(hasHTTPorHTTPS_bl){
                sourcePath = path1 + path2 + sourcePath;
            }
    
            if(!pName) return;
            pName = decodeURIComponent(pName);
            pName = pName.replace(/[^A-Z0-9\-\_\.]+/ig, "_");
        
            sourcePath = FWDUVPUtils.getValidSource(sourcePath);
            
            var url = _s.videoDownloaderPath_str;
            
            if(!_s.dlIframe){
                _s.dlIframe = document.createElement("IFRAME");
                _s.dlIframe.style.display = "none";
                document.documentElement.appendChild(_s.dlIframe);
            }
            
            if(_s.isMbl && !FWDUVPUtils.isAndroid){
                
                if(_s.openDownloadLinkOnMobile_bl){
                    window.open(defaultSourcePath, "_blank");
                    return;
                }
            
                var email = _s.getValidEmail();
                if(!email) return;
                
                if(_s.emailXHR != null){
                    try{_s.emailXHR.abort();}catch(e){}
                    _s.emailXHR.onreadystatechange = null;
                    _s.emailXHR.onerror = null;
                    _s.emailXHR = null;
                }
                
                _s.emailXHR = new XMLHttpRequest();
                
                _s.emailXHR.onreadystatechange = function(e){
                    if(_s.emailXHR.readyState == 4){
                        if(_s.emailXHR.status == 200){
                            if(_s.emailXHR.responseText == "sent"){
                                alert("Email sent.");
                            }else{
                                alert("Error sending email, _s is a server side error, the php file can't send the email!");
                            }
                            
                        }else{
                            alert("Error sending email: " + _s.emailXHR.status + ": " + _s.emailXHR.statusText);
                        }
                    }
                };
                
                _s.emailXHR.onerror = function(e){
                    try{
                        if(window.console) console.log(e);
                        if(window.console) console.log(e.message);
                    }catch(e){};
                    alert("Error sending email: " + e.message);
                };

                _s.emailXHR.open("get", _s.mailPath_str + "?mail=" + email + "&name=" + pName + "&path=" + sourcePath, true);
                _s.emailXHR.send();
                return;
            }
            
        
            _s.dlIframe.src = url + "?path="+ sourcePath +"&name=" + pName;
        };
        
        
        _s.getValidEmail = function(){
            var email = prompt("Please enter your email address where the video download link will be sent:");
            var emailRegExp = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
        
            while(!emailRegExp.test(email) || email == ""){
                if(email === null) return;
                email = prompt("Please enter a valid email address:");
            }
            return email;
        };
        

        //####################################//
        /* load playlist */
        //####################################//
        _s.loadPlaylist = function(id){
            _s.id = id;
            _s.playlist_ar = undefined;
            _s.stopToLoadPlaylist();
            
            if(_s.isPlaylistDispatchingError_bl) return;
            
            clearTimeout(_s.dispatchPlaylistLoadCompleteWidthDelayId_to);
            var source = _s.catsRef_ar[id];

            if(source === undefined){
                _s.isPlaylistDispatchingError_bl = true;
                var showLoadPlaylistErrorId_to = setTimeout(function(){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"<font color='#ff0000'>loadPlaylist()</font> - Please specify a DOM playlist id or youtube playlist id!"});
                    _s.isPlaylistDispatchingError_bl = false;
                }, 50);
                return;
            }
            
            if(source === null){
                _s.isPlaylistDispatchingError_bl = true;
                var showLoadPlaylistErrorId_to = setTimeout(function(){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"The playlist with id <font color='#ff0000'>" + _s.cats_ar[id].source + "</font> is not found in the DOM."});
                    _s.isPlaylistDispatchingError_bl = false;
                }, 50);
                return;
            }
        
            if(!isNaN(source)){
                _s.isPlaylistDispatchingError_bl = true;
                var showLoadPlaylistErrorId_to = setTimeout(function(){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"<font color='#ff0000'>loadPlaylist()</font> - The parameter must be of type string!"});
                    _s.isPlaylistDispatchingError_bl = false;
                }, 50);
                return;
            }

            _s.resetYutubeVimeoPlaylistLoader();
            _s.isYoutbe_bl = false;
            _s.loadFromFolder_bl = false;
            _s.isVimeoAlbum_bl = false;
            _s.playlist_ar = [];
            _s.playlistPass = _s.cats_ar[id].pass;
            
            if(!source.length){
                _s.parseDOMPlaylist(source, _s.cats_ar[id].source); 
            }else if(source.indexOf("list=") != -1 || source.indexOf("youtube.") != -1){
                _s.isYoutbe_bl = true;
                _s.playlist_ar = _s.plsCache_ar[_s.id];
                if(_s.playlist_ar){
                    _s.youtubePlLoadComplete();
                }else{
                    _s.loadYoutubePlaylist(source);
                }
            }else if(source.indexOf("vimeo.com") != -1){
                _s.isVimeo_bl = true;
                _s.loadVimeoPlaylist(source, _s.cats_ar[id]['vimeoUserId'], _s.cats_ar[id]['clientId'], _s.cats_ar[id]['vimeoSecret'], _s.cats_ar[id]['vimeoToken']);
            }else if(source.indexOf("list=") != -1){
                _s.isPlaylistDispatchingError_bl = true;
                var showLoadPlaylistErrorId_to = setTimeout(function(){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Loading youtube playlist is only possible by setting <font color='#ff0000'>useYoutube=\"yes\"</font>."});
                    _s.isPlaylistDispatchingError_bl = false;
                }, 50);
                return;
            }else if(source.indexOf("folder=") != -1){
                _s.loadFolderPlaylist(source);
            }else if(source.indexOf(".xml") != -1
              || source.indexOf("http:") != -1
              || source.indexOf("https:") != -1
              || source.indexOf("www.") != -1
            ){
                _s.loadXMLPlaylist(source);
            }
        };

        
        //#######################################//
        /* load XML playlist (warning _s will will work only online on a web server,
         * it is not working local!) */
        //######################################//
        _s.loadXMLPlaylist = function(url){
            if(_s.isPlaylistDispatchingError_bl) return;
            
            if(document.location.protocol == "file:"){
                _s.isPlaylistDispatchingError_bl = true;
                var showLoadPlaylistErrorId_to = setTimeout(function(){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Loading XML files local is not allowed or possible!. To function properly please test online."});
                    _s.isPlaylistDispatchingError_bl = false;
                }, 50);
                return;
            }
            
            _s.sourceURL_str = url;
            _s.xhr = new XMLHttpRequest();
            _s.xhr.onreadystatechange = _s.ajaxOnLoadHandler;
            _s.xhr.onerror = _s.ajaxOnErrorHandler;
            
            try{
                _s.xhr.open("get", _s.proxyPath_str + "?url=" +  _s.sourceURL_str + "&rand=" + parseInt(Math.random() * 99999999), true);
                _s.xhr.setRequestHeader('Content-Type', 'text/xml');
                _s.xhr.send();
            }catch(e){
                var message = e;
                if(e){if(e.message)message = e.message;}
                _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"XML file can't be loaded! <font color='#ff0000'>" + _s.sourceURL_str + "</font>. " + message });
            }
        };
        

        //#######################################//
        /* load folder */
        //######################################//
        _s.loadFolderPlaylist = function(url){
            if(_s.isPlaylistDispatchingError_bl) return;
            
            if(document.location.protocol == "file:"){
                _s.isPlaylistDispatchingError_bl = true;
                var showLoadPlaylistErrorId_to = setTimeout(function(){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Creating a video playlist from a folder is not allowed or possible local! To function properly please test online."});
                    _s.isPlaylistDispatchingError_bl = false;
                }, 50);
                return;
            }   
            
            _s.loadFromFolder_bl = true;
            _s.sourceURL_str = url.substr(url.indexOf("=") + 1);
            _s.xhr = new XMLHttpRequest();
            _s.xhr.onreadystatechange = _s.ajaxOnLoadHandler;
            _s.xhr.onerror = _s.ajaxOnErrorHandler;
            
            try{
                _s.xhr.open("get", _s.proxyFolderPath_str + "?dir=" +  encodeURIComponent(_s.sourceURL_str) + "&videoLabel=" + _s.folderVideoLabel_str  + "&rand=" + parseInt(Math.random() * 9999999), true);
                _s.xhr.send();
            }catch(e){
                var message = e;
                if(e){if(e.message)message = e.message;}
                _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Please make sure the folder exists and it has video or audio files in it: <font color='#ff0000'>" + encodeURIComponent(_s.sourceURL_str) + "</font>"});
            }
        };


        //##########################################//
        /* load youtube list */
        //##########################################//
        _s.loadVimeoPlaylist = function(url, userId, clientId, vimeoSecret, vimeoToken){
            if(document.location.protocol == "file:"){
                _s.isPlaylistDispatchingError_bl = true;
                var showLoadPlaylistErrorId_to = setTimeout(function(){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Loading Vimeo albums local is not allowed or possible! To function properly please test online."});
                    _s.isPlaylistDispatchingError_bl = false;
                }, 50);
                return;
            }
            
            _s.isVimeoAlbum_bl = true;
            if(url) _s.vimeoAlbumURL = url;
            if(userId) _s.userId = userId;
            if(clientId) _s.clientId = clientId;
            if(vimeoSecret) _s.vimeoSecret = vimeoSecret;
            if(vimeoToken) _s.vimeoToken = vimeoToken;
            var albumId = _s.vimeoAlbumURL.match(/\/[\d]+/ig);
            albumId = albumId[0].substr(1);
            
            var offset = '';
            if(_s.clientId){
                offset = '&client_id=' + _s.clientId + '&vimeo_secret=' + _s.vimeoSecret + '&vimeo_token=' + _s.vimeoToken;
            }
            
            if(_s.nextPageToken_str){
                _s.sourceURL_str = _s.mainFolderPath_str + 'vimeo/data.php?rand=' + Math.round(Math.random() * 99999999) +  '&type=vimeo_user_album&user=' + _s.userId + '&album_id=' + albumId + '&page='+ _s.nextPageToken_str + '&per_page=50' + offset;
            }else{
                _s.sourceURL_str = _s.mainFolderPath_str + 'vimeo/data.php?rand=' + Math.round(Math.random() * 99999999) +  '&type=vimeo_user_album&user=' + _s.userId + '&album_id=' + albumId + '&page=1&per_page=50' + offset;
            }
            
            _s.xhr = new XMLHttpRequest();
            _s.xhr.onreadystatechange = _s.ajaxOnLoadHandler;
            _s.xhr.onerror = _s.ajaxOnErrorHandler;
            
            try{
                _s.xhr.open("get",_s.sourceURL_str, true);
                _s.xhr.send();
            }catch(e){
                var message = e;
                if(e){if(e.message)message = e.message;}
                _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Error loading vimeo album! <font color='#ff0000'>" + _s.vimeoAlbumURL + "</font>"});
            }
        }
        
        _s.parseVimeoPlaylist = function(object){
            _s.stopToLoadPlaylist();
            if(object['body']['error']){
                _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:object['body']['error'] + ' ' + object['body']['developer_message']});
                return;
            }
            object = object['body'];
        
            var tt;
            var item;
            var videoSource;
            
            if(!_s.vimeoObject_ar){
                _s.vimeoObject_ar = [];
            }
            
            for(var i=0; i<object.data.length; i++){
                _s.vimeoObject_ar.push(object.data[i]);
            }
            
            tt = _s.vimeoObject_ar.length;
            
            
            if(object['paging']['next']){
                _s.nextPageToken_str = Number(object['page']) + 1;
                _s.loadVimeoPlaylist();
                return;
            }
        
            for(var i=0; i< tt; i++){
                
                var obj = {};
                item = _s.vimeoObject_ar[i];
                var videoId = item['uri'].match(/\/[\d]+/ig)[0].substr(1);
                obj.startAtVideo = 0;
                obj.videoSource = [{source:'https://vimeo.com/' + videoId}];
                
                obj['atb'] = 'yes';
                obj.gaStr = item['name'];
                obj.title = "<p class='ytbChangeColor fwduvp-ytb-info-title' style='color:" + _s.youtubeAndFolderVideoTitleColor_str + ";'>" + item['name'] + "</p>";
                
                var desc = item['description'];
                if(!desc) desc = "";
                if(obj.title.length > 165){
                    desc = desc.substr(0, 60);
                }else{
                    desc = desc.substr(0, 90);
                }
                
                desc = desc.substr(0, desc.lastIndexOf(" ")) + " ...";
                
                obj.titleText = item['name'];
                obj.titleText = item['name'];
                obj.desc = undefined;
                
                obj.desc = "<p class='fwduvp-ytb-info-title' style='color:" + _s.youtubeAndFolderVideoTitleColor_str + ";'>" + item['name'] + "</p><p class='fwduvp-ytb-info-p' style='color:" + _s.youtubeDescriptionColor_str + ";'>" + item['description'] + "</p>";
                obj.downloadable = false;
                try{
                    obj.thumbSource = item['pictures']['sizes'][2]['link'];
                }catch(e){}
                obj.posterSource =  "none";
            
                obj.downloadable = false;
                _s.playlist_ar.push(obj);
            }

            if(_s.randomizePlaylist_bl){
                _s.playlist_ar = FWDUVPUtils.randomizeArray(_s.playlist_ar);
            }
        
            if(_s.maxPlaylistItems < _s.playlist_ar.length){
                _s.playlist_ar = _s.playlist_ar.splice(0, _s.maxPlaylistItems);
            }
            
            clearTimeout(_s.dispatchPlaylistLoadCompleteWidthDelayId_to);
            _s.dispatchPlaylistLoadCompleteWidthDelayId_to = setTimeout(function(){
                _s.dispatchEvent(FWDUVPData.PLAYLIST_LOAD_COMPLETE);
            }, 50);
    
            _s.isDataLoaded_bl = true;
        }
        

        //##########################################//
        /* load youtube list */
        //##########################################//
        _s.loadYoutubePlaylist = function(url){
            if(_s.isPlaylistDispatchingError_bl && !_s.isYoutbe_bl) return;
        
            _s.isChannel = url.indexOf('channel/') != -1;
            _s.url = url;
            if(!_s.youtubeUrl_str){
                if(url.indexOf('list=')  != -1){
                    var rx = /list=(.*?)(?:&|$)/i;
                    var arr = rx.exec(url);
                }else{
                    var rx = /channel\/(.*?)(?:&|$)/i;
                    var arr = rx.exec(url);
                }
                
                url = arr[1];
                _s.youtubeUrl_str = url;
            }
            
            if(_s.nextPageToken_str){
                if(_s.isChannel){
                    _s.sourceURL_str = "https://www.googleapis.com/youtube/v3/search?part=snippet&pageToken=" + _s.nextPageToken_str + "&channelId=" + _s.youtubeUrl_str + "&key=" + _s.youtubeAPIKey + "&maxResults=50&callback=" + prt.instanceName_str + "._d.parseYoutubePlaylist";
                }else{
                    _s.sourceURL_str = "https://www.googleapis.com/youtube/v3/playlistItems?part=snippet&pageToken=" + _s.nextPageToken_str + "&playlistId=" + _s.youtubeUrl_str + "&key=" + _s.youtubeAPIKey + "&maxResults=50&callback=" + prt.instanceName_str + "._d.parseYoutubePlaylist";
                }
                
            }else{
                if(_s.isChannel){
                    _s.sourceURL_str = "https://www.googleapis.com/youtube/v3/search?part=snippet&channelId=" + _s.youtubeUrl_str + "&key=" + _s.youtubeAPIKey + "&maxResults=50&callback=" + prt.instanceName_str + "._d.parseYoutubePlaylist";
                }else{
                    _s.sourceURL_str = "https://www.googleapis.com/youtube/v3/playlistItems?part=snippet&playlistId=" + _s.youtubeUrl_str + "&key=" + _s.youtubeAPIKey + "&maxResults=50&callback=" + prt.instanceName_str + "._d.parseYoutubePlaylist";
                }
            }
            
            if(_s.scs_el == null){
                try{
                    _s.scs_el = document.createElement('script');
                    _s.scs_el.src = _s.sourceURL_str;
                    _s.scs_el.id = prt.instanceName_str + "._d.parseYoutubePlaylist";
                    document.documentElement.appendChild(_s.scs_el);
                }catch(e){}
            }
            _s.JSONPRequestTimeoutId_to = setTimeout(function(){
                var err;
                if(_s.isChannel){
                    err = 'channel';
                }
                _s.JSONPRequestTimeoutError("Error loading youtube " + err + "!<font color='#ff0000'>" + _s.youtubeUrl_str + "</font>");
            }, 6000);
        
        };
        
        _s.JSONPRequestTimeoutError = function(text){
            _s.stopToLoadPlaylist();
            _s.isPlaylistDispatchingError_bl = true;
            var showLoadPlaylistErrorId_to = setTimeout(function(){
                _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:text});
                _s.isPlaylistDispatchingError_bl = false;
            }, 50);
            return;
        };
        
        _s.resetYutubeVimeoPlaylistLoader = function(){
            _s.isYoutbe_bl = false;
            _s.youtubeObject_ar = null;
            _s.vimeoObject_ar = null;
            _s.nextPageToken_str = null;
            _s.youtubeUrl_str = null;
        };

        
        //######################################//
        /* Handle ajax response */
        //######################################//
        _s.ajaxOnErrorHandler = function(e){
            try{
                if(window.console) console.log(e);
                if(window.console) console.log(e.message);
            }catch(e){};
            if(_s.isVimeoAlbum_bl){
                _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Error loading vimeo album! <font color='#ff0000'>" + _s.vimeoAlbumURL + "</font>"});
            }else if(_s.loadFromFolder_bl){
                _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Error loading file : <font color='#ff0000'>" + _s.proxyFolderPath_str + "</font>. Make sure the path is correct"});
            }else{
                _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Error loading file : <font color='#ff0000'>" + _s.proxyPath_str + "</font>. Make sure the path is correct"});
            }
        };
        
        _s.ajaxOnLoadHandler = function(e){
            var response;
            var isXML = false;
            
            if(_s.xhr.readyState == 4){
                if(_s.xhr.status == 404){
                    if(_s.isVimeoAlbum_bl){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Error loading vimeo album! <font color='#ff0000'>" + _s.vimeoAlbumURL + "</font>"});
                    }else if(_s.loadFromFolder_bl){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Folder proxy file path is not found: <font color='#ff0000'>" + _s.proxyFolderPath_str + "</font>"});
                    }else{
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Proxy file path is not found: <font color='#ff0000'>" + _s.proxyPath_str + "</font>"});
                    }
                    
                }else if(_s.xhr.status == 408){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Server has timeout!"});
                }else if(_s.xhr.status == 200){
                    if(_s.xhr.responseText.indexOf("<b>Warning</b>:") != -1){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Error loading folder: <font color='#ff0000'>" + _s.sourceURL_str + "</font>. Make sure that the folder path is correct!"});
                        return;
                    }
                    
                    if(window.JSON){
                        response = JSON.parse(_s.xhr.responseText);
                    }else{
                        response = eval('('+ _s.xhr.responseText +')');
                    }
                
                    if(response.body){
                        _s.parseVimeoPlaylist(response);
                    }else if(response.folder){
                        _s.parseFolderJSON(response);
                    }else if(response.li){
                        _s.parseXML(response);
                    }else if(response.error){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Error loading file: <font color='#ff0000'>" + _s.sourceURL_str + "</font>. Make sure the file path (xml or podcast) is correct and well formatted!"});
                    }
                }
            }
        };
        
        _s.parseYoutubePlaylist = function(object){
            
            if(_s.isPlaylistDispatchingError_bl || !_s.isYoutbe_bl) return;
            if(object.error){
                var err;
                if(_s.isChannel){
                    err = 'channel';
                }
                _s.JSONPRequestTimeoutError("Error loading youtube " + err + "! <font color='#ff0000'>" + _s.youtubeUrl_str + "</font>");
                if(console) console.log(object);
                return;
            }
            
            _s.playlist_ar = [];
            var tt;
            var item;
            var videoSource;
            
            if(!_s.youtubeObject_ar){
                _s.youtubeObject_ar = [];
            }
            
            for(var i=0; i<object.items.length; i++){
                _s.youtubeObject_ar.push(object.items[i]);
            }
            
            tt = _s.youtubeObject_ar.length;
            
            _s.stopToLoadPlaylist();
            
            if(object.nextPageToken){
                _s.nextPageToken_str = object.nextPageToken;
                _s.loadYoutubePlaylist(_s.url);
                return;
            }
            
            for(var i=0; i< tt; i++){
                
                var obj = {};
                item = _s.youtubeObject_ar[i];
                if(item.snippet.thumbnails){
                    if(_s.isChannel){
                        obj.videoSource = item.id.videoId;
                    }else{
                        obj.videoSource = item.snippet.resourceId.videoId;
                    }
                    
                    obj.startAtVideo = 0;
                    obj.videoSource = [{source:"https://www.youtube.com/watch?v=" + obj.videoSource}];
                    obj.owner = item.snippet.channelTitle;
                    obj.gaStr =  item.snippet.title;

                    if(window['isWhite']){
                        _s.youtubeAndFolderVideoTitleColor_str = '#000000';
                    }else if(window['isDark']){
                        _s.youtubeAndFolderVideoTitleColor_str = '#FFFFFF';
                    }
                    
                    obj.title = "<p class='ytbChangeColor fwduvp-ytb-title' style='color:" + _s.youtubeAndFolderVideoTitleColor_str + ";'>" + item.snippet.title + "</p>";
                    var desc = item.snippet.description;
                    if(obj.title.length > 190){
                        desc = desc.substr(0, 20);
                    }else if(obj.title.length > 165){
                        desc = desc.substr(0, 60);
                    }else{
                        desc = desc.substr(0, 90);
                    }
                    
                    desc = desc.substr(0, desc.lastIndexOf(" ")) + " ...";
                    obj.title += "<p class='fwduvp-ytb-p' style='color:" + _s.youtubeOwnerColor_str + ";'> " + desc + "</p>";
                
                    obj.titleText = item.snippet.title;
                    obj.titleText = item.snippet.title;
                    obj.desc = undefined;
                    
                    obj.desc = "<p class='fwduvp-ytb-info-title' style='color:" + _s.youtubeAndFolderVideoTitleColor_str + ";'>" + item.snippet.title + "</p><p class='fwduvp-ytb-info-p' style='color:" + _s.youtubeDescriptionColor_str + ";'>" + item.snippet.description + "</p>";
                
                    obj.downloadable = false;
                
                    try{
                        obj.thumbSource = item.snippet.thumbnails["default"].url;
                        if(_s.showOnlyThumbnail){
                            if(item.snippet.thumbnails["standard"]){
                                obj.thumbSource = item.snippet.thumbnails["standard"].url;
                            }else if(item.snippet.thumbnails["high"]){
                                obj.thumbSource = item.snippet.thumbnails["high"].url;
                            }
                        }
                    }catch(e){}
                    obj.posterSource =  "none";
                    
                    if(item.snippet.title.indexOf("eleted video") == -1 && item.snippet.title.indexOf("his video is unavailable") == -1){
                        _s.playlist_ar.push(obj);
                    }
                }
            }

            if(_s.randomizePlaylist_bl){
                _s.playlist_ar = FWDUVPUtils.randomizeArray(_s.playlist_ar);
            }
        
            if(_s.maxPlaylistItems < _s.playlist_ar.length){
                _s.playlist_ar = _s.playlist_ar.splice(0, _s.maxPlaylistItems);
            }

            _s.plsCache_ar[_s.id] = _s.playlist_ar;
            
            _s.youtubePlLoadComplete();
        };

        _s.youtubePlLoadComplete = function(){
            clearTimeout(_s.dispatchPlaylistLoadCompleteWidthDelayId_to);
            _s.dispatchPlaylistLoadCompleteWidthDelayId_to = setTimeout(function(){
                _s.dispatchEvent(FWDUVPData.PLAYLIST_LOAD_COMPLETE);
            }, 50);
            _s.isDataLoaded_bl = true;
        }
        
            
        _s.isDataLoaded_bl = true;
        
        _s.setYoutubePlaylistHEXColor = function(color){
            _s.youtubeAndFolderVideoTitleColor_str = color;
        }
        
        _s.closeJsonPLoader = function(){
            clearTimeout(_s.JSONPRequestTimeoutId_to);
        };
        

        //##########################################//
        /* parse DOM playlist */
        //##########################################//
        _s.parseDOMPlaylist = function(element, id){
            if(_s.isPlaylistDispatchingError_bl) return;
        
            var children_ar = FWDUVPUtils.getChildren(element);
            var totalChildren = children_ar.length;
            var child;
            var has360Video = false;
            _s.playlist_ar = [];
            
            if(totalChildren == 0){
                var showLoadPlaylistErrorId_to = setTimeout(function(){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"At least one video is required in the playlist with id: <font color='#ff0000'>" + id + "</font>"});
                    _s.isPlaylistDispatchingError_bl = false;
                }, 50);
                return;
            }
            
            for(var i=0; i<totalChildren; i++){
                var obj = {};
                var adsObj;
                child = children_ar[i];
                
                if(!FWDUVPUtils.hasAttribute(child, "data-thumb-source")){
                    _s.isPlaylistDispatchingError_bl = true;
                    var showLoadPlaylistErrorId_to = setTimeout(function(){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Attribute <font color='#ff0000'>data-thumb-source</font> is required in the playlist at position <font color='#ff0000'>" + (i + 1)});
                    }, 50);
                    return;
                }
                
                if(!FWDUVPUtils.hasAttribute(child, "data-video-source")){
                    _s.isPlaylistDispatchingError_bl = true;
                    var showLoadPlaylistErrorId_to = setTimeout(function(){
                        _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Attribute <font color='#ff0000'>data-video-source</font> is required in the playlist at position <font color='#ff0000'>" + (i + 1)});
                    }, 50);
                    return;
                }
                
                obj.thumbSource = encodeURI(FWDUVPUtils.getAttributeValue(child, "data-thumb-source"));
                
                obj.videoSource = FWDUVPUtils.getAttributeValue(child, "data-video-source");
                obj._dPlaybackRate  = FWDUVPUtils.getAttributeValue(child, "data-playback-rate");
                obj.startAtVideo = FWDUVPUtils.getAttributeValue(child, "data-start-at-video") || 0;
                obj.isLive = FWDUVPUtils.getAttributeValue(child, "data-is-live");
                obj.atb = FWDUVPUtils.getAttributeValue(child, "data-use-a-to-b") == "yes" ? true : false;
                obj.thumbnailsPreview = FWDUVPUtils.getAttributeValue(child, "data-thumbnails-preview");
                if(!_s.useAToB) obj.atb = false;
                
                if(obj.isLive == "yes"){
                    obj.isLive = true;
                }else{
                    obj.isLive = false;
                }
                
                obj.isPrivate = FWDUVPUtils.getAttributeValue(child, "data-is-private");
                if(obj.isPrivate == "yes"){
                    obj.isPrivate = true;
                }else{
                    obj.isPrivate = false;
                }

                obj.redirectURL = FWDUVPUtils.getAttributeValue(child, "data-redirect-url");
                obj.redirectTarget = FWDUVPUtils.getAttributeValue(child, "data-redirect-target");
                obj.privateVideoPassword_str = FWDUVPUtils.getAttributeValue(child, "data-private-video-password");
                obj.startAtTime = FWDUVPUtils.getAttributeValue(child, "data-start-at-time");
                if(obj.startAtTime == "00:00:00" || !FWDUVPUtils.checkTime(obj.startAtTime)) obj.startAtTime = undefined;
                
                obj.stopAtTime = FWDUVPUtils.getAttributeValue(child, "data-stop-at-time");
                if(obj.stopAtTime == "00:00:00" || !FWDUVPUtils.checkTime(obj.stopAtTime)) obj.stopAtTime = undefined;
                
                if(obj.videoSource.indexOf("{source:") != -1){
                    
                    try{
                        obj.videoLabels_ar = [];
                        obj.videoSource = eval(obj.videoSource);
                        for(var m=0; m<obj.videoSource.length; m++){
                            obj.videoLabels_ar[m] = obj.videoSource[m]["label"];
                        }
                        for(var m=0; m<obj.videoSource.length; m++){
                            var src = obj.videoSource[m].source;
                            if(src.indexOf("encrypt:") != -1) src = atob(src.substr(8));
                            obj.videoSource[m].source = FWDUVPUtils.getValidSource(src);

                            var mm = obj.videoSource[m].startWhenPlayButtonClick360DegreeVideo;
                            if(mm == "yes"){
                                mm = true;
                            }else{
                                mm = false;
                            }
                            obj.videoSource[m].startWhenPlayButtonClick360DegreeVideo = mm;

                            var rr = obj.videoSource[m].rotationY360DegreeVideo;
                            if(rr != undefined){
                                rr = Number(obj.videoSource[m].rotationY360DegreeVideo);
                            }else{
                                rr = -90;
                            }
                            obj.videoSource[m].rotationY360DegreeVideo = rr;
                        }

                        for(var m=0; m<obj.videoSource.length; m++){
                            obj.videoSource[m].is360 = obj.videoSource[m]['is360'];
                            if(obj.videoSource[m].is360 == "yes") obj.videoSource[m].is360 = true;
                            if(obj.videoSource[m].is360 == "no") obj.videoSource[m].is360 = false;
                            if(obj.videoSource[m].is360 == true) has360Video = true;
                        }
                        
                        obj.videoLabels_ar.reverse();
                    }catch(e){
                        _s.isPlaylistDispatchingError_bl = true;
                        var showLoadPlaylistErrorId_to = setTimeout(function(){
                            _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Please make sure that the <font color='#ff0000'>data-video-source</font> attribute contains an array of videos at position <font color='#ff0000'>" + (i + 1) + "</font>"});
                        }, 50);
                        return;
                    }
                }else{
                    src = obj.videoSource;
                    if(src.indexOf("encrypt:") != -1) src = atob(src.substr(8));
                    obj.videoSource = [{source:FWDUVPUtils.getValidSource(src)}];
                }
            
                if(FWDUVPUtils.hasAttribute(child, "data-subtitle-soruce")){
                    obj.subtitleSource = FWDUVPUtils.getAttributeValue(child, "data-subtitle-soruce");
                    if(obj.subtitleSource.indexOf("{source:") != -1){
                        obj.startAtSubtitle = FWDUVPUtils.getAttributeValue(child, "data-start-at-subtitle") || 0;
                        if(obj.subtitleSource.indexOf("{source:") != -1){
                            try{
                                obj.subtitleSource = eval(obj.subtitleSource);
                            }catch(e){
                                _s.isPlaylistDispatchingError_bl = true;
                                var showLoadPlaylistErrorId_to = setTimeout(function(){
                                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Please make sure that the <font color='#ff0000'>data-subtitle-source</font> attribute contains an array of subtitles at position <font color='#ff0000'>" + (i + 1) + "</font>"});
                                }, 50);
                                return;
                            }
                            obj.subtitleSource.splice(0,0, {source:"none", label:_s.subtitlesOffLabel_str});
                            obj.subtitleSource.reverse();
                        }
                    }else{
                        obj.subtitleSource = [{source:obj.subtitleSource}];
                    }
                    if(obj.subtitleSource){
                        for(var x=0; x<obj.subtitleSource.length; x++){
                            var source = obj.subtitleSource[x].source;
                            if(source.indexOf("encrypt:") != -1) obj.subtitleSource[x].source = atob(source.substr(8));
                        }
                    }
                }
                
                obj._dAdvertisementOnPauseSource  = FWDUVPUtils.getAttributeValue(child, "data-advertisement-on-pause-source");
                obj.scrubAtTimeAtFirstPlay = FWDUVPUtils.getAttributeValue(child, "data-scrub-at-time-at-first-play") || "none";
                if(/^((?:[01]\d|2[0-3]):[0-5]\d:[0-5]\d$)/g.test(obj.scrubAtTimeAtFirstPlay)){
                    obj.scrubAtTimeAtFirstPlay = FWDUVPUtils.getSecondsFromString(obj.scrubAtTimeAtFirstPlay);
                }else{
                    obj.scrubAtTimeAtFirstPlay = undefined;
                }
                
                if(FWDUVPUtils.hasAttribute(child, "data-poster-source")){
                    obj.posterSource = encodeURI(FWDUVPUtils.getAttributeValue(child, "data-poster-source"));
                }else{
                    obj.posterSource = "none";
                }
            
                obj.downloadPath = obj.videoSource[obj.startAtVideo];
                
                if(FWDUVPUtils.hasAttribute(child, "data-downloadable") && _s.showDownloadVideoButton_bl){
                    obj.downloadable = FWDUVPUtils.getAttributeValue(child, "data-downloadable") == "yes" ? true : false;
                    if(obj.downloadPath.source.indexOf(".") ==  -1)  obj.downloadable = false;
                }else{
                    obj.downloadable = false;
                }

                if(FWDUVPUtils.hasAttribute(child, "data-play-if-logged-in")){
                    obj.playIfLoggedIn = FWDUVPUtils.getAttributeValue(child, "data-play-if-logged-in");
                    if(obj.playIfLoggedIn == 'no') obj.playIfLoggedIn = undefined;
                }
                
                //video popup adds and annotations
                var annotations_ar;
                var mainPopupAds_ar = FWDUVPUtils.getChildren(child);
                var tempPopupAds_ar;
                var popupAds_ar;
                var popupOrAnnotationChild;
                var finalPopupChild;
                var popupObj;
                
                for(var k=0; k<mainPopupAds_ar.length; k++){
                    
                    popupOrAnnotationChild = mainPopupAds_ar[k];    
                    if(FWDUVPUtils.hasAttribute(popupOrAnnotationChild, "data-add-popup")){
                        tempPopupAds_ar = FWDUVPUtils.getChildren(popupOrAnnotationChild);
                        popupAds_ar = [];
                        for(var x=0; x<tempPopupAds_ar.length; x++){
                            finalPopupChild = tempPopupAds_ar[x];
                            if(finalPopupChild){
                                popupObj = {};
                                popupObj.source = FWDUVPUtils.getValidSource(FWDUVPUtils.getAttributeValue(finalPopupChild, "data-image-path"));
                                popupObj.timeStart = FWDUVPUtils.getSecondsFromString(FWDUVPUtils.getAttributeValue(finalPopupChild, "data-time-start"));
                                popupObj.timeEnd = FWDUVPUtils.getSecondsFromString(FWDUVPUtils.getAttributeValue(finalPopupChild, "data-time-end"));
                                popupObj.link = FWDUVPUtils.getAttributeValue(finalPopupChild, "data-link");
                                popupObj.target = FWDUVPUtils.getAttributeValue(finalPopupChild, "data-target");
                                popupObj.google_ad_width = parseInt(FWDUVPUtils.getAttributeValue(finalPopupChild, "data-google-ad-width")) || 600;
                                popupObj.google_ad_height = parseInt(FWDUVPUtils.getAttributeValue(finalPopupChild, "data-google-ad-height")) || 200;
                                popupObj.google_ad_client = FWDUVPUtils.getAttributeValue(finalPopupChild, "data-google-ad-client");
                                popupObj.google_ad_slot = FWDUVPUtils.getAttributeValue(finalPopupChild, "data-google-ad-slot");
                                popupAds_ar.push(popupObj);
                            }
                        }
                        
                        obj.popupAds_ar = popupAds_ar;
                    }
                    
                    //ads
                    if(FWDUVPUtils.hasAttribute(popupOrAnnotationChild, "data-ads")){
                        var adsData_ar = FWDUVPUtils.getChildren(popupOrAnnotationChild);
                        var ads_ar = [];
                    
                        var adsChild;
                        var tt = adsData_ar.length;
                        
                        for(var m=0; m<tt; m++){
                            var adsObj = {};
                            adsChild = adsData_ar[m];
                            
                            adsObj.timeStart = FWDUVPUtils.getSecondsFromString(FWDUVPUtils.getAttributeValue(adsChild, "data-time-start"));
                            if(FWDUVPUtils.hasAttribute(adsChild, "data-add-duration")){
                                adsObj.addDuration = FWDUVPUtils.getSecondsFromString(FWDUVPUtils.getAttributeValue(adsChild, "data-add-duration"));
                            }
                            
                            adsObj.thumbnailSource = FWDUVPUtils.getAttributeValue(adsChild, "data-thumbnail-source");
                            if(adsObj.thumbnailSource == "" || adsObj.thumbnailSource == " ") adsObj.thumbnailSource = undefined;
                            
                            adsObj.timeToHoldAds = parseInt(FWDUVPUtils.getAttributeValue(adsChild, "data-time-to-hold-ads") || 4);
                            adsObj.source = FWDUVPUtils.getValidSource(FWDUVPUtils.getAttributeValue(adsChild,"data-source"));
                            adsObj.link = FWDUVPUtils.getAttributeValue(adsChild,"data-link");
                            adsObj.target = FWDUVPUtils.getAttributeValue(adsChild,"data-target");
                            
                            ads_ar[m] = adsObj
                        }
                        
                        obj.ads_ar = ads_ar
                    }
                    
                    if(FWDUVPUtils.hasAttribute(child, "data-vast-url")){
                        obj.ads_ar = undefined;
                        var vsrc = FWDUVPUtils.getAttributeValue(child, "data-vast-url");
                        
                        if(FWDUVPUtils.isIMA(vsrc)){
                            obj.imaURL = vsrc;
                        }else{
                            obj.vastURL = vsrc;
                            obj.vastClickTroughTarget = FWDUVPUtils.getAttributeValue(child, "data-vast-clicktrough-target") || "_blank";
                            obj.vastLinearStartTime = FWDUVPUtils.getAttributeValue(child, "data-vast-linear-astart-at-time") || "00:00:00";
                        }
                    }
                
                    //cuepoints
                    if(FWDUVPUtils.hasAttribute(popupOrAnnotationChild, "data-cuepoints")){
                        var cuepointsData_ar = FWDUVPUtils.getChildren(popupOrAnnotationChild);
                        var cuepoints_ar = [];
                    
                        var cuepointsChild;
                        var tt = cuepointsData_ar.length;
                        
                        for(var m=0; m<tt; m++){
                            var cuepointsObj = {};
                            cuepointsChild = cuepointsData_ar[m];
                            
                            cuepointsObj.timeStart = FWDUVPUtils.getSecondsFromString(FWDUVPUtils.getAttributeValue(cuepointsChild, "data-time-start"));
                            cuepointsObj.javascriptCall = FWDUVPUtils.getAttributeValue(cuepointsChild, "data-javascript-call");
                            cuepointsObj.isPlayed_bl = false;
                            cuepoints_ar[m] = cuepointsObj
                        }
                        
                        obj.cuepoints_ar = cuepoints_ar
                    }
                    
                    //annotation
                    if(FWDUVPUtils.hasAttribute(popupOrAnnotationChild, "data-annotations")){
                        annotations_ar = FWDUVPUtils.getChildren(popupOrAnnotationChild);
                
                        var annotationChild;
                        var tt = annotations_ar.length;
                        
                        for(var m=0; m<tt; m++){
                            var annotationObj = {};
                            annotationChild = annotations_ar[m];
                            
                            annotationObj.start = FWDUVPUtils.getSecondsFromString(FWDUVPUtils.getAttributeValue(annotationChild, "data-start-time"));
                            annotationObj.end = FWDUVPUtils.getSecondsFromString(FWDUVPUtils.getAttributeValue(annotationChild, "data-end-time"));
                            annotationObj.left = parseInt(FWDUVPUtils.getAttributeValue(annotationChild, "data-left"), 10);
                            annotationObj.top = parseInt(FWDUVPUtils.getAttributeValue(annotationChild, "data-top"), 10);
                            
                            annotationObj.showCloseButton_bl = FWDUVPUtils.getAttributeValue(annotationChild, "data-show-close-button") == "yes" ? true : false; 
                            annotationObj.clickSource = FWDUVPUtils.getAttributeValue(annotationChild, "data-click-source");
                            annotationObj.clickSourceTarget = FWDUVPUtils.getAttributeValue(annotationChild, "data-click-source-target");
                    
                            annotationObj.normalStateClass = FWDUVPUtils.getAttributeValue(annotationChild, "data-normal-state-class");
                            annotationObj.selectedStateClass = FWDUVPUtils.getAttributeValue(annotationChild, "data-selected-state-class");
                            
                            annotationObj.content = annotationChild.innerHTML;
                            
                            annotations_ar[m] = annotationObj
                        }
                        
                        obj.annotations_ar = annotations_ar
                    }
                }
                
                //video description
                var descChidren_ar = FWDUVPUtils.getChildren(child);
                var descChild;
                obj.title = "not defined!";
                obj.titleText = "not defined!";
                
                for(var k=0; k<descChidren_ar.length; k++){
                    descChild = descChidren_ar[k];  
                    if(FWDUVPUtils.hasAttribute(descChild, "data-video-short-description")){
                        obj.title =  descChild.innerHTML;
                        obj.titleText = descChild.textContent;
                        obj.titleText = obj.titleText.replace(/^\s+/g, '')
                        
                    }else if(FWDUVPUtils.hasAttribute(descChild, "data-video-long-description")){
                        obj.desc = descChild.innerHTML;
                    }
                }
            
                var gaStr = obj.titleText.split('\n')
                for(var x=0; x<gaStr.length; x++){
                
                    if(gaStr[x].length > 2){
                        obj.gaStr = gaStr[x];
                        break;
                    }
                }
                
                if(FWDUVPUtils.hasAttribute(child, "data-ads-source")){
                    adsObj = {};
                    adsObj.source = FWDUVPUtils.getValidSource(FWDUVPUtils.getAttributeValue(child, "data-ads-source"));
                    adsObj.pageToOpen = FWDUVPUtils.getAttributeValue(child, "data-ads-page-to-open-url");
                    adsObj.pageTarget = FWDUVPUtils.getAttributeValue(child, "data-ads-page-target") || "_blank";
                    adsObj.timeToHoldAds = parseInt(FWDUVPUtils.getAttributeValue(child, "data-time-to-hold-ads")) || 0;
                    obj.ads = adsObj;
                }
            
                _s.playlist_ar[i] = obj;
            }

            if(_s.randomizePlaylist_bl){
                _s.playlist_ar = FWDUVPUtils.randomizeArray(_s.playlist_ar);
            }
        
            if(_s.maxPlaylistItems < _s.playlist_ar.length){
                _s.playlist_ar = _s.playlist_ar.splice(0, _s.maxPlaylistItems);
            }
        
            clearTimeout(_s.dispatchPlaylistLoadCompleteWidthDelayId_to);
            _s.dispatchPlaylistLoadCompleteWidthDelayId_to = setTimeout(function(){
                _s.dispatchEvent(FWDUVPData.PLAYLIST_LOAD_COMPLETE);
            }, 50);
    
            _s.isDataLoaded_bl = true;
        };
        

        //####################################//
        /* parse folder JSON */
        //####################################//
        _s.parseFolderJSON = function(response){
            _s.playlist_ar = [];
            var obj;
            var obj_ar = response.folder;
            var counter = 0;
            if(obj_ar && !obj_ar.length){
                _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Please make sure the folder exists and it has video or audio files in it: <font color='#ff0000'>" + encodeURIComponent(_s.sourceURL_str) + "</font>"});
                return;
            }

            for(var i=0; i<obj_ar.length; i++){
                obj = {};
                obj.videoSource = encodeURI(obj_ar[i]["@attributes"]["data-video-path"]);
                
                obj.videoSource =  obj_ar[i]["@attributes"]["data-video-path"];
                obj._dPlaybackRate  = obj_ar[i]["@attributes"]["data-playback-rate"];
                obj.startAtVideo = obj_ar[i]["@attributes"]["data-start-at-video"] || 0;
                obj.videoSource = [{source:FWDUVPUtils.getValidSource(obj.videoSource)}];
                obj.thumbSource = encodeURI(obj_ar[i]["@attributes"]["data-thumb-path"]);
                obj.posterSource = encodeURI(obj_ar[i]["@attributes"]["data-poster-path"]);
                obj.downloadPath = encodeURIComponent(obj_ar[i]["@attributes"]["download-path"]);
                
                obj.downloadable = _s.showDownloadVideoButton_bl;
                if(_s.forceDisableDownloadButtonForFolder_bl) obj.downloadable = false;
                obj.titleText = "...";
                obj.title = "<p class='fwduvp-thumbnail-title' style='color:" + _s.youtubeAndFolderVideoTitleColor_str + "'>...</p>";
                    
                obj.titleText = obj_ar[i]["@attributes"]["data-title"];
                obj.title = "<p class='fwduvp-thumbnail-title' style='color:" + _s.youtubeAndFolderVideoTitleColor_str + "'>" + obj_ar[i]["@attributes"]["data-title"] + "</p>";
                obj.desc = undefined;
                
                _s.playlist_ar[i] = obj;
            }

            if(_s.randomizePlaylist_bl){
                _s.playlist_ar = FWDUVPUtils.randomizeArray(_s.playlist_ar);
            }
        
            if(_s.maxPlaylistItems < _s.playlist_ar.length){
                _s.playlist_ar = _s.playlist_ar.splice(0, _s.maxPlaylistItems);
            }
            
            clearTimeout(_s.dispatchPlaylistLoadCompleteWidthDelayId_to);
            _s.dispatchPlaylistLoadCompleteWidthDelayId_to = setTimeout(function(){
                _s.dispatchEvent(FWDUVPData.PLAYLIST_LOAD_COMPLETE);
            }, 50);
    
            _s.isDataLoaded_bl = true;
        };
        

        //####################################//
        /* parse xml JSON */
        //####################################//
        _s.parseXML = function(response){
            _s.playlist_ar = [];
            var obj;
            var obj_ar = response.li;
            var has360Video = false;
            
            if(!obj_ar.length) obj_ar = [obj_ar];
            
            for(var i=0; i<obj_ar.length; i++){
                obj = {};
                
                obj.videoSource =  obj_ar[i]["@attributes"]["data-video-source"];
                obj.startAtVideo = obj_ar[i]["@attributes"]["data-start-at-video"] || 0;

                obj.startWhenPlayButtonClick360DegreeVideo =  obj_ar[i]["@attributes"]["data-start-when-play-button-click-60D-degree-video"];
                if(obj.startWhenPlayButtonClick360DegreeVideo == 'yes') obj.startWhenPlayButtonClick360DegreeVideo = true;
                obj.rotationY360DegreeVideo =obj_ar[i]["@attributes"]["data-rotation-y-360-degree-video"];
                if(obj.rotationY360DegreeVideo === undefined) obj.rotationY360DegreeVideo = -90;
                obj.isLive = obj_ar[i]["@attributes"]["data-is-live"];
                obj.atb = obj_ar[i]["@attributes"]["data-use-a-to-b"] == "yes" ? true : false;
                if(!_s.useAToB) obj.atb = false;
                                    
                obj.isPrivate = obj_ar[i]["@attributes"]["data-is-private"]; 
                if(obj.isPrivate == "yes"){
                    obj.isPrivate = true;
                }else{
                    obj.isPrivate = false;
                }

                if(obj_ar[i]["@attributes"]["data-play-if-logged-in"]){
                    obj.playIfLoggedIn = obj_ar[i]["@attributes"]["data-play-if-logged-in"];
                    if(obj.playIfLoggedIn == 'no') obj.playIfLoggedIn = undefined;
                }
                
                obj.privateVideoPassword_str =  obj_ar[i]["@attributes"]["data-private-video-password"];
                
                obj.startAtTime =  obj_ar[i]["@attributes"]["data-start-at-time"];
                if(obj.startAtTime == "00:00:00" || !FWDUVPUtils.checkTime(obj.startAtTime)) obj.startAtTime = undefined;
                
                obj.stopAtTime =  obj_ar[i]["@attributes"]["data-stop-at-time"];
                if(obj.stopAtTime == "00:00:00" || !FWDUVPUtils.checkTime(obj.stopAtTime)) obj.stopAtTime = undefined;
                
                if(obj.videoSource.indexOf("{source:") != -1){
    
                    try{
                        obj.videoLabels_ar = [];
                        obj.videoSource = eval(obj.videoSource);
                        
                        for(var m=0; m<obj.videoSource.length; m++){
                            obj.videoLabels_ar[m] = obj.videoSource[m]["label"];
                        }
                        
                        for(var m=0; m<obj.videoSource.length; m++){
                            var src = obj.videoSource[m].source;
                            if(src.indexOf("encrypt:") != -1) src = atob(src.substr(8));
                            obj.videoSource[m].source = FWDUVPUtils.getValidSource(src);
                        }
                        
                        for(var m=0; m<obj.videoSource.length; m++){
                            obj.videoSource[m].is360 = obj.videoSource[m]['is360'];
                            if(obj.videoSource[m].is360 == "yes") obj.videoSource[m].is360 = true;
                            if(obj.videoSource[m].is360 == "no") obj.videoSource[m].is360 = false;
                            if(obj.videoSource[m].is360 == true) has360Video = true;
                        }
                                
                        obj.videoLabels_ar.reverse();
                    }catch(e){
                        _s.isPlaylistDispatchingError_bl = true;
                        var showLoadPlaylistErrorId_to = setTimeout(function(){
                            _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Please make sure that the <font color='#ff0000'>data-video-source</font> attribute contains an array of videos at position <font color='#ff0000'>" + (i + 1) + "</font>"});
                        }, 50);
                        return;
                    }
                }else{
                    var src = obj.videoSource;
                    if(src.indexOf("encrypt:") != -1) src = atob(src.substr(8));
                    obj.videoSource = [{source:FWDUVPUtils.getValidSource(src)}];
                }
                
                obj.subtitleSource =  obj_ar[i]["@attributes"]["data-subtitle-soruce"];
                obj.startAtSubtitle = obj_ar[i]["@attributes"]["data-start-at-subtitle"] || 0;
                if(obj.subtitleSource){
                    if(obj.subtitleSource.indexOf("{source:") != -1){
                        if(obj.subtitleSource.indexOf("{source:") != -1){
                            try{
                                obj.subtitleSource = eval(obj.subtitleSource);
                                if(obj.subtitleSource.indexOf("encrypt:") != -1) obj.subtitleSource = atob(src.substr(8));
                            }catch(e){
                                _s.isPlaylistDispatchingError_bl = true;
                                var showLoadPlaylistErrorId_to = setTimeout(function(){
                                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"Please make sure that the <font color='#ff0000'>data-subtitle-source</font> attribute contains an array of subtitles at position <font color='#ff0000'>" + (i + 1) + "</font>"});
                                }, 50);
                                return;
                            }
                            obj.subtitleSource.splice(0,0, {source:"none", label:_s.subtitlesOffLabel_str});
                            obj.subtitleSource.reverse();
                        }
                    }else{
                        obj.subtitleSource = [{source:obj.subtitleSource}];
                    }
                    if(obj.subtitleSource){
                        for(var x=0; x<obj.subtitleSource.length; x++){
                            var source = obj.subtitleSource[x].source;
                            if(source.indexOf("encrypt:") != -1) obj.subtitleSource[x].source = atob(source.substr(8));
                        }
                    }
                }
                
                obj._dAdvertisementOnPauseSource  = obj_ar[i]["@attributes"]["data-advertisement-on-pause-source"];
                obj.scrubAtTimeAtFirstPlay =  obj_ar[i]["@attributes"]["data-scrub-at-time-at-first-play"];
                if(obj.scrubAtTimeAtFirstPlay){
                    if(/^((?:[01]\d|2[0-3]):[0-5]\d:[0-5]\d$)/g.test(obj.scrubAtTimeAtFirstPlay)){
                        obj.scrubAtTimeAtFirstPlay = FWDUVPUtils.getSecondsFromString(obj.scrubAtTimeAtFirstPlay);
                    }
                }
                
                obj.downloadPath = obj.videoSource[obj.startAtVideo];
                obj.downloadable = obj_ar[i]["@attributes"]["data-downloadable"] == "yes" ? true : false;
                if(obj.videoSource[0]["source"].indexOf(".") == -1) obj.downloadable = false;
                obj.posterSource = encodeURI(obj_ar[i]["@attributes"]["data-poster-source"]);
                obj.thumbSource = obj_ar[i]["@attributes"]["data-thumb-source"];
                obj.title = obj_ar[i]["@attributes"]["data-title"];
                obj.titleText = obj_ar[i]["@attributes"]["data-title"];
                obj.desc = obj_ar[i]["@attributes"]["data-desc"];
                
                obj.gaStr = obj.titleText;
                
                //ads
                if(obj_ar[i]["@attributes"]["data-ads-source"]){
                    var adsObj = {};
                    adsObj.source = FWDUVPUtils.getValidSource(obj_ar[i]["@attributes"]["data-ads-source"]);
                    adsObj.pageToOpen = obj_ar[i]["@attributes"]["data-ads-page-to-open-url"];
                    adsObj.pageTarget = obj_ar[i]["@attributes"]["data-ads-page-target"] || "_blank";
                    adsObj.timeToHoldAds = obj_ar[i]["@attributes"]["data-time-to-hold-ads"]  || 0;
                    obj.ads = adsObj;
                }

                //vast
                if(obj_ar[i]["@attributes"]["data-vast-url"]){
                    obj.ads_ar = undefined;
                    var vsrc = obj_ar[i]["@attributes"]["data-vast-url"];
                    
                    if(FWDUVPUtils.isIMA(vsrc)){
                        obj.imaURL = vsrc;
                    }else{
                        obj.vastURL = vsrc;
                        obj.vastClickTroughTarget = obj_ar[i]["@attributes"]["data-vast-clicktrough-target"];
                        obj.vastLinearStartTime = obj_ar[i]["@attributes"]["data-vast-linear-astart-at-time"] || "00:00:00";
                    }
                }

                //cuepoints

                if(obj_ar[i]["@attributes"]["data-cuepoints"]){
                    adsObj = {};
                    adsObj.timeStart = obj_ar[i]["@attributes"]["data-time-start"];
                    adsObj.javascriptCall = obj_ar[i]["@attributes"]["data-javascript-call"];
                    adsObj.isPlayed_bl = false
                    obj.cuepoints_ar = adsObj;
                }
            
                _s.playlist_ar[i] = obj;
            }
            
            if(_s.randomizePlaylist_bl){
                _s.playlist_ar = FWDUVPUtils.randomizeArray(_s.playlist_ar);
            }
        
            if(_s.maxPlaylistItems < _s.playlist_ar.length){
                _s.playlist_ar = _s.playlist_ar.splice(0, _s.maxPlaylistItems);
            }
                
            clearTimeout(_s.dispatchPlaylistLoadCompleteWidthDelayId_to);
            _s.dispatchPlaylistLoadCompleteWidthDelayId_to = setTimeout(function(){
                _s.dispatchEvent(FWDUVPData.PLAYLIST_LOAD_COMPLETE);
            }, 50);
    
            _s.isDataLoaded_bl = true;
        };
        

        //####################################//
        /* load vast */
        //####################################//
        _s.setVastSource = function(source, startTime){
            if(!_s.vastLoaded_bl){
                _s.vastScript = document.createElement('script');
                var scriptURI = _s.scripts[_s.countLoadedSCript];
                document.head.appendChild(_s.vastScript);
                _s.vastScript.src =  _s.mainFolderPath_str + 'java/FWDUVPVast.js';
                
                _s.vastScript.onload = function(){
                    FWDUVPVast.setPrototype();
                    _s.vast = new FWDUVPVast(_s);
                    _s.vast.setSource(source, startTime);
                }
                
                _s.vastScript.onerror = function(e){
                    _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:'VAST js plugin named <font color="#FF0000">FWDUVPVast.js</font> is not found. Please make sure that the content folder contains the java folder that contains the <font color="#FF0000">FWDUVPVast.js</font> file. '});
                }
                _s.vastLoaded_bl = true;
                return;
            }
            _s.vast.setSource(source);
        }
        
        _s.closeVast = function(){
            if(_s.vast) _s.vast.closeVast();
        }
        
        _s.fixVmapTimes = function(duration, curAddData, curPopupAdsData, id){
            if(_s.vast) _s.vast.fixVmapTimes(duration, curAddData, curPopupAdsData, id); 
        }
        
        _s.resetVastId = function(){
            if(_s.vast) _s.vast.id = -1;
        }
        
        
        //####################################//
        /* show error if a required property is not defined */
        //####################################//
        _s.showPropertyError = function(error){
            _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"The property called <font color='#FF0000'>" + error + "</font> is not defined."});
        };
        
        
        //####################################//
        /* stop to load current playlist... */
        //####################################//
        _s.stopToLoadPlaylist = function(){
            _s.closeJsonPLoader();
            try{
                _s.scs_el.src = null;
                document.documentElement.removeChild(_s.scs_el);
                _s.scs_el = null;
            }catch(e){}
            
            if(_s.xhr != null){
                try{_s.xhr.abort();}catch(e){}
                _s.xhr.onreadystatechange = null;
                _s.xhr.onerror = null;
                _s.xhr = null;
            }
        };
        

        //####################################//
        /* show error if a required property is not defined */
        //####################################//
        _s.showPropertyError = function(error){
            _s.dispatchEvent(FWDUVPData.LOAD_ERROR, {text:"The property called <font color='#ff0000'>" + error + "</font> is not defined."});
        };
        
        _s.init();
    };
    

    /* set prototype */
    FWDUVPData.setPrototype = function(){
        FWDUVPData.prototype = new FWDUVPEventDispatcher();
    };
    
    FWDUVPData.VAST_LOADING = 'vastLoading';
    FWDUVPData.VAST_LOADED = "vastLoaded";
    FWDUVPData.PLAYLIST_LOAD_COMPLETE = "playlistLoadComplete";
    FWDUVPData.PRELOADER_LOAD_DONE = "onPreloaderLoadDone";
    FWDUVPData.LOAD_DONE = "onLoadDone";
    FWDUVPData.LOAD_ERROR = "onLoadError";
    FWDUVPData.IMAGE_LOADED = "onImageLoaded";
    FWDUVPData.SKIN_LOAD_COMPLETE = "onSkinLoadComplete";
    FWDUVPData.SKIN_PROGRESS = "onSkinProgress";
    FWDUVPData.IMAGES_PROGRESS = "onImagesPogress";
    FWDUVPData.IMA_READY = 'imaReady';
    FWDUVPData.IMA_ERROR = 'ima_error';
    
    window.FWDUVPData = FWDUVPData;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Display object.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
    /*
     * @ type values: div, img.
     * @ positon values: relative, absolute.
     * @ positon values: hidden.
     * @ display values: block, inline-block, _s applies only if the position is relative.
     */
    var FWDUVPDisplayObject = function(type, position, overflow, display){

        'use strict';
        
        var _s = this;
        _s.listeners = {events_ar:[]};
        
        if(type == "div" || type == "img" || type == "canvas" || "input"){
            _s.type = type; 
        }else{
            throw Error("Type is not valid! " + type);
        }
    
        _s.children_ar = [];
        _s.position = position || "absolute";
        _s.overflow = overflow || "hidden";
        _s.display = display || "inline-block";
        _s.visible = true;
        _s.buttonMode;
        _s.x = 0;
        _s.y = 0;
        _s.w = 0;
        _s.h = 0;
        _s.rect;
        _s.alpha = 1;
        _s.innerHTML = "";
        _s.opacityType = "";
        
        _s.hasTransform3d_bl =  FWDUVPUtils.hasTransform3d;
        _s.hasTransform2d_bl =  FWDUVPUtils.hasTransform2d;
        _s.hasBeenSetSelectable_bl = false;
        

        //##############################//
        /* init */
        //#############################//
        _s.init = function(){
            _s.setScreen();
        };  

        
        //######################################//
        /* check if it supports transforms. */
        //######################################//
        _s.getTransform = function() {
            var properties = ['transform', 'msTransform', 'WebkitTransform', 'MozTransform', 'OTransform'];
            var p;
            while (p = properties.shift()) {
               if (typeof _s.screen.style[p] !== 'undefined') {
                    return p;
               }
            }
            return false;
        };
        

        //######################################//
        /* set opacity type */
        //######################################//
        _s.getOpacityType = function(){
            var opacityType;
            if (typeof _s.screen.style.opacity != "undefined") {//ie9+ 
                opacityType = "opacity";
            }else{ //ie8
                opacityType = "filter";
            }
            return opacityType;
        };

        
        //######################################//
        /* setup main screen */
        //######################################//
        _s.setScreen = function(element){
            if(_s.type == "img" && element){
                _s.screen = null;
                _s.screen = element;
                _s.setMainProperties();
            }else{
                _s.screen = document.createElement(_s.type);
                _s.setMainProperties();
            }
        };
        

        //########################################//
        /* set main properties */
        //########################################//
        _s.setMainProperties = function(){
            
            _s.transform = _s.getTransform();
            _s.setPosition(_s.position);
            _s.setOverflow(_s.overflow);
            _s.opacityType = _s.getOpacityType();
            
            if(_s.opacityType == "opacity") _s.isHtml5_bl = true;
            
            if(_s.opacityType == "filter") _s.screen.style.filter = "inherit";
            _s.screen.style.left = "0px";
            _s.screen.style.top = "0px";
            _s.screen.style.margin = "0px";
            _s.screen.style.padding = "0px";
            _s.screen.style.maxWidth = "none";
            _s.screen.style.maxHeight = "none";
            _s.screen.style.border = "none";
            _s.screen.style.lineHeight = "1";
            _s.screen.style.backfaceVisibility = "hidden";
            _s.screen.style.webkitBackfaceVisibility = "hidden";
            _s.screen.style.MozBackfaceVisibility = "hidden";
            
            if(type == "img"){
                _s.setWidth(_s.screen.width);
                _s.setHeight(_s.screen.height);
            }
        };
            
        _s.setBackfaceVisibility =  function(){
            _s.screen.style.backfaceVisibility = "visible";
            _s.screen.style.webkitBackfaceVisibility = "visible";
            _s.screen.style.MozBackfaceVisibility = "visible";      
        };

        
        //###################################################//
        /* set / get various peoperties.*/
        //###################################################//
        _s.setSelectable = function(val){
            
            if(!val){
                _s.screen.style.userSelect = "none";
                _s.screen.style.MozUserSelect = "none";
                _s.screen.style.webkitUserSelect = "none";
                _s.screen.style.khtmlUserSelect = "none";
                _s.screen.style.oUserSelect = "none";
                _s.screen.style.msUserSelect = "none";
                _s.screen.msUserSelect = "none";
                _s.screen.ondragstart = function(e){return false;};
                _s.screen.onselectstart = function(){return false;};
                _s.screen.ontouchstart = function(){return false;};
                _s.screen.style.webkitTouchCallout='none';
                _s.hasBeenSetSelectable_bl = true;
            }else{
                if(FWDUVPUtils.isFirefox || FWDUVPUtils.isIE){
                    _s.screen.style.userSelect = "element";
                    _s.screen.style.MozUserSelect = "element";
                    _s.screen.style.msUserSelect = "element";
                }else if(FWDUVPUtils.isSafari){
                    _s.screen.style.userSelect = "text";
                    _s.screen.style.webkitUserSelect = "text";
                }else{
                    _s.screen.style.userSelect = "auto";
                    _s.screen.style.webkitUserSelect = "auto";
                }
                
                _s.screen.style.khtmlUserSelect = "auto";
                _s.screen.style.oUserSelect = "auto";
                
                if(FWDUVPUtils.isIEAndLessThen9){
                    _s.screen.ondragstart = null;
                    _s.screen.onselectstart = null;
                    _s.screen.ontouchstart = null;
                }else{
                    _s.screen.ondragstart = undefined;
                    _s.screen.onselectstart = undefined;
                    _s.screen.ontouchstart = undefined;
                }
                
                _s.screen.style.webkitTouchCallout='default';
                _s.hasBeenSetSelectable_bl = false;
            }
            
        };
        
        _s.getScreen = function(){
            return _s.screen;
        };
        
        _s.setVisible = function(val){
            _s.visible = val;
            if(_s.visible == true){
                _s.screen.style.visibility = "visible";
            }else{
                _s.screen.style.visibility = "hidden";
            }
        };
        
        _s.getVisible = function(){
            return _s.visible;
        };
            
        _s.setResizableSizeAfterParent = function(){
            _s.screen.style.width = "100%";
            _s.screen.style.height = "100%";
        };
        
        _s.getStyle = function(){
            return _s.screen.style;
        };
        
        _s.setOverflow = function(val){
            _s.overflow = val;
            _s.screen.style.overflow = _s.overflow;
        };
        
        _s.setPosition = function(val){
            _s.position = val;
            _s.screen.style.position = _s.position;
        };
        
        _s.setDisplay = function(val){
            _s.display = val;
            _s.screen.style.display = _s.display;
        };
        
        _s.setButtonMode = function(val){
            _s.buttonMode = val;
            if(_s.buttonMode ==  true){
                _s.screen.style.cursor = "pointer";
            }else{
                _s.screen.style.cursor = "default";
            }
        };
        
        _s.setBkColor = function(val){
            _s.screen.style.backgroundColor = val;
        };
        
        _s.setInnerHTML = function(val){
            _s.innerHTML = val;
            _s.screen.innerHTML = _s.innerHTML;
        };
        
        _s.getInnerHTML = function(){
            return _s.innerHTML;
        };
        
        _s.getRect = function(){
            return _s.screen.getBoundingClientRect();
        };
        
        _s.setAlpha = function(val){
            _s.alpha = val;
            if(_s.opacityType == "opacity"){
                _s.screen.style.opacity = _s.alpha;
            }else if(_s.opacityType == "filter"){
                _s.screen.style.filter = "alpha(opacity=" + _s.alpha * 100 + ")";
                _s.screen.style.filter = "progid:DXImageTransform.Microsoft.Alpha(Opacity=" + Math.round(_s.alpha * 100) + ")";
            }
        };
        
        _s.getAlpha = function(){
            return _s.alpha;
        };
        
        _s.getRect = function(){
            return _s.screen.getBoundingClientRect();
        };
        
        _s.getGlobalX = function(){
            return _s.getRect().left;
        };
        
        _s.getGlobalY = function(){
            return _s.getRect().top;
        };
        
        _s.setX = function(val){
            _s.x = val;
            if(_s.hasTransform3d_bl){
                _s.screen.style[_s.transform] = 'translate3d(' + _s.x + 'px,' + _s.y + 'px,0)';
            }else if(_s.hasTransform2d_bl){
                _s.screen.style[_s.transform] = 'translate(' + _s.x + 'px,' + _s.y + 'px)';
            }else{
                _s.screen.style.left = _s.x + "px";
            }
        };
        
        _s.getX = function(){
            return  _s.x;
        };
        
        _s.setY = function(val){
            _s.y = val;
            if(_s.hasTransform3d_bl){
                _s.screen.style[_s.transform] = 'translate3d(' + _s.x + 'px,' + _s.y + 'px,0)'; 
            }else if(_s.hasTransform2d_bl){
                _s.screen.style[_s.transform] = 'translate(' + _s.x + 'px,' + _s.y + 'px)';
            }else{
                _s.screen.style.top = _s.y + "px";
            }
        };
        
        _s.getY = function(){
            return  _s.y;
        };
        
        _s.setWidth = function(val){
            _s.w = val;
            if(_s.type == "img"){
                _s.screen.width = _s.w;
                _s.screen.style.width = _s.w + "px";
            }else{
                _s.screen.style.width = _s.w + "px";
            }
        };
        
        _s.getWidth = function(){
            if(_s.type == "div" || _s.type == "input"){
                if(_s.screen.offsetWidth != 0) return  _s.screen.offsetWidth;
                return _s.w;
            }else if(_s.type == "img"){
                if(_s.screen.offsetWidth != 0) return  _s.screen.offsetWidth;
                if(_s.screen.width != 0) return  _s.screen.width;
                return _s._w;
            }else if( _s.type == "canvas"){
                if(_s.screen.offsetWidth != 0) return  _s.screen.offsetWidth;
                return _s.w;
            }
        };
        
        _s.setHeight = function(val){
            _s.h = val;
            if(_s.type == "img"){
                _s.screen.height = _s.h;
                _s.screen.style.height = _s.h + "px";
            }else{
                _s.screen.style.height = _s.h + "px";
            }
        };
        
        _s.getHeight = function(){
            if(_s.type == "div" || _s.type == "input"){
                if(_s.screen.offsetHeight != 0) return  _s.screen.offsetHeight;
                return _s.h;
            }else if(_s.type == "img"){
                if(_s.screen.offsetHeight != 0) return  _s.screen.offsetHeight;
                if(_s.screen.height != 0) return  _s.screen.height;
                return _s.h;
            }else if(_s.type == "canvas"){
                if(_s.screen.offsetHeight != 0) return  _s.screen.offsetHeight;
                return _s.h;
            }
        };
        

        //#####################################//
        /* DOM list */
        //#####################################//
        _s.addChild = function(e){
            if(_s.contains(e)){ 
                _s.children_ar.splice(FWDUVPUtils.indexOfArray(_s.children_ar, e), 1);
                _s.children_ar.push(e);
                _s.screen.appendChild(e.screen);
            }else{
                _s.children_ar.push(e);
                _s.screen.appendChild(e.screen);
            }
        };
        
        _s.removeChild = function(e){
            if(_s.contains(e)){
                _s.children_ar.splice(FWDUVPUtils.indexOfArray(_s.children_ar, e), 1);
                _s.screen.removeChild(e.screen);
            }else{
                throw Error("##removeChild()## Child dose't exist, it can't be removed!");
            };
        };
        
        _s.contains = function(e){
            if(FWDUVPUtils.indexOfArray(_s.children_ar, e) == -1){
                return false;
            }else{
                return true;
            }
        };
        
        _s.addChildAt = function(e, index){
            if(_s.getNumChildren() == 0){
                _s.children_ar.push(e);
                _s.screen.appendChild(e.screen);
            }else if(index == 1){
                _s.screen.insertBefore(e.screen, _s.children_ar[0].screen);
                _s.screen.insertBefore(_s.children_ar[0].screen, e.screen); 
                if(_s.contains(e)){
                    _s.children_ar.splice(FWDUVPUtils.indexOfArray(_s.children_ar, e), 1, e);
                }else{
                    _s.children_ar.splice(FWDUVPUtils.indexOfArray(_s.children_ar, e), 0, e);
                }
            }else{
                if(index < 0  || index > _s.getNumChildren() -1) throw Error("##getChildAt()## Index out of bounds!");
                
                _s.screen.insertBefore(e.screen, _s.children_ar[index].screen);
                if(_s.contains(e)){
                    _s.children_ar.splice(FWDUVPUtils.indexOfArray(_s.children_ar, e), 1, e);
                }else{
                    _s.children_ar.splice(FWDUVPUtils.indexOfArray(_s.children_ar, e), 0, e);
                }
            }
        };
        
        _s.getChildAt = function(index){
            if(index < 0  || index > _s.getNumChildren() -1) throw Error("##getChildAt()## Index out of bounds!");
            if(_s.getNumChildren() == 0) throw Error("##getChildAt## Child dose not exist!");
            return _s.children_ar[index];
        };
        
        _s.getChildIndex = function(child){
            if(_s.contains(child)){
                return FWDUVPUtils.indexOfArray(_s.children_ar, child);
            }
            return 0;
        };
        
        _s.removeChildAtZero = function(){
            _s.screen.removeChild(_s.children_ar[0].screen);
            _s.children_ar.shift();
        };
        
        _s.getNumChildren = function(){
            return _s.children_ar.length;
        };
        
        
        //################################//
        /* event dispatcher */
        //#################################//
        _s.addListener = function (type, listener){
            
            if(type == undefined) throw Error("type is required.");
            if(typeof type === "object") throw Error("type must be of type String.");
            if(typeof listener != "function") throw Error("listener must be of type Function.");
            
            
            var event = {};
            event.type = type;
            event.listener = listener;
            event.target = _s;
            _s.listeners.events_ar.push(event);
        };
        
        _s.dispatchEvent = function(type, props){
            if(_s.listeners == null) return;
            if(type == undefined) throw Error("type is required.");
            if(typeof type === "object") throw Error("type must be of type String.");
            
            for (var i=0, len=_s.listeners.events_ar.length; i < len; i++){
                if(_s.listeners.events_ar[i].target === _s && _s.listeners.events_ar[i].type === type){     
                    if(props){
                        for(var prop in props){
                            _s.listeners.events_ar[i][prop] = props[prop];
                        }
                    }
                    _s.listeners.events_ar[i].listener.call(_s, _s.listeners.events_ar[i]);
                }
            }
        };
        
        _s.removeListener = function(type, listener){
            
            if(type == undefined) throw Error("type is required.");
            if(typeof type === "object") throw Error("type must be of type String.");
            if(typeof listener != "function") throw Error("listener must be of type Function." + type);
            
            for (var i=0, len=_s.listeners.events_ar.length; i < len; i++){
                if(_s.listeners.events_ar[i].target === _s 
                        && _s.listeners.events_ar[i].type === type
                        && _s.listeners.events_ar[i].listener ===  listener
                ){
                    _s.listeners.events_ar.splice(i,1);
                    break;
                }
            }  
        };
        

        //###########################################//
        /* destroy methods*/
        //###########################################//
        _s.disposeImage = function(){
            if(_s.type == "img") _s.screen.src = null;
        };
        
        
        _s.destroy = function(){
            
            if(_s.hasBeenSetSelectable_bl){
                _s.screen.ondragstart = null;
                _s.screen.onselectstart = null;
                _s.screen.ontouchstart = null;
            };
            
            _s.screen.removeAttribute("style");
            
            //destroy properties
            _s.listeners = [];
            _s.listeners = null;
            _s.children_ar = [];
            _s.children_ar = null;
            _s.style = null;
            _s.screen = null;
            _s.transform = null;
            _s.position = null;
            _s.overflow = null;
            _s.display = null;
            _s.visible = null;
            _s.buttonMode = null;
            _s.x = null;
            _s.y = null;
            _s.w = null;
            _s.h = null;
            _s.rect = null;
            _s.alpha = null;
            _s.innerHTML = null;
            _s.opacityType = null;
            _s.isHtml5_bl = null;
        
            _s.hasTransform3d_bl = null;
            _s.hasTransform2d_bl = null;
            _s = null;
        };
        
        /* init */
        _s.init();
    };
    
    window.FWDUVPDisplayObject = FWDUVPDisplayObject;
}(window));/**
 * Easy Video Player PACKAGED v8.4
 * Embed window.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
    
    var FWDUVPEmbedWindow = function(_d, prt){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPEmbedWindow.prototype;
        
        _s.embedColoseN_img = _d.embedColoseN_img;  
        _s.useHEX = _d.useHEX;
        _s.nBC = _d.nBC
        _s.sBC = _d.sBC;

        _s.embedWindowBackground_str = _d.embedWindowBackground_str;
        _s.embedWindowInputBackgroundPath_str = _d.embedWindowInputBackgroundPath_str;
        _s.secondaryLabelsColor_str = _d.secondaryLabelsColor_str;
        _s.inputColor_str = _d.inputColor_str;
        _s.mainLabelsColor_str = _d.mainLabelsColor_str;
        _s.sendButtonNPath_str = _d.sendButtonNPath_str;
        _s.sendButtonSPath_str = _d.sendButtonSPath_str;
        _s.inputBackgroundColor_str = _d.inputBackgroundColor_str;
        _s.borderColor_str = _d.borderColor_str;
        _s.sendToAFriendPath_str = _d.sendToAFriendPath_str;
        
        _s.maxTextWidth = 0;
        _s.totalWidth = 0;
        _s.sW = 0;
        _s.sH = 0;
        _s.buttonWidth = 44;
        _s.buttonHeight = 19;
        _s.embedWindowCloseButtonMargins = _d.embedWindowCloseButtonMargins;

        _s.shareAndEmbedTextColor_str = _d.shareAndEmbedTextColor_str;

        _s.isMbl = FWDUVPUtils.isMobile;
        _s.useVectorIcons_bl = _d.useVectorIcons_bl
    

        //#################################//
        /* init */
        //#################################//
        _s.init = function(){
            if(_s.clsBtn) return;
            if(_d.sknPth.indexOf("hex_white") != -1){
                _s.sBC = "#FFFFFF";
            } 
        
            _s.setBackfaceVisibility();
            _s.mainHld = new FWDUVPDisplayObject("div");
            
            _s.bk_do = new FWDUVPDisplayObject("div");
            _s.bk_do.getStyle().width = "100%";
            _s.bk_do.getStyle().height = "100%";
            _s.bk_do.setAlpha(.9);
            _s.bk_do.getStyle().background = "url('" + _s.embedWindowBackground_str + "')";
        
            //setup link and embed text
            _s.linkAndEmbedHld =  new FWDUVPDisplayObject("div");
            
            _s.lnkAndEbdHldBk = new FWDUVPDisplayObject("div");
            _s.lnkAndEbdHldBk.getStyle().background = "url('" + _s.embedWindowBackground_str + "')";
            _s.lnkAndEbdHldBk.getStyle().borderStyle = "solid";
            _s.lnkAndEbdHldBk.getStyle().borderWidth = "1px";
            _s.lnkAndEbdHldBk.getStyle().borderColor =  _s.borderColor_str;
            
            _s.mainLbl = new FWDUVPDisplayObject("div");
            _s.mainLbl.setBackfaceVisibility();
            _s.mainLbl.getStyle().fontFamily = "Arial";
            _s.mainLbl.getStyle().fontSize= "12px";
            _s.mainLbl.getStyle().color = _s.mainLabelsColor_str;
            _s.mainLbl.getStyle().whiteSpace= "nowrap";
            _s.mainLbl.getStyle().fontSmoothing = "antialiased";
            _s.mainLbl.getStyle().webkitFontSmoothing = "antialiased";
            _s.mainLbl.getStyle().textRendering = "optimizeLegibility";
            _s.mainLbl.getStyle().padding = "0px";
            _s.mainLbl.screen.className = 'UVP-main-label';
            _s.mainLbl.setInnerHTML("SHARE & EMBED");   
            
            _s.linkLbl = new FWDUVPDisplayObject("div");
            _s.linkLbl.screen.className = 'UVP-secnd-label';
            _s.linkLbl.setBackfaceVisibility();
            _s.linkLbl.getStyle().fontFamily = "Arial";
            _s.linkLbl.getStyle().fontSize= "12px";
            _s.linkLbl.getStyle().color = _s.secondaryLabelsColor_str;
            _s.linkLbl.getStyle().whiteSpace= "nowrap";
            _s.linkLbl.getStyle().fontSmoothing = "antialiased";
            _s.linkLbl.getStyle().webkitFontSmoothing = "antialiased";
            _s.linkLbl.getStyle().textRendering = "optimizeLegibility";
            _s.linkLbl.getStyle().padding = "0px";
            _s.linkLbl.setInnerHTML("Link to _s video:");   
            
            _s.linkTxt = new FWDUVPDisplayObject("div");
            _s.linkTxt.screen.className = 'UVP-embed-inpt';
            _s.linkTxt.setBackfaceVisibility();
            _s.linkTxt.getStyle().fontFamily = "Arial";
            _s.linkTxt.getStyle().fontSize= "12px";
            _s.linkTxt.getStyle().color = _s.shareAndEmbedTextColor_str;
            if(!FWDUVPUtils.isIEAndLessThen9) _s.linkTxt.getStyle().wordBreak = "break-all";
            _s.linkTxt.getStyle().fontSmoothing = "antialiased";
            _s.linkTxt.getStyle().webkitFontSmoothing = "antialiased";
            _s.linkTxt.getStyle().textRendering = "optimizeLegibility";
            _s.linkTxt.getStyle().padding = "6px";
            _s.linkTxt.getStyle().paddingTop = "4px";
            _s.linkTxt.getStyle().paddingBottom = "4px";
            _s.linkTxt.getStyle().backgroundColor = _s.inputBackgroundColor_str;
            _s.linkTxt.screen.addEventListener('touchstart',function(){
                selectText(_s.linkTxt.screen);
            });
            
            _s.embedLbl = new FWDUVPDisplayObject("div");
            _s.embedLbl.setBackfaceVisibility();
            _s.embedLbl.screen.className = 'UVP-secnd-label';
            _s.embedLbl.getStyle().fontFamily = "Arial";
            _s.embedLbl.getStyle().fontSize= "12px";
            _s.embedLbl.getStyle().color = _s.secondaryLabelsColor_str;
            _s.embedLbl.getStyle().whiteSpace= "nowrap";
            _s.embedLbl.getStyle().fontSmoothing = "antialiased";
            _s.embedLbl.getStyle().webkitFontSmoothing = "antialiased";
            _s.embedLbl.getStyle().textRendering = "optimizeLegibility";
            _s.embedLbl.getStyle().padding = "0px";
            _s.embedLbl.setInnerHTML("Embed _s video:");
            
            _s.embdTxt = new FWDUVPDisplayObject("div");
            _s.embdTxt.screen.className = 'UVP-embed-inpt';
            _s.embdTxt.setBackfaceVisibility();
            if(!FWDUVPUtils.isIEAndLessThen9) _s.embdTxt.getStyle().wordBreak = "break-all";
            _s.embdTxt.getStyle().fontFamily = "Arial";
            _s.embdTxt.getStyle().fontSize= "12px";
            _s.embdTxt.getStyle().lineHeight = "16px";
            _s.embdTxt.getStyle().color = _s.shareAndEmbedTextColor_str;
            _s.embdTxt.getStyle().fontSmoothing = "antialiased";
            _s.embdTxt.getStyle().webkitFontSmoothing = "antialiased";
            _s.embdTxt.getStyle().textRendering = "optimizeLegibility";
            _s.embdTxt.getStyle().backgroundColor = _s.inputBackgroundColor_str;
            _s.embdTxt.getStyle().padding = "6px";
            _s.embdTxt.getStyle().paddingTop = "4px";
            _s.embdTxt.getStyle().paddingBottom = "4px";
            _s.embdTxt.screen.addEventListener('touchstart',function(){
                selectText(_s.embdTxt.screen);
            });
        
            //setup flash buttons
            FWDUVPSimpleSizeButton.setPrototype();
            _s.copyLinkBtn = new FWDUVPSimpleSizeButton(
                    _d.embedCopyButtonNPath_str,
                    _d.embedCopyButtonSPath_str,
                    _s.buttonWidth,
                    _s.buttonHeight,
                    _d.useHEX,
                    _d.nBC,
                    _d.sBC,
                    true
            );
            _s.copyLinkBtn.screen.style.position = 'absolute';
            _s.copyLinkBtn.addListener(FWDUVPSimpleSizeButton.CLICK, function(){
                _s.copyToClipboard(_s.linkTxt.screen);
            });

            FWDUVPSimpleSizeButton.setPrototype();
            _s.copyEmbedBtn = new FWDUVPSimpleSizeButton(
                    _d.embedCopyButtonNPath_str,
                    _d.embedCopyButtonSPath_str,
                    _s.buttonWidth,
                    _s.buttonHeight,
                    _d.useHEX,
                    _d.nBC,
                    _d.sBC,
                    true
            );
            
            _s.copyEmbedBtn.screen.style.position = 'absolute';
            _s.copyEmbedBtn.addListener(FWDUVPSimpleSizeButton.CLICK,function(){
                _s.copyToClipboard(_s.embdTxt.screen);
            });

            //setup send to a friend
            _s.sendMainHld =  new FWDUVPDisplayObject("div");
            
            _s.sendMainHldBk = new FWDUVPDisplayObject("div");
            _s.sendMainHldBk.getStyle().background = "url('" + _s.embedWindowBackground_str + "')";
            _s.sendMainHldBk.getStyle().borderStyle = "solid";
            _s.sendMainHldBk.getStyle().borderWidth = "1px";
            _s.sendMainHldBk.getStyle().borderColor =  _s.borderColor_str;
            
            _s.sendMainLbl = new FWDUVPDisplayObject("div");
            _s.sendMainLbl.setBackfaceVisibility();
            _s.sendMainLbl.getStyle().fontFamily = "Arial";
            _s.sendMainLbl.getStyle().fontSize= "12px";
            _s.sendMainLbl.getStyle().color = _s.mainLabelsColor_str;
            _s.sendMainLbl.getStyle().whiteSpace= "nowrap";
            _s.sendMainLbl.getStyle().fontSmoothing = "antialiased";
            _s.sendMainLbl.getStyle().webkitFontSmoothing = "antialiased";
            _s.sendMainLbl.getStyle().textRendering = "optimizeLegibility";
            _s.sendMainLbl.getStyle().padding = "0px";
            _s.sendMainLbl.screen.className = 'UVP-main-label';
            _s.sendMainLbl.setInnerHTML("SEND TO A FRIEND");    
            
            _s.yourEmailLabel_do = new FWDUVPDisplayObject("div");
            _s.yourEmailLabel_do.setBackfaceVisibility();
            _s.yourEmailLabel_do.screen.className = 'UVP-secnd-label';
            _s.yourEmailLabel_do.getStyle().fontFamily = "Arial";
            _s.yourEmailLabel_do.getStyle().fontSize= "12px";
            _s.yourEmailLabel_do.getStyle().color = _s.secondaryLabelsColor_str;
            _s.yourEmailLabel_do.getStyle().whiteSpace= "nowrap";
            _s.yourEmailLabel_do.getStyle().padding = "0px";
            _s.yourEmailLabel_do.setInnerHTML("Your email:");
            
            _s.yourEmailInpt = new FWDUVPDisplayObject("input");
            _s.yourEmailInpt.screen.className = 'UVP-embed-inpt';
            _s.yourEmailInpt.setBackfaceVisibility();
            _s.yourEmailInpt.getStyle().fontFamily = "Arial";
            _s.yourEmailInpt.getStyle().fontSize= "12px";
            _s.yourEmailInpt.getStyle().backgroundColor = _s.inputBackgroundColor_str;
            _s.yourEmailInpt.getStyle().color = _s.inputColor_str;
            _s.yourEmailInpt.getStyle().outline = 0;
            _s.yourEmailInpt.getStyle().whiteSpace= "nowrap";
            _s.yourEmailInpt.getStyle().padding = "6px";
            _s.yourEmailInpt.getStyle().paddingTop = "4px";
            _s.yourEmailInpt.getStyle().paddingBottom = "4px";
            
            _s.friendEmailLbl = new FWDUVPDisplayObject("div");
            _s.friendEmailLbl.setBackfaceVisibility();
            _s.friendEmailLbl.screen.className = 'UVP-secnd-label';
            _s.friendEmailLbl.getStyle().fontFamily = "Arial";
            _s.friendEmailLbl.getStyle().fontSize= "12px";
            _s.friendEmailLbl.getStyle().color = _s.secondaryLabelsColor_str;
            _s.friendEmailLbl.getStyle().whiteSpace= "nowrap";
            _s.friendEmailLbl.getStyle().padding = "0px";
            _s.friendEmailLbl.setInnerHTML("Your friend's email:");
            
            _s.friendEmailInpt = new FWDUVPDisplayObject("input");
            _s.friendEmailInpt.screen.className = 'UVP-embed-inpt';
            _s.friendEmailInpt.setBackfaceVisibility();
            _s.friendEmailInpt.getStyle().fontFamily = "Arial";
            _s.friendEmailInpt.getStyle().fontSize= "12px";
            _s.friendEmailInpt.getStyle().backgroundColor = _s.inputBackgroundColor_str;
            _s.friendEmailInpt.getStyle().color = _s.inputColor_str;
            _s.friendEmailInpt.getStyle().outline= 0;
            _s.friendEmailInpt.getStyle().whiteSpace= "nowrap";
            _s.friendEmailInpt.getStyle().padding = "6px";
            _s.friendEmailInpt.getStyle().paddingTop = "4px";
            _s.friendEmailInpt.getStyle().paddingBottom = "4px";    

            FWDUVPSimpleSizeButton.setPrototype();
            _s.sndBtn = new FWDUVPSimpleSizeButton(
                    _s.sendButtonNPath_str, 
                    _s.sendButtonSPath_str,
                    _s.buttonWidth,
                    _s.buttonHeight,
                    _s.useHEX,
                    _d.nBC,
                    _d.sBC,
                    true);
            _s.sndBtn.addListener(FWDUVPSimpleSizeButton.MOUSE_UP, _s.sendClickHandler);
            
        
            _s.infoText_do = new FWDUVPDisplayObject("div");
            _s.infoText_do.setBackfaceVisibility();
            _s.infoText_do.getStyle().fontFamily = "Arial";
            _s.infoText_do.getStyle().fontSize= "12px";
            _s.infoText_do.getStyle().color = _s.secondaryLabelsColor_str;
            _s.infoText_do.getStyle().whiteSpace= "nowrap";
            _s.infoText_do.getStyle().fontSmoothing = "antialiased";
            _s.infoText_do.getStyle().webkitFontSmoothing = "antialiased";
            _s.infoText_do.getStyle().textRendering = "optimizeLegibility";
            _s.infoText_do.getStyle().padding = "0px";
            _s.infoText_do.getStyle().paddingTop = "4px";
            _s.infoText_do.getStyle().textAlign = "center";
            _s.infoText_do.getStyle().color = _s.mainLabelsColor_str;
            
            //setup close button
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.clsBtn = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<div class='table-fwduvp-button'><span class='table-cell-fwduvp-button fwdicon-close'></span></div>",
                        undefined,
                        "UVPCloseButtonNormalState",
                        "UVPCloseButtonSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.clsBtn = new FWDUVPSimpleButton(_d.embedColoseN_img, _d.embedWindowClosePathS_str, undefined,
                        true,
                        _d.useHEX,
                        _d.nBC,
                        _d.sBC,
                        false, false, false, false, true);
            }
            _s.clsBtn.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.closeButtonOnMouseUpHandler);
            
            _s.addChild(_s.mainHld);
            _s.mainHld.addChild(_s.bk_do)
            
            _s.linkAndEmbedHld.addChild(_s.lnkAndEbdHldBk);
            _s.linkAndEmbedHld.addChild(_s.mainLbl);
            _s.linkAndEmbedHld.addChild(_s.linkLbl);
            _s.linkAndEmbedHld.addChild(_s.linkTxt);
            _s.linkAndEmbedHld.addChild(_s.embedLbl);
            _s.linkAndEmbedHld.addChild(_s.embdTxt);
            _s.linkAndEmbedHld.addChild(_s.copyLinkBtn);
            _s.linkAndEmbedHld.addChild(_s.copyEmbedBtn);
            
            _s.sendMainHld.addChild(_s.sendMainHldBk);
            _s.sendMainHld.addChild(_s.sendMainLbl);
            _s.sendMainHld.addChild(_s.yourEmailLabel_do);
            _s.sendMainHld.addChild(_s.yourEmailInpt);
            _s.sendMainHld.addChild(_s.friendEmailLbl);
            _s.sendMainHld.addChild(_s.friendEmailInpt);
            _s.sendMainHld.addChild(_s.sndBtn);
            
            _s.mainHld.addChild(_s.linkAndEmbedHld);
            _s.mainHld.addChild(_s.sendMainHld);
            
            _s.mainHld.addChild(_s.clsBtn); 
        };
    
        _s.closeButtonOnMouseUpHandler = function(){
            if(!_s.isShowed_bl) return;
            _s.hide();
        };
    
        _s.copyToClipboard = function(element){
              selectText(element);
              document.execCommand("copy");
        }
    
        function selectText(element){
            if(window.top != window && FWDEVPUtils.isIE) return;
            if(!element) element = _s;
            
            var range, selection;
            if (document.body.createTextRange) {
                range = document.body.createTextRange();
                range.moveToElementText(element);
                range.select();
            }else if(window.getSelection && document.createRange) {
                selection = window.getSelection();
                range = document.createRange();
                range.selectNodeContents(element);
                selection.removeAllRanges();
                selection.addRange(range);
            }
        };
        
        _s.positionAndResize = function(){
            _s.sW = prt.sW;
            _s.sH = prt.sH;
            
            _s.maxTextWidth = Math.min(_s.sW - 150, 500);
            _s.totalWidth = _s.maxTextWidth + _s.buttonWidth + 40;
            
            if(_s.isMbl){
                _s.linkTxt.setWidth(_s.maxTextWidth + 52);
                _s.embdTxt.setWidth(_s.maxTextWidth + 52);
            }else{
                _s.linkTxt.setWidth(_s.maxTextWidth);
                _s.embdTxt.setWidth(_s.maxTextWidth);
            }
            
            _s.positionFinal();
            
            _s.clsBtn.setX(_s.sW - _s.clsBtn.w - _s.embedWindowCloseButtonMargins);
            _s.clsBtn.setY(_s.embedWindowCloseButtonMargins);
            
            _s.setWidth(_s.sW);
            _s.setHeight(_s.sH);
            _s.mainHld.setWidth(_s.sW);
            _s.mainHld.setHeight(_s.sH);
        };
        
        _s.positionFinal = function(){
            
            var totalHeight;
            var isEmbeddedAndFScreenOnIE11Bug_bl = false;
            
            if(_s.sH < 360 || _s.sW < 350){
                _s.linkTxt.getStyle().whiteSpace= "nowrap";
                _s.embdTxt.getStyle().whiteSpace= "nowrap";
            }else{
                _s.linkTxt.getStyle().whiteSpace = "normal";
                _s.embdTxt.getStyle().whiteSpace= "normal";
            }
            
            if(_s.linkLbl.screen.offsetHeight < 6) isEmbeddedAndFScreenOnIE11Bug_bl = true;
            
            var embedAndLinkMainLabelHeight;
            if(isEmbeddedAndFScreenOnIE11Bug_bl){
                embedAndLinkMainLabelHeight = Math.round(_s.mainLbl.screen.getBoundingClientRect().height * 100);
            }else{
                embedAndLinkMainLabelHeight = _s.mainLbl.getHeight();
            }
            _s.mainLbl.setX(16);
            _s.linkLbl.setX(16);
            _s.linkLbl.setY(embedAndLinkMainLabelHeight + 14);
            
            var linkTextLabelHeight;
            var linkTextHeight;
            if(isEmbeddedAndFScreenOnIE11Bug_bl){
                linkTextLabelHeight = Math.round(_s.linkLbl.screen.getBoundingClientRect().height * 100);
                linkTextHeight = Math.round(_s.linkTxt.screen.getBoundingClientRect().height * 100);
            }else{
                linkTextLabelHeight = _s.linkLbl.getHeight();
                linkTextHeight = _s.linkTxt.getHeight();
            }
            
            _s.linkTxt.setX(10);
            _s.linkTxt.setY(_s.linkLbl.y + linkTextLabelHeight + 5);
            if(_s.isMbl){
                _s.copyLinkBtn.setX(-100);
            }else{
                _s.copyLinkBtn.setX(_s.maxTextWidth + 30);
            }
            
            _s.copyLinkBtn.setY(_s.linkTxt.y + linkTextHeight - _s.buttonHeight);
            _s.embedLbl.setX(16);
            _s.embedLbl.setY(_s.copyLinkBtn.y + _s.copyLinkBtn.h + 14);
            
            var embedTextHeight;
            if(isEmbeddedAndFScreenOnIE11Bug_bl){
                embedTextHeight = Math.round(_s.embdTxt.screen.getBoundingClientRect().height * 100);
            }else{
                embedTextHeight = _s.embdTxt.getHeight();
            }
            _s.embdTxt.setX(10);
            _s.embdTxt.setY(_s.embedLbl.y + linkTextLabelHeight + 5);
            if(_s.isMbl){
                _s.copyEmbedBtn.setX(-100);
            }else{
                _s.copyEmbedBtn.setX(_s.maxTextWidth + 30);
            }
            _s.copyEmbedBtn.setY(_s.embdTxt.y + embedTextHeight - _s.buttonHeight);
            _s.lnkAndEbdHldBk.setY(_s.linkLbl.y - 9);
            _s.lnkAndEbdHldBk.setWidth(_s.totalWidth - 2);
            _s.lnkAndEbdHldBk.setHeight(_s.embdTxt.y + embedTextHeight - 9);
            _s.linkAndEmbedHld.setWidth(_s.totalWidth);
            _s.linkAndEmbedHld.setHeight(_s.embdTxt.y + embedTextHeight + 14);
            
            var sendMainLabelHeight;
            var inputHeight;
            if(isEmbeddedAndFScreenOnIE11Bug_bl){
                sendMainLabelHeight = Math.round(_s.sendMainLbl.screen.getBoundingClientRect().height * 100);
                inputHeight = Math.round(_s.yourEmailInpt.screen.getBoundingClientRect().height * 100);
            }else{
                sendMainLabelHeight = _s.sendMainLbl.getHeight();
                inputHeight = _s.yourEmailInpt.getHeight();
            }
            _s.sendMainLbl.setX(16);
            _s.yourEmailLabel_do.setX(16);
            _s.yourEmailLabel_do.setY(sendMainLabelHeight + 14);
            
            if(_s.sW > 400){
                _s.yourEmailInpt.setX(10);
                _s.yourEmailInpt.setWidth(parseInt(_s.totalWidth - 52 - _s.buttonWidth)/2);
                _s.yourEmailInpt.setY(_s.yourEmailLabel_do.y + linkTextLabelHeight + 5);
                
                _s.friendEmailLbl.setX(_s.yourEmailInpt.x + _s.yourEmailInpt.w + 26);
                _s.friendEmailLbl.setY(_s.yourEmailLabel_do.y);
                _s.friendEmailInpt.setX(_s.yourEmailInpt.x + _s.yourEmailInpt.w + 20);
                _s.friendEmailInpt.setWidth(parseInt((_s.maxTextWidth - 30)/2));
                _s.friendEmailInpt.setY(_s.yourEmailLabel_do.y + linkTextLabelHeight + 5);
                _s.sndBtn.setX(_s.friendEmailInpt.x + _s.yourEmailInpt.w + 10);
                _s.sndBtn.setY(_s.friendEmailInpt.y +inputHeight - _s.buttonHeight);
            }else{
                _s.yourEmailInpt.setX(10);
                _s.yourEmailInpt.setWidth(_s.totalWidth -32);
                _s.yourEmailInpt.setY(_s.yourEmailLabel_do.y + linkTextLabelHeight + 5);
                
                _s.friendEmailLbl.setX(16);
                _s.friendEmailLbl.setY(_s.yourEmailInpt.y + inputHeight + 14);
                _s.friendEmailInpt.setX(10);
                _s.friendEmailInpt.setY(_s.friendEmailLbl.y + linkTextLabelHeight + 5);
                _s.friendEmailInpt.setWidth(_s.totalWidth - 32);
                
                _s.sndBtn.setX(_s.totalWidth - _s.buttonWidth - 10);
                _s.sndBtn.setY(_s.friendEmailInpt.y + inputHeight + 10);
            }
            
            _s.sendMainHldBk.setY(_s.yourEmailLabel_do.y - 9);
            _s.sendMainHldBk.setWidth(_s.totalWidth - 2);
            _s.sendMainHldBk.setHeight(_s.sndBtn.y + _s.sndBtn.h - 9);
            _s.sendMainHld.setWidth(_s.totalWidth);
            _s.sendMainHld.setHeight(_s.sndBtn.y + _s.sndBtn.h + 14);
            
            if(isEmbeddedAndFScreenOnIE11Bug_bl){
                totalHeight = Math.round(_s.linkAndEmbedHld.screen.getBoundingClientRect().height * 100 + _s.sendMainHld.screen.getBoundingClientRect().height * 100);
            }else{
                totalHeight = _s.linkAndEmbedHld.getHeight() + _s.sendMainHld.getHeight();
            }
            
            _s.linkAndEmbedHld.setX(parseInt((_s.sW - _s.totalWidth)/2));
            _s.linkAndEmbedHld.setY(parseInt((_s.sH - totalHeight)/2) - 8);
            _s.sendMainHld.setX(parseInt((_s.sW - _s.totalWidth)/2));
            if(isEmbeddedAndFScreenOnIE11Bug_bl){
                _s.sendMainHld.setY(Math.round(_s.linkAndEmbedHld.y + _s.linkAndEmbedHld.screen.getBoundingClientRect().height * 100 + 20));
            }else{
                _s.sendMainHld.setY(_s.linkAndEmbedHld.y + _s.linkAndEmbedHld.getHeight() + 20);
            }
        };
        
        //##############################################//
        /* Send email */
        //##############################################//
        _s.sendClickHandler = function(){
            var hasError_bl = false;
            if(!_s.getValidEmail(_s.yourEmailInpt.screen.value)){
                if(FWDAnimation.isTweening(_s.yourEmailInpt.screen)) return;
                FWDAnimation.to(_s.yourEmailInpt.screen, .1, {css:{backgroundColor:'#FF0000'}, yoyo:true, repeat:3});
                hasError_bl = true;
            }
            if(!_s.getValidEmail(_s.friendEmailInpt.screen.value)){
                if(FWDAnimation.isTweening(_s.friendEmailInpt.screen)) return;
                FWDAnimation.to(_s.friendEmailInpt.screen, .1, {css:{backgroundColor:'#FF0000'}, yoyo:true, repeat:3});
                hasError_bl = true;
            }
            if(hasError_bl) return;
            _s.sendEmail();
        };
        
        
        //############ send email ####################//
        _s.sendEmail = function(){
            if(_s.isSending_bl) return;
            _s.isSending_bl = true;
            _s.xhr = new XMLHttpRequest();
            _s.xhr.onreadystatechange = _s.onChange;
            _s.xhr.onerror = _s.ajaxOnErrorHandler;
            
            try{
                _s.xhr.open("get", _s.sendToAFriendPath_str + "?friendMail=" + _s.friendEmailInpt.screen.value + "&yourMail=" + _s.yourEmailInpt.screen.value + "&link=" + encodeURI(_s.linkToVideo_str) , true);
                _s.xhr.send();
            }catch(e){
                _s.showInfo("ERROR", true);
                if(console) console.log(e);
                if(e.message && window.console) console.log(e.message);
            }
            _s.resetInputs();
        };
        
        _s.ajaxOnErrorHandler = function(e){
            _s.showInfo("ERROR", true);
            try{
                if(window.console) console.log(e);
                if(window.console) console.log(e.message);
            }catch(e){};
            _s.isSending_bl = false;
        };
        
        _s.onChange = function(response){
            if(_s.xhr.readyState == 4 && _s.xhr.status == 200){
                if(_s.xhr.responseText == "sent"){
                    _s.showInfo("SENT");
                }else{
                    _s.showInfo("ERROR", true);
                    if(window.console) console.log("Error The server can't send the email!");
                }
                _s.isSending_bl = false;
            }
        };
        
        _s.resetInputs = function(){
            _s.yourEmailInpt.screen.value = "";
            _s.friendEmailInpt.screen.value = "";
        };
    
        _s.getValidEmail = function(email){
            var emailRegExp = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
            if(!emailRegExp.test(email) || email == "") return false;
            return true;
        };

        
        //#############################################//
        /* Set embed data */
        //#############################################//
        _s.setEmbedData = function(){
        
            var allUrl = location.href;
            var host = location.protocol + "//" + location.host;
            var pathName = location.pathname;
            var hash = location.hash;
            var search = location.search;
            var pathWithoutHashOrSearch = host + pathName;
            
        
            search = search.replace(/&?UVPInstanceName=.+UVPVideoId=[0-9]+/g, "");
            allUrl = allUrl.replace(/&?UVPInstanceName=.+UVPVideoId=[0-9]+/g, "");
        
            if(search){
                if(hash){
                    _s.finalEmbedPath_str = pathWithoutHashOrSearch + search + "&UVPInstanceName=" + prt.instanceName_str + "&UVPPlaylistId=" + prt.catId + "&UVPVideoId=" + prt.id + hash;
                }else{
                    _s.finalEmbedPath_str = pathWithoutHashOrSearch + search + "&UVPInstanceName=" + prt.instanceName_str + "&UVPPlaylistId=" + prt.catId + "&UVPVideoId=" + prt.id;
                }
            }else{
                if(hash){
                    _s.finalEmbedPath_str = pathWithoutHashOrSearch + "?UVPInstanceName=" + prt.instanceName_str + "&UVPPlaylistId=" + prt.catId + "&UVPVideoId=" + prt.id + hash;
                }else{
                    _s.finalEmbedPath_str = pathWithoutHashOrSearch + "?UVPInstanceName=" + prt.instanceName_str + "&UVPPlaylistId=" + prt.catId + "&UVPVideoId=" + prt.id;
                }
            }
            
            if(hash){
                if(hash.indexOf("playlistId=") == -1){
                    _s.linkToVideo_str = pathWithoutHashOrSearch + search + hash + "&playlistId=" + prt.catId + "&videoId=" + prt.id;
                }else{
                    _s.linkToVideo_str = allUrl;
                }
            }else{
                _s.linkToVideo_str = allUrl + "#/?playlistId=" + prt.catId + "&videoId=" + prt.id;;
            }
    
            _s.finalEmbedPath_str = encodeURI(_s.finalEmbedPath_str);
            _s.linkToVideo_str = encodeURI(_s.linkToVideo_str); 
            _s.finalEmbedCode_str = "<iframe src='" + _s.finalEmbedPath_str + "' width='" + prt.sW + "' height='" + prt.sH + "' frameborder='0' scrolling='no' allowfullscreen></iframe>";
        
            if(FWDUVPUtils.isIE){
                _s.linkTxt.screen.innerText = _s.linkToVideo_str;
                _s.embdTxt.screen.innerText = _s.finalEmbedCode_str;
            }else{
                _s.linkTxt.screen.textContent = _s.linkToVideo_str;
                _s.embdTxt.screen.textContent = _s.finalEmbedCode_str;
            }
        };  
        

        //#########################################//
        /* show hide info */
        //#########################################//
        _s.showInfo = function(text, hasError){
                
            _s.infoText_do.setInnerHTML(text);
            _s.sendMainHld.addChild(_s.infoText_do);
            _s.infoText_do.setWidth(_s.buttonWidth);
            _s.infoText_do.setHeight(_s.buttonHeight - 4);
            _s.infoText_do.setX(_s.sndBtn.x);
            _s.infoText_do.setY(_s.sndBtn.y - 23);

            _s.infoText_do.setAlpha(0);
            if(hasError){
                _s.infoText_do.getStyle().color = "#FF0000";
            }else{
                _s.infoText_do.getStyle().color = _s.mainLabelsColor_str;
            }
            FWDAnimation.killTweensOf(_s.infoText_do);
            FWDAnimation.to(_s.infoText_do, .16, {alpha:1, yoyo:true, repeat:7});
        };

        
        //###########################################//
        /* show / hide */
        //###########################################//
        _s.show = function(id){
            if(_s.isShowed_bl) return;
            _s.isShowed_bl = true;
            prt.main_do.addChild(_s);
            _s.init();
            
            _s.resetInputs();
            _s.setEmbedData();
            if(!FWDUVPUtils.isMobile || (FWDUVPUtils.isMobile && FWDUVPUtils.hasPointerEvent)) prt.main_do.setSelectable(true);
            
            if(_s.useVectorIcons_bl){
                _s.checkButtonsId_to = setInterval(function(){
                    
                    if(_s.clsBtn.w != 0){   
                        _s.positionAndResize();
                        
                        clearInterval(_s.checkButtonsId_to);
                        clearTimeout(_s.hideCompleteId_to);
                        clearTimeout(_s.showCompleteId_to);
                        _s.mainHld.setY(- _s.sH);
                        
                        _s.showCompleteId_to = setTimeout(_s.showCompleteHandler, 900);
                        setTimeout(function(){
                            FWDAnimation.to(_s.mainHld, .8, {y:0, delay:.1, ease:Expo.easeInOut});
                        }, 100);
                    
                    }
                
                }, 50);
            }else{
                _s.positionAndResize();
            
                clearTimeout(_s.hideCompleteId_to);
                clearTimeout(_s.showCompleteId_to);
                _s.mainHld.setY(- _s.sH);
                
                _s.showCompleteId_to = setTimeout(_s.showCompleteHandler, 900);
                setTimeout(function(){
                    FWDAnimation.to(_s.mainHld, .8, {y:0, delay:.1, ease:Expo.easeInOut});
                }, 100);
            }
        };
        
        _s.showCompleteHandler = function(){};
        
        _s.hide = function(){
            if(!_s.isShowed_bl) return;
            _s.isShowed_bl = false;
            
            if(prt.customContextMenu_do) prt.customContextMenu_do.enable();
            _s.positionAndResize();
            
            clearTimeout(_s.hideCompleteId_to);
            clearTimeout(_s.showCompleteId_to);
            
            if(!FWDUVPUtils.isMobile || (FWDUVPUtils.isMobile && FWDUVPUtils.hasPointerEvent)) prt.main_do.setSelectable(false);
            _s.hideCompleteId_to = setTimeout(_s.hideCompleteHandler, 800);
            FWDAnimation.killTweensOf(_s.mainHld);
            FWDAnimation.to(_s.mainHld, .8, {y:-_s.sH, ease:Expo.easeInOut});
        };
        
        _s.hideCompleteHandler = function(){
            prt.main_do.removeChild(_s);
            _s.dispatchEvent(FWDUVPEmbedWindow.HIDE_COMPLETE);
        };

        if(_s.useHEX){
            _s.init();
        }
    };
        
        
    /* set prototype */
    FWDUVPEmbedWindow.setPrototype = function(){
        FWDUVPEmbedWindow.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPEmbedWindow.ERROR = "error";
    FWDUVPEmbedWindow.HIDE_COMPLETE = "hideComplete";
    
    FWDUVPEmbedWindow.prototype = null;
    window.FWDUVPEmbedWindow = FWDUVPEmbedWindow;
}(window));/**
 * Easy Video Player PACKAGED v8.4
 * Event dispatcher.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (){
    
    var FWDUVPEventDispatcher = function (){

        'use strict';
        
        this.listeners = {events_ar:[]};
         
        this.addListener = function (type, listener){
            
            if(type == undefined) throw Error("type is required.");
            if(typeof type === "object") throw Error("type must be of type String.");
            if(typeof listener != "function") throw Error("listener must be of type Function.");
            
            
            var event = {};
            event.type = type;
            event.listener = listener;
            event.target = this;
            this.listeners.events_ar.push(event);
        };
        
        this.dispatchEvent = function(type, props){
            if(this.listeners == null) return;
            if(type == undefined) throw Error("type is required.");
            if(typeof type === "object") throw Error("type must be of type String.");
            
            for (var i=0, len=this.listeners.events_ar.length; i < len; i++){
                if(this.listeners.events_ar[i].target === this && this.listeners.events_ar[i].type === type){       
                    if(props){
                        for(var prop in props){
                            this.listeners.events_ar[i][prop] = props[prop];
                        }
                    }
                    this.listeners.events_ar[i].listener.call(this, this.listeners.events_ar[i]);
                }
            }
        };
        
       this.removeListener = function(type, listener){
            
            if(type == undefined) throw Error("type is required.");
            if(typeof type === "object") throw Error("type must be of type String.");
            if(typeof listener != "function") throw Error("listener must be of type Function." + type);
            
            for (var i=0, len=this.listeners.events_ar.length; i < len; i++){
                if(this.listeners.events_ar[i].target === this 
                        && this.listeners.events_ar[i].type === type
                        && this.listeners.events_ar[i].listener ===  listener
                ){
                    this.listeners.events_ar.splice(i,1);
                    break;
                }
            }  
        };
        
        /* destroy */
        this.destroy = function(){
            this.listeners = null;
            
            this.addListener = null;
            this.dispatchEvent = null;
            this.removeListener = null;
        };
        
    };  
    
    window.FWDUVPEventDispatcher = FWDUVPEventDispatcher;
}(window));/**
 * Easy Video Player PACKAGED v8.4
 * Timeout hider.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
    
    var FWDUVPHider = function(screenToTest, screenToTest2, hideDelay){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPHider.prototype;
   
        _s.screenToTest = screenToTest;
        _s.screenToTest2 = screenToTest2;
        _s.hideDelay = hideDelay;
        _s.globalX = 0;
        _s.globalY = 0;
        
        _s.dispatchOnceShow_bl = true;
        _s.isStopped_bl = true;
        _s.isMbl = FWDUVPUtils.isMobile;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
        
        _s.init = function(){};
    
        _s.start = function(){
            _s.currentTime = new Date().getTime();
            clearInterval(_s.checkIntervalId_int);
            _s.checkIntervalId_int = setInterval(_s.update, 100);
            _s.addMouseOrTouchCheck();
            _s.isStopped_bl = false;
        };
        
        _s.stop = function(){
            clearInterval(_s.checkIntervalId_int);
            _s.isStopped_bl = true;
            _s.removeMouseOrTouchCheck();
            _s.removeMouseOrTouchCheck2();
        };
        
        _s.addMouseOrTouchCheck = function(){   
            if(_s.hasInitialTestEvents_bl) return;
            _s.hasInitialTestEvents_bl = true;
            if(_s.isMbl){
                if(_s.hasPointerEvent_bl){
                    _s.screenToTest.screen.addEventListener("pointerdown", _s.onMouseOrTouchUpdate);
                    _s.screenToTest.screen.addEventListener("MSPointerMove", _s.onMouseOrTouchUpdate);
                }else{
                    _s.screenToTest.screen.addEventListener("touchstart", _s.onMouseOrTouchUpdate);
                }
            }else if(window.addEventListener){
                window.addEventListener("mousemove", _s.onMouseOrTouchUpdate);
            }else if(document.attachEvent){
                document.attachEvent("onmousemove", _s.onMouseOrTouchUpdate);
            }
        };
        
        _s.removeMouseOrTouchCheck = function(){    
            if(!_s.hasInitialTestEvents_bl) return;
            _s.hasInitialTestEvents_bl = false;
            if(_s.isMbl){
                if(_s.hasPointerEvent_bl){
                    _s.screenToTest.screen.removeEventListener("pointerdown", _s.onMouseOrTouchUpdate);
                    _s.screenToTest.screen.removeEventListener("MSPointerMove", _s.onMouseOrTouchUpdate);
                }else{
                    _s.screenToTest.screen.removeEventListener("touchstart", _s.onMouseOrTouchUpdate);
                }
            }else if(window.removeEventListener){
                window.removeEventListener("mousemove", _s.onMouseOrTouchUpdate);
            }else if(document.detachEvent){
                document.detachEvent("onmousemove", _s.onMouseOrTouchUpdate);
            }
        };
        
        _s.addMouseOrTouchCheck2 = function(){  
            if(_s.addSecondTestEvents_bl) return;
            _s.addSecondTestEvents_bl = true;
            if(_s.screenToTest.screen.addEventListener){
                _s.screenToTest.screen.addEventListener("mousemove", _s.secondTestMoveDummy);
            }else if(_s.screenToTest.screen.attachEvent){
                _s.screenToTest.screen.attachEvent("onmousemove", _s.secondTestMoveDummy);
            }
        };
        
        _s.removeMouseOrTouchCheck2 = function(){   
            if(!_s.addSecondTestEvents_bl) return;
            _s.addSecondTestEvents_bl = false;
            if(_s.screenToTest.screen.removeEventListener){
                _s.screenToTest.screen.removeEventListener("mousemove", _s.secondTestMoveDummy);
            }else if(_s.screenToTest.screen.detachEvent){
                _s.screenToTest.screen.detachEvent("onmousemove", _s.secondTestMoveDummy);
            }
        };
        
        _s.secondTestMoveDummy = function(){
            _s.removeMouseOrTouchCheck2();
            _s.addMouseOrTouchCheck();
        };
        
        _s.onMouseOrTouchUpdate = function(e){
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            
            if(_s.globalX != vc.screenX
               && _s.globalY != vc.screenY){
                _s.currentTime = new Date().getTime();
            }
            
            _s.globalX = vc.screenX;
            _s.globalY = vc.screenY;
            
            if(!_s.isMbl){
                if(!FWDUVPUtils.hitTest(_s.screenToTest.screen, _s.globalX, _s.globalY)){
                    _s.removeMouseOrTouchCheck();
                    _s.addMouseOrTouchCheck2();
                }
            }
        };
    
        _s.update = function(e){
            if(new Date().getTime() > _s.currentTime + _s.hideDelay){
                if(_s.dispatchOnceShow_bl){ 
                    _s.dispatchOnceHide_bl = true;
                    _s.dispatchOnceShow_bl = false; 
                    _s.dispatchEvent(FWDUVPHider.HIDE);
                    clearTimeout(_s.hideCompleteId_to);
                    _s.hideCompleteId_to = setTimeout(function(){
                        _s.dispatchEvent(FWDUVPHider.HIDE_COMPLETE);
                    }, 1000);
                }
            }else{
                if(_s.dispatchOnceHide_bl){
                    clearTimeout(_s.hideCompleteId_to);
                    _s.dispatchOnceHide_bl = false;
                    _s.dispatchOnceShow_bl = true;
                    _s.dispatchEvent(FWDUVPHider.SHOW);
                }
            }
        };

        _s.reset = function(){
            clearTimeout(_s.hideCompleteId_to);
            _s.currentTime = new Date().getTime();
            _s.dispatchEvent(FWDUVPHider.SHOW);
        };
        
        _s.init();
     };
     
     FWDUVPHider.HIDE = "hide";
     FWDUVPHider.SHOW = "show";
     FWDUVPHider.HIDE_COMPLETE = "hideComplete";
     
     FWDUVPHider.setPrototype = function(){
         FWDUVPHider.prototype = new FWDUVPEventDispatcher();
     };
     

     window.FWDUVPHider = FWDUVPHider;
}(window));/**
 * Easy Video Player PACKAGED v8.4
 * Error info window.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
    
    var FWDUVPInfo = function(prt, warningIconPath, showErrorInfo){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPInfo.prototype;
    
        _s.warningIconPath_str = warningIconPath;
        _s.showErrorInfo_bl = showErrorInfo;
        _s.allowToRemove_bl = true;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;

        
        //#################################//
        /* init */
        //#################################//
        _s.init = function(){
            _s.setResizableSizeAfterParent();
            
            _s.bk_do = new FWDUVPDisplayObject("div");
            _s.bk_do.setAlpha(.6);
            _s.bk_do.setBkColor("#000000");
            _s.addChild(_s.bk_do);
            
            _s.textHolder_do = new FWDUVPDisplayObject("div");
            if(!FWDUVPUtils.isIEAndLessThen9) _s.textHolder_do.getStyle().font = "Arial";
            _s.textHolder_do.getStyle().wordWrap = "break-word";
            _s.textHolder_do.getStyle().padding = "10px";
            _s.textHolder_do.getStyle().paddingLeft = "42px";
            _s.textHolder_do.getStyle().lineHeight = "18px";
            _s.textHolder_do.getStyle().color = "#000000";
            _s.textHolder_do.setBkColor("#EEEEEE");
            
            var img_img = new Image();
            img_img.src = _s.warningIconPath_str;
            _s.img_do = new FWDUVPDisplayObject("img");
            _s.img_do.setScreen(img_img);
            _s.img_do.setWidth(28);
            _s.img_do.setHeight(28);
            
            _s.addChild(_s.textHolder_do);
            _s.addChild(_s.img_do);
        };
        
        _s.showText = function(txt){
            if(!_s.isShowedOnce_bl){
                if(_s.hasPointerEvent_bl){
                    _s.screen.addEventListener("pointerdown", _s.closeWindow);
                }else{
                    _s.screen.addEventListener("click", _s.closeWindow);
                    _s.screen.addEventListener("touchend", _s.closeWindow);
                }
                _s.isShowedOnce_bl = true;
            }
            
            _s.setVisible(false);
            
            _s.textHolder_do.getStyle().paddingBottom = "10px";
            _s.textHolder_do.setInnerHTML(txt);
            clearTimeout(_s.show_to);
            _s.show_to = setTimeout(_s.show, 60);
            setTimeout(function(){
                _s.positionAndResize();
            }, 10);
        };
        
        _s.show = function(){
            var finalW = Math.min(640, prt.sW - 120);
            _s.isShowed_bl = true;
        
            _s.textHolder_do.setWidth(finalW);
            setTimeout(function(){
                if(_s.showErrorInfo_bl) _s.setVisible(true);
                _s.positionAndResize();
            }, 100);
        };
        
        _s.positionAndResize = function(){
            
            var finalW = _s.textHolder_do.getWidth();
            var finalH = _s.textHolder_do.getHeight();
            var finalX = parseInt((prt.sW - finalW)/2);
            var finalY = parseInt((prt.sH - finalH)/2);
            
            _s.bk_do.setWidth(prt.sW);
            _s.bk_do.setHeight(prt.sH);
            _s.textHolder_do.setX(finalX);
            _s.textHolder_do.setY(finalY);
            
            _s.img_do.setX(finalX + 6);
            _s.img_do.setY(finalY + parseInt((_s.textHolder_do.getHeight() - _s.img_do.h)/2));
        };
        
        _s.closeWindow = function(){
            if(!_s.allowToRemove_bl) return;
            _s.isShowed_bl = false;
            clearTimeout(_s.show_to);
            setTimeout(function(){
            try{prt.main_do.removeChild(_s);}catch(e){}
            }, 100);
        };
        
        _s.init();
    };
    
        
    /* set prototype */
    FWDUVPInfo.setPrototype = function(){
        FWDUVPInfo.prototype = new FWDUVPDisplayObject("div", "relative");
    };
    
    FWDUVPInfo.prototype = null;
    window.FWDUVPInfo = FWDUVPInfo;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Info window.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
    
    var FWDUVPInfoWindow = function(prt, _d){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPInfoWindow.prototype;
        
        _s.embedColoseN_img = _d.embedColoseN_img;
        
        _s.embedWindowBackground_str = _d.embedWindowBackground_str;
        _s.embedWindowInputBackgroundPath_str = _d.embedWindowInputBackgroundPath_str;
        _s.secondaryLabelsColor_str = _d.secondaryLabelsColor_str;
        _s.inputColor_str = _d.inputColor_str;
        _s.sendButtonNPath_str = _d.sendButtonNPath_str;
        _s.sendButtonSPath_str = _d.sendButtonSPath_str;
        _s.inputBackgroundColor_str = _d.inputBackgroundColor_str;
        _s.borderColor_str = _d.borderColor_str;
        _s.sendToAFriendPath_str = _d.sendToAFriendPath_str;
        
        _s.maxTextWidth = 0;
        _s.totalWidth = 0;
        _s.sW = 0;
        _s.sH = 0;
        _s.buttonWidth = 44;
        _s.buttonHeight = 19;
        _s.embedWindowCloseButtonMargins = _d.embedWindowCloseButtonMargins;
        _s.shareAndEmbedTextColor_str = _d.shareAndEmbedTextColor_str;

        _s.isDark = true;
        if(_s.embedWindowBackground_str.indexOf('dark') == -1){
            _s.isDark = false;
        }

        _s.isMbl = FWDUVPUtils.isMobile;
        _s.useVectorIcons_bl = _d.useVectorIcons_bl;
    

        //#################################//
        /* init */
        //#################################//
        _s.init = function(){
            _s.setBackfaceVisibility();
            _s.mainHld = new FWDUVPDisplayObject("div");
            var css = 'fwduvp-info-window-white';
            
            if(_s.isDark){
                css = 'fwduvp-info-window-dark';
            }
            _s.mainHld.screen.className = css;
            
            _s.mainBk_do = new FWDUVPDisplayObject("div");
            _s.mainBk_do.getStyle().width = "100%";
            _s.mainBk_do.getStyle().height = "100%";
            _s.mainBk_do.setAlpha(.9);
            _s.mainBk_do.getStyle().background = "url('" + _s.embedWindowBackground_str + "')";
        
            //setup link and embed text
            _s.mainTextHolder_do =  new FWDUVPDisplayObject("div", "absolute");
            
            _s.bk_do = new FWDUVPDisplayObject("div");
            _s.bk_do.getStyle().background = "url('" + _s.embedWindowBackground_str + "')";
            _s.bk_do.getStyle().borderStyle = "solid";
            _s.bk_do.getStyle().borderWidth = "1px";
            _s.bk_do.getStyle().borderColor =  _s.borderColor_str;
            
            _s.text_do = new FWDUVPDisplayObject("div", "relative");
            _s.text_do.hasTransform3d_bl = false;
            _s.text_do.hasTransform2d_bl = false;
            _s.text_do.getStyle().fontFamily = "Arial";
            _s.text_do.getStyle().fontSize= "12px";
            _s.text_do.getStyle().fontSmoothing = "antialiased";
            _s.text_do.getStyle().webkitFontSmoothing = "antialiased";
            _s.text_do.getStyle().textRendering = "optimizeLegibility";

            //setup close button
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.clsBtn = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<div class='table-fwduvp-button'><span class='table-cell-fwduvp-button fwdicon-close'></span></div>",
                        undefined,
                        "UVPCloseButtonNormalState",
                        "UVPCloseButtonSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.clsBtn = new FWDUVPSimpleButton(_d.infoWindowClooseN_img, _d.embedWindowClosePathS_str, undefined,
                        true,
                        _d.useHEX,
                        _d.nBC,
                        _d.sBC,
                        false, false, false, false, true);
            }
            _s.clsBtn.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.closeButtonOnMouseUpHandler);
            
            _s.mainHld.addChild(_s.mainBk_do);
            _s.mainTextHolder_do.addChild(_s.bk_do);
            _s.mainTextHolder_do.addChild(_s.text_do);  
            _s.mainHld.addChild(_s.mainTextHolder_do);
            _s.addChild(_s.mainHld);

            _s.mainHld.addChild(_s.clsBtn); 
        };
    
        _s.closeButtonOnMouseUpHandler = function(){
            if(!_s.isShowed_bl) return;
            _s.hide();
        };
        
        _s.positionAndResize = function(){
        
            _s.sW = prt.sW;
            _s.sH = prt.sH;
            
            _s.maxTextWidth = Math.min(_s.sW - 150, 500);
            _s.totalWidth = _s.maxTextWidth + _s.buttonWidth + 40;
            
            _s.positionFinal();
            
            _s.clsBtn.setX(_s.sW - _s.clsBtn.w - _s.embedWindowCloseButtonMargins);
            _s.clsBtn.setY(_s.embedWindowCloseButtonMargins);
            
            _s.setWidth(_s.sW);
            _s.setHeight(_s.sH);
            _s.mainHld.setWidth(_s.sW);
            _s.mainHld.setHeight(_s.sH);
        };
        
        _s.positionFinal = function(){
            var totalHeight;
            var isEmbeddedAndFScreenOnIE11Bug_bl = false;
            _s.mainTextHolder_do.setWidth(_s.totalWidth);
            
            if(isEmbeddedAndFScreenOnIE11Bug_bl){
                totalHeight = Math.round(_s.mainTextHolder_do.screen.getBoundingClientRect().height * 100);
            }else{
                totalHeight = _s.mainTextHolder_do.getHeight();
            }
            
            _s.bk_do.setWidth(_s.totalWidth - 2);
            _s.bk_do.setHeight(totalHeight - 2);
            
            _s.mainTextHolder_do.setX(parseInt((_s.sW - _s.totalWidth)/2));
            _s.mainTextHolder_do.setY(parseInt((_s.sH - totalHeight)/2) - 8);
        };

        
        //###########################################//
        /* show / hide */
        //###########################################//
        _s.show = function(videoDesc){
            if(_s.isShowed_bl) return;
            _s.isShowed_bl = true;
            prt.main_do.addChild(_s);
            _s.text_do.setInnerHTML(videoDesc);
        
            _s.positionAndResize();
            
            clearTimeout(_s.hideCompleteId_to);
            clearTimeout(_s.showCompleteId_to);
            _s.mainHld.setY(- _s.sH);
            
            _s.showCompleteId_to = setTimeout(_s.showCompleteHandler, 900);
            setTimeout(function(){
                FWDAnimation.to(_s.mainHld, .8, {y:0, delay:.1, ease:Expo.easeInOut});
            }, 100);
        };
        
        _s.showCompleteHandler = function(){};
        
        _s.hide = function(){
            if(!_s.isShowed_bl) return;
            _s.isShowed_bl = false;
            
            if(prt.customContextMenu_do) prt.customContextMenu_do.enable();
            _s.positionAndResize();
            
            clearTimeout(_s.hideCompleteId_to);
            clearTimeout(_s.showCompleteId_to);
            
            _s.hideCompleteId_to = setTimeout(_s.hideCompleteHandler, 800);
            FWDAnimation.killTweensOf(_s.mainHld);
            FWDAnimation.to(_s.mainHld, .8, {y:-_s.sH, ease:Expo.easeInOut});
        };
        
        _s.hideCompleteHandler = function(){
            prt.main_do.removeChild(_s);
            _s.dispatchEvent(FWDUVPInfoWindow.HIDE_COMPLETE);
        };
    
        _s.init();
    };
    
        
    /* set prototype */
    FWDUVPInfoWindow.setPrototype = function(){
        FWDUVPInfoWindow.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPInfoWindow.ERROR = "error";
    FWDUVPInfoWindow.HIDE_COMPLETE = "hideComplete";
    
    FWDUVPInfoWindow.prototype = null;
    window.FWDUVPInfoWindow = FWDUVPInfoWindow;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Main class.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
    
    var FWDUVPlayer = function(props){

        'use strict';

        FWDUVPlayer.V = '8.4';
        
        var _s = this;
        _s.isInstantiate_bl = false;
        _s.displayType = props.displayType || FWDUVPlayer.RESPONSIVE;
        
        if(_s.displayType.toLowerCase() != FWDUVPlayer.RESPONSIVE 
           && _s.displayType.toLowerCase() != FWDUVPlayer.FULL_SCREEN
           && _s.displayType.toLowerCase() != FWDUVPlayer.STICKY
           && _s.displayType.toLowerCase() != FWDUVPlayer.AFTER_PARENT
           && _s.displayType.toLowerCase() != FWDUVPlayer.LIGHTBOX){
            _s.displayType = FWDUVPlayer.RESPONSIVE;
        }
        _s.displayType = _s.displayType.toLowerCase();
        
        _s.stickyOnScroll = props.stickyOnScroll || "no";
        _s.stickyOnScroll = _s.stickyOnScroll == "yes" ? true : false;
        if(_s.displayType != FWDUVPlayer.RESPONSIVE) _s.stickyOnScroll = false;
        _s.isMinShowed = true;
        
        _s.stickyOnScrollWidth = props.stickyOnScrollWidth || 700;
        _s.stickyOnScrollHeight = props.stickyOnScrollHeight || 394; 

        _s.maxWidth = props.maxWidth || 640;
        _s.maxHeight = props.maxHeight || 380;
    
        _s.useYoutube_bl = props.useYoutube || "no"; 
        _s.useYoutube_bl = _s.useYoutube_bl == "yes" ? true : false;
        
        _s.useVimeo_bl = props.useVimeo || "no"; 
        _s.useVimeo_bl = _s.useVimeo_bl == "yes" ? true : false;
        
        _s.mainFolderPath_str = props.mainFolderPath;
        if((_s.mainFolderPath_str.lastIndexOf("/") + 1) != _s.mainFolderPath_str.length){
            _s.mainFolderPath_str += "/";
        }
        
        _s.sknPth = props.skinPath;
        if((_s.sknPth.lastIndexOf("/") + 1) != _s.sknPth.length){
            _s.sknPth += "/";
        }
        
        _s.warningIconPath_str = _s.mainFolderPath_str + _s.sknPth + "warningIcon.png";
        
        FWDUVPlayer.YTAPIReady = false;
        _s.fillEntireVideoScreen_bl = false;
    
        /* init gallery */
        _s.init = function(){
            if(_s.isInstantiate_bl) return;
            FWDUVPlayer.instaces_ar.push(_s);
            
            FWDTweenLite.ticker.useRAF(false);
            _s.props = props;
            
            _s.instanceName_str = _s.props.instanceName;
            
            if(!_s.instanceName_str){
                alert("FWDUVPlayer instance name is required please make sure that the instanceName parameter exsists and it's value is uinique.");
                return;
            }
            
            if(window[_s.instanceName_str]){
                alert("FWDUVPlayer instance name " + _s.instanceName_str +  " is already defined and contains a different instance reference, set a different instance name.");
                return;
            }else{
                window[_s.instanceName_str] = _s;
            }
        
            if(!_s.props){
                alert("FWDUVPlayer constructor properties object is not defined!");
                return;
            }
            
            if(!_s.props.parentId){     
                alert("Property parentId is not defined in the FWDUVPlayer constructor, _s property represents the div id into which the megazoom is added as a child!");
                return;
            }
            
            if(_s.displayType == FWDUVPlayer.RESPONSIVE) _s.mustHaveHolderDiv_bl = true;
        
            if(_s.mustHaveHolderDiv_bl && !FWDUVPUtils.getChildById(_s.props.parentId)){
                alert("FWDUVPlayer holder div is not found, please make sure that the div exsists and the id is correct! " + _s.props.parentId);
                return;
            }
            
            _s.body = document.getElementsByTagName("body")[0];
            if(_s.displayType == FWDUVPlayer.STICKY){
                _s.stageContainer = document.createElement("div");
                _s.stageContainer.style.position = "fixed";
                _s.stageContainer.style.width = "100%";
                _s.stageContainer.style.zIndex = "999999";
                _s.stageContainer.style.height = "0px";
            
                document.documentElement.appendChild(_s.stageContainer);
                _s.stageContainer.style.overflow = "visible";
                
            }else if(_s.displayType == FWDUVPlayer.FULL_SCREEN  || _s.displayType == FWDUVPlayer.LIGHTBOX){
                _s.stageContainer = document.documentElement;
            }else{
                _s.stageContainer = FWDUVPUtils.getChildById(_s.props.parentId);
            }
        
            _s.position_str = _s.props.verticalPosition;
            if(!_s.position_str) _s.position_str = FWDUVPlayer.POSITION_TOP;
            if(_s.position_str == "bottom"){
                _s.position_str = FWDUVPlayer.POSITION_BOTTOM;
            }else{
                _s.position_str = FWDUVPlayer.POSITION_TOP;
            }
            
            _s.horizontalPosition_str = _s.props.horizontalPosition;
            if(!_s.horizontalPosition_str) _s.horizontalPosition_str = FWDUVPlayer.CENTER;
            if(_s.horizontalPosition_str == "center"){
                _s.horizontalPosition_str = FWDUVPlayer.CENTER;
            }else if(_s.horizontalPosition_str == "left"){
                _s.horizontalPosition_str = FWDUVPlayer.LEFT;
            }else if(_s.horizontalPosition_str == "right"){
                _s.horizontalPosition_str = FWDUVPlayer.RIGHT;
            }else{
                _s.horizontalPosition_str = FWDUVPlayer.CENTER;
            }
            
            if(_s.isEmbedded_bl) _s.displayType = FWDUVPlayer.FULL_SCREEN;
            
            _s.listeners = {events_ar:[]};
            _s.spaceBetweenControllerAndPlaylist = _s.props.spaceBetweenControllerAndPlaylist || 1;
            _s.autoScale_bl = _s.props.autoScale;
            _s.autoScale_bl = _s.autoScale_bl == "yes" ? true : false;

            _s.ec = document.getElementById('fwduvp_extra_content');
            
            _s.showPreloader_bl = _s.props.showPreloader;
            _s.showPreloader_bl = _s.showPreloader_bl == "yes" ? true : false;
            
            _s.preloaderColors = _s.props.preloaderColors || ["#666666", "#FFFFFF"];
            
            _s.backgroundColor_str = _s.props.backgroundColor || "transparent";
            _s.videoBackgroundColor_str = _s.props.videoBackgroundColor || "transparent";
            
            _s.mainBackgroundImagePath_str = _s.props.mainBackgroundImagePath;
            if(_s.mainBackgroundImagePath_str && _s.mainBackgroundImagePath_str.length < 3) _s.mainBackgroundImagePath_str = undefined;
            
            _s.animate_bl = true; 
            _s.isShowedFirstTime_bl = true;
            
            _s.offsetX = parseInt(_s.props.offsetX) || 0;
            _s.offsetY = parseInt(_s.props.offsetY) || 0
            _s.lastX = 0;
            _s.lastY = 0;
            _s.tempStageWidth = 0;
            _s.tempStageHeight = 0;
            _s.tempVidStageWidth = 0;
            _s.tempVidStageHeight = 0;
            _s.sW = 0;
            _s.sH = 0;
            _s.vidStageWidth = 0;
            _s.vidStageHeight = 0;
            _s.catId = -1;
            _s.id = -1;
            _s.totaadsIdeos = 0;
            _s.prevCatId = -1;
            _s.totalTimePlayed = 0;
            _s.isFullScreen_bl = false;
            
            _s.videoSourcePath_str = "";
            _s.prevVideoSourcePath_str;
            _s.posterPath_str = _s.props.posterPath;
            _s.playListThumbnailWidth = _s.props.thumbnailWidth || 80;
            _s.playListThumbnailHeight = _s.props.thumbnailHeight || 80;

            _s.showOnlyThumbnail = _s.props.showOnlyThumbnail;
            _s.showOnlyThumbnail = _s.showOnlyThumbnail == "yes" ? true : false;

            _s.playlistWidth = _s.props.playlistRightWidth || 250;
            _s.playlistHeight = 0;
            
            _s.showPlaylistButtonAndPlaylist_bl = _s.props.showPlaylistButtonAndPlaylist;
            _s.showPlaylistButtonAndPlaylist_bl = _s.showPlaylistButtonAndPlaylist_bl == "no" ? false : true;
            
            _s.isPlaylistShowed_bl = _s.props.showPlaylistByDefault;
            _s.isPlaylistShowed_bl = _s.isPlaylistShowed_bl == "no" ? false : true;
            
            _s.showErrorInfo_bl = _s.props.showErrorInfo; 
            _s.showErrorInfo_bl = _s.showErrorInfo_bl == "no" ? false : true;
            
            _s.showAnnotationsPositionTool_bl =  _s.props.showAnnotationsPositionTool;
            _s.showAnnotationsPositionTool_bl = _s.showAnnotationsPositionTool_bl == "yes" ? true : false;
            if(_s.showAnnotationsPositionTool_bl) _s.isPlaylistShowed_bl = false;
            
            if(FWDUVPlayer.videoStartBehaviour != "pause" 
            && FWDUVPlayer.videoStartBehaviour != "stop"
            && FWDUVPlayer.videoStartBehaviour != "default"
            ){
                FWDUVPlayer.videoStartBehaviour = "pause";
            }
            
            _s.lightBoxBackgroundOpacity = _s.props.lightBoxBackgroundOpacity || 1;
            _s.lightBoxBackgroundColor_str = _s.props.lightBoxBackgroundColor || "transparent";
            _s.preloaderBackgroundColor = _s.props.preloaderBackgroundColor || "#000000";
            _s.preloaderFillColor = _s.props.preloaderFillColor || "#FFFFFF";
            _s.addPrevId = Math.random() * 999999999;
            _s.orintationChangeComplete_bl = true;
            _s.isInstantiate_bl = true;
            _s.useDeepLinking_bl = _s.props.useDeepLinking;
            _s.useDeepLinking_bl = _s.useDeepLinking_bl == "yes" ? true : false;
            
            _s.isMbl = FWDUVPUtils.isMobile;
            _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
            
            _s.lightBoxWidth = _s.props.maxWidth || 500;
            _s.lightBoxHeight =  _s.props.maxHeight || 400;
            
            _s.isShowed_bl = _s.props.showPlayerByDefault; 
            _s.isShowed_bl = _s.isShowed_bl == "yes" ? true : false;
            
            _s.googleAnalyticsMeasurementId = _s.props.googleAnalyticsMeasurementId; 
            if(!window['gtag'] && _s.googleAnalyticsMeasurementId){
                var script = document.createElement('script');
                script.src = 'https://www.googletagmanager.com/gtag/js?id=' + _s.googleAnalyticsMeasurementId;
                script.setAttribute("async", "true");
                script.onload = function() {

                  _s.initGoogleAnalytics();
                };
                document.head.appendChild(script);
            }else if(window['gtag'] && _s.googleAnalyticsMeasurementId){
                _s.initGoogleAnalytics();
            }

        
            if(_s.displayType == FWDUVPlayer.LIGHTBOX){
                _s.setupLightBox();
            }else if(_s.displayType == FWDUVPlayer.STICKY){
                _s.setupPlayer();
                _s.startResizeHandler();
            }else{
                if(_s.initializeOnlyWhenVisible_bl){
                    _s.startResizeHandler();
                    window.addEventListener("scroll", _s.onInitlalizeScrollHandler);
                    setTimeout(_s.onInitlalizeScrollHandler, 500);
                }else{
                    _s.setupPlayer();
                    _s.startResizeHandler();
                }
            }
        };

        _s.initGoogleAnalytics = function(){
              // Once the script is loaded, initialize Google Analytics
              window.dataLayer = window.dataLayer || [];
              _s.gtag = function(){dataLayer.push(arguments);}

              _s.gtag('js', new Date());
              _s.gtag('config', _s.googleAnalyticsMeasurementId);
        }

        _s.addMinOnScroll = function(){
            if(_s.displayType != FWDUVPlayer.RESPONSIVE) return;
            if(_s.stickyOnScroll) window.addEventListener("scroll", _s.minimizeOnScrollHandler);
        }

        _s.removeMinOnScroll = function(){
            if(_s.stickyOnScroll) window.removeEventListener("scroll", _s.minimizeOnScrollHandler);
        }

        _s.minimizeOnScrollHandler = function(e){
            var scrollOffsets = FWDUVPUtils.getScrollOffsets();
            _s.pageXOffset = scrollOffsets.x;
            _s.pageYOffset = scrollOffsets.y;
            
            if(_s.stageContainer.getBoundingClientRect().bottom < 0){
                _s.setMinimized();
            }else{
                _s.setNormal();
            }
        }

        _s.setMinimized = function(){
            if(_s.isMin || _s.isFullscreen_bl) return;
            _s.isMin = true;
            _s.main_do.getStyle().position = 'fixed';
            _s.main_do.getStyle().zIndex = 9999999999999;
            _s.main_do.setAlpha(0);
            _s.startPosisionOnMin();
        }

        _s.startPosisionOnMin = function(){
            _s.wasPlaylistShowed_bl = _s.isPlaylistShowed_bl;
            _s.showPlaylist();
            _s.resizeHandler();
            _s.positionOnMin();
        }

        _s.setNormal = function(){
            if(!_s.isMin) return;
            _s.isMinShowed = true;
            _s.isMin = false;
            _s.main_do.getStyle().position = "relative";
            _s.main_do.getStyle().zIndex = 0;
            FWDAnimation.killTweensOf(_s.main_do);
            _s.main_do.setAlpha(1);
            _s.main_do.setX(0);
            _s.main_do.setY(0);
            if(_s.opener_do) _s.opener_do.setX(-1000);
                        
            _s.startPosisionOnNormal();
        }

        _s.startPosisionOnNormal = function(){
            if(_s.opener_do) _s.opener_do.showCloseButton();
            _s.isPlaylistShowed_bl = _s.wasPlaylistShowed_bl;
            if(_s.isPlaylistShowed_bl) _s.hidePlaylist(true);
            _s.resizeHandler();
        }
        
        _s.positionOnMin = function(animate){
            if(!_s.isMin && !animate) return;
            var offset = 5;
            var dl = .2;
            if(_s.isMbl) offset= 0;
            var offsetTop = 0;
            if(!_s.isMinShowed){
                dl = 0;
                offsetTop = Math.round(_s.tempStageHeight) + offset;
            } 

            if(_s.opener_do){
                var oX = _s.ws.w - _s.opener_do.w - offset;
                var oY = _s.ws.h - _s.tempStageHeight - offset + offsetTop - _s.opener_do.h;
            }
            
            _s.main_do.setX(_s.ws.w - _s.tempStageWidth - offset);
            if(_s.main_do.alpha == 0 || animate){
                if(_s.main_do.alpha == 0){
                    _s.main_do.setY(_s.ws.h);
                    if(_s.opener_do){
                        _s.opener_do.setX(oX);
                        _s.opener_do.setY(_s.ws.h);
                    }
                }
                FWDAnimation.to(_s.main_do, .8, {alpha:1, y:_s.ws.h - _s.tempStageHeight - offset + offsetTop, delay:dl, ease:Expo.easeInOut});
                if(_s.opener_do){
                    FWDAnimation.killTweensOf(_s.opener_do);
                    FWDAnimation.to(_s.opener_do, .8, {x:oX, y:oY, delay:dl, ease:Expo.easeInOut});
                }
            }else{
                FWDAnimation.killTweensOf(_s.main_do);
                _s.main_do.setAlpha(1);
                _s.main_do.setY(_s.ws.h - _s.tempStageHeight - offset + offsetTop);
                if(_s.opener_do){
                    FWDAnimation.killTweensOf(_s.opener_do);
                    _s.opener_do.setX(oX);
                    _s.opener_do.setY(oY);
                }
            }           
        }

        _s.onInitlalizeScrollHandler = function(){
            var scrollOffsets = FWDUVPUtils.getScrollOffsets();
            _s.pageXOffset = scrollOffsets.x;
            _s.pageYOffset = scrollOffsets.y;
            
            if(_s.main_do.getRect().top >= -_s.sH && _s.main_do.getRect().top < _s.ws.h){
                window.removeEventListener("scroll", _s.onInitlalizeScrollHandler);
                _s.setupPlayer();
            }
        };
        
        _s.setupPlayer = function(){
            if(!_s.main_do){
                _s.setupMainDo();
                _s.setupInfo();
                _s.setupData();
            }
        }
        
        //#############################################//
        /* setup  lighbox...*/
        //#############################################//
        _s.setupLightBox = function(){
            
            FWDUVPLightBox.setPrototype();
            _s.lightBox_do =  new FWDUVPLightBox(_s, 
                    _s.lightBoxBackgroundColor_str, 
                    _s.backgroundColor_str, 
                    _s.lightBoxBackgroundOpacity, 
                    _s.lightBoxWidth, 
                    _s.lightBoxHeight);
                    
            _s.lightBox_do.addListener(FWDUVPLightBox.SHOW, _s.lightBoxShowHandler);
            _s.lightBox_do.addListener(FWDUVPLightBox.CLOSE, _s.lightBoxCloseHandler);
            _s.lightBox_do.addListener(FWDUVPLightBox.HIDE_COMPLETE, _s.lightBoxHideCompleteHandler);
            _s.setupPlayer();
        };
        
        _s.lightBoxShowHandler = function(){}
        
        _s.lightBoxCloseHandler = function(){
        
            _s.stop();
            _s.stopResizeHandler();
        };
        
        _s.lightBoxHideCompleteHandler = function(){
            _s.dispatchEvent(FWDUVPlayer.HIDE_LIGHTBOX_COMPLETE);
        };

    
        //#############################################//
        /* setup main do */
        //#############################################//
        _s.setupMainDo = function(){
        
            _s.main_do = new FWDUVPDisplayObject("div", "relative");
            _s.main_do.screen.className = 'fwduvp';
            if(_s.hasPointerEvent_bl) _s.main_do.getStyle().touchAction = "none";
            _s.main_do.getStyle().webkitTapHighlightColor = "rgba(0, 0, 0, 0)";
            _s.main_do.getStyle().webkitFocusRingColor = "rgba(0, 0, 0, 0)";
            _s.main_do.getStyle().width = "100%";
            _s.main_do.getStyle().height = "100%";
            _s.main_do.setBackfaceVisibility();
            _s.main_do.setBkColor(_s.backgroundColor_str);
            if(!FWDUVPUtils.isMobile || (FWDUVPUtils.isMobile && FWDUVPUtils.hasPointerEvent)) _s.main_do.setSelectable(false); 
            _s.videoHolder_do = new FWDUVPDisplayObject("div");
            _s.main_do.addChild(_s.videoHolder_do);

            if(_s.displayType ==  FWDUVPlayer.STICKY){
                _s.background_do = new FWDUVPDisplayObject("div");
                _s.background_do.getStyle().width = "100%";
                if(_s.mainBackgroundImagePath_str){
                    _s.mainBackground_do =  new FWDUVPDisplayObject("div");
                    _s.stageContainer.appendChild(_s.mainBackground_do.screen);
                }
                _s.stageContainer.appendChild(_s.background_do.screen);
                _s.stageContainer.appendChild(_s.main_do.screen);
            }else if(_s.displayType == FWDUVPlayer.FULL_SCREEN){    
                _s.stageContainer.style.overflow = "hidden";
                _s.main_do.getStyle().position = "absolute";
                document.documentElement.appendChild(_s.main_do.screen);
                _s.stageContainer.style.zIndex = 9999999999998;
                _s.main_do.getStyle().zIndex = 9999999999998;
            }else if(_s.displayType == FWDUVPlayer.BACKGROUND_VIDEO){   
                document.documentElement.appendChild(_s.main_do.screen);
                _s.main_do.getStyle().zIndex = -9999999999998;
                _s.main_do.getStyle().position = "fixed";
                document.documentElement.insertBefore(_s.main_do.screen, document.documentElement.firstChild);
            }else if(_s.displayType == FWDUVPlayer.LIGHTBOX){
                _s.main_do.getStyle().position = "absolute";
            
                _s.stageContainer = _s.lightBox_do.mainLightBox_do.screen;
                _s.stageContainer.appendChild(_s.main_do.screen);
                _s.main_do.setX(-10000);
                _s.main_do.setY(-10000);
                _s.main_do.setWidth(0);
                _s.main_do.setHeight(0);
            }else{
                _s.stageContainer.style.overflow = "hidden";
                _s.stageContainer.appendChild(_s.main_do.screen);
            }   

            if(_s.isEmbedded_bl) _s.main_do.getStyle().zIndex = 9999999999998;
        };
        
        
        //#############################################//
        /* setup info_do */
        //#############################################//
        _s.setupInfo = function(){
            FWDUVPInfo.setPrototype();
            _s.info_do = new FWDUVPInfo(_s, _s.warningIconPath_str, _s.showErrorInfo_bl);
            _s.info_do.getStyle().zIndex = "9999999999999999";
        };      
        

        //#############################################//
        /* resize handler */
        //#############################################//
        _s.startResizeHandler = function(){
            
            if(_s.displayType == FWDUVPlayer.STICKY){
                if(FWDUVPUtils.isAndroid) window.addEventListener("orientationchange", _s.orientationChange);
                window.addEventListener("scroll", _s.onScrollHandler);
            }
            
            if(_s.displayType == FWDUVPlayer.LIGHTBOX){
                window.addEventListener("scroll", _s.onScrollHandler);
            }
            
            window.addEventListener("resize", _s.onResizeHandler);
        
            _s.onResizeHandler(true);
            _s.resizeHandlerId_to = setTimeout(function(){_s.resizeHandler();}, 500);
        };
        
        _s.orientationChange = function(){
            _s.orintationChangeComplete_bl = false; 
            clearTimeout(_s.resizeHandlerId_to);
            clearTimeout(_s.resizeHandler2Id_to);
            clearTimeout(_s.orientationChangeId_to);
        
            _s.orientationChangeId_to = setTimeout(function(){
                _s.orintationChangeComplete_bl = true; 
                _s.stageContainer.style.left = "0";
                _s.resizeHandler(true);
                }, 1000);
            
            _s.stageContainer.style.left = "-5000px";
            if(_s.preloader_do) _s.preloader_do.setX(-5000);    
        };
        
        _s.onScrollHandler = function(e){
            if(_s.displayType == FWDUVPlayer.STICKY && _s.isMbl) _s.onResizeHandler();
            if(_s.lightBox_do && !_s.lightBox_do.isShowed_bl) return;
            _s.scrollHandler();
            var scrollOffsets = FWDUVPUtils.getScrollOffsets();
            _s.scrollOffsets = scrollOffsets;
        };
        
        _s.scrollHandler = function(){
            var scrollOffsets = FWDUVPUtils.getScrollOffsets();
            _s.pageXOffset = scrollOffsets.x;
            _s.pageYOffset = scrollOffsets.y;
            if(_s.displayType == FWDUVPlayer.LIGHTBOX){
                _s.lightBox_do.setX(scrollOffsets.x);
                _s.lightBox_do.setY(scrollOffsets.y);
            }else if(_s.isFullScreen_bl || _s.displayType == FWDUVPlayer.FULL_SCREEN){  
                _s.main_do.setX(scrollOffsets.x);
                _s.main_do.setY(scrollOffsets.y);
            }
        };
        
        _s.stopResizeHandler = function(){
            if(window.removeEventListener){
                window.removeEventListener("resize", _s.onResizeHandler);
            }else if(window.detachEvent){
                window.detachEvent("onresize", _s.onResizeHandler);
            }   
            clearTimeout(_s.resizeHandlerId_to);
        };

        
        _s.onResizeHandler = function(e){
            _s.resizeHandler();
            clearTimeout(_s.resizeHandler2Id_to);
            _s.resizeHandler2Id_to = setTimeout(function(){_s.resizeHandler();}, 300);
        };
        
        _s.prevVpW;
        _s.resizeHandler = function(allowToResizeFinal, resizePlaylistWithAnim){
            _s.tempPlaylistPosition_str;
        
            var viewportSize = FWDUVPUtils.getViewportSize();
            var scrollOffsets = FWDUVPUtils.getScrollOffsets();
            _s.ws = viewportSize;
            _s.showPlaylistOnFullScreen = _s._d.showPlaylistOnFullScreen;
            if(_s.ws.w < 1000) _s.showPlaylistOnFullScreen = false;
            
            if(_s.displayType == FWDUVPlayer.STICKY  && !_s.isFullScreen_bl){   
                _s.main_do.getStyle().width = "100%";
                if(_s.main_do.getWidth() > _s.maxWidth){
                    _s.main_do.setWidth(_s.maxWidth);
                }
                
                _s.sW = _s.main_do.getWidth();
                if(_s.autoScale_bl){
                    _s.sH = parseInt(_s.maxHeight * (_s.sW/_s.maxWidth));
                }else{
                    _s.sH = _s.maxHeight;
                }
            
            }else if(_s.displayType == FWDUVPlayer.LIGHTBOX && !_s.isFullScreen_bl){
                if(!_s.lightBox_do.isShowed_bl ||  !_s.main_do) return;
                if(_s.lightBoxWidth > viewportSize.w){
                    _s.finalLightBoxWidth = viewportSize.w;
                    _s.finalLightBoxHeight = parseInt(_s.lightBoxHeight * (viewportSize.w/_s.lightBoxWidth));
                }else{
                    _s.finalLightBoxWidth = _s.lightBoxWidth;
                    _s.finalLightBoxHeight = _s.lightBoxHeight;
                }
                _s.lightBox_do.setWidth(viewportSize.w);
                _s.lightBox_do.setHeight(viewportSize.h);
                _s.lightBox_do.setX(scrollOffsets.x);
                _s.lightBox_do.setY(scrollOffsets.y);
                _s.lightBox_do.mainLightBox_do.setX(parseInt((viewportSize.w - _s.finalLightBoxWidth)/2));
                _s.lightBox_do.mainLightBox_do.setY(parseInt((viewportSize.h - _s.finalLightBoxHeight)/2));
                if(_s.lightBox_do.clsBtn && _s.lightBox_do.isShowed_bl){ 
                    _s.lightBox_do.clsBtn.setX(viewportSize.w - _s.lightBox_do.clsBtn.w - 15);
                    _s.lightBox_do.clsBtn.setY(15);
                }
                _s.main_do.setX(0);
                _s.main_do.setY(0);
                _s.lightBox_do.mainLightBox_do.setWidth(_s.finalLightBoxWidth);
                _s.lightBox_do.mainLightBox_do.setHeight(_s.finalLightBoxHeight);   
                _s.sW = _s.finalLightBoxWidth;
                _s.sH = _s.finalLightBoxHeight;
            }else if(_s.isFullScreen_bl || _s.displayType == FWDUVPlayer.FULL_SCREEN){  
                _s.main_do.setX(0);
                _s.main_do.setY(0);
                _s.sW = viewportSize.w;
                _s.sH = viewportSize.h;
            }else if(_s.displayType == FWDUVPlayer.AFTER_PARENT){
                _s.main_do.setX(0);
                _s.main_do.setY(0);
                _s.sW = _s.stageContainer.offsetWidth;
                _s.sH = _s.stageContainer.offsetHeight;
            }else{
                _s.stageContainer.style.width = "100%";
                if(_s.stageContainer.offsetWidth > _s.maxWidth){
                    _s.stageContainer.style.width = _s.maxWidth + "px";
                }
                _s.sW = _s.stageContainer.offsetWidth;
                if(_s.autoScale_bl){
                    _s.sH = parseInt(_s.maxHeight * (_s.sW/_s.maxWidth));
                    _s.tempStageHeight = _s.sH;
                }else{
                    _s.sH = _s.maxHeight;
                    _s.tempStageHeight = _s.sH;
                }
            }
            
            if(_s.sH > viewportSize.h && _s.isFullScreen_bl) _s.sH = viewportSize.h;
            if(_s._d && _s.playlist_do){
                _s.playlistHeight = parseInt(_s._d.playlistBottomHeight);
            }

            if(_s.isMin && !_s.isFullScreen_bl){
                _s.sW = Math.min(_s.stickyOnScrollWidth - 10, _s.ws.w - 10)
                _s.sH = parseInt(_s.stickyOnScrollHeight * (_s.sW/_s.stickyOnScrollWidth));
                _s.tempStageHeight = _s.sH;
            }
        
            if(_s._d){
                _s.tempPlaylistPosition_str = _s._d.playlistPosition_str;
                if(_s.sW < 800 || (_s.ec && _s.sH < 600)){
                    _s.tempPlaylistPosition_str = "bottom";
                }
                _s.playlistPosition_str = _s.tempPlaylistPosition_str;
                if(_s.playlist_do) _s.playlist_do.position_str = _s.tempPlaylistPosition_str;
            }
            
            if(_s.playlist_do && _s.isPlaylistShowed_bl){
                if(_s.playlistPosition_str == "bottom"){
                    _s.vidStageWidth = _s.sW;
                    _s.sH += _s.playlistHeight + _s.spaceBetweenControllerAndPlaylist;
                    _s.vidStageHeight = _s.sH - _s.playlistHeight - _s.spaceBetweenControllerAndPlaylist;
                    if(_s.displayType == FWDUVPlayer.FULL_SCREEN) _s.controller_do.disablePlaylistButton();
                }else if(_s.playlistPosition_str == "right"){
                    if(_s.isFullScreen_bl && !_s.showPlaylistOnFullScreen){
                        _s.vidStageWidth = _s.sW;
                    }else{
                        _s.vidStageWidth = _s.sW - _s.playlistWidth - _s.spaceBetweenControllerAndPlaylist;
                    }
                    if(_s.controller_do) _s.controller_do.enablePlaylistButton();
                    _s.vidStageHeight = _s.sH;
                }
            }else{
                _s.vidStageWidth = _s.sW;
                _s.vidStageHeight = _s.sH;
            }
                
            if(_s.controller_do){
                if(_s.playlist_do){
                    if(_s.playlistPosition_str == "right"){
                        if(_s.isFullScreen_bl && !_s.showPlaylistOnFullScreen){
                            _s.controller_do.disablePlaylistButton();
                        }else{
                            _s.controller_do.enablePlaylistButton();
                        }
                    }else if(_s.isEmbedded_bl){
                        _s.controller_do.disablePlaylistButton();
                    }
                }
            }
            
            if(_s.mainBackground_do){
                _s.mainBackground_do.setWidth(_s.ws.w);
                _s.mainBackground_do.setHeight(_s.sH);
            }
            
            if(!allowToResizeFinal){
                FWDAnimation.killTweensOf(_s);
                
                _s.tempStageWidth = _s.sW;
                _s.tempStageHeight = _s.sH;
                _s.tempVidStageWidth = _s.vidStageWidth;
                _s.tempVidStageHeight = Math.max(0, _s.vidStageHeight);
                
                _s.resizeFinal(resizePlaylistWithAnim);
                if(_s.prevVpW != viewportSize.w || _s.displayType != FWDUVPlayer.STICKY){
                    _s.setStageContainerFinalHeightAndPosition(resizePlaylistWithAnim);
                }
            }   

            setTimeout(function(){
                _s.prevVpW = viewportSize.w;
            },50)
        };

        _s.resizeFinal = function(resizePlaylistWithAnim){

            if(_s.displayType != FWDUVPlayer.STICKY && !_s.isMin) _s.stageContainer.style.height = _s.tempStageHeight + "px";

            if(_s.mainBackground_do){
                _s.mainBackground_do.setWidth(_s.ws.w);
                _s.mainBackground_do.setHeight(_s.tempStageHeight);
            }
            
            _s.main_do.setWidth(_s.tempStageWidth);
            _s.videoHolder_do.setWidth(_s.tempVidStageWidth);
            _s.videoHolder_do.setHeight(_s.tempVidStageHeight);
            
            if(_s.showPlaylistButtonAndPlaylist_bl && _s.isPlaylistShowed_bl && _s.playlistPosition_str == "bottom"){
                _s.main_do.setHeight(_s.tempStageHeight);
            }else{
                _s.main_do.setHeight(_s.tempStageHeight);
            }
            
            if(_s.displayType == FWDUVPlayer.LIGHTBOX) _s.lightBox_do.mainLightBox_do.setY(parseInt((_s.ws.h - _s.tempStageHeight)/2));
            
            if(_s.audioScreen_do && _s.videoType_str == FWDUVPlayer.MP3){
                _s.audioScreen_do.resizeAndPosition(_s.tempVidStageWidth, _s.tempVidStageHeight);
            }
            
            if(_s.ytb_do && _s.videoType_str == FWDUVPlayer.YOUTUBE){
                _s.ytb_do.setWidth(_s.tempVidStageWidth);
                _s.ytb_do.setHeight(_s.tempVidStageHeight);
            }
            
            if(_s.logo_do) _s.logo_do.positionAndResize();
            if(_s.playlist_do && !FWDAnimation.isTweening(_s)){
                _s.playlist_do.resizeAndPosition(resizePlaylistWithAnim);
            }
        
            if(_s.annotations_do){
                if(FWDAnimation.isTweening(_s)){
                    _s.annotations_do.position(true);
                }else{
                    _s.annotations_do.position(false);
                }
            }

            if(_s.controller_do) _s.controller_do.resizeAndPosition();
            if(_s.categories_do) _s.categories_do.resizeAndPosition();
            
            if(_s.videoScreen_do && (_s.videoType_str == FWDUVPlayer.VIDEO || _s.videoType_str == FWDUVPlayer.HLS_JS || _s.videoType_str == FWDUVPlayer.DASH)){
                _s.finaadsIdeoScreenW = _s.tempVidStageWidth;
                _s.finaadsIdeoScreenH = _s.tempVidStageHeight;
                _s.finaadsIdeoScreenX = _s.finaadsIdeoScreenY = 0;
                
                _s.videoScreen_do.resizeAndPosition(_s.finaadsIdeoScreenW, _s.finaadsIdeoScreenH, _s.finaadsIdeoScreenX, _s.finaadsIdeoScreenY);
            }

            if(_s.isIMA && _s.IMA) _s.IMA.resizeAndPosition();
        
            if(_s.ytb_do && _s.ytb_do.ytb && _s.videoType_str == FWDUVPlayer.YOUTUBE){
                _s.ytb_do.resizeAndPosition();
            }
            
            if(_s.vimeo_do && _s.videoType_str == FWDUVPlayer.VIMEO){
                _s.vimeo_do.resizeAndPosition();
            }
            
            if(_s.preloader_do) _s.positionPreloader();
            if(_s.dClk_do){
                if(_s.is360 && _s.videoType_str == FWDUVPlayer.YOUTUBE){
                    _s.dClk_do.setWidth(0);
                }else if(_s.videoType_str == FWDUVPlayer.VIMEO && !_s._d.showDefaultControllerForVimeo_bl){
                    _s.dClk_do.setWidth(0);
                }else{
                    _s.dClk_do.setWidth(_s.tempVidStageWidth);
                    if(_s.isMbl){
                        _s.dClk_do.setHeight(_s.tempVidStageHeight);
                    }else{
                        if(_s.videoType_str == FWDUVPlayer.YOUTUBE && !_s.isAdd_bl){
                            _s.dClk_do.setHeight(_s.tempVidStageHeight);
                        }else{
                            _s.dClk_do.setHeight(_s.tempVidStageHeight);
                        }
                    }
                }
            }
            
            if(_s.videoHider_do) _s.resizeVideoHider();
            if(_s.lrgPlayBtn) _s.positionLargePlayButton();
            if(_s.videoPoster_do && _s.videoPoster_do.allowToShow_bl) _s.videoPoster_do.positionAndResize();
            if(_s.popw_do && _s.popw_do.isShowed_bl) _s.popw_do.positionAndResize();
            if(_s.embedWindow_do && _s.embedWindow_do.isShowed_bl) _s.embedWindow_do.positionAndResize();
            if(_s.passWindow_do && _s.passWindow_do.isShowed_bl) _s.passWindow_do.positionAndResize();
            if(_s.lg_do && _s.lg_do.isShowed_bl) _s.lg_do.positionAndResize();
            if(_s.infoWindow_do && _s.infoWindow_do.isShowed_bl) _s.infoWindow_do.positionAndResize();
            if(_s.info_do && _s.info_do.isShowed_bl) _s.info_do.positionAndResize();
            if(_s.shareWindow_do && _s.shareWindow_do.isShowed_bl) _s.shareWindow_do.positionAndResize();
            if(_s.adsStart_do && _s.isAdd_bl) _s.positionAds();
            if(_s.subtitle_do) _s.subtitle_do.position(resizePlaylistWithAnim);
            if(_s.popupAds_do) _s.popupAds_do.position(resizePlaylistWithAnim);
            _s.positionAdsImage();
            
            _s.positionOnMin();
            
        };
        
        _s.setStageContainerFinalHeightAndPosition = function(animate){
            if(_s.displayType != FWDUVPlayer.STICKY) return;
            
            _s.allowToResizeAndPosition_bl = true;
            clearTimeout(_s.showPlaylistWithDelayId_to);
            
            if(_s.horizontalPosition_str == FWDUVPlayer.LEFT){
                _s.main_do.setX(_s.offsetX);
                if(_s.opener_do){
                    if(_s._d.openerAlignment_str == "right"){
                        _s.opener_do.setX(Math.round(_s.sW - _s.opener_do.w + _s.offsetX));
                    }else{
                        _s.opener_do.setX(_s.offsetX);
                    }
                }
            }else if(_s.horizontalPosition_str == FWDUVPlayer.CENTER){
                _s.main_do.setX(Math.round((_s.ws.w - _s.sW)/2));
                if(_s.opener_do){
                    if(_s._d.openerAlignment_str == "right"){
                        _s.opener_do.setX(parseInt((_s.ws.w - _s.sW)/2) + _s.sW - _s.opener_do.w);
                    }else{
                        _s.opener_do.setX(_s.main_do.x);
                    }
                }
            }else if(_s.horizontalPosition_str == FWDUVPlayer.RIGHT){
                _s.main_do.setX(Math.round(_s.ws.w - _s.sW - _s.offsetX));
                if(_s.opener_do){
                    if(_s._d.openerAlignment_str == "right"){
                        _s.opener_do.setX(Math.round(_s.ws.w - _s.opener_do.w - _s.offsetX));
                    }else{
                        _s.opener_do.setX(Math.round(_s.ws.w - _s.sW - _s.offsetX));
                    }
                }
            }
        
            if(animate){        
                if(_s.position_str ==  FWDUVPlayer.POSITION_TOP){
                    if(_s.isShowed_bl && !_s.isShowedFirstTime_bl){
                        FWDAnimation.to(_s.stageContainer, .8, {css:{top:_s.offsetY}, ease:Expo.easeInOut});
                    }else{
                        FWDAnimation.to(_s.stageContainer, .8, {css:{top:-_s.sH}, ease:Expo.easeInOut});
                    }
                    
                    if(_s.isShowedFirstTime_bl){
                        if(_s.opener_do) FWDAnimation.to(_s.opener_do, .8, {y:_s.sH - _s.opener_do.h, ease:Expo.easeInOut});
                    }else{
                        if(_s.opener_do) FWDAnimation.to(_s.opener_do, .8, {y:_s.sH, ease:Expo.easeInOut});
                    }
                }else{
                    if(_s.isShowed_bl && !_s.isShowedFirstTime_bl){
                        FWDAnimation.to(_s.stageContainer, .8, {css:{top:_s.ws.h - _s.sH - _s.offsetY}, ease:Expo.easeInOut});
                    }else{
                        FWDAnimation.to(_s.stageContainer, .8, {css:{top:_s.ws.h}, ease:Expo.easeInOut, onComplete:_s.moveWheyLeft});
                    }
                    
                    if(_s.isShowedFirstTime_bl){
                        if(_s.opener_do) FWDAnimation.to(_s.opener_do, .8, {y:0, ease:Expo.easeInOut});
                    }else{
                        if(_s.opener_do) FWDAnimation.to(_s.opener_do, .8, {y:-_s.opener_do.h, ease:Expo.easeInOut});
                    }
                }
            }else{
                FWDAnimation.killTweensOf(_s.stageContainer);
                if(_s.position_str ==  FWDUVPlayer.POSITION_TOP){
                    if(_s.isShowed_bl && !_s.isShowedFirstTime_bl){
                        _s.stageContainer.style.top = _s.offsetY + "px";
                    }else{
                        _s.stageContainer.style.top = -_s.sH + "px";
                    }
                    if(_s.isShowedFirstTime_bl){
                        if(_s.opener_do) _s.opener_do.setY(_s.sH - _s.opener_do.h);
                    }else{
                        if(_s.opener_do) _s.opener_do.setY(_s.sH);
                    }
                }else{
                    
                    if(_s.isShowed_bl && !_s.isShowedFirstTime_bl){
                        _s.stageContainer.style.top = (_s.ws.h - _s.sH - _s.offsetY) + "px";
                    }else{
                        _s.stageContainer.style.top = _s.ws.h + "px";
                    }
                    
                    if(_s.isShowedFirstTime_bl){
                        if(_s.opener_do) _s.opener_do.setY(0);
                    }else{
                        if(_s.opener_do) _s.opener_do.setY(-_s.opener_do.h);
                    }
                }
            }
        }
        
        
        //###############################################//
        /* Setup click screen */
        //###############################################//
        _s.setupClickScreen = function(){
            _s.dClk_do = new FWDUVPDisplayObject("div");
            if(FWDUVPUtils.isIE){
                _s.dClk_do.setBkColor("rgba(255,0,0,.00001");
            }
            
            if(_s.hasPointerEvent_bl){
                _s.dClk_do.screen.addEventListener("pointerdown", _s.playPauseDownHandler);
                _s.dClk_do.screen.addEventListener("pointerup", _s.playPauseClickHandler);
                _s.dClk_do.screen.addEventListener("pointermove", _s.playPauseMoveHandler);
            }else{  
                if(!_s.isMbl){
                    _s.dClk_do.screen.addEventListener("mousedown", _s.playPauseDownHandler);
                    _s.dClk_do.screen.addEventListener("mouseup", _s.playPauseClickHandler);
                    _s.dClk_do.screen.addEventListener("mousemove", _s.playPauseMoveHandler);
                }else{
                    _s.dClk_do.screen.addEventListener("click", _s.playPauseClickHandler);
                }
            }
            
            _s.hideClickScreen();
            _s.videoHolder_do.addChild(_s.dClk_do);
        };
        
        _s.playPauseDownHandler = function(e){
            _s.isClickHandlerMoved_bl = false;
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);
            _s.firstDommyTapX = vc.screenX;
            _s.firstDommyTapY = vc.screenY;
            if(_s.is360) _s.dClk_do.getStyle().cursor = 'url(' + _s._d.grabPath_str + '), default';
        }
        
        _s.playPauseMoveHandler = function(e){
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);
            var dx;
            var dy;
            
            if(e.touches && e.touches.length != 1) return;
            dx = Math.abs(vc.screenX - _s.firstDommyTapX);   
            dy = Math.abs(vc.screenY - _s.firstDommyTapY); 
            
            if(_s.isMbl && (dx > 10 || dy > 10)){
                _s.isClickHandlerMoved_bl = true;
            }else if(!_s.isMbl && (dx > 2 || dy > 2)){
                _s.isClickHandlerMoved_bl = true;
            }
        }
        
        _s.playPauseClickHandler = function(e){
            if(_s.is360) _s.dClk_do.getStyle().cursor = 'url(' + _s._d.handPath_str + '), default';
            if(e.button == 2) return;
            if(_s.isClickHandlerMoved_bl) return;
            if(_s.isAdd_bl){
                
                if(_s._d.adsPageToOpenURL_str && _s._d.adsPageToOpenURL_str != "none"){
                    if(_s.ClickTracking) _s.executeVastEvent(_s.ClickTracking);
                    window.open(_s._d.adsPageToOpenURL_str, _s._d.adsPageToOpenTarget_str);
                    _s.pause();
                }
                return;
            }
            
            if(_s.disableClick_bl) return;
            _s.firstTapPlaying_bl = _s.isPlaying_bl;
            
            FWDUVPlayer.keyboardCurInstance = _s;
            
            if(_s.controller_do && _s.controller_do.mainHld.y != 0 && _s.isMbl) return;
            
            if(!_s.isMbl){
                if(FWDUVPlayer.videoStartBehaviour == FWDUVPlayer.PAUSE_ALL_VIDEOS){
                    FWDUVPlayer.pauseAllVideos(_s);
                }else if(FWDUVPlayer.videoStartBehaviour == FWDUVPlayer.STOP_ALL_VIDEOS){
                    FWDUVPlayer.stopAllVideos(_s);
                }
            }
            
            if(_s.videoType_str == FWDUVPlayer.YOUTUBE){
                _s.ytb_do.togglePlayPause();
            }else if(_s.videoType_str == FWDUVPlayer.MP3){
                _s.audioScreen_do.togglePlayPause();
            }else if(_s.videoType_str == FWDUVPlayer.VIMEO){
                _s.vimeo_do.togglePlayPause();
            }else{
                if(_s.videoScreen_do) _s.videoScreen_do.togglePlayPause();  
            }
        };
        
        _s.showClickScreen = function(){
            _s.dClk_do.setVisible(true);
            if(_s.isAdd_bl && _s._d.adsPageToOpenURL_str && _s._d.adsPageToOpenURL_str != "none"){
                _s.dClk_do.setButtonMode(true);
            }else{  
                if(_s.is360){
                    _s.dClk_do.getStyle().cursor = 'url(' + _s._d.handPath_str + '), default';
                }else{
                    _s.dClk_do.setButtonMode(false);
                }
            }
        };
        
        _s.hideClickScreen = function(){
            _s.dClk_do.setVisible(false);
        };
        

        //#####################################//
        /* Setup disable click */
        //#####################################//
        _s.setupDisableClick = function(){
            _s.disableClick_do = new FWDUVPDisplayObject("div");
            if(FWDUVPUtils.isIE){
                _s.disableClick_do.setBkColor('rgba(0,255,0,.0001');
            }
            _s.main_do.addChild(_s.disableClick_do);
            
        };
        
        _s.disableClick = function(){
            _s.disableClick_bl = true;
            clearTimeout(_s.disableClickId_to);
            if(_s.disableClick_do){
                _s.disableClick_do.setWidth(_s.sW);
                _s.disableClick_do.setHeight(_s.sH);
            }
            _s.disableClickId_to =  setTimeout(function(){
                if(_s.disableClick_do){
                    _s.disableClick_do.setWidth(0);
                    _s.disableClick_do.setHeight(0);
                }
                _s.disableClick_bl = false;
            }, 500);
        };
        
        _s.showDisable = function(){
            _s.disableClick_do.setWidth(_s.sW);
            _s.disableClick_do.setHeight(_s.sH);
        };
        
        _s.hideDisable = function(){
            if(!_s.disableClick_do) return;
            if(_s.disableClick_do.w == 0) return;
            _s.disableClick_do.setWidth(0);
            _s.disableClick_do.setHeight(0);
        };

        
        //########################################//
        /* add double click and tap support */
        //########################################//
        _s.addDoubleClickSupport = function(){
            
            if(_s.hasPointerEvent_bl){
                _s.dClk_do.screen.addEventListener("pointerdown", _s.onFirstDown);
            }else{
                if(!_s.isMbl){
                    _s.dClk_do.screen.addEventListener("mousedown", _s.onFirstDown);
                }
                _s.dClk_do.screen.addEventListener("touchstart", _s.onFirstDown);
            }
            _s.setupVisualization();
        };
        
        _s.onFirstDown = function(e){
            if(e.button == 2) return;
            if(_s.isFullscreen_bl && e.preventDefault) e.preventDefault();
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);
            _s.firstTapX = vc.screenX - _s.main_do.getGlobalX();
            _s.firstTapY = vc.screenY - _s.main_do.getGlobalY();
        
            _s.firstTapPlaying_bl = _s.isPlaying_bl;
            
            if(FWDUVPUtils.isIEWebKit) return;
            if(_s.hasPointerEvent_bl){
                
                _s.dClk_do.screen.removeEventListener("pointerdown", _s.onFirstDown);
                _s.dClk_do.screen.addEventListener("pointerdown", _s.onSecondDown);
            }else{
                if(!_s.isMbl){
                    _s.dClk_do.screen.addEventListener("mousedown", _s.onSecondDown);
                    _s.dClk_do.screen.removeEventListener("mousedown", _s.onFirstDown);
                }
                _s.dClk_do.screen.addEventListener("touchstart", _s.onSecondDown);
                _s.dClk_do.screen.removeEventListener("touchstart", _s.onFirstDown);
            }
            clearTimeout(_s.secondTapId_to);
            _s.secondTapId_to = setTimeout(_s.doubleTapExpired, 500);
        };
        
        _s.doubleTapExpired = function(){
            clearTimeout(_s.secondTapId_to);
            if(_s.hasPointerEvent_bl){
                _s.dClk_do.screen.removeEventListener("pointerdown", _s.onSecondDown);
                _s.dClk_do.screen.addEventListener("pointerdown", _s.onFirstDown);
            }else{
                _s.dClk_do.screen.removeEventListener("touchstart", _s.onSecondDown);
                _s.dClk_do.screen.addEventListener("touchstart", _s.onFirstDown);
                if(!_s.isMbl){
                    _s.dClk_do.screen.removeEventListener("mousedown", _s.onSecondDown);
                    _s.dClk_do.screen.addEventListener("mousedown", _s.onFirstDown);
                }
            }
        };
        
        _s.onSecondDown = function(e){
            if(e.preventDefault) e.preventDefault();
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);
            var dx;
            var dy;
            
            if(FWDUVPUtils.isIEWebKit) _s.firstTapPlaying_bl = _s.isPlaying_bl;
            if(e.touches && e.touches.length != 1) return;
            dx = Math.abs((vc.screenX - _s.main_do.getGlobalX()) - _s.firstTapX);   
            dy = Math.abs((vc.screenY - _s.main_do.getGlobalY()) - _s.firstTapY); 
            if(dx > 10 || dy > 10) return;

            if(_s.firstTapX < _s.tempVidStageWidth * 0.33){
                if(!_s.isPlaying_bl){
                    _s.skipOnDb_bl = true;
                    _s.rewind(_s._d.rewTm);
                    _s.addVisualization('left');
                    setTimeout(function(){
                        if(!_s.isPlaying_bl) _s.play();
                    }, 200);
                    setTimeout(function(){
                        _s.skipOnDb_bl = false;
                    }, 500);
                } 
            }else if(_s.firstTapX > _s.tempVidStageWidth * 0.67){
                    if(!_s.isPlaying_bl){
                        _s.skipOnDb_bl = true;
                        _s.rewind(- _s._d.rewTm);
                        _s.addVisualization('right');
                        setTimeout(function(){
                            if(!_s.isPlaying_bl) _s.play();
                        }, 200);
                        setTimeout(function(){
                            _s.skipOnDb_bl = false;
                        }, 500);
                } 
            }else{
                _s.switchFullScreenOnDoubleClick();
                if(_s.firstTapPlaying_bl){
                    _s.play();
                }else{
                    _s.pause();
                }
            }
        };
        
        _s.switchFullScreenOnDoubleClick = function(){
            _s.disableClick();
            if(!_s.isFullScreen_bl){
                _s.goFullScreen();
            }else{
                _s.goNormalScreen();
            }
        };


        //############################################//
        /* Setup double click visualization */
        //############################################//
        _s.lasPosition;
        _s.setupVisualization = function(){
            _s.mainVz_do = new FWDUVPDisplayObject('div');
            _s.mainVz_do.getStyle().pointerEvents = 'none';
            _s.mainVz_do.getStyle().backgroundColor = 'rgba(0,0,0,0.01)';
            _s.mainVzBackgrond_do = new FWDUVPDisplayObject('div');
            _s.mainVzBackgrond_do.getStyle().width = '100%';
            _s.mainVzBackgrond_do.getStyle().height = '100%';
            _s.mainVzBackgrond_do.getStyle().backgroundColor = 'rgba(255,255,255, .15)';
            _s.mainVz_do.getStyle().borderRadius = '100%';
            _s.mainVz_do.addChild(_s.mainVzBackgrond_do);

            _s.circle_do = new FWDUVPTransformDisplayObject('div');
            _s.circle_do.getStyle().backgroundColor = 'rgba(255,255,255, .15)';
            _s.circle_do.getStyle().borderRadius = '100%';
            _s.mainVz_do.addChild(_s.circle_do);

            var vzImg1 = new Image();
            vzImg1.src = _s.mainFolderPath_str + _s.sknPth + 'vis.png';
            _s.vzImg1_do = new FWDUVPTransformDisplayObject('img');
            _s.vzImg1_do.setScreen(vzImg1);
            _s.vzImg1_do.setWidth(17);
            _s.vzImg1_do.setHeight(23);
            _s.mainVz_do.addChild(_s.vzImg1_do);

            var vzImg2 = new Image();
            vzImg2.src = _s.mainFolderPath_str + _s.sknPth + 'vis.png';
            _s.vzImg2_do = new FWDUVPTransformDisplayObject('img');
            _s.vzImg2_do.setScreen(vzImg2);
            _s.vzImg2_do.setWidth(17);
            _s.vzImg2_do.setHeight(23);
            _s.mainVz_do.addChild(_s.vzImg2_do);

            var vzImg3 = new Image();
            vzImg3.src = _s.mainFolderPath_str + _s.sknPth + 'vis.png';
            _s.vzImg3_do = new FWDUVPTransformDisplayObject('img');
            _s.vzImg3_do.setScreen(vzImg3);
            _s.vzImg3_do.setWidth(17);
            _s.vzImg3_do.setHeight(23);
            _s.mainVz_do.addChild(_s.vzImg3_do);
        }

        _s.addVisualization = function(pos){
            clearTimeout(_s.vizFinisedId_to);
            clearTimeout(_s.vizFinished2Id_to);
            var w = Math.round(_s.tempVidStageWidth/2);
            var h = Math.round(_s.tempVidStageHeight * 1.5);

            FWDAnimation.killTweensOf(_s.mainVzBackgrond_do);
            if(_s.lasPosition != pos) _s.mainVzBackgrond_do.setAlpha(0);
            FWDAnimation.to(_s.mainVzBackgrond_do, .4, {alpha:1});

            _s.mainVz_do.setVisible(true);
            _s.mainVz_do.setWidth(w);
            _s.mainVz_do.setHeight(h);
            _s.mainVz_do.setY((_s.tempVidStageHeight - h)/2);
            var offsetY = Math.abs(_s.mainVz_do.y);
            if(_s.controller_do && _s.controller_do.isShowed_bl) offsetY -= _s.controller_do.sH/2;
            if(!_s.videoHolder_do.contains(_s.mainVz_do)){
                if(_s.controller_do){
                    _s.videoHolder_do.addChildAt(_s.mainVz_do, _s.videoHolder_do.getChildIndex(_s.controller_do) - 1);
                }else{
                    _s.videoHolder_do.addChild(_s.mainVz_do);
                }
            } 
            if(pos == 'right'){
                _s.mainVz_do.getStyle().borderRadius = '100% 0% 0% 100%';
                _s.mainVz_do.setX(w);
                _s.vzImg1_do.setRotation(0);
                _s.vzImg2_do.setRotation(0);
                _s.vzImg3_do.setRotation(0);
            }else{
                _s.mainVz_do.getStyle().borderRadius = '0% 100% 100% 0%';
                _s.mainVz_do.setX(0);
                _s.vzImg1_do.setRotation(180);
                _s.vzImg2_do.setRotation(180);
                _s.vzImg3_do.setRotation(180);
            }

            _s.vzImg1_do.setX(Math.round(w - (_s.vzImg1_do.w * 3))/2);
            _s.vzImg1_do.setY(Math.round(offsetY + (_s.tempVidStageHeight - _s.vzImg1_do.h)/2));
            _s.vzImg2_do.setX(_s.vzImg1_do.x + _s.vzImg1_do.w);
            _s.vzImg2_do.setY(_s.vzImg1_do.y);
            _s.vzImg3_do.setX(_s.vzImg2_do.x + _s.vzImg2_do.w);
            _s.vzImg3_do.setY(_s.vzImg2_do.y);
            
            FWDAnimation.killTweensOf(_s.vzImg1_do);
            FWDAnimation.killTweensOf(_s.vzImg2_do);
            FWDAnimation.killTweensOf(_s.vzImg3_do);
            _s.vzImg1_do.setAlpha(0);
            _s.vzImg2_do.setAlpha(0);
            _s.vzImg3_do.setAlpha(0);
            if(pos == 'right'){
                FWDAnimation.to(_s.vzImg1_do, .4, {alpha:1});
                FWDAnimation.to(_s.vzImg1_do, .4, {alpha:0, delay:.3});
                FWDAnimation.to(_s.vzImg2_do, .4, {alpha:1, delay:.3});
                FWDAnimation.to(_s.vzImg2_do, .4, {alpha:0, delay:.6});
                FWDAnimation.to(_s.vzImg3_do, .4, {alpha:1, delay:.6});
                FWDAnimation.to(_s.vzImg3_do, .4, {alpha:0, delay:.9});
            }else{
                FWDAnimation.to(_s.vzImg3_do, .4, {alpha:1});
                FWDAnimation.to(_s.vzImg3_do, .4, {alpha:0, delay:.3});
                FWDAnimation.to(_s.vzImg2_do, .4, {alpha:1, delay:.3});
                FWDAnimation.to(_s.vzImg2_do, .4, {alpha:0, delay:.6});
                FWDAnimation.to(_s.vzImg1_do, .4, {alpha:1, delay:.6});
                FWDAnimation.to(_s.vzImg1_do, .4, {alpha:0, delay:.9});
            }

            FWDAnimation.killTweensOf(_s.circle_do);
            _s.circle_do.setAlpha(1);
            _s.circle_do.setScale2(1);
            _s.circle_do.setWidth(w);
            _s.circle_do.setHeight(w);
            _s.circle_do.setScale2(0);
            _s.circle_do.setX(_s.firstTapX - _s.mainVz_do.x - _s.circle_do.w/2);
            _s.circle_do.setY(_s.firstTapY + offsetY - _s.circle_do.w/2);
            FWDAnimation.to(_s.circle_do, .8, {scale:2, ease:Expo.easeInOut});

            _s.vizFinisedId_to = setTimeout(function(){
                FWDAnimation.to(_s.mainVzBackgrond_do, .4, {alpha:0});
                FWDAnimation.to(_s.circle_do, .4, {alpha:0});
                _s.vizFinished2Id_to = setTimeout(function(){
                    _s.mainVz_do.setVisible(false);
                }, 400)
            }, 800);

            _s.lasPosition = pos;
        }

        _s.stopVisualization =  function(){
            if(!_s.mainVz_do) return;
            clearTimeout(_s.vizFinisedId_to);
            clearTimeout(_s.vizFinished2Id_to);
            _s.mainVz_do.setVisible(false);
        }
        

        //############################################//
        /* Setup video hider */
        //############################################//
        _s.setupVideoHider = function(){
            _s.videoHider_do = new FWDUVPDisplayObject("div");
            _s.videoHolder_do.addChild(_s.videoHider_do);
        };
        
        _s.showVideoHider = function(){
            if(_s.isVideoHiderShowed_bl || !_s.videoHider_do) return;
            _s.isVideoHiderShowed_bl = true;
            _s.videoHider_do.setVisible(true);
            _s.resizeVideoHider();
        };
        
        _s.hideVideoHider = function(){
            if(!_s.isVideoHiderShowed_bl) return;
            _s.isVideoHiderShowed_bl = false;
            clearTimeout(_s.videoHilderId_to);
            _s.videoHilderId_to = setTimeout(function(){
                _s.videoHider_do.setVisible(false);
            }, 300);
        };
        
        _s.resizeVideoHider = function(){
            if(_s.isVideoHiderShowed_bl){
                _s.videoHider_do.setWidth(_s.tempStageWidth);
                _s.videoHider_do.setHeight(_s.tempStageHeight);
            }
        };
        

        //############################################//
        /* Setup youtube player */
        //############################################//
        _s.setupYoutubeAPI = function(){
            if(_s.ytb_do) return;
            if(typeof YT != "undefined" && YT.Player){
                _s.setupYoutubePlayer();
                return;
            }else{
                if(FWDUVPlayer.isYoutubeAPILoadedOnce_bl){
                    _s.keepCheckingYoutubeAPI_int =  setInterval(function(){
                        if(typeof YT != "undefined" && YT && YT.Player){
                            if(_s.videoSourcePath_str.indexOf("youtube.") == -1) clearInterval(_s.keepCheckingYoutubeAPI_int);
                            clearInterval(_s.keepCheckingYoutubeAPI_int);
                            _s.setupYoutubePlayer();
                        }
                    }, 50);
                    return;
                }
                
                var tag = document.createElement("script");
                tag.src = "https://www.youtube.com/iframe_api";
                var firstScriptTag = document.getElementsByTagName("script")[0];
                firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
            
                tag.onload = function(){
                    _s.checkIfYoutubePlayerIsReadyId_int = setInterval(function(){
                        if(YT && YT.Player){
                            clearInterval(_s.checkIfYoutubePlayerIsReadyId_int);
                            _s.setupYoutubePlayer();
                        }
                    }, 50);
                }
                
                tag.onerror = function(){
                    setTimeout(function(){
                        _s.showSourceError("Error loading Youtube API");
                    }, 500);
                    return;
                }
                
                FWDUVPlayer.isYoutubeAPILoadedOnce_bl = true;
            }
        };
        
        _s.setupYoutubePlayer = function(){
            if(_s.ytb_do) return;
            
            
            FWDUVPYoutubeScreen.setPrototype();
            _s.ytb_do = new FWDUVPYoutubeScreen(_s, _s._d.volume);
            _s.ytb_do.addListener(FWDUVPYoutubeScreen.READY, _s.youtubeReadyHandler);
            _s.ytb_do.addListener(FWDUVPVideoScreen.ERROR, _s.videoScreenErrorHandler);
            _s.ytb_do.addListener(FWDUVPYoutubeScreen.SAFE_TO_SCRUBB, _s.videoScreenSafeToScrubbHandler);
            _s.ytb_do.addListener(FWDUVPYoutubeScreen.STOP, _s.videoScreenStopHandler);
            _s.ytb_do.addListener(FWDUVPYoutubeScreen.PLAY, _s.videoScreenPlayHandler);
            _s.ytb_do.addListener(FWDUVPYoutubeScreen.PAUSE, _s.videoScreenPauseHandler);
            _s.ytb_do.addListener(FWDUVPYoutubeScreen.UPDATE, _s.videoScreenUpdateHandler);
            _s.ytb_do.addListener(FWDUVPYoutubeScreen.UPDATE_TIME, _s.videoScreenUpdateTimeHandler);
            _s.ytb_do.addListener(FWDUVPYoutubeScreen.LOAD_PROGRESS, _s.videoScreenLoadProgressHandler);
            _s.ytb_do.addListener(FWDUVPYoutubeScreen.PLAY_COMPLETE, _s.videoScreenPlayCompleteHandler);
            _s.ytb_do.addListener(FWDUVPYoutubeScreen.CUED, _s.youtubeScreenCuedHandler);
            _s.ytb_do.addListener(FWDUVPYoutubeScreen.QUALITY_CHANGE, _s.youtubeScreenQualityChangeHandler);
            _s.ytb_do.addListener(FWDUVPYoutubeScreen.UPDATE_SUBTITLE, _s.videoScreenUpdateSubtitleHandler);

            if(!_s.isMobile_bl) _s.ytb_do.showDisable();
        };
        
        _s.youtubeReadyHandler = function(e){
            
            _s.isYoutubeReady_bl = true;
        
            _s.hidePreloaderId_to = setTimeout(function(){
                if(_s.preloader_do) _s.preloader_do.hide(true);}
            , 50);
            
            _s.isTempYoutubeAdd_bl = _s.isAdd_bl;
            if(_s.isAdd_bl){
                if(_s.videoType_str == FWDUVPlayer.YOUTUBE) _s.setSource(_s.addSource_str);
            }else{
                if(_s.videoType_str == FWDUVPlayer.YOUTUBE) _s.updateAds(0, true);
            }
        };
        
        _s.youtubeScreenCuedHandler = function(){
            if(_s.main_do) if(_s.main_do.contains(_s.info_do)) _s.main_do.removeChild(_s.info_do);
        };
        
        _s.youtubeScreenQualityChangeHandler = function(e){
            if(_s.videoType_str == FWDUVPlayer.VIDEO) _s.curDurration = _s.videoScreen_do.curDuration;
            if(_s.controller_do) _s.controller_do.updateQuality(e.levels, e.qualityLevel);
        };

        
        //############################################//
        /* Setup Vimeo API */
        //############################################//
        _s.setupVimeoAPI = function(){
            if(_s.vimeo_do) return;
            if(typeof Vimeo != "undefined" && Vimeo.Player){
                _s.setupVimeoPlayer();
                return;
            }else{
                if(FWDUVPlayer.isVimeoAPILoadedOnce_bl){
                    _s.keepCheckingVimeoAPI_int =  setInterval(function(){
                        if(typeof Vimeo != "undefined" && Vimeo && Vimeo.Player){
                            if(_s.videoSourcePath_str.indexOf("vimeo.") == -1) clearInterval(_s.keepCheckingVimeoAPI_int);
                            clearInterval(_s.keepCheckingVimeoAPI_int);
                            _s.setupVimeoPlayer();
                        }
                    }, 50);
                    return;
                }
                
                var tag = document.createElement("script");
                tag.src = "https://player.vimeo.com/api/player.js";
                var firstScriptTag = document.getElementsByTagName("script")[0];
                firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
            
                tag.onload = function(){
                    _s.keepCheckingVimeoAPI_int = setInterval(function(){
                        if(typeof Vimeo != "undefined" && Vimeo && Vimeo.Player){
                            clearInterval(_s.keepCheckingVimeoAPI_int);
                            _s.setupVimeoPlayer();
                        }
                    }, 50);
                }
                                        
                tag.onerror = function(){
                    setTimeout(function(){
                        _s.showSourceError("Error loading Vimeo API");
                    }, 500);
                    return;
                }
                
                FWDUVPlayer.isVimeoAPILoadedOnce_bl = true;
            }
        };
        

        //############################################//
        /* Setup Vimeo player */
        //############################################// 
        _s.setupVimeoPlayer = function(){
            if(_s.vimeo_do) return;
            FWDUVPVimeoScreen.setPrototype();

            _s.vimeo_do = new FWDUVPVimeoScreen(_s, _s._d.volume);
            _s.vimeo_do.addListener(FWDUVPVimeoScreen.ERROR, _s.vimeoInitErrorHandler);
            _s.vimeo_do.addListener(FWDUVPVimeoScreen.READY, _s.vimeoReadyHandler);
            
            _s.vimeo_do.addListener(FWDUVPVimeoScreen.SAFE_TO_SCRUBB, _s.videoScreenSafeToScrubbHandler);
            _s.vimeo_do.addListener(FWDUVPVimeoScreen.STOP, _s.videoScreenStopHandler);
            _s.vimeo_do.addListener(FWDUVPVimeoScreen.PLAY, _s.videoScreenPlayHandler);
            _s.vimeo_do.addListener(FWDUVPVimeoScreen.PAUSE, _s.videoScreenPauseHandler);
            _s.vimeo_do.addListener(FWDUVPVimeoScreen.UPDATE, _s.videoScreenUpdateHandler);
            _s.vimeo_do.addListener(FWDUVPVimeoScreen.UPDATE_TIME, _s.videoScreenUpdateTimeHandler);
            _s.vimeo_do.addListener(FWDUVPVimeoScreen.LOAD_PROGRESS, _s.videoScreenLoadProgressHandler);
            _s.vimeo_do.addListener(FWDUVPVimeoScreen.PLAY_COMPLETE, _s.videoScreenPlayCompleteHandler);
            _s.vimeo_do.addListener(FWDUVPVimeoScreen.UPDATE_SUBTITLE, _s.videoScreenUpdateSubtitleHandler);
            
        };
        
        _s.vimeoInitErrorHandler = function(e){
            _s.showSourceError(e.error);
        };
        
        _s.vimeoReadyHandler = function(e){
            _s.isVimeoReady_bl = true;
    
            clearInterval(_s.hidePreloaderId_to);
            _s.hidePreloaderId_to = setTimeout(function(){
                if(_s.preloader_do) _s.preloader_do.hide(true);}
            , 50);
        
            if(_s.isAdd_bl){
                if(_s.videoType_str == FWDUVPlayer.VIMEO) _s.setSource(_s.addSource_str);
            }else{
                if(_s.videoType_str == FWDUVPlayer.VIMEO) _s.updateAds(0, true);
            }
        };      

        
        //#############################################//
        /* setup context menu */
        //#############################################//
        _s.setupContextMenu = function(){
            FWDUVPContextMenu.setPrototype();
            _s.customContextMenu_do = new FWDUVPContextMenu(_s, _s._d);
        };


        //#############################################//
        /* setup RSM */
        //#############################################//
        _s.setupRSM = function(){
            window.addEventListener("beforeunload", function (e) {
                var test = Math.random() * 1000;
                if(_s.isPlaying_bl && !_s.isAdd_bl){
                    document.cookie = "fwduvp_video_path=" + _s.videoSourcePath_str + "; expires=Thu, 18 Dec 2040 00:00:01 GMT; path=/";
                    var curTime = _s.getCurrentTime();
                    if(curTime.length == 5) curTime = "00:" + curTime;
                    document.cookie = "fwduvp_time=" + curTime + "; expires=Thu, 18 Dec 2040 00:00:01 GMT; path=/"; 
                }
            });
        };
        
        
        //#############################################//
        /* setup _d */
        //#############################################//
        _s.setupData = function(){
            FWDUVPData.setPrototype();
            _s._d = new FWDUVPData(_s.props, _s.rootElement_el, _s);
            _s._d.useYoutube_bl = _s.useYoutube_bl;
            
            if(_s.mainBackground_do) _s.mainBackground_do.getStyle().background = "url('" + _s.mainBackgroundImagePath_str + "')";
            
            _s._d.addListener(FWDUVPData.VAST_LOADED, _s.vastLoaded);
            _s._d.addListener(FWDUVPData.PRELOADER_LOAD_DONE, _s.onPreloaderLoadDone);
            _s._d.addListener(FWDUVPData.LOAD_ERROR, _s._dLoadError);
            _s._d.addListener(FWDUVPData.SKIN_PROGRESS, _s._dSkinProgressHandler);
            _s._d.addListener(FWDUVPData.SKIN_LOAD_COMPLETE, _s._dSkinLoadComplete);
            _s._d.addListener(FWDUVPData.PLAYLIST_LOAD_COMPLETE, _s._dPlayListLoadComplete);
            _s._d.addListener(FWDUVPData.IMA_READY, _s._dImaReady);
            _s._d.addListener(FWDUVPData.IMA_ERROR, _s._dImaError);
            
        };
        
        _s.vastLoaded = function(e){
            _s.isAdd_bl = false
            _s.isVastLoading_bl = false;
            _s._d.playlist_ar[_s.id].popupAds_ar = e.popupAds;
            _s._d.playlist_ar[_s.id].ads_ar = e.ads;
            _s.adsId = -1;
            _s.updateAds(0);
            _s.dispatchEvent(FWDUVPData.VAST_LOADED);
        }
    
        _s.onPreloaderLoadDone = function(){
            if(_s.showPreloader_bl) _s.setupPreloader();
            if(!_s.isMbl) _s.setupContextMenu();
            _s.fillEntireVideoScreen_bl = _s._d.fillEntireVideoScreen_bl;
            _s.resizeHandler();
        };
        
        _s._dLoadError = function(e){
            _s.showSourceError(e.text);
            if(_s.playlist_do) _s.playlist_do.catId = -1;
            _s.dispatchEvent(FWDUVPlayer.ERROR, {error:e.text});
        };
        
        _s._dSkinProgressHandler = function(e){};
        
        _s._dSkinLoadComplete = function(){
            if(location.protocol.indexOf("file:") != -1){
                if(FWDUVPUtils.isOpera || FWDUVPUtils.isIEAndLessThen9){
                    _s.showSourceError("This browser can't play video local, please test online or use a browser like Firefox of Chrome.");
                    return;
                }
            }

            if(_s.showOnlyThumbnail){
                _s.playlistWidth = _s.playListThumbnailWidth;
            }
            
            _s.volume = _s._d.volume;
            _s.playlistHeight = _s._d.playlistBottomHeight;
            
            if(_s.displayType == FWDUVPlayer.FULL_SCREEN  && !FWDUVPUtils.hasFullScreen){
                _s._d.showFullScreenButton_bl = false;
            }
        
            if(_s.isEmbedded_bl){
                _s.useDeepLinking_bl = false;
                _s._d.playlistPosition_str = "right";
            }
            
            if(FWDUVPlayer.atLeastOnePlayerHasDeeplinking_bl) _s.useDeepLinking_bl = false;
            if(_s.useDeepLinking_bl) FWDUVPlayer.atLeastOnePlayerHasDeeplinking_bl = true;
            
            if(_s.useDeepLinking_bl){
                setTimeout(function(){_s.setupDL();}, 200);
            }else{
                if(_s.isEmbedded_bl){
                    _s.catId = _s.embeddedPlaylistId;
                    _s.id = _s.embeddedVideoId;
                }else{
                    var args = FWDUVPUtils.getHashUrlArgs(window.location.hash);
                    if(_s.useDeepLinking_bl && args.playlistId !== undefined && args.videoId !== undefined){
                        _s.catId = args.playlistId;
                        _s.id = args.videoId;
                    }else{
                        if(args.videoId){
                            _s.id = args.videoId;
                        }else{
                            _s.id = _s._d.startAtVideo;
                        }

                        if(args.playlistId){
                            _s.catId = args.playlistId;
                        }else{
                            _s.catId = _s._d.startAtPlaylist;
                        }
                        
                    }
                }
                _s.loadInternalPlaylist();
            }
        };
        
        _s._dPlayListLoadComplete = function(){
            if(_s._d.cats_ar[_s.catId].pass) _s.playlistPass = _s._d.cats_ar[_s.catId].pass;
            
            _s.loadAddFirstTime_bl = true;
            if(!_s.isPlaylistLoadedFirstTime_bl){
                _s.setupNormalVideoPlayers();
                if(!FWDUVPUtils.isIEAndLessThen9) _s.updatePlaylist();
            }
            
            if(_s.isPlaylistLoadedFirstTime_bl) _s.updatePlaylist();    
            _s.isPlaylistLoaded_bl = true;
            _s.videoHolder_do.setY(0);
            _s.resizeHandler();
            setTimeout(function(){
                _s.positionLargePlayButton();
                if(_s.controller_do) _s.controller_do.resizeAndPosition();
                if(_s.playlist_do) _s.playlist_do.resizeAndPosition();
            }, 350);
        };
        
        _s.updatePlaylist = function(){
            _s.videoType_str =  "none";
            if(!_s._d.playlist_ar || !_s._d.playlist_ar[_s.id]) return;
            
            if(_s.main_do) if(_s.main_do.contains(_s.info_do)) _s.main_do.removeChild(_s.info_do);
            if(_s.preloader_do){
                _s.preloader_do.hide(true);
            } 

            _s.totaadsIdeos = _s._d.playlist_ar.length;
            
            if(_s.id < 0){
                _s.id = 0;
            }else if(_s.id > _s.totaadsIdeos - 1){
                _s.id = _s.totaadsIdeos - 1;
            }
            
            
            if(_s.playlist_do) _s.playlist_do.updatePlaylist(_s._d.playlist_ar, _s.catId, _s.id, _s._d.cats_ar[_s.catId].playlistName);
            _s.hideVideoHider();
            
            if(_s._d.startAtRandomVideo_bl){
                _s.id = parseInt(Math.random() * _s._d.playlist_ar.length);
                if(_s.useDeepLinking_bl){
                    FWDUVPDL.setValue("?playlistId=" + _s.catId + "&videoId=" + _s.id);
                    return;
                }
            }
            _s.plPassPassed = false;
            _s.prevSource = Math.random() * 99999999999;
            _s.posterPath_str = _s._d.playlist_ar[_s.id].posterSource;
            _s.updateAds(0);
            
            if(_s.isFirstPlaylistLoaded_bl && !_s.isMbl && !_s._d.startAtRandomVideo_bl && _s._d.autoPlay_bl) _s.play();
            _s._d.startAtRandomVideo_bl = false;
            _s.isFirstPlaylistLoaded_bl = true;
            _s.dispatchEvent(FWDUVPlayer.LOAD_PLAYLIST_COMPLETE);
            
            if(_s.displayType == FWDUVPlayer.STICKY){
                setTimeout(function(){
                    _s.isShowedFirstTime_bl = false;
                    _s.setStageContainerFinalHeightAndPosition(_s.animate_bl);
                }, 50);
            }
        };
        
        _s._dImaReady = function(){
            if(_s.isIMA) _s.setSource(_s.videoSourcePath_str);
        }
        
        _s._dImaError = function(){
            _s.errorImaSDK = true;
            _s.setSource(_s.videoSourcePath_str);
        }

        
        //############################################//
        /* Load playlists */
        //############################################//
        _s.loadInternalPlaylist = function(){
            
            _s.isPlaylistLoaded_bl = false;
            _s.isThumbClick_bl = false;
            _s.playlistPass = false;
            _s.isAdd_bl = false;
            _s.adsId = -1;
            
            _s.prvAdSource = Math.random() * 999999999;
            if(_s.prevCatId == _s.catId) return;
            _s.prevCatId = _s.catId;

            if(_s.preloader_do){
                 _s.positionPreloader();
                 _s.preloader_do.show(false);
            }
        
            _s.stop();
            _s.videoHolder_do.setY(-5000);
            if(_s.hider) _s.hider.stop();
            _s.setPosterSource("none");
            if(_s.videoPoster_do){
                _s.videoPoster_do.id = -1;
                _s.videoPoster_do.hide(true);
            }
        
            if(_s.lrgPlayBtn) _s.lrgPlayBtn.hide();
            if(_s.controller_do) _s.controller_do.hide(false, 10);
            _s.showVideoHider();
            _s._d.resetVastId();
            if(_s.popupAds_do) _s.popupAds_do.resetId();

            _s._d.loadPlaylist(_s.catId);
            if(_s.logo_do) _s.logo_do.hide(false, true);
            if(_s.isAdd_bl){
                _s.adsSkip_do.hide(false);
                _s.adsStart_do.hide(false);
            }
            

            if(_s.playlist_do) _s.playlist_do.destroyPlaylist();
            
            if(_s.isAPIReady_bl) _s.dispatchEvent(FWDUVPlayer.START_TO_LOAD_PLAYLIST);
        };

        
        //############################################//
        /* update deeplink */
        //############################################//
        _s.setupDL = function(){
            _s.initFirstDL = true;
            FWDUVPDL.onChange = _s.dlChangeHandler;
            if(_s.isEmbedded_bl){
                FWDUVPDL.setValue("?playlistId=" + _s.embeddedPlaylistId + "&videoId=" + _s.embeddedVideoId);
            }
            _s.dlChangeHandler();
        };
        
        _s.dlChangeHandler = function(){
            if(_s.hasOpenedInPopup_bl) return;
            
            var mustReset_bl = false;
            
            if(_s.categories_do && _s.categories_do.isOnDOM_bl){
                _s.categories_do.hide();
                return;
            }
            
            _s.prevId = _s.id;
            _s.prevEventCatId = _s.catId;
            
            _s.catId = parseInt(FWDUVPDL.getParameter("playlistId"));
            _s.id = parseInt(FWDUVPDL.getParameter("videoId"));
            
            if(_s.catId == undefined || _s.id == undefined || isNaN(_s.catId) || isNaN(_s.id)){
                _s.catId = _s._d.startAtPlaylist;
                _s.id = _s._d.startAtVideo;
                mustReset_bl = true;
            }
        
            if(_s.catId < 0 || _s.catId > _s._d.totalCategories - 1 && !mustReset_bl){
                _s.catId = _s._d.startAtPlaylist;
                _s.id = _s._d.startAtVideo;
                mustReset_bl = true;
            }
            
            if(_s._d.playlist_ar){
                if(_s.id < 0 && !mustReset_bl){
                    _s.id = _s._d.startAtVideo;
                    mustReset_bl = true;
                }else if(_s.prevCatId == _s.catId && _s.id > _s._d.playlist_ar.length - 1  && !mustReset_bl){
                    _s.id = _s._d.playlist_ar.length - 1;
                    mustReset_bl = true;
                }
            }
            _s.totalDuration = 0;
            var curValue = _s.catId +  ' - ' + _s.id;
            if(mustReset_bl){
                FWDUVPDL.setValue("?playlistId=" + _s.catId + "&videoId=" + _s.id);
                return;
            }
            if(_s.lastValue == curValue) return;
            _s.lastValue = _s.catId +  ' - ' + _s.id;
            
            if(_s.prevId == -1) _s.prevId  = _s.id;
            if(_s.prevEventCatId == -1) _s.prevEventCatId = _s.catId;
            
            if(_s.prevCatId != _s.catId){
                _s.loadInternalPlaylist();
                _s.prevCatId = _s.catId;
            }else{
                _s.stop();
                _s.isThumbClick_bl = true;
                _s.updateAds(0, true);
                _s._d.startAtRandomVideo_bl = false;
            }
            
            _s.pastHref = window['location']['href'];
        };
        
        
        //###########################################//
        /* Setup normal video players */
        //###########################################//
        _s.setupNormalVideoPlayers = function(){
            if(_s.videoScreen_do) return;
            
            _s.isAPIReady_bl = true;
            _s.setupRSM();
            _s.setupVideoScreen();
            _s.setupAudioScreen();
            _s.setupVideoPoster();
            if(_s.preloader_do) _s.main_do.addChild(_s.preloader_do);
            _s.setupSubtitle();
            _s.setupClickScreen();
            _s.setupPopupAds();
            if(_s._d.showLogo_bl) _s.setupLogo();
            _s.addDoubleClickSupport();
            _s.setupVideoHider();
            _s.setupAnnotations();
            if(_s._d.showController_bl) _s.setupController();
            _s.setupAdsStart();
            if(_s._d.showPlaylistButtonAndPlaylist_bl) _s.setupPlaylist();
            _s.setupLargePlayPauseButton();
            if(_s._d.showChromecastButton_bl) _s.setupChormecast();
            if(_s._d.showController_bl) _s.setupHider();
            if(_s._d.showPlaylistsButtonAndPlaylists_bl) _s.setupCategories();
            _s.setupDisableClick();
            if(_s._d.showEmbedButton_bl) _s.setupEmbedWindow();
            _s.setupPasswordWindow();
            if(!_s._d.isLoggedIn_bl && _s._d.showController_bl) _s.setupLoginWindow();
            if(_s._d.showShareButton_bl) _s.setupShareWindow();
            _s.setupAopw();
            if(_s._d.showInfoButton_bl) _s.setupInfoWindow();
            if((_s._d.showOpener_bl && _s.displayType == FWDUVPlayer.STICKY)
                || (_s._d.stickyOnScrollShowOpener_bl && _s.stickyOnScroll)){
                _s.setupOpener();
            } 

            if(_s._d.useFingerPrintStamp){
                _s.setupFingerPrintStamp();
            }
            
            if(FWDUVPlayer.useYoutube == "no") _s.isPlaylistLoadedFirstTime_bl = true;
            _s.addMinOnScroll();
            _s.isAPIReady_bl = true;
            _s.dispatchEvent(FWDUVPlayer.READY);
            
            if(_s._d.addKeyboardSupport_bl) _s.addKeyboardSupport();
        
        };


        //###########################################//
        /* setup finger print stamp */
        //###########################################//
        _s.setupFingerPrintStamp = function(){
            FWDUVPFPS.setPrototype();
            _s.fps = new FWDUVPFPS(_s)
            _s.videoHolder_do.addChild(_s.fps);
        }
        
        
        //###########################################//
        /* setup opener */
        //###########################################//
        _s.setupOpener = function(){
    
            FWDUVPOpener.setPrototype();
            _s.opener_do = new FWDUVPOpener(_s._d, _s.position_str, _s.isShowed_bl);
            if(FWDUVPUtils.isIEAndLessThen9){
                _s.opener_do.getStyle().zIndex = "2147483634";
            }else{
                _s.opener_do.getStyle().zIndex = "99999999994";
            }
            _s.opener_do.setX(-10000);
            if(_s.isShowed_bl){
                _s.opener_do.showCloseButton();
            }else{
                _s.opener_do.showOpenButton();
            }
            _s.opener_do.addListener(FWDUVPOpener.SHOW, _s.openerShowHandler);
            _s.opener_do.addListener(FWDUVPOpener.HIDE, _s.openerHideHandler);
            _s.opener_do.addListener(FWDUVPController.PLAY, _s.controllerOnPlayHandler);
            _s.opener_do.addListener(FWDUVPController.PAUSE, _s.controllerOnPauseHandler);
            _s.stageContainer.appendChild(_s.opener_do.screen);
            if(_s.stickyOnScroll){
                 _s.opener_do.getStyle().position = 'fixed';
                 document.documentElement.appendChild(_s.opener_do.screen);
            }
        };
        
        _s.openerShowHandler = function(){
            _s.showPlayer();
        };
        
        _s.openerHideHandler = function(){
            _s.hidePlayer();
        };
        

        //#############################################//
        /* setup preloader */
        //#############################################//
        _s.setupPreloader = function(){
            FWDUVPPreloader.setPrototype();
            _s.preloader_do = new FWDUVPPreloader(_s, 'center', 10, _s.preloaderBackgroundColor, _s.preloaderFillColor, 3, 0.8);
            _s.preloader_do.show(false);
            if(_s.showPreloader_bl){
                if(_s.displayType == FWDUVPlayer.STICKY){
                    document.documentElement.appendChild(_s.preloader_do.screen);
                }else{
                    _s.main_do.addChild(_s.preloader_do);
                }
            }
        };
    
        _s.positionPreloader = function(){
            if(_s.displayType == FWDUVPlayer.STICKY){
                if(!_s.main_do.contains(_s.preloader_do)){
                    _s.preloader_do.setX(Math.round((_s.ws.w - _s.preloader_do.w)/2));
                    if(_s.position_str == FWDUVPlayer.POSITION_BOTTOM){
                        _s.preloader_do.setY(Math.round((_s.ws.h - _s.preloader_do.h) - 10) + FWDUVPUtils.getScrollOffsets().y);
                    }else{
                        _s.preloader_do.setY(10);
                    }
                }else{
                    posPreloader();
                }
            }else{
                posPreloader();
            }

            function posPreloader(){
                var x;
                if(!_s.isPlaylistLoaded_bl){
                    x = _s.sW;
                }else{
                    x = _s.tempVidStageWidth;
                }
                _s.preloader_do.setX(parseInt((x - _s.preloader_do.w)/2));
                _s.preloader_do.setY(parseInt((_s.tempVidStageHeight - _s.preloader_do.h)/2));
            }
        };
        

        //###########################################//
        /* setup categories */
        //###########################################//
        _s.setupCategories = function(){
            FWDUVPCategories.setPrototype();
            _s.categories_do = new FWDUVPCategories(_s._d, _s);
            _s.categories_do.getStyle().zIndex = "2147483647";
            _s.categories_do.addListener(FWDUVPCategories.HIDE_COMPLETE, _s.categoriesHideCompleteHandler);
            if(_s._d.showPlaylistsByDefault_bl){
                _s.showCatWidthDelayId_to = setTimeout(function(){
                    _s.showCategories();
                }, 1400);
            };
        };
        
        _s.categoriesHideCompleteHandler = function(e){
            if(_s.controller_do){
                _s.controller_do.setCategoriesButtonState("unselected");
                _s.controller_do.categoriesButton_do.setNormalState(true);
            }
            
            if(_s.useDeepLinking_bl){
                if(_s.categories_do.id != _s.catId){
                    _s.catId = _s.categories_do.id;
                    _s.id = 0;
                    FWDUVPDL.setValue("?playlistId=" + _s.catId + "&videoId=" + _s.id);
                    return;
                }
            }else{
                if(_s.catId == _s.categories_do.id) return;
                _s.catId = _s.categories_do.id;
                _s.id = 0;
                _s.loadInternalPlaylist(_s.catId);
            }
            
            if(_s.isVideoPlayingWhenOpenWindows_bl) _s.resume();
        };
        

        //##########################################//
        /* setup video poster */
        //##########################################//
        _s.setupVideoPoster = function(){
            FWDUVPPoster.setPrototype();
            _s.videoPoster_do = new FWDUVPPoster(_s,  _s._d.show, _s._d.posterBackgroundColor_str);
            _s.videoHolder_do.addChild(_s.videoPoster_do);
        };
        

        //##########################################//
        /* setup info window */
        //##########################################//
        _s.setupInfoWindow = function(){
            FWDUVPInfoWindow.setPrototype();
            _s.infoWindow_do = new FWDUVPInfoWindow(_s, _s._d);
            _s.infoWindow_do.addListener(FWDUVPInfoWindow.HIDE_COMPLETE, _s.infoWindowHideCompleteHandler);
            _s.main_do.addChild(_s.infoWindow_do);
        };
        
        _s.infoWindowHideCompleteHandler = function(){
            
            if(_s.isVideoPlayingWhenOpenWindows_bl) _s.resume();
            
            if(_s.controller_do && !_s.isMbl){
                _s.controller_do.infoButton_do.isDisabled_bl = false;
                _s.controller_do.infoButton_do.setNormalState(true);
            }
        };

        
        //##########################################//
        /* setup chromecast */
        //##########################################//
        _s.setupChormecast = function(){
            if(!_s._d.showController_bl) return;
            FWDUVPCC.setPrototype();
            _s.cc = new FWDUVPCC(_s.controller_do);
        }

        
        //###########################################//
        /* Setup large play / pause button */
        //###########################################//
        _s.setupLargePlayPauseButton = function(){
            if(_s._d.useVectorIcons_bl){                
                FWDUVPSimpleButton.setPrototype();
                _s.lrgPlayBtn = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<div class='table-fwduvp-button'><span class='table-cell-fwduvp-button fwdicon-play'></span></div>",
                        undefined,
                        "UVPLargePlayButtonNormalState",
                        "UVPLargePlayButtonSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                if(_s.sknPth.indexOf("hex_white") != -1){
                    _s.lrgPlayBtn = new FWDUVPSimpleButton(_s._d.largePlayN_img, _s._d.largePlayS_str, undefined, true,
                                                             _s._d.useHEX,
                                                             _s._d.nBC,
                                                             "#FFFFFF",
                                                             false, false, false, false, true);
                }else{
                    _s.lrgPlayBtn = new FWDUVPSimpleButton(_s._d.largePlayN_img, _s._d.largePlayS_str, undefined, true,
                                                             _s._d.useHEX,
                                                             _s._d.nBC,
                                                             _s._d.sBC,
                                                             false, false, false, false, true);
                }
            }
            
            _s.lrgPlayBtn.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.largePlayButtonUpHandler);
            _s.lrgPlayBtn.setOverflow("visible");
            _s.lrgPlayBtn.hide(false);
            _s.main_do.addChild(_s.lrgPlayBtn);
        };
        
        _s.largePlayButtonUpHandler = function(){
            if(_s.isIMA && _s.IMA && !_s.IMA.isReady) return;
            _s.isThumbClick_bl = true;
            _s.disableClick();
            _s.lrgPlayBtn.hide();
            _s.play();
            if(_s._d.goFullScreenOnPlay_bl) _s.goFullScreen();
        };
        
        _s.positionLargePlayButton =  function(){
            _s.lrgPlayBtn.setX(parseInt((_s.tempVidStageWidth - _s.lrgPlayBtn.w)/2));
            _s.lrgPlayBtn.setY(parseInt((_s.tempVidStageHeight - _s.lrgPlayBtn.h)/2));
        };

        
        //###########################################//
        /* Setup logo */
        //###########################################//
        _s.setupLogo = function(){
            FWDUVPLogo.setPrototype();
            _s.logo_do = new FWDUVPLogo(_s, _s._d.logoPath_str, _s._d.logoPosition_str, _s._d.logoMargins, _s._d.logoTarget);
            _s.main_do.addChild(_s.logo_do);
        };
        

        //###########################################//
        /* Setup playlist */
        //###########################################//
        _s.setupPlaylist = function(){
            FWDUVPPlaylist.setPrototype();
            _s.playlist_do = new FWDUVPPlaylist(_s, _s._d);
            _s.playlist_do.addListener(FWDUVPPlaylist.THUMB_MOUSE_UP, _s.playlistThumbMouseUpHandler);
            _s.playlist_do.addListener(FWDUVPPlaylist.PLAY_PREV_VIDEO, _s.playPrevVideoHandler);
            _s.playlist_do.addListener(FWDUVPPlaylist.PLAY_NEXT_VIDEO, _s.playNextVideoHandler);
            _s.playlist_do.addListener(FWDUVPPlaylist.ENABLE_SHUFFLE, _s.enableShuffleHandler);
            _s.playlist_do.addListener(FWDUVPPlaylist.DISABLE_SHUFFLE, _s.disableShuffleHandler);
            _s.playlist_do.addListener(FWDUVPPlaylist.ENABLE_LOOP, _s.enableLoopHandler);
            _s.playlist_do.addListener(FWDUVPPlaylist.DISABLE_LOOP, _s.disableLoopHandler);
            _s.playlist_do.addListener(FWDUVPPlaylist.CHANGE_PLAYLIST, _s.changePlaylistHandler);
            _s.main_do.addChildAt(_s.playlist_do, 0);
            if(_s._d.useVectorIcons_bl){
                setTimeout(function(){
                    _s.playlist_do.resizeAndPosition(true);
                }, 340);
            }
        };
        
        _s.changePlaylistHandler = function(e){
            _s.loadPlaylist(e.id);
        }
        
        _s.playlistThumbMouseUpHandler = function(e){
            if(_s.disableClick_bl) return;
            
            if(_s._d.playlist_ar){
                _s.videoNameGa = _s._d.playlist_ar[_s.id]["gaStr"]
                _s.videoCat = _s._d.cats_ar[_s.catId]["playlistName"];
            }
            _s.totalDuration = 0;
            
            if(_s.useDeepLinking_bl && _s.id != e.id){
                FWDUVPDL.setValue("?playlistId=" + _s.catId + "&videoId=" + e.id);
                _s.id = e.id;
                _s.isThumbClick_bl = true;
            }else{
                _s.stop();
                _s.id = e.id;
                _s.changeHLS_bl = true;
                _s.isThumbClick_bl = true;
                _s.isAdd_bl = false;
                
                _s.updateAds(0);            
            }
            if(_s._d.goFullScreenOnPlay_bl) _s.goFullScreen();
        };
        
        _s.playPrevVideoHandler = function(){
            _s.isThumbClick_bl = true;
            if(_s._d.shuffle_bl){
                _s.playShuffle();
            }else{
                _s.playPrev();
            }
        };
        
        _s.playNextVideoHandler = function(){
        
            _s.isThumbClick_bl = true;
            if(_s._d.shuffle_bl){
                _s.playShuffle();
            }else{
                _s.playNext();
            }
        };
        
        _s.enableShuffleHandler = function(e){
            _s._d.shuffle_bl = true;
            _s._d.loop_bl = false;
            _s.playlist_do.setShuffleButtonState("selected");
            _s.playlist_do.setLoopStateButton("unselected");
        };
        
        _s.disableShuffleHandler = function(e){
            _s._d.shuffle_bl = false;
            _s.playlist_do.setShuffleButtonState("unselected");
        };
        
        _s.enableLoopHandler = function(e){
            _s._d.loop_bl = true;
            _s._d.shuffle_bl = false;
            _s.playlist_do.setLoopStateButton("selected");
            _s.playlist_do.setShuffleButtonState("unselected");
        };
        
        _s.disableLoopHandler = function(e){
            _s._d.loop_bl = false;
            _s.playlist_do.setLoopStateButton("unselected");
        };


        //###########################################//
        /* Setup autoplay click. */
        //###########################################//
        _s.setupAPT = function(){
            if(!_s.apt && _s._d.autoPlayText && _s._d.autoPlay_bl){
                _s.apt = new FWDUVPTransformDisplayObject('div');
                _s.apt.screen.className = 'fwduvp-autoplay-text';
                _s.apt.setButtonMode(true);
                _s.apt.setInnerHTML(_s._d.autoPlayText + '<svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0)"><path d="M9.4272 0.430497C9.4272 0.267667 9.33293 0.113407 9.18724 0.0448468C9.03298 -0.0322832 8.86158 -0.00657319 8.73303 0.0962667L4.93652 3.12147L9.4272 7.61215V0.430497Z" fill="black"/><path d="M11.8742 11.2702L0.733188 0.129242C0.566073 -0.0378725 0.294404 -0.0378725 0.127289 0.129242C-0.0398256 0.296357 -0.0398256 0.568026 0.127289 0.735141L2.82341 3.43212H2.57231C2.30664 3.43212 2.07525 3.5521 1.92099 3.74064C1.79244 3.88633 1.71531 4.08344 1.71531 4.28912V7.71712C1.71531 8.18847 2.10096 8.57412 2.57231 8.57412H4.56055L8.73413 11.9078C8.81126 11.9678 8.90553 12.0021 8.9998 12.0021C9.05979 12.0021 9.12835 11.985 9.18834 11.9593C9.33403 11.8907 9.4283 11.7364 9.4283 11.5736V10.037L11.2674 11.8761C11.3514 11.9601 11.4611 12.0021 11.5708 12.0021C11.6805 12.0021 11.7902 11.9601 11.8742 11.877C12.0413 11.709 12.0413 11.4382 11.8742 11.2702Z" fill="black"/></g></svg>');
                _s.main_do.addChild(_s.apt);

                _s.apt.screen.addEventListener('click', function(e){
                    _s.setVolume(_s._d.volume, true);
                });
            }
            _s.showAPT();
        }

        _s.removeAPT = function(){
            if(_s.apt && _s.main_do.contains(_s.apt)) _s.main_do.removeChild(_s.apt);
            _s.aptRemoved = true;
        }

        _s.hideAPT = function(){
            if(_s.apt) _s.apt.setX(-5000);
        }

        _s.showAPT = function(){
            if(_s.apt && !_s.aptRemoved){
                 _s.apt.setX(0);
                 _s.apt.setScale2(0);
                 FWDAnimation.to(_s.apt, 1, {scale:1, ease:Elastic.easeInOut});
            }
        }
        

        //###########################################//
        /* Setup popup ads */
        //###########################################//
        _s.setupPopupAds = function(){
            FWDUVPPupupAds.setPrototype();
            _s.popupAds_do =  new FWDUVPPupupAds(_s, _s._d);
            _s.videoHolder_do.addChild(_s.popupAds_do);
        };
        
        
        //###########################################//
        /* Setup subtitle */
        //###########################################//
        _s.setupSubtitle = function(){
            FWDUVPSubtitle.setPrototype();
            _s.subtitle_do =  new FWDUVPSubtitle(_s, _s._d);
            _s.subtitle_do.addListener(FWDUVPSubtitle.LOAD_COMPLETE, _s.subtitleLoadComplete);
        };
        
        _s.subtitleLoadComplete = function(){
            _s.subtitle_do.show();
            if(_s.controller_do) _s.controller_do.enableSubtitleButton();
        };
        
        _s.loadSubtitle = function(path){
            if(_s.isCasting){
                _s.cc.loadSubtitle();
                return;
            }
            
            if(_s.controller_do) _s.controller_do.disableSubtitleButton();
            if(path){
                _s.subtitle_do.loadSubtitle(path);
                _s.videoHolder_do.addChildAt(_s.subtitle_do, _s.videoHolder_do.getChildIndex(_s.dClk_do) - 1);
                
            }
        }

        
        //###########################################//
        /* setup controller */
        //###########################################//
        _s.setupController = function(){
            FWDUVPController.setPrototype();
            _s.controller_do = new FWDUVPController(_s._d, _s);
            
            _s.controller_do.addListener(FWDUVPController.CHANGE_AUDIO_TRACKS, _s.audioTracksHanlder);
            _s.controller_do.addListener(FWDUVPController.VR, _s.vrHanlder);
            _s.controller_do.addListener(FWDUVPData.LOAD_ERROR, _s.controllerErrorHandler);
            _s.controller_do.addListener(FWDUVPController.REWIND, _s.rewindHandler);
            _s.controller_do.addListener(FWDUVPController.CHANGE_PLAYBACK_RATES, _s.changePlaybackRateHandler);
            _s.controller_do.addListener(FWDUVPController.CHANGE_SUBTITLE, _s.changeSubtitileHandler);
            _s.controller_do.addListener(FWDUVPController.SHOW_CATEGORIES, _s.showCategoriesHandler);
            _s.controller_do.addListener(FWDUVPController.SHOW_PLAYLIST, _s.showPlaylistHandler);
            _s.controller_do.addListener(FWDUVPController.HIDE_PLAYLIST, _s.hidePlaylistHandler);
            _s.controller_do.addListener(FWDUVPController.PLAY, _s.controllerOnPlayHandler);
            _s.controller_do.addListener(FWDUVPController.PAUSE, _s.controllerOnPauseHandler);
            _s.controller_do.addListener(FWDUVPController.START_TO_SCRUB, _s.controllerStartToScrubbHandler);
            _s.controller_do.addListener(FWDUVPController.SCRUB, _s.controllerScrubbHandler);
            _s.controller_do.addListener(FWDUVPController.STOP_TO_SCRUB, _s.controllerStopToScrubbHandler);
            _s.controller_do.addListener(FWDUVPController.CHANGE_VOLUME, _s.controllerChangeVolumeHandler);
            _s.controller_do.addListener(FWDUVPController.DOWNLOAD_VIDEO, _s.controllerDownloadVideoHandler);
            _s.controller_do.addListener(FWDUVPController.CHANGE_YOUTUBE_QUALITY, _s.controllerChangeYoutubeQualityHandler);
            _s.controller_do.addListener(FWDUVPController.FULL_SCREEN, _s.controllerFullScreenHandler);
            _s.controller_do.addListener(FWDUVPController.NORMAL_SCREEN, _s.controllerNormalScreenHandler);
            _s.controller_do.addListener(FWDUVPPlaylist.PLAY_PREV_VIDEO, _s.playPrevVideoHandler);
            _s.controller_do.addListener(FWDUVPPlaylist.PLAY_NEXT_VIDEO, _s.playNextVideoHandler);
            _s.controller_do.addListener(FWDUVPController.SHOW_EMBED_WINDOW, _s.showEmbedWindowHandler);
            _s.controller_do.addListener(FWDUVPController.SHOW_INFO_WINDOW, _s.showInfoWindowHandler);
            _s.controller_do.addListener(FWDUVPController.SHOW_SHARE_WINDOW, _s.controllerShareHandler);
            _s.controller_do.addListener(FWDUVPController.SHOW_SUBTITLE, _s.showSubtitleHandler);
            _s.controller_do.addListener(FWDUVPController.HIDE_SUBTITLE, _s.hideSubtitleHandler);
            _s.videoHolder_do.addChild(_s.controller_do);
        };

        _s.audioTracksHanlder = function(e){
            if(_s.hlsJS){
                _s.hlsJS.audioTrack = e.id;
            }else{
                _s.videoScreen_do.setAudioTrack(e.id);
            }
        }

        _s.vrHanlder = function(){
            _s.play();
            if(!_s.videoScreen_do.vrSupport_bl){
                _s.videoScreen_do.showVrMessage();
            }else{
                _s.videoScreen_do.startVR();
            }
        }
        
        _s.controllerErrorHandler = function(e){
            _s.showSourceError(e.text);
        }
        
        _s.rewindHandler = function(){
            _s.rewind(_s._d.rewTm);
        }

        _s.rewind = function(offset){
            var curTime = _s.getCurrentTime();
            if(curTime.length == 5) curTime = "00:" + curTime;
            if(curTime.length == 7) curTime = "0" + curTime;
            curTime = FWDUVPUtils.getSecondsFromString(curTime);
            curTime -= offset;
            curTime = FWDUVPUtils.formatTime(curTime);
            if(curTime.length == 5) curTime = "00:" + curTime;
            if(curTime.length == 7) curTime = "0" + curTime;
            _s.scrubbAtTime(curTime);
        }
        
        _s.changePlaybackRateHandler = function(e){
            _s.setPlaybackRate(e.rate);
        }
        
        _s.changeSubtitileHandler = function(e){
            _s._d.playlist_ar[_s.id].startAtSubtitle = e.id;
            _s.controller_do.updateSubtitleButtons(_s._d.playlist_ar[_s.id].subtitleSource, _s._d.playlist_ar[_s.id].startAtSubtitle);
            _s.ccSS = Number(_s._d.playlist_ar[_s.id].subtitleSource.length - e.id);
            if(!_s.isAdd_bl) _s.loadSubtitle(_s._d.playlist_ar[_s.id].subtitleSource[_s._d.playlist_ar[_s.id].subtitleSource.length - 1 - _s._d.playlist_ar[_s.id].startAtSubtitle]["source"]);
            
        }
        
        _s.showSubtitleHandler = function(){
            _s.subtitle_do.show();
            _s.subtitle_do.isShowed_bl = true;
            
        };
        
        _s.hideSubtitleHandler = function(){
            _s.subtitle_do.isShowed_bl = false;
            _s.subtitle_do.hide();
        };
        
        _s.showCategoriesHandler = function(e){
            
            _s.showCategories();
            if(_s.controller_do) _s.controller_do.setCategoriesButtonState("selected");
        };
        
        _s.showPlaylistHandler = function(e){
            _s.disableClick();
            _s.showPlaylist();          
        };
        
        _s.hidePlaylistHandler = function(e){
            _s.disableClick();
            _s.hidePlaylist();  
        };
        
        _s.controllerOnPlayHandler = function(e){
            _s.play();
            if(_s._d.goFullScreenOnPlay_bl) _s.goFullScreen();
        };
        
        _s.controllerOnPauseHandler = function(e){
            _s.pause();
        };
        
        _s.controllerStartToScrubbHandler = function(e){
            if(_s.isCasting){
                _s.cc.startToScrub();
                return;
            }
            _s.startToScrub();
        };
        
        _s.controllerScrubbHandler = function(e){
            if(_s.isCasting){
                _s.cc.seek(e.percent);
                return;
            }
            _s.scrub(e.percent);
        };
        
        _s.controllerStopToScrubbHandler = function(e){
            if(_s.isCasting){
                _s.cc.stopToScrub();
                return;
            }
            _s.stopToScrub();
        };
        
        _s.controllerChangeVolumeHandler = function(e){
            _s.setVolume(e.percent);
        };
        
        _s.controllerDownloadVideoHandler = function(){
            _s.downloadVideo();
        };
        
        _s.controllerShareHandler = function(e){
            _s.setVideoPlayingStateOnWindowShow();
            _s.pause();
            
            _s.shareWindow_do.show();
            if(_s.controller_do && !_s.isMbl){
                _s.controller_do.shareButton_do.setSelectedState();
                _s.controller_do.shareButton_do.isDisabled_bl = true;
            }
        };
        
        _s.controllerChangeYoutubeQualityHandler = function(e){
            if(_s.videoType_str == FWDUVPlayer.HLS_JS){
                _s.curHlsLevel = Math.abs(e.id - _s.hlsLevels_ar.length + 1);
                _s.hlsJS.currentLevel = _s.curHlsLevel;
                
            }else if(_s.videoType_str == FWDUVPlayer.YOUTUBE){
                _s.ytb_do.setQuality(e.quality);
            }else{
                _s.curDurration = _s.curTimeInSecond;
                _s._d.playlist_ar[_s.id].startAtVideo = _s._d.playlist_ar[_s.id].videoSource.length - 1 - e.id;
                _s.setSource(_s._d.playlist_ar[_s.id].videoSource[_s._d.playlist_ar[_s.id].startAtVideo]["source"], false, _s._d.playlist_ar[_s.id].videoSource[_s._d.playlist_ar[_s.id].startAtVideo]["is360"]);
                _s.isQualityChanging_bl = true;
                _s.play();
            }
        };
        
        _s.controllerFullScreenHandler = function(){
            _s.goFullScreen();
        };
        
        _s.controllerNormalScreenHandler = function(){
            _s.goNormalScreen();
        };
        
        _s.showEmbedWindowHandler = function(){
            _s.setVideoPlayingStateOnWindowShow();
            _s.pause();
        
            _s.embedWindow_do.show();
            
            if(_s.controller_do && !_s.isMbl){
                _s.controller_do.embedButton_do.setSelectedState();
                _s.controller_do.embedButton_do.isDisabled_bl = true;
            }
        };
        
        _s.showInfoWindowHandler = function(){
            _s.setVideoPlayingStateOnWindowShow();
            _s.pause();
            
            _s.infoWindow_do.show(_s._d.playlist_ar[_s.id].desc);
            
            if(_s.controller_do && !_s.isMbl){
                _s.controller_do.infoButton_do.setSelectedState();
                _s.controller_do.infoButton_do.isDisabled_bl = true;
            }
        };
        
        _s.setVideoPlayingStateOnWindowShow =  function(){
            if(_s.isCasting){
                _s.isVideoPlayingWhenOpenWindows_bl = _s.cc.playerState == 'PLAYING';
            }else if(_s.isIMA && _s.IMA.started){
                _s.isVideoPlayingWhenOpenWindows_bl = _s.IMA.isPlaying;
            }else if(_s.videoType_str == FWDUVPlayer.YOUTUBE && _s.ytb_do){
                _s.isVideoPlayingWhenOpenWindows_bl = _s.ytb_do.isPlaying_bl;
            }else if(_s.videoType_str == FWDUVPlayer.VIMEO && _s.vimeo_do){
                _s.isVideoPlayingWhenOpenWindows_bl = _s.vimeo_do.isPlaying_bl;
            }else{
                if(_s.videoScreen_do) _s.isVideoPlayingWhenOpenWindows_bl = _s.videoScreen_do.isPlaying_bl;
            }
        }

        
        //###########################################//
        /* setup FWDUVPAudioScreen */
        //###########################################//
        _s.setupAudioScreen = function(){   
            if(_s.audioScreen_do) return;
            FWDUVPAudioScreen.setPrototype();
            _s.audioScreen_do = new FWDUVPAudioScreen(_s, _s._d.volume);
            
            _s.audioScreen_do.addListener(FWDUVPAudioScreen.ERROR, _s.videoScreenErrorHandler);
            _s.audioScreen_do.addListener(FWDUVPAudioScreen.SAFE_TO_SCRUBB, _s.videoScreenSafeToScrubbHandler);
            _s.audioScreen_do.addListener(FWDUVPAudioScreen.STOP, _s.videoScreenStopHandler);
            _s.audioScreen_do.addListener(FWDUVPAudioScreen.PLAY, _s.videoScreenPlayHandler);
            _s.audioScreen_do.addListener(FWDUVPAudioScreen.PAUSE, _s.videoScreenPauseHandler);
            _s.audioScreen_do.addListener(FWDUVPAudioScreen.UPDATE, _s.videoScreenUpdateHandler);
            _s.audioScreen_do.addListener(FWDUVPAudioScreen.UPDATE_TIME, _s.videoScreenUpdateTimeHandler);
            _s.audioScreen_do.addListener(FWDUVPAudioScreen.LOAD_PROGRESS, _s.videoScreenLoadProgressHandler);
            _s.audioScreen_do.addListener(FWDUVPVideoScreen.START_TO_BUFFER, _s.videoScreenStartToBuferHandler);
            _s.audioScreen_do.addListener(FWDUVPVideoScreen.STOP_TO_BUFFER, _s.videoScreenStopToBuferHandler);
            _s.audioScreen_do.addListener(FWDUVPAudioScreen.PLAY_COMPLETE, _s.videoScreenPlayCompleteHandler);
            _s.audioScreen_do.addListener(FWDUVPAudioScreen.UPDATE_SUBTITLE, _s.videoScreenUpdateSubtitleHandler);
            
            _s.videoHolder_do.addChild(_s.audioScreen_do);
        };

        
        //###########################################//
        /* setup FWDUVPVideoScreen */
        //###########################################//
        _s.setupVideoScreen = function(){
            FWDUVPVideoScreen.setPrototype();
            _s.videoScreen_do = new FWDUVPVideoScreen(_s, _s._d.volume);
            _s.videoScreen_do.addListener(FWDUVPVideoScreen.ERROR, _s.videoScreenErrorHandler);
            _s.videoScreen_do.addListener(FWDUVPVideoScreen.SAFE_TO_SCRUBB, _s.videoScreenSafeToScrubbHandler);
            _s.videoScreen_do.addListener(FWDUVPVideoScreen.STOP, _s.videoScreenStopHandler);
            _s.videoScreen_do.addListener(FWDUVPVideoScreen.PLAY, _s.videoScreenPlayHandler);
            _s.videoScreen_do.addListener(FWDUVPVideoScreen.PAUSE, _s.videoScreenPauseHandler);
            _s.videoScreen_do.addListener(FWDUVPVideoScreen.UPDATE, _s.videoScreenUpdateHandler);
            _s.videoScreen_do.addListener(FWDUVPVideoScreen.UPDATE_TIME, _s.videoScreenUpdateTimeHandler);
            _s.videoScreen_do.addListener(FWDUVPVideoScreen.LOAD_PROGRESS, _s.videoScreenLoadProgressHandler);
            _s.videoScreen_do.addListener(FWDUVPVideoScreen.START_TO_BUFFER, _s.videoScreenStartToBuferHandler);
            _s.videoScreen_do.addListener(FWDUVPVideoScreen.STOP_TO_BUFFER, _s.videoScreenStopToBuferHandler);
            _s.videoScreen_do.addListener(FWDUVPVideoScreen.PLAY_COMPLETE, _s.videoScreenPlayCompleteHandler);
            _s.videoScreen_do.addListener(FWDUVPVideoScreen.UPDATE_SUBTITLE, _s.videoScreenUpdateSubtitleHandler);
            _s.videoHolder_do.addChild(_s.videoScreen_do);
        };
        
        _s.videoScreenErrorHandler = function(e){

            var error;
            _s.isPlaying_bl = false;
            if(FWDUVPlayer.hasHTML5Video || _s.videoType_str == FWDUVPlayer.YOUTUBE){
                error = e.text;
                if(window.console) console.log(e.text);
                _s.showSourceError(error);
                
                if(_s.controller_do){
                    _s.controller_do.disableMainScrubber();
                    _s.controller_do.disablePlayButton();
                    if(!_s._d.showControllerWhenVideoIsStopped_bl) _s.controller_do.hide(!_s.isMbl);
                    _s.lrgPlayBtn.hide();
                    _s.hideClickScreen();
                    if(_s.hider) _s.hider.stop();
                }
            }else{
                error = e;
                _s.showSourceError(error);
            }
            
            if(_s.logo_do) _s.logo_do.hide(false);
            if(_s.preloader_do) _s.preloader_do.hide(false);
            _s.showCursor();
            _s.dispatchEvent(FWDUVPlayer.ERROR, {error:error});
        };
        
        _s.videoScreenSafeToScrubbHandler = function(){
            var curPlaylist = _s._d.playlist_ar[_s.id];

            if(_s.preloader_do) _s.preloader_do.hide();
            
            if(_s.controller_do){
                if(_s.isAdd_bl){
                    _s.controller_do.disableMainScrubber();
                    if(_s._d.timeToHoldAds) _s.adsStart_do.show(true);
                    if(_s._d.adsThumbnailPath_str && _s._d.adsThumbnailPath_str != "none") _s.adsStart_do.loadThumbnail(_s._d.adsThumbnailPath_str);
                    _s.positionAds();
                }else{
                    _s.controller_do.enableMainScrubber();
                }
                
                _s.controller_do.enablePlayButton();
                _s.controller_do.show(true);
                
                if(!_s.isAdd_bl){
                    if(_s.controller_do.ytbQualityButton_do){
                        _s.controller_do.ytbQualityButton_do.enable();
                        _s.controller_do.enablePlaybackRateButton();
                    }
                    _s.controller_do.enableAtButton();
                }
                if(!_s.isAdd_bl && _s.controller_do.playbackRateButton_do) _s.controller_do.enablePlaybackRateButton();
                if(!_s.isAdd_bl){
                     if(_s.controller_do.downloadButton_do) _s.controller_do.downloadButton_do.enable();
                     if(_s.controller_do.rewindButton_do) _s.controller_do.rewindButton_do.enable();
                }

                if(_s.hider) _s.hider.start();
            }
            
            if(!_s.isAdd_bl && !_s.isIMA && curPlaylist && curPlaylist.subtitleSource){
                _s.loadSubtitle(curPlaylist.subtitleSource[curPlaylist.subtitleSource.length - 1 - curPlaylist.startAtSubtitle]["source"]);
            }
            
            if(!_s.isAdd_bl){
                if(_s.customContextMenu_do) _s.customContextMenu_do.enable();
                if((_s.controller_do && _s.controller_do.thumbnailsPreview_do && curPlaylist['thumbnailsPreview'])
                    || ((_s.controller_do && _s.controller_do.thumbnailsPreview_do && curPlaylist['thumbnailsPreview'] == 'auto')
                        && (_s.videoType_str == FWDUVPlayer.VIDEO || _s.videoType_str == FWDUVPlayer.HLS_JS))){
                        _s._d.tempShowMainScrubberToolTipLabel_bl = false;
                        _s.controller_do.thumbnailsPreview_do.load(curPlaylist['thumbnailsPreview'], _s.videoType_str, _s.videoSourcePath_str, _s.videoScreen_do.video_el);
                    } 
            }
            
            if(_s.controller_do){
                if( !_s.isQualityChanging_bl) _s.controller_do.disableSubtitleButton();
                _s.controller_do.enableAtbButton();
                if(_s.isAdd_bl && window['FWDUVPCC']) FWDUVPCC.disableButton();
            } 
            
            if(_s.isMbl){
                _s.adsSkip_do.hide(false);
            }

            if(_s.isQualityChanging_bl && !_s.isAdd_bl){
                _s.scrubbAtTime(_s.curDurration);
                _s.curDurration = 0;
                _s.isQualityChanging_bl = false;
            }
            
            _s.videoPoster_do.hide(true);
            
            _s.callVastEvent("start");
            _s.executeVastEvent(_s.Impression);
            
            _s.showClickScreen();
            setTimeout(function(){
                if(_s.totalDuration && _s.controller_do) _s.controller_do.positionAdsLines(_s.totalDuration);
            }, 1500);

            if(_s.getStartTimeStamp("t") != "00:00:00"){
                if(args['uvpi']){
                    if(args['uvpi'] == _s.instanceName_str) _s.scrubbAtTime(_s.getStartTimeStamp("t"));
                }else{
                    _s.scrubbAtTime(_s.getStartTimeStamp("t"));
                }
            }
            
            if(document.cookie && _s._d.useResumeOnPlay_bl && !_s.isAdd_bl){
                if(FWDUVPUtils.getCookie("fwduvp_video_path") && FWDUVPUtils.getCookie("fwduvp_time") 
                   && FWDUVPUtils.getCookie("fwduvp_video_path") == _s.videoSourcePath_str){
                    var curTime = FWDUVPUtils.getCookie("fwduvp_time");
                    if(!_s.rmsPlayed_bl){
                        _s.scrubbAtTime(FWDUVPUtils.getCookie("fwduvp_time"));
                    }
                }
                _s.rmsPlayed_bl = true;
            }

            _s.dispatchEvent(FWDUVPlayer.SAFE_TO_SCRUB);
        };
        
        _s.videoScreenUpdateSubtitleHandler = function(e){
            if(_s.subtitle_do) _s.subtitle_do.updateSubtitle(e.curTime);
        }
    
        _s.videoScreenStopHandler = function(e){
            if(_s.main_do) if(_s.main_do.contains(_s.info_do)) _s.main_do.removeChild(_s.info_do);
            _s.videoPoster_do.allowToShow_bl = true;
            _s.isPlaying_bl = false;
            
            if(_s.controller_do){
                _s.controller_do.disableMainScrubber();
                _s.controller_do.showPlayButton();
                if(!_s._d.showControllerWhenVideoIsStopped_bl){
                    _s.controller_do.hide(!_s.isMbl);
                }else{
                    _s.controller_do.show(!_s.isMbl);
                }
                if(_s.hider) _s.hider.stop();
            }
            
            if(_s.ytb_do){
                _s.ytb_do.stopVideo();
            }
            
            if(_s.logo_do) _s.logo_do.hide(true);
            
            _s.hideClickScreen();
            
            if(_s.isMbl){
                _s.adsSkip_do.hide(false);
                _s.adsStart_do.hide(false);
            }
            
            _s.showCursor();
            _s.dispatchEvent(FWDUVPlayer.STOP);
        };
        
        _s.videoScreenPlayHandler = function(){
            if(_s.preloader_do) _s.preloader_do.hide();
            if(_s.is360) _s.dClk_do.getStyle().cursor = 'url(' + _s._d.handPath_str + '), default';
            FWDUVPlayer.keyboardCurInstance = _s;
            
            if(_s.videoType_str == FWDUVPlayer.YOUTUBE
               && _s.ytb_do && _s.ytb_do.isStopped_bl) return;
             
            _s.setupAPT();
            _s.callVastEvent("resume");
            
            if(_s.isMbl){
                if(FWDUVPlayer.videoStartBehaviour == FWDUVPlayer.STOP_ALL_VIDEOS){
                    FWDUVPlayer.stopAllVideos(_s);
                }
            }else{
                if(FWDUVPlayer.videoStartBehaviour == FWDUVPlayer.PAUSE_ALL_VIDEOS){
                    FWDUVPlayer.pauseAllVideos(_s);
                }
            }
        
            if(_s.logo_do) _s.logo_do.show(true);
              
            if(_s.controller_do){
                _s.controller_do.showPauseButton();
                _s.controller_do.show(true);
            }
            
            _s.playAtTime_bl = false;
            _s.hasHlsPlayedOnce_bl = true;
            if(_s.lrgPlayBtn) _s.lrgPlayBtn.hide();
            if(_s.hider) _s.hider.start();
            _s.showCursor();

            _s.videoScreenStopToBuferHandler();
            
            if(_s.popw_do) _s.popw_do.hide();
        
            if((!_s.hasStartedToPlay_bl && _s._d.playlist_ar[_s.id] && _s._d.playlist_ar[_s.id].startAtTime && !_s.isAdd_bl && !_s.wasAdd_bl)
                || (_s._d.playlist_ar[_s.id].startAtTime &&  !_s.isAdd_bl && _s.addStartAtZero)
            ){
                _s.scrubbAtTime(_s._d.playlist_ar[_s.id].startAtTime);
            } 
            
            if(!_s.isMbl || _s.source.indexOf('.m3u') == -1 || (_s.isMbl && _s.source.indexOf('.m3u') == -1)){
                _s.resumeAfterAd();
            } 

            if(!_s.hasStartedToPlay_bl && _s.castStartAtTime && !_s.isAdd_bl){
                _s.scrubbAtTime(_s.castStartAtTime);
                _s.castStartAtTime = undefined;
            }
            
            _s.isPlaying_bl = true;
            //_s.isThumbClick_bl = false;
            _s.loadAddFirstTime_bl = false;
            _s.hasStartedToPlay_bl = true;
            if(_s.opener_do) _s.opener_do.showPauseButton();
            if(_s.fps) _s.fps.start();
            
            _s.dispatchEvent(FWDUVPlayer.PLAY);
        };

        _s.resumeAfterAd = function(){
            if(_s.wasAdd_bl){
                if(FWDUVPUtils.isSafari){
                    setTimeout(function(){
                        _s.scrubbAtTime(_s.scrubAfterAddDuration);
                    },500);
                }else{
                    if(_s.videoType_str == FWDUVPlayer.VIMEO){
                        setTimeout(function(){
                            _s.scrubbAtTime(_s.scrubAfterAddDuration);
                        },500);
                    }else{
                        _s.scrubbAtTime(_s.scrubAfterAddDuration)
                    }
                
                }
                _s.wasAdd_bl = _s.addStartAtZero = false;
            }
        }
        
        _s.videoScreenPauseHandler = function(){

            if(_s.videoType_str == FWDUVPlayer.YOUTUBE
               && _s.ytb_do && _s.ytb_do.isStopped_bl) return;
               
            if(_s.videoType_str == FWDUVPlayer.VIMEO
               && _s.vimeo_do && _s.vimeo_do.isStopped_bl) return;
               
            _s.callVastEvent("pause");
            if(_s.preloader_do) _s.preloader_do.hide();

            _s.isPlaying_bl = false;
            if(_s.controller_do){
                _s.controller_do.showPlayButton();
                _s.controller_do.show(true);
            }
            
            var isShareWIndowShowed_bl = _s.shareWindow_do && _s.shareWindow_do.isShowed_bl;
            var isEmbedWIndowShowed_bl = _s.embedWindow_do && _s.embedWindow_do.isShowed_bl;

            if(!isShareWIndowShowed_bl && !isEmbedWIndowShowed_bl){
                if(_s.showPopW_bl) _s.popw_do.show(_s.popwSource);  
            }
                
            if(_s.lrgPlayBtn && !_s._d.showAnnotationsPositionTool_bl) _s.lrgPlayBtn.show();
            
            if(_s.hider){
                _s.hider.reset();
                _s.hider.stop();
            }
            
            _s.showClickScreen();
            
            _s.showCursor();
            if(_s.opener_do) _s.opener_do.showPlayButton();
            if(_s.fps) _s.fps.stop();
            _s.dispatchEvent(FWDUVPlayer.PAUSE);
        };
        
        _s.videoScreenUpdateHandler = function(e){
            var percent;    
            if(FWDUVPlayer.hasHTML5Video || _s.videoType_str == FWDUVPlayer.YOUTUBE){
                percent = e.percent;
                if(_s.controller_do) _s.controller_do.updateMainScrubber(percent);
            }else{
                percent = e;
                console.log(e)
                if(_s.controller_do) _s.controller_do.updateMainScrubber(percent);
            }
            _s.dispatchEvent(FWDUVPlayer.UPDATE, {percent:percent});
        };
        
        _s.videoScreenUpdateTimeHandler = function(e, e2, e3){
            if(_s.isStopped_bl) return;
            
            if(_s.prevSeconds != Math.round(e.seconds)) _s.totalTimePlayed += 1;
            _s.totalTimeInSeconds = Math.round(e.totalTimeInSeconds);
            _s.totalTimeInMilliseconds = e.totalTimeInSeconds;
            _s.curTimeInSecond = Math.round(e.seconds);
            _s.curTimeInmilliseconds = e.seconds;
            _s.prevSeconds =  Math.round(e.seconds)
            _s.totalPercentPlayed = _s.totalTimePlayed/e.totalTimeInSeconds;

            if(!isFinite(_s.totalPercentPlayed)) _s.totalPercentPlayed = 0;
            
            if(FWDUVPUtils.getSecondsFromString(_s.getStartTimeStamp("e"))){
                if(_s.curTimeInSecond >= parseInt(FWDUVPUtils.getSecondsFromString(_s.getStartTimeStamp("e")))) _s.stop();
            }
        
            if(_s.controller_do 
               && !_s.controller_do.isMainScrubberScrubbing_bl
               && _s.controller_do.atb
               && _s.controller_do.atb.isShowed_bl
               && !_s.controller_do.atb.scrub){
                
                var a = Math.round(_s.totalTimeInSeconds * _s.controller_do.atb.pa);
                var b = Math.round(_s.totalTimeInSeconds * _s.controller_do.atb.pb);
                
                
                if(_s.prevCurTimeInSeconds != _s.curTimeInSecond){
                    _s.prevCurTimeInSeconds = _s.curTimeInSecond;
                    if(_s.curTimeInSecond < a){
                        _s.scrub(_s.controller_do.atb.pa);
                    }else if(_s.curTimeInSecond > b){
                        _s.scrub(_s.controller_do.atb.pa);
                    }
                }
            }
            
            if(_s.isAdd_bl){
                if(_s.totalPercentPlayed >= .25 && _s.callFirstQuartile){
                    _s.callVastEvent("firstQuartile");
                    _s.callFirstQuartile = false;
                }else if(_s.totalPercentPlayed >= .50 && _s.callMidpoint){
                    _s.callVastEvent("midpoint");
                    _s.callMidpoint = false;
                }else if(_s.totalPercentPlayed >= .75 && _s.callThirdQuartile){
                    _s.callVastEvent("thirdQuartile");
                    _s.callThirdQuartile = false;
                }
            }

            var time;
            var seconds;
            if(FWDUVPlayer.hasHTML5Video || _s.videoType_str == FWDUVPlayer.YOUTUBE || _s.videoType_str == FWDUVPlayer.VIMEO){
                _s.curTime = e.curTime;
                _s.totalTime = e.totalTime;
                time = _s.curTime + "/" + _s.totalTime;
                seconds = _s.curTimeInSecond;
                if(_s.controller_do) _s.controller_do.updateTime(time);
            }else{
                _s.curTime = e;
                _s.totalTime = e2;
                time = _s.curTime + "/" + _s.totalTime;
                if(e == undefined || e2 ==  undefined) time = "00:00/00:00";
                seconds = Math.round(e3);
                if(_s.controller_do) _s.controller_do.updateTime(time);
            }
            
            _s.currentSecconds = e.seconds;
            
            if(_s.popupAds_do && !_s.isAdd_bl) _s.popupAds_do.update(_s.curTimeInSecond);
            if(_s.annotations_do && !_s.isAdd_bl) _s.annotations_do.update(_s.curTimeInSecond);
            
            if(_s._d.playlist_ar && _s._d.playlist_ar[_s.id]){
                _s.cuePointsSource_ar = _s._d.playlist_ar[_s.id].cuepoints_ar;
            }
            
            if(_s.cuePointsSource_ar && !_s.isAdd_bl){
                var length = _s.cuePointsSource_ar.length;
                for(var i=0; i<length; i++){
                    if(_s.cuePointsSource_ar){
                        var cuePoint = _s.cuePointsSource_ar[i];
                        if(cuePoint.timeStart == _s.curTimeInSecond && !cuePoint.played_bl){
                            if(_s._d.executeCuepointsOnlyOnce_bl ){
                                if(!cuePoint.played_bl) eval(cuePoint.javascriptCall);
                            }else{
                                eval(cuePoint.javascriptCall);
                            }
                            cuePoint.played_bl = true;
                        }
                    }
                }
            }
            
            if(!_s.isAdd_bl){
                if(_s.totalTime.length>5){
                    _s.totalDuration = FWDUVPUtils.getSecondsFromString(_s.totalTime);
                }else{
                    _s.totalDuration = FWDUVPUtils.getSecondsFromString("00:" + _s.totalTime);
                }
            }
            
            if(_s.isIMA){
                _s.IMA.updateCuepointLines(seconds);
            }
            
            if(_s.isAdd_bl){
                if(_s._d.timeToHoldAds > seconds){
                    _s.adsStart_do.updateText(_s._d.skipToVideoText_str + Math.abs(_s._d.timeToHoldAds - seconds));
                    if(_s.isMbl) _s.adsSkip_do.hide(false);
                    if(_s.videoType_str == FWDUVPlayer.IMAGE || _s.videoType_str == FWDUVPlayer.IFRAME){
                        _s.adsStart_do.show(true);
                    }
                }else if(_s.isPlaying_bl){
                    _s.adsStart_do.hide(true);
                    if(_s._d.timeToHoldAds) _s.adsSkip_do.show(true);
                }
            }else{
                _s.adsStart_do.hide(true);
                _s.adsSkip_do.hide(true);
            }
        
            if(seconds != 0){
                _s.updateAds(seconds);
            }

            if(_s.isPlaying_bl && _s._d.playlist_ar[_s.id] && FWDUVPUtils.getSecondsFromString(_s._d.playlist_ar[_s.id].stopAtTime) <= e.seconds){
                if(_s._d.playAfterVideoStop_bl){
                    if(_s._d.stopAfterLastVideoHasPlayed_bl && _s._d.playlist_ar.length - 1 == _s.id){
                        _s.stop();
                    }else{
                        _s.playNext();
                    }
                }else if(!_s._d.stopAfterLastVideoHasPlayed_bl && _s._d.playlist_ar.length - 1 == _s.id && _s._d.playlist_ar.length > 1){
                    _s.playNext();
                }else{
                    _s.stop();
                }
            }

            _s.dispatchEvent(FWDUVPlayer.UPDATE_TIME, {currentTime:_s.curTime, totalTime:_s.totalTime});
        };
        
        _s.videoScreenLoadProgressHandler = function(e){
            if(FWDUVPlayer.hasHTML5Video || _s.videoType_str == FWDUVPlayer.YOUTUBE){
                if(_s.controller_do) _s.controller_do.updatePreloaderBar(e.percent);
            }else{
                if(_s.controller_do) _s.controller_do.updatePreloaderBar(e);
            }
        };
        
        _s.videoScreenStartToBuferHandler = function(){
            if(_s.preloader_do){
                _s.preloader_do.show(false);
            }
        };
        
        _s.videoScreenStopToBuferHandler = function(){
            if(_s.preloader_do && _s.isPlaylistLoaded_bl) _s.preloader_do.hide(true);
        };
        
        _s.videoScreenPlayCompleteHandler = function(e, buttonUsedToSkipAds){
            if(_s._d.playlist_ar){
                _s.videoNameGa = _s._d.playlist_ar[_s.id]["gaStr"]
                _s.videoCat = _s._d.cats_ar[_s.catId]["playlistName"];
            }
            
            _s.stopedAtComplete = true;
            _s.callVastEvent("complete");
            
            if(_s.isIMA && _s.IMA.hasPostRoll && _s.curTimeInSecond >= _s.totalTimeInSeconds - 1){
                _s.IMA.playPostRoll();
                return;
            }
            
            if(!_s.isAdd_bl && _s._d.playlist_ar[_s.id].redirectURL){
                if(_s._d.playlist_ar[_s.id].redirectTarget == "_self"){
                    location.replace(_s._d.playlist_ar[_s.id].redirectURL);
                }else{
                    window.open(_s._d.playlist_ar[_s.id].redirectURL, _s._d.playlist_ar[_s.id].redirectTarget);
                }
            }
            
            var tempIsAdd_bl = _s.isAdd_bl;
            
            if(_s.isAdd_bl){
                _s.isThumbClick_bl = true;
                if(_s._d.openNewPageAtTheEndOfTheAds_bl && _s._d.adsPageToOpenURL_str != "none" && !buttonUsedToSkipAds){
                    if(_s._d.adsPageToOpenTarget_str == "_self"){
                        location.href = _s._d.adsPageToOpenURL_str;
                    }else{
                        window.open(_s._d.adsPageToOpenURL_str, _s._d.adsPageToOpenTarget_str);
                    }
                }

                _s.sendGAPlayedAdEvent();
                
                _s.isAdd_bl = false;
                _s.updateAds(0);
                _s.wasAdd_bl = true;


                if(buttonUsedToSkipAds && _s.videoType_str == FWDUVPlayer.VIDEO){   
                    _s.play();
                }else{
                    if(!_s.isMbl && (_s.videoType_str != FWDUVPlayer.DASH && _s.videoType_str != FWDUVPlayer.VIMEO)) _s.play();
                }
            }
            
            if(!tempIsAdd_bl){

                if((_s.lightBox_do && _s.lightBox_do.isShowed_bl && _s._d.closeLightBoxWhenPlayComplete)){
                    _s.stop();
                    _s.lightBox_do.closeButtonOnStartHandler();
                }

                if(_s._d.loop_bl){
                    if(_s.videoType_str == FWDUVPlayer.HLS_JS
                    || _s.videoType_str == FWDUVPlayer.DASH){
                        setTimeout(function(){
                            _s.scrub(0);
                            _s.resume();
                        }, 50);
                    }else{                      
                        _s.scrub(0);
                        _s.play();
                    }
                }else if((_s._d.stopVideoWhenPlayComplete_bl || _s._d.playlist_ar.length == 1)
                ||  (_s._d.stopAfterLastVideoHasPlayed_bl && _s._d.playlist_ar.length - 1 == _s.id)
                ){  
                    _s.stop();
                }else if(_s._d.shuffle_bl){
                    _s.playShuffle();
                    if(_s.isMbl) _s.stop();
                    if(_s.videoType_str == FWDUVPlayer.DASH){
                        _s.setSource(_s.source);
                    }
                }else{
                    _s.playNext();
                    if(_s.isMbl){
                        if(_s.videoType_str == FWDUVPlayer.DASH){
                            _s.setSource(_s.source);
                        }
                    } 
                }
            }
            if(_s.hider) _s.hider.reset();
            _s.dispatchEvent(FWDUVPlayer.PLAY_COMPLETE);
        };
        

        //##########################################//
        /* Setup annotations */
        //##########################################//
        _s.setupAnnotations = function(){
            FWDUVPAnnotations.setPrototype();
            _s.annotations_do = new FWDUVPAnnotations(_s, _s._d);
            _s.videoHolder_do.setBkColor = props.backgroundColor;
            _s.videoHolder_do.screen.className = 'fwduvp-video-holder';
            _s.videoHolder_do.addChild(_s.annotations_do);
        };
        

        //##########################################//
        /* Setup skip adds buttons */
        //##########################################//
        _s.setupAdsStart = function(){
            FWDUVPAdsStart.setPrototype();
            _s.adsStart_do = new FWDUVPAdsStart(
                    _s._d.adsButtonsPosition_str, 
                    _s._d.adsBorderNormalColor_str, 
                    "", 
                    _s._d.adsBackgroundPath_str,
                    _s._d.adsTextNormalColor);
            
            FWDUVPAdsButton.setPrototype();
            _s.adsSkip_do = new FWDUVPAdsButton(
                    _s,
                    _s._d.skipIconPath_img,
                    _s._d.skipIconSPath_str,
                    _s._d.skipToVideoButtonText_str,
                    _s._d.adsButtonsPosition_str, 
                    _s._d.adsBorderNormalColor_str, 
                    _s._d.adsBorderSelectedColor_str, 
                    _s._d.adsBackgroundPath_str,
                    _s._d.adsTextNormalColor,
                    _s._d.adsTextSelectedColor,
                    _s._d.useHEX,
                    _s._d.nBC,
                    _s._d.sBC);
            _s.adsSkip_do.addListener(FWDUVPAdsButton.MOUSE_UP, _s.skipAdsMouseUpHandler);
            
            _s.videoHolder_do.addChild(_s.adsSkip_do);
            _s.videoHolder_do.addChild(_s.adsStart_do);
        };
        
        _s.skipAdsMouseUpHandler = function(){
            _s.isThumbClick_bl = true;
            _s.callVastEvent("skip");
            _s.videoScreenPlayCompleteHandler(null, true);
        };
        
        _s.positionAds = function(animate){
            
            var finalX;
            var finalY;
        
            if(_s._d.adsButtonsPosition_str == "left"){
                finalX = 0;
            }else{
                finalX = _s.tempVidStageWidth;
            }
            
            if(_s.controller_do){
                if(_s.controller_do.isShowed_bl){
                    finalY = _s.tempVidStageHeight - _s.adsStart_do.h - _s._d.controllerHeight - 30;
                }else{
                    finalY = _s.tempVidStageHeight - _s.adsStart_do.h - _s._d.controllerHeight;
                }
            }else{
                finalY = _s.tempVidStageHeight - _s.adsStart_do.h
            }
            
            FWDAnimation.killTweensOf(_s.adsStart_do);
            if(animate){
                FWDAnimation.to(_s.adsStart_do, .8, {y:finalY, ease:Expo.easeInOut});
            }else{
                _s.adsStart_do.setY(finalY);
            }
            
            _s.adsStart_do.setX(finalX);

            var mbl = false;
            if(_s.tempStageWidth < 600) mbl = true;
        
            _s.adsSkip_do.resize(mbl);
            
            if(_s._d.adsButtonsPosition_str == "left"){
                finalX = 0;
            }else{
                finalX = _s.tempVidStageWidth;
            }
            
            if(_s.controller_do){
                if(_s.controller_do.isShowed_bl){
                    finalY = _s.tempVidStageHeight - _s.adsSkip_do.h - _s._d.controllerHeight - 30;
                }else{
                    finalY = _s.tempVidStageHeight - _s.adsSkip_do.h - _s._d.controllerHeight;
                }
            }else{
                finalY = _s.tempVidStageHeight - _s.adsSkip_do.h
            }
            
            FWDAnimation.killTweensOf(_s.adsSkip_do);
            if(animate){
                FWDAnimation.to(_s.adsSkip_do, .8, {y:finalY, ease:Expo.easeInOut});
            }else{
                _s.adsSkip_do.setY(finalY);
            }
            
            _s.adsSkip_do.setX(finalX);
            
        };

        
        //##########################################//
        /* Setup embed window */
        //##########################################//
        _s.setupShareWindow = function(){
            FWDUVPShareWindow.setPrototype();
            _s.shareWindow_do = new FWDUVPShareWindow(_s._d, _s);
            _s.shareWindow_do.addListener(FWDUVPShareWindow.HIDE_COMPLETE, _s.shareWindowHideCompleteHandler);
        };
        
        _s.shareWindowHideCompleteHandler = function(){
            if(_s.isVideoPlayingWhenOpenWindows_bl) _s.resume();
            
            if(_s.controller_do && !_s.isMbl){
                _s.controller_do.shareButton_do.isDisabled_bl = false;
                _s.controller_do.shareButton_do.setNormalState(true);
            }
        };


        //##########################################//
        /* Setup login window */
        //##########################################//
        _s.setupLoginWindow =  function(){
            FWDUVPPassword.setPrototype();
            _s.lg_do = new FWDUVPPassword(_s._d, _s, true);
        }

        
        //##########################################//
        /* Setup embed window */
        //##########################################//
        _s.setupPasswordWindow = function(){
            FWDUVPPassword.setPrototype();
            _s.passWindow_do = new FWDUVPPassword(_s._d, _s);
            _s.passWindow_do.addListener(FWDUVPPassword.CORRECT, _s.passordCorrect);
        };
        
        _s.passordCorrect = function(){
            _s.passWindow_do.hide();
            _s.hasPassedPassowrd_bl = true;
            _s.play();
        }

        _s.checkPassWindow = function(){
            if(!_s.isAdd_bl && (_s._d.playlist_ar[_s.id]["isPrivate"] || _s.playlistPass) && !_s.hasPassedPassowrd_bl && _s.passWindow_do && !_s.plPassPassed){
                if(_s.lrgPlayBtn) _s.lrgPlayBtn.show();
                _s.passWindow_do.show();
                _s.videoPoster_do.show();
                return;
            }

            return true;
        }
        

        //##########################################//
        /* Setup embed window */
        //##########################################//
        _s.setupEmbedWindow = function(){
            FWDUVPEmbedWindow.setPrototype();
            _s.embedWindow_do = new FWDUVPEmbedWindow(_s._d, _s);
            _s.embedWindow_do.addListener(FWDUVPEmbedWindow.ERROR, _s.embedWindowErrorHandler);
            _s.embedWindow_do.addListener(FWDUVPEmbedWindow.HIDE_COMPLETE, _s.embedWindowHideCompleteHandler);
        };
        
        _s.embedWindowErrorHandler = function(e){
            _s.showSourceError(e.error);
        };
        
        _s.embedWindowHideCompleteHandler = function(){
            if(_s.isVideoPlayingWhenOpenWindows_bl) _s.resume();
            
            if(_s.controller_do && !_s.isMbl){
                _s.controller_do.embedButton_do.isDisabled_bl = false;
                _s.controller_do.embedButton_do.setNormalState(true);
            }
        };
        
        _s.copyLinkButtonOnMouseOver = function(){
            _s.embedWindow_do.copyLinkButton_do.setSelectedState();
        };
        
        _s.copyLinkButtonOnMouseOut = function(){
            _s.embedWindow_do.copyLinkButton_do.setNormalState();
        };
        
        _s.getLinkCopyPath = function(){
            return _s.embedWindow_do.linkToVideo_str;
        };
        
        _s.embedkButtonOnMouseOver = function(){
            _s.embedWindow_do.copyEmbedButton_do.setSelectedState();
        };
        
        _s.embedButtonOnMouseOut = function(){
            _s.embedWindow_do.copyEmbedButton_do.setNormalState();
        };
        
        _s.getEmbedCopyPath = function(){
            return _s.embedWindow_do.finalEmbedCode_str;
        };
        
        
        //######################################//
        /* Add keyboard support */
        //######################################//
        _s.setInputs = function(){
            var numInputs = document.querySelectorAll('input');
            for (var i = 0; i < numInputs.length; i++) {
                numInputs[i].addEventListener("mousedown", _s.inputFocusInHandler);
                numInputs[i].addEventListener("touchstart", _s.inputFocusInHandler);
            }

            var numTextA = document.querySelectorAll('textarea');
            for (var i = 0; i < numTextA.length; i++) {
                numTextA[i].addEventListener("mousedown", _s.inputFocusInHandler);
                numTextA[i].addEventListener("touchstart", _s.inputFocusInHandler);
            }
        }
        
        _s.inputFocusInHandler = function(e){
            _s.curInput = e.target;
            setTimeout(function(){
                if(_s.hasPointerEvent_bl){
                    window.addEventListener("pointerdown", _s.inputFocusOutHandler);
                }else if(window.addEventListener){
                    window.addEventListener("mousedown", _s.inputFocusOutHandler);
                    window.addEventListener("touchstart", _s.inputFocusOutHandler);
                }
                FWDUVPlayer.isSearchedFocused_bl = true;
            }, 50);
        }
        
        _s.inputFocusOutHandler = function(e){
            
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            if(!FWDUVPUtils.hitTest(_s.curInput, vc.screenX, vc.screenY)){
                if(_s.hasPointerEvent_bl){
                    window.removeEventListener("pointerdown", _s.inputFocusOutHandler);
                }else if(window.removeEventListener){
                    window.removeEventListener("mousedown", _s.inputFocusOutHandler);
                    window.removeEventListener("touchstart", _s.inputFocusOutHandler);
                }
                FWDUVPlayer.isSearchedFocused_bl = false;
                return;
            }
        };
        
        _s.addKeyboardSupport = function(){
            _s.setInputs();
            document.addEventListener("keydown",  _s.onKeyDownHandler); 
            document.addEventListener("keyup",  _s.onKeyUpHandler);
        };
        
        _s.onKeyDownHandler = function(e){
            if((_s.isSpaceDown_bl || !_s.hasStartedToPlay_bl || FWDUVPlayer.isSearchedFocused_bl) && !_s.isCasting) return;
            if(_s != FWDUVPlayer.keyboardCurInstance && (FWDUVPlayer.videoStartBehaviour == "pause" || FWDUVPlayer.videoStartBehaviour == "none")) return;
            if(_s.embedWindow_do && _s.embedWindow_do.isShowed_bl) return;
            _s.isSpaceDown_bl = true;
            if(e.preventDefault) e.preventDefault();

            if (e.keyCode == 32){
                
                _s.stickOnCurrentInstanceKey_bl = true;
                if(_s.isCasting){
                    _s.cc.togglePlayPause();
                }else if(_s.videoType_str == FWDUVPlayer.IMAGE || _s.videoType_str == FWDUVPlayer.IFRAME){
                    if(_s.isImageAdsPlaying_bl){
                        _s.stopUpdateImageInterval();
                    }else{
                        _s.startUpdateImageInterval();
                    }
                }else if(_s.isIMA && _s.IMA.started){
                    _s.IMA.togglePlayPause();
                }else if(_s.videoType_str == FWDUVPlayer.YOUTUBE){
                    if(!_s.ytb_do.isSafeToBeControlled_bl) return;
                    _s.ytb_do.togglePlayPause();
                }else if(_s.videoType_str == FWDUVPlayer.VIMEO){
                    if(!_s.vimeo_do.isSafeToBeControlled_bl) return;
                    _s.vimeo_do.togglePlayPause();
                }else if(_s.videoType_str == FWDUVPlayer.MP3){
                    if(!_s.audioScreen_do.isSafeToBeControlled_bl) return;
                    _s.audioScreen_do.togglePlayPause();
                }else if(FWDUVPlayer.hasHTML5Video){
                    if(!_s.videoScreen_do.isSafeToBeControlled_bl) return;
                    if(_s.videoScreen_do) _s.videoScreen_do.togglePlayPause();
                }
                if(e.preventDefault) e.preventDefault();
                return false;
            }else if (e.keyCode == 70){
                if(_s.isFullScreen_bl){
                    _s.goNormalScreen();
                }else{
                    _s.goFullScreen();
                }
            }else if (e.keyCode == 77){
                if(_s.volume != 0) _s.lastVolume = _s.volume;
                if(_s.volume != 0){
                    _s.volume = 0;
                }else{
                    _s.volume = _s.lastVolume;
                }
                _s.setVolume(_s.volume);
            }else if (e.keyCode == 38){
                _s.volume += .1;
                if(_s.volume > 1) _s.volume = 1;
                _s.setVolume(_s.volume);
            }else if (e.keyCode == 40){
                _s.volume -= .1;
                if(_s.volume < 0) _s.volume = 0;
                _s.setVolume(_s.volume);
            }else if (e.keyCode == 77){
                
                if(_s.volume < 0) _s.volume = 0;
                _s.setVolume(_s.volume);
            }else if (e.keyCode == 39 && !_s.isAdd_bl && !_s.isIMA){
                var curTime = _s.getCurrentTime();
                if(curTime.length == 5) curTime = "00:" + curTime;
                if(curTime.length == 7) curTime = "0" + curTime;
                curTime = FWDUVPUtils.getSecondsFromString(curTime);
                curTime += 5;
                curTime = FWDUVPUtils.formatTime(curTime);
                if(curTime.length == 5) curTime = "00:" + curTime;
                if(curTime.length == 7) curTime = "0" + curTime;
                
                _s.scrubbAtTime(curTime);
            }else if (e.keyCode == 37 && !_s.isAdd_bl && !_s.isIMA){
                var curTime = _s.getCurrentTime();
                if(curTime.length == 5) curTime = "00:" + curTime;
                if(curTime.length == 7) curTime = "0" + curTime;
                curTime = FWDUVPUtils.getSecondsFromString(curTime);
                curTime -= 5;
                curTime = FWDUVPUtils.formatTime(curTime);
                if(curTime.length == 5) curTime = "00:" + curTime;
                if(curTime.length == 7) curTime = "0" + curTime;
                _s.scrubbAtTime(curTime);
            }
        };
        
        _s.onKeyUpHandler = function(e){
            _s.isSpaceDown_bl = false;
        };
        
        _s.setupAopw = function(){
            FWDUVPOPWindow.setPrototype();
            _s.popw_do = new FWDUVPOPWindow(_s._d, _s);
        }
        

        //####################################//
        /* Setup hider */
        //####################################//
        _s.setupHider = function(){
            FWDUVPHider.setPrototype();
            _s.hider = new FWDUVPHider(_s.main_do, _s.controller_do, _s._d.controllerHideDelay);
            _s.hider.addListener(FWDUVPHider.SHOW, _s.hiderShowHandler);
            _s.hider.addListener(FWDUVPHider.HIDE, _s.hiderHideHandler);
            _s.hider.addListener(FWDUVPHider.HIDE_COMPLETE, _s.hiderHideCompleteHandler);
        };
        
        _s.hiderShowHandler = function(){
            if(_s.controller_do && _s.isPlaying_bl) _s.controller_do.show(true);
            if(_s.logo_do && _s._d.hideLogoWithController_bl && _s.isPlaying_bl) _s.logo_do.show(true);
            _s.showCursor();
            
            if(_s.isAdd_bl){
                _s.positionAds(true);
                _s.adsStart_do.showWithOpacity();
                _s.adsSkip_do.showWithOpacity();    
            }
            
            if(_s.subtitle_do) _s.subtitle_do.position(true);
            if(_s.popupAds_do) _s.popupAds_do.position(true);
            
        };
        

        _s.hiderHideHandler = function(){
            if(_s.controller_do.volumeScrubber_do && _s.controller_do.isVolumeScrubberShowed_bl){
                _s.hider.reset();
                return;
            }

            if(_s.controller_do.atb && _s.controller_do.atb.isShowed_bl){
                if(FWDUVPUtils.hitTest(_s.controller_do.atb.mainHld.screen, _s.hider.globalX, _s.hider.globalY)){
                    _s.hider.reset();
                    return;
                }
            }
        
            if(_s._d.showYoutubeQualityButton_bl && FWDUVPUtils.hitTest(_s.controller_do.ytbButtonsHolder_do.screen, _s.hider.globalX, _s.hider.globalY)){
                _s.hider.reset();
                return;
            }
            
            if(_s._d.showPlaybackRateButton_bl && _s.controller_do && FWDUVPUtils.hitTest(_s.controller_do.playbackRatesButtonsHolder_do.screen, _s.hider.globalX, _s.hider.globalY)){
                _s.hider.reset();
                return;
            }

            if(_s._d.showAudioTracksButton_bl && _s.controller_do && FWDUVPUtils.hitTest(_s.controller_do.ATBButtonsHolder_do.screen, _s.hider.globalX, _s.hider.globalY)){
                _s.hider.reset();
                return;
            }
            
            if(_s.controller_do && _s._d.showSubBtn && FWDUVPUtils.hitTest(_s.controller_do.subtitlesButtonsHolder_do.screen, _s.hider.globalX, _s.hider.globalY)){
                _s.hider.reset();
                return;
            }
            
            if(FWDUVPUtils.hitTest(_s.controller_do.screen, _s.hider.globalX, _s.hider.globalY)){
                _s.hider.reset();
                return;
            }
            
            if(FWDUVPUtils.hitTest(_s.controller_do.mainScrubber_do.screen, _s.hider.globalX, _s.hider.globalY)){
                _s.hider.reset();
                return;
            }
            
            
            if(_s._d.showDefaultControllerForVimeo_bl || _s.videoType_str != FWDUVPlayer.VIMEO){
                _s.controller_do.hide(true);
            }
            
            if(_s.logo_do && _s._d.hideLogoWithController_bl) _s.logo_do.hide(true);
            if(_s.isFullScreen_bl) _s.hideCursor();
            
            if(_s.isAdd_bl){
                _s.positionAds(true);
                _s.adsStart_do.hideWithOpacity();
                _s.adsSkip_do.hideWithOpacity();    
            }
            
            _s.subtitle_do.position(true);
            if(_s.popupAds_do) _s.popupAds_do.position(true);
        };
        
        _s.hiderHideCompleteHandler = function(){
            _s.controller_do.positionScrollBarOnTopOfTheController();
        };
        

        //####################################//
        // API
        //###################################//
        _s.play = function(){
            
            if(!_s.isAPIReady_bl) return;
            
            if(_s.isCasting){
                _s.cc.play();
                return;
            }
        
            if(_s.videoType_str == FWDUVPlayer.HLS_JS){
                if(location.protocol.indexOf("file:") >= 0){
                    _s.showSourceError("HLS m3u8 videos can't be played local on _s browser, please test it online!.");
                    return;
                }
            }

            var check = _s.checkPassWindow();
            if(!check) return;
            _s.hasPassedPassowrd_bl = true;

            if(_s._d.playIfLoggedIn || _s._d.playlist_ar[_s.id]['playIfLoggedIn']){
                _s.lg_do.show();
                _s.videoPoster_do.show();
                return;
            }
            
            if(_s.isMbl){
                  FWDUVPlayer.stopAllVideos(_s);
            }else{
                if(FWDUVPlayer.videoStartBehaviour == FWDUVPlayer.PAUSE_ALL_VIDEOS){
                    FWDUVPlayer.pauseAllVideos(_s);
                }else if(FWDUVPlayer.videoStartBehaviour == FWDUVPlayer.STOP_ALL_VIDEOS){
                    FWDUVPlayer.stopAllVideos(_s);
                }
            }
            
            if(_s.isIMA){
                if(_s.isIMA && _s.IMA && !_s.IMA.isReady) return;
                _s.IMA.play();
            }else if(_s.videoType_str == FWDUVPlayer.IMAGE || _s.videoType_str == FWDUVPlayer.IFRAME){
                _s.startUpdateImageInterval();
            }else if(_s.videoType_str == FWDUVPlayer.YOUTUBE){
                if(_s.ytb_do) _s.ytb_do.play();
            }else if(_s.videoType_str == FWDUVPlayer.MP3){
                if(_s.audioScreen_do) _s.audioScreen_do.play();
                if(!FWDUVPUtils.isLocal) _s.audioScreen_do.setupSpectrum();
            }else if(_s.videoType_str == FWDUVPlayer.VIMEO){
                if(_s.vimeo_do) _s.vimeo_do.play();
            }else if(FWDUVPlayer.hasHTML5Video){
                if(_s.videoType_str == FWDUVPlayer.HLS_JS && !_s.isHLSManifestReady_bl){
                    _s.videoScreen_do.initVideo();
                    if(window['Hls']){
                        _s.setupHLS();
                        _s.hlsJS.loadSource(_s.videoSourcePath_str);
                        _s.hlsJS.attachMedia(_s.videoScreen_do.video_el);
                        
                        _s.hlsJS.on(Hls.Events.MANIFEST_PARSED,function(e){
                            _s.isHLSManifestReady_bl = true;
                            if(_s.videoType_str == FWDUVPlayer.HLS_JS){
                                _s.play();
                                _s.parseLevels();
                            } 
                        });
                    }
                }else if(_s.videoType_str == FWDUVPlayer.DASH && !_s.isDASHManifestReady_bl){
                    _s.videoScreen_do.initVideo();
                    
                    if(window['dashjs']){
                        _s.setupDASH();
                        _s.dashJS.initialize(_s.videoScreen_do.video_el, _s.videoSourcePath_str, false);
                        _s.dashJS.attachSource(_s.videoSourcePath_str);
                        _s.dashJS.on(dashjs.MediaPlayer.events.MANIFEST_LOADED, function(e){
                            _s.isDASHManifestReady_bl = true;
                            if(_s.videoType_str == FWDUVPlayer.DASH) setTimeout(_s.play, 100);
                        });
                    }
                }else{
                    _s.videoScreen_do.play();
                }
            }

            _s.lrgPlayBtn.hide();
            _s.videoPoster_do.hide();
        };
        
        _s.pause = function(){
            if(!_s.isAPIReady_bl) return;
            
            if(_s.isCasting){
                _s.cc.pause();
                return;
            }
            if(_s.isIMA){
                _s.IMA.pause();
            }else if(_s.videoType_str == FWDUVPlayer.IMAGE || _s.videoType_str == FWDUVPlayer.IFRAME){
                _s.stopUpdateImageInterval();
            }else if(_s.videoType_str == FWDUVPlayer.YOUTUBE){
                _s.ytb_do.pause();
            }else if(_s.videoType_str == FWDUVPlayer.MP3){
                if(_s.audioScreen_do) _s.audioScreen_do.pause();
            }else if(_s.videoType_str == FWDUVPlayer.VIMEO){
                _s.vimeo_do.pause();
            }else if(FWDUVPlayer.hasHTML5Video){
                if(_s.videoScreen_do) _s.videoScreen_do.pause();
            }
        };
        
        _s.resume = function(){
            if(!_s.isAPIReady_bl) return;
            
            if(_s.isCasting){
                _s.cc.play();
            }else if(_s.isIMA && _s.IMA.started){
                _s.IMA.play();
            }else if(_s.videoType_str == FWDUVPlayer.IMAGE || _s.videoType_str == FWDUVPlayer.IFRAME){
                _s.startUpdateImageInterval();
            }else if(_s.videoType_str == FWDUVPlayer.YOUTUBE && _s.ytb_do){
                _s.ytb_do.resume();
            }else if(_s.videoType_str == FWDUVPlayer.MP3){
                if(_s.audioScreen_do) _s.audioScreen_do.resume();
            }else if(_s.videoType_str == FWDUVPlayer.VIMEO && _s.vimeo_do){
                _s.vimeo_do.resume();
            }else if(FWDUVPlayer.hasHTML5Video){
                if(_s.videoScreen_do) _s.videoScreen_do.resume();
            }
        };

        _s.sendGAPlayedEvent = function(){
            if(!isNaN(_s.totalPercentPlayed) && _s.gtag && !_s.isAdd_bl){
                if(Math.round(_s.totalPercentPlayed * 100)){

                    var params = {
                        'video_name': _s.videoNameGa,
                        'video_url': _s.source,
                        'percent_played' : Math.round(_s.totalPercentPlayed * 100),
                        'stopped_at_time': _s.getCurrentTime(),
                        'duration' : _s.getTotalTime(),
                        'full_screen': _s.isFullScreen_bl
                    }

                    _s.gtag('event', 'played', params);
                
                    _s.totalTimePlayed = 0;
                    _s.totalPercentPlayed = 0;
                }
            }
        }   

        _s.sendGAPlayedAdEvent = function(source, percentPlayed, duration){
            if(!source){
                source = _s.source;
            }

            if(!percentPlayed){
                percentPlayed = _s.totalPercentPlayed;
            }

            if(!duration){
                duration = _s.getTotalTime();
            }
            
            if(!isNaN(percentPlayed) && _s.gtag){
                if(Math.round(_s.totalPercentPlayed * 100)){

                    var params = {
                        'video_url': source,
                        'percent_played' : Math.round(percentPlayed * 100),
                        'stopped_at_time': _s.getCurrentTime(),
                        'duration': duration,
                        'full_screen': _s.isFullScreen_bl
                    }
                
                    _s.gtag('event', 'ads', params);

                    _s.totalTimePlayed = 0;
                    _s.totalPercentPlayed = 0;
                }
            }
        }   
        
        _s.stop = function(source){
            if(!_s.isAPIReady_bl) return;
            if(_s.isStopped_bl) return;
            
            _s.sendGAPlayedEvent();
            
            if(_s.isCasting){
                _s.cc.stop();
            }
            if(_s.IMA) _s.IMA.stop();
            
            FWDUVPPassword.isCorect = true;
            _s.totalTimePlayed = 0;
            _s.totalDuration = 0;
            _s.isIMA = undefined;
            _s.hlsLevels_ar = null;
            _s.hasPassedPassowrd_bl = false;
            _s.isHLSManifestReady_bl = false;
            _s.isDASHManifestReady_bl = false;
            clearInterval(_s.tryHLS_int);
            clearInterval(_s.checkIfYoutubePlayerIsReadyId_int);
            clearInterval(_s.keepCheckingYoutubeAPI_int);
            _s.hideAPT();
            _s.destroyDASH();
            _s.destroyHLS();
            _s._d.closeVast();
            if(_s.fps) _s.fps.stop();
            _s.isPlaying_bl = false;
            if(_s.customContextMenu_do) _s.customContextMenu_do.disable();
                
            if(_s.videoType_str == FWDUVPlayer.IMAGE || _s.videoType_str == FWDUVPlayer.IFRAME){
                _s.stopUpdateImageInterval();
            }else if(_s.videoType_str == FWDUVPlayer.YOUTUBE && _s.ytb_do){
                _s.ytb_do.stop();
            }else if(_s.videoType_str == FWDUVPlayer.MP3){
                if(_s.audioScreen_do) _s.audioScreen_do.stop();
            }else if(_s.videoType_str == FWDUVPlayer.VIMEO && _s.vimeo_do){
                _s.vimeo_do.stop();
            }else if(FWDUVPlayer.hasHTML5Video){
                _s.videoScreen_do.stop();
            }
            
            clearTimeout(_s.playVimeoWhenLoadedId_to); 
            if(_s.popw_do) _s.popw_do.hide();
            
            if(_s._d.playlist_ar[_s.id]){
                _s.posterPath_str = _s._d.playlist_ar[_s.id].posterSource;
            }
            
            if(_s.isMbl){
                if(_s._d.showControllerWhenVideoIsStopped_bl && _s.controller_do) _s.controller_do.show(true);
                
                _s.videoPoster_do.show();
                _s.lrgPlayBtn.show();
                
            }else{
                if(!_s.isThumbClick_bl){
                    if(_s.controller_do && _s._d.showControllerWhenVideoIsStopped_bl) _s.controller_do.show(true);
                    if(_s.videoPoster_do) _s.videoPoster_do.show();
                    if(_s.lrgPlayBtn) _s.lrgPlayBtn.show();
                }
            }
            
            if(_s.controller_do){
                if(_s.controller_do.atb) _s.controller_do.atb.hide(true);
                if(_s.controller_do.subtitleButton_do){
                    _s.controller_do.disableSubtitleButton();
                    if(_s.subtitle_do){
                        if(_s.subtitle_do.showSubByDflt){
                            _s.controller_do.subtitleButton_do.setButtonState(0);
                        }else{
                            _s.controller_do.subtitleButton_do.setButtonState(1);
                        }
                    }
                }
                if(_s.controller_do.thumbnailsPreview_do) _s.controller_do.thumbnailsPreview_do.remove();

                if(_s.controller_do.atbButton_do){
                    _s.controller_do.atbButton_do.doNotallowToSetNormal = false;
                    _s.controller_do.atbButton_do.isSelected = false;
                    _s.controller_do.atbButton_do.setNormalState();
                }

                _s.controller_do.disableAtbButton();
                if(_s.controller_do.ttm) _s.controller_do.ttm.hide();
                if(_s.controller_do.ytbQualityButton_do) _s.controller_do.ytbQualityButton_do.disable();
                if(_s.controller_do.playbackRateButton_do) _s.controller_do.playbackRateButton_do.disable();
                if(_s.controller_do && _s.controller_do.rewindButton_do) _s.controller_do.rewindButton_do.disable();
            }
            
            if(_s.popupAds_do){
                _s.popupAds_do.hideAllPopupButtons(false);
            }
            
            _s.hasHlsPlayedOnce_bl = false;
            _s.isSafeToScrub_bl = false;
            _s.hlsState = undefined;
            _s.changeHLS_bl = false;
            _s.totalDuration = 0;
            _s.hasStartedToPlay_bl = false;
            
            if(_s.controller_do){
                _s.controller_do.disablePlaybackRateButton();
                _s.controller_do.disableAtButton();
            }
            if(_s.subtitle_do) _s.subtitle_do.hide();
            if(_s.annotations_do) _s.annotations_do.update(-1);
            if(_s.hider) _s.hider.reset();
            _s.showCursor();
            if(_s.adsStart_do) _s.adsStart_do.hide(true);
            if(_s.adsSkip_do) _s.adsSkip_do.hide(true);
            if(_s.controller_do) _s.controller_do.hideAdsLines();
            _s.stopVisualization();
            _s.isStopped_bl = false;
        };
        
        _s.startToScrub = function(){
            if(!_s.isAPIReady_bl) return;
            if(_s.videoType_str == FWDUVPlayer.YOUTUBE && _s.ytb_do && _s.ytb_do.isSafeToBeControlled_bl){
                _s.ytb_do.startToScrub();
            }else if(_s.videoType_str == FWDUVPlayer.MP3){
                if(_s.audioScreen_do) _s.audioScreen_do.startToScrub();
            }else{
                if(_s.videoScreen_do) _s.videoScreen_do.startToScrub();
            }
        };
        
        _s.stopToScrub = function(){
            if(!_s.isAPIReady_bl) return;
            if(_s.videoType_str == FWDUVPlayer.YOUTUBE && _s.ytb_do && _s.ytb_do.isSafeToBeControlled_bl){
                _s.ytb_do.stopToScrub();
            }else if(_s.videoType_str == FWDUVPlayer.MP3){
                if(_s.audioScreen_do) _s.audioScreen_do.stopToScrub();
            }else {
                if(_s.videoScreen_do) _s.videoScreen_do.stopToScrub();
            }
        };
        
        _s.scrubbAtTime = function(duration){
            if(!_s.isAPIReady_bl || !duration) return;
            if(String(duration).indexOf(":") != -1) duration = FWDUVPUtils.getSecondsFromString(duration);
            if(_s.isCasting){
                _s.cc.scrubbAtTime(duration);
            }else if(_s.videoType_str == FWDUVPlayer.YOUTUBE && _s.ytb_do && _s.ytb_do.isSafeToBeControlled_bl){
                _s.ytb_do.scrubbAtTime(duration);
            }else if(_s.videoType_str == FWDUVPlayer.VIMEO && _s.vimeo_do){
                _s.vimeo_do.scrubbAtTime(duration);
            }else if(_s.videoType_str == FWDUVPlayer.MP3){
                if(_s.audioScreen_do) _s.audioScreen_do.scrubbAtTime(duration);
            }else if(FWDUVPlayer.hasHTML5Video){
                if(_s.videoScreen_do) _s.videoScreen_do.scrubbAtTime(duration);
            }
        };
        
        _s.scrub = function(percent){
            if(!_s.isAPIReady_bl) return;
            if(isNaN(percent)) return;
            if(percent < 0){
                percent = 0;
            }else if(percent > 1){
                percent = 1;
            }
            
            if(_s.videoType_str == FWDUVPlayer.YOUTUBE && _s.ytb_do && _s.ytb_do.isSafeToBeControlled_bl){
                _s.ytb_do.scrub(percent);
            }else if(_s.videoType_str == FWDUVPlayer.MP3){
                if(_s.audioScreen_do) _s.audioScreen_do.scrub(percent);
            }else if(_s.videoType_str == FWDUVPlayer.VIMEO && _s.vimeo_do && _s.vimeo_do.isSafeToBeControlled_bl){
                _s.vimeo_do.scrub(percent);
            }else{
                if(_s.videoScreen_do) _s.videoScreen_do.scrub(percent);
            }
        };
        
        _s.setVolume = function(volume, removeAutoPlay){
            if(!_s.isAPIReady_bl) return;
            _s.volume = volume;

            if(volume && removeAutoPlay){
                _s._d.autoPlay_bl = false;
                _s.removeAPT();
            } 

            if(_s.controller_do) _s.controller_do.updateVolume(volume, true);
            
            if(_s.isIMA) _s.IMA.setVolume(volume);
            if(_s.videoType_str == FWDUVPlayer.YOUTUBE && _s.ytb_do){
                _s.ytb_do.setVolume(volume);
            }
            
            if(_s.videoType_str == FWDUVPlayer.VIMEO && _s.vimeo_do){
                _s.vimeo_do.setVolume(volume);
            }
            
            if(_s.audioScreen_do){
                _s.audioScreen_do.setVolume(volume);
            }
            
            if(FWDUVPlayer.hasHTML5Video){
                if(_s.videoScreen_do) _s.videoScreen_do.setVolume(volume);
            }
            
            if(_s.isCasting){
                _s.cc.setVolume();
            }
            
            _s.dispatchEvent(FWDUVPlayer.VOLUME_SET, {volume:volume});
        };
            
        _s.showCategories = function(){
            
            if(!_s.isAPIReady_bl) return;
            _s.setVideoPlayingStateOnWindowShow();
            
            if(_s.categories_do){
                _s.categories_do.show(_s.catId);
                if(_s.controller_do) _s.controller_do.setCategoriesButtonState("selected");
                _s.pause();
            }
        };
        
        _s.hideCategories = function(){
            if(!_s.isAPIReady_bl) return;
            if(_s.categories_do){
                _s.categories_do.hide();
                if(_s.controller_do) _s.controller_do.setCategoriesButtonState("unselected");
            }
        };
        
        _s.showPlaylist = function(){
            if(!_s.isAPIReady_bl || !_s.showPlaylistButtonAndPlaylist_bl) return;
            _s.isPlaylistShowed_bl = false;
            
            if(_s.controller_do) _s.controller_do.showHidePlaylistButton();
            _s.playlist_do.hide(_s.animate_bl);
            if(_s.playlistPosition_str == 'right'){
                _s.resizeHandler(!_s.isMbl);
            }
            
            _s.sH = _s.vidStageHeight;
            _s.setStageContainerFinalHeightAndPosition(_s.animate_bl);

            FWDAnimation.to(_s, .8, {tempStageWidth:_s.sW,
                                         tempStageHeight:_s.sH,
                                         tempVidStageWidth:_s.vidStageWidth,
                                         tempVidStageHeight:_s.vidStageHeight,
                                         ease:Expo.easeInOut,
                                         onUpdate:_s.resizeFinal});
        };
        
        _s.hidePlaylist = function(resNoAnim){
            if(!_s.isAPIReady_bl || !_s.showPlaylistButtonAndPlaylist_bl) return;
            
            _s.isPlaylistShowed_bl = true;
            if(_s.controller_do) _s.controller_do.showShowPlaylistButton();
            if(resNoAnim){
                _s.playlist_do.show(false);
            }else{
                _s.playlist_do.show(_s.animate_bl);
            }
            
            _s.resizeHandler(_s.animate_bl);
            _s.setStageContainerFinalHeightAndPosition(_s.animate_bl);
            
            FWDAnimation.to(_s, .8, {tempStageWidth:_s.sW,
                                         tempStageHeight:_s.sH,
                                         tempVidStageWidth:_s.vidStageWidth,
                                         tempVidStageHeight:_s.vidStageHeight,
                                         ease:Expo.easeInOut,
                                         onUpdate:_s.resizeFinal});
        
        };
        
        _s.setPosterSource = function(path){
            
            if(!_s.isAPIReady_bl || !path || _s.videoType_str == 'none') return;
            var path_ar = path.split(",");
                
            if(_s.isMbl && path_ar[1] != undefined){
                path = path_ar[1];
            }else{
                path = path_ar[0];
            }

            if(!_s.videoPoster_do) return;
            _s.posterPath_str = path;
            
            _s.videoPoster_do.setPoster(_s.posterPath_str);
            if(_s.prUVPosterSource_str != path) _s.dispatchEvent(FWDUVPlayer.UPDATE_POSTER_SOURCE);
            
            _s.prUVPosterSource_str = path;
        };
        
        _s.setThumbnailPreviewSource = function(source){
            if(!_s.isAPIReady_bl || FWDUVPUtils.isLocal) return;
            if(_s.controller_do){
                
                if(!_s.thumbnailsPreviewLoaded_bl){
                    var script = document.createElement('script');
                    script.src =  _s.mainFolderPath_str + 'java/FWDUVPThumbnailsPreview.js'
                    document.head.appendChild(script);
    
                    script.onload = function () {
                        _s.thumbnailsPreviewLoaded_bl = true;
                        _s.setThumbnailPreviewSource(source);
                    }
                    return;
                }
                    
                _s.hasThumbnailsPreview = true;
                _s.controller_do.setupThumbnailsPreview()
                _s.controller_do.thumbnailsPreview_do.load(source);
            }
        }

        
        //#####################################################//
        /* Update ads */
        //#####################################################//
        _s.updateAds = function(duration, setSourceOverwrite){
            if(_s._d.vastXML && !_s._d.isVastXMLParsed_bl){
                if(_s.controller_do){
                    _s.controller_do.hideAdsLines();
                    _s.controller_do.resetsAdsLines();
                }
                _s._d.setVastSource(_s._d.vastXML);
                return;
            } 

            if(!_s._d.playlist_ar[_s.id]) return;
            _s.curAddData = _s._d.playlist_ar[_s.id].ads_ar;

            _s.curPopupAdsData = _s._d.playlist_ar[_s.id].popupAds_ar;
            var hasPopupAds = (_s.curPopupAdsData && _s.curPopupAdsData.length > 0);
            
            if(_s.adsId != _s.id){
                if(_s.popupAds_do) _s.popupAds_do.hideAllPopupButtons(true);
                if(_s.controller_do) _s.controller_do.resetsAdsLines();
            }
            
            if(_s._d.playlist_ar[_s.id].vastURL && !_s.curAddData){
                if(_s.adsId != _s.id){
                    _s._d.setVastSource(_s._d.playlist_ar[_s.id].vastURL, _s._d.playlist_ar[_s.id].vastLinearStartTime);
                }
                _s.adsId = _s.id;
                return;
            }
            _s.adsId = _s.id;
            
            if(!_s.isAdd_bl){
                _s.TrackingEvents = undefined;
                _s.Impression = undefined;
                _s.ClickTracking = undefined;
                if(_s.curAddData){
                    _s.callFirstQuartile = true;
                    _s.callMidpoint = true;
                    _s.callThirdQuartile = true;
                }
            }
            
            if(!_s.isAdd_bl){
                if(_s.controller_do){

                    if(_s.totalDuration){
                        _s._d.fixVmapTimes(_s.totalDuration, _s.curAddData, _s.curPopupAdsData, _s.id);
                        _s.controller_do.setupAdsLines(_s.curAddData, _s.id, _s.catId);
                        if(_s.totalDuration) _s.controller_do.positionAdsLines(_s.totalDuration);
                        if(hasPopupAds){
                            _s.popupAds_do.resetPopups(_s.curPopupAdsData, _s.id);
                            _s.popupAds_do.id = _s.id;
                        }
                    }
                }
                
                _s.curSource = _s._d.playlist_ar[_s.id].videoSource[_s._d.playlist_ar[_s.id].startAtVideo]["source"];
                
                if(_s.curAddData){
                    for(var i=0; i<_s.curAddData.length; i++){
                        if(duration >= _s.curAddData[i].timeStart && duration <= (_s.curAddData[i].timeStart + 1) 
                            && !_s.curAddData[i].played_bl && duration != _s.prevDuration){
                                
                            _s.addId = i;
                            if(_s.curAddData[i].timeStart == 0){
                                setSourceOverwrite = false;
                                _s.addStartAtZero = true;
                            }else{
                                _s.addStartAtZero = false;
                            }
                            _s.isAdd_bl = true;
                        
                            _s.addSource_str = _s.curAddData[i].source;
                            _s.curAddData[_s.addId].played_bl = true;
                            _s.adDuation = duration;
                        
                            _s._d.adsThumbnailPath_str = _s.curAddData[i].thumbnailSource;
                            _s._d.timeToHoldAds = _s.curAddData[i].timeToHoldAds;
                            _s._d.adsPageToOpenURL_str = _s.curAddData[i].link;
                            _s._d.adsPageToOpenTarget_str = _s.curAddData[i].target;
                            _s.TrackingEvents = _s.curAddData[i].TrackingEvents;
                            _s.Impression = _s.curAddData[i].Impression
                            _s.ClickTracking = _s.curAddData[i].ClickTracking
                            _s.scrubAfterAddDuration = _s.curAddData[i].timeStart;
                            _s.curImageTotalTime = _s.curAddData[i].addDuration;
                            _s.setSource(_s.addSource_str);
                        
                            if(_s.controller_do && _s.controller_do.line_ar) _s.controller_do.line_ar[i].setVisible(false);
                            _s.prvAdSource = _s.addSource_str;
                            return;
                        }
                    }
                }
            }else{
                if(!_s.isAdd_bl){
                    _s.curSource = _s._d.playlist_ar[_s.id].videoSource[_s._d.playlist_ar[_s.id].startAtVideo]["source"];
                }else{
                    _s.curSource = "FWDUVPDummy" + new Date().getTime();
                }
            }
        
            
            _s.isLive = _s._d.playlist_ar[_s.id]["isLive"];
            
            if(!_s.isAdd_bl && _s.prevSource != _s.curSource && _s.curSource.indexOf("FWDUVPDummy") == -1 || setSourceOverwrite){
                if(setSourceOverwrite){
                    _s.isAdd_bl = false;
                    _s.curSource = _s._d.playlist_ar[_s.id].videoSource[_s._d.playlist_ar[_s.id].startAtVideo]["source"]
                }
                _s.setSource(_s.curSource, false, _s._d.playlist_ar[_s.id].videoSource[_s._d.playlist_ar[_s.id].startAtVideo]["is360"]);
            }
            if(_s.controller_do) _s.controller_do.positionAdsLines(_s.curDuration);
            _s.prevDuration = duration;
            _s.prevSource = _s.curSource;
        };
        

        //#####################################################//
        /* Setup image screen */
        //#####################################################//
        _s.updateImageScreen = function(source){
            if(_s.videoType_str == FWDUVPlayer.IFRAME){
                if(!_s.ifr_do){     
                    _s.ifr_do = new FWDUVPDisplayObject("iframe");
                    _s.ifr_do.hasTransform3d_bl = false;
                    _s.ifr_do.hasTransform2d_bl = false;
                    _s.ifr_do.setBackfaceVisibility();
                }
                
                _s.videoHolder_do.addChildAt(_s.ifr_do, _s.videoHolder_do.getChildIndex(_s.dClk_do) + 1);
                _s.showClickScreen();
                
                _s.ifr_do.screen.src = source;
                _s.ifr_do.setBkColor("#000000");
                _s.positionAdsImage();
                _s.startToUpdateAdsButton();
                return;
            }

            if(!_s.imgH_do){
                _s.imgH_do = new FWDUVPDisplayObject("div");
                _s.imgH_do.setX(0);
                _s.imgH_do.setY(0);
                _s.imgH_do.setBkColor("#000000");
            }
            
            _s.videoHolder_do.addChildAt(_s.imgH_do,  _s.videoHolder_do.getChildIndex(_s.dClk_do) - 1);
            _s.showClickScreen();
            if(_s.imgH_do.contains(_s.imageScreen_do)) _s.imgH_do.removeChild(_s.imageScreen_do);
            _s.imageScreen_do = null;
            
            _s.imageScreen_do = new FWDUVPDisplayObject("img");
            
            _s.imageAdd_img = new Image()
            _s.imageAdd_img.src = source;
        
            if(_s.preloader_do){
                _s.preloader_do.show(false);
            }
            if(_s.lrgPlayBtn) _s.lrgPlayBtn.hide();
            
            _s.imageAdd_img.onload = function(){
                _s.imageScreen_do.setScreen(_s.imageAdd_img);
                _s.imageScreen_do.setAlpha(0);
                FWDAnimation.to(_s.imageScreen_do, 1, {alpha:1});
                _s.imageAddOriginalWidth = _s.imageAdd_img.width;
                _s.imageAddOriginalHeight = _s.imageAdd_img.height;
                if(_s.preloader_do) _s.preloader_do.hide();
                _s.imgH_do.addChild(_s.imageScreen_do);
                _s.positionAdsImage();
                _s.startToUpdateAdsButton();
            }
            
            _s.imageAdd_img.onerror = function(){
                _s.showSourceError("Advertisment image with path " +  source + " can't be found");
                return;
            }
        }
        
        _s.positionAdsImage = function(){

            if(_s.videoType_str == FWDUVPlayer.IFRAME && _s.ifr_do){
                _s.ifr_do.setWidth(_s.tempVidStageWidth);
                _s.ifr_do.setHeight(_s.tempVidStageHeight);
            }

            if(!_s.imageScreen_do || _s.videoType_str != FWDUVPlayer.IMAGE) return;
            var scaleX = _s.tempVidStageWidth/_s.imageAddOriginalWidth;
            var scaleY = _s.tempVidStageHeight/_s.imageAddOriginalHeight;
            
            var totalScale = 0;
            if(scaleX >= scaleY){
                totalScale = scaleX;
            }else if(scaleX <= scaleY){
                totalScale = scaleY;
            }
            
            var finalW = parseInt(_s.imageAddOriginalWidth * totalScale);
            var finalH = parseInt(_s.imageAddOriginalHeight * totalScale);
            var finalX = parseInt((_s.tempVidStageWidth - finalW)/2);
            var finalY = parseInt((_s.tempVidStageHeight - finalH)/2);
            
            _s.imageScreen_do.setWidth(finalW); 
            _s.imageScreen_do.setHeight(finalH); 
            _s.imageScreen_do.setX(finalX); 
            _s.imageScreen_do.setY(finalY); 
            _s.imgH_do.setWidth(_s.tempVidStageWidth);
            _s.imgH_do.setHeight(_s.tempVidStageHeight);
        }
        
        _s.startToUpdateAdsButton = function(){
            _s.curImageTime = 0;
            _s.updateAdsButton();
            _s.stopUpdateImageInterval();
            
            if(_s._d.autoPlay_bl || _s.adDuation || _s.isThumbClick_bl){ 
                _s.startUpdateImageInterval();
                _s.setPlayAndPauseButtonState();    
            }
        }
        
        _s.stopUpdateImageInterval = function(){
            _s.isImageAdsPlaying_bl = false;
            clearInterval(_s.startUpdateAdsId_int);
            _s.setPlayAndPauseButtonState();
            _s.isPlaying_bl = false;
            _s.hider.stop();    
        }
        
        _s.startUpdateImageInterval = function(){
            _s.isImageAdsPlaying_bl = true;
            _s.startUpdateAdsId_int = setInterval(_s.updateAdsButton, 1000);
            _s.setPlayAndPauseButtonState();
            if(_s.lrgPlayBtn) _s.lrgPlayBtn.hide();
            _s.isPlaying_bl = true;
            _s.hider.start();
        }
        
        _s.updateAdsButton = function(){
            _s.videoScreenUpdateTimeHandler({curTime:FWDUVPUtils.formatTime(_s.curImageTime), totalTime:FWDUVPUtils.formatTime(_s.curImageTotalTime), seconds:_s.curImageTime});
            _s.videoScreenUpdateHandler({percent:_s.curImageTime/_s.curImageTotalTime});
            if(_s.curImageTime == _s.curImageTotalTime) _s.videoScreenPlayCompleteHandler();
            _s.curImageTime += 1;
        }
        
        _s.setPlayAndPauseButtonState = function(){
            if(_s.isImageAdsPlaying_bl){
                if(_s.controller_do) _s.controller_do.showPauseButton();
            }else{
                if(_s.controller_do) _s.controller_do.showPlayButton();
            }
        }
        
        // Set source
        _s.showSourceError = function(txt){
            _s.main_do.addChild(_s.info_do);
            _s.info_do.showText(txt);
            if(_s.preloader_do) _s.preloader_do.hide();
            _s.resizeHandler();
        }
        
        _s.setSource = function(source, overwrite, is360){
            
            if(source) _s.source = source;

            if(_s._d.playlist_ar && _s._d.playlist_ar[_s.id] && !_s._d.playlist_ar[_s.id]['playIfLoggedIn']){
                if(_s.lg_do) _s.lg_do.hide();
            }
            
            _s.is360 = is360;

            // Thumbnails preview.
            if(_s._d.playlist_ar && _s._d.playlist_ar[_s.id]['thumbnailsPreview']){
                if(location.protocol.indexOf("file:") != -1){
                    setTimeout(function(){
                        _s.showSourceError("This browser doesn't allow thumbnails preview videos local, please test online.")
                    }, 50);
                }

                if(_s._d.playlist_ar[_s.id]['thumbnailsPreview'].length > 2
                   && location.protocol.indexOf("file:") == -1
                   && !_s.thumbnailsPreviewLoaded_bl){
                    var script = document.createElement('script');
                    script.src =  _s.mainFolderPath_str + 'java/FWDUVPThumbnailsPreview.js'
                    document.head.appendChild(script);
                    
                    script.onerror = function(e){
                        _s.main_do.addChild(_s.info_do);
                        _s.showSourceError('The thumbnails preview javascript file named <font color="#FF0000">FWDUVPThumbnailsPreview.js</font> is not found. Please make sure that the content folder contains the java folder that contains the <font color="#FF0000">FWDUVPThumbnailsPreview.js</font> file.');
                    }
                    
                    script.onload = function () {
                        _s.thumbnailsPreviewLoaded_bl = true;
                        _s.setSource(_s.source, false, _s.is360);
                    }
                    return;
                }
            }
            
            _s.hasThumbnailsPreview = false;
            if(_s._d.playlist_ar[_s.id]['thumbnailsPreview'] && _s._d.playlist_ar[_s.id]['thumbnailsPreview'].length > 2){
                _s.hasThumbnailsPreview = true;
                if(_s.controller_do) _s.controller_do.setupThumbnailsPreview();
            }
            
            if(!_s.isAPIReady_bl || _s.id == -1) return;
            
            if(_s.id < 0){
                _s.id = 0;
            }else if(_s.id > _s.totaadsIdeos - 1){
                _s.id = _s.totaadsIdeos - 1;
            }
            
            if(_s._d.playlist_ar[_s.id] == undefined) return;
            
            _s.stop(source);

            // Remove APT.
            if(_s.isThumbClick_bl && !_s.aptRemoved){
                _s._d.autoPlay_bl = false;
                _s.removeAPT();
                _s.setVolume(_s._d.volume, true);
            }

            // Cuepoints.
            _s.cuePointsSource_ar = _s._d.playlist_ar[_s.id].cuepoints_ar;
            
            // Advertisement.
            if(_s.playlist_do && _s.playlist_do.curId != _s.id){
                _s.prvAdSource = Math.random() * 999999999;
                if(!_s._d.playAdsOnlyOnce_bl){
                    for(var i=0; i<_s._d.playlist_ar.length; i++){
                        if(_s._d.playlist_ar[i].ads_ar){
                            for(var j=0; j<_s._d.playlist_ar[i].ads_ar.length; j++){
                                _s._d.playlist_ar[i].ads_ar[j].played_bl = false;
                            }
                        }   
                        if(_s._d.playlist_ar[i].popupAds_ar){
                            for(var j=0; j<_s._d.playlist_ar[i].popupAds_ar.length; j++){
                                _s._d.playlist_ar[i].popupAds_ar[j].isClsd = false;
                            }
                        }   
                    }
                }

                if(!_s._d.executeCuepointsOnlyOnce_bl){
                    if(_s.cuePointsSource_ar){
                        for(var i=0; i<_s.cuePointsSource_ar.length; i++){
                            _s.cuePointsSource_ar[i].played_bl = false;
                        }
                    }
                }
            }
        
            if(source.toLowerCase().indexOf("vimeo.com") != -1 
               && source.toLowerCase().indexOf(".m3u8") == -1
               && source.toLowerCase().indexOf(".mp4") == -1){
                _s.videoType_str = FWDUVPlayer.VIMEO;
            }else if(source.toLowerCase().indexOf("youtube.") != -1){
                _s.videoType_str = FWDUVPlayer.YOUTUBE;
            }else if(source.toLowerCase().indexOf(".mp3") != -1){
                _s.videoType_str = FWDUVPlayer.MP3;
                if(_s.controller_do) _s.controller_do.setX(0);
            }else if(source.toLowerCase().indexOf(".jpg") != -1 
                    || source.toLowerCase().indexOf(".jpeg") != -1 
                    || source.toLowerCase().indexOf(".png") != -1
            ){
                _s.videoType_str = FWDUVPlayer.IMAGE;
                if(_s.controller_do) _s.controller_do.setX(0);
            }else if(!source.match(/\.mpd|\.m3u8|\.mp4|\.mov|google.com|lh3.|myqnapcloud/ig)){
                _s.videoType_str = FWDUVPlayer.IFRAME;
                if(_s.controller_do) _s.controller_do.setX(0);
            }else{
                if(_s.controller_do) _s.controller_do.setX(0);
                if(!FWDUVPlayer.hasHTMLHLS && source.toLowerCase().indexOf(".m3u8") != -1){
                    _s.videoType_str = FWDUVPlayer.HLS_JS;
                }else if(source.toLowerCase().indexOf(".mpd") != -1){
                    _s.videoType_str = FWDUVPlayer.DASH;
                }else{
                    _s.videoType_str = FWDUVPlayer.VIDEO;
                }
            }

            _s.videoSourcePath_str = source;
            _s.finalVideoPath_str = source;
            _s.posterPath_str = _s._d.playlist_ar[_s.id].posterSource;

            // Set is live.
            if(_s.controller_do) _s.controller_do.setIsLive(_s.isLive);
            
            // IMA
            var isIMA = _s._d.playlist_ar[_s.id].imaURL;
            if(_s.videoType_str != FWDUVPlayer.VIDEO || _s.errorImaSDK) isIMA = false;
            if(isIMA){
                _s.isIMA = isIMA;
                if(!_s._d.imaReady){
                    _s._d.startToLoadIMA();
                    return;
                }
                
                if(!_s.IMA){
                    FWDUVPIMA.setPrototype();
                    _s.IMA = new FWDUVPIMA(_s);
                }
            }
            if(!_s.IMA) _s.isIMA = false;
            
            // Casting
            if(_s.cc) _s.cc.checkButtonState();

            //DASH
            if(source.indexOf(".mpd") != -1 && !_s.isDASHLoaded_bl && !FWDUVPlayer.isDASHLoaded_bl){
                if(location.protocol.indexOf("file:") != -1){
                    _s.showSourceError("This browser doesn't allow playing MPEG DASH videos local, please test online.");
                    return;
                }

                var script = document.createElement('script');
                script.src = _s._d.dashPath_str;
                document.head.appendChild(script);
                script.onerror = function(){
                    _s.showSourceError("Error loading MPEG DASH library <font color='#FF0000'>" + _s._d.dashPath_str + "</font>.")
                    return;
                }

                script.onload = function () {
                    _s.isDASHLoaded_bl = true;
                    FWDUVPlayer.isDASHLoaded_bl = true;
                    _s.setupDASH();
                    _s.setSource(source, false, _s.is360);
                }

                if(_s.isMbl) _s.isThumbClick_bl = false;

                if(!_s._d.autoPlay_bl && !_s.isThumbClick_bl){
                    _s.setPosterSource(_s.posterPath_str);
                    if(_s.videoPoster_do) _s.videoPoster_do.show();
                    if(_s.lrgPlayBtn) _s.lrgPlayBtn.show();
                }
                return;
            }
            

            // HLS
            if(!FWDUVPlayer.hasHTMLHLS && source.indexOf(".m3u8") != -1 && !_s.isHLSJsLoaded_bl && !FWDUVPlayer.isHLSJsLoaded_bl){
                // if(location.protocol.indexOf("file:") != -1){
                //     _s.showSourceError("This browser doesn't allow playing HLS videos local, please test online.")
                //     return;
                // }
                
                var script = document.createElement('script');
                script.src = _s._d.hlsPath_str;
                document.head.appendChild(script);
                script.onerror = function(){3
                    _s.showSourceError("Error loading HLS library <font color='#FF0000'>" + _s._d.hlsPath_str + "</font>.")
                    return;
                }
                
                script.onload = function () {
                    _s.isHLSJsLoaded_bl = true;
                    FWDUVPlayer.isHLSJsLoaded_bl = true;
                    _s.setupHLS();
                    _s.setSource(source, false, _s.is360);
                }
                
                if(!_s._d.autoPlay_bl && !_s.isThumbClick_bl){
                    _s.setPosterSource(_s.posterPath_str);
                    if(_s.videoPoster_do) _s.videoPoster_do.show();
                    if(_s.lrgPlayBtn) _s.lrgPlayBtn.show();
                }
                return;
            }
            
            if(source.indexOf("youtube.") != -1 && !_s.ytb_do){
                setTimeout(function(){
                    
                    if(_s.showPreloader_bl){
                        _s.main_do.addChild(_s.preloader_do);   
                        if(_s.preloader_do){
                            _s.preloader_do.show(false);
                        }
                        if(_s.lrgPlayBtn) _s.lrgPlayBtn.hide();
                        
                        if(location.protocol.indexOf("file:") != -1 && FWDUVPUtils.isIE) _s.main_do.addChild(_s.info_do);
                    }
                }, 50);
                
                if(location.protocol.indexOf("file:") != -1 && FWDUVPUtils.isIE){
                    _s.showSourceError("This browser doesn't allow the Youtube API to run local, please test it online or in another browser like Firefox or Chrome.");
                    return;
                }   
                
                _s.setupYoutubeAPI();
                return;
            }
        
            if(source.indexOf("vimeo.") != -1 && !_s.vimeo_do && _s.videoType_str == FWDUVPlayer.VIMEO){
                    
                if(location.protocol.indexOf("file:") != -1){
                    _s.showSourceError("This browser doesn't allow playing Vimeo videos local, please test online.");
                    return;
                }
                
                if(_s.showPreloader_bl){
                    _s.main_do.addChild(_s.preloader_do);   
                    if(_s.preloader_do){
                        _s.preloader_do.show(false);
                    }
                }
                if(_s.lrgPlayBtn) _s.lrgPlayBtn.hide();
            
                _s.setupVimeoAPI();
                return;
            }
            
            
            if(_s.is360  && !_s.isThreeJsOrbigLoaded_bl && (_s.videoType_str == FWDUVPlayer.VIDEO && _s.videoType_str != FWDUVPlayer.HLS_JS)){
                    
                if(FWDUVPUtils.isLocal){
                    _s.showSourceError("This browser doesn't allow playing 360 videos local, please test online.");
                    return;
                }
                
                if(!FWDUVPUtils.hasWEBGL){
                    _s.showSourceError("Playing 360 videos in _s browser is not possible because it doesn't support WEBGL.");
                    return;
                }
                
                if(!_s.isThreeJsLoaded_bl && !FWDUVPlayer.hasThreeJsLoaded_bl){
                    var script = document.createElement('script');
                    script.src = _s._d.threeJsPath_str;
                    script.onerror = function(){
                        _s.showSourceError("Error loading 360 degree library <font color='#FF0000'>" + _s._d.threeJsPath_str + "</font>.");
                        return;
                    }
                    script.onload = function () {
                        _s.isThreeJsOrbigLoaded_bl = true;
                        
                            var script2 = document.createElement('script');
                            script2.src = _s._d.threeJsControlsPath_str;
                            script2.onerror = function(){
                                _s.showSourceError("Error loading three.js from <font color='#FF0000'>" + _s._d.threeJsControlsPath_str + "</font>.");
                                return;
                            }
                            script2.onload = function () {
                                FWDUVPlayer.hasThreeJsLoaded_bl = true;
                                _s.isThreeJsOrbitLoaded_bl = true;
                                if(_s.isThreeJsOrbigLoaded_bl && _s.isThreeJsOrbitLoaded_bl) _s.setSource(source, true, true);
                                clearTimeout(_s.load360ScriptsId_to);
                                if(_s.preloader_do) _s.preloader_do.hide();
                            };
                            document.head.appendChild(script2);
                            };

                    document.head.appendChild(script);
                    
                    
                    _s.load360ScriptsId_to = setTimeout(function(){
                        if(_s.showPreloader_bl){
                            if(_s.preloader_do){
                                _s.preloader_do.show(false);
                            }
                        }
                    },1000);
                    return;
                }
            }
            
            if(_s.is360){
                _s.dClk_do.getStyle().cursor = 'url(' + _s._d.handPath_str + '), default';
            }else{
                _s.dClk_do.getStyle().cursor = "auto";
            }

            _s.rotationY360DegreeVideo = _s._d.playlist_ar[_s.id].videoSource[_s._d.playlist_ar[_s.id].startAtVideo]["rotationY360DegreeVideo"];
            _s.startWhenPlayButtonClick360DegreeVideo = _s._d.playlist_ar[_s.id].videoSource[_s._d.playlist_ar[_s.id].startAtVideo]["startWhenPlayButtonClick360DegreeVideo"];


            if(_s._d.playlist_ar[_s.id] && _s._d.playlist_ar[_s.id].scrubAtTimeAtFirstPlay) _s.playAtTime_bl = true;
            if(_s.controller_do && _s.controller_do.rewindButton_do) _s.controller_do.rewindButton_do.disable();
        
            _s.popwSource = _s._d.playlist_ar[_s.id]._dAdvertisementOnPauseSource;
            if(_s._d.playlist_ar[_s.id] && _s._d.playlist_ar[_s.id]._dAdvertisementOnPauseSource){
                _s.showPopW_bl = true;
            }else{
                _s.showPopW_bl = false;
            }

            if(!source) source = _s._d.playlist_ar[_s.id].videoSource[_s._d.playlist_ar[_s.id].startAtVideo].source;

            if(source.indexOf("youtube.") != -1){
                var regExp = /^.*(youtu\.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/;
                source = source.match(regExp)[2];
            }
            
            if(_s.controller_do) _s.controller_do.enablePlayButton();
            _s.prevVideoSource_str = source;
            
            if(!source){
                _s.showSourceError("Video source is not defined!");
                return;
            }
        
            if(_s.playlist_do){
                _s.playlist_do.curId = _s.id;
                _s.playlist_do.checkThumbsState();
            }
            
            if(_s.controller_do && _s._d.playlist_ar[_s.id].subtitleSource && _s._d.playlist_ar[_s.id].subtitleSource.length > 1){
                _s.subsSource_ar = _s._d.playlist_ar[_s.id].subtitleSource;
                _s.subsStartAtSubtitle = Number(_s._d.playlist_ar[_s.id].startAtSubtitle);
                _s.controller_do.updateSubtitleButtons(_s.subsSource_ar, _s.subsStartAtSubtitle);
                _s.ccSS = Number(_s._d.playlist_ar[_s.id].subtitleSource.length - _s._d.playlist_ar[_s.id].startAtSubtitle);
            }
            _s.subtitle_do.stopToLoadSubtitle();
            
            if(_s.controller_do){
                _s.controller_do.updateHexColorForScrubber(_s.isAdd_bl);
                _s.controller_do.removeAtButton();
            } 
            
            _s.annotations_ar = _s._d.playlist_ar[_s.id].annotations_ar;
            _s.annotations_do.setupAnnotations(_s.annotations_ar);
            
            _s.startAtPlaybackIndex = _s._d.startAtPlaybackIndex;
            
            if(_s._d.playlist_ar[_s.id]["_dPlaybackRate"] == "0.25"){
                _s.startAtPlaybackIndex = 5;
            }else if(_s._d.playlist_ar[_s.id]["_dPlaybackRate"] == "0.5"){
                _s.startAtPlaybackIndex = 4;
            }else if(_s._d.playlist_ar[_s.id]["_dPlaybackRate"] == "1"){
                _s.startAtPlaybackIndex = 3;
            }else if(_s._d.playlist_ar[_s.id]["_dPlaybackRate"] == "1.25"){
                _s.startAtPlaybackIndex = 2;
            }else if(_s._d.playlist_ar[_s.id]["_dPlaybackRate"] == "1.5"){
                _s.startAtPlaybackIndex = 1;
            }else if(_s._d.playlist_ar[_s.id]["_dPlaybackRate"] == "2"){
                _s.startAtPlaybackIndex = 0;
            }
            
            _s.prevVideoSourcePath_str = _s.videoSourcePath_str;
            _s.resizeHandler(false, true);
            
            // Image & iframe
            if(_s.videoType_str == FWDUVPlayer.IMAGE || _s.videoType_str == FWDUVPlayer.IFRAME){
                _s.updateImageScreen(_s.videoSourcePath_str);
                if(_s.videoPoster_do) _s.videoPoster_do.setX(-5000);
                return;
            }else{
                if(_s.videoHolder_do.contains(_s.ifr_do)) _s.videoHolder_do.removeChild(_s.ifr_do);
                if(_s.videoHolder_do.contains(_s.imgH_do)) _s.videoHolder_do.removeChild(_s.imgH_do);
                if(_s.videoPoster_do) _s.videoPoster_do.setX(0);
            }
            
            if(_s.getVideoSource()) _s.dispatchEvent(FWDUVPlayer.UPDATE_VIDEO_SOURCE);
            

            //Vimeo
            if(_s.videoType_str == FWDUVPlayer.VIMEO){
                
                if(_s.ytb_do && _s.ytb_do.ytb ){
                    _s.ytb_do.showDisable();
                }
                if(_s.ytb_do) _s.ytb_do.setX(-5000);

                if(_s.videoScreen_do) _s.videoScreen_do.setX(-5000);
                if(_s.vimeo_do.x != 0) _s.vimeo_do.setX(0);
            
                if(_s.isAdd_bl){
                    _s.showClickScreen();
                }else{
                    _s.hideClickScreen();
                }
                
                if(_s.audioScreen_do) _s.audioScreen_do.setX(-5000);
                _s.audioScreen_do.setVisible(false);
                
                if(_s.videoScreen_do) _s.videoScreen_do.setVisible(false);
                if(_s.controller_do) _s.controller_do.removePlaybackRateButton();

                if(_s.controller_do){
                    _s.controller_do.hideQualityButtons(false);
                    _s.controller_do.removeYtbQualityButton();
                }
                
                 _s.videoPoster_do.hide(true);
                _s.setPosterSource(_s.posterPath_str);
                
                _s.vimeo_do.setSource(source);

                if(_s.getVideoSource()) _s.dispatchEvent(FWDUVPlayer.UPDATE_VIDEO_SOURCE);
                _s.resizeHandler();
                return;
            }
            
            //Youtube
            if(_s.videoType_str == FWDUVPlayer.YOUTUBE){
                
                if(_s.vimeo_do) _s.vimeo_do.setX(-5000);
                _s.videoScreen_do.setX(-5000);
                _s.videoScreen_do.setVisible(false);
                
                if(_s.audioScreen_do) _s.audioScreen_do.setX(-5000);
                _s.audioScreen_do.setVisible(false);
                                
                if(_s.ytb_do) _s.ytb_do.setX(0);

                if(_s.ytb_do && _s.ytb_do.ytb && !_s.is360){
                    _s.ytb_do.showDisable();
                }else{
                    _s.ytb_do.hideDisable();
                }
                
                _s.videoPoster_do.hide(true);
                _s.setPosterSource(_s.posterPath_str);

                if(_s.lrgPlayBtn && !_s._d.showAnnotationsPositionTool_bl){
                    if(_s.videoPoster_do) _s.videoPoster_do.show();
                    _s.lrgPlayBtn.show();
                }
                
                _s.isTempYoutubeAdd_bl = false;
                _s.ytb_do.setSource(source);

                if(_s.controller_do){
                    _s.controller_do.addYtbQualityButton();
                    if(_s.controller_do){
                        if(_s.videoType_str == FWDUVPlayer.VIMEO || _s.videoType_str == FWDUVPlayer.IMAGE || _s.videoType_str == FWDUVPlayer.IFRAME){
                            _s.controller_do.removePlaybackRateButton();
                        }else{
                            _s.controller_do.addPlaybackRateButton(_s.startAtPlaybackIndex);
                        }
                    }
                }

                if(_s.isAdd_bl){
                    _s.setPlaybackRate(1);
                }else{
                    _s.setPlaybackRate(_s._d.defaultPlaybackRate_ar[_s._d.startAtPlaybackIndex]);
                }

                if(_s.controller_do && _s._d.showPlaybackRateButton_bl){
                    _s.controller_do.updatePlaybackRateButtons(_s.startAtPlaybackIndex);
                }
                
                _s.resizeHandler(false, true);
                if(_s.getVideoSource()) _s.dispatchEvent(FWDUVPlayer.UPDATE_VIDEO_SOURCE);
                return;
            }
            
            _s.finalVideoPath_str = source;
            
            if(_s.videoType_str == FWDUVPlayer.MP3){
                
                if(_s.vimeo_do) _s.vimeo_do.setX(-5000);
                if(_s.ytb_do) _s.ytb_do.setX(-5000);
                if(_s.ytb_do && _s.ytb_do.ytb){
                    _s.ytb_do.showDisable();
                }
                
                if(_s.audioScreen_do) _s.audioScreen_do.setX(-5000);
                _s.audioScreen_do.setVisible(false);
                _s.videoScreen_do.setVisible(true);
                
                
                if(_s.controller_do && _s._d.playlist_ar[_s.id].videoSource.length > 1){
                    _s.controller_do.updatePreloaderBar(0);
                    if(_s.controller_do){
                        _s.controller_do.addYtbQualityButton();
                    }
                    _s.controller_do.updateQuality(_s._d.playlist_ar[_s.id].videoLabels_ar, _s._d.playlist_ar[_s.id].videoLabels_ar[_s._d.playlist_ar[_s.id].videoLabels_ar.length - 1 - _s._d.playlist_ar[_s.id].startAtVideo]);
                }else if(_s.controller_do){
                    _s.controller_do.removeYtbQualityButton();
                }
                
                if(_s.controller_do){
                    if(_s.videoType_str == FWDUVPlayer.VIMEO || _s.videoType_str == FWDUVPlayer.IMAGE || _s.videoType_str == FWDUVPlayer.IMAGE){
                        _s.controller_do.removePlaybackRateButton();
                    }else{
                        _s.controller_do.addPlaybackRateButton(_s.startAtPlaybackIndex);
                    }
                }

                _s._d.autoPlay_bl = false;
                _s.removeAPT();
                
                _s.audioScreen_do.setX(0);
                _s.audioScreen_do.setVisible(true);
                if(!_s.isAdd_bl && window['FWDUVPCC']) FWDUVPCC.enableButton();
                _s.videoPoster_do.hide(true);
                _s.setPosterSource(_s.posterPath_str);
                _s.audioScreen_do.setSource(source);

                if(_s.isAdd_bl && !_s.isMbl){
                    _s.play();
                }else if(_s.isThumbClick_bl){
                    if(_s.displayType != FWDUVPlayer.LIGHTBOX  || _s.lightBox_do.isShowed_bl){
                        _s.play();
                    } 
                }else{
                    if(_s.videoPoster_do) _s.videoPoster_do.show();
                    if(_s.lrgPlayBtn) _s.lrgPlayBtn.show();
                }
            }
            
            if(FWDUVPlayer.hasHTML5Video 
               && _s.videoType_str == FWDUVPlayer.VIDEO
               || _s.videoType_str == FWDUVPlayer.HLS_JS
               || _s.videoType_str == FWDUVPlayer.DASH){
                
                if(_s.vimeo_do) _s.vimeo_do.setX(-5000);
                if(_s.ytb_do) _s.ytb_do.setX(-5000);
                if(_s.ytb_do && _s.ytb_do.ytb){
                    _s.ytb_do.showDisable();
                }
                
                if(_s.audioScreen_do) _s.audioScreen_do.setX(-5000);
                _s.audioScreen_do.setVisible(false);
                
                _s.videoScreen_do.setVisible(true);
                
                if(_s.controller_do && _s._d.playlist_ar[_s.id].videoSource.length > 1){
                    _s.controller_do.updatePreloaderBar(0);
                    if(_s.controller_do){
                        _s.controller_do.addYtbQualityButton();
                    }
                
                    _s.controller_do.updateQuality(_s._d.playlist_ar[_s.id].videoLabels_ar, _s._d.playlist_ar[_s.id].videoLabels_ar[_s._d.playlist_ar[_s.id].videoLabels_ar.length - 1 - _s._d.playlist_ar[_s.id].startAtVideo]);
                }else if(_s.controller_do){
                    _s.controller_do.removeYtbQualityButton();
                }
                
                if(_s.controller_do){
                    if(_s.controller_do){
                        if(_s.videoType_str == FWDUVPlayer.VIMEO || _s.videoType_str == FWDUVPlayer.IMAGE || _s.videoType_str == FWDUVPlayer.IFRAME){
                            _s.controller_do.removePlaybackRateButton();
                        }else{
                            _s.controller_do.addPlaybackRateButton(_s.startAtPlaybackIndex);
                        }
                    }
                }
                
                if(_s.videoType_str == FWDUVPlayer.DASH){
                    _s.setPosterSource(_s.posterPath_str);
                    if(_s._d.autoPlay_bl || _s.isThumbClick_bl || (!_s.isMbl && _s.isAdd_bl && !_s.loadAddFirstTime_bl)){
                        _s.videoPoster_do.hide(true);
                    } 
                    _s.videoScreen_do.setSource(source);
                    _s.setupDASH();

                    _s.dashJS.initialize(_s.videoScreen_do.video_el, _s.videoSourcePath_str, false);
                    _s.dashJS.attachSource(_s.videoSourcePath_str);

                    _s.dashJS.on(dashjs.MediaPlayer.events.MANIFEST_LOADED, function(e){
                        _s.isDASHManifestReady_bl = true;
                        
                        if(!_s.isMbl && _s.isAdd_bl && !_s.loadAddFirstTime_bl){
                            setTimeout(_s.play, 100);
                        }

                        if(_s._d.autoPlay_bl || _s.isThumbClick_bl){
                            
                            if(_s.isThumbClick_bl){
                                if(_s.videoType_str == FWDUVPlayer.DASH){
                                    setTimeout(_s.play, 100);
                                }
                            }

                            if(_s._d.autoPlay_bl){
                                if(_s.controller_do) _s.controller_do.updateVolume(0);
                                if(_s.displayType != FWDUVPlayer.LIGHTBOX  || _s.lightBox_do.isShowed_bl){
                                    if(_s.videoType_str == FWDUVPlayer.DASH){
                                        setTimeout(_s.play, 100);
                                    }
                                } 
                            }
                        }else{
                            _s.videoPoster_do.show(true);
                            _s.lrgPlayBtn.show();
                        }

                        if(_s.isAdd_bl){
                            _s.setPlaybackRate(1);
                        }else{
                            _s.setPlaybackRate(_s._d.defaultPlaybackRate_ar[_s.startAtPlaybackIndex]);
                        }
                        if(_s.controller_do && _s._d.showPlaybackRateButton_bl){
                            _s.controller_do.updatePlaybackRateButtons(_s.startAtPlaybackIndex);
                        }
                    });
                    
                }else if(_s.videoType_str == FWDUVPlayer.HLS_JS){
                    _s.setPosterSource(_s.posterPath_str);
                    if(_s._d.autoPlay_bl || _s.isThumbClick_bl || (!_s.isMbl && _s.isAdd_bl && !_s.loadAddFirstTime_bl)){
                        _s.videoPoster_do.hide(true);
                    } 
                    _s.videoScreen_do.setSource(source);
                    _s.videoScreen_do.initVideo();
                    _s.setupHLS();
                    _s.hlsJS.loadSource(_s.videoSourcePath_str);
                    _s.hlsJS.attachMedia(_s.videoScreen_do.video_el);
                    
                    _s.hlsJS.on(Hls.Events.MANIFEST_PARSED,function(e){
                        if(_s.videoType_str == FWDUVPlayer.HLS_JS){
                            
                            _s.isHLSManifestReady_bl = true;
                            

                            if(_s.controller_do){
                                _s.controller_do.addYtbQualityButton();
                            }

                            if(_s.isAdd_bl && !_s.loadAddFirstTime_bl){
                                _s.play();
                            }
                            
                            if(_s._d.autoPlay_bl || _s.isThumbClick_bl){
                
                                if( _s.isThumbClick_bl) _s.play();

                                if(_s._d.autoPlay_bl){
                                    if(_s.controller_do) _s.controller_do.updateVolume(0);
                                    if(_s.displayType != FWDUVPlayer.LIGHTBOX  || _s.lightBox_do.isShowed_bl){
                                        _s.play();
                                    } 
                                }
                            }
                            
                            if(_s.isAdd_bl){
                                _s.setPlaybackRate(1);
                            }else{
                                _s.setPlaybackRate(_s._d.defaultPlaybackRate_ar[_s.startAtPlaybackIndex]);
                            }
                            if(_s.controller_do && _s._d.showPlaybackRateButton_bl){
                                _s.controller_do.updatePlaybackRateButtons(_s.startAtPlaybackIndex);
                            }

                            _s.parseLevels();
                        }
                    });
                }else{
                    if(!_s.isAdd_bl && window['FWDUVPCC']) FWDUVPCC.enableButton();
                    _s.setPosterSource(_s.posterPath_str);
                    _s.videoPoster_do.hide(true);
                    _s.videoScreen_do.setSource(source);

                    if(_s.isAdd_bl && !_s.loadAddFirstTime_bl){
                        _s.play();
                    }
                    
                    if(_s._d.autoPlay_bl || _s.isThumbClick_bl){

                        if(_s.isThumbClick_bl ) _s.play();

                        if(_s._d.autoPlay_bl){
                            if(_s.controller_do) _s.controller_do.updateVolume(0);
                            if(_s.displayType != FWDUVPlayer.LIGHTBOX  || _s.lightBox_do.isShowed_bl){
                                _s.play();
                            } 
                        }

                        if(_s.isCasting){
                            _s.videoPoster_do.show();
                        }
                    }else{
                        _s.videoPoster_do.show(true);
                        _s.lrgPlayBtn.show();
                    }
                    
                    if(_s.isAdd_bl){
                        _s.setPlaybackRate(1);
                    }else{
                        _s.setPlaybackRate(_s._d.defaultPlaybackRate_ar[_s.startAtPlaybackIndex]);
                    }
                    if(_s.controller_do && _s._d.showPlaybackRateButton_bl){
                        _s.controller_do.updatePlaybackRateButtons(_s.startAtPlaybackIndex);
                    }
                    
                }
                
                if(_s.isIMA) _s.IMA.setSource(_s.isIMA);
            }
            _s.resizeHandler();
        };
        
        // DASH
        _s.setupDASH = function(){
            if(_s.dashJS) return;
            _s.isDASHLoaded_bl = true;
            _s.dashJS = dashjs.MediaPlayer().create();

            _s.dashJS.on(dashjs.MediaPlayer.events.ERROR, function(e){
                console.log(e);
                _s.main_do.addChild(_s.info_do);
                _s.info_do.showText(e.error.message);
            });
        }

        _s.destroyDASH = function(o){
            if(_s.dashJS){
                try{    
                    _s.dashJS.reset();
                }catch(e){}
             _s.dashJS = null;
            }
        }

        // HLS
        _s.destroyHLS = function(){
            if(_s.hlsJS){
                _s.hlsJS.destroy();
                _s.hlsJS = null;
            }
        }

        _s.setupHLS = function(){
            
            if(_s.hlsJS || !window['Hls']) return;
            _s.isHLSJsLoaded_bl = true;
            _s.hlsJS = new Hls();
            
            FWDUVPRegisterHLSError(_s);

            _s.hlsJS.on(Hls.Events.MANIFEST_LOADED,function(event, data){
                _s.setAudioTracks(_s.hlsJS.audioTracks);
            });

            _s.hlsJS.on(Hls.Events.LEVEL_UPDATED,function(event, data){
                _s.curHlsLevel = data.level;
                _s.updateHlsControllerLevels();
            });

            _s.hlsJS.on(Hls.Events.LEVEL_SWITCHING,function(event, data){
                _s.curHlsLevel = data.level;
                _s.updateHlsControllerLevels();
            });
        }

        _s.setAudioTracks = function(audioTracks_ar){
            if(audioTracks_ar && audioTracks_ar.length > 1){
                _s.controller_do.addAtButton();

                _s.audioTracks_ar = [];
                audioTracks_ar.forEach((o,i) =>{
                    _s.audioTracks_ar[i] = {'label':o['name'] || o['label']};
                })
                _s.audioTracks_ar.reverse();
                _s.controller_do.updateATBButtons(_s.audioTracks_ar, 0);
            }
        }

        _s.updateHlsControllerLevels = function(){
            if(_s.controller_do && _s.hlsLevels_ar){
                _s.curHlsLevel = Math.abs(_s.curHlsLevel - _s.hlsLevels_ar.length + 1)
                _s.controller_do.disableQualityButtons('', _s.curHlsLevel);
            }
        }

        _s.parseLevels = function(){
            var hlsLevels = _s.hlsJS.levels;
            _s.hlsLevels_ar = [];

            setTimeout(function(){
                
                hlsLevels.forEach(function(el){
                    var level = '';
                    var levelW = el.width;
                    var levelH = el.height;
                    if(levelW == 320){
                        level = 'tiny';
                    }else if(levelW == 480){
                        level = 'small';
                    }else if(levelW == 640){
                        level = 'medium';
                    }else if(levelW == 960){
                        level = 'large';
                    }else if(levelW == 1280){
                        level = 'hd720';
                    }else if(levelW == 1920){
                        level = 'hd1080';
                    }else if(levelW == 2560){
                        level = 'hd1440p';
                    }else if(levelW == 3840){
                        level = 'hd2160';
                    }else if(levelW == 3840){
                        level = 'hd2160';
                    }else if(levelW == 5120){
                        level = 'hd2880';
                    }else if(levelW == 7680){
                        level = 'hd4320';
                    }else{
                        level = levelW + 'x' + levelH;
                    }

                    _s.hlsLevels_ar.push(level);                    
                });
                
                if(!_s.hlsLevels_ar) return;
                
                _s.hlsLevels_ar.reverse();
            
                if(_s.controller_do){
                    _s.curHlsLevel = Math.abs(_s.hlsLevels_ar.length - _s.hlsLevels_ar.length);
                    _s.curHlsLevel = _s.curHlsLevel;
                    _s.controller_do.updateQuality(_s.hlsLevels_ar, _s.curHlsLevel, _s.curHlsLevel);
                }
            }, 500);
        
        }

    
        //#############################################//
        /* go fullscreen / normal screen */
        //#############################################//
        _s.goFullScreen = function(){
            if(!_s.isAPIReady_bl) return;
            _s.wasMin = _s.isMin;
            _s.isFullScreen_bl = true;
            _s.removeMinOnScroll();
            
            if(document.addEventListener){
                document.addEventListener("fullscreenchange", _s.onFullScreenChange);
                document.addEventListener("mozfullscreenchange", _s.onFullScreenChange);
                document.addEventListener("webkitfullscreenchange", _s.onFullScreenChange);
                document.addEventListener("MSFullscreenChange", _s.onFullScreenChange);
            }
            
            if(FWDUVPUtils.isSafari && FWDUVPUtils.isWin){
                
            }else{
                if(document.documentElement.requestFullScreen) {
                    _s.main_do.screen.requestFullScreen();
                }else if(document.documentElement.mozRequestFullScreen){ 
                    _s.main_do.screen.mozRequestFullScreen();
                }else if(document.documentElement.webkitRequestFullScreen){
                    _s.main_do.screen.webkitRequestFullScreen();
                }else if(document.documentElement.msRequestFullscreen){
                    _s.main_do.screen.msRequestFullscreen();
                }
            }
            
            _s.callVastEvent("playerExpand");
            _s.stopVisualization();
            _s.disableClick();
            
            if(!_s.isEmbedded_bl){
                _s.main_do.getStyle().position = "fixed";
                document.documentElement.style.overflow = "hidden";
                _s.main_do.getStyle().zIndex = 2147483641;
            }
            
            if(_s.controller_do){
                _s.controller_do.showNormalScreenButton();
                _s.controller_do.setNormalStateToFullScreenButton();
            }
            if(_s.customContextMenu_do) _s.customContextMenu_do.updateFullScreenButton(1);
            var scrollOffsets = FWDUVPUtils.getScrollOffsets();
            _s.lastX = scrollOffsets.x;
            _s.lastY = scrollOffsets.y;
            window.scrollTo(0,0);

            if(_s.isMbl) window.addEventListener("touchmove", _s.disableFullScreenOnMobileHandler);
            _s.dispatchEvent(FWDUVPlayer.GO_FULLSCREEN);
            _s.resizeHandler();
        };
        
        _s.disableFullScreenOnMobileHandler = function(e){
            if(e.preventDefault) e.preventDefault();
        };
        
        _s.goNormalScreen = function(){     
            if(!_s.isAPIReady_bl) return;
            
            if (document.cancelFullScreen) {  
                document.cancelFullScreen();  
            }else if (document.mozCancelFullScreen) {  
                document.mozCancelFullScreen();  
            }else if (document.webkitCancelFullScreen) {  
                document.webkitCancelFullScreen();  
            }else if (document.msExitFullscreen) {  
                document.msExitFullscreen();  
            }

            _s.disableClick();
            _s.addMainDoToTheOriginalParent();
            _s.isFullScreen_bl = false;
        };
        
        _s.addMainDoToTheOriginalParent = function(){
            if(!_s.isFullScreen_bl) return;
            
            if(document.removeEventListener){
                document.removeEventListener("fullscreenchange", _s.onFullScreenChange);
                document.removeEventListener("mozfullscreenchange", _s.onFullScreenChange);
                document.removeEventListener("webkitfullscreenchange", _s.onFullScreenChange);
                document.removeEventListener("MSFullscreenChange", _s.onFullScreenChange);
            }
            
            _s.callVastEvent("playerCollapse");
                
            if(_s.controller_do){
                _s.controller_do.setNormalStateToFullScreenButton();
            }

            if(_s.categories_do && _s.categories_do.isShowed_bl){
                try{
                    _s.main_do.removeChild(_s.categories_do);
                }catch(e){}
                document.documentElement.appendChild(_s.categories_do.screen);
            }
        
            if(!_s.isEmbedded_bl){
                if(_s.displayType == FWDUVPlayer.RESPONSIVE
                   || _s.displayType == FWDUVPlayer.AFTER_PARENT
                   || _s.displayType == FWDUVPlayer.LIGHTBOX
                    || _s.displayType == FWDUVPlayer.STICKY
                 ){
                    
                    document.documentElement.style.overflow = "visible";
                    if(_s.isMin){
                        _s.main_do.getStyle().position = 'fixed';
                        _s.main_do.getStyle().zIndex = 9999999999999;
                    }else{
                        _s.main_do.getStyle().position = "relative";
                        _s.main_do.getStyle().zIndex = 0;
                    }
                
                }else{
                    _s.main_do.getStyle().position = "absolute";
                    _s.main_do.getStyle().zIndex = 9999999999998;
                }
            }
            
            if(_s.displayType != FWDUVPlayer.FULL_SCREEN) _s.controller_do.enablePlaylistButton();
            
            if(_s.customContextMenu_do) _s.customContextMenu_do.updateFullScreenButton(0);
            _s.controller_do.showFullScreenButton();
            window.scrollTo(_s.lastX, _s.lastY);

            _s.showCursor();
            _s.resizeHandler();

            setTimeout(function(){
                _s.addMinOnScroll();
                _s.resizeHandler();
            }, 500);
            
            window.scrollTo(_s.lastX, _s.lastY);
            if(!FWDUVPUtils.isIE){
                setTimeout(function(){
                    window.scrollTo(_s.lastX, _s.lastY);
                }, 150);
            }
            
            if(_s.isMbl) window.removeEventListener("touchmove", _s.disableFullScreenOnMobileHandler);
            _s.dispatchEvent(FWDUVPlayer.GO_NORMALSCREEN);
        };
        
        _s.onFullScreenChange = function(e){
            if(!(document.fullScreen || document.msFullscreenElement  || document.mozFullScreen || document.webkitIsFullScreen || document.msieFullScreen)){
                _s.controller_do.showNormalScreenButton();
                _s.addMainDoToTheOriginalParent();
                _s.isFullScreen_bl = false;
            }
        };
        
        _s.loadPlaylist = function(id){
            if(!_s.isAPIReady_bl) return;
            if(_s._d.prevId == id) return;
            
            if(_s._d.playlist_ar && _s._d.playlist_ar[_s.id]){
                _s.videoNameGa = _s._d.playlist_ar[_s.id]["gaStr"]
                _s.videoCat = _s._d.cats_ar[_s.catId]["playlistName"];
            }
            
            _s.catId = id;
            _s.id = 0;
            
            if(_s.catId < 0){
                _s.catId = 0;
            }else if(_s.catId > _s._d.totalPlaylists - 1){
                _s.catId = _s._d.totalPlaylists - 1;
            };
            
            if(_s.useDeepLinking_bl){
                FWDUVPDL.setValue("?playlistId=" + _s.catId + "&videoId=" + _s.id);
            }else{
                _s.loadInternalPlaylist();
            }
        };
        
        _s.playNext = function(){   
            if(!_s.isAPIReady_bl || !_s.isPlaylistLoaded_bl) return;
            
            if(_s._d.playlist_ar){
                _s.videoNameGa = _s._d.playlist_ar[_s.id]["gaStr"]
                _s.videoCat = _s._d.cats_ar[_s.catId]["playlistName"];
            }
        
            _s.id ++;
            _s.executePlayNextPrevOrShuffle();
        };
        
        _s.playPrev = function(){
            if(!_s.isAPIReady_bl || !_s.isPlaylistLoaded_bl) return;
            
            if(_s._d.playlist_ar){
                _s.videoNameGa = _s._d.playlist_ar[_s.id]["gaStr"]
                _s.videoCat = _s._d.cats_ar[_s.catId]["playlistName"];
            }
            
            _s.id --;   
            _s.executePlayNextPrevOrShuffle();
        };
        
        _s.playShuffle = function(){
            if(!_s.isAPIReady_bl || !_s.isPlaylistLoaded_bl) return;
            
            if(_s._d.playlist_ar){
                _s.videoNameGa = _s._d.playlist_ar[_s.id]["gaStr"]
                _s.videoCat = _s._d.cats_ar[_s.catId]["playlistName"];
            }
            
            var tempId = parseInt(Math.random() * _s.totaadsIdeos);
            while(tempId == _s.id) tempId = parseInt(Math.random() * _s.totaadsIdeos);
            
            _s.id = tempId; 
            _s.executePlayNextPrevOrShuffle();
        };
        
        _s.executePlayNextPrevOrShuffle = function(){
            _s._d.isVastXMLParsed_bl = false;
            _s.totalDuration = 0;
            if(_s.id < 0){
                _s.id = _s.totaadsIdeos - 1;
            }else if(_s.id > _s.totaadsIdeos - 1){
                _s.id = 0;
            }
            if(_s.useDeepLinking_bl){
                FWDUVPDL.setValue("?playlistId=" + _s.catId + "&videoId=" + _s.id);
            }else{
                _s.isThumbClick_bl = true;
                _s.updateAds(0, true);
            }
        }
        
        _s.playVideo = function(videoId){   
            if(!_s.isAPIReady_bl || !_s.isPlaylistLoaded_bl) return;
            
            if(_s._d.playlist_ar){
                _s.videoNameGa = _s._d.playlist_ar[_s.id]["gaStr"]
                _s.videoCat = _s._d.cats_ar[_s.catId]["playlistName"];
            }
            
            _s.id = videoId;
            
            if(_s.id < 0){
                _s.id = _s.totaadsIdeos - 1;
            }else if(_s.id > _s.totaadsIdeos - 1){
                _s.id = 0;
            }
            
            if(_s.useDeepLinking_bl){
                FWDUVPDL.setValue("?playlistId=" + _s.catId + "&videoId=" + _s.id);
            }else{
                _s.updateAds(0, true);
                if(_s.isMbl && _s.videoType_str == FWDUVPlayer.VIDEO) _s.play();
                if(!_s.isMbl){
                    _s.play();
                }
            }
        };
        
        _s.setVideoSource =  function(source, is360, isLive){
            _s.isAdd_bl = false;
            var s360_str = "no";
            if(is360) s360_str = "yes";
            _s.isLive = isLive;
            _s.setSource(source, false, is360);
        };
    
        
        _s.downloadVideo = function(pId){

            var check = _s.checkPassWindow();
            if(!check) return;

            _s.hasPassedPassowrd_bl = true;
            
            if(pId ==  undefined) pId = _s.id;
            
            var sourceName;
            var source = _s._d.playlist_ar[pId].videoSource[_s._d.playlist_ar[_s.id].startAtVideo]["source"];
            if(String(source.indexOf("encrypt:")) != -1){
                source = atob(source.substr(8));
            }
            if(source.indexOf("/") != -1){
                sourceName = source.substr(source.lastIndexOf("/") + 1);
            }else{
                sourceName = source;
            }
            
            if(_s.gtag){
                if(_s._d.playlist_ar){
                    _s.videoNameGa = _s._d.playlist_ar[_s.id]["gaStr"]
                }
                
                var params = {
                    'video_name': _s.videoNameGa,
                    'video_url': source,
                }
                _s.gtag('event', 'download', params);
            }
    
            _s._d.downloadVideo(source, sourceName);
        };
        
        _s.share = function(){
            if(!_s.isAPIReady_bl) return;
            _s.controllerShareHandler();
        };  
        
        _s.getVideoSource = function(){
            if(!_s.isAPIReady_bl) return;
            return _s.finalVideoPath_str;
        };
        
        _s.getPosterSource = function(){
            if(!_s.isAPIReady_bl) return;
            return _s.posterPath_str;
        };
        
        _s.getPlaylistId = function(){
            return _s.catId;
        };
        
        _s.getVideoId = function(){
            return _s.id;
        };
        
        _s.getCurrentTime = function(format){
            if(!format) format = 'text';
            var tm;
            if(format == 'milliseconds'){
                if(!_s.curTimeInmilliseconds){
                    tm = 0;
                }else{
                    tm = _s.curTimeInmilliseconds;
                }
                if(_s.isCasting) tm = _s.cc.getCurrentTime();
            }else if(format == 'seconds'){
                if(!_s.curTimeInSecond){
                    tm = 0;
                }else{
                    tm = _s.curTimeInSecond;
                }
                if(_s.isCasting) tm = _s.cc.getCurrentTime();
            }else{
                if(!_s.curTime){
                    tm = "00:00";
                }else{
                    tm = _s.curTime;
                }
                if(_s.isCasting) tm = FWDUVPUtils.formatTime(_s.cc.getCurrentTime());
            }
            return tm;
        };
        
        _s.getTotalTime = function(format){
            if(!format) format = 'text';
            var tm;
            if(format == 'milliseconds'){
                if(!_s.totalTimeInMilliseconds){
                    tm = 0;
                }else{
                    tm = _s.totalTimeInMilliseconds;
                }
                if(_s.isCasting) tm = _s.cc.getCurrentTime();
            }else if(format == 'seconds'){
                tm = Math.round(_s.totalTimeInSeconds);
                if(_s.isCasting) tm = _s.cc.getDuration();
            }else{
                if(!_s.totalTime){
                    tm = "00:00";
                }else{
                    tm = _s.totalTime;
                }
                if(_s.isCasting) tm = FWDUVPUtils.formatTime(_s.cc.getDuration());
            }
            return tm;
        };
    
        
        _s.setPlaybackRate = function(rate){
            if(!_s.isAPIReady_bl) return;
            if( _s.videoScreen_do && _s.videoType_str == FWDUVPlayer.VIDEO
             || _s.videoType_str == FWDUVPlayer.HLS_JS
             || _s.videoType_str == FWDUVPlayer.DASH){
                _s.videoScreen_do.setPlaybackRate(rate);
            }else if(_s.videoType_str == FWDUVPlayer.YOUTUBE){
                _s.ytb_do.setPlaybackRate(rate);
            }else if(_s.videoType_str == FWDUVPlayer.MP3){
                _s.audioScreen_do.setPlaybackRate(rate);
            }
        }
        
        _s.showLightbox = function(){
            if(_s.lightBox_do) _s.lightBox_do.show();
        }
        
        _s.fillEntireVideoScreen = function(param){
            _s.fillEntireVideoScreen_bl = param;
            _s.resizeHandler();
        };

        
        //###########################################//
        /* Hide / show cursor */
        //###########################################//
        _s.hideCursor = function(){
            document.documentElement.style.cursor = "none";
            document.getElementsByTagName("body")[0].style.cursor = "none";
            if(!_s.isAdd_bl) _s.dClk_do.getStyle().cursor = "none";
        };
        
        _s.showCursor = function(){
            document.documentElement.style.cursor = "auto";
            document.getElementsByTagName("body")[0].style.cursor = "auto";
            if(_s.isAdd_bl){
                _s.dClk_do.setButtonMode(true);
            }else{
                if(_s.is360){
                    _s.dClk_do.getStyle().cursor = 'url(' + _s._d.handPath_str + '), default';
                }else{
                    _s.dClk_do.getStyle().cursor = "auto";
                }
            }
        };
        
        _s.showPlayer = function(){
            if(!_s.isAPIReady_bl) return;
            _s.isShowed_bl = true;
            _s.opener_do.showCloseButton();
            _s.setStageContainerFinalHeightAndPosition(_s.animate_bl);
            if(_s.isMin){
                _s.isMinShowed = true;
                _s.positionOnMin(true);
            }
        };
        
        _s.hidePlayer = function(){
            if(!_s.isAPIReady_bl) return;
            _s.isShowed_bl = false;
            _s.opener_do.showOpenButton();
            _s.setStageContainerFinalHeightAndPosition(_s.animate_bl);
            if(_s.isMin){
                _s.isMinShowed = false;
                _s.positionOnMin(true);
            }
        };
        
        _s.getStartTimeStamp = function(str){

            var ts  = window.location.href;
            ts = ts.substr(ts.indexOf(str + "=") + 2);

            if(ts.indexOf("&") != -1){
                ts = ts.substr(0, ts.indexOf("&"));
            }

            if(ts.indexOf("s&") != -1){
                ts = ts.substr(0, ts.indexOf("s&") + 1);
            }

            if(ts.length > 10) return;
        
            var pattern = /\d+h/g;
            var hours = ts.match(pattern);
            try{ hours = ts.match(pattern)[0] }catch(e){}
            if(hours){
                hours = hours.substr(0, hours.length -1);
                if(hours.length == 1 && parseInt(hours) < 10){
                    hours = "0" + hours;
                }
                if(parseInt(hours) > 59) hours = 59;
            }
            hours = hours ? hours : "00";
            
            var pattern = /h\d+m/g;
            var minutes = ts.match(pattern);
            try{ minutes = ts.match(pattern)[0].substr(1) }catch(e){}
            
            if(minutes){
                minutes = minutes.substr(0, minutes.length -1);
                if(minutes.length == 1 && parseInt(minutes) < 10){
                    minutes = "0" + minutes;
                }
                if(parseInt(minutes) > 59) minutes = 59;
            }
            minutes = minutes ? minutes : "00";
            
            var pattern = /\d+s/g;
            var seconds = ts.match(pattern);
            try{ seconds = ts.match(pattern)[0] }catch(e){}
            if(seconds){
                seconds = seconds.substr(0, seconds.length -1);
                if(seconds.length == 1 && parseInt(seconds) < 10){
                    seconds = "0" + seconds;
                }
                if(parseInt(seconds) > 59) seconds = 59;
            }
            seconds = seconds ? seconds : "00";
        
            return hours + ":" + minutes + ":" + seconds;
        }
        
        _s.setVastSource =  function(source){
            if(!_s.isAPIReady_bl) return;
            _s.isAdd_bl = false;
            _s.adDone_bl = false;
            _s.stop();
            _s.prevDuration = -1;
            _s._d.vastXML = source;
            _s._d.isVastXMLParsed_bl = false;
            _s._d.vast.id = -1;
            _s.updateAds();
        }


        //###########################################//
        /* event dispatcher */
        //###########################################//
        _s.addListener = function (type, listener){
            if(type == undefined) throw Error("type is required.");
            if(typeof type === "object") throw Error("type must be of type String.");
            if(typeof listener != "function") throw Error("listener must be of type Function.");
            
            var event = {};
            event.type = type;
            event.listener = listener;
            event.target = _s;
            _s.listeners.events_ar.push(event);
        };
        
        _s.dispatchEvent = function(type, props){
            if(_s.listeners == null) return;
            if(type == undefined) throw Error("type is required.");
            if(typeof type === "object") throw Error("type must be of type String.");
            
            for (var i=0, len=_s.listeners.events_ar.length; i < len; i++){
                if(_s.listeners.events_ar[i].target === _s && _s.listeners.events_ar[i].type === type){     
                    if(props){
                        for(var prop in props){
                            _s.listeners.events_ar[i][prop] = props[prop];
                        }
                    }
                    _s.listeners.events_ar[i].listener.call(_s, _s.listeners.events_ar[i]);
                }
            }
        };
        
       _s.removeListener = function(type, listener){
            
            if(type == undefined) throw Error("type is required.");
            if(typeof type === "object") throw Error("type must be of type String.");
            if(typeof listener != "function") throw Error("listener must be of type Function." + type);
            
            for (var i=0, len=_s.listeners.events_ar.length; i < len; i++){
                if(_s.listeners.events_ar[i].target === _s 
                        && _s.listeners.events_ar[i].type === type
                        && _s.listeners.events_ar[i].listener ===  listener
                ){
                    _s.listeners.events_ar.splice(i,1);
                    break;
                }
            }  
        };
        
        //#############################################//
        /* Tracking vast events */
        //#############################################//
        _s.callVastEvent = function(eventName){
            
            if(!_s.TrackingEvents) return;
            var URI;
            
            for(var i=0; i<_s.TrackingEvents.length; i++){
                if(eventName == _s.TrackingEvents[i]["event"]){
                    URI = _s.TrackingEvents[i]["URI"];
                }
            }
        
            if(!URI) return;
            _s.executeVastEvent(URI);
        }
        
        _s.executeVastEvent = function(URI){
            if(!URI) return;
            var img = new Image();
            img.src = URI;
        }
        
        //#############################################//
        /* clean main events */
        //#############################################//
        _s.cleanMainEvents = function(){
            if(window.removeEventListener){
                window.removeEventListener("resize", _s.onResizeHandler);
            }else if(window.detachEvent){
                window.detachEvent("onresize", _s.onResizeHandler);
            }
        
            clearTimeout(_s.resizeHandlerId_to);
            clearTimeout(_s.resizeHandler2Id_to);
            clearTimeout(_s.hidePreloaderId_to);
            clearTimeout(_s.orientationChangeId_to);
        };
    
        
        var args = FWDUVPUtils.getUrlArgs(window.location.search);
        var embedTest = args.UVPInstanceName;
        var instanceName = args.UVPInstanceName;
        
        if(embedTest){
            _s.isEmbedded_bl = props.instanceName == instanceName;
        }
    
        if(_s.isEmbedded_bl){
            var ws = FWDUVPUtils.getViewportSize();
            
            _s.embeddedPlaylistId = parseInt(args.UVPPlaylistId);
            _s.embeddedVideoId = parseInt(args.UVPVideoId);
            
            var dumy_do = new FWDUVPDisplayObject("div");
            dumy_do.setBkColor(props.backgroundColor);
            dumy_do.setWidth(ws.w);
            dumy_do.setHeight(ws.h);
            
            document.documentElement.style.overflow = "hidden";
            document.getElementsByTagName("body")[0].style.overflow = "hidden";
            
            if(FWDUVPUtils.isIEAndLessThen9){
                document.getElementsByTagName("body")[0].appendChild(dumy_do.screen);
            }else{
                document.documentElement.appendChild(dumy_do.screen);
            }
        }
        _s.init();
    };

    
    /* set prototype */
    FWDUVPlayer.setPrototype =  function(){
        FWDUVPlayer.prototype = new FWDUVPEventDispatcher();
    };
        
    
    FWDUVPlayer.stopAllVideos = function(pVideo){
        var tt = FWDUVPlayer.instaces_ar.length;
        var video;
        for(var i=0; i<tt; i++){
            video = FWDUVPlayer.instaces_ar[i];
            if(video != pVideo){
                video.stop();
            }
        };
    };
    
    FWDUVPlayer.pauseAllVideos = function(pVideo){
        var tt = FWDUVPlayer.instaces_ar.length;
        var video;
        for(var i=0; i<tt; i++){
            video = FWDUVPlayer.instaces_ar[i];
            if(video != pVideo){
                video.pause();
            }
        };
    };
    
    FWDUVPlayer.hasHTML5Video = true;
    FWDUVPlayer.hasCanvas = (function(){
        return Boolean(document.createElement("canvas"));
    })();
    
    FWDUVPlayer.instaces_ar = [];
    
    FWDUVPlayer.hasHTMLHLS = (function(){
        return navigator.userAgent.match(/(iPhone|iPod)/g);
    }());
    
    
    FWDUVPlayer.areMainInstancesInitialized_bl = false;
    FWDUVPlayer.curInstance = null;
    FWDUVPlayer.keyboardCurInstance = null;
    FWDUVPlayer.isYoutubeAPICreated_bl = false;
    
    FWDUVPlayer.HLS_JS = "HLS";
    FWDUVPlayer.DASH = 'DASH';
    FWDUVPlayer.PAUSE_ALL_VIDEOS = "pause";
    FWDUVPlayer.STOP_ALL_VIDEOS = "stop";
    FWDUVPlayer.DO_NOTHING = "none";
    FWDUVPlayer.YOUTUBE = "youtube";
    FWDUVPlayer.VIMEO = "vimeo";
    FWDUVPlayer.VIDEO = "video";
    FWDUVPlayer.IFRAME = "iframe";
    FWDUVPlayer.atLeastOnePlayerHasDeeplinking_bl = false;
    FWDUVPlayer.MP3 = "mp3";
    
    FWDUVPlayer.CENTER = "center";
    FWDUVPlayer.RIGHT = "right";
    FWDUVPlayer.LEFT = "left";
    FWDUVPlayer.POSITION_BOTTOM = "bottom";
    FWDUVPlayer.POSITION_TOP = "top";
    FWDUVPlayer.HIDE_LIGHTBOX_COMPLETE = "lightboxHideComplete";
    FWDUVPlayer.START_TO_LOAD_PLAYLIST = "startToLoadPlaylist";
    FWDUVPlayer.LOAD_PLAYLIST_COMPLETE = "loadPlaylistComplete";
    FWDUVPlayer.READY = "ready";
    FWDUVPlayer.STOP = "stop";
    FWDUVPlayer.PLAY = "play";
    FWDUVPlayer.PAUSE = "pause";
    FWDUVPlayer.UPDATE = "update";
    FWDUVPlayer.UPDATE_TIME = "updateTime";
    FWDUVPlayer.UPDATE_VIDEO_SOURCE = "updateVideoSource";
    FWDUVPlayer.UPDATE_POSTER_SOURCE = "udpatePosterSource";
    FWDUVPlayer.ERROR = "error";
    FWDUVPlayer.PLAY_COMPLETE = "playComplete";
    FWDUVPlayer.VOLUME_SET = "volumeSet";
    FWDUVPlayer.GO_FULLSCREEN = "goFullScreen";
    FWDUVPlayer.GO_NORMALSCREEN = "goNormalScreen";
    FWDUVPlayer.IMAGE = "image";
    FWDUVPlayer.HLS_JS = "hls_flash"
    FWDUVPlayer.SAFE_TO_SCRUB = "safeToScrub";
    
    FWDUVPlayer.LIGHTBOX = "lightbox";
    FWDUVPlayer.STICKY = "sticky";
    FWDUVPlayer.RESPONSIVE = "responsive";
    FWDUVPlayer.FULL_SCREEN = "fullscreen";
    FWDUVPlayer.AFTER_PARENT = "afterparent";
    
    window.FWDUVPlayer = FWDUVPlayer;
    
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Lightbox.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){

    'use strict';
    
    var FWDUVPLightBox = function(
            prt,
            mainBackgroundColor_str,
            holderBackgroundColor_str,
            lightBoxBackgroundOpacity,
            lightBoxWidth,
            lightBoxHeight
        ){
        
        var _s  = this;
        var prototype = FWDUVPLightBox.prototype;

        _s.mainBackgroundColor_str = mainBackgroundColor_str;
        _s.holderBackgroundColor_str = holderBackgroundColor_str;
        
        _s.lightBoxBackgroundOpacity = lightBoxBackgroundOpacity;
        _s.lightBoxWidth = lightBoxWidth;
        _s.lightBoxHeight = lightBoxHeight;
        
        _s.isMbl = FWDUVPUtils.isMobile;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
        _s.closeButtonIsTweening_bl = true;
    
        _s.init = function(){
            _s.getStyle().zIndex = 9999999;
            _s.setupMainContainers();
        };

        
        //#############################################//
        /* setup main containers */
        //#############################################//
        _s.setupMainContainers = function(){
            
            if(_s.isMbl && _s.hasPointerEvent_bl) _s.getStyle().msTouchAction = "none";
            
            _s.lightBoxBackground_sdo = new FWDUVPDisplayObject("div"); 
            _s.lightBoxBackground_sdo.setResizableSizeAfterParent();
            _s.lightBoxBackground_sdo.setBkColor(_s.mainBackgroundColor_str);
            _s.lightBoxBackground_sdo.screen.addEventListener('click', _s.closeButtonOnStartHandler);
            _s.addChild(_s.lightBoxBackground_sdo);
            
            _s.mainLightBox_do = new FWDUVPDisplayObject("div");
            _s.mainLightBox_do.setBkColor(_s.holderBackgroundColor_str);
            _s.mainLightBox_do.setWidth(1);
            _s.mainLightBox_do.setHeight(1);

            _s.addChild(_s.mainLightBox_do);
            
            document.documentElement.appendChild(_s.screen);
            
            _s.setX(-10000);
            _s.setY(-10000);
            _s.setWidth(0);
            _s.setHeight(0);
        };
        
        _s.show = function(){
            
            if(_s.isShowed_bl) return;
            if(_s.clsBtn){
                _s.hideCloseButton(false);
                _s.showCloseButton(true);
                _s.clsBtn.setX(-200);
            }else{
                _s.loadClsoeButtonImage();
            }
            
            var viewportSize = FWDUVPUtils.getViewportSize();
            var scrollOffsets = FWDUVPUtils.getScrollOffsets();
            
            _s.setWidth(viewportSize.w);
            _s.setHeight(viewportSize.h);
            _s.setX(scrollOffsets.x);
            _s.setY(scrollOffsets.y);
            
            _s.lightBoxBackground_sdo.setAlpha(0);
            FWDAnimation.to(_s.lightBoxBackground_sdo, .8, {alpha:_s.lightBoxBackgroundOpacity});
            _s.setX(scrollOffsets.x);
            _s.setY(scrollOffsets.y);
            
            _s.mainLightBox_do.setX(parseInt(viewportSize.w/2));
            _s.mainLightBox_do.setY(parseInt(viewportSize.h/2));
            
            if(_s.lightBoxWidth > viewportSize.w){
                _s.finalLightBoxWidth = viewportSize.w;
                _s.finalLightBoxHeight = parseInt(_s.lightBoxHeight * (viewportSize.w/_s.lightBoxWidth));
            }else{
                _s.finalLightBoxWidth = _s.lightBoxWidth;
                _s.finalLightBoxHeight = _s.lightBoxHeight;
            }
            
            FWDAnimation.to(_s.mainLightBox_do, .8, {
                w:_s.finalLightBoxWidth, 
                h:_s.finalLightBoxHeight,
                x:parseInt((viewportSize.w - _s.finalLightBoxWidth)/2),
                y:parseInt((viewportSize.h - _s.finalLightBoxHeight)/2),
                delay:.4,
                onComplete:_s.showComplete,
                ease:Expo.easeInOut});

            if(prt.main_do){
                prt.main_do.setX(-5000);
            }
            _s.dispatchEvent(FWDUVPLightBox.SHOW);
        }
        
        _s.showComplete = function(){
            _s.isShowed_bl = true;
            _s.clsBtn.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.closeButtonOnStartHandler);
            _s.addKeyboardSupport();
            prt.startResizeHandler();
            console.log('complete ' + _s.wasAutoPlay)
            if(prt.isPlaylistLoaded_bl &&  (prt._d.autoPlay_bl || _s.wasAutoPlay)){
                if(!_s.setWAP) _s.wasAutoPlay = prt._d.autoPlay_bl;
                _s.setWAP = true;
                prt.play();
            }
        }
        
        
        //####################################//
        /* Add keyboard support */
        //#####################################//
        _s.addKeyboardSupport = function(){
            document.addEventListener("keydown",  _s.onKeyDownHandler); 
        }
        
        _s.onKeyDownHandler = function(e){
            if(e.keyCode == 27) _s.closeButtonOnStartHandler();
        }
        

        //#############################################//
        /* setup lightbox close button */
        //#############################################//
        _s.loadClsoeButtonImage = function(){
            _s.closeN_img = new Image();
            _s.closeN_img.onload = _s.setupCloseButton;
            _s.closeN_img.src = prt.mainFolderPath_str + prt.sknPth + "embed-close-button.png";
            _s.closeSPath_str = prt.mainFolderPath_str + prt.sknPth + "embed-close-button-over.png";
        }
        
        _s.setupCloseButton = function(e){
            var viewportSize = FWDUVPUtils.getViewportSize();
            FWDUVPSimpleButton.setPrototype();
            _s.clsBtn = new FWDUVPSimpleButton(_s.closeN_img, _s.closeSPath_str, undefined, true);
            
            _s.hideCloseButton(false);
            _s.showCloseButton(true);
            _s.clsBtn.setX(viewportSize.w - _s.clsBtn.w - 15);
            _s.clsBtn.setY(15);
            _s.addChild(_s.clsBtn);
        };
        
        _s.showCloseButtonComplete = function(){
            _s.closeButtonIsTweening_bl = false;
        }
        
        _s.hideCloseButton = function(animate){
            FWDAnimation.killTweensOf(_s.clsBtn);
            if(!animate){
                _s.clsBtn.setAlpha(0);
            }else{
                FWDAnimation.to(_s.clsBtn, .9, {alpha:0});  
            }
        }
        
        _s.showCloseButton = function(animate){
            FWDAnimation.killTweensOf(_s.clsBtn);
            if(!animate){
                _s.clsBtn.setAlpha(1);
            }else{
                FWDAnimation.to(_s.clsBtn, .9, {alpha:1, delay:.8});    
            }
        }
        
        _s.mouseDummyHandler = function(e){
            if(e.preventDefault){
                e.preventDefault();
            }else{
                return false;
            }
        };
            
        _s.closeButtonOnStartHandler = function(e){
            if(!_s.isShowed_bl) return;
            _s.isShowed_bl = false;
            var viewportSize = FWDUVPUtils.getViewportSize();
            
            _s.clsBtn.removeListener(FWDUVPSimpleButton.MOUSE_UP, _s.closeButtonOnStartHandler);
            
            FWDAnimation.to(_s.clsBtn, .9, {alpha:0});
            FWDAnimation.to(_s.mainLightBox_do, .8, {
                w:0, 
                h:0,
                x:parseInt(viewportSize.w/2),
                y:parseInt(viewportSize.h/2),
                delay:.4,
                ease:Expo.easeInOut});
            
            FWDAnimation.to(_s.lightBoxBackground_sdo, .8, {alpha:0, delay:.8});
            FWDAnimation.to(prt.main_do, .8, {x:-prt.main_do.w/2, y:-prt.main_do.h/2 , ease:Expo.easeInOut, delay:.4});
            _s.lighboxAnimDoneId_to = setTimeout(_s.lighboxHideAnimationDone, 1600);
            
            _s.dispatchEvent(FWDUVPLightBox.CLOSE);
        };
        
        _s.lighboxHideAnimationDone = function(){
            _s.setX(-10000);
            _s.setY(-10000);
            _s.setWidth(0);
            _s.setHeight(0);
            _s.dispatchEvent(FWDUVPLightBox.HIDE_COMPLETE);
        };
            
        _s.init();
    };

    
    /* set prototype */
    FWDUVPLightBox.setPrototype = function(){
        FWDUVPLightBox.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPLightBox.CLOSE = "ligtBoxClose";
    FWDUVPLightBox.SHOW = "show";
    FWDUVPLightBox.HIDE_COMPLETE = "hideComplete";
    
    FWDUVPLightBox.prototype = null;
    window.FWDUVPLightBox = FWDUVPLightBox;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Logo.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){

    'use strict';
    
    var FWDUVPLogo = function(
            prt, 
            source,
            position,
            margins,
            logoTarget
        ){
        
        var _s  = this;
        var prototype = FWDUVPLogo.prototype;

        _s.position_str = position;
        _s.source_str = source;
        _s.logoLink_str = prt._d.logoLink_str;
        
        _s.margins = margins;
        _s.logoTarget = logoTarget;
        
        _s.isShowed_bl = true;
        _s.allowToShow_bl = true;
    
        _s.init = function(){
            
            if(_s.logoLink_str == "none"){
                _s.getStyle().pointerEvents = "none";
            }else{
                _s.setButtonMode(true);
                _s.screen.onclick = function(){
                    if(_s.logoTarget == '_self'){
                        location.href = _s.logoLink_str;
                    }else{
                        window.open(_s.logoLink_str, "_blank");
                    }
                };
            }
            
            _s.logoImage_do = new FWDUVPDisplayObject("img");
            
            _s.img_img = new Image();
            _s.img_img.onerror = null;
            _s.img_img.onload = _s.loadDone;
            _s.img_img.src = _s.source_str + "?" + new Date().getTime();
            _s.hide();
        };
        
        _s.loadDone = function(){
            _s.setWidth(_s.img_img.width);
            _s.setHeight(_s.img_img.height);
            _s.logoImage_do.setScreen(_s.img_img);
            _s.addChild(_s.logoImage_do);
            _s.logoImage_do.setWidth(_s.img_img.width);
            _s.logoImage_do.setHeight(_s.img_img.height);
            
            _s.positionAndResize();
        };
        
        _s.positionAndResize = function(){
            
            if(!prt.tempVidStageWidth) return;
            
            if(_s.position_str == "topleft"){
                _s.finalX = _s.margins;
                _s.finalY = _s.margins;
            }else if(_s.position_str == "topright"){
                _s.finalX = prt.tempVidStageWidth - _s.w - _s.margins;
                _s.finalY = _s.margins;
            }else if(_s.position_str == "bottomright"){
                _s.finalX = prt.tempVidStageWidth - _s.w - _s.margins;
                _s.finalY = prt.tempVidStageHeight - _s.h - _s.margins;
            }else if(_s.position_str == "bottomleft"){
                _s.finalX = _s.margins;
                _s.finalY = prt.tempVidStageHeight - _s.h - _s.margins;
            }
        
            _s.setX(_s.finalX);
            _s.setY(_s.finalY);
        };
        

        //################################//
        /* show / hide */
        //################################//
        _s.show = function(animate){
            if(_s.isShowed_bl) return;
            _s.isShowed_bl = true;
            _s.setVisible(true);
            FWDAnimation.killTweensOf(_s);
            if(animate){
                FWDAnimation.to(_s, .8, {alpha:1, ease:Expo.easeInOut});
            }else{
                _s.setAlpha(1);
            }
        };
        
        _s.hide = function(animate, overwrite){
            if(!_s.isShowed_bl && !overwrite) return;
            _s.isShowed_bl = false;
            FWDAnimation.killTweensOf(_s);
            if(animate){
                FWDAnimation.to(_s, .8, {alpha:0, ease:Expo.easeInOut, onComplete:function(){
                    _s.setVisible(false);
                }});
            }else{
                _s.setAlpha(0);
                _s.setVisible(false);
            }
        };
        
        
        _s.init();
    };
    
    /* set prototype */
    FWDUVPLogo.setPrototype = function(){
        FWDUVPLogo.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPLogo.prototype = null;
    window.FWDUVPLogo = FWDUVPLogo;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Sticky display opener.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (){
    var FWDUVPOpener = function(_d, position_str, playerIsShowed_bl){
        
        'use strict';

        var _s = this;
        
        _s.animation_img = _d.openerAnimation_img;
        
        if(position_str ==  FWDUVPlayer.POSITION_TOP){
            _s.openN_img = _d.openTopN_img;
            _s.openSPath_str = _d.openTopSPath_str;     
        }else{
            _s.openN_img = _d.openBottomN_img;
            _s.openSPath_str = _d.openBottomSPath_str;
        }
    
        _s.openerPauseN_img = _d.openerPauseN_img;
        _s.openerPlayN_img = _d.openerPlayN_img;
        _s.closeN_img = _d.closeN_img;
        
        _s.useHEX = _d.useHEX; 
        _s.nBC = _d.nBC;
        _s.sBC = _d.sBC;
        
        _s.openerPauseS_str = _d.openerPauseS_str;
        _s.openerPlaySPath_str = _d.openerPlayS_str;
        _s.closeSPath_str = _d.closeSPath_str;
        _s.animationPath_img = _d.animationPath_img;
        
        try{
            _s.totalWidth = _s.openN_img.width;
            _s.totalHeight = _s.openN_img.height;
        }catch(e){}
        
        _s.position_str = position_str;
        _s.alignment_str = _d.openerAlignment_str;
        
        _s.openerEqulizerOffsetLeft = _d.openerEqulizerOffsetLeft; 
        _s.openerEqulizerOffsetTop = _d.openerEqulizerOffsetTop;
        
        _s.showFirstTime_bl = true;
        _s.playerIsShowed_bl = playerIsShowed_bl;
        _s.showOpenerPlayPauseButton_bl = _d.showOpenerPlayPauseButton_bl;
        _s.isMbl = FWDUVPUtils.isMobile;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
        
        _s.init = function(){
            
            if(_d.sknPth.indexOf("hex_white") != -1){
                _s.sBC = "#FFFFFF";
            }else{
                _s.sBC = _d.sBC;
            }
            _s.hasTransform3d_bl = false;
            _s.hasTransform2d_bl = false;
            _s.setBackfaceVisibility();
            _s.getStyle().msTouchAction = "none";
            _s.getStyle().webkitTapHighlightColor = "rgba(0, 0, 0, 0)";
            _s.setupStuff();
            if(_s.showOpenerPlayPauseButton_bl) _s.setupPlayPauseButton();
        
            if(_s.playerIsShowed_bl) _s.showCloseButton();
            if(_s.showOpenerPlayPauseButton_bl){
                _s.setWidth(_s.totalWidth + _s.openerPauseN_img.width + 1);
            }else{
                _s.setWidth(_s.totalWidth);
            }
            _s.setHeight(_s.totalHeight);
        };
    

        //######################################//
        /* setup main stuff */
        //######################################//
        _s.setupStuff = function(e){
            
            _s.mainHld = new FWDUVPDisplayObject("div");
            _s.mainHld.hasTransform3d_bl = false;
            _s.mainHld.hasTransform2d_bl = false;
            _s.mainHld.setBackfaceVisibility();
            
            if(_s.showOpenerPlayPauseButton_bl){
                _s.mainHld.setWidth(_s.totalWidth + _s.openerPauseN_img.width + 1);
            }else{
                _s.mainHld.setWidth(_s.totalWidth);
            }
            _s.mainHld.setHeight(_s.totalHeight);
            
            if(_s.useHEX){
                
                _s.openN_do = new FWDUVPDisplayObject("div");
                _s.openN_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.openN_img, _s.nBC).canvas;
                _s.openN_do.screen.appendChild(_s.openN_canvas);
            }else{
                _s.openN_do = new FWDUVPDisplayObject("img");
                _s.openN_do.setScreen(_s.openN_img);
            }
            _s.openN_do.setWidth(_s.openN_img.width);
            _s.openN_do.setHeight(_s.openN_img.height);
            
            _s.openS_img = new Image();
            _s.openS_img.src = _s.openSPath_str;    
            if(_s.useHEX){
                _s.openS_do = new FWDUVPDisplayObject("div");
                _s.openS_img.onload = function(){       
                    _s.openS_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.openS_img, _s.sBC).canvas;
                    _s.openS_do.setWidth(_s.openS_img.width);
                    _s.openS_do.setHeight(_s.openS_img.height);
                    _s.openS_do.screen.appendChild(_s.openS_canvas);
                }                   
            }else{
                _s.openS_do = new FWDUVPDisplayObject("img"); 
                _s.openS_do.setScreen(_s.openS_img);
            }
            _s.openS_do.setWidth(_s.openN_do.w);
            _s.openS_do.setHeight(_s.openN_do.h);
            _s.openS_do.setAlpha(0);
            
            if(_s.useHEX){
                _s.closeN_do = new FWDUVPDisplayObject("div");
                _s.closeN_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.closeN_img, _s.nBC).canvas;
                _s.closeN_do.screen.appendChild(_s.closeN_canvas);
            }else{
                _s.closeN_do = new FWDUVPDisplayObject("img");
                _s.closeN_do.setScreen(_s.closeN_img);
            }
            _s.closeN_do.setWidth(_s.closeN_img.width);
            _s.closeN_do.setHeight(_s.closeN_img.height);
            
            _s.closeN_do.hasTransform3d_bl = false;
            _s.closeN_do.hasTransform2d_bl = false;
            _s.closeN_do.setBackfaceVisibility();
            
            _s.closeS_img = new Image();
            _s.closeS_img.src = _s.closeSPath_str;  
            if(_s.useHEX){
                _s.closeS_do = new FWDUVPDisplayObject("div");
                _s.closeS_img.onload = function(){      
                    _s.closeS_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.closeS_img, _s.sBC).canvas;
                    _s.closeS_do.setWidth(_s.closeN_img.width);
                    _s.closeS_do.setHeight(_s.closeN_img.height);
                    _s.closeS_do.screen.appendChild(_s.closeS_canvas);
                }                   
            }else{
                _s.closeS_do = new FWDUVPDisplayObject("img"); 
                _s.closeS_do.setScreen(_s.closeS_img);
            }
            
            _s.closeS_do.setWidth(_s.closeN_img.width);
            _s.closeS_do.setHeight(_s.closeN_img.height);
            
            _s.closeS_do.setAlpha(0);
            _s.closeS_do.hasTransform3d_bl = false;
            _s.closeS_do.hasTransform2d_bl = false;
            
            FWDUVPPreloader2.setPrototype();
            _s.animation_do = new FWDUVPPreloader2(_s.animationPath_img, 29, 22, 31, 80, true);
            _s.animation_do.setY(_s.openerEqulizerOffsetTop);
            _s.animation_do.show(false);
            _s.animation_do.stop();
            
            _s.dumy_do = new FWDUVPDisplayObject("div");
            _s.dumy_do.setWidth(_s.totalWidth);
            _s.dumy_do.setHeight(_s.totalHeight);
            _s.dumy_do.getStyle().zIndex = 2;
            _s.dumy_do.hasTransform3d_bl = false;
            _s.dumy_do.hasTransform2d_bl = false;
            _s.dumy_do.setBackfaceVisibility();
            _s.dumy_do.setButtonMode(true);
            
            if(FWDUVPUtils.isIE || FWDUVPUtils.isAndroid){
                _s.dumy_do.setBkColor("#FF0000");
                _s.dumy_do.setAlpha(.01);
            }
        
            if(_s.hasPointerEvent_bl){
                _s.mainHld.screen.addEventListener("pointerup", _s.onMouseUp);
                _s.mainHld.screen.addEventListener("pointerover", _s.onMouseOver);
                _s.mainHld.screen.addEventListener("pointerout", _s.onMouseOut);
            }else if(_s.screen.addEventListener){   
                if(!_s.isMbl){
                    _s.mainHld.screen.addEventListener("mouseover", _s.onMouseOver);
                    _s.mainHld.screen.addEventListener("mouseout", _s.onMouseOut);
                    _s.mainHld.screen.addEventListener("mouseup", _s.onMouseUp);
                }
                _s.screen.addEventListener("touchend", _s.onMouseUp);
            }
            
            _s.mainHld.addChild(_s.openN_do);
            _s.mainHld.addChild(_s.openS_do);
            
            _s.mainHld.addChild(_s.closeN_do);
            _s.mainHld.addChild(_s.closeS_do);
            _s.mainHld.addChild(_s.animation_do);
            _s.mainHld.addChild(_s.dumy_do);
            _s.addChild(_s.mainHld);
            
        };
        
        _s.showOpener = function(animate){}
        
        _s.onMouseOver = function(e, animate){
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE || e.pointerType == "mouse"){
                _s.setSelectedState();
            }
        };
            
        _s.onMouseOut = function(e){
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE || e.pointerType == "mouse"){
                _s.setNormalState();
            }
        };
        
        _s.onMouseUp = function(e){
            if(e.preventDefault) e.preventDefault();
            if(_s.playerIsShowed_bl){
                _s.playerIsShowed_bl = false;
                _s.dispatchEvent(FWDUVPOpener.HIDE);
            }else{
                _s.playerIsShowed_bl = true;
                _s.dispatchEvent(FWDUVPOpener.SHOW);
            }
        };

        
        //################################################//
        /* Setup play button */
        //################################################//
        _s.setupPlayPauseButton = function(){
            FWDUVPComplexButton.setPrototype();
            _s.playPauseButton_do = new FWDUVPComplexButton(
                    _s.openerPlayN_img,
                    _s.openerPlaySPath_str,
                    _s.openerPauseN_img,
                    _s.openerPauseS_str,
                    true,
                    _s.useHEX,
                    _s.nBC,
                    _s.sBC
            );
            _s.playPauseButton_do.addListener(FWDUVPComplexButton.MOUSE_UP, _s.playButtonMouseUpHandler);
            _s.addChild(_s.playPauseButton_do);
        };
        
        _s.showPlayButton = function(){
            if(_s.playPauseButton_do) _s.playPauseButton_do.setButtonState(1);
            _s.animation_do.stop();
        };
        
        _s.showPauseButton = function(){
            if(_s.playPauseButton_do) _s.playPauseButton_do.setButtonState(0);
            _s.animation_do.start(0);
        };
        
        _s.playButtonMouseUpHandler = function(){
            if(_s.playPauseButton_do.currentState == 0){
                _s.dispatchEvent(FWDUVPController.PAUSE);
            }else{
                _s.dispatchEvent(FWDUVPController.PLAY);
            }
        };

        
        //###############################//
        /* set normal / selected state */
        //################################//
        _s.setNormalState = function(){
            if(_s.isMbl && !_s.hasPointerEvent_bl) return;
            FWDAnimation.killTweensOf(_s.openS_do);
            FWDAnimation.killTweensOf(_s.closeS_do);
            FWDAnimation.to(_s.openS_do, .5, {alpha:0, ease:Expo.easeOut}); 
            FWDAnimation.to(_s.closeS_do, .5, {alpha:0, ease:Expo.easeOut});
        };
        
        _s.setSelectedState = function(animate){
            FWDAnimation.killTweensOf(_s.openS_do);
            FWDAnimation.killTweensOf(_s.closeS_do);
            FWDAnimation.to(_s.openS_do, .5, {alpha:1, ease:Expo.easeOut}); 
            FWDAnimation.to(_s.closeS_do, .5, {alpha:1, ease:Expo.easeOut});
        };
        

        //######################################//
        /* show /hide close / open */
        //######################################//
        _s.showOpenButton = function(){
            _s.playerIsShowed_bl = false;
            _s.closeN_do.setX(150);
            _s.closeS_do.setX(150);
            
            if(_s.playPauseButton_do){
                if(_s.alignment_str == "right"){
                    _s.playPauseButton_do.setX(0);
                    _s.openN_do.setX(_s.playPauseButton_do.w + 1);
                    _s.openS_do.setX(_s.playPauseButton_do.w + 1);
                    _s.dumy_do.setX(_s.playPauseButton_do.w + 1);
                    _s.dumy_do.setWidth(_s.totalWidth);
                    _s.animation_do.setX(_s.playPauseButton_do.w + 1 + _s.openerEqulizerOffsetLeft);
                }else{
                    _s.playPauseButton_do.setX(_s.openN_do.w + 1);
                    _s.openN_do.setX(0);
                    _s.openS_do.setX(0);
                    _s.dumy_do.setX(0);
                    _s.dumy_do.setWidth(_s.totalWidth);
                    _s.animation_do.setX(_s.openerEqulizerOffsetLeft);
                }
            }else{
                _s.openN_do.setX(0);
                _s.openS_do.setX(0);
                _s.dumy_do.setX(0);
                _s.dumy_do.setWidth(_s.totalWidth);
                _s.animation_do.setX(_s.openerEqulizerOffsetLeft);
            }
            _s.animation_do.setVisible(true);
        };
        
        _s.showCloseButton = function(){
            _s.playerIsShowed_bl = true;
            _s.openN_do.setX(150);
            _s.openS_do.setX(150);
            _s.dumy_do.setWidth(_s.closeN_do.w);
            if(_s.alignment_str == "right"){
                if(_s.playPauseButton_do){
                    _s.closeN_do.setX(_s.totalWidth + 1);
                    _s.closeS_do.setX(_s.totalWidth + 1);
                    _s.dumy_do.setX(_s.totalWidth + 1);
                }else{
                    _s.closeN_do.setX(_s.totalWidth - _s.closeN_do.w);
                    _s.closeS_do.setX(_s.totalWidth - _s.closeN_do.w);
                    _s.dumy_do.setX(_s.totalWidth - _s.closeN_do.w);
                }
            }else{
                _s.closeN_do.setX(0);
                _s.closeS_do.setX(0);
                _s.dumy_do.setX(0);
            }
            
            if(_s.playPauseButton_do) _s.playPauseButton_do.setX(150);
            _s.animation_do.setX(150);
            _s.animation_do.setVisible(false);
        };
        
        _s.hide = function(){
            _s.mainHld.setX(150);
        };
        
        _s.show = function(){
            _s.mainHld.setX(0);
        };
        

        //##########################################//
        /* Update HEX color of a canvaas */
        //##########################################//
        _s.updateHEXColors = function(nBC, sBC){
            
            _s.nBC = nBC;
            _s.sBC = sBC;
            _s.playPauseButton_do.updateHEXColors(nBC, sBC);
            FWDUVPUtils.changeCanvasHEXColor(_s.openN_img, _s.openN_canvas, nBC);
            FWDUVPUtils.changeCanvasHEXColor(_s.closeN_img, _s.closeN_canvas, nBC);
            
            FWDUVPUtils.changeCanvasHEXColor(_s.openS_img, _s.openS_canvas, sBC);
            FWDUVPUtils.changeCanvasHEXColor(_s.closeS_img, _s.closeS_canvas, sBC);
        }
        
        _s.init();
    };

    
    /* set prototype */
    FWDUVPOpener.setPrototype = function(){
        FWDUVPOpener.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPOpener.SHOW = "show";
    FWDUVPOpener.HIDE = "hise";
    FWDUVPOpener.PLAY = "play";
    FWDUVPOpener.PAUSE = "pause";
    
    
    FWDUVPOpener.prototype = null;
    window.FWDUVPOpener = FWDUVPOpener;
    
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Popup window.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
    
    var FWDUVPOPWindow = function(_d, prt){
        
        'use strict';

        var _s = this;
        var prototype = FWDUVPOPWindow.prototype;
        
        _s.buttons_ar = [];
        
        _s.maxWidth = _d.aopwWidth;
        _s.maxHeight = _d.aopwHeight + _d.popwColseN_img.height + 1; 
        _s.sW = 0;
        _s.sH = 0;
        _s.aopwSource = _d.aopwSource;
        _s.aopwTitle = _d.aopwTitle;
        _s.aopwTitleColor_str = _d.aopwTitleColor_str;
        _s.aopwBorderSize = _d.aopwBorderSize;

        _s.isMbl = FWDUVPUtils.isMobile;
    

        //#################################//
        /* init */
        //#################################//
        _s.init = function(){
            _s.setBackfaceVisibility();
            
            _s.mainBar_do = new FWDUVPDisplayObject("div");
            
            _s.bar_do = new FWDUVPDisplayObject("div");
            _s.bar_do.getStyle().background = "url('" + _d.popwBarBackgroundPath_str + "')";
            
            _s.adHolder_do = new FWDUVPDisplayObject("div");
        
            _s.adBk_do = new FWDUVPDisplayObject("div");
            _s.adBk_do.getStyle().background = "url('" + _d.popwWindowBackgroundPath_str + "')";
                
            //setup close button
            FWDUVPSimpleButton.setPrototype();
            _s.clsBtn = new FWDUVPSimpleButton(_d.popwColseN_img, _d.popwColseSPath_str, undefined,
                    true,
                    _d.useHEX,
                    _d.nBC,
                    _d.sBC,
                    false, false, false, false, true);
            _s.clsBtn.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.closeButtonOnMouseUpHandler);
            
            _s.title_do = new FWDUVPDisplayObject("div");
            _s.title_do.getStyle().width = "100%";
            _s.title_do.getStyle().textAlign = "left";
            _s.title_do.getStyle().fontFamily = "Arial";
            _s.title_do.getStyle().fontSize= "14px";
            _s.title_do.getStyle().fontWeight = "100";
            _s.title_do.getStyle().color = _s.aopwTitleColor_str;
            _s.title_do.setInnerHTML(_s.aopwTitle);
            _s.bar_do.addChild(_s.title_do);
            
            _s.addChild(_s.adBk_do);
            _s.mainBar_do.addChild(_s.bar_do);
            _s.mainBar_do.addChild(_s.clsBtn); 
            _s.mainBar_do.setHeight(_s.clsBtn.h);
            _s.addChild(_s.mainBar_do);
            _s.addChild(_s.adHolder_do);
            _s.bar_do.setHeight(_s.mainBar_do.h);
        };
        
        _s.closeButtonOnMouseUpHandler = function(){
            if(!_s.isShowed_bl) return;
            _s.hide();
            prt.play();
        };
        
        _s.positionAndResize = function(){
            _s.sW = Math.min(prt.tempVidStageWidth, _s.maxWidth);
            _s.sH = Math.min(prt.tempVidStageHeight, _s.maxHeight);
            var totalScale = 1;
            var scaleX = prt.tempVidStageWidth/_s.maxWidth;
            var scaleY = prt.tempVidStageHeight/_s.maxHeight;
            if(scaleX < scaleY){
                totalScale = scaleX;
            }else if(scaleX > scaleY){
                totalScale = scaleY;
            }
            if(totalScale > 1) totalScale = 1;
            
            _s.sW = totalScale * _s.maxWidth;
            _s.sH = totalScale * _s.maxHeight;
            
            _s.setWidth(_s.sW);
            _s.setHeight(_s.sH);
    
            _s.setHeight(_s.sH);
            _s.setX(Math.round((prt.tempVidStageWidth - _s.sW)/2));
            _s.setY(Math.round((prt.tempVidStageHeight - _s.sH)/2));
            
            _s.mainBar_do.setWidth(_s.sW);
            _s.clsBtn.setX(_s.sW - _s.clsBtn.w);
            _s.bar_do.setWidth(_s.sW - _s.clsBtn.w - 1);
            
            _s.adBk_do.setWidth(_s.sW);
            _s.adBk_do.setHeight(_s.sH - _s.mainBar_do.h - 1);
            _s.adBk_do.setY(_s.mainBar_do.h + 1);
            
            _s.adHolder_do.setWidth(_s.sW - _s.aopwBorderSize * 2);
            _s.adHolder_do.setX(_s.aopwBorderSize);
            _s.adHolder_do.setY(_s.mainBar_do.h + _s.aopwBorderSize + 1);
            _s.adHolder_do.setHeight(_s.sH - _s.mainBar_do.h - _s.aopwBorderSize * 2 - 1);
        };
        
        
        //###########################################//
        /* show / hide */
        //###########################################//
        _s.show = function(aopwSource){
            if(_s.isShowed_bl) return;
            _s.isShowed_bl = true;
            if(aopwSource) _s.aopwSource = aopwSource;
            prt.main_do.addChild(_s);
            _s.adHolder_do.setInnerHTML("<iframe width='100%' height='100%' scrolling='no' frameBorder='0' src=" + _s.aopwSource + "></iframe>");
            _s.positionAndResize();
            
            _s.title_do.setX(8);
            _s.title_do.setY(Math.round((_s.bar_do.h - _s.title_do.getHeight())/2));
        };
        
        _s.showCompleteHandler = function(){};
        
        _s.hide = function(){
            if(!_s.isShowed_bl) return;
            _s.isShowed_bl = false;
            if(prt.main_do.contains(_s)) prt.main_do.removeChild(_s);
        };
        
        _s.hideCompleteHandler = function(){
            prt.main_do.removeChild(_s);
            _s.dispatchEvent(FWDUVPOPWindow.HIDE_COMPLETE);
        };
        

        //##########################################//
        /* Update HEX color of a canvaas */
        //##########################################//
        _s.updateHEXColors = function(nBC, sBC){
            _s.clsBtn.updateHEXColors(nBC, sBC);
        }
    
        _s.init();
    };
        
        
    /* set prototype */
    FWDUVPOPWindow.setPrototype = function(){
        FWDUVPOPWindow.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPOPWindow.HIDE_COMPLETE = "hideComplete";
    
    FWDUVPOPWindow.prototype = null;
    window.FWDUVPOPWindow = FWDUVPOPWindow;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Password window.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
    
    var FWDUVPPassword = function(_d, prt, lg){

        'use strict';
        
        var _s = this;
        var prototype = FWDUVPPassword.prototype;
            
        _s.passColoseN_img = _d.passColoseN_img;
        _s.privateVideoPassword_str = _d.privateVideoPassword_str;
        _s.embedWindowBackground_str = _d.embedWindowBackground_str;
        
        _s.secondaryLabelsColor_str = _d.secondaryLabelsColor_str;
        _s.inputColor_str = _d.inputColor_str;
        _s.mainLabelsColor_str = _d.mainLabelsColor_str;
        _s.passButtonNPath_str = _d.passButtonNPath_str;
        _s.passButtonSPath_str = _d.passButtonSPath_str;
        _s.inputBackgroundColor_str = _d.inputBackgroundColor_str;
        _s.borderColor_str = _d.borderColor_str;
        
        _s.maxTextWidth = 0;
        _s.totalWidth = 0;
        _s.sW = 0;
        _s.sH = 0;
        _s.buttonWidth = 28;
        _s.buttonHeight = 19;
        _s.embedWindowCloseButtonMargins = _d.embedWindowCloseButtonMargins;
        _s.finalEmbedPath_str = null;
        
        _s.useVectorIcons_bl = _d.useVectorIcons_bl;
        _s.isMobile_bl = FWDUVPUtils.isMobile;

    
        //#################################//
        /* init */
        //#################################//
        _s.init = function(){
            if(_s.clsBtn) return;
            _s.setBackfaceVisibility();
            _s.mainHld = new FWDUVPDisplayObject("div");
            _s.mainHld.hasTransform3d_bl = false;
            _s.mainHld.hasTransform2d_bl = false;
            _s.mainHld.setBackfaceVisibility();
            
            _s.bk_do = new FWDUVPDisplayObject("div");
            _s.bk_do.getStyle().width = "100%";
            _s.bk_do.getStyle().height = "100%";
            _s.bk_do.setAlpha(.9);
            _s.bk_do.getStyle().background = "url('" + _s.embedWindowBackground_str + "')";
        
            _s.passMainHolder_do =  new FWDUVPDisplayObject("div");
            
            _s.passMainHldBk = new FWDUVPDisplayObject("div");
            _s.passMainHldBk.getStyle().background = "url('" + _s.embedWindowBackground_str + "')";
            _s.passMainHldBk.getStyle().borderStyle = "solid";
            _s.passMainHldBk.getStyle().borderWidth = "1px";
            _s.passMainHldBk.getStyle().borderColor =  _s.borderColor_str;
            
            _s.passMainLabel_do = new FWDUVPDisplayObject("div");
            _s.passMainLabel_do.screen.className = 'UVP-main-label';
            _s.passMainLabel_do.setBackfaceVisibility();
            _s.passMainLabel_do.screen.className = 'fwdeap-main-label'
            _s.passMainLabel_do.getStyle().fontFamily = "Arial";
            _s.passMainLabel_do.getStyle().fontSize= "12px";
            _s.passMainLabel_do.getStyle().color = _s.mainLabelsColor_str;
            _s.passMainLabel_do.getStyle().whiteSpace= "nowrap";
            _s.passMainLabel_do.getStyle().padding = "0px";
            _s.passMainLabel_do.setInnerHTML("PRIVATE VIDEO");  
            
            _s.passLabel_do = new FWDUVPDisplayObject("div");
            _s.passMainLabel_do.screen.className = 'UVP-main-label';
            _s.passLabel_do.setBackfaceVisibility();
            _s.passLabel_do.screen.className = 'fwdeap-label';
            _s.passLabel_do.getStyle().fontFamily = "Arial";
            _s.passLabel_do.getStyle().fontSize= "12px";
            _s.passLabel_do.getStyle().color = _s.secondaryLabelsColor_str;
            _s.passLabel_do.getStyle().whiteSpace= "nowrap";
    
            _s.passLabel_do.getStyle().padding = "0px";
            _s.passLabel_do.setInnerHTML("Please enter password:");
            
            _s.passInput_do = new FWDUVPDisplayObject("input");
            _s.passInput_do.screen.className = 'UVP-embed-inpt';
            _s.passInput_do.setBackfaceVisibility();
            _s.passInput_do.getStyle().fontFamily = "Arial";
            _s.passInput_do.getStyle().fontSize= "12px";
            _s.passInput_do.getStyle().backgroundColor = _s.inputBackgroundColor_str;
            _s.passInput_do.getStyle().color = _s.inputColor_str;
            _s.passInput_do.getStyle().outline = 0;
            _s.passInput_do.getStyle().whiteSpace= "nowrap";
            _s.passInput_do.getStyle().padding = "6px";
            _s.passInput_do.getStyle().paddingTop = "4px";
            _s.passInput_do.getStyle().paddingBottom = "4px";
            _s.passInput_do.screen.setAttribute("type", "password");
            
            if(!lg){
                FWDUVPSimpleSizeButton.setPrototype();
                _s.passBtn = new FWDUVPSimpleSizeButton(
                        _s.passButtonNPath_str, 
                        _s.passButtonSPath_str,
                        _s.buttonWidth,
                        _s.buttonHeight,
                        _d.useHEX,
                        _d.nBC,
                        _d.sBC,
                        true
                        );
                _s.passBtn.getStyle().position = 'absolute';
                _s.passMainLabel_do.screen.className = 'fwduvp-ok-button';
                _s.passBtn.addListener(FWDUVPSimpleSizeButton.CLICK, _s.passClickHandler);
            
                //setup close button
                FWDUVPSimpleButton.setPrototype();
                if(_s.useVectorIcons_bl){
                    _s.clsBtn = new FWDUVPSimpleButton(
                            0, 0, 0, true, 0, 0, 0,
                            "<div class='table-fwduvp-button'><span class='table-cell-fwduvp-button fwdicon-close'></span></div>",
                            undefined,
                            "UVPCloseButtonNormalState",
                            "UVPCloseButtonSelectedState"
                    );
                    _s.clsBtn.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.closeButtonOnMouseUpHandler);
                    _s.mainHld.addChild(_s.clsBtn); 
                
                }else{
                    FWDUVPSimpleButton.setPrototype();
                    _s.clsBtn = new FWDUVPSimpleButton(
                        _s.passColoseN_img, 
                        _d.embedWindowClosePathS_str, 
                        0,
                        true,
                        _d.useHEX,
                        _d.nBC,
                        _d.sBC,
                        0, 0, 0, 0, true);
                }
                _s.clsBtn.screen.className = 'fwduvp-close-button';
                _s.clsBtn.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.closeButtonOnMouseUpHandler);
                
                _s.addChild(_s.mainHld);
                _s.mainHld.addChild(_s.bk_do);
                
                _s.passMainHolder_do.addChild(_s.passMainHldBk);
                _s.passMainHolder_do.addChild(_s.passMainLabel_do);
                _s.passMainHolder_do.addChild(_s.passLabel_do);
                _s.passMainHolder_do.addChild(_s.passInput_do);
                _s.passMainHolder_do.addChild(_s.passBtn);
                _s.mainHld.addChild(_s.passMainHolder_do);
                _s.mainHld.addChild(_s.clsBtn); 
            }else{
                _s.addChild(_s.mainHld);
                _s.mainHld.addChild(_s.bk_do);
                _s.mainHld.addChild(_s.passLabel_do);
                _s.passLabel_do.getStyle().whiteSpace = "normal";
                _s.passLabel_do.getStyle().width = "calc(100% - 40px)";
                _s.passLabel_do.getStyle().textAlign = 'center';
                _s.passLabel_do.setInnerHTML(_d.playIfLoggedInMessage);

                var clsn = 'fwduvp-loggedin-message-white';
                if(_d.isDark){
                    clsn = 'fwduvp-loggedin-message-dark';
                }
                _s.passLabel_do.screen.className = clsn;
                _s.passLabel_do.setOverflow('visible');

                FWDUVPSimpleButton.setPrototype();
                if(_s.useVectorIcons_bl){
                    _s.clsBtn = new FWDUVPSimpleButton(
                            0, 0, 0, true, 0, 0, 0,
                            "<div class='table-fwduvp-button'><span class='table-cell-fwduvp-button fwdicon-close'></span></div>",
                            undefined,
                            "UVPCloseButtonNormalState",
                            "UVPCloseButtonSelectedState"
                    );
                    _s.clsBtn.screen.className = 'fwduvp-close-button';
                    _s.clsBtn.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.closeButtonOnMouseUpHandler);
                    _s.mainHld.addChild(_s.clsBtn); 
                }else{

                    var clsNImg = new Image();
                    clsNImg.src = _s.passColoseN_img.src;
                    clsNImg.onload = function(){
                        //setup close button.
                        FWDUVPSimpleButton.setPrototype();
                        _s.clsBtn = new FWDUVPSimpleButton(
                                clsNImg, 
                                _d.embedWindowClosePathS_str, 
                                undefined,
                                true,
                                _d.useHEX,
                                _d.nBC,
                                _d.sBC, 
                                0, 0, 0, 0, true);
                        _s.clsBtn.screen.className = 'fwduvp-close-button';
                        _s.clsBtn.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.closeButtonOnMouseUpHandler);
                        _s.mainHld.addChild(_s.clsBtn); 
                        clsNImg.onload = null;
                        _s.posClsBtn();
                    }
                }
            }       

            _s.posClsBtn();
        };
    
        _s.closeButtonOnMouseUpHandler = function(){
            if(!_s.isShowed_bl) return;
            _s.hide();
        };
        
    
        function selectText(){
            if(window.top != window && FWDUVPUtils.isIE) return;
            var range, selection;
            if (document.body.createTextRange) {
                range = document.body.createTextRange();
                range.moveToElementText(this);
                range.select();
            }else if(window.getSelection && document.createRange) {
                selection = window.getSelection();
                range = document.createRange();
                range.selectNodeContents(this);
                selection.removeAllRanges();
                selection.addRange(range);
            }
        };
        
        _s.positionAndResize = function(){
            _s.sW = prt.sW;
            _s.sH = prt.sH;
            
            _s.maxTextWidth = Math.min(_s.sW - 150, 300);
            _s.totalWidth = _s.maxTextWidth + _s.buttonWidth;
            
            _s.positionFinal();
            
            _s.setWidth(_s.sW);
            _s.setHeight(_s.sH);
            _s.mainHld.setWidth(_s.sW);
            _s.mainHld.setHeight(_s.sH);
        };

        _s.posClsBtn = function(){
            if(_s.clsBtn){
                _s.clsBtn.getStyle().left = 'auto';
                _s.clsBtn.getStyle().right = _s.embedWindowCloseButtonMargins + 'px';
                _s.clsBtn.getStyle().top = _s.embedWindowCloseButtonMargins + 'px';
            }
        }

        _s.positionFinal = function(){          
            var totalHeight;
            var textLableHeight = _s.passLabel_do.getHeight();
            var passMainLabelHeight;
            
            passMainLabelHeight = _s.passMainLabel_do.getHeight();

            if(!lg){
                _s.passMainLabel_do.setX(14);
                _s.passLabel_do.setX(14);
                _s.passLabel_do.setY(passMainLabelHeight + 14);
                
                _s.passInput_do.setX(10);
                _s.passInput_do.setWidth(parseInt(_s.totalWidth - 40 - _s.buttonWidth));
                _s.passInput_do.setY(_s.passLabel_do.y + textLableHeight + 5);
                _s.passBtn.setX(10 + _s.passInput_do.w + 20);
                _s.passBtn.setY(_s.passLabel_do.y + textLableHeight + 7);
                
                _s.passMainHldBk.setY(_s.passLabel_do.y - 9);
                _s.passMainHldBk.setWidth(_s.totalWidth - 2);
                _s.passMainHldBk.setHeight(_s.passBtn.y + _s.passBtn.h - 9);
                _s.passMainHolder_do.setWidth(_s.totalWidth);
                _s.passMainHolder_do.setHeight(_s.passBtn.y + _s.passBtn.h + 14);

                _s.passMainHolder_do.setX(Math.round((_s.sW - _s.totalWidth)/2));
                totalHeight = _s.passMainHldBk.getHeight();
                _s.passMainHolder_do.setY(Math.round((_s.sH - totalHeight)/2) - 10);
            }else{
                _s.passLabel_do.setX(Math.round((_s.sW - _s.passLabel_do.getWidth())/2));
                _s.passLabel_do.setY(Math.round((_s.sH - _s.passLabel_do.getHeight())/2));
            }
        };

        
        //##############################################//
        /* Send email */
        //##############################################//
        _s.passClickHandler = function(){
            
            var allow = true;
            var vidPass = prt._d.playlist_ar[prt.id]['privateVideoPassword_str'];
            var playlistPass = prt.playlistPass;

            if(playlistPass){
                if(playlistPass != FWDUVPUtils.MD5(_s.passInput_do.screen.value)){
                    allow = false;
                }else{
                    prt.plPassPassed = true;
                }
            }else if(vidPass){
                if(vidPass != FWDUVPUtils.MD5(_s.passInput_do.screen.value)){
                    allow = false;
                }
            }else{
                if(_s.privateVideoPassword_str != FWDUVPUtils.MD5(_s.passInput_do.screen.value)){
                    allow = false;
                }
            }
            if(!allow){
                if(!FWDAnimation.isTweening(_s.passInput_do.screen)) FWDAnimation.to(_s.passInput_do.screen, .1, {css:{backgroundColor:'#FF0000'}, yoyo:true, repeat:3});
                return;
            }
        
            _s.dispatchEvent(FWDUVPPassword.CORRECT);
        };
        

        //##########################################//
        /* Update HEX color of a canvaas */
        //##########################################//
        _s.updateHEXColors = function(nBC, sBC){
            _s.passBtn.updateHEXColors(nBC, sBC);
            _s.clsBtn.updateHEXColors(nBC, sBC);
        }
        

        /* show hide info */
        //#########################################//
        _s.showInfo = function(text, hasError){
                
            _s.infoText_do.setInnerHTML(text);
            _s.passMainHolder_do.addChild(_s.infoText_do);
            _s.infoText_do.setWidth(_s.buttonWidth);
            _s.infoText_do.setHeight(_s.buttonHeight - 4);
            _s.infoText_do.setX(_s.passBtn.x);
            _s.infoText_do.setY(_s.passBtn.y - 23);

            _s.infoText_do.setAlpha(0);
            if(hasError){
                _s.infoText_do.getStyle().color = "#FF0000";
            }else{
                _s.infoText_do.getStyle().color = _s.mainLabelsColor_str;
            }
            FWDAnimation.killTweensOf(_s.infoText_do);
            FWDAnimation.to(_s.infoText_do, .16, {alpha:1, yoyo:true, repeat:7});
        };

        
        //###########################################//
        /* show / hide */
        //###########################################//
        _s.show = function(id){
            if(_s.isShowed_bl) return;
            _s.isShowed_bl = true;
            prt.main_do.addChild(_s);
            _s.init();
            
            if(_s.passBtn){
                _s.passBtn.setSelectedState();
                _s.passInput_do.setInnerHTML("");
            }
            if(!FWDUVPUtils.isMobile || (FWDUVPUtils.isMobile && FWDUVPUtils.hasPointerEvent)) prt.main_do.setSelectable(true);
            _s.positionAndResize();
            
            clearTimeout(_s.hideCompleteId_to);
            clearTimeout(_s.showCompleteId_to);
            _s.mainHld.setY(- _s.sH);
            if(_s.passBtn){
                _s.passBtn.setNormalState();
            }
            _s.showCompleteId_to = setTimeout(_s.showCompleteHandler, 900);
            setTimeout(function(){
                _s.positionAndResize();
                FWDAnimation.to(_s.mainHld, .8, {y:0, delay:.1, ease:Expo.easeInOut});
            }, 100);
        };
        
        _s.showCompleteHandler = function(){};
        
        _s.hide = function(){
            if(!_s.isShowed_bl) return;
            _s.isShowed_bl = false;
            
            if(prt.customContextMenu_do) prt.customContextMenu_do.enable();
            _s.positionAndResize();
            
            clearTimeout(_s.hideCompleteId_to);
            clearTimeout(_s.showCompleteId_to);
            
            if(!FWDUVPUtils.isMobile || (FWDUVPUtils.isMobile && FWDUVPUtils.hasPointerEvent)) prt.main_do.setSelectable(false);
            _s.hideCompleteId_to = setTimeout(_s.hideCompleteHandler, 800);
            FWDAnimation.killTweensOf(_s.mainHld);
            FWDAnimation.to(_s.mainHld, .8, {y:-_s.sH, ease:Expo.easeInOut});
        };
        
        _s.hideCompleteHandler = function(){
            prt.main_do.removeChild(_s);
            _s.dispatchEvent(FWDUVPPassword.HIDE_COMPLETE);
        };
    
        if(_d.useHEX){
            _s.init();
        }
    };
    
        
    /* set prototype */
    FWDUVPPassword.setPrototype = function(){
        FWDUVPPassword.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPPassword.ERROR = "error";
    FWDUVPPassword.CORRECT = "correct";
    FWDUVPPassword.HIDE_COMPLETE = "hideComplete";
    
    FWDUVPPassword.prototype = null;
    window.FWDUVPPassword = FWDUVPPassword;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Playlist.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
    
    var FWDUVPPlaylist = function(
            prt, 
            _d
        ){

        'use strict';
        
        var _s  = this;
        var prototype = FWDUVPPlaylist.prototype;
        
        _s.prt = prt;
        _s._d = _d;
        _s.prevN_img = _d.prevN_img;
        _s.nextN_img = _d.nextN_img;
        _s.replayN_img = _d.replayN_img;
        _s.shuffleN_img = _d.shuffleN_img;
        _s.scrBkTop_img = _d.scrBkTop_img;
        _s.scrDragTop_img = _d.scrDragTop_img;
        _s.scrLinesN_img = _d.scrLinesN_img;
        _s.buttons_ar = [];

        _s.useHEX = _d.useHEX; 
        _s.nBC = _d.nBC;
        _s.sBC = _d.sBC;
        
        _s.bkPath_str = _d.controllerBkPath_str;
        _s.position_str = prt.playlistPosition_str;
        _s.playlistBackgroundColor_str = _d.playlistBackgroundColor_str;
        _s.inputBackgroundColor_str = _d.searchInputBackgroundColor_str;
        _s.inputColor_str = _d.searchInputColor_str;
        _s.prevInputValue_str = "none";
        
        _s.showOnlyThmb = _d.showOnlyThumbnail;
        _s.scrWidth = _s.scrBkTop_img.width;
        _s.mouseX = 0;
        _s.mouseY = 0;
        _s.catId = -1;
        _s.dif = 0;
        _s.countLoadedThumbs = 0;
        _s.curId = -1;
        _s.finalX = 0;
        _s.finalY = 0;
        _s.controlBarHeight = _d.controllerHeight;
        _s.totalThumbs = 0;
        _s.totalWidth = prt.playlistWidth;
        _s.totalHeight = prt.playlistHeight;
        _s.dThumbW = _s.thumbImageW = _d.thumbnailWidth;
        _s.dThumbH = _s.thumbImageH = _d.thumbnailHeight;
        _s.thumbInPadding = 3;
        _s.spaceBetweenThumbnails = _d.spaceBetweenThumbnails;
        _s.startSpaceBetweenButtons = _d.startSpaceBetweenButtons;
        _s.spaceBetweenButtons = _d.spaceBetweenButtons;
    
        _s.totalButtons = 0;
        _s.buttonsToolTipHideDelay = _d.buttonsToolTipHideDelay;
        _s.removeFromThumbsHolderHeight = 0;
        _s.totalThumbsHeight = 0;
        _s.scrollBarHandlerFinalY = 0;
        _s.sW = _s.totalWidth;
        _s.sH = _s.totalHeight;
        _s.scrollbarOffestWidth = _d.scrollbarOffestWidth;
        _s.lastThumbnailFinalY = -1;
        _s.thumbsFinalY = 0;
        _s.scollbarSpeedSensitivity = _d.scollbarSpeedSensitivity;
        _s.vy = 0;
        _s.vy2 = 0;
        _s.friction = .9;
        
        _s.showThumbnail_bl = _d.showThumbnail_bl;

        _s.showPlaylistName_bl = _d.showPlaylistName_bl;
        _s.showController_bl = _d.showSearchInpt || _d.showNextAndPrevButtons_bl || _d.showLoopButton_bl || _d.showShuffleButton_bl;
        _s.loop_bl = _d.loop_bl;
        _s.shuffle_bl = _d.shuffle_bl;
        _s.showSearchInpt = _d.showSearchInpt;
        _s.allowToScrollAndScrollBarIsActive_bl = true;
        _s.showPlaylistToolTips_bl = _d.showPlaylistToolTips_bl;
        _s.showPlaylistByDefault_bl = _d.showPlaylistByDefault_bl;
        _s.repeatBackground_bl =  _d.repeatBackground_bl;
        _s.addMouseWheelSupport_bl = _d.addMouseWheelSupport_bl;
        _s.showNextAndPrevButtons_bl = _d.showNextAndPrevButtons_bl;
        _s.showShuffleButton_bl = _d.showShuffleButton_bl;
        _s.showLoopButton_bl = _d.showLoopButton_bl;
        _s.showButtonsToolTip_bl = _d.showButtonsToolTip_bl;
        _s.isShowed_bl = true;
        _s.usePlaylistsSelectBox_bl = _d.usePlaylistsSelectBox_bl;
        _s.isMbl = FWDUVPUtils.isMobile;
        _s.addScrOnMM_bl = _d.addScrOnMM_bl;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
        _s.useVectorIcons_bl = _d.useVectorIcons_bl;
        
        _s.init = function(){
            _s.setOverflow('hidden');
            _s.screen.className = 'fwduvp-playlist';

            _s.mainHld = new FWDUVPDisplayObject("div");
            _s.mainHld.screen.className = 'fwduvp-playlist-background';

            if(_d.isWhite){
                _s.mainHld.screen.className = 'fwduvp-playlist-background white';
            }

            _s.mainHld.setBkColor(_s.playlistBackgroundColor_str);
            
            _s.mainThumbsHolder_do = new FWDUVPDisplayObject("div");
            _s.mainThumbsHolder_do.screen.className = 'fwduvp-playlist-thumbs-holder';
            _s.mainThumbsHolder_do.setBkColor(_s.playlistBackgroundColor_str);
            
            _s.thumbsHolder_do = new FWDUVPDisplayObject("div");
            _s.thumbsHolder_do.setOverflow("visible");
            _s.mainThumbsHolder_do.addChild(_s.thumbsHolder_do);
            _s.mainHld.addChild(_s.mainThumbsHolder_do);
            _s.addChild(_s.mainHld);

            
            if(_s.showController_bl){
                _s.controllBar_do = new FWDUVPDisplayObject("div");
                
                if(_s.repeatBackground_bl){
                    _s.controllerBk_do =  new FWDUVPDisplayObject("div");
                    _s.controllerBk_do.getStyle().background = "url('" + _s.bkPath_str +  "')";
                }else{
                    _s.controllerBk_do = new FWDUVPDisplayObject("img");
                    var imageBk_img = new Image();
                    imageBk_img.src = _s.bkPath_str;
                    _s.controllerBk_do.setScreen(imageBk_img);
                }
                
                _s.controllerBk_do.setHeight(_s.controlBarHeight);
                _s.controllerBk_do.getStyle().width = "100%";
                
                _s.controllBar_do.addChild(_s.controllerBk_do);
                _s.controllBar_do.setHeight(_s.controlBarHeight);
                _s.mainHld.addChild(_s.controllBar_do);
            }
            
            if(_s.showShuffleButton_bl) _s.setupShuffleButton();
            if(_s.showLoopButton_bl) _s.setupLoopButton();
            if(_s.showNextAndPrevButtons_bl){
                _s.setupPrevButton();
                _s.setupNextButton();
            }
            
            if(_s.showButtonsToolTip_bl) _s.setupToolTips();
            _s.totalButtons = _s.buttons_ar.length;
        
            if(_s.showSearchInpt && _s.showController_bl) _s.setupInput();
            
            if(_s.showController_bl){
                _s.removeFromThumbsHolderHeight = _s.controllBar_do.h + _s.spaceBetweenThumbnails;
            }
            
            _s.setupMobileScrollbar();
            if(!_s.isMbl) _s.setupScrollbar();
            if(_s.addMouseWheelSupport_bl) _s.addMouseWheelSupport();
            
            if(_s.showPlaylistName_bl){
                _s.setupPlaylistName();
                _s.removeFromThumbsHolderHeight += _s.controlBarHeight + _s.spaceBetweenThumbnails;
                _s.mainThumbsHolder_do.setY(_s.controlBarHeight + _s.spaceBetweenThumbnails);
                if(_s.scrMainHolder_do) _s.scrMainHolder_do.setY(_s.mainThumbsHolder_do.y);
            }

            var ec = prt.ec;
            if(ec){
                _s.ec = new FWDUVPDisplayObject("div", 'relative');
                _s.ec.setInnerHTML(ec.innerHTML);
                prt.main_do.addChild(_s.ec);
                _s.positionEc();
            }
            
            if(!_s.showPlaylistByDefault_bl){
                _s.hide();
            }
        };

        _s.positionEc =  function(){
            if(_s.ec){
                _s.ec.setWidth(_s.sW);
                _s.ec.setX(prt.sW - _s.sW);
                _s.ec.setY(0);
            }
        }
        
        
        //#####################################//
        /* resize and position */
        //#####################################//
        _s.resizeAndPosition = function(resizePlaylistWithAnim){
            
            if(!prt.sW) return;
            
            var offset = 0;
            if(_s.ec){
                offset = Math.round(_s.ec.getHeight());
                _s.positionEc();
            }
            
            if(_s.position_str == "bottom"){
                _s.sW = prt.sW;
                _s.sH = prt.playlistHeight;
                if(_s.showOnlyThmb){
                    _s.thumbImageW = _s.sW - _s.scrWidth;
                }
                _s.finalX = 0;
                _s.finalY = prt.tempVidStageHeight + prt.spaceBetweenControllerAndPlaylist;
            }else{
                _s.sW = _s.totalWidth;
                if(_s.showOnlyThmb){
                    _s.thumbImageW = _s.sW - _s.scrWidth;
                }
                _s.sH = prt.sH - offset;
                _s.finalX = prt.sW - _s.totalWidth;
                _s.finalY = 0;
            }
            
            if(_s.comboBox_do) _s.comboBox_do.resizeAndPosition();
            
            if(_s.bk_do){
                _s.bk_do.setWidth(_s.sW);
                _s.bk_do.setHeight(_s.sH);
            }
            
            _s.positionThumbs(resizePlaylistWithAnim);
            
            if(_s.allowToScrollAndScrollBarIsActive_bl && _s.scrMainHolder_do){
                _s.mainThumbsHolder_do.setWidth(_s.sW - _s.scrollbarOffestWidth + 1);
            }else{
                _s.mainThumbsHolder_do.setWidth(_s.sW);
            }
            _s.mainThumbsHolder_do.setHeight(_s.sH - _s.removeFromThumbsHolderHeight);
            if(_s.scrHandler_do)  _s.updateScrollBarSizeActiveAndDeactivate();
            
            if(_s.controllBar_do) _s.positionControllBar();
            _s.updateScrollBarHandlerAndContent(resizePlaylistWithAnim);

            
            _s.setWidth(_s.sW);
            _s.setHeight(_s.sH + offset);
            _s.setX(_s.finalX);
            _s.setY(_s.finalY + offset);
            _s.mainHld.setWidth(_s.sW);
            _s.mainHld.setHeight(_s.sH);
        };

        
        //#################################//
        /* update playlist */
        //#################################//
        _s.updatePlaylist = function(playlist, catId, id, playlistName){
            
            clearTimeout(_s.populateNextItemId_to);
            _s.hasPlaylist_bl = true;
            _s.catId = catId;
            _s.curId = id;
            
            _s.playlist_ar = playlist;  
            _s.countLoadedThumbs = 0;
            _s.allowToScrollAndScrollBarIsActive_bl = false;
                
            if(_s.input_do){
                _s.hasInputFocus_bl = false;
                _s.input_do.screen.value = "Search";
            }
                
            _s.setupThumbnails();
            _s.updatePlaylistName(playlistName);
            if(_s.showThumbnail_bl) _s.loadImages();
            if(_s.comboBox_do) _s.comboBox_do.setButtonsStateBasedOnId(_s.catId);

            _s.hideAndShow(true);
            _s.thumbsHolder_do.setY(0);
            _s.resizeAndPosition();

            if(_s.scrHandler_do){
                _s.updateScrollBarSizeActiveAndDeactivate();
                _s.updateScrollBarHandlerAndContent(false, true);
            }
        };
        
    
        _s.destroyPlaylist = function(){
            if(!_s.thumbs_ar) return;
            var thumb;

            _s.stopToUpdateDrag();

            _s.hasPlaylist_bl = false;
            if(_s.image_img){
                _s.image_img.onerror = null;
                _s.image_img.onload = null;
            }
            
            FWDAnimation.killTweensOf(_s.mainHld);
            if(_s.position_str == "bottom"){
                _s.mainHld.setY(-_s.sH - 5);
            }else{
                _s.mainHld.setX(-_s.sW - 5);
            }

            if(_s.ec){
                _s.ec.setX(-5000);
            }
            
            clearTimeout(_s.loadWithDelayId_to);
            for(var i=0; i<_s.totalThumbs; i++){
                thumb = _s.thumbs_ar[i];
                _s.thumbsHolder_do.removeChild(thumb);
                thumb.destroy();
            }
            _s.thumbs_ar = null;
        };

        
        //#################################################//
        /* Setup combo-box */
        //#################################################//
        _s.setupcomboBox = function(){
            _s.labels_ar = [];
            for (var i=0; i<_d.cats_ar.length; i++){
                _s.labels_ar[i] = _d.cats_ar[i].playlistName;
            }

            var settingsObj ={
                categories_ar:_s.labels_ar,
                selectorLabel:_s.labels_ar[0],
                selectorBackgroundNormalColor:_d.mainSelectorBackgroundSelectedColor,
                selectorTextNormalColor:_d.mainSelectorTextNormalColor,
                selectorTextSelectedColor:_d.mainSelectorTextSelectedColor,
                buttonBackgroundNormalColor:_d.mainButtonBackgroundNormalColor,
                buttonBackgroundSelectedColor:_d.mainButtonBackgroundSelectedColor,
                buttonTextNormalColor:_d.mainButtonTextNormalColor,
                buttonTextSelectedColor:_d.mainButtonTextSelectedColor,
                buttonHeight:_s.controlBarHeight,
                arrowN_str:_d.arrowN_str,
                arrowS_str:_d.arrowS_str,
                arrowW:11,
                arrowH:6
            }
            
            FWDUVPComboBox.setPrototype();
            _s.comboBox_do = new FWDUVPComboBox(_s, settingsObj);
            _s.comboBox_do.addListener(FWDUVPComboBox.BUTTON_PRESSED, _s.changePlaylistOnClick);
            _s.mainHld.addChild(_s.comboBox_do);
        }
        
        _s.changePlaylistOnClick = function(e){
            _s.dispatchEvent(FWDUVPPlaylist.CHANGE_PLAYLIST, {id:e.id});
        }

        
        //#################################################//
        /* Setup playlist name */
        //#################################################//
        _s.setupPlaylistName = function(){
            
            _s.playlistNameHolder_do =  new FWDUVPDisplayObject("div");
            _s.playlistNameHolder_do.setHeight(_s.controlBarHeight);
            _s.playlistNameHolder_do.getStyle().width = "100%";
    
            if(_s.repeatBackground_bl){
                _s.playlistNameBk_do =  new FWDUVPDisplayObject("div");
                _s.playlistNameBk_do.getStyle().background = "url('" + _s.bkPath_str +  "')";
            }else{
                _s.playlistNameBk_do = new FWDUVPDisplayObject("img");
                var imageBk_img = new Image();
                imageBk_img.src = _s.bkPath_str;
                _s.playlistNameBk_do.setScreen(imageBk_img);
            }
            
            _s.playlistNameBk_do.getStyle().width = "100%";
            _s.playlistNameBk_do.getStyle().height = "100%"

            _s.playlistName_do = new FWDUVPDisplayObject("div");
            _s.playlistName_do.getStyle().width = "100%";
            _s.playlistName_do.screen.className = 'fwduvp-playlist-name';
            _s.playlistName_do.getStyle().textAlign = "center";
            _s.playlistName_do.getStyle().fontSmoothing = "antialiased";
            _s.playlistName_do.getStyle().webkitFontSmoothing = "antialiased";
            _s.playlistName_do.getStyle().textRendering = "optimizeLegibility";
            _s.playlistName_do.getStyle().fontFamily = "Arial";
            _s.playlistName_do.getStyle().fontSize= "14px";
            _s.playlistName_do.getStyle().color = _d.playlistNameColor_str;
            
            _s.playlistNameHolder_do.addChild(_s.playlistNameBk_do);    
            
            if(!_s.usePlaylistsSelectBox_bl){
                _s.playlistNameHolder_do.addChild(_s.playlistName_do);
            }
            _s.mainHld.addChild(_s.playlistNameHolder_do);
            if(_s.usePlaylistsSelectBox_bl){
                _s.setupcomboBox();
                if(_s.controllBar_do){
                    _s.mainHld.addChild(_s.controllBar_do);
                }
            } 
        };
        
        _s.updatePlaylistName = function(label){
            
            if(!_s.playlistName_do) return;
            _s.playlistName_do.setInnerHTML(label);
            
            setTimeout(function(){
                _s.playlistName_do.setY(parseInt((_s.playlistNameHolder_do.h - _s.playlistName_do.getHeight())/2) + 1);
            }, 50);
        };

        
        //################################################//
        /* setup input */
        //################################################//
        _s.setupInput = function(){
            
            _s.input_do = new FWDUVPDisplayObject("input");
            _s.input_do.screen.maxLength = 20;
            _s.input_do.screen.className = 'fwduvp-search';
            _s.input_do.getStyle().textAlign = "left";
            _s.input_do.getStyle().outline = "none";
            _s.input_do.getStyle().boxShadow  = "none";
            _s.input_do.getStyle().fontFamily = "Arial";
            _s.input_do.getStyle().fontSize= "12px";
            _s.input_do.getStyle().padding =  '7px 10px 7px';
            _s.input_do.getStyle().boxSizing = 'border-box';
            if(!FWDUVPUtils.isIEAndLessThen9) _s.input_do.getStyle().paddingRight = "-6px";
            _s.input_do.getStyle().backgroundColor = _s.inputBackgroundColor_str;
            _s.input_do.getStyle().color = _s.inputColor_str;
            _s.input_do.screen.value = "Search";
            
            _s.noSearchFound_do = new FWDUVPDisplayObject("div");
            _s.noSearchFound_do.setX(0);
            _s.noSearchFound_do.screen.className = 'fwduvp-search-not-found';
            _s.noSearchFound_do.getStyle().textAlign = "center";
            _s.noSearchFound_do.getStyle().width = "100%";
            _s.noSearchFound_do.getStyle().fontFamily = "Arial";
            _s.noSearchFound_do.getStyle().fontSize= "12px";
            _s.noSearchFound_do.getStyle().color = _s.inputColor_str;
            _s.noSearchFound_do.setInnerHTML("NOTHING FOUND!");
            _s.noSearchFound_do.setVisible(false);
            _s.mainHld.addChild(_s.noSearchFound_do);
            
            if(_s.hasPointerEvent_bl){
                _s.input_do.screen.addEventListener("pointerdown", _s.inputFocusInHandler);
            }else if(_s.input_do.screen.addEventListener){
                _s.input_do.screen.addEventListener("mousedown", _s.inputFocusInHandler);
                _s.input_do.screen.addEventListener("touchstart", _s.inputFocusInHandler);
            }
            
            _s.input_do.screen.addEventListener("keyup", _s.keyUpHandler);
            
            var inputArrow_img = new Image();
            inputArrow_img.src = _d.inputArrowPath_str;
            _s.inputArrow_do = new FWDUVPDisplayObject("img"); 
            _s.inputArrow_do.setScreen(inputArrow_img);
            _s.inputArrow_do.setWidth(12);
            _s.inputArrow_do.setHeight(12);
            
            _s.controllBar_do.addChild(_s.input_do);
            _s.controllBar_do.addChild(_s.inputArrow_do);
        };
        
        _s.inputFocusInHandler = function(){
            
            if(_s.hasInputFocus_bl) return;
            
            _s.hasInputFocus_bl = true;
            
            if(_s.input_do.screen.value == "Search"){
                _s.input_do.screen.value = "";
            }
            
            _s.input_do.screen.focus();
            
            setTimeout(function(){
                if(_s.hasPointerEvent_bl){
                    window.addEventListener("pointerdown", _s.inputFocusOutHandler);
                }else if(window.addEventListener){
                    window.addEventListener("mousedown", _s.inputFocusOutHandler);
                    window.addEventListener("touchstart", _s.inputFocusOutHandler);
                }
                FWDUVPlayer.isSearchedFocused_bl = true;
            }, 50);
        };
        
        _s.inputFocusOutHandler = function(e){
            
            FWDUVPlayer.isSearchedFocused_bl = false;
            if(!_s.hasInputFocus_bl) return;
            
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            if(!FWDUVPUtils.hitTest(_s.input_do.screen, vc.screenX, vc.screenY)){
                _s.hasInputFocus_bl = false;
                if(_s.input_do.screen.value == ""){
                    _s.input_do.screen.value = "Search";
                    if(_s.hasPointerEvent_bl){
                        window.removeEventListener("pointerdown", _s.inputFocusOutHandler);
                    }else if(window.removeEventListener){
                        window.removeEventListener("mousedown", _s.inputFocusOutHandler);
                        window.removeEventListener("touchstart", _s.inputFocusOutHandler);
                    }
                }
                return;
            }
        };
        
        _s.keyUpHandler = function(e){
            if(e.stopPropagation) e.stopPropagation();
            if(_s.prevInputValue_str != _s.input_do.screen.value){
                if(_s.isMbl){
                    _s.positionThumbs(false);
                    _s.thumbsFinalY = Math.round((_s.curId/(_s.totalThumbs - 1)) * (_s.totalThumbsHeight - _s.mainThumbsHolder_do.h)) * -1;
                }else{
                    _s.positionThumbs(true);
                }
            }
            
            _s.prevInputValue_str = _s.input_do.screen.value;
            
            if(_s.scrHandler_do){
                _s.updateScrollBarSizeActiveAndDeactivate();
                _s.updateScrollBarHandlerAndContent(true, true);
            }
        };
        
        _s.showNothingFound = function(){
            if(_s.isShowNothingFound_bl) return;
            _s.isShowNothingFound_bl = true;
            
            _s.noSearchFound_do.setVisible(true);
            _s.noSearchFound_do.setY(parseInt((_s.sH - _s.noSearchFound_do.getHeight())/2));
            _s.noSearchFound_do.setAlpha(0);
            FWDAnimation.to(_s.noSearchFound_do, .1, {alpha:1, yoyo:true, repeat:4});
        };
        
        _s.hideNothingFound = function(){
            if(!_s.isShowNothingFound_bl) return;
            _s.isShowNothingFound_bl = false;
            
            FWDAnimation.killTweensOf(_s.noSearchFound_do);
            _s.noSearchFound_do.setVisible(false);
        };
        

        //##########################################//
        /* position controllbar */
        //##########################################//
        _s.positionControllBar = function(){
            
            var inputWidth;
            var button;
            var prevButton;
            
            if(_s.input_do && _s.sW <= 340){
                inputWidth = _s.sW - (_s.startSpaceBetweenButtons * 2);
                
                if(_s.nextButton_do) inputWidth -= _s.nextButton_do.w + _s.spaceBetweenButtons;
                if(_s.prevButton_do) inputWidth -= _s.prevButton_do.w + _s.spaceBetweenButtons;
                if(_s.shuffleButton_do) inputWidth -= _s.shuffleButton_do.w + _s.spaceBetweenButtons;
                if(_s.loopButton_do) inputWidth -= _s.loopButton_do.w + _s.spaceBetweenButtons;
                
                for(var i=0; i<_s.totalButtons; i++){
                    button = _s.buttons_ar[_s.totalButtons - 1 - i];
                    prevButton = _s.buttons_ar[_s.totalButtons - i];
                    if(i == 0){
                        button.setX(_s.sW - button.w - _s.startSpaceBetweenButtons);
                    }else{
                        button.setX(prevButton.x - prevButton.w - _s.spaceBetweenButtons);
                    }
                    
                    button.setY(parseInt((_s.controllBar_do.h - button.h)/2));
                }
            }else if(_s.input_do && _s.sW > 340){
                inputWidth = _s.sW - (_s.startSpaceBetweenButtons * 2) + _s.spaceBetweenButtons - 2;
                if(inputWidth > 350) inputWidth = 350;
                
                if(_s.nextButton_do)inputWidth -= _s.nextButton_do.w + _s.spaceBetweenButtons;
                if(_s.prevButton_do)inputWidth -= _s.prevButton_do.w + _s.spaceBetweenButtons;
                if(_s.shuffleButton_do) inputWidth -= _s.shuffleButton_do.w + _s.spaceBetweenButtons;
                if(_s.loopButton_do) inputWidth -= _s.loopButton_do.w + _s.spaceBetweenButtons;
                
                for(var i=0; i<_s.totalButtons; i++){
                    button = _s.buttons_ar[_s.totalButtons - 1 - i];
                    prevButton = _s.buttons_ar[_s.totalButtons - i];
                    if(i == 0){
                        button.setX(_s.sW - button.w - _s.startSpaceBetweenButtons);
                    }else{
                        button.setX(prevButton.x - prevButton.w - _s.spaceBetweenButtons);
                    }
                    
                    button.setY(parseInt((_s.controllBar_do.h - button.h)/2));
                }
            }else{
                if(_s.shuffleButton_do){
                    _s.shuffleButton_do.setX(_s.spaceBetweenButtons);
                    _s.shuffleButton_do.setY(parseInt((_s.controllBar_do.h - _s.shuffleButton_do.h)/2));
                    if(_s.loopButton_do){
                        _s.loopButton_do.setX(_s.shuffleButton_do.x + _s.shuffleButton_do.w + _s.spaceBetweenButtons);
                        _s.loopButton_do.setY(parseInt((_s.controllBar_do.h - _s.shuffleButton_do.h)/2));
                    }
                }else if(_s.loopButton_do){
                    _s.loopButton_do.setX(_s.spaceBetweenButtons);
                    _s.loopButton_do.setY(parseInt((_s.controllBar_do.h - _s.loopButton_do.h)/2));
                }
                
                if(_s.nextButton_do){
                    _s.nextButton_do.setX(_s.sW - _s.nextButton_do.w - _s.startSpaceBetweenButtons);
                    _s.nextButton_do.setY(parseInt((_s.controllBar_do.h - _s.nextButton_do.h)/2));
                    
                    _s.prevButton_do.setX(_s.nextButton_do.x - _s.nextButton_do.w - _s.spaceBetweenButtons);
                    _s.prevButton_do.setY(parseInt((_s.controllBar_do.h - _s.prevButton_do.h)/2));
                }
            }
            
            if(_s.input_do){
                _s.input_do.setWidth(inputWidth);
                _s.input_do.setX(_s.startSpaceBetweenButtons);
                _s.input_do.setY(parseInt((_s.controllBar_do.h - _s.input_do.getHeight())/2));
                _s.inputArrow_do.setX(parseInt(_s.input_do.x + _s.input_do.getWidth()) - _s.inputArrow_do.w - 7);
                _s.inputArrow_do.setY(parseInt((_s.controllBar_do.h - _s.inputArrow_do.h)/2));
            }
        
            _s.controllBar_do.setWidth(_s.sW);
            _s.controllBar_do.setY(_s.sH - _s.controllBar_do.h);
        };

        
        //################################################//
        /* Setup prev button */
        //################################################//
        _s.setupPrevButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.prevButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-FF-left'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.prevButton_do = new FWDUVPSimpleButton(_s.prevN_img, _d.prevSPath_str, undefined, true, 
                _d.useHEX,
                _d.nBC,
                _d.sBC);
            }

            _s.prevButton_do.screen.className = 'fwduvp-prev-button';
            _s.prevButton_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.prevButtonShowTooltipHandler);
            _s.prevButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.prevButtonOnMouseUpHandler);
            _s.buttons_ar.push(_s.prevButton_do);
            _s.controllBar_do.addChild(_s.prevButton_do); 
        };
        
        _s.prevButtonShowTooltipHandler = function(e){
            _s.showToolTip(_s.prevButton_do, _s.prevButtonToolTip_do, e.e);
        };
        
        _s.prevButtonOnMouseUpHandler = function(){
            _s.dispatchEvent(FWDUVPPlaylist.PLAY_PREV_VIDEO);
        };
        

        //################################################//
        /* Setup next button */
        //################################################//
        _s.setupNextButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.nextButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-FF-right'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.nextButton_do = new FWDUVPSimpleButton(_s.nextN_img, _d.nextSPath_str, undefined, true, 
                _d.useHEX,
                _d.nBC,
                _d.sBC);
            }

            _s.nextButton_do.screen.className = 'fwduvp-next-button';
            _s.nextButton_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.nextButtonShowTooltipHandler);
            _s.nextButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.nextButtonOnMouseUpHandler);
            _s.buttons_ar.push(_s.nextButton_do);
            _s.controllBar_do.addChild(_s.nextButton_do);
        };
        
        _s.nextButtonShowTooltipHandler = function(e){
            _s.showToolTip(_s.nextButton_do, _s.nextButtonToolTip_do, e.e);
        };
        
        _s.nextButtonOnMouseUpHandler = function(){
            _s.dispatchEvent(FWDUVPPlaylist.PLAY_NEXT_VIDEO);
        };
        

        //##########################################//
        /* Setup shuffle button */
        //#########################################//
        _s.setupShuffleButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.shuffleButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-shuffle'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.shuffleButton_do = new FWDUVPSimpleButton(_s.shuffleN_img, _d.shufflePathS_str, undefined, true, 
                _d.useHEX,
                _d.nBC,
                _d.sBC);
            }

            _s.shuffleButton_do.screen.className = 'fwduvp-shuffle-button';
            _s.shuffleButton_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.shuffleButtonShowToolTipHandler);
            _s.shuffleButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.shuffleButtonOnMouseUpHandler);
            _s.buttons_ar.push(_s.shuffleButton_do);
            _s.controllBar_do.addChild(_s.shuffleButton_do); 
            if(!_s.loop_bl && _s.shuffle_bl) _s.setShuffleButtonState("selected");
        };
        
        _s.shuffleButtonShowToolTipHandler = function(e){
            _s.showToolTip(_s.shuffleButton_do, _s.shuffleButtonToolTip_do, e.e);
        };
        
        _s.shuffleButtonOnMouseUpHandler = function(){
            if(_s.shuffleButton_do.isSelectedFinal_bl){
                _s.dispatchEvent(FWDUVPPlaylist.DISABLE_SHUFFLE);
            }else{
                _s.dispatchEvent(FWDUVPPlaylist.ENABLE_SHUFFLE);
            }
        };
        
        _s.setShuffleButtonState = function(state){ 
            if(!_s.shuffleButton_do) return;
            if(state == "selected"){
                _s.shuffleButton_do.setSelected();
            }else if(state == "unselected"){
                _s.shuffleButton_do.setUnselected();
            }
        };
        

        //##########################################//
        /* Setup loop button */
        //#########################################//
        _s.setupLoopButton = function(){
            if(_s.useVectorIcons_bl){
                FWDUVPSimpleButton.setPrototype();
                _s.loopButton_do = new FWDUVPSimpleButton(
                        undefined, undefined, undefined, true, undefined, undefined, undefined,
                        "<span class='fwdicon fwdicon-loop'></span>",
                        undefined,
                        "UVPMainButtonsNormalState",
                        "UVPMainButtonsSelectedState"
                );
            }else{
                FWDUVPSimpleButton.setPrototype();
                _s.loopButton_do = new FWDUVPSimpleButton(_s.replayN_img, _d.replaySPath_str, undefined, true, 
                _d.useHEX,
                _d.nBC,
                _d.sBC);
            }

            _s.loopButton_do.screen.className = 'fwduvp-loop-button';
            _s.loopButton_do.addListener(FWDUVPSimpleButton.SHOW_TOOLTIP, _s.loopButtonShowTooltipHandler);
            _s.loopButton_do.addListener(FWDUVPSimpleButton.MOUSE_UP, _s.loopButtonOnMouseUpHandler);
            _s.buttons_ar.push(_s.loopButton_do);
            _s.controllBar_do.addChild(_s.loopButton_do); 
            if(_s.loop_bl) _s.setLoopStateButton("selected");
        };
        
        
        _s.loopButtonShowTooltipHandler = function(e){
            _s.showToolTip(_s.loopButton_do, _s.loopButtonToolTip_do, e.e);
        };
        
        _s.loopButtonOnMouseUpHandler = function(){
            if(_s.loopButton_do.isSelectedFinal_bl){
                _s.dispatchEvent(FWDUVPPlaylist.DISABLE_LOOP);
            }else{
                _s.dispatchEvent(FWDUVPPlaylist.ENABLE_LOOP);
            }
        };
        
        
        _s.setLoopStateButton = function(state){
            if(!_s.loopButton_do) return;
            if(state == "selected"){
                _s.loopButton_do.setSelected();
            }else if(state == "unselected"){
                _s.loopButton_do.setUnselected();
            }
        };
        

        //################################//
        /* Setup tooltips */
        //################################//        
        _s.setupToolTips = function(){
            
            if(_s.showNextAndPrevButtons_bl){
                FWDUVPToolTip.setPrototype();
                _s.prevButtonToolTip_do = new FWDUVPToolTip(_s.prevButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "previous video", _d.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.prevButtonToolTip_do.screen);
                
                FWDUVPToolTip.setPrototype();
                _s.nextButtonToolTip_do = new FWDUVPToolTip(_s.nextButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "next video", _d.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.nextButtonToolTip_do.screen);
            }
        
            if(_s.showShuffleButton_bl){
                FWDUVPToolTip.setPrototype();
                _s.shuffleButtonToolTip_do = new FWDUVPToolTip(_s.shuffleButton_do, _d.toopTipBk_str, _d.toopTipPointer_str,  "shuffle", _d.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.shuffleButtonToolTip_do.screen);
            }
            
            if(_s.showLoopButton_bl){
                FWDUVPToolTip.setPrototype();
                _s.loopButtonToolTip_do = new FWDUVPToolTip(_s.loopButton_do, _d.toopTipBk_str, _d.toopTipPointer_str, "loop", _d.buttonsToolTipFontColor_str, _s.buttonsToolTipHideDelay);
                document.documentElement.appendChild(_s.loopButtonToolTip_do.screen);
            }
        };
        
        _s.showToolTip = function(button, toolTip, e){
            if(!_s.showButtonsToolTip_bl) return;
            var ws = FWDUVPUtils.getViewportSize();
            var wc = FWDUVPUtils.getViewportMouseCoordinates(e);
            var localX;
            var localY;
            
            if(button.screen.offsetWidth < 3){
                localX = parseInt(button.getGlobalX() * 100 + button.w/2 - toolTip.w/2);
                localY = parseInt(button.getGlobalY() * 100 - toolTip.h - 8);
            }else{
                localX = parseInt(button.getGlobalX() + button.w/2 - toolTip.w/2);
                localY = parseInt(button.getGlobalY() - toolTip.h - 8);
            }
            
            var offseX = 0;
        
            if(localX < 0){
                offseX = localX;
                localX = 0;
            }else if(localX + toolTip.w > ws.w){
                offseX = (ws.w - (localX + toolTip.w)) * -1;
                localX = localX + (offseX * -1);
            }
            
            toolTip.positionPointer(offseX, false);
            
            toolTip.setX(localX);
            toolTip.setY(localY);
            toolTip.show();
        };
        
        _s.setupThumbnails = function(){
            _s.totalThumbs = _s.playlist_ar.length;
            _s.thumbs_ar = [];
            var thumb;
            var nClr = _d.thumbnailNormalBackgroundColor_str;
            var sClr = _d.thumbnailHoverBackgroundColor_str;
            var dClr = _d.thumbnailDisabledBackgroundColor_str;
            
            if(window['isWhite']){
                nClr = '#FFFFFF';
                sClr = dClr = '#EEEEEE';
            }

            for(var i=0; i<_s.totalThumbs; i++){
                FWDUVPPlaylistThumb.setPrototype();
                thumb = new FWDUVPPlaylistThumb(
                        _s, 
                        i, 
                        _d.playlistThumbnailsBkPath_str,
                        nClr,
                        sClr,
                        dClr,
                        _s.thumbImageW,
                        _s.thumbImageH,
                        _s.thumbInPadding,
                        _s.playlist_ar[i].title,
                        _s.playlist_ar[i].titleText,
                        _s.showThumbnail_bl);
                
                _s.thumbs_ar[i] = thumb;
            
                thumb.addListener(FWDUVPPlaylistThumb.MOUSE_UP, _s.thumbMouseUpHandler);
                _s.thumbsHolder_do.addChild(thumb);
            }
        };
        
        _s.thumbMouseUpHandler = function(e){
            if(_s.disableThumbs_bl) return;
            _s.disableForAWhileAfterThumbClick_bl = true;
            clearTimeout(_s.disableForAWhileAfterThumbClickId_to);
            _s.disableForAWhileAfterThumbClickId_to = setTimeout(function(){
                _s.disableForAWhileAfterThumbClick_bl = false;
            }, 200);
            _s.dispatchEvent(FWDUVPPlaylist.THUMB_MOUSE_UP, {id:e.id});
        };
        

        //#############################################//
        /* load thumbnail images */
        //#############################################//
        _s.loadImages = function(){
            if(!_s.playlist_ar[_s.countLoadedThumbs]) return;
            if(_s.image_img){
                _s.image_img.onload = null;
                _s.image_img.onerror = null;
            }
            
            _s.image_img = new Image();
            _s.image_img.onerror = _s.onImageLoadError;
            _s.image_img.onload = _s.onImageLoadComplete;
            
            _s.image_img.src = _s.playlist_ar[_s.countLoadedThumbs].thumbSource;
        };
        
        _s.onImageLoadError = function(e){};
        
        _s.onImageLoadComplete = function(e){
            var thumb = _s.thumbs_ar[_s.countLoadedThumbs];
            thumb.setImage(_s.image_img);
            _s.countLoadedThumbs++;
            _s.loadWithDelayId_to = setTimeout(_s.loadImages, 40);  
        };
        

        //#####################################//
        /* enable disable thumbs based on id */
        //#####################################//
        _s.checkThumbsState = function(){
            if(!_s.thumbs_ar) return;
            var thumb;
            for(var i=0; i< _s.totalThumbs; i++){
                thumb = _s.thumbs_ar[i];
                if(i == _s.curId){
                    thumb.disable();
                }else{
                    thumb.enable();
                }
            };
        };
        
        _s.positionThumbs = function(animate){
            if(!_s.thumbs_ar) return;
            var thumb;
            var curX;
            var curY;
            var inputValue;
            var tmpSpaceBetwThmbs = _s.spaceBetweenThumbnails;
            var copy_ar = [].concat(_s.thumbs_ar);
            _s.isSearched_bl = false;
        
            if(_s.input_do){
                inputValue = _s.input_do.screen.value.toLowerCase();
                if(inputValue.toLowerCase() != "Search".toLowerCase()){
                    for(var i=0; i<copy_ar.length; i++){
                        thumb = copy_ar[i];
                        
                        if(thumb.htmlText_str.indexOf(inputValue) == -1){
                            FWDAnimation.killTweensOf(thumb);
                            thumb.setX(-thumb.w - 20);
                            copy_ar.splice(i, 1);
                            i--;
                        }
                    }
                }
            }
        
            var totalThumbs = copy_ar.length;
            if(_s.totalThumbs != totalThumbs) _s.isSearched_bl = true;
        
            for(var i=0; i<totalThumbs; i++){
                thumb = copy_ar[i];
                thumb.thumbImageWidth = _s.thumbImageW;
                thumb.thumbImageHeight = _s.thumbImageH;
                thumb.finalW = _s.sW;
                thumb.finalX = 0;
                thumb.finalY = i * (thumb.finalH + tmpSpaceBetwThmbs);
                thumb.resizeAndPosition(animate);
            }
            
            if(totalThumbs == 0){
                _s.showNothingFound();
            }else{
                _s.hideNothingFound();
            }
            
            if(thumb){
                _s.totalThumbsHeight = Math.max(0, totalThumbs * (thumb.h + _s.spaceBetweenThumbnails) - _s.spaceBetweenThumbnails);
                
                if(_s.totalThumbsHeight > _s.sH - _s.removeFromThumbsHolderHeight){
                    _s.allowToScrollAndScrollBarIsActive_bl = true;
                }else{
                    _s.allowToScrollAndScrollBarIsActive_bl = false;
                }
            }
        };
        
        
        //##########################################//
        /* setup mobile scrollbar */
        //##########################################//
        _s.setupMobileScrollbar = function(){
            if(!_s.isMbl) return;
            if(_s.hasPointerEvent_bl){
                _s.mainThumbsHolder_do.screen.addEventListener("pointerdown", _s.scrollBarTouchStartHandler);
            }else{
                _s.mainThumbsHolder_do.screen.addEventListener("touchstart", _s.scrollBarTouchStartHandler);
            }
        };
        
        _s.scrollBarTouchStartHandler = function(e){
            _s.isScrollingOnMove_bl = false;
            FWDAnimation.killTweensOf(_s.thumbsHolder_do);

            var vmc = FWDUVPUtils.getViewportMouseCoordinates(e);       
            _s.isDragging_bl = true;
            _s.thumbsFinalY = _s.lastThumbsFinalY = _s.thumbsHolder_do.y;
            _s.lastPresedY = _s.lastPresedY2 = vmc.screenY;
            _s.startToUpdateDrag();
        
            if(_s.hasPointerEvent_bl){
                window.addEventListener("pointerup", _s.scrollBarTouchEndHandler);
                window.addEventListener("pointermove", _s.scrollBarTouchMoveHandler);
            }else{
                window.addEventListener("touchend", _s.scrollBarTouchEndHandler);
                window.addEventListener("touchmove", _s.scrollBarTouchMoveHandler, {passive:false});
            }
        };
        
        _s.scrollBarTouchMoveHandler = function(e){
            if(e.preventDefault) e.preventDefault();
            e.stopImmediatePropagation();
            
            if(_s.totalThumbsHeight < _s.mainThumbsHolder_do.h) return;
            if(_s.comboBox_do && _s.comboBox_do.isShowed_bl) return;
            
            var vmc = FWDUVPUtils.getViewportMouseCoordinates(e);   
            var toAdd = vmc.screenY - _s.lastPresedY;
            _s.thumbsFinalY += toAdd;
            _s.thumbsFinalY = Math.round(_s.thumbsFinalY);
            var dy = vmc.screenY - _s.lastPresedY2;
            _s.lastPresedY = vmc.screenY;

            if(Math.abs(dy) > 5){
                prt.showDisable();
            }
            FWDAnimation.killTweensOf(_s.thumbsHolder_do)
            _s.thumbsHolder_do.setY(_s.thumbsFinalY);
        };
        
        _s.scrollBarTouchEndHandler = function(e){
            _s.isDragging_bl = false;
            
            clearTimeout(_s.disableOnMoveId_to);
            _s.disableOnMoveId_to = setTimeout(function(){
                prt.hideDisable();
            },50);
            if(_s.hasPointerEvent_bl){
                window.removeEventListener("pointerup", _s.scrollBarTouchEndHandler);
                window.removeEventListener("pointermove", _s.scrollBarTouchMoveHandler);
            }else{
                window.removeEventListener("touchend", _s.scrollBarTouchEndHandler);
                window.removeEventListener("touchmove", _s.scrollBarTouchMoveHandler);
            }
        };
        
        _s.stopToUpdateDrag = function(){
            FWDAnimation.killTweensOf(_s.thumbsHld_do)
            cancelAnimationFrame(_s.updateMov_af);
        }

        _s.startToUpdateDrag = function(){
            _s.stopToUpdateDrag();
            _s.updateDrag();

        }

        _s.updateDrag = function(animate){
            _s.updateMov_af = requestAnimationFrame(_s.updateDrag);

            if(_s.isDragging_bl){
                _s.vy = _s.thumbsFinalY - _s.lastThumbsFinalY;
                _s.lastThumbsFinalY = _s.thumbsFinalY;  
                if(Math.abs(_s.vy) < 20){
                    _s.vy = 0;
                }
            }else{
                _s.vy *= _s.friction;       
                _s.thumbsFinalY += _s.vy;
                if(_s.mainThumbsHolder_do.h <= _s.totalThumbsHeight){
                    if(_s.thumbsFinalY > 0){
                        _s.vy2 = (0 - _s.thumbsFinalY) * .3;
                        _s.vy *= _s.friction;
                        _s.thumbsFinalY += _s.vy2;
                    }else if(_s.thumbsFinalY <= _s.mainThumbsHolder_do.h - _s.totalThumbsHeight){
                        _s.vy2 = (_s.mainThumbsHolder_do.h - _s.totalThumbsHeight - _s.thumbsFinalY) * .3;
                        _s.vy *= _s.friction;
                        _s.thumbsFinalY += _s.vy2;
                    }
                }

                _s.thumbsFinalY = parseFloat(_s.thumbsFinalY.toFixed(2));               
                if(_s.prevThumbsFinalY == _s.thumbsFinalY){
                    _s.stopToUpdateDrag();
                    _s.thumbsFinalY = Math.round(_s.thumbsFinalY);
                }

                FWDAnimation.killTweensOf(_s.thumbsHolder_do);
                _s.thumbsHolder_do.setY(_s.thumbsFinalY);
                _s.prevThumbsFinalY = _s.thumbsFinalY;
            }
        };
        
        //#################################//
        /* setup mouse scrollbar */
        //#################################//
        _s.setupScrollbar = function(){
            _s.scrMainHolder_do = new FWDUVPDisplayObject("div");
            _s.scrMainHolder_do.setWidth(_s.scrWidth);
            
            //track
            _s.scrTrack_do = new FWDUVPDisplayObject("div");
            _s.scrTrack_do.setWidth(_s.scrWidth);
            _s.scrTrackTop_do = new FWDUVPDisplayObject("img");
            _s.scrTrackTop_do.setScreen(_s.scrBkTop_img);
            _s.scrTrackMiddle_do = new FWDUVPDisplayObject("div");
            _s.scrTrackMiddle_do.getStyle().background = "url('" + _d.scrBkMiddlePath_str + "')";
            _s.scrTrackMiddle_do.setWidth(_s.scrWidth);
            _s.scrTrackMiddle_do.setY(_s.scrTrackTop_do.h);
            var scrTrackBottomImage_img = new Image();
            scrTrackBottomImage_img.src = _d.scrBkBottomPath_str;
            _s.scrTrackBottom_do = new FWDUVPDisplayObject("img");
            _s.scrTrackBottom_do.setScreen(scrTrackBottomImage_img);
            _s.scrTrackBottom_do.setWidth(_s.scrTrackTop_do.w);
            _s.scrTrackBottom_do.setHeight(_s.scrTrackTop_do.h);
            
            //handler
            _s.scrHandler_do = new FWDUVPDisplayObject("div");
            _s.scrHandler_do.setWidth(_s.scrWidth);
            
            _s.scrHandlerTop_do = new FWDUVPDisplayObject("img");
            if(_s.useHEX){
                _s.scrHandlerTop_do = new FWDUVPDisplayObject("div");
                _s.scrHandlerTop_do.setWidth(_s.scrDragTop_img.width);
                _s.scrHandlerTop_do.setHeight(_s.scrDragTop_img.height);
                _s.mainScrubberDragTop_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.scrDragTop_img, _s.nBC).canvas;
                _s.scrHandlerTop_do.screen.appendChild(_s.mainScrubberDragTop_canvas);  
            }else{
                _s.scrHandlerTop_do = new FWDUVPDisplayObject("img");
                _s.scrHandlerTop_do.setScreen(_s.scrDragTop_img);
            }
        
            _s.scrHandlerMiddle_do = new FWDUVPDisplayObject("div");
            _s.middleImage = new Image();
            _s.middleImage.src = _d.scrDragMiddlePath_str;
            if(_s.useHEX){
                _s.middleImage.onload = function(){
                    _s.scrubberDragMiddle_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.middleImage, _s.nBC, true);
                    _s.scrubberDragImage_img = _s.scrubberDragMiddle_canvas.image;
                    _s.scrHandlerMiddle_do.getStyle().background = "url('" + _s.scrubberDragImage_img.src + "') repeat-y";
                }
            }else{
                _s.scrHandlerMiddle_do.getStyle().background = "url('" + _d.scrDragMiddlePath_str + "')";
            }
            _s.scrHandlerMiddle_do.setWidth(_s.scrWidth);
            _s.scrHandlerMiddle_do.setY(_s.scrHandlerTop_do.h);
            
            _s.scrHandlerBottom_do = new FWDUVPDisplayObject("div");
            _s.bottomImage = new Image();
            _s.bottomImage.src = _d.scrDragMiddlePath_str;
            if(_s.useHEX){
                _s.bottomImage.onload = function(){
                    _s.scrubberDragBottom_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.bottomImage, _s.nBC, true);
                    _s.scrubberDragBottomImage_img = _s.scrubberDragBottom_canvas.image;
                    _s.scrHandlerBottom_do.getStyle().background = "url('" + _s.scrubberDragBottomImage_img.src + "') repeat-y";
                    
                }
            }else{
                _s.scrHandlerBottom_do.getStyle().background = "url('" + _d.scrDragBottomPath_str + "')";
            }
            _s.scrHandlerBottom_do.setWidth(_s.scrWidth);
            _s.scrHandlerBottom_do.setY(_s.scrHandlerTop_do.h);
            
            _s.scrHandlerBottom_do.setWidth(_s.scrHandlerTop_do.w);
            _s.scrHandlerBottom_do.setHeight(_s.scrHandlerTop_do.h);
            
            if(_s.useHEX){
                _s.scrHandlerLinesN_do = new FWDUVPDisplayObject("div");
                _s.scrHandlerLinesN_do.setWidth(_s.scrLinesN_img.width);
                _s.scrHandlerLinesN_do.setHeight(_s.scrLinesN_img.height);
                _s.mainhandlerN_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.scrLinesN_img, _s.sBC).canvas;
                _s.scrHandlerLinesN_do.screen.appendChild(_s.mainhandlerN_canvas);  
            }else{
                _s.scrHandlerLinesN_do = new FWDUVPDisplayObject("img");
                _s.scrHandlerLinesN_do.setScreen(_s.scrLinesN_img);
            }
            
            _s.scrHandlerLinesS_img = new Image();
            _s.scrHandlerLinesS_img.src = _d.scrLinesSPath_str;
            if(_s.useHEX){
                _s.scrHandlerLinesS_do = new FWDUVPDisplayObject("div");
                _s.scrHandlerLinesS_img.onload = function(){
                    _s.scrHandlerLinesS_do.setWidth(_s.scrHandlerLinesN_do.w);
                    _s.scrHandlerLinesS_do.setHeight(_s.scrHandlerLinesN_do.h);
                    _s.scrubberLines_s_canvas = FWDUVPUtils.getCanvasWithModifiedColor(_s.scrHandlerLinesS_img, _s.sBC, true);
                    _s.scrubbelinesSImage_img = _s.scrubberLines_s_canvas.image;
                    _s.scrHandlerLinesS_do.getStyle().background = "url('" + _s.scrubbelinesSImage_img.src + "') repeat-y";
                }
            }else{
                _s.scrHandlerLinesS_do = new FWDUVPDisplayObject("img");
                _s.scrHandlerLinesS_do.setScreen(_s.scrHandlerLinesS_img);
                _s.scrHandlerLinesS_do.setWidth(_s.scrHandlerLinesN_do.w);
                _s.scrHandlerLinesS_do.setHeight(_s.scrHandlerLinesN_do.h);
            }
            _s.scrHandlerLinesS_do.setAlpha(0);
            
            _s.scrHandlerLines_do = new FWDUVPDisplayObject("div");
            _s.scrHandlerLines_do.setWidth(_s.scrHandlerLinesN_do.w);
            _s.scrHandlerLines_do.setHeight(_s.scrHandlerLinesN_do.h);
        
            _s.scrTrack_do.addChild(_s.scrTrackTop_do);
            _s.scrTrack_do.addChild(_s.scrTrackMiddle_do);
            _s.scrTrack_do.addChild(_s.scrTrackBottom_do);
            _s.scrHandler_do.addChild(_s.scrHandlerTop_do);
            _s.scrHandler_do.addChild(_s.scrHandlerMiddle_do);
            _s.scrHandler_do.addChild(_s.scrHandlerBottom_do);
            _s.scrHandlerLines_do.addChild(_s.scrHandlerLinesN_do);
            _s.scrHandlerLines_do.addChild(_s.scrHandlerLinesS_do);
            _s.scrMainHolder_do.addChild(_s.scrTrack_do);
            _s.scrMainHolder_do.addChild(_s.scrHandler_do);
            _s.scrMainHolder_do.addChild(_s.scrHandlerLines_do);
            _s.mainHld.addChild(_s.scrMainHolder_do);
            
            _s.scrHandler_do.screen.addEventListener("mouseover", _s.scrollBarHandlerOnMouseOver);
            _s.scrHandler_do.screen.addEventListener("mouseout", _s.scrollBarHandlerOnMouseOut);
            _s.scrHandler_do.screen.addEventListener("mousedown", _s.scrollBarHandlerOnMouseDown);
            _s.scrHandlerLines_do.screen.addEventListener("mouseover", _s.scrollBarHandlerOnMouseOver);
            _s.scrHandlerLines_do.screen.addEventListener("mouseout", _s.scrollBarHandlerOnMouseOut);
            _s.scrHandlerLines_do.screen.addEventListener("mousedown", _s.scrollBarHandlerOnMouseDown);
            
            if(_s.addScrOnMM_bl){
                window.addEventListener('mousemove', _s.scrOnMM);
            }
        };

        _s.scrOnMM = function(e){
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            if(FWDUVPUtils.hitTest(_s.mainThumbsHolder_do.screen, vc.screenX, vc.screenY)){
                _s.isDragging_bl = true;
                _s.scrollBarHandlerMoveHandler(e);
            }else{
                _s.isDragging_bl = false;
            }
        }
        
        _s.scrollBarHandlerOnMouseOver = function(e){
            if(!_s.allowToScrollAndScrollBarIsActive_bl || _s.addScrOnMM_bl) return; 
            FWDAnimation.killTweensOf(_s.scrHandlerLinesN_do);
            FWDAnimation.killTweensOf(_s.scrHandlerLinesS_do);
            FWDAnimation.to(_s.scrHandlerLinesN_do, .8, {alpha:0, ease:Expo.easeOut});
            FWDAnimation.to(_s.scrHandlerLinesS_do, .8, {alpha:1, ease:Expo.easeOut});
        };
        
        _s.scrollBarHandlerOnMouseOut = function(e){
            if(_s.isDragging_bl || !_s.allowToScrollAndScrollBarIsActive_bl) return;
            FWDAnimation.killTweensOf(_s.scrHandlerLinesN_do);
            FWDAnimation.killTweensOf(_s.scrHandlerLinesS_do);
            FWDAnimation.to(_s.scrHandlerLinesN_do, .8, {alpha:1, ease:Expo.easeOut});
            FWDAnimation.to(_s.scrHandlerLinesS_do, .8, {alpha:0, ease:Expo.easeOut});
        };
        
        _s.scrollBarHandlerOnMouseDown = function(e){
            if(!_s.allowToScrollAndScrollBarIsActive_bl || _s.addScrOnMM_bl) return;
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);        
            _s.isDragging_bl = true;
            _s.yPositionOnPress = _s.scrHandler_do.y;
            _s.lastPresedY = vc.screenY;
            FWDAnimation.killTweensOf(_s.scrHandler_do);
            prt.showDisable();
            
            if(window.addEventListener){
                window.addEventListener("mousemove", _s.scrollBarHandlerMoveHandler);
                window.addEventListener("mouseup", _s.scrollBarHandlerEndHandler);  
            }
        };
        
        _s.scrollBarHandlerMoveHandler = function(e){
            if(e.preventDefault) e.preventDefault();
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            var linesY = _s.scrollBarHandlerFinalY + parseInt((_s.scrHandler_do.h - _s.scrHandlerLines_do.h)/2);
            if(_s.addScrOnMM_bl){
                _s.scrollBarHandlerFinalY = Math.round(vc.screenY - _s.mainThumbsHolder_do.getGlobalY() - _s.scrHandler_do.h/2);
            }else{
                _s.scrollBarHandlerFinalY = Math.round(_s.yPositionOnPress + vc.screenY - _s.lastPresedY);
            }
            
            if(_s.scrollBarHandlerFinalY >= _s.scrTrack_do.h - _s.scrHandler_do.h){
                _s.scrollBarHandlerFinalY = _s.scrTrack_do.h -  _s.scrHandler_do.h;
            }else if(_s.scrollBarHandlerFinalY <= 0){
                _s.scrollBarHandlerFinalY = 0;
            }
            
            _s.scrHandler_do.setY(_s.scrollBarHandlerFinalY);
            FWDAnimation.killTweensOf(_s.scrHandler_do);
            FWDAnimation.to(_s.scrHandlerLines_do, .8, {y:linesY, ease:Quart.easeOut});
            _s.updateScrollBarHandlerAndContent(true);
        };
        
        _s.scrollBarHandlerEndHandler = function(e){
            var vc = FWDUVPUtils.getViewportMouseCoordinates(e);    
            _s.isDragging_bl = false;
            
            if(!FWDUVPUtils.hitTest(_s.scrHandler_do.screen, vc.screenX, vc.screenY)){
                FWDAnimation.killTweensOf(_s.scrHandlerLinesN_do);
                FWDAnimation.killTweensOf(_s.scrHandlerLinesS_do);
                FWDAnimation.to(_s.scrHandlerLinesN_do, .8, {alpha:1, ease:Expo.easeOut});
                FWDAnimation.to(_s.scrHandlerLinesS_do, .8, {alpha:0, ease:Expo.easeOut});
            }
        
            prt.hideDisable();
            FWDAnimation.killTweensOf(_s.scrHandler_do);
            FWDAnimation.to(_s.scrHandler_do, .4, {y:_s.scrollBarHandlerFinalY, ease:Quart.easeOut});
            
            if(window.removeEventListener){
                window.removeEventListener("mousemove", _s.scrollBarHandlerMoveHandler);
                window.removeEventListener("mouseup", _s.scrollBarHandlerEndHandler);   
            }
        };
        
        _s.updateScrollBarSizeActiveAndDeactivate = function(){
            if(_s.disableForAWhileAfterThumbClick_bl) return;
            if(_s.allowToScrollAndScrollBarIsActive_bl){
                _s.allowToScrollAndScrollBarIsActive_bl = true;
                _s.scrMainHolder_do.setX(_s.sW - _s.scrMainHolder_do.w);
                _s.scrMainHolder_do.setHeight(_s.sH - _s.removeFromThumbsHolderHeight);
                _s.scrTrack_do.setHeight(_s.scrMainHolder_do.h);
                _s.scrTrackMiddle_do.setHeight(_s.scrTrack_do.h - (_s.scrTrackTop_do.h * 2));
                _s.scrTrackBottom_do.setY(_s.scrTrackMiddle_do.y + _s.scrTrackMiddle_do.h);
                _s.scrMainHolder_do.setAlpha(1);
                if(!_s.addScrOnMM_bl){
                    _s.scrHandler_do.setButtonMode(true);
                    _s.scrHandlerLines_do.setButtonMode(true);
                }
            }else{
                _s.allowToScrollAndScrollBarIsActive_bl = false;
                _s.scrMainHolder_do.setX(_s.sW - _s.scrMainHolder_do.w);
                _s.scrMainHolder_do.setHeight(_s.sH - _s.removeFromThumbsHolderHeight);
                _s.scrTrack_do.setHeight(_s.scrMainHolder_do.h);
                _s.scrTrackMiddle_do.setHeight(_s.scrTrack_do.h - (_s.scrTrackTop_do.h * 2));
                _s.scrTrackBottom_do.setY(_s.scrTrackMiddle_do.y + _s.scrTrackMiddle_do.h);
                _s.scrMainHolder_do.setAlpha(.5);
                _s.scrHandler_do.setY(0);
                _s.scrHandler_do.setButtonMode(false);
                _s.scrHandlerLines_do.setButtonMode(false);
            }
            
            _s.scrHandler_do.setHeight(Math.max(120, Math.round(Math.min(1,(_s.scrMainHolder_do.h/_s.totalThumbsHeight)) * _s.scrMainHolder_do.h)));
            _s.scrHandlerMiddle_do.setHeight(_s.scrHandler_do.h - (_s.scrHandlerTop_do.h * 2));
            _s.scrHandlerBottom_do.setY(_s.scrHandlerMiddle_do.y + _s.scrHandlerMiddle_do.h);
            FWDAnimation.killTweensOf(_s.scrHandlerLines_do);
            _s.scrHandlerLines_do.setY(_s.scrollBarHandlerFinalY + parseInt((_s.scrHandler_do.h - _s.scrHandlerLines_do.h)/2));
            _s.scrHandlerBottom_do.setY(_s.scrHandler_do.h - _s.scrHandlerBottom_do.h);
        };
        
        _s.updateScrollBarHandlerAndContent = function(animate, overwrite){

            if(_s.isMbl && _s.disableForAWhileAfterThumbClick_bl) return;
            if(!_s.allowToScrollAndScrollBarIsActive_bl && !overwrite) return;

            var percentScrolled = 0;
            var thumb;
            
            if(_s.isDragging_bl && !_s.isMbl){
                percentScrolled = (_s.scrollBarHandlerFinalY/(_s.scrMainHolder_do.h - _s.scrHandler_do.h));
                if(percentScrolled == "Infinity"){
                    percentScrolled = 0;
                }else if(percentScrolled >= 1){
                    percentScrolled = 1;
                }
                _s.thumbsFinalY = Math.round(percentScrolled * (_s.totalThumbsHeight - _s.mainThumbsHolder_do.h)) * -1;
            }else{
                if(_s.isSearched_bl){
                    _s.percentScrolled = 0;
                    percentScrolled = 0;
                }else{
                    percentScrolled = _s.curId/(_s.totalThumbs - 1);
                }
                
                _s.thumbsFinalY = Math.min(0, Math.round(percentScrolled * (_s.totalThumbsHeight - _s.mainThumbsHolder_do.h)) * -1);
                
                if(_s.scrMainHolder_do){
                    _s.scrollBarHandlerFinalY = Math.round((_s.scrMainHolder_do.h - _s.scrHandler_do.h) * percentScrolled);
                    
                    if(_s.scrollBarHandlerFinalY < 0){
                        _s.scrollBarHandlerFinalY = 0;
                    }else if(_s.scrollBarHandlerFinalY > _s.scrMainHolder_do.h - _s.scrHandler_do.h - 1){
                        _s.scrollBarHandlerFinalY = _s.scrMainHolder_do.h - _s.scrHandler_do.h - 1;
                    }
                    
                    FWDAnimation.killTweensOf(_s.scrHandler_do);
                    FWDAnimation.killTweensOf(_s.scrHandlerLines_do);
                    if(animate){
                        FWDAnimation.to(_s.scrHandler_do, .4, {y:_s.scrollBarHandlerFinalY, ease:Quart.easeOut});
                        FWDAnimation.to(_s.scrHandlerLines_do, .8, {y:_s.scrollBarHandlerFinalY + parseInt((_s.scrHandler_do.h - _s.scrHandlerLinesN_do.h)/2), ease:Quart.easeOut});
                    }else{
                        _s.scrHandler_do.setY(_s.scrollBarHandlerFinalY);
                        _s.scrHandlerLines_do.setY(_s.scrollBarHandlerFinalY + parseInt((_s.scrHandler_do.h - _s.scrHandlerLinesN_do.h)/2));
                    }
                }
            }
            
            if(_s.lastThumbnailFinalY != _s.thumbsFinalY){
                FWDAnimation.killTweensOf(_s.thumbsHolder_do);
                if(animate){
                    FWDAnimation.to(_s.thumbsHolder_do, .5, {y:_s.thumbsFinalY, ease:Quart.easeOut});
                }else{
                    _s.thumbsHolder_do.setY(_s.thumbsFinalY);
                }
            }
            
            _s.lastThumbnailFinalY = _s.thumbsFinalY;
        };

        
        //###########################################//
        /* Add mousewheel support */
        //###########################################//
        _s.addMouseWheelSupport = function(){
            if(_s.screen.addEventListener){
                _s.screen.addEventListener('DOMMouseScroll', _s.mouseWheelHandler);
                _s.screen.addEventListener ("mousewheel", _s.mouseWheelHandler);
            }
        };
        
        _s.mouseWheelHandler = function(e){
            if(e.preventDefault) e.preventDefault();
            if(_s.disableMouseWheel_bl || _s.isDragging_bl) return false;
            if(_s.comboBox_do && _s.comboBox_do.isShowed_bl) return;
            
            var dir = e.detail || e.wheelDelta; 
            if(e.wheelDelta) dir *= -1;
        
            if(dir > 0){
                _s.scrollBarHandlerFinalY += Math.round((160 * _s.scollbarSpeedSensitivity)  * (_s.mainThumbsHolder_do.h/_s.totalThumbsHeight));
            }else if(dir < 0){
                _s.scrollBarHandlerFinalY -= Math.round((160 * _s.scollbarSpeedSensitivity)  * (_s.mainThumbsHolder_do.h/_s.totalThumbsHeight));
            }
            
            if(_s.scrollBarHandlerFinalY >= _s.scrTrack_do.h - _s.scrHandler_do.h){
                _s.scrollBarHandlerFinalY = _s.scrTrack_do.h -  _s.scrHandler_do.h;
            }else if(_s.scrollBarHandlerFinalY <= 0){
                _s.scrollBarHandlerFinalY = 0;
            }
            
            var linesY = _s.scrollBarHandlerFinalY + parseInt((_s.scrHandler_do.h - _s.scrHandlerLines_do.h)/2);
            FWDAnimation.killTweensOf(_s.scrHandler_do);
            FWDAnimation.killTweensOf(_s.scrHandlerLines_do);
            FWDAnimation.to(_s.scrHandlerLines_do, .8, {y:linesY, ease:Quart.easeOut});
            FWDAnimation.to(_s.scrHandler_do, .5, {y:_s.scrollBarHandlerFinalY, ease:Quart.easeOut});
            _s.isDragging_bl = true;
            _s.updateScrollBarHandlerAndContent(true);
            _s.isDragging_bl = false;
        
            if(e.preventDefault){
                e.preventDefault();
            }else{
                return false;
            }
        };

        
        //################################//
        /* show / hide */
        //################################//
        _s.hideAndShow = function(animate){
            if(_s.position_str == "bottom"){
                _s.mainHld.setY(-_s.sH);
                FWDAnimation.to(_s.mainHld, .8, {y:0, delay: .3, ease:Expo.easeInOut});
            }else{
                _s.mainHld.setX(-_s.sW - 2);
                FWDAnimation.to(_s.mainHld, .8, {x:0, delay: .3, ease:Expo.easeInOut});
                if(_s.ec){
                    _s.positionEc();
                    _s.ec.setAlpha(0);
                    FWDAnimation.to(_s.ec, .8, {alpha:1, delay: .3, ease:Expo.easeInOut});
                }
            }
        };
        
        _s.hide = function(animate){
        
            _s.isShowed_bl = false;
            if(animate){
                if(_s.position_str == "bottom"){
                    FWDAnimation.to(_s.mainHld, .8, {y: -_s.sH, ease:Expo.easeInOut});
                }
            }else{
                FWDAnimation.killTweensOf(_s.mainHld);
                if(_s.position_str == "bottom"){
                    _s.mainHld.setY(-_s.sH);
                }
            }
        };
        
        _s.show = function(animate){

            _s.isShowed_bl = true;
            if(!FWDAnimation.isTweening(_s.mainHld)) _s.hide(false);
            if(animate){
                if(_s.position_str == "bottom"){
                    FWDAnimation.to(_s.mainHld, .8, {y:0, ease:Expo.easeInOut});
                }else{
                    _s.mainHld.setY(0);
                }
            }else{
                FWDAnimation.killTweensOf(_s.mainHld);
                _s.mainHld.setX(0);
                _s.mainHld.setY(0);
                clearTimeout(_s.disableThumbsId_to);
                _s.disableThumbsId_to =  setTimeout(function(){_s.disableThumbs_bl = false;}, 200);
                _s.disableThumbs_bl = true;
            }
        };
    
        _s.init();
    };
    
    
    /* set prototype */
    FWDUVPPlaylist.setPrototype = function(){
        FWDUVPPlaylist.prototype = new FWDUVPDisplayObject("div", "absolute", "visible");
    };
    
    FWDUVPPlaylist.THUMB_MOUSE_UP = "thumbMouseOut";
    FWDUVPPlaylist.PLAY_PREV_VIDEO = "playPrevVideo";
    FWDUVPPlaylist.PLAY_NEXT_VIDEO = "playNextVideo";
    FWDUVPPlaylist.DISABLE_LOOP = "disableLoop";
    FWDUVPPlaylist.ENABLE_LOOP = "enableLoop";
    FWDUVPPlaylist.DISABLE_SHUFFLE = "disableShuffle";
    FWDUVPPlaylist.ENABLE_SHUFFLE = "enableShuffle";
    FWDUVPPlaylist.CHANGE_PLAYLIST = "changePlaylist";
    
    FWDUVPPlaylist.prototype = null;
    window.FWDUVPPlaylist = FWDUVPPlaylist;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Playlist thumb.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (window){
    var FWDUVPPlaylistThumb = function(
            prt,
            pId, 
            backgroundImagePath,
            thumbnailNormalBackgroundColor,
            thumbnailHoverBackgroundColor,
            thumbnailDisabledBackgroundColor,
            thumbImageWidth,
            thumbImageHeight,
            padding,
            htmlContent,
            htmlText,
            showThumbnail_bl
        ){
        
        'use strict';

        var _s = this;
        var prototype = FWDUVPPlaylistThumb.prototype;
    
        _s.backgroundImagePath_str = backgroundImagePath;
        _s.thumbnailNormalBackgroundColor_str = thumbnailNormalBackgroundColor;
        _s.thumbnailHoverBackgroundColor_str = thumbnailHoverBackgroundColor;
        _s.thumbnailDisabledBackgroundColor_str = thumbnailDisabledBackgroundColor;
        _s.htmlContent_str = htmlContent;
        _s.htmlText_str = htmlText.toLowerCase();
        _s.curStt = "none";
    
        _s.id = pId;
        _s.padding = padding;
        _s.thumbImageWidth = thumbImageWidth;
        _s.thumbImageHeight = thumbImageHeight;
        _s.finalH = _s.padding * 2 + _s.thumbImageHeight;
    
        _s.isDark = true;
        if(backgroundImagePath.indexOf('dark') == -1){
            _s.isDark = false;
        }
    
        _s.hasCanvas_bl = FWDUVPlayer.hasCanvas;
        _s.isMbl = FWDUVPUtils.isMobile;
        _s.hasPointerEvent_bl = FWDUVPUtils.hasPointerEvent;
        _s.showThumbnail_bl = showThumbnail_bl;


        //#################################//
        /* initialize */
        //#################################//
        _s.init = function(){
            _s.setupMainContainers();
            
            _s.setButtonMode(true);
            _s.setNormalState();
            
            if(_s.hasPointerEvent_bl){
                _s.screen.addEventListener("pointerover", _s.onMouseOver);
                _s.screen.addEventListener("pointerout", _s.onMouseOut);
                _s.screen.addEventListener("pointerup", _s.onMouseUp);
            }else if(_s.screen.addEventListener){   
                _s.screen.addEventListener("mouseover", _s.onMouseOver);
                _s.screen.addEventListener("mouseout", _s.onMouseOut);
                _s.screen.addEventListener("click", _s.onMouseUp);
            }
        };
        
        _s.onMouseUp = function(e){
            if(_s.isDisabled_bl || e.button == 2) return;
            if(e.preventDefault) e.preventDefault();
            _s.dispatchEvent(FWDUVPPlaylistThumb.MOUSE_UP, {id:_s.id});
        };
        
        _s.onMouseOver = function(e){
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE){
                if(_s.isDisabled_bl) return;
                _s.setSelectedState(true);
            }
        };
            
        _s.onMouseOut = function(e){
            if(!e.pointerType || e.pointerType == e.MSPOINTER_TYPE_MOUSE){
                if(_s.isDisabled_bl) return;
                _s.setNormalState(true);
            }
        };
        

        //#################################//
        /* set image */
        //#################################//
        _s.setupMainContainers = function(){

            _s.mainImgHld = new FWDUVPDisplayObject("div");
            _s.mainImgHld.screen.className = 'fwduvp-playlist-thumbnail';
            _s.mainImgHld.getStyle().background = "url('" + _s.backgroundImagePath_str + "')";
            _s.mainImgHld.setX(_s.padding);
            _s.mainImgHld.setY(_s.padding);
            _s.mainImgHld.setWidth(_s.thumbImageWidth);
            _s.mainImgHld.setHeight(_s.thumbImageHeight);
            _s.imageHolder_do = new FWDUVPDisplayObject("div");
            
            _s.txt = new FWDUVPDisplayObject("div");
            var cls = 'fwduvp-playlist-thumbnail-white-text';
            if(_s.isDark){
                cls = 'fwduvp-playlist-thumbnail-dark-text';
            }
            _s.txt.screen.className = cls;
            _s.txt.hasTransform3d_bl = false;
            _s.txt.hasTransform2d_bl = false;
            _s.txt.setHeight(_s.finalH - 6);
            _s.txt.setBackfaceVisibility();
            _s.txt.getStyle().fontFamily = "Arial";
            _s.txt.getStyle().fontSize= "12px";
            _s.txt.getStyle().color = _s.fontColor_str;
            _s.txt.getStyle().fontSmoothing = "antialiased";
            _s.txt.getStyle().webkitFontSmoothing = "antialiased";
            _s.txt.getStyle().textRendering = "optimizeLegibility";
            
            _s.slTitle = _s.txt.screen.className;
            
            if(_s.showThumbnail_bl){
                _s.txt.setX((_s.padding * 2) + _s.thumbImageWidth + 4);
            }else{
                _s.txt.setX((_s.padding * 2));
            }
        
            _s.txt.setInnerHTML(_s.htmlContent_str);    
            if(!prt.showOnlyThmb) _s.addChild(_s.txt);
            
            _s.dumy_do = new FWDUVPDisplayObject("div");
            _s.dumy_do.getStyle().width = "100%";
            _s.dumy_do.getStyle().height = "100%";
            if(FWDUVPUtils.isIE){
                _s.dumy_do.setBkColor("#FF0000");
                _s.dumy_do.setAlpha(0.01);
            }
        
            if(_s.showThumbnail_bl) _s.addChild(_s.mainImgHld);     
            _s.mainImgHld.addChild(_s.imageHolder_do);
            _s.addChild(_s.dumy_do);
        };
        
        _s.updateText = function(htmlContent_str){
            try{
                _s.htmlContent_str = htmlContent_str;
                _s.txt.setInnerHTML(_s.htmlContent_str);
            }catch(e){}
        }

    
        //#################################//
        /* set image */
        //#################################//
        _s.setImage = function(image){
            _s.normalImage_do = new FWDUVPDisplayObject("img");
            _s.normalImage_do.setScreen(image);
            
            _s.imageOriginalW = _s.normalImage_do.w;
            _s.imageOriginalH = _s.normalImage_do.h;
        
            _s.resizeImage();
            
            _s.imageHolder_do.setX(parseInt(_s.thumbImageWidth/2));
            _s.imageHolder_do.setY(parseInt(_s.thumbImageHeight/2));
            _s.imageHolder_do.setWidth(0);
            _s.imageHolder_do.setHeight(0);
            
            _s.normalImage_do.setX(- parseInt(_s.normalImage_do.w/2));
            _s.normalImage_do.setY(- parseInt(_s.normalImage_do.h/2));
        
            FWDAnimation.to(_s.imageHolder_do, .8, {
                x:0, 
                y:0,
                w:_s.thumbImageWidth,
                h:_s.thumbImageHeight, 
                ease:Expo.easeInOut});
            _s.normalImage_do.setAlpha(0);
            
            if(_s.isMbl){
                var curAlpha;
                if(_s.id == prt.curId){
                    curAlpha = .3;
                }else{
                    curAlpha = 1;
                }
            
                FWDAnimation.to(_s.normalImage_do, .8, {
                    alpha:curAlpha,
                    x:_s.imageFinalX, 
                    y:_s.imageFinalY, 
                    ease:Expo.easeInOut});
                
            }else{
                FWDAnimation.to(_s.normalImage_do, .8, {
                    alpha:1,
                    x:_s.imageFinalX, 
                    y:_s.imageFinalY, 
                    ease:Expo.easeInOut});
            }
            
            _s.imageHolder_do.addChild(_s.normalImage_do);
            _s.hasImage_bl = true;
        };
        

        //#################################//
        /* resize thumbnail*/
        //#################################//
        _s.resizeAndPosition = function(animate){
            if(_s.showThumbnail_bl){
                _s.txt.setWidth(_s.finalW - ((_s.padding * 2) + _s.thumbImageWidth) - 16);
            }else{
                _s.txt.setWidth(_s.finalW - ((_s.padding * 2)) - 16);
            }
            _s.setWidth(_s.finalW);
            _s.setHeight(_s.finalH);
            
            if(animate){
                FWDAnimation.to(_s, .6, {x:_s.finalX, y:_s.finalY, ease:Expo.easeInOut});
            }else{
                FWDAnimation.killTweensOf(_s);
                _s.setX(_s.finalX);
                _s.setY(_s.finalY);
            }
            
            _s.resizeImage();
        };
    

        //#################################//
        /* resize image*/
        //#################################//
        _s.resizeImage = function(animate){
            if(prt.showOnlyThmb){
                _s.mainImgHld.setWidth(_s.thumbImageWidth);
                _s.mainImgHld.setHeight(_s.thumbImageHeight);
                _s.imageHolder_do.setWidth(_s.thumbImageWidth);
                _s.imageHolder_do.setHeight(_s.thumbImageHeight);
            }

            if(!_s.normalImage_do) return;
            
            if(_s.isMbl){   
                if(_s.normalImage_do.alpha != 1 && !_s.isDisabled_bl) _s.normalImage_do.setAlpha(1);
            }else{
                if(_s.imageHolder_do.alpha != 1 && !_s.isDisabled_bl) _s.imageHolder_do.setAlpha(1);
            }

            var scX = _s.thumbImageWidth/_s.imageOriginalW;
            var scY = _s.thumbImageHeight/_s.imageOriginalH;
            var ttsc;
            
            if(scX >= scY){
                ttsc = scX;
            }else{
                ttsc = scY;
            }
            
            _s.imageFinalW = Math.ceil(ttsc * _s.imageOriginalW);
            _s.imageFinalH = Math.ceil(ttsc * _s.imageOriginalH);
            _s.imageFinalX = Math.round((_s.thumbImageWidth - _s.imageFinalW)/2);
            _s.imageFinalY = Math.round((_s.thumbImageHeight - _s.imageFinalH)/2);
        
            _s.normalImage_do.setX(_s.imageFinalX);
            _s.normalImage_do.setY(_s.imageFinalY);
            _s.normalImage_do.setWidth(_s.imageFinalW);
            _s.normalImage_do.setHeight(_s.imageFinalH);
        };
        

        //#######################################//
        /* Set selected/normal/disable states */
        //######################################//
        _s.setNormalState = function(animate){
            if(_s.curStt == "normal") return;
            _s.curStt = "normal";

            if(_s.slTitle){
                _s.txt.screen.className = _s.slTitle;
            }

            if(animate){
                FWDAnimation.to(_s.screen, .8, {css:{backgroundColor:_s.thumbnailNormalBackgroundColor_str},ease:Expo.easeOut});
            }else{
                FWDAnimation.killTweensOf(_s.screen);
                _s.getStyle().backgroundColor = _s.thumbnailNormalBackgroundColor_str;
            }
        };
        
        _s.setSelectedState = function(animate){
            if(_s.curStt == "selected") return;
            _s.curStt = "selected";
        
            _s.setTitleSelectedClass();
            if(animate){
                FWDAnimation.to(_s.screen, .8, {css:{backgroundColor:_s.thumbnailHoverBackgroundColor_str},ease:Expo.easeOut});
            }else{
                FWDAnimation.killTweensOf(_s.screen);
                _s.getStyle().backgroundColor = _s.thumbnailNormalBackgroundColor_str;
            }
        };
        
        _s.setDisabledState = function(animate){
            if(_s.curStt == "disabled") return;
            _s.curStt = "disabled";

            _s.setTitleSelectedClass();
            if(animate){
                FWDAnimation.to(_s.screen, .8, {css:{backgroundColor:_s.thumbnailDisabledBackgroundColor_str},ease:Expo.easeOut});
            }else{
                FWDAnimation.killTweensOf(_s.screen);
                _s.getStyle().backgroundColor = _s.thumbnailNormalBackgroundColor_str;
            }
        };

        _s.setTitleSelectedClass = function(){
            if(_s.slTitle){
                _s.txt.screen.className = _s.slTitle  + ' active';
            }
        }
        

        //###############################//
        /* enable / disable */
        //##############################//
        _s.enable = function(){
            if(!_s.isDisabled_bl) return;
            _s.isDisabled_bl = false;
            _s.setButtonMode(true);
            _s.setNormalState(true);
            
            if(_s.isMbl){
                if(_s.normalImage_do) _s.normalImage_do.setAlpha(1);
            }else{
                FWDAnimation.to(_s.imageHolder_do, .6, {alpha:1});
            }
        };
        
        _s.disable = function(){
            if(_s.isDisabled_bl) return;
            _s.disableForAWhile_bl = true;
            clearTimeout(_s.disableForAWhileId_to);
            _s.disableForAWhileId_to = setTimeout(function(){
                _s.disableForAWhile_bl = false;
            }, 200);
            _s.isDisabled_bl = true;
            _s.setButtonMode(false);
            _s.setDisabledState(true);
            
            if(_s.isMbl){
                if(_s.normalImage_do) _s.normalImage_do.setAlpha(.3);
            }else{
                FWDAnimation.to(_s.imageHolder_do, .6, {alpha:.3});
            }
        };

        
        //################################//
        /* Destroy */
        //################################//
        _s.destroy = function(){
            FWDAnimation.killTweensOf(_s);
            if(_s.normalImage_do){
                FWDAnimation.killTweensOf(_s.normalImage_do);
                _s.normalImage_do.destroy();
            }
            
            FWDAnimation.killTweensOf(_s.imageHolder_do);
            _s.imageHolder_do.destroy();
            _s.dumy_do.destroy();
            _s.txt.destroy();
            _s.backgroundImagePath_str = backgroundImagePath;
            _s.imageHolder_do = null;
            _s.normalImage_do = null;
            _s.dumy_do = null;
            _s.txt = null;
            _s.htmlContent_str = null;
            _s.htmlText_str = null;
            _s.curStt = null;
        };
    
        _s.init();
    };
    
    
    /* set prototype */
    FWDUVPPlaylistThumb.setPrototype = function(){
        FWDUVPPlaylistThumb.prototype = new FWDUVPDisplayObject("div");
    };
    
    FWDUVPPlaylistThumb.SHOW_TOOL_TIP = "showToolTip";
    FWDUVPPlaylistThumb.HIDE_TOOL_TIP = "hideToolTip";
    FWDUVPPlaylistThumb.MOUSE_UP = "onMouseUp";
    
    FWDUVPPlaylistThumb.prototype = null;
    window.FWDUVPPlaylistThumb = FWDUVPPlaylistThumb;
}(window));/**
 * Ultimate Video Player PACKAGED v9.1
 * Advertisement popup button.
 *
 * @author Tibi - FWDesign [https://webdesign-flash.ro/]
 * Copyright © 2006 All Rights Reserved.
 */
(function (){
var FWDUVPPopupAddButton = function(
            prt,
            imgSrc,
            start,
            end,
            link,
            target,
            isClsd,
            id,
            google_ad_client,
            google_ad_slot,
            google_ad_width,
            google_ad_height,
            tracking,
            poppAdClsNPth,
            poppAdClsSPth,
            shwPpoppAdClsBtn,
            useHEX,
            nBC,
            sBC
        ){

        'use strict';
            
        var _s = this;
        var prototype = FWDUVPPopupAddButton.prototype;
        
        _s.clsBtn;
        _s.image_do;
        _s.imgSrc = imgSrc;
        _s.link = link;
        _s.target = target;
        _s.start = start;
        _s.end = end;
        _s.google_ad_client = google_ad_client;
        _s.google_ad_slot = google_ad_slot
        _s.originalW = _s.google_ad_width = google_ad_width;
        _s.originalH = _s.google_ad_height = google_ad_height;
        _s.tracking = tracking;
        
        _s.finalW = 0;
        _s.finalH = 0;
        
        if(Boolean(_s.google_ad_client)){
            _s.type = 'adsense';
        }else if(_s.imgSrc.match(/.png|.jpg|.jpeg/ig)){
            _s.type = 'image';
        }else{
            _s.type = 'iframe';
        }
    
        _s.id = id;
        
        _s.shwPpoppAdClsBtn = shwPpoppAdClsBtn;
        _s.poppAdClsNPth = poppAdClsNPth;
        _s.poppAdClsSPth = poppAdClsSPth;
        
        _s.isClsd = isClsd;
        _s.isLded = false;
        _s.isShowed_bl = false;

        

        //##########################################//
        /* initialize  */
        //##########################################//
        _s.init = function(){
            _s.setBkColor("rgba(0, 0, 0, 0.6)");
            _s.setX(-5000);

            var pth = _s.poppAdClsNPth;
            if(window['isWhite']){
                pth = 'content/hex_white/close-button-normal.png';
            }

            if(_s.shwPpoppAdClsBtn){
                FWDUVPSimpleSizeButton.setPrototype();
                _s.clsBtn = new FWDUVPSimpleSizeButton(
                        pth, 
                        _s.poppAdClsSPth,
                        22,
                        21,
                        useHEX,
                        nBC,
                        sBC,
                        true
                        );

                _s.clsBtn.addListener(FWDUVPSimpleSizeButton.MOUSE_UP, _s.closeClickButtonCloseHandler);
            }
            
            if(_s.type == 'image'){
                _s.image = new Image();
                _s.image.src = _s.imgSrc;
                _s.image.onload = _s.onLoadHandler;
            }else{
                _s.isLded = true;
                _s.setWidth(_s.originalW);
                _s.setHeight(_s.originalH);
            }
            
            if(_s.clsBtn){
                _s.addChild(_s.clsBtn);
                _s.clsBtn.setX(-300);
            }
            
            if(_s.link){
                _s.setButtonMode(true);
            }
        };
        
        _s.closeClickButtonCloseHandler = function(){
            _s.hide();
            _s.isClsd = true;
            prt.popupAds_ar[_s.id].isClosed = true;
        };
        
        _s.clickHandler = function(){
            if(_s.link){
                prt.prt.pause();
                window.open(_s.link, _s.target);
            }
        };

        
        //##########################################//
        /* setup main containers */
        //##########################################//
        _s.onLoadHandler = function(){
            _s.originalW = _s.image.width;
            _s.originalH = _s.image.height;
            _s.image_do = new FWDUVPDisplayObject("img");
            _s.image_do.setScreen(_s.image);
            _s.image_do.setWidth(_s.originalW);
            _s.image_do.setHeight(_s.originalH);
            _s.addChild(_s.image_do);
            _s.isLded = true;
            if(_s.clsBtn){
                _s.addChild(_s.clsBtn);
                _s.clsBtn.setX(-300);
            }
            if(_s.screen.addEventListener){
                _s.image_do.screen.addEventListener("click", _s.clickHandler);
            }else{
                _s.image_do.screen.attachEvent("onclick", _s.clickHandler);
            }
        };
        
        _s.hide = function(remove){
            if(!_s.isShowed_bl) return;
            _s.isShowed_bl = false;
            var scale = Math.min(1, prt.prt.tempVidStageWidth/(_s.originalW));          
            var finalH = parseInt(scale * _s.originalH);
            var finalY = parseInt(prt.prt.tempVidStageHeight);
            prt.setY(finalY);
            
            _s.setX(-5000);
            FWDAnimation.killTweensOf(prt);
            if(remove){
                prt.removeChild(_s);
                prt.setWidth(0);
                prt.setHeight(0);
            }else{
                _s.setWidth(0);
                _s.setHeight(0);
                prt.setVisible(false);
                _s.setVisible(false);
            }
        };
        
        _s.show = function(){
            
            if(_s.isShowed_bl || _s.isClsd || !_s.isLded) return;   
            _s.isShowed_bl = true;
            
            _s.setX(0);
            setTimeout(function(){
                FWDAnimation.killTweensOf(prt);
                prt.setVisible(true);
                _s.setVisible(true);

                if(_s.type == 'adsense' && !_s.isGooglAdCreated_bl){
                    
                    _s.isGooglAdCreated_bl = true;
                    
                    window.google_ad_client = _s.google_ad_client;
                    window.google_ad_slot = _s.google_ad_slot;
                    window.google_ad_width = _s.originalW;
                    window.google_ad_height = _s.originalH;
                    
                    // container is where you want the ad to be inserted
                    _s.container = new FWDUVPTransformDisplayObject("div");
                    _s.container.setWidth(_s.originalW);
                    _s.container.setHeight(_s.originalH);
                    
                    _s.addChild(_s.container);
                
                    var w = document.write;
                    document.write = function (content) {
                        _s.container.screen.innerHTML = content;
                        document.write = w;
                    };

                    var script = document.createElement('script');
                    script.type = 'text/javascript';
                    if(location.href.indexOf("https") != -1){
                        script.src = 'https://pagead2.googlesyndication.com/pagead/show_ads.js';
                    }else{
                        script.src = 'http://pagead2.googlesyndication.com/pagead/show_ads.js';
                    }
                    
                    document.body.appendChild(script);
                    if(_s.clsBtn){
                        _s.addChild(_s.clsBtn);
                        _s.clsBtn.setX(-300);
                    }
                }else if(_s.type == 'iframe'){

             